/*
 * Decompiled with CFR 0.152.
 */
public class GameFieldItem {
    private static int FULL_INT = -1;
    public static int MATRIX_IMAGE_BRICK_COUNT = 0;
    public static boolean blink1IsVisible = false;
    public static boolean blink2isVisible = false;
    public static int TRAIN_LENGTH = 3;
    public static int TRAIN_DURATION = 0;
    public static boolean TAIN_HIGHLIGHT_1_TARIN = true;
    private int _data = 0;
    private boolean _isRendered = false;
    public static final int FLAG_SHIFT_VISIBLE = 0;
    public static final int FLAG_SHIFT_BLINK = 1;
    public static final int FLAG_SHIFT_HOT = 2;
    public static final int FLAG_SHIFT_FILLING_FULL = 3;
    public static final int FLAG_SHIFT_FILLING_HEAD = 4;
    public static final int FLAG_SHIFT_RAIN_POINT = 5;
    private static final int MATRIX_BRICK_NORMAL = 0;
    private static final int MATRIX_BRICK_BRIGHT = 1;
    private static final int MATRIX_BRICK_TRAIN = 2;
    public static final int MATRIX_BRICK_BG = 3;
    private static final int MATRIX_BRICK_TYPE_SHIFT = 6;
    private static final int MATRIX_BRICK_TYPE_MASK = 3;
    private static final int MATRIX_BRICK_INDEX_SHIFT = 8;
    private static final int MATRIX_BRICK_INDEX_MASK = 31;
    public static final int MATRIX_BRICK_NEW_INDEX = -1;
    public static final int MATRIX_BRICK_OLD_INDEX = 30;
    public static final int BRICK_UNDEFINED = 0;
    public static final int BRICK_FIELD = 1;
    public static final int BRICK_FIGURE = 2;
    public static final int BRICK_ENEMY = 3;
    public static final int BRICK_BULLET = 4;
    public static final int BRICK_ENEMY_BULLET = 5;
    private static final int BRICK_TRAIN = 6;
    private static final int BRICK_TRAIN_SPIRIT = 7;
    private static final int BRICK_SHIFT = 13;
    private static final int BRICK_MASK = 7;
    private static final int BRICK_HOT_FLAG_SHIFT = 17;
    private static final int BRICK_ONCE_HOT_FLAG_SHIFT = 18;
    private static final int LIFE_COUNTER_SHIFT = 19;
    private static final int LIFE_COUNTER_MASK = 31;

    GameFieldItem() {
        this._data = 0;
        this._isRendered = false;
    }

    GameFieldItem(int data) {
        this._data = data;
        this._isRendered = false;
        this.updateState();
    }

    private boolean getFlagWithShift(int flagShift) {
        return (this._data & 1 << flagShift) != 0;
    }

    private void setFlagWithShift(boolean state, int flagShift) {
        this._data = state ? this._data | 1 << flagShift : this._data & (1 << flagShift ^ FULL_INT);
    }

    public boolean isVisible() {
        return this.getFlagWithShift(0);
    }

    private void setIsVisible(boolean state) {
        this.setFlagWithShift(state, 0);
    }

    public boolean isBlinking() {
        return this.getFlagWithShift(1);
    }

    public void setIsBlinking(boolean state) {
        this.setFlagWithShift(state, 1);
    }

    private boolean isHot() {
        return this.getFlagWithShift(2);
    }

    private void setIsHot(boolean state) {
        this.setFlagWithShift(state, 2);
    }

    public boolean isFillingFull() {
        return this.getFlagWithShift(3);
    }

    public void setIsFillingFull(boolean state) {
        this.setFlagWithShift(state, 3);
    }

    public boolean isFillingHead() {
        return this.getFlagWithShift(4);
    }

    public void setIsFillingHed(boolean state) {
        this.setFlagWithShift(state, 4);
    }

    public boolean isRainPoint() {
        return this.getFlagWithShift(5);
    }

    public void setIsRainPoint(boolean state) {
        this.setFlagWithShift(state, 5);
    }

    public int matrixBrickType() {
        return this._data >> 6 & 3;
    }

    public void setMatrixBrickTypeMask(int newValue) {
        this._data = this._data & (0xC0 ^ FULL_INT) | (newValue & 3) << 6;
    }

    public int matrixBrickIdex() {
        return (this._data >> 8 & 0x1F) - 1;
    }

    public void setMatrixBrickIndex(int newValue) {
        this._data = this._data & (0x1F00 ^ FULL_INT) | (newValue + 1 & 0x1F) << 8;
    }

    public boolean matrixBrickIndexIsSet() {
        return this.matrixBrickIdex() == -1;
    }

    public void invalidateMatrixBrickIndex() {
        this.setMatrixBrickIndex(-1);
    }

    public int brickType() {
        return this._data >> 13 & 7;
    }

    public void setBrickType(int newValue) {
        this._data = this._data & (0xE000 ^ FULL_INT) | (newValue & 7) << 13;
    }

    public boolean isHotBrick() {
        return this.getFlagWithShift(17);
    }

    public void setIsHotBrick(boolean state) {
        this.setFlagWithShift(state, 17);
    }

    public boolean isHotOnceBrick() {
        return this.getFlagWithShift(18);
    }

    public void setIsHotOnceBrick(boolean state) {
        this.setFlagWithShift(state, 18);
    }

    public int getLifeCounter() {
        return this._data >> 19 & 0x1F;
    }

    public void setLifeCounter(int newValue) {
        this._data = this._data & (0xF80000 ^ FULL_INT) | (newValue & 0x1F) << 19;
    }

    public final int data() {
        return this._data;
    }

    public final void setData(int newData) {
        this._data = newData;
    }

    public final void composeData(int newData) {
        int mbIndex = this.matrixBrickIdex();
        this._data = newData;
        if (this.matrixBrickIdex() == 30) {
            this.setMatrixBrickIndex(mbIndex);
        }
        this.updateState();
    }

    public final boolean isRendered() {
        return this._isRendered;
    }

    public final void setIsRendred(boolean state) {
        this._isRendered = state;
    }

    public final void clear() {
        this._data = 0;
        this._isRendered = false;
    }

    public final void updateState() {
        if (this.isHotOnceBrick()) {
            this.setIsHotBrick(true);
        }
        switch (this.brickType()) {
            case 0: {
                if (E.MATRIX_SKIN_RENDERING_ON) {
                    if (this.isHot() && TRAIN_LENGTH > 0) {
                        this.setIsHotBrick(false);
                        this.setBrickType(6);
                        this.setLifeCounter(TRAIN_LENGTH);
                    } else if (this.isFillingHead() && !this.isFillingFull() && TRAIN_LENGTH > 0) {
                        this.setIsFillingHed(false);
                        this.setBrickType(6);
                        this.setLifeCounter(TRAIN_LENGTH);
                    }
                    if (!this.isHot()) break;
                    this.setIsHotBrick(false);
                    break;
                }
                if (this.isHot() && TRAIN_LENGTH > 0) {
                    this.setIsHotBrick(false);
                }
                if (!this.isBlinking()) break;
                this.setIsBlinking(false);
                break;
            }
            case 6: {
                if (this.getLifeCounter() == 0) {
                    if (TRAIN_DURATION > 0) {
                        this.setBrickType(7);
                        this.setLifeCounter(TRAIN_DURATION);
                        break;
                    }
                    this.setBrickType(0);
                    break;
                }
                this.setLifeCounter(this.getLifeCounter() - 1);
                break;
            }
            case 7: {
                if (this.getLifeCounter() == 0) {
                    this.setBrickType(0);
                    break;
                }
                this.setLifeCounter(this.getLifeCounter() - 1);
                break;
            }
            case 4: {
                this.setIsHotBrick(true);
                break;
            }
            case 5: {
                this.setIsHotBrick(false);
                this.setIsHotOnceBrick(false);
            }
        }
        if (E.MATRIX_SKIN_RENDERING_ON) {
            this.setIsVisible(this.brickType() != 0 || this.isFillingFull());
        } else if (!(this.brickType() != 0 && this.brickType() != 6 && this.brickType() != 7 || this.isFillingFull())) {
            this.setIsVisible(false);
        } else {
            this.setIsVisible(true);
        }
        if (E.MATRIX_SKIN_RENDERING_ON) {
            if (this.isRainPoint() && this.brickType() != 0) {
                this.setIsRainPoint(false);
            }
            if (this.isRainPoint()) {
                this.setIsVisible(true);
            }
        }
        if (!E.MATRIX_SKIN_RENDERING_ON && this.isBlinking() && this.isVisible() && !this.isFillingFull()) {
            if (this.isHotBrick()) {
                this.setIsVisible(blink1IsVisible);
            } else {
                this.setIsVisible(blink2isVisible);
            }
        }
        this.setIsHot(this.isHotBrick() || this.isFillingHead() && this.isFillingFull());
        if (this.isHot() && (!this.isFillingFull() || this.isFillingHead())) {
            this.setMatrixBrickIndex(-1);
        }
        if (E.MATRIX_SKIN_RENDERING_ON && this.isVisible()) {
            if (this.matrixBrickIdex() == -1) {
                this.setMatrixBrickIndex(GUtillMath.rnd(MATRIX_IMAGE_BRICK_COUNT));
            }
            if (this.isHot() && (!this.isFillingFull() || this.isFillingHead())) {
                this.setMatrixBrickTypeMask(1);
            } else if (this.isFillingFull()) {
                this.setMatrixBrickTypeMask(0);
            } else if (!(this.brickType() != 6 && this.brickType() != 7 || this.brickType() == 6 && this.getLifeCounter() == TRAIN_LENGTH && TAIN_HIGHLIGHT_1_TARIN)) {
                this.setMatrixBrickTypeMask(2);
            } else if (this.isRainPoint()) {
                this.setMatrixBrickTypeMask(3);
            } else {
                this.setMatrixBrickTypeMask(0);
            }
        }
        if (this.isHotOnceBrick()) {
            if (this.getLifeCounter() != 0) {
                this.setLifeCounter(this.getLifeCounter() - 1);
            } else {
                this.setIsHotBrick(false);
                this.setIsHotOnceBrick(false);
            }
        }
        if (this.isFillingHead()) {
            this.setIsHot(false);
        }
    }

    public static final int playerBrickData() {
        GameFieldItem tempItem = new GameFieldItem();
        tempItem.setBrickType(2);
        tempItem.updateState();
        return tempItem.data();
    }

    public static final int fieldBrickData() {
        GameFieldItem tempItem = new GameFieldItem();
        tempItem.setBrickType(1);
        tempItem.updateState();
        return tempItem.data();
    }
}

