/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicBarrierRacing
extends GameLogicRacing {
    private byte bBarrierCount = 0;
    private byte bBarrierPos;
    private byte bBarrierDir;
    private boolean bStepLeft = false;
    private boolean bStepRight = false;

    protected void placePlayer() {
        super.placePlayer();
        this.bBarrierCount = 0;
        this.bBarrierPos = (byte)-1;
        this.bCarPos = (byte)GUtillMath.rnd(6);
        this.updateFigure();
    }

    protected void placeBarrier() {
        int i = this.bBarrierPos - this.bBarrierPos % 10 + 1;
        while (i % 10 != 9) {
            if (i != this.bBarrierPos && i != this.bBarrierPos - 1 && i != this.bBarrierPos + 1) {
                GameField.setBrickType(i, 3);
            } else {
                GameField.setBrickType(i, 0);
            }
            ++i;
        }
    }

    protected void cycleBarrier() {
        if (this.bBarrierDir == 0) {
            if (this.bBarrierPos % 10 > 2) {
                this.bBarrierPos = (byte)(this.bBarrierPos - 1);
                this.placeBarrier();
            } else {
                this.bBarrierDir = 1;
                this.bBarrierPos = (byte)(this.bBarrierPos + 1);
                this.placeBarrier();
            }
        } else if (this.bBarrierPos % 10 < 7) {
            this.bBarrierPos = (byte)(this.bBarrierPos + 1);
            this.placeBarrier();
        } else {
            this.bBarrierDir = 0;
            this.bBarrierPos = (byte)(this.bBarrierPos - 1);
            this.placeBarrier();
        }
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            this.active = true;
        } else if (this.active && this.bShowCollision == 0) {
            if (key == 6) {
                this.bStepLeft = true;
            } else if (key == 8) {
                this.bStepRight = true;
            }
        }
    }

    public boolean updateEvent() {
        if (this.active && this.bShowCollision == 0) {
            if (this.bStepLeft) {
                if (this.bCarPos > 0) {
                    this.bCarPos = (byte)(this.bCarPos - 1);
                    this.updateFigure();
                }
                this.bStepLeft = false;
            } else if (this.bStepRight) {
                if (this.bCarPos < 5) {
                    this.bCarPos = (byte)(this.bCarPos + 1);
                    this.updateFigure();
                }
                this.bStepRight = false;
            }
            if (E.kStates[7] || E.kStates[4]) {
                this.figureIsHot = true;
                this.updateState();
            } else {
                this.figureIsHot = false;
            }
            if (this.figureIsHot != this.lastFigureHotState) {
                this.updateFigure();
            }
            if (this.checkCollision()) {
                this.CurrentScore = 0;
                this.showCollision();
            }
        }
        return false;
    }

    public void updateLevel(int level) {
        super.updateLevel(level);
        this.bBarrierCount = 0;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = 199; i >= 0; --i) {
                    if (GameField.getBrickType(i) != 3 && GameField.getBrickType(i) != 1 && GameField.getBrickType(i) != 2) continue;
                    GameField.getItem(i + 10).setData(GameField.getItem(i).data());
                    GameField.setBrickType(i, 0);
                    GameField.getItem(i).setMatrixBrickIndex(-1);
                }
                if (this.bBarrierPos != -1) {
                    this.bBarrierPos = (byte)(this.bBarrierPos + 10);
                }
                if (this.bSideWall != 3) {
                    GameField.getItem(0).setData(GameFieldItem.fieldBrickData());
                    GameField.getItem(9).setData(GameFieldItem.fieldBrickData());
                    this.bSideWall = (byte)(this.bSideWall + 1);
                } else {
                    this.bSideWall = 1;
                }
                if (this.bCurUpdate < 11) {
                    if (this.bCurUpdate == 1) {
                        this.bBarrierCount = (byte)(this.bBarrierCount < 2 ? (int)(this.bBarrierCount + 1) : 2);
                        if (E.cheatsOn) {
                            this.bBarrierPos = (byte)2;
                            this.bBarrierDir = 0;
                        } else {
                            this.bBarrierPos = (byte)GUtillMath.rnd_to(2, 8);
                            this.bBarrierDir = (byte)GUtillMath.rnd(2);
                        }
                        this.placeBarrier();
                    }
                    this.bCurUpdate = (byte)(this.bCurUpdate + 1);
                } else if (this.bCurUpdate == 11) {
                    this.bCurUpdate = 1;
                }
                if (this.bCurUpdate == 9 && this.bBarrierCount == 2) {
                    this.score += 10;
                    this.CurrentScore += 10;
                }
                if (this.checkCollision()) {
                    this.CurrentScore = 0;
                    this.showCollision();
                }
                if (this.CurrentScore == 500) {
                    this.score += 200;
                    this.CurrentScore = 0;
                    this.gameup = true;
                    this.placePlayer();
                }
            }
        }
    }

    protected boolean checkCollision() {
        for (int i = 0; i < 7; ++i) {
            if (GameField.getBrickType(CAR_FIGURE[i] + this.bCarPos) != 3) continue;
            return true;
        }
        return false;
    }
}

