/*
 * Decompiled with CFR 0.152.
 */
package com.spl;

import com.nokia.mid.ui.FullCanvas;
import com.spl.Selector;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SelectorCanvas
extends FullCanvas {
    private final int LEFT_SK;
    private final int RIGHT_SK;
    private final int KEY_RIGHT;
    private final int KEY_LEFT;
    private final int KEY_UP;
    private final int KEY_DOWN;
    private final int KEY_SELECT;
    private int IMAGE_Y_POS = 10;
    private int IMAGE_Y_GAP = 5;
    private int BOTTOM_BAR_HEIGHT = 28;
    private int scrWidth = 240;
    private int scrHeight = 320;
    private int exitLeftPos;
    private int exitUpperPos;
    private int okLeftPos;
    private int okUpperPos;
    private int menuLength;
    private boolean waitScreen = false;
    private Image[] menuImages;
    private Image exitImage;
    private Image fonImage;
    private Image okImage;

    public SelectorCanvas() {
        this.LEFT_SK = -6;
        this.RIGHT_SK = -7;
        this.KEY_RIGHT = -4;
        this.KEY_LEFT = -3;
        this.KEY_UP = -1;
        this.KEY_DOWN = -2;
        this.KEY_SELECT = -5;
    }

    public void setScrWidth(int n) {
        this.scrWidth = n;
    }

    public void setScrHeight(int n) {
        this.scrHeight = n;
    }

    public void setWaitScreen(boolean bl) {
        this.waitScreen = bl;
    }

    public void initSelectionMenu(Image[] imageArray) {
        this.menuImages = imageArray;
        this.menuLength = imageArray.length;
        try {
            this.exitImage = Image.createImage((String)"/exit.png");
            this.fonImage = Image.createImage((String)"/fon.png");
            this.okImage = Image.createImage((String)"/ok.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = this.scrHeight - this.fonImage.getHeight();
        for (int i = 0; i < this.menuLength; ++i) {
            n -= this.menuImages[i].getHeight();
        }
        this.IMAGE_Y_POS = this.IMAGE_Y_GAP = n / (this.menuLength + 1);
        this.BOTTOM_BAR_HEIGHT = this.fonImage.getHeight();
        this.okLeftPos = (this.scrWidth - this.menuImages[0].getWidth()) / 2;
        this.okUpperPos = this.scrHeight - this.BOTTOM_BAR_HEIGHT + (this.BOTTOM_BAR_HEIGHT - this.exitImage.getHeight()) / 2;
        this.exitLeftPos = (this.scrWidth - this.menuImages[0].getWidth()) / 2 + this.menuImages[0].getWidth();
        this.exitUpperPos = this.scrHeight - this.BOTTOM_BAR_HEIGHT + (this.BOTTOM_BAR_HEIGHT - this.exitImage.getHeight()) / 2;
    }

    private void drawSelectionMenu(Graphics graphics, int n) {
        for (int i = 0; i < this.menuLength; ++i) {
            int n2 = this.menuImages[i].getHeight();
            int n3 = this.menuImages[i].getWidth();
            int n4 = (this.scrWidth - n3) / 2;
            graphics.drawImage(this.menuImages[i], n4, n, 20);
            if (Selector.selectedMIDlet == i) {
                graphics.setColor(255, 255, 255);
                graphics.drawRect(n4 - 3, n - 3, n3 + 5, n2 + 5);
                graphics.drawRect(n4 - 2, n - 2, n3 + 3, n2 + 3);
                graphics.drawRect(n4 - 1, n - 1, n3 + 1, n2 + 1);
            }
            n += n2 + this.IMAGE_Y_GAP;
        }
    }

    public static int getImagesTotalWidth(Image[] imageArray) {
        if (imageArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < imageArray.length; ++i) {
            n += imageArray[i].getWidth();
        }
        return n;
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, this.scrWidth, this.scrHeight);
        if (this.waitScreen) {
            graphics.setColor(16, 16, 16);
            graphics.fillRect(0, 0, this.scrWidth, this.scrHeight);
            graphics.setColor(0);
            graphics.drawString("Please wait...", this.scrWidth / 2 + 2, this.scrHeight / 2 + 2, 65);
            graphics.setColor(255, 255, 255);
            graphics.drawString("Please wait...", this.scrWidth / 2, this.scrHeight / 2, 65);
        } else {
            graphics.setColor(107, 172, 192);
            graphics.fillRect(0, 0, this.scrWidth, this.scrHeight);
            graphics.drawImage(this.fonImage, 0, this.scrHeight, 36);
            graphics.drawImage(this.exitImage, this.exitLeftPos, this.exitUpperPos, 24);
            graphics.drawImage(this.okImage, this.okLeftPos, this.okUpperPos, 20);
            this.drawSelectionMenu(graphics, this.IMAGE_Y_POS);
        }
    }

    protected void keyPressed(int n) {
        if (this.waitScreen) {
            return;
        }
        switch (n) {
            case -6: {
                this.runGame();
                break;
            }
            case -7: {
                Selector.midlet.notifyDestroyed();
                break;
            }
            case -2: 
            case 56: {
                if (++Selector.selectedMIDlet <= this.menuLength - 1) break;
                Selector.selectedMIDlet = 0;
                break;
            }
            case -1: 
            case 50: {
                if (--Selector.selectedMIDlet >= 0) break;
                Selector.selectedMIDlet = this.menuLength - 1;
                break;
            }
            case -5: 
            case 53: {
                this.runGame();
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    private void runGame() {
        if (Selector.selectedMIDlet < this.menuLength) {
            for (int i = 0; i < this.menuLength; ++i) {
                this.menuImages[i] = null;
            }
            this.exitImage = null;
            this.okImage = null;
            this.fonImage = null;
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.waitScreen = true;
            this.repaint();
            this.serviceRepaints();
            if (!Selector.gameStarted) {
                new Thread(Selector.midlet).start();
            }
        }
    }
}

