/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class Sudoku {
    public int[][] m_iGrid;
    public int[][] m_GridFlag;
    public int[][] m_GridFlag2;
    public int[][] m_BlinkFlag;
    public int[][] m_flagMustBeFill;
    public short[][][] m_draft;
    public int[][] m_vsFlag;
    static final int kvs1p = 1;
    static final int kvs2p = 2;
    Random m_random;
    public static int[] m_isRepeatedGrid = new int[]{0, 0, 0};
    public int m_iGridId = 0;
    public int[][] m_iSolution;
    public int m_iSolCount = 0;
    public short[][] m_iCurrentGrid;
    public int m_iErrors = 0;
    public int m_iBlank;
    static final int k_iSize = 9;
    static final byte k_bGroupW = 3;
    static final byte k_bGroupH = 3;
    static final byte k_bGroupCountW = 3;
    static final byte k_bGroupCountH = 3;
    short[] repeatRow;
    short[] repeatColumn;
    short[] repeatGrid;
    static boolean bNeedBlink;
    static boolean bNeedAlpha;
    int iNullCell = 81;
    static int nMustbeFill;
    static int nMustBeFillError;
    static int nPlayerFilled;
    static int nCellNeedFill;
    static int[][] v1;
    static int[][] v2;
    static int[][] v3;
    static final int k_iChangeCount = 6;
    boolean hasAlphaEffect;
    int m_solve_i;
    int m_solve_j;
    int iError = 0;
    static final int kFillNone = 0;
    static final int kFillGreen = 1;
    static final int kFillRed = 2;
    static final int kFillBlack = 3;
    static final int kFillDraft = 4;
    byte m_bEasier = (byte)-1;
    byte m_bShort;
    protected int m_iDequeRemovals;
    private Header root = new Header();
    private Vector columns = new Vector();
    private Vector rows = new Vector();
    private Vector solStack = new Vector();
    private int stackPos;
    private int iterStack;
    private Node iterRow;
    private Node iterCol;
    private Header column;
    private Node row;
    private boolean more;
    int m_iSolveStep = 0;
    int timer = 0;

    public Sudoku() {
        nPlayerFilled = 0;
        nCellNeedFill = 0;
        this.m_draft = new short[9][9][4];
        this.m_BlinkFlag = new int[9][9];
        this.m_iGrid = new int[9][9];
        this.m_GridFlag = new int[9][9];
        this.m_vsFlag = new int[9][9];
        this.m_flagMustBeFill = new int[9][9];
        this.m_GridFlag2 = new int[9][9];
        this.m_iSolution = new int[9][9];
        this.m_iCurrentGrid = new short[9][9];
        Sudoku.m_isRepeatedGrid[2] = 0;
        Sudoku.m_isRepeatedGrid[1] = 0;
        Sudoku.m_isRepeatedGrid[0] = 0;
        this.m_random = new Random();
    }

    void setCellMustBeFill(int n, int n2) {
        this.m_flagMustBeFill[n][n2] = 1;
    }

    void removeCellMustBeFill(int n, int n2) {
        this.m_flagMustBeFill[n][n2] = 0;
    }

    void setRedCellMustBeFill(int n, int n2) {
        this.m_flagMustBeFill[n][n2] = 2;
    }

    void SetVsFlag() {
        if (cGame.Is1PTurn()) {
            this.m_vsFlag[cGame.m_select_i][cGame.m_select_j] = 1;
            ++nPlayerFilled;
        } else {
            this.m_vsFlag[cGame.m_select_i][cGame.m_select_j] = 2;
            --nPlayerFilled;
        }
    }

    boolean is1PCell(int n, int n2) {
        return this.m_vsFlag[n][n2] == 1;
    }

    boolean is2PCell(int n, int n2) {
        return this.m_vsFlag[n][n2] == 2;
    }

    boolean ContestFinish() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!this.isCellMustBeFill(i, j) || this.isRightCell(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    boolean isRightCell(int n, int n2) {
        return this.m_iCurrentGrid[n][n2] == this.m_iSolution[n][n2];
    }

    boolean isCellFilled(int n, int n2) {
        return this.m_iCurrentGrid[n][n2] != 0;
    }

    boolean isRightCell(int n, int n2, int n3) {
        return n3 == this.m_iSolution[n][n2];
    }

    int getRightCell(int n, int n2) {
        return this.m_iSolution[n][n2];
    }

    boolean isCellMustBeFill(int n, int n2) {
        return this.m_flagMustBeFill[n][n2] == 1;
    }

    boolean isRedCellMustBeFill(int n, int n2) {
        return this.m_flagMustBeFill[n][n2] == 2;
    }

    void setBlinkCfg(boolean bl) {
        bNeedBlink = bl;
    }

    void setAlphaCfg(boolean bl) {
        bNeedAlpha = bl;
    }

    void readMatrix(byte[] byArray) {
        int n;
        int n2;
        int n3 = 81;
        v1 = new int[9][9];
        v2 = new int[9][9];
        v3 = null;
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n < 9; ++n) {
                Sudoku.v1[n2][n] = byArray[n2 + n * 9];
                Sudoku.v2[n2][n] = byArray[n2 + n * 9 + n3];
            }
        }
        this.switchGrid();
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n < 9; ++n) {
                if (v2[n2][n] == 1) {
                    this.setCell(n2, n, v1[n2][n]);
                    this.setGreenCell(n2, n);
                }
                this.m_iSolution[n2][n] = v1[n2][n];
            }
        }
        nCellNeedFill = this.iNullCell;
        v1 = null;
        v2 = null;
    }

    boolean isComplete() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.m_iSolution[i][j] == this.m_iCurrentGrid[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    void RandomFill(int n) {
        if (this.iNullCell <= n) {
            n = this.iNullCell - 1;
        }
        int n2 = (this.m_random.nextInt() >>> 1) % 81;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 % 9;
            int n5 = n2 / 9;
            if (this.getCell(n4, n5) == 0 && this.m_random.nextInt() > 0) {
                this.setCell(n4, n5, this.getRightCell(n4, n5));
                this.setGreenCell(n4, n5);
                ++n3;
            }
            if (++n2 < 81) continue;
            n2 = 0;
        }
        nCellNeedFill = this.iNullCell;
    }

    void readMatrix2(byte[] byArray) {
        int n;
        int n2;
        int n3 = 81;
        v1 = new int[9][9];
        v2 = new int[9][9];
        v3 = new int[9][9];
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n < 9; ++n) {
                Sudoku.v1[n2][n] = byArray[n2 + n * 9];
                Sudoku.v2[n2][n] = byArray[n2 + n * 9 + n3];
                Sudoku.v3[n2][n] = byArray[n2 + n * 9 + n3 * 2];
            }
        }
        this.switchGrid();
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n < 9; ++n) {
                if (v2[n2][n] == 1) {
                    this.setCell(n2, n, v1[n2][n]);
                    this.setGreenCell(n2, n);
                }
                if (v3[n2][n] == 1) {
                    this.setCellMustBeFill(n2, n);
                }
                this.m_iSolution[n2][n] = v1[n2][n];
            }
        }
        v1 = null;
        v2 = null;
        v3 = null;
    }

    protected void switchGrid() {
        if (cGame.s_game_mode != 0 && cGame.s_game_mode != 4) {
            return;
        }
        if (cGame.s_is_X_mode) {
            return;
        }
        int n = this.m_iGridId = cGame.s_game_sub_id;
        int n2 = n % 6;
        this.switchRowGroup(0, n2 % 3);
        if (n2 / 2 == 1) {
            this.switchRowGroup(1, 2);
        }
        n2 = (n /= 6) % 6;
        this.switchColGroup(0, n2 % 3);
        if (n2 / 3 == 1) {
            this.switchColGroup(1, 2);
        }
        boolean bl = (n2 = (n /= 6) % 6) < 3;
        int n3 = n2 < 3 ? n2 : n2 - 3;
        n2 = (n /= 6) % 6;
        if (bl) {
            this.switchRow(n3 * 3 + 0, n3 * 3 + n2 % 3);
            if (n2 / 3 == 1) {
                this.switchRow(n3 * 3 + 1, n3 * 3 + 2);
            }
        } else {
            this.switchCol(n3 * 3 + 0, n3 * 3 + n2 % 3);
            if (n2 / 3 == 1) {
                this.switchCol(n3 * 3 + 1, n3 * 3 + 2);
            }
        }
    }

    protected void switchRow(int n, int n2) {
        if (n == n2) {
            return;
        }
        int[] nArray = v1[n];
        Sudoku.v1[n] = v1[n2];
        Sudoku.v1[n2] = nArray;
        nArray = v2[n];
        Sudoku.v2[n] = v2[n2];
        Sudoku.v2[n2] = nArray;
        if (v3 != null) {
            nArray = v3[n];
            Sudoku.v3[n] = v3[n2];
            Sudoku.v3[n2] = nArray;
        }
    }

    protected void switchCol(int n, int n2) {
        if (n == n2) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            int n3 = v1[i][n];
            Sudoku.v1[i][n] = v1[i][n2];
            Sudoku.v1[i][n2] = n3;
            n3 = v2[i][n];
            Sudoku.v2[i][n] = v2[i][n2];
            Sudoku.v2[i][n2] = n3;
            if (v3 == null) continue;
            n3 = v3[i][n];
            Sudoku.v3[i][n] = v3[i][n2];
            Sudoku.v3[i][n2] = n3;
        }
    }

    protected void switchRowGroup(int n, int n2) {
        if (n == n2) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.switchRow(n * 3 + i, n2 * 3 + i);
        }
    }

    protected void switchColGroup(int n, int n2) {
        if (n == n2) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.switchCol(n * 3 + i, n2 * 3 + i);
        }
    }

    void SetDraft(int n, int n2, int n3, int n4) {
        this.m_draft[n][n2][n3] = (short)n4;
    }

    void SetDraftNull(int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            this.m_draft[n][n2][i] = 0;
        }
    }

    boolean hasDraft(int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            if (this.m_draft[n][n2][i] == 0) continue;
            return true;
        }
        return false;
    }

    short getDraft(int n, int n2, int n3) {
        return this.m_draft[n][n2][n3];
    }

    short[] findvalid(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[9];
        for (n5 = 0; n5 < 9; ++n5) {
            for (n4 = 0; n4 < 9; ++n4) {
                if (!Sudoku.IsInSameColumn(n5, n4, n, n2) && !Sudoku.IsInSameRow(n5, n4, n, n2) && !Sudoku.IsInSameGrid(n5, n4, n, n2) || (n3 = this.getCell(n5, n4)) <= 0 || this.isRedCell(n5, n4)) continue;
                nArray[n3 - 1] = 1;
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < 9; ++n4) {
            if (nArray[n4] == 1) continue;
            ++n5;
        }
        short[] sArray = new short[n5];
        n3 = 0;
        for (int i = 0; i < 9; ++i) {
            if (nArray[i] == 1) continue;
            sArray[n3++] = (short)(i + 1);
        }
        return sArray;
    }

    void scan(int n, int n2) {
        if (this.isBlackCell(n, n2) && this.getCell(n, n2) == this.m_iSolution[n][n2]) {
            this.removeRedCell(n, n2);
            this.setGreenCell(n, n2);
        }
    }

    int contains(int n) {
        int n2 = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.m_iCurrentGrid[i][j] != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    void resetBlinkFlag() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_BlinkFlag[i][j] = 0;
            }
        }
    }

    boolean isAlphaCell(int n, int n2) {
        return this.m_BlinkFlag[n][n2] == 2;
    }

    boolean isBlinkcell(int n, int n2) {
        return this.m_BlinkFlag[n][n2] == 1;
    }

    void setAlphaFlag(int n, int n2) {
        this.hasAlphaEffect = true;
        this.m_BlinkFlag[n][n2] = 2;
    }

    void setBlinkFlag(int n, int n2) {
        this.m_BlinkFlag[n][n2] = 1;
    }

    void FillAGreen() {
        int n;
        int[] nArray = new int[81];
        int[] nArray2 = new int[81];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 9; ++n) {
            for (int i = 0; i < 9; ++i) {
                if (this.getCell(n, i) == 0) {
                    nArray[n2++] = n * 9 + i;
                }
                if (!this.isRedCell(n, i)) continue;
                nArray2[n3++] = n * 9 + i;
            }
        }
        n = -1;
        if (cGame.s_game_mode == 3 || cGame.s_game_mode == 4) {
            this.m_solve_i = cGame.m_select_i;
            this.m_solve_j = cGame.m_select_j;
        } else if (n2 != 0) {
            n = n2 == 1 ? 0 : (this.m_random.nextInt() >>> 1) % (n2 - 1);
            this.m_solve_i = nArray[n] / 9;
            this.m_solve_j = nArray[n] % 9;
        } else {
            n = n3 == 1 ? 0 : (this.m_random.nextInt() >>> 1) % (n3 - 1);
            this.m_solve_i = nArray2[n] / 9;
            this.m_solve_j = nArray2[n] % 9;
        }
        this.setCell(this.m_solve_i, this.m_solve_j, this.m_iSolution[this.m_solve_i][this.m_solve_j]);
        this.setBlinkFlag(this.m_solve_i, this.m_solve_j);
        this.removeRedCell(this.m_solve_i, this.m_solve_j);
        this.setGreenCell(this.m_solve_i, this.m_solve_j);
    }

    int findANullCell() {
        int n;
        int[] nArray = new int[81];
        int n2 = 0;
        for (n = 0; n < 9; ++n) {
            for (int i = 0; i < 9; ++i) {
                if (this.getCell(n, i) != 0) continue;
                nArray[n2++] = n * 9 + i;
            }
        }
        n = -1;
        if (n2 != 0) {
            n = n2 == 1 ? 0 : (this.m_random.nextInt() >>> 1) % (n2 - 1);
            return nArray[n];
        }
        return -1;
    }

    int findACluel1() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.getCell(i, j) != 0) continue;
                int n = this.findNNullCells_C(i, j);
                int n2 = this.findNNullCells_R(i, j);
                int n3 = this.findNNullCells_G(i, j);
                if (n > 1 && n > 1 && n > 1) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    int find3Cluel1() {
        for (int i = 8; i >= 0; --i) {
            for (int j = 8; j >= 0; --j) {
                if (this.getCell(i, j) != 0) continue;
                int n = this.findNNullCells_C(i, j);
                int n2 = this.findNNullCells_R(i, j);
                int n3 = this.findNNullCells_G(i, j);
                if (n > 2 || n > 2 || n > 2) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    int find3Cluel2() {
        for (int i = 8; i >= 0; --i) {
            for (int j = 8; j >= 0; --j) {
                if (this.getCell(i, j) != 0) continue;
                int n = this.findNNullCells_C(i, j);
                int n2 = this.findNNullCells_R(i, j);
                int n3 = this.findNNullCells_G(i, j);
                if (n > 3 || n > 3 || n > 3) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    int findACluel2() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.getCell(i, j) != 0) continue;
                int n = this.findNNullCells_C(i, j);
                int n2 = this.findNNullCells_R(i, j);
                int n3 = this.findNNullCells_G(i, j);
                if (n > 2 && n > 2 && n > 2) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    int findACluel3() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.getCell(i, j) != 0) continue;
                int n = this.findNNullCells_C(i, j);
                int n2 = this.findNNullCells_R(i, j);
                int n3 = this.findNNullCells_G(i, j);
                if (n > 3 && n > 3 && n > 3) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    int findNNullCells(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                short s;
                if (!Sudoku.IsInSameColumn(i, j, n, n2) && !Sudoku.IsInSameRow(i, j, n, n2) && !Sudoku.IsInSameGrid(i, j, n, n2) || (s = this.getCell(i, j)) != 0) continue;
                ++n3;
            }
        }
        return n3;
    }

    int findNNullCells_C(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                short s;
                if (!Sudoku.IsInSameColumn(i, j, n, n2) || (s = this.getCell(i, j)) != 0) continue;
                ++n3;
            }
        }
        return n3;
    }

    int findNNullCells_R(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                short s;
                if (!Sudoku.IsInSameRow(i, j, n, n2) || (s = this.getCell(i, j)) != 0) continue;
                ++n3;
            }
        }
        return n3;
    }

    int findNNullCells_G(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                short s;
                if (!Sudoku.IsInSameGrid(i, j, n, n2) || (s = this.getCell(i, j)) != 0) continue;
                ++n3;
            }
        }
        return n3;
    }

    void SetRedFlags(int n, int n2) {
        int n3;
        int n4;
        if (cGame.s_game_mode == 3 && !this.isRightCell(n, n2)) {
            this.setRedCell(n, n2);
        }
        for (n4 = 0; n4 < 9; ++n4) {
            if (n4 == n || this.getCell(n4, n2) != this.getCell(n, n2)) continue;
            this.setRedCell(n4, n2);
            this.setRedCell(n, n2);
        }
        for (n4 = 0; n4 < 9; ++n4) {
            if (n4 == n2 || this.getCell(n, n4) != this.getCell(n, n2)) continue;
            this.setRedCell(n, n4);
            this.setRedCell(n, n2);
        }
        n4 = n / 3 * 3;
        int n5 = n2 / 3 * 3;
        for (n3 = n4; n3 < n4 + 3; ++n3) {
            for (int i = n5; i < n5 + 3; ++i) {
                if (n3 == n && i == n2 || this.getCell(n3, i) != this.getCell(n, n2)) continue;
                this.setRedCell(n3, i);
                this.setRedCell(n, n2);
            }
        }
        if (cGame.s_is_X_mode) {
            if (n == n2) {
                for (n3 = 0; n3 < 9; ++n3) {
                    if (n3 == n || this.getCell(n3, n3) != this.getCell(n, n)) continue;
                    this.setRedCell(n, n2);
                    this.setRedCell(n3, n3);
                }
            }
            if (n == 8 - n2) {
                for (n3 = 0; n3 < 9; ++n3) {
                    if (n3 == n || this.getCell(n3, 8 - n3) != this.getCell(n, n2)) continue;
                    this.setRedCell(n, n2);
                    this.setRedCell(n3, 8 - n3);
                }
            }
        }
    }

    void SetAlphaFlags(int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        this.hasAlphaEffect = false;
        for (n5 = 0; n5 < 9; ++n5) {
            if (this.isRedCell(n5, n2)) {
                return;
            }
            if (this.getCell(n5, n2) != 0) continue;
            bl = false;
        }
        for (n5 = 0; n5 < 9; ++n5) {
            if (this.isRedCell(n, n5)) {
                return;
            }
            if (this.getCell(n, n5) != 0) continue;
            bl2 = false;
        }
        n5 = n / 3 * 3;
        int n6 = n2 / 3 * 3;
        for (n4 = n5; n4 < n5 + 3; ++n4) {
            for (n3 = n6; n3 < n6 + 3; ++n3) {
                if (this.isRedCell(n4, n3)) {
                    return;
                }
                if (this.getCell(n4, n3) != 0) continue;
                bl3 = false;
            }
        }
        if (cGame.s_is_X_mode) {
            if (n == n2) {
                for (n4 = 0; n4 < 9; ++n4) {
                    if (this.isRedCell(n4, n4)) {
                        return;
                    }
                    if (this.getCell(n4, n4) != 0) continue;
                    bl4 = false;
                }
            } else {
                bl4 = false;
            }
            if (n == 8 - n2) {
                for (n4 = 0; n4 < 9; ++n4) {
                    if (this.isRedCell(n4, 8 - n4)) {
                        return;
                    }
                    if (this.getCell(n4, 8 - n4) != 0) continue;
                    bl5 = false;
                }
            } else {
                bl5 = false;
            }
        }
        if (bl) {
            for (n4 = 0; n4 < 9; ++n4) {
                this.setAlphaFlag(n4, n2);
            }
            cGame.AddCommnetAnim();
        }
        if (bl2) {
            for (n4 = 0; n4 < 9; ++n4) {
                this.setAlphaFlag(n, n4);
            }
            cGame.AddCommnetAnim();
        }
        if (bl3) {
            for (n4 = n5; n4 < n5 + 3; ++n4) {
                for (n3 = n6; n3 < n6 + 3; ++n3) {
                    this.setAlphaFlag(n4, n3);
                }
            }
            cGame.AddCommnetAnim();
        }
        if (cGame.s_is_X_mode) {
            if (bl4) {
                for (n4 = 0; n4 < 9; ++n4) {
                    this.setAlphaFlag(n4, n4);
                }
                cGame.AddCommnetAnim();
            }
            if (bl5) {
                for (n4 = 0; n4 < 9; ++n4) {
                    this.setAlphaFlag(n4, 8 - n4);
                }
                cGame.AddCommnetAnim();
            }
        }
    }

    void SetRedFlags2(int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < 9; ++n4) {
            if (n4 == n || this.getCell(n4, n2) != this.getCell(n, n2)) continue;
            this.setRedCell(n, n2);
        }
        for (n4 = 0; n4 < 9; ++n4) {
            if (n4 == n2 || this.getCell(n, n4) != this.getCell(n, n2)) continue;
            this.setRedCell(n, n2);
        }
        n4 = n / 3 * 3;
        int n5 = n2 / 3 * 3;
        for (n3 = n4; n3 < n4 + 3; ++n3) {
            for (int i = n5; i < n5 + 3; ++i) {
                if (n3 == n && i == n2 || this.getCell(n3, i) != this.getCell(n, n2)) continue;
                this.setRedCell(n, n2);
            }
        }
        if (cGame.s_is_X_mode) {
            if (n == n2) {
                for (n3 = 0; n3 < 9; ++n3) {
                    if (n3 == n || this.getCell(n3, n3) != this.getCell(n, n)) continue;
                    this.setRedCell(n, n2);
                }
            }
            if (n == 8 - n2) {
                for (n3 = 0; n3 < 9; ++n3) {
                    if (n3 == n || this.getCell(n3, 8 - n3) != this.getCell(n, n2)) continue;
                    this.setRedCell(n, n2);
                }
            }
        }
    }

    void ClearGrid() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                short s = this.getCell(i, j);
                if (s == 0 || this.isGreenCell(i, j)) continue;
                this.setCell(i, j, 0);
                this.setNullCell(i, j);
            }
        }
        this.m_GridFlag2 = new int[9][9];
        this.m_draft = new short[9][9][4];
        this.m_BlinkFlag = new int[9][9];
    }

    void ClearRedFlags(int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < 9; ++n4) {
            for (n3 = 0; n3 < 9; ++n3) {
                this.removeRedCell(n4, n3);
            }
        }
        for (n4 = 0; n4 < 9; ++n4) {
            for (n3 = 0; n3 < 9; ++n3) {
                short s = this.getCell(n4, n3);
                if (s == 0 || this.isGreenCell(n4, n3)) continue;
                this.SetRedFlags2(n4, n3);
            }
        }
    }

    void ClearRedFlagInGreen() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!this.isGreenCell(i, j)) continue;
                this.removeRedCell(i, j);
            }
        }
    }

    static boolean IsInSameColumn(int n, int n2, int n3, int n4) {
        return n == n3;
    }

    static boolean IsInSameRow(int n, int n2, int n3, int n4) {
        return n2 == n4;
    }

    static boolean IsInSameGrid(int n, int n2, int n3, int n4) {
        return n / 3 == n3 / 3 && n2 / 3 == n4 / 3;
    }

    boolean canBeFill(int n, int n2) {
        if (cGame.s_game_mode == 3 || cGame.s_game_mode == 5) {
            return !this.isGreenCell(n, n2) && this.isCellMustBeFill(n, n2);
        }
        if (cGame.s_game_mode == 4) {
            return this.getCell(n, n2) == 0;
        }
        return !this.isGreenCell(n, n2);
    }

    void setCell(int n, int n2, int n3) {
        if (n3 == 0 && this.getCell(n, n2) != 0) {
            ++this.iNullCell;
        }
        if (n3 != 0 && this.getCell(n, n2) == 0) {
            --this.iNullCell;
        }
        this.m_iCurrentGrid[n][n2] = (short)n3;
    }

    short getCell(int n, int n2) {
        return this.m_iCurrentGrid[n][n2];
    }

    boolean isGreenCell(int n, int n2) {
        return this.m_GridFlag[n][n2] == 1;
    }

    boolean isRedCell(int n, int n2) {
        return this.m_GridFlag2[n][n2] == 2;
    }

    boolean isBlackCell(int n, int n2) {
        return this.m_GridFlag[n][n2] == 3;
    }

    boolean isNullCell(int n, int n2) {
        return this.m_GridFlag[n][n2] == 0;
    }

    void setGreenCell(int n, int n2) {
        this.SetDraftNull(n, n2);
        this.m_GridFlag[n][n2] = 1;
    }

    void setRedCell(int n, int n2) {
        if (!this.isRedCell(n, n2)) {
            ++this.iError;
        }
        if (bNeedBlink) {
            this.setBlinkFlag(n, n2);
        }
        this.m_GridFlag2[n][n2] = 2;
    }

    void removeRedCell(int n, int n2) {
        if (this.isRedCell(n, n2)) {
            --this.iError;
        }
        this.m_GridFlag2[n][n2] = 0;
    }

    void setBlackCell(int n, int n2) {
        this.m_GridFlag[n][n2] = 3;
    }

    void setNullCell(int n, int n2) {
        this.m_GridFlag[n][n2] = 0;
    }

    public void getAllClues() {
        byte[][] byArray = new byte[9][9];
        this.m_bEasier = (byte)-1;
        this.m_bShort = (byte)90;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.m_iCurrentGrid[i][j] == 0) {
                    byArray[i][j] = this.getCellClue(i, j);
                    if (byArray[i][j] >= this.m_bShort) continue;
                    this.m_bShort = byArray[i][j];
                    this.m_bEasier = (byte)(i * 9 + j);
                    continue;
                }
                byArray[i][j] = 90;
            }
        }
    }

    private byte getCellClue(int n, int n2) {
        int n3;
        byte by = 0;
        byte[] byArray = new byte[10];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n / 3 * 3;
        int n8 = n2 / 3 * 3;
        for (n3 = 0; n3 < 9; ++n3) {
            if (this.m_iCurrentGrid[n3][n2] > 0 && n3 != n && !this.isRepeat(n3, n2)) {
                byArray[this.m_iCurrentGrid[n3][n2]] = 1;
                ++n4;
            }
            if (this.m_iCurrentGrid[n][n3] > 0 && n3 != n2 && !this.isRepeat(n, n3)) {
                byArray[this.m_iCurrentGrid[n][n3]] = 1;
                ++n5;
            }
            if (this.m_iCurrentGrid[n7 + n3 % 3][n8 + n3 / 3] <= 0 || n7 + n3 % 3 == n && n8 + n3 / 3 == n2 || this.isRepeat(n7 + n3 % 3, n8 + n3 / 3)) continue;
            byArray[this.m_iCurrentGrid[n7 + n3 % 3][n8 + n3 / 3]] = 1;
            ++n6;
        }
        by = 9;
        for (n3 = 1; n3 < 10; ++n3) {
            if (byArray[n3] != 0) continue;
            by = (byte)(by + 9);
        }
        if (n4 < n5) {
            n4 = n5;
        }
        if (n4 < n6) {
            n4 = n6;
        }
        by = (byte)(by - n4);
        return by;
    }

    boolean isRepeat(int n, int n2) {
        int n3 = n2 * 9 + n;
        return (m_isRepeatedGrid[n3 / 32] & 1 << n3 % 32) != 0 && this.m_iGrid[n][n2] == 0;
    }

    public byte[] getValid(int n, int n2) {
        int n3;
        byte[] byArray = new byte[10];
        for (n3 = 0; n3 < 10; ++n3) {
            byArray[n3] = 1;
        }
        int n4 = n / 3 * 3;
        int n5 = n2 / 3 * 3;
        for (n3 = 0; n3 < 9; ++n3) {
            if (this.m_iCurrentGrid[n3][n2] > 0 && n3 != n) {
                byArray[this.m_iCurrentGrid[n3][n2]] = 0;
            }
            if (this.m_iCurrentGrid[n][n3] > 0 && n3 != n2) {
                byArray[this.m_iCurrentGrid[n][n3]] = 0;
            }
            if (this.m_iCurrentGrid[n4 + n3 % 3][n5 + n3 / 3] <= 0 || n4 + n3 % 3 == n || n5 + n3 / 3 == n2) continue;
            byArray[this.m_iCurrentGrid[n4 + n3 % 3][n5 + n3 / 3]] = 0;
        }
        byArray[0] = 1;
        return byArray;
    }

    void initialize() {
        int n;
        int n2;
        int n3;
        this.clearSolver();
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                this.addColumn(n3 * 9 + n2, true);
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                n = 81 + (n3 * 9 + n2) * 3;
                this.addColumn(n, true);
                this.addColumn(n + 1, true);
                this.addColumn(n + 2, true);
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                for (int i = 0; i < 9; ++i) {
                    this.row = null;
                    n = i * 9;
                    this.setColumn(n3 * 9 + n2);
                    this.setColumn(81 + (n + n3) * 3);
                    this.setColumn(81 + (n + n2) * 3 + 1);
                    this.setColumn(81 + (n + (n3 / 3 * 3 + n2 / 3)) * 3 + 2);
                }
            }
        }
    }

    void clearSolver() {
        int n;
        int n2 = this.columns.size();
        for (n = 0; n < n2; ++n) {
            Header header = (Header)this.columns.elementAt(n);
            header.unplug();
        }
        n2 = this.rows.size();
        for (n = 0; n < n2; ++n) {
            Node node;
            Node node2 = (Node)this.rows.elementAt(n);
            node2.left.right = null;
            do {
                node = node2.right;
                node2.unplug();
            } while ((node2 = node) != null);
        }
        this.iterCol = null;
        this.iterRow = null;
        this.row = null;
        this.column = null;
        this.root.unplug();
        this.root = new Header();
        this.columns.removeAllElements();
        this.rows.removeAllElements();
        this.solStack.removeAllElements();
    }

    public void setCell2(int n, int n2, int n3) {
        int n4 = n * 9 * 9 + n2 * 9;
        this.m_iGrid[n][n2] = n3;
        for (int i = 0; i < 9; ++i) {
            if (n3 <= 0 || i == n3 - 1) {
                this.enableRow(n4 + i);
                continue;
            }
            this.disableRow(n4 + i);
        }
    }

    public void setGrid(short[][] sArray) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (sArray[i][j] != this.m_iGrid[i][j]) {
                    this.setCell2(i, j, sArray[i][j]);
                }
                this.m_iSolution[i][j] = 0;
            }
        }
        this.m_iSolCount = 0;
    }

    protected boolean record() {
        if (++this.m_iSolCount > 1) {
            return false;
        }
        int n = this.getSol();
        while (n != -1) {
            int n2 = -1;
            int n3 = -1;
            while (n != -1) {
                if (n >= 81) {
                    if ((n - 81) % 3 == 0) {
                        n2 = (n - 81) / 3 % 9;
                    }
                    if ((n - 81) % 3 == 1) {
                        n3 = (n - 81) / 3 % 9;
                    }
                    if (n2 >= 0 && n3 >= 0) {
                        this.m_iSolution[n2][n3] = (n - 81) / 3 / 9 + 1;
                    }
                }
                n = this.getSol();
            }
            n = this.getSol();
        }
        return true;
    }

    public void addColumn(int n, boolean bl) {
        Header header = new Header();
        header.id = n;
        header.size = 0;
        if (bl) {
            header.right = this.root;
            header.left = this.root.left;
            this.root.left.right = header;
            this.root.left = header;
        }
        this.columns.addElement(header);
    }

    public void setColumn(int n) {
        Header header = (Header)this.columns.elementAt(n);
        Node node = new Node();
        if (this.row == null) {
            this.row = node;
            this.rows.addElement(node);
        } else {
            node.left = this.row;
            node.right = this.row.right;
            this.row.right.left = node;
            this.row.right = node;
        }
        node.head = header;
        node.up = header;
        node.down = header.down;
        header.down.up = node;
        header.down = node;
        ++header.size;
    }

    public void disableRow(int n) {
        Node node = (Node)this.rows.elementAt(n);
        if (node.up == node) {
            return;
        }
        Node node2 = node;
        do {
            node2.up.down = node2.down;
            node2.down.up = node2.up;
            node2.down = node2.up = node2;
            --node2.head.size;
        } while (node != (node2 = node2.right));
    }

    public void enableRow(int n) {
        Node node = (Node)this.rows.elementAt(n);
        if (node.up != node) {
            return;
        }
        Node node2 = node;
        do {
            node2.up = node2.head;
            node2.down = node2.head.down;
            node2.up.down = node2;
            node2.down.up = node2;
            ++node2.head.size;
        } while (node != (node2 = node2.right));
    }

    public boolean solve() {
        switch (this.m_iSolveStep) {
            case 0: {
                this.initialize();
                ++this.m_iSolveStep;
                return false;
            }
            case 1: {
                this.setGrid(this.m_iCurrentGrid);
                ++this.m_iSolveStep;
                return false;
            }
            case 2: {
                int n;
                int n2;
                if (this.m_iSolCount == 1) {
                    ++this.m_iSolveStep;
                    break;
                }
                this.more = true;
                this.solStack.setSize(this.columns.size());
                this.stackPos = 0;
                this.iterStack = 0;
                this.m_iDequeRemovals = 0;
                this.m_iSolCount = 0;
                this.iterCol = null;
                this.iterRow = null;
                this.column = null;
                this.search();
                if (this.m_iSolCount == 0 || cGame.s_game_mode == 2) {
                    for (n2 = 0; n2 < 9; ++n2) {
                        for (n = 0; n < 9; ++n) {
                            this.m_iGrid[n2][n] = 0;
                        }
                    }
                }
                if (cGame.s_game_mode == 2 && this.m_iSolCount == 1) {
                    n2 = 81;
                    for (n = 0; n < 9; ++n) {
                        for (int i = 0; i < 9; ++i) {
                            this.m_iGrid[n][i] = this.m_iCurrentGrid[n][i];
                            cGame.Custom_Puzzles[cGame.m_puzzleChoosed][n2 + i * 9 + n] = this.m_iCurrentGrid[n][i] != 0 ? (byte)1 : 0;
                            cGame.Custom_Puzzles[cGame.m_puzzleChoosed][i * 9 + n] = (byte)this.m_iSolution[n][i];
                        }
                    }
                    cGame.s_validCustomPuzzle[cGame.m_puzzleChoosed] = 1;
                    this.m_iErrors = this.m_iBlank;
                } else if (cGame.s_game_mode == 1 && this.m_iSolCount > 0) {
                    for (n2 = 0; n2 < 9; ++n2) {
                        for (n = 0; n < 9; ++n) {
                            if (this.m_iCurrentGrid[n2][n] != 0) {
                                this.setGreenCell(n2, n);
                            } else {
                                this.setBlackCell(n2, n);
                            }
                            this.m_iCurrentGrid[n2][n] = (byte)this.m_iSolution[n2][n];
                        }
                    }
                }
                ++this.m_iSolveStep;
                return false;
            }
            case 3: {
                this.clearSolver();
                System.gc();
                ++this.m_iSolveStep;
                return true;
            }
        }
        return true;
    }

    protected int getSol() {
        if (this.iterCol != null) {
            int n = this.iterCol.head.id;
            this.iterCol = this.iterCol.right;
            if (this.iterCol == this.iterRow) {
                this.iterCol = null;
            }
            return n;
        }
        if (++this.iterStack < this.stackPos) {
            this.iterCol = this.iterRow = (Node)this.solStack.elementAt(this.iterStack);
        }
        return -1;
    }

    private void search() {
        ++this.timer;
        if (this.root.right == this.root) {
            this.iterStack = 0;
            this.iterRow = this.stackPos > 0 ? (Node)this.solStack.elementAt(0) : null;
            this.iterCol = this.iterRow;
            this.more = this.record();
            return;
        }
        this.choose();
        this.cover(this.column);
        this.row = this.column.down;
        while (this.row != this.column) {
            Node node = this.row.right;
            while (node != this.row) {
                this.cover(node.head);
                node = node.right;
            }
            this.solStack.setElementAt(this.row, this.stackPos++);
            this.search();
            this.row = (Node)this.solStack.elementAt(--this.stackPos);
            this.column = this.row.head;
            node = this.row.left;
            while (node != this.row) {
                this.uncover(node.head);
                node = node.left;
            }
            if (!this.more) break;
            this.row = this.row.down;
        }
        this.uncover(this.column);
    }

    private void cover(Header header) {
        header.right.left = header.left;
        header.left.right = header.right;
        ++this.m_iDequeRemovals;
        Node node = header.down;
        while (node != header) {
            Node node2 = node.right;
            while (node2 != node) {
                node2.down.up = node2.up;
                node2.up.down = node2.down;
                --node2.head.size;
                ++this.m_iDequeRemovals;
                node2 = node2.right;
            }
            node = node.down;
        }
    }

    private void uncover(Header header) {
        Node node = header.up;
        while (node != header) {
            Node node2 = node.left;
            while (node2 != node) {
                ++node2.head.size;
                node2.down.up = node2;
                node2.up.down = node2;
                node2 = node2.left;
            }
            node = node.up;
        }
        header.right.left = header;
        header.left.right = header;
    }

    private void choose() {
        int n = Integer.MAX_VALUE;
        Header header = (Header)this.root.right;
        while (header != this.root) {
            if (header.size < n) {
                this.column = header;
                n = header.size;
            }
            header = (Header)header.right;
        }
    }

    public void releaseData() {
        if (this.m_iGrid != null) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_iSolution[i][j] = 0;
                    this.m_iGrid[i][j] = 0;
                    this.m_iCurrentGrid[i][j] = 0;
                    this.m_GridFlag[i][j] = 0;
                    this.m_GridFlag2[i][j] = 0;
                }
            }
        }
        Sudoku.m_isRepeatedGrid[2] = 0;
        Sudoku.m_isRepeatedGrid[1] = 0;
        Sudoku.m_isRepeatedGrid[0] = 0;
        this.m_iSolCount = 0;
        this.iError = 0;
        this.iNullCell = 81;
    }

    private class Header
    extends Node {
        public int size = 0;
        public int id = 0;

        public Header() {
            this.head = this;
        }
    }

    private class Node {
        public Node left = this;
        public Node right = this;
        public Node up = this;
        public Node down = this;
        public Header head;

        private Node() {
        }

        public void unplug() {
            this.head = null;
            this.down = null;
            this.up = null;
            this.right = null;
            this.left = null;
        }
    }
}

