/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class TCP
extends Thread {
    public boolean m_connected;
    public boolean m_bError = false;
    public String m_bErrorString = null;
    private TCPRecv m_receiveThread;
    protected Vector incomingQueue = new Vector();
    protected Vector outgoingQueue = new Vector();
    protected byte[] outgoing_data_on_receive_connection;
    protected String url;
    protected StreamConnection connection = null;
    protected InputStream istream = null;
    protected OutputStream ostream = null;
    protected StreamConnection receive_connection = null;
    protected InputStream receive_istream = null;
    protected OutputStream receive_ostream = null;

    public TCP(String string) {
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(byte[] byArray) {
        Vector vector = this.outgoingQueue;
        synchronized (vector) {
            this.outgoingQueue.addElement(byArray);
        }
    }

    public void sendEstablishConnectionPackageOnReceive(byte[] byArray) {
        this.sendPacket(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] recvPacket() {
        byte[] byArray = null;
        Vector vector = this.incomingQueue;
        synchronized (vector) {
            if (this.incomingQueue.size() > 0) {
                byArray = (byte[])this.incomingQueue.firstElement();
                this.incomingQueue.removeElementAt(0);
            }
        }
        return byArray;
    }

    public void connect() {
        if (!this.m_connected) {
            try {
                new Thread(this).start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void disconnect() {
        this.m_connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (this.m_receiveThread != null) {
            this.m_receiveThread.m_running = false;
        }
        try {
            if (this.istream != null) {
                this.istream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.ostream != null) {
                this.ostream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.istream = null;
        this.ostream = null;
        this.connection = null;
        Vector vector = this.outgoingQueue;
        synchronized (vector) {
            while (this.outgoingQueue.size() > 0) {
                this.outgoingQueue.removeElementAt(0);
            }
        }
        vector = this.incomingQueue;
        synchronized (vector) {
            while (this.incomingQueue.size() > 0) {
                this.incomingQueue.removeElementAt(0);
            }
        }
        try {
            this.m_receiveThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_connected = false;
        this.m_bError = false;
        try {
            this.connection = (StreamConnection)Connector.open((String)this.url);
            if (this.connection == null) {
                this.m_bErrorString = "StreamConnection.open to " + this.url;
                this.m_bError = true;
                return;
            }
        }
        catch (Exception exception) {
            this.m_bError = true;
            this.m_bErrorString = "StreamConnection.open to " + this.url + " exception: " + exception;
            return;
        }
        this.ostream = null;
        try {
            this.ostream = this.connection.openOutputStream();
            if (this.ostream == null) {
                this.m_bError = true;
                this.m_bErrorString = "StreamConnection.openOutputStream to " + this.url;
                return;
            }
        }
        catch (Exception exception) {
            this.m_bError = true;
            this.m_bErrorString = "StreamConnection.openOutputStream to " + this.url + " exception: " + exception;
            return;
        }
        this.istream = null;
        try {
            this.istream = this.connection.openInputStream();
            if (this.istream == null) {
                this.m_bError = true;
                this.m_bErrorString = "StreamConnection.openInputStream to " + this.url;
                return;
            }
        }
        catch (Exception exception) {
            this.m_bError = true;
            this.m_bErrorString = "StreamConnection.openInputStream to " + this.url + " exception: " + exception;
            return;
        }
        this.m_connected = true;
        this.m_receiveThread = new TCPRecv(this.istream, this.incomingQueue);
        this.m_receiveThread.start();
        byte[] byArray = new byte[1];
        while (this.m_connected && this.m_receiveThread.m_running) {
            byte[] byArray2;
            Vector vector = this.outgoingQueue;
            synchronized (vector) {
                byArray2 = null;
                if (this.outgoingQueue.size() > 0) {
                    byArray2 = (byte[])this.outgoingQueue.firstElement();
                    this.outgoingQueue.removeElementAt(0);
                }
            }
            if (byArray2 == null) {
                Thread.yield();
                continue;
            }
            byArray[0] = (byte)(byArray2.length & 0xFF);
            try {
                this.ostream.write(byArray);
                this.ostream.write(byArray2);
            }
            catch (Exception exception) {
                this.m_bError = true;
                this.m_bErrorString = "Send th: " + (exception.getMessage() == null ? exception.toString() : exception.getMessage());
                this.m_connected = false;
            }
            Thread.yield();
        }
        this.m_connected = false;
        this.cleanup();
        try {
            this.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class TCPRecv
    extends Thread {
        private InputStream is;
        private Vector v;
        private boolean m_running;
        private byte[] localReceiveBuffer;
        private int len;
        private int receiveBufferOffset;
        private byte[] receiveBufferQueue;

        public TCPRecv(InputStream inputStream, Vector vector) {
            this.is = inputStream;
            this.v = vector;
            this.localReceiveBuffer = new byte[255];
        }

        void recvBytes() {
            this.len = -2;
            boolean bl = false;
            try {
                this.len = this.is.read(this.localReceiveBuffer);
            }
            catch (Exception exception) {
                TCP.this.m_bError = true;
                TCP.this.m_bErrorString = "Recv th: " + (exception.getMessage() == null ? exception.toString() : exception.getMessage());
                this.m_running = false;
            }
            if (this.len <= 0) {
                this.m_running = false;
                return;
            }
            byte[] byArray = new byte[this.len + this.receiveBufferQueue.length - this.receiveBufferOffset];
            System.arraycopy(this.receiveBufferQueue, this.receiveBufferOffset, byArray, 0, this.receiveBufferQueue.length - this.receiveBufferOffset);
            System.arraycopy(this.localReceiveBuffer, 0, byArray, this.receiveBufferQueue.length - this.receiveBufferOffset, this.len);
            this.receiveBufferOffset = 0;
            this.receiveBufferQueue = byArray;
            Thread.yield();
        }

        int getByte() {
            while (this.m_running && this.receiveBufferQueue.length - this.receiveBufferOffset < 1) {
                this.recvBytes();
            }
            return this.m_running ? this.receiveBufferQueue[this.receiveBufferOffset++] : -1;
        }

        byte[] getBytes(int n) {
            while (this.m_running && this.receiveBufferQueue.length - this.receiveBufferOffset < n) {
                this.recvBytes();
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.receiveBufferQueue, this.receiveBufferOffset, byArray, 0, n);
            this.receiveBufferOffset += n;
            return byArray;
        }

        public void start() {
            this.m_running = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.receiveBufferQueue = new byte[0];
            this.receiveBufferOffset = 0;
            while (this.m_running) {
                int n = this.getByte();
                if (n == -1) {
                    this.m_running = false;
                    continue;
                }
                if (n < 0) {
                    n += 256;
                }
                byte[] byArray = this.getBytes(n);
                Vector vector = this.v;
                synchronized (vector) {
                    this.v.addElement(byArray);
                }
                Thread.yield();
            }
        }
    }
}

