/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public final class XPlayer {
    public static final byte SCORE_TYPE_POINTS = 1;
    public static final byte SCORE_TYPE_TIME = 2;
    private static final byte FUNCTION_LOGIN_REGISTER = 11;
    private static final byte FUNCTION_UPLOAD_SCORE = 35;
    private static final byte FUNCTION_GET_RANKINGS = 112;
    private static final byte FUNCTION_GET_RANKINGS_AROUND_PLAYER = 115;
    private static final byte FUNCTION_CHANGE_USERNAME = 14;
    private static final byte FUNCTION_RATE_GAME = 8;
    private static final byte FUNCTION_RECOMMEND_GAME_TO_BUDDIES = 9;
    private static final byte FUNCTION_GET_STATS = 10;
    private static final byte FUNCTION_DOWNLOAD_ITEM = 5;
    private static final byte FUNCTION_DOWNLOAD_PREVIEW = 18;
    public static final byte FUNCTION_DOWNLOAD_LIST_TYPE_ALL = 15;
    public static final byte FUNCTION_DOWNLOAD_LIST_TYPE_ALREADY_DOWNLOADED = 16;
    public static final byte FUNCTION_DOWNLOAD_LIST_TYPE_NOT_DOWNLOADED = 17;
    public static final byte FUNCTION_DOWNLOAD_LIST_TYPE_NEW_ITEMS = 20;
    private static final byte DOWNLOAD_OPERATION_SUCCESS = 3;
    private static final byte DOWNLOAD_OPERATION_FAIL = 1;
    private static final int DOWNLOAD_MAX_ITEMS = 128;
    private String[] dlMenuId = new String[128];
    private String[] dlName = new String[128];
    private int[] dlSize = new int[128];
    private int[] dlPrice = new int[128];
    private int dlTotalItems = 0;
    private byte[] dlItemData = null;
    private static String GGI;
    public static final int NOT_A_NUMBER = -666666;
    private HTTP whttp;
    private int leaderboardSize = -666666;
    private String[] leaderboardPlayerNames = null;
    private int[] leaderboardPlayerPositions = null;
    private int[] leaderboardPlayerScores = null;
    private int[][] leaderboardPlayerScoreDatas = null;
    private int leaderboardSupplementalDataFieldsNumber = 0;
    private int currentPlayerLeaderboardPosition = -666666;
    private int currentPlayerLeaderboardScore = -666666;
    private int[] currentPlayerLeaderboardScoreData = null;
    private String multipleScoresRequestBuffer = null;
    private String url;
    private String urlDownload;
    private String username;
    private String uid;
    private boolean is_logged_in = false;
    private int newRankAfterScoreSending;
    public static long callstarttime;
    private int lastErrorCode;
    private static boolean changeScreenMode;
    private String phoneNumber;
    private int bestRank = -666666;
    private int highScore = -666666;
    private int[] highScoreData = null;
    private int lowScore = -666666;
    private int[] lowScoreData = null;
    private int avgScore = -666666;
    private int numberOfGamesPlayed = -666666;
    private String lastTimePlayed = null;
    private int crtPosWrite;
    private int crtPosRead;
    private byte[] msgData;
    private TCP wtcp;
    private String url_tcp;
    private byte m_MPConnectLevel = 0;
    private boolean m_MPHasOpponentFinished = false;
    private String[] m_lNameList;
    private String[] m_lBinaryDataList;
    private byte[] m_lByteDataList;
    private byte noitems = 0;
    private int nosessionsbase = 0;
    private String found_player_name;
    private byte found_player_status;
    private String found_player_session_name;
    private byte found_player_session_number_of_players;
    private String requested_player_data;
    private String requested_player_nickname;
    private byte m_type;
    private byte m_subtype;
    private byte[] m_data;
    private Vector incomingGameData;
    private String currentsessionname = null;
    private String currentsessiondata = null;
    public boolean isGameMessageInQueue = false;

    static void PRINT(String string) {
    }

    public XPlayer(MIDlet mIDlet) {
        try {
            this.url = mIDlet.getAppProperty("ONLINE-XPlayerURL");
            GGI = mIDlet.getAppProperty("ONLINE-GGI");
        }
        catch (Exception exception) {
            this.url = "";
            GGI = "";
        }
        if (this.url == null || GGI == null) {
            return;
        }
        this.whttp = new HTTP();
        this.username = new String("");
        this.newRankAfterScoreSending = -666666;
        this.is_logged_in = false;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.clearLeaderboard();
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"UUID", (boolean)true);
            if (recordStore.getNumRecords() >= 1) {
                byte[] byArray = recordStore.getRecord(1);
                this.uid = new String(byArray);
            } else {
                this.uid = this.GenerateUID();
                byte[] byArray = this.uid.getBytes();
                if (recordStore.getNumRecords() >= 1) {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                } else {
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    private String GenerateUID() {
        byte[] byArray = new byte[20];
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            int n = random.nextInt() % 35;
            if (n < 0) {
                n = -n;
            }
            byArray[i] = (byte)n;
            if (byArray[i] < 10) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] + 48);
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] + 87);
        }
        String string = new String(byArray);
        System.gc();
        return string + Integer.toString((int)System.currentTimeMillis() / 1000);
    }

    public boolean isLoggedIn() {
        return this.is_logged_in;
    }

    public void setUsername(String string) {
        this.username = new String(string);
    }

    public String getUsername() {
        return this.username;
    }

    public int getNewRankAfterScoreSending() {
        return this.newRankAfterScoreSending;
    }

    public int getLastError() {
        if (this.whttp.isInProgress()) {
            return -1;
        }
        if (this.whttp.m_bError) {
            return -2;
        }
        return this.lastErrorCode;
    }

    public void cancel() {
        this.whttp.cancel();
    }

    public void cleanup() {
        this.whttp.cleanup();
    }

    private String String2Blob(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        int n2 = 0;
        int n3 = 8;
        int n4 = string.length() * 8 / 6;
        n4 = string.length() * 8 % 6 != 0 ? (n4 += 2) : ++n4;
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < n4; ++i) {
            byArray2[i] = 0;
        }
        while (n2 < string.length()) {
            int n5 = byArray[n2] & 0xFF;
            n5 >>= 8 - n3;
            if (n3 < 6) {
                if (++n2 < string.length()) {
                    n5 |= byArray[n2] << n3;
                    n3 += 2;
                }
            } else if ((n3 -= 6) == 0) {
                n3 = 8;
                ++n2;
            }
            byArray2[n] = this.SSEncDec_GetCharFromKeyByIndex((byte)(n5 &= 0x3F));
            ++n;
        }
        String string2 = new String(byArray2, 0, n);
        return string2;
    }

    private byte SSEncDec_GetCharFromKeyByIndex(byte by) {
        if (by < 26) {
            return (byte)(by + 97);
        }
        if (by < 52) {
            return (byte)(by + 39);
        }
        if (by < 62) {
            return (byte)(by - 4);
        }
        if (by == 62) {
            return 95;
        }
        return 45;
    }

    private String getValue(String string, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.indexOf(124, n2 + 1);
        while (n > 0) {
            if (n2 == -1) {
                return null;
            }
            n2 = n4;
            n4 = string.indexOf(124, n2 + 1);
            --n;
        }
        if (n2 == -1) {
            return null;
        }
        if (n4 == -1) {
            n4 = string.length();
        }
        if (n3 > 0) {
            ++n2;
        }
        if (n2 == n4) {
            return "";
        }
        if (n2 > n4) {
            return null;
        }
        try {
            char[] cArray = new char[n4 - n2];
            string.getChars(n2, n4, cArray, 0);
            String string2 = new String(cArray);
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void sendChangeUsername() {
        String string = "";
        string = "f|14|i|" + GGI + "|n|" + this.username + "|u|" + this.uid + "|";
        String string2 = this.String2Blob(string);
        this.lastErrorCode = -100;
        this.whttp.sendByGet(this.url, string2);
    }

    public void sendLogin(String string) {
        String string2 = "";
        string2 = "f|11|i|" + GGI + "|n|" + this.username + "|u|" + this.uid + "|";
        if (string != null) {
            string2 = string2 + "b|" + string + "|";
        }
        String string3 = this.String2Blob(string2);
        this.lastErrorCode = -100;
        this.whttp.sendByGet(this.url, string3);
    }

    public void handleLogin() {
        this.handleLoginChangeUsername(11);
    }

    public void handleChangeUsername() {
        this.handleLoginChangeUsername(14);
    }

    private void handleLoginChangeUsername(int n) {
        if (n != 11 && n != 14) {
            return;
        }
        if (this.whttp.isInProgress()) {
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("f") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (string == null) {
                return;
            }
            if (Integer.parseInt(string) != n) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string == null) {
                return;
            }
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                if (this.lastErrorCode == 3) {
                    string = this.getValue(this.whttp.m_response, 5);
                    if (string != null && string.compareTo("d") == 0 && (string = this.getValue(this.whttp.m_response, 6)).compareTo("5 M7 error, contact Online Team") == 0) {
                        this.lastErrorCode = -2;
                    }
                } else if (this.lastErrorCode == 5) {
                    this.username = this.getValue(this.whttp.m_response, 6);
                }
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
                this.username = this.getValue(this.whttp.m_response, 5);
                this.is_logged_in = true;
            }
        }
    }

    public void sendHighscore(int n, int n2, int n3) {
        String string;
        this.whttp.cancel();
        String string2 = "g|35|i|" + GGI + "|u|" + this.uid;
        if (n2 >= 0) {
            string2 = string2 + "|l|" + n2;
        }
        string2 = string2 + "|s|" + n + '|';
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = -100;
        this.newRankAfterScoreSending = -666666;
        this.whttp.sendByGet(this.url, string2);
    }

    public void sendHighscoreWithSupplementalData(int n, int n2, int n3, int[] nArray) {
        String string;
        this.whttp.cancel();
        String string2 = "f|35|i|" + GGI + "|u|" + this.uid;
        if (n2 < 0) {
            n2 = 0;
        }
        string2 = string2 + "|l|" + n2 + "|t|" + n3 + "|sl|0|s|" + n;
        for (int i = 0; i < nArray.length; ++i) {
            string2 = string2 + "|l|" + n2 + "|t|" + n3 + "|sl|" + (i + 1) + "|s|" + nArray[i];
        }
        string2 = string2 + "|";
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = -100;
        this.newRankAfterScoreSending = -666666;
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleHighscore() {
        if (this.whttp.isInProgress()) {
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("g") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (Integer.parseInt(string) != 35) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
                int n = 4;
                if ((string = this.getValue(this.whttp.m_response, n++)).compareTo("l") == 0) {
                    int n2 = ++n;
                    ++n;
                    string = this.getValue(this.whttp.m_response, n2);
                }
                if (string.compareTo("r") == 0) {
                    string = this.getValue(this.whttp.m_response, n);
                    this.newRankAfterScoreSending = Integer.parseInt(string);
                }
            }
        }
    }

    public void initMultipleScores() {
        this.multipleScoresRequestBuffer = "f|35|i|" + GGI + "|u|" + this.uid;
    }

    public void addMultipleScoreEntry(int n, int n2, int n3) {
        if (this.multipleScoresRequestBuffer == null) {
            return;
        }
        this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|l|" + n2 + "|t|" + n3 + "|s|" + n;
    }

    public void addMultipleScoreEntryWithSupplementalData(int n, int n2, int n3, int[] nArray) {
        if (this.multipleScoresRequestBuffer == null) {
            return;
        }
        this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|l|" + n2 + "|t|" + n3 + "|sl|0|s|" + n;
        for (int i = 0; i < nArray.length; ++i) {
            this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|l|" + n2 + "|t|" + n3 + "|sl|" + (i + 1) + "|s|" + nArray[i];
        }
    }

    public void sendMultipleHighscores() {
        if (this.multipleScoresRequestBuffer == null) {
            return;
        }
        this.whttp.cancel();
        this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|";
        String string = this.String2Blob(this.multipleScoresRequestBuffer);
        this.lastErrorCode = -100;
        this.newRankAfterScoreSending = -666666;
        this.whttp.sendByGet(this.url, string);
    }

    public void sendRankGet(int n, int n2, int n3, int n4, int n5) {
        String string;
        this.whttp.cancel();
        String string2 = "g|112|i|" + GGI + "|u|" + this.uid + "|p|" + n2 + "|";
        if (n >= 0) {
            string2 = string2 + "l|" + n + "|";
        }
        string2 = string = this.String2Blob(string2);
        this.clearLeaderboard();
        this.lastErrorCode = -100;
        this.leaderboardSupplementalDataFieldsNumber = n4;
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleRankGet() {
        if (this.whttp.isInProgress()) {
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("g") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (Integer.parseInt(string) != 112) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
                this.clearLeaderboard();
                try {
                    this.processLeaderboardData(this.whttp.m_response);
                }
                catch (Exception exception) {
                    this.lastErrorCode = 40;
                }
            }
        }
    }

    public void sendRankGetAroundPlayer(int n, int n2, int n3, int n4, int n5) {
        String string;
        this.whttp.cancel();
        String string2 = "g|115|i|" + GGI + "|u|" + this.uid + "|";
        if (n >= 0) {
            string2 = string2 + "l|" + n + "|";
        }
        string2 = string = this.String2Blob(string2);
        this.clearLeaderboard();
        this.lastErrorCode = -100;
        this.leaderboardSupplementalDataFieldsNumber = n4;
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleRankGetAroundPlayer() {
        if (this.whttp.isInProgress()) {
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("g") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (Integer.parseInt(string) != 115) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
                this.clearLeaderboard();
                try {
                    this.processRankingAroundPlayerData(this.whttp.m_response);
                }
                catch (Exception exception) {
                    this.lastErrorCode = 40;
                }
            }
        }
    }

    public int getCurrentPlayerLeaderboardPosition() {
        return this.currentPlayerLeaderboardPosition;
    }

    public int getCurrentPlayerLeaderboardScore() {
        return this.currentPlayerLeaderboardScore;
    }

    public int[] getCurrentPlayerLeaderboardScoreData() {
        return this.currentPlayerLeaderboardScoreData;
    }

    public boolean getLeaderboardData(String[] stringArray, int[] nArray, int[] nArray2, int[][] nArray3) {
        if (this.leaderboardSize <= 0 || this.leaderboardPlayerNames == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < this.leaderboardSize || nArray == null || nArray.length < this.leaderboardSize || nArray2 == null || nArray2.length < this.leaderboardSize) {
            return false;
        }
        System.arraycopy(this.leaderboardPlayerNames, 0, stringArray, 0, this.leaderboardSize);
        System.arraycopy(this.leaderboardPlayerPositions, 0, nArray, 0, this.leaderboardSize);
        System.arraycopy(this.leaderboardPlayerScores, 0, nArray2, 0, this.leaderboardSize);
        if (this.leaderboardPlayerScoreDatas != null && this.leaderboardSupplementalDataFieldsNumber > 0) {
            if (nArray3 == null || nArray3.length < this.leaderboardSize || nArray3[0].length < this.leaderboardSupplementalDataFieldsNumber) {
                return false;
            }
            System.arraycopy(this.leaderboardPlayerScoreDatas, 0, nArray3, 0, this.leaderboardSize);
        }
        return true;
    }

    public int getLeaderboardSize() {
        if (this.leaderboardPlayerNames == null) {
            return -1;
        }
        return this.leaderboardSize;
    }

    public String getLeaderboardEntryPlayerName(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerNames == null) {
            return null;
        }
        return this.leaderboardPlayerNames[n];
    }

    public int getLeaderboardEntryPlayerPosition(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerPositions == null) {
            return -1;
        }
        return this.leaderboardPlayerPositions[n];
    }

    public int getLeaderboardEntryPlayerScore(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerScores == null) {
            return -666666;
        }
        return this.leaderboardPlayerScores[n];
    }

    public int[] getLeaderboardEntryPlayerScoreData(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerScoreDatas == null) {
            return null;
        }
        return this.leaderboardPlayerScoreDatas[n];
    }

    private void processLeaderboardData(String string) {
        int n;
        int n2 = 4;
        String string2 = this.getValue(string, n2++);
        int n3 = 0;
        if (string2.compareTo("y") == 0) {
            string2 = this.getValue(string, n2++);
            this.currentPlayerLeaderboardPosition = Integer.parseInt(string2);
            if (this.currentPlayerLeaderboardPosition < 0) {
                this.currentPlayerLeaderboardPosition = -666666;
                this.currentPlayerLeaderboardPosition = -666666;
                this.currentPlayerLeaderboardScore = -666666;
                this.currentPlayerLeaderboardScoreData = null;
                n2 += 2 + this.leaderboardSupplementalDataFieldsNumber;
                n3 -= 3 + this.leaderboardSupplementalDataFieldsNumber;
            } else {
                int n4 = ++n2;
                ++n2;
                string2 = this.getValue(string, n4);
                this.currentPlayerLeaderboardScore = Integer.parseInt(string2);
                if (this.leaderboardSupplementalDataFieldsNumber > 0) {
                    this.currentPlayerLeaderboardScoreData = new int[this.leaderboardSupplementalDataFieldsNumber];
                }
                for (n = 0; n < this.leaderboardSupplementalDataFieldsNumber; ++n) {
                    string2 = this.getValue(string, n2++);
                    this.currentPlayerLeaderboardScoreData[n] = Integer.parseInt(string2);
                }
            }
        } else if (string2.compareTo("n") != 0) {
            return;
        }
        n = 0;
        n = string.indexOf(124, n + 1);
        while (n != -1) {
            ++n3;
            n = string.indexOf(124, n + 1);
        }
        n3 -= 4;
        if (this.currentPlayerLeaderboardPosition >= 0) {
            n3 -= 3 + this.leaderboardSupplementalDataFieldsNumber;
        }
        this.leaderboardSize = n3 / (3 + this.leaderboardSupplementalDataFieldsNumber);
        if (this.leaderboardSize <= 0) {
            return;
        }
        this.leaderboardPlayerNames = new String[this.leaderboardSize];
        this.leaderboardPlayerPositions = new int[this.leaderboardSize];
        this.leaderboardPlayerScores = new int[this.leaderboardSize];
        if (this.leaderboardSupplementalDataFieldsNumber > 0) {
            this.leaderboardPlayerScoreDatas = new int[this.leaderboardSize][this.leaderboardSupplementalDataFieldsNumber];
        }
        for (int i = 0; i < this.leaderboardSize; ++i) {
            string2 = this.getValue(string, n2++);
            this.leaderboardPlayerPositions[i] = Integer.parseInt(string2);
            string2 = this.getValue(string, n2++);
            this.leaderboardPlayerNames[i] = new String(string2);
            string2 = this.getValue(string, n2++);
            this.leaderboardPlayerScores[i] = Integer.parseInt(string2);
            for (int j = 0; j < this.leaderboardSupplementalDataFieldsNumber; ++j) {
                string2 = this.getValue(string, n2++);
                this.leaderboardPlayerScoreDatas[i][j] = Integer.parseInt(string2);
            }
        }
    }

    private void processRankingAroundPlayerData(String string) {
        int n = 0;
        int n2 = 0;
        n = string.indexOf(124, n + 1);
        while (n != -1) {
            ++n2;
            n = string.indexOf(124, n + 1);
        }
        this.leaderboardSize = (n2 -= 4) / (3 + this.leaderboardSupplementalDataFieldsNumber);
        if (this.leaderboardSize <= 0) {
            return;
        }
        this.leaderboardPlayerNames = new String[this.leaderboardSize];
        this.leaderboardPlayerPositions = new int[this.leaderboardSize];
        this.leaderboardPlayerScores = new int[this.leaderboardSize];
        if (this.leaderboardSupplementalDataFieldsNumber > 0) {
            this.leaderboardPlayerScoreDatas = new int[this.leaderboardSize][this.leaderboardSupplementalDataFieldsNumber];
        }
        int n3 = 5;
        for (int i = 0; i < this.leaderboardSize; ++i) {
            String string2 = this.getValue(string, n3++);
            this.leaderboardPlayerNames[i] = new String(string2);
            string2 = this.getValue(string, n3++);
            this.leaderboardPlayerPositions[i] = Integer.parseInt(string2);
            string2 = this.getValue(string, n3++);
            this.leaderboardPlayerScores[i] = Integer.parseInt(string2);
            for (int j = 0; j < this.leaderboardSupplementalDataFieldsNumber; ++j) {
                string2 = this.getValue(string, n3++);
                this.leaderboardPlayerScoreDatas[i][j] = Integer.parseInt(string2);
            }
        }
    }

    private void clearLeaderboard() {
        this.leaderboardPlayerNames = null;
        this.leaderboardPlayerPositions = null;
        this.leaderboardPlayerScores = null;
        this.leaderboardPlayerScoreDatas = null;
        this.currentPlayerLeaderboardPosition = -666666;
        this.currentPlayerLeaderboardScore = -666666;
        this.currentPlayerLeaderboardScoreData = null;
        this.leaderboardSize = -666666;
        System.gc();
    }

    public static final void screenModeChange(boolean bl) {
    }

    public static final boolean needScreenModeChange() {
        return changeScreenMode;
    }

    public void setPhoneNumber(String string) {
        this.phoneNumber = new String(string);
    }

    public void sendStatsGet(int n, int n2) {
        this.whttp.cancel();
        this.lastErrorCode = -3;
    }

    public void handleStatsGet() {
        this.lastErrorCode = -3;
    }

    public void getPlayerStats(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, String[] stringArray, int[] nArray6, int[] nArray7) {
        int n;
        nArray[0] = this.bestRank;
        nArray2[0] = this.highScore;
        for (n = 0; n < this.leaderboardSupplementalDataFieldsNumber; ++n) {
            nArray7[n] = this.highScoreData[n];
        }
        nArray3[0] = this.lowScore;
        for (n = 0; n < this.leaderboardSupplementalDataFieldsNumber; ++n) {
            nArray6[n] = this.lowScoreData[n];
        }
        nArray4[0] = this.avgScore;
        nArray5[0] = this.numberOfGamesPlayed;
        stringArray[0] = this.lastTimePlayed;
    }

    public int getMyBestRank() {
        return this.bestRank;
    }

    public int getMyHighScore() {
        return this.highScore;
    }

    public int getMyLowScore() {
        return this.lowScore;
    }

    public int[] getMyLowScoreData() {
        return this.lowScoreData;
    }

    public int[] getMyHighScoreData() {
        return this.highScoreData;
    }

    public int getMyAvgScore() {
        return this.avgScore;
    }

    public int getMyNumberOfGamesPlayed() {
        return this.numberOfGamesPlayed;
    }

    public String getMyLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public void sendRateGame(int n) {
        this.whttp.cancel();
        this.lastErrorCode = -3;
    }

    public void handleRateGame() {
        this.lastErrorCode = -3;
    }

    public void sendRecommendGame() {
        this.whttp.cancel();
        this.lastErrorCode = -3;
    }

    public void handleRecommendGame() {
        this.lastErrorCode = -3;
    }

    public void setData(byte[] byArray) {
        System.arraycopy(byArray, 0, this.msgData, 0, byArray.length);
        this.crtPosWrite = byArray.length;
        this.crtPosRead = 0;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.crtPosWrite];
        System.arraycopy(this.msgData, 0, byArray, 0, this.crtPosWrite);
        this.crtPosWrite = 0;
        this.crtPosRead = 0;
        return byArray;
    }

    public void clearData() {
        this.m_type = 0;
        this.m_subtype = 0;
        this.crtPosWrite = 0;
        this.crtPosRead = 0;
    }

    public int getLength() {
        return this.crtPosWrite;
    }

    public void addByte(byte by) throws Exception {
        if (this.msgData == null || this.crtPosWrite >= this.msgData.length) {
            throw new Exception("Error adding byte to current data");
        }
        this.msgData[this.crtPosWrite++] = by;
    }

    public byte getByte() throws Exception {
        if (this.msgData != null && this.crtPosRead < this.crtPosWrite) {
            return this.msgData[this.crtPosRead++];
        }
        throw new Exception("Error retrieving byte from current data");
    }

    public void addShort(short s) throws Exception {
        if (this.msgData == null || this.crtPosWrite >= this.msgData.length - 1) {
            throw new Exception("Error add short to current data");
        }
        this.msgData[this.crtPosWrite++] = (byte)((s & 0xFF00) >> 8);
        this.msgData[this.crtPosWrite++] = (byte)(s & 0xFF);
    }

    public short getShort() throws Exception {
        if (this.msgData != null && this.crtPosRead < this.crtPosWrite - 1) {
            short s = (short)(this.msgData[this.crtPosRead] << 8 & 0xFF00 | this.msgData[this.crtPosRead + 1] & 0xFF);
            this.crtPosRead += 2;
            return s;
        }
        throw new Exception("Error retrieve short from current data");
    }

    public void addInt(int n) throws Exception {
        if (this.msgData == null || this.crtPosWrite >= this.msgData.length - 3) {
            throw new Exception("Error add int to current data");
        }
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 24);
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 16);
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 8);
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 0);
    }

    public int getInt() throws Exception {
        if (this.msgData != null && this.crtPosRead < this.crtPosWrite - 3) {
            int n = 0;
            n |= this.msgData[this.crtPosRead] << 24 & 0xFF000000;
            n |= this.msgData[this.crtPosRead + 1] << 16 & 0xFF0000;
            n |= this.msgData[this.crtPosRead + 2] << 8 & 0xFF00;
            this.crtPosRead += 4;
            return n |= this.msgData[this.crtPosRead + 3] << 0 & 0xFF;
        }
        throw new Exception("Error retrieve int from current data");
    }

    public void addByteArray(byte by, int n, byte[] byArray) throws Exception {
        if (this.msgData != null && this.crtPosWrite < this.msgData.length - by) {
            this.msgData[this.crtPosWrite++] = by;
            System.arraycopy(byArray, n, this.msgData, this.crtPosWrite, by);
            this.crtPosWrite += by;
        } else {
            throw new Exception("Error adding byte array to current data");
        }
    }

    public byte[] getByteArray() throws Exception {
        byte by = 0;
        if (this.msgData == null || this.crtPosRead >= this.crtPosWrite) {
            throw new Exception("Error getting byte array size from current data");
        }
        by = this.msgData[this.crtPosRead++];
        if (this.crtPosRead < this.crtPosWrite - by + 1) {
            byte[] byArray = new byte[by];
            System.arraycopy(this.msgData, this.crtPosRead, byArray, 0, by);
            this.crtPosRead += by;
            return byArray;
        }
        throw new Exception("Error adding byte array to current data");
    }

    public byte[] getByteArray(int n, byte[] byArray) throws Exception {
        byte by = 0;
        if (this.msgData == null || this.crtPosRead >= this.crtPosWrite) {
            throw new Exception("Error getting byte array size from current data");
        }
        by = this.msgData[this.crtPosRead++];
        if (this.crtPosRead < this.crtPosWrite - by + 1) {
            System.arraycopy(this.msgData, this.crtPosRead, byArray, n, by);
            this.crtPosRead += by;
            return byArray;
        }
        throw new Exception("Error adding byte array to current data");
    }

    public void addString(String string) throws Exception {
        byte[] byArray = string.getBytes();
        if (byArray.length > 255) {
            throw new Exception("Error adding string to current data");
        }
        this.addByteArray((byte)byArray.length, 0, byArray);
    }

    public String getString() throws Exception {
        return new String(this.getByteArray());
    }

    public final boolean mpIsConnected() {
        return this.m_MPConnectLevel >= 1;
    }

    public final boolean mpIsLoggedIn() {
        return this.m_MPConnectLevel >= 2;
    }

    public final boolean mpIsInSession() {
        return this.m_MPConnectLevel >= 3;
    }

    public final boolean mpIsInGame() {
        return this.m_MPConnectLevel >= 5;
    }

    public final boolean mpIsMaster() {
        return this.m_MPConnectLevel == 4 || this.m_MPConnectLevel == 6;
    }

    public final boolean mpHasOpponnentFinished() {
        return this.m_MPHasOpponentFinished;
    }

    private boolean mpProcessIncomingMessages() {
        if (System.currentTimeMillis() - callstarttime > 7000L) {
            this.mpSendKeepAlive();
        }
        if (!this.wtcp.m_connected) {
            this.m_MPConnectLevel = 0;
            if (this.wtcp.m_bError) {
                this.lastErrorCode = -2;
            }
            return true;
        }
        this.m_data = this.wtcp.recvPacket();
        if (this.m_data == null) {
            if (!this.wtcp.m_connected) {
                this.m_MPConnectLevel = 0;
                if (this.wtcp.m_bError) {
                    this.lastErrorCode = -2;
                }
            }
            return false;
        }
        this.setData(this.m_data);
        try {
            this.m_type = this.getByte();
            this.m_subtype = 0;
            switch (this.m_type) {
                case 115: {
                    this.m_subtype = this.getByte();
                    switch (this.m_subtype) {
                        case 101: 
                        case 115: 
                        case 120: {
                            return true;
                        }
                    }
                    throw new Exception("Unknown message type");
                }
                case 103: {
                    this.m_subtype = this.getByte();
                    switch (this.m_subtype) {
                        case 114: {
                            return true;
                        }
                        case 112: {
                            this.mpProcessPushMessages();
                            return false;
                        }
                        case 103: 
                        case 104: {
                            this.incomingGameData.addElement(this.m_data);
                            return false;
                        }
                        case 97: {
                            return false;
                        }
                    }
                    throw new Exception("Unknown message type");
                }
            }
            throw new Exception("Unknown message type");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void mpProcessPushMessages() throws Exception {
        if (!this.mpIsInSession()) {
            return;
        }
        int n = 0;
        byte by = this.getByte();
        switch (by) {
            case 107: {
                this.m_MPConnectLevel = (byte)2;
                break;
            }
            case 108: {
                int n2;
                String string = this.getString();
                for (n2 = 0; n2 < this.m_lNameList.length && !string.toLowerCase().equals(this.m_lNameList[n2].toLowerCase()); ++n2) {
                }
                if (n2 == this.m_lNameList.length) {
                    return;
                }
                String[] stringArray = new String[this.m_lNameList.length - 1];
                byte[] byArray = new byte[this.m_lNameList.length - 1];
                int n3 = 0;
                int n4 = 0;
                while (n3 < this.m_lNameList.length) {
                    if (n3 == n2) {
                        ++n3;
                        continue;
                    }
                    stringArray[n4] = this.m_lNameList[n3];
                    byArray[n4] = this.m_lByteDataList[n3];
                    ++n3;
                    ++n4;
                }
                this.m_lNameList = stringArray;
                this.m_lByteDataList = byArray;
                this.noitems = (byte)this.m_lNameList.length;
                break;
            }
            case 106: {
                byte by2 = this.getByte();
                String string = this.getString();
                n = this.m_lNameList != null ? this.m_lNameList.length + 1 : 1;
                String[] stringArray = new String[n];
                byte[] byArray = new byte[n];
                for (int i = 0; i < n - 1; ++i) {
                    stringArray[i] = this.m_lNameList[i];
                    byArray[i] = this.m_lByteDataList[i];
                }
                stringArray[i] = string;
                byArray[i] = by2;
                this.m_lNameList = stringArray;
                this.m_lByteDataList = byArray;
                this.noitems = (byte)this.m_lNameList.length;
                break;
            }
            case 115: {
                if (this.m_MPConnectLevel == 4) break;
                int n5 = this.getByte();
                this.m_lNameList = new String[n5];
                this.m_lByteDataList = new byte[n5];
                for (int i = 0; i < n5; ++i) {
                    this.m_lNameList[i] = this.getString();
                    this.m_lByteDataList[i] = (byte)(i + 1);
                }
                this.noitems = (byte)this.m_lNameList.length;
                if (this.m_MPConnectLevel == 3) {
                    this.m_MPConnectLevel = (byte)5;
                    this.m_MPHasOpponentFinished = false;
                } else {
                    this.lastErrorCode = 51;
                }
                this.incomingGameData = new Vector();
                break;
            }
            case 102: {
                this.m_MPHasOpponentFinished = true;
            }
        }
    }

    private void mpPrepareGameRequest(byte by) throws Exception {
        this.clearData();
        this.addByte((byte)103);
        this.addByte((byte)114);
        this.addByte(by);
    }

    public void mpPrepareGameData() throws Exception {
        if (!this.mpIsInGame()) {
            this.lastErrorCode = 50;
            return;
        }
        this.lastErrorCode = -1;
        this.clearData();
        this.addByte((byte)103);
        this.addByte((byte)103);
    }

    public void mpSendGameData() {
        if (!this.mpIsInGame() || this.lastErrorCode != -1) {
            this.lastErrorCode = 50;
            return;
        }
        this.lastErrorCode = 0;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleGameData() throws Exception {
        this.isGameMessageInQueue = false;
        if (!this.mpIsInGame()) {
            this.lastErrorCode = 50;
            return;
        }
        if (this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.incomingGameData.size() > 0) {
            this.m_data = (byte[])this.incomingGameData.firstElement();
            this.incomingGameData.removeElementAt(0);
            this.isGameMessageInQueue = true;
        } else {
            this.m_data = null;
        }
    }

    public void mpSendDisconnect() {
        this.clearData();
        try {
            this.addByte((byte)115);
            this.addByte((byte)120);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleDisconnect() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type == 115 && this.m_subtype == 120) {
            this.mpDisconnect();
        }
        this.lastErrorCode = 0;
    }

    public void mpDisconnect() {
        this.wtcp.disconnect();
        this.m_MPConnectLevel = 0;
    }

    public void mpHandleUpdates() {
        this.mpProcessIncomingMessages();
    }

    public void mpSendEstablishConnection() {
        if (this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        int n = new Random().nextInt();
        this.wtcp.connect();
        this.clearData();
        try {
            this.addByte((byte)115);
            this.addByte((byte)114);
            this.addInt(n);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        this.clearData();
        try {
            this.addByte((byte)115);
            this.addByte((byte)119);
            this.addInt(n);
        }
        catch (Exception exception) {
            return;
        }
        this.wtcp.sendEstablishConnectionPackageOnReceive(this.getData());
    }

    public void mpHandleEstablishConnection() {
        if (this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type == 115) {
            switch (this.m_subtype) {
                case 115: {
                    this.m_MPConnectLevel = 1;
                    this.lastErrorCode = 0;
                    break;
                }
                case 101: {
                    this.m_MPConnectLevel = 0;
                    this.lastErrorCode = -2;
                }
            }
        }
    }

    public void mpSendLogin() {
        if (!this.mpIsConnected() || this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)105);
            this.addString("" + GGI + "-" + this.uid);
            this.addInt(0);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpSendLogin(String string) {
        if (!this.mpIsConnected() || this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)105);
            this.addString("" + GGI + "-" + this.uid);
            this.addString(string);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleLogin() {
        if (!this.mpIsConnected() || this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 105) {
                this.lastErrorCode = 51;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                this.m_MPConnectLevel = (byte)2;
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 3;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendQuickGame() {
        if (!this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)117);
        }
        catch (Exception exception) {
            return;
        }
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.nosessionsbase = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpSendListSession(byte by, byte by2) {
        if (!this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.noitems = by;
            this.nosessionsbase = by2;
            if (this.noitems <= 0) {
                this.noitems = 1;
            }
            if (this.nosessionsbase < 0) {
                this.nosessionsbase = 0;
            }
            this.mpPrepareGameRequest((byte)108);
            this.addByte(this.noitems);
            this.addInt(this.nosessionsbase);
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
            return;
        }
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleListSession() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (!this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 117 && by != 108) {
                this.lastErrorCode = 51;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                this.noitems = this.getByte();
                this.nosessionsbase = this.getInt();
                if (this.noitems > 0) {
                    int n;
                    this.m_lNameList = new String[this.noitems];
                    this.m_lByteDataList = new byte[this.noitems];
                    this.m_lBinaryDataList = new String[this.noitems];
                    for (n = 0; n < this.noitems; ++n) {
                        this.m_lNameList[n] = this.getString();
                        this.m_lByteDataList[n] = this.getByte();
                    }
                    for (n = 0; n < this.noitems; ++n) {
                        try {
                            this.m_lBinaryDataList[n] = this.getString();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 3;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendCreateSession(String string, String string2) {
        if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)99);
            this.addString(string);
            if (string2 != null) {
                this.addString(string2);
            }
        }
        catch (Exception exception) {
            return;
        }
        this.currentsessionname = string;
        this.currentsessiondata = string2;
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleCreateSession() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 99) {
                this.lastErrorCode = 51;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                this.m_MPConnectLevel = (byte)4;
                this.noitems = 1;
                this.m_lNameList = new String[this.noitems];
                this.m_lByteDataList = new byte[this.noitems];
                for (int i = 0; i < this.noitems; ++i) {
                    this.m_lNameList[i] = this.username;
                    this.m_lByteDataList[i] = 1;
                }
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 54;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendJoinSession(String string) {
        if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)106);
            this.addString(string);
        }
        catch (Exception exception) {
            return;
        }
        this.currentsessionname = string;
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleJoinSession() {
        block11: {
            if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
                this.lastErrorCode = 50;
                return;
            }
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 106) {
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.m_MPConnectLevel = (byte)3;
                    this.lastErrorCode = 0;
                    this.noitems = this.getByte();
                    this.m_lNameList = new String[this.noitems];
                    this.m_lByteDataList = new byte[this.noitems];
                    for (int i = 0; i < this.noitems; ++i) {
                        this.m_lNameList[i] = this.getString();
                        this.m_lByteDataList[i] = (byte)(i + 1);
                    }
                    this.currentsessiondata = null;
                    try {
                        this.currentsessiondata = this.getString();
                        if (this.currentsessiondata.length() == 0) {
                            this.currentsessiondata = null;
                        }
                        break block11;
                    }
                    catch (Exception exception) {}
                    break block11;
                }
                this.lastErrorCode = 54;
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
            }
        }
    }

    public void mpSendLeaveSession() {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)113);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleLeaveSession() {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 113) {
                this.lastErrorCode = 51;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                this.m_MPConnectLevel = (byte)2;
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 3;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendKickOutPlayer(String string) {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)107);
            this.addString(string);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleKickOutPlayer(String string) {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 107) {
                this.lastErrorCode = 51;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                int n;
                boolean bl = false;
                for (n = 0; n < this.m_lNameList.length && !string.toLowerCase().equals(this.m_lNameList[n].toLowerCase()); ++n) {
                }
                if (n == this.m_lNameList.length) {
                    this.lastErrorCode = 0;
                    return;
                }
                String[] stringArray = new String[this.m_lNameList.length - 1];
                byte[] byArray = new byte[this.m_lNameList.length - 1];
                int n2 = 0;
                int n3 = 0;
                while (n2 < this.m_lNameList.length) {
                    if (n2 == n) {
                        ++n2;
                        continue;
                    }
                    stringArray[n3] = this.m_lNameList[n2];
                    byArray[n3] = this.m_lByteDataList[n2];
                    ++n2;
                    ++n3;
                }
                this.m_lNameList = stringArray;
                this.m_lByteDataList = byArray;
                this.noitems = (byte)this.m_lNameList.length;
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 3;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendStartGame() {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)115);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleStartGame() {
        byte by;
        if (this.mpIsInGame()) {
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                by = this.getByte();
                if (by != 115) {
                    this.lastErrorCode = 51;
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            this.lastErrorCode = 0;
            this.incomingGameData = new Vector();
        }
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            by = this.getByte();
            if (by != 115) {
                this.lastErrorCode = 51;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                if (this.m_MPConnectLevel == 3) {
                    this.m_MPConnectLevel = (byte)5;
                } else if (this.m_MPConnectLevel == 4) {
                    this.m_MPConnectLevel = (byte)6;
                }
                this.m_MPHasOpponentFinished = false;
                this.noitems = this.getByte();
                this.m_lNameList = new String[this.noitems];
                this.m_lByteDataList = new byte[this.noitems];
                for (int i = 0; i < this.noitems; ++i) {
                    this.m_lNameList[i] = this.getString();
                    this.m_lByteDataList[i] = (byte)(i + 1);
                }
                this.incomingGameData = new Vector();
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 54;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendFinishGame() {
        if (!this.mpIsInGame()) {
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)102);
        }
        catch (Exception exception) {
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleFinishGame() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 102) {
                this.lastErrorCode = 51;
            }
            if ((by = this.getByte()) == 115) {
                this.m_MPConnectLevel = (byte)2;
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 54;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendFindPlayer(String string) {
        if (!this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)119);
            this.addString(string);
        }
        catch (Exception exception) {
            return;
        }
        this.found_player_session_name = null;
        this.found_player_session_number_of_players = (byte)-1;
        this.found_player_status = (byte)-1;
        this.found_player_name = string;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleFindPlayer() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 119) {
                this.lastErrorCode = 40;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                this.found_player_status = this.getByte();
                if (this.found_player_status == 115 || this.found_player_status == 112) {
                    this.found_player_session_name = this.getString();
                    this.found_player_session_number_of_players = this.getByte();
                }
                this.lastErrorCode = 0;
            } else {
                this.lastErrorCode = 54;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    public void mpSendGetPlayerData(String string) {
        if (!this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)121);
            this.addString(string);
        }
        catch (Exception exception) {
            return;
        }
        this.requested_player_data = null;
        this.requested_player_nickname = string;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleGetPlayerData() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type != 103 || this.m_subtype != 114) {
            return;
        }
        try {
            byte by = this.getByte();
            if (by != 121) {
                this.lastErrorCode = 40;
                return;
            }
            by = this.getByte();
            if (by == 115) {
                by = this.getByte();
                if (by == 104) {
                    this.requested_player_data = this.getString();
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = by == 100 ? 0 : 40;
                }
            } else {
                this.lastErrorCode = 54;
            }
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
        }
    }

    private boolean mpSendKeepAlive() {
        try {
            this.clearData();
            this.addByte((byte)103);
            this.addByte((byte)97);
            this.wtcp.sendPacket(this.getData());
            callstarttime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String[] getNameList() {
        return this.m_lNameList;
    }

    public String[] getDataList() {
        return this.m_lBinaryDataList;
    }

    public byte[] getByteDataList() {
        return this.m_lByteDataList;
    }

    public String getSessionName() {
        return this.currentsessionname;
    }

    public String getSessionData() {
        return this.currentsessiondata;
    }

    public int getNumberOfItems() {
        return this.noitems;
    }

    public int getFirstSessionIndex() {
        return this.nosessionsbase;
    }

    public String getFoundPlayerName() {
        return this.found_player_name;
    }

    public byte getFoundPlayerStatus() {
        return this.found_player_status;
    }

    public String getFoundPlayerSessionName() {
        return this.found_player_session_name;
    }

    public byte getFoundPlayerSessionNumberOfPlayers() {
        return this.found_player_session_number_of_players;
    }

    public String getRequestedPlayerData() {
        return this.requested_player_data;
    }

    public String getRequestedPlayerNickname() {
        return this.requested_player_nickname;
    }

    public void sendGetItemList(int n, String string) {
        String string2;
        this.whttp.cancel();
        String string3 = string != null ? "f|" + n + "|i|" + GGI + "|u|" + this.uid + "|p|" + string + "|" : "f|" + n + "|i|" + GGI + "|u|" + this.uid + "|";
        string3 = string2 = this.String2Blob(string3);
        this.lastErrorCode = -100;
        this.whttp.sendByGet(this.urlDownload, string3);
    }

    public void handleGetItemList() {
        if (this.whttp.isInProgress()) {
            return;
        }
        if (this.whttp.isErrorOccurred()) {
            return;
        }
        if (this.whttp.m_response != null) {
            this.initDownloadItems(this.whttp.m_response);
        }
    }

    private void clearDownloadItems() {
        for (int i = 0; i < 128; ++i) {
            this.dlName[i] = null;
            this.dlMenuId[i] = null;
            this.dlSize[i] = 0;
            this.dlPrice[i] = 0;
        }
        this.dlTotalItems = 0;
    }

    private boolean initDownloadItems(String string) {
        this.clearDownloadItems();
        String string2 = this.getValue(string, 1);
        if (Integer.parseInt(string2) == 1) {
            this.lastErrorCode = 31;
            return false;
        }
        if (Integer.parseInt(string2) != 3) {
            this.lastErrorCode = 32;
            return false;
        }
        string2 = this.getValue(string, 2);
        this.dlTotalItems = Integer.parseInt(string2);
        if (this.dlTotalItems == 0) {
            this.lastErrorCode = 32;
            return false;
        }
        int n = 3;
        for (int i = 0; i < this.dlTotalItems; ++i) {
            this.dlMenuId[i] = (string2 = this.getValue(string, n++)).length() != 0 ? string2 : null;
            string2 = this.getValue(string, n++);
            this.dlPrice[i] = Integer.parseInt(string2);
            string2 = this.getValue(string, n++);
            this.dlName[i] = string2.length() != 0 ? string2 : null;
            string2 = this.getValue(string, n++);
            this.dlSize[i] = Integer.parseInt(string2);
        }
        this.lastErrorCode = 0;
        return true;
    }

    public int getDownloadItemsNumber() {
        return this.dlTotalItems;
    }

    public String getDownloadItemMenuId(int n) {
        return this.dlMenuId[n];
    }

    public int getDownloadItemPrice(int n) {
        return this.dlPrice[n];
    }

    public String getDownloadItemName(int n) {
        return this.dlName[n];
    }

    public int getDownloadItemSize(int n) {
        return this.dlSize[n];
    }

    public void sendGetItem(String string) {
        this.whttp.cancel();
        if (string == null) {
            return;
        }
        String string2 = "f|5|i|" + GGI + "|u|" + this.uid + "|p|" + string + "|";
        string2 = this.String2Blob(string2);
        this.lastErrorCode = -100;
        this.whttp.sendByGet(this.urlDownload, string2);
    }

    public void handleGetItem() {
        if (this.whttp.isInProgress()) {
            return;
        }
        if (this.whttp.isErrorOccurred()) {
            return;
        }
        if (this.whttp.m_response != null) {
            this.initDownloadData(this.whttp);
        }
    }

    private void initDownloadData(HTTP hTTP) {
        this.dlItemData = hTTP.m_response.getBytes();
        this.lastErrorCode = 0;
    }

    public byte[] getItemData() {
        return this.dlItemData;
    }

    static {
        changeScreenMode = false;
    }

    static interface ConnectLevel {
        public static final byte NOT_CONNECTED = 0;
        public static final byte NOT_LOGGED_IN = 1;
        public static final byte IN_CONNECTED = 2;
        public static final byte IN_SESSION = 3;
        public static final byte IN_SESSION_MASTER = 4;
        public static final byte IN_GAME = 5;
        public static final byte IN_GAME_MASTER = 6;
    }

    public static interface MessageType {
        public static final byte BASIC_MESSAGE_TYPE_UNKNOWN = 0;
        public static final byte BASIC_MESSAGE_TYPE_GAME = 103;
        public static final byte BASIC_MESSAGE_TYPE_CONNECT = 115;
        public static final byte CONNECT_MESSAGE_INIT_WRITE = 119;
        public static final byte CONNECT_MESSAGE_INIT_READ = 114;
        public static final byte CONNECT_MESSAGE_SUCCESS = 115;
        public static final byte CONNECT_MESSAGE_ERROR = 101;
        public static final byte CONNECT_MESSAGE_DISCONNECT = 120;
        public static final byte GAME_MESSAGE_REQUEST = 114;
        public static final byte GAME_MESSAGE_PUSH = 112;
        public static final byte GAME_MESSAGE_IN_GAME = 103;
        public static final byte GAME_MESSAGE_IN_GAME_TOALL = 104;
        public static final byte GAME_MESSAGE_ERROR = 101;
        public static final byte GAME_MESSAGE_KEEP_ALIVE = 97;
        public static final byte REQUEST_MESSAGE_LOGIN = 105;
        public static final byte REQUEST_MESSAGE_CREATE_SESSION = 99;
        public static final byte REQUEST_MESSAGE_LIST_SESSIONS = 108;
        public static final byte REQUEST_MESSAGE_GET_QUICK_SESSION = 117;
        public static final byte REQUEST_MESSAGE_JOIN_SESSION = 106;
        public static final byte REQUEST_MESSAGE_LEAVE_SESSION = 113;
        public static final byte REQUEST_MESSAGE_KICK_OUT_PLAYER = 107;
        public static final byte REQUEST_MESSAGE_START_GAME = 115;
        public static final byte REQUEST_MESSAGE_FINISH_GAME = 102;
        public static final byte REQUEST_MESSAGE_GET_PLAYER_INFO = 119;
        public static final byte REQUEST_MESSAGE_GET_PLAYER_DATA = 121;
        public static final byte RESPONSE_MESSAGE_SUCCESS = 115;
        public static final byte RESPONSE_MESSAGE_ERROR = 101;
        public static final byte ERROR_INVALID_INPUT = 105;
        public static final byte ERROR_NO_SESSION = 115;
        public static final byte ERROR_SESSION_CLOSED = 99;
        public static final byte ERROR_NOT_MASTER = 109;
        public static final byte ERROR_LOGIN_NICKNAME_USED = 110;
        public static final byte ERROR_LOGIN_INVALID_NICKNAME = 113;
        public static final byte ERROR_LOGIN_AUTHENTICATION_FAILED = 97;
        public static final byte ERROR_CREATE_SESSION_INVALID_NAME = 118;
        public static final byte ERROR_CREATE_SESSION_NAME_USED = 117;
        public static final byte ERROR_BLOCKED_SESSION = 98;
        public static final byte ERROR_LIST_SESSION_INVALID_INDEX = 108;
        public static final byte ERROR_JOIN_SESSION_TOO_MANY_PLAYERS = 106;
        public static final byte ERROR_NO_PLAYER = 107;
        public static final byte ERROR_KICK_OUT_PLAYER_IS_MASTER = 100;
        public static final byte ERROR_START_GAME_NOT_ENOUGH_PLAYERS = 103;
        public static final byte PUSH_MESSAGE_JOIN_SESSION = 106;
        public static final byte PUSH_MESSAGE_LEAVE_SESSION = 108;
        public static final byte PUSH_MESSAGE_KICK_OUT = 107;
        public static final byte PUSH_MESSAGE_START_GAME = 115;
        public static final byte PUSH_MESSAGE_FINISH_GAME = 102;
        public static final byte PLAYER_STATUS_NOT_REGISTERED = 110;
        public static final byte PLAYER_STATUS_OFFLINE = 102;
        public static final byte PLAYER_STATUS_ONLINE = 111;
        public static final byte PLAYER_STATUS_ONLINE_IN_SESSION = 115;
        public static final byte PLAYER_STATUS_ONLINE_PLAYING = 112;
        public static final byte PLAYER_STATUS_HAS_PSD = 104;
        public static final byte PLAYER_STATUS_HAS_NO_PSD = 100;
    }

    public static interface Error {
        public static final int ERROR_INIT = -100;
        public static final byte ERROR_NOT_M7_ENABLED = -3;
        public static final byte ERROR_CONNECTION = -2;
        public static final byte ERROR_PENDING = -1;
        public static final byte ERROR_NONE = 0;
        public static final byte ERROR_NO_UUID = 1;
        public static final byte ERROR_NO_NICKNAME = 2;
        public static final byte ERROR_REGISTER_FAILED = 3;
        public static final byte ERROR_NOT_REGISTERED = 4;
        public static final byte ERROR_NICK_TAKEN = 5;
        public static final byte ERROR_SCORE_UPLOAD_FAILED = 21;
        public static final byte ERROR_GET_RANKINGS_FAILED = 22;
        public static final byte ERROR_RATE_GAME_FAILED = 23;
        public static final byte ERROR_RECOMMEND_GAME_FAILED = 24;
        public static final byte ERROR_NO_PHONE_NUMBER = 25;
        public static final byte ERROR_NO_CLIENT_ID = 26;
        public static final byte ERROR_INVALID_GGI = 27;
        public static final byte ERROR_GET_STATS_FAILED = 29;
        public static final byte ERROR_SUPPLEMENTAL_DATA_NEEDED = 31;
        public static final byte ERROR_VALIDATE_LICENSE_FAILED = 32;
        public static final byte ERROR_CHANGE_USERNAME_FAILED = 33;
        public static final byte ERROR_BAD_RESPONSE = 40;
        public static final byte ERROR_WRONGFULL_QSTATE = 50;
        public static final byte ERROR_WRONGFULL_RSTATE = 51;
        public static final byte ERROR_START_GAME = 52;
        public static final byte ERROR_JOIN_GAME = 53;
        public static final byte ERROR_REQUEST_FAILED = 54;
        public static final byte ERROR_DOWNLOAD_FILE_NOT_FOUND = 30;
        public static final byte ERROR_DOWNLOAD_LIST_NO_FILES = 31;
        public static final byte ERROR_DOWNLOAD_FAILED = 32;
        public static final byte ERROR_DOWNLOAD_NO_SPACE = 33;
    }

    public static interface Configuration {
        public static final int XPLAYER_VERSION = 1;
        public static final boolean HX_DEBUG = false;
        public static final boolean ENABLE_DEBUG = true;
        public static final boolean ENABLE_TIMEOUT = false;
        public static final int CONN_TIMEOUT = 30000;
        public static final boolean HTTP_NO_CANCEL = false;
        public static final boolean USE_HTTP_POST = false;
        public static final boolean FULLSCREEN_CHANGE = false;
        public static final boolean CARRIER_USSPRINT = false;
        public static final boolean CARRIER_USNEXTEL = false;
        public static final boolean CARRIER_USCINGULAR_ORANGE = false;
        public static final boolean CARRIER_USCINGULAR_BLUE = false;
        public static final boolean CARRIER_USVIRGIN = false;
        public static final boolean ENABLE_M7_SUPPORT = false;
        public static final boolean CARRIER_MXTELCEL = false;
        public static final boolean ENABLE_MULTIPLAYER = false;
        public static final boolean ENABLE_DUAL_TCP = false;
        public static final boolean ENABLE_READ_COMMUNICATION_SUPPORT = false;
        public static final boolean ENABLE_PLAYER_SPECIFIC_DATA = false;
        public static final boolean ENABLE_FIND_PLAYER = true;
        public static final int KEEP_ALIVE_TIME = 7000;
        public static final boolean ENABLE_PURE_XPLAYER = true;
    }
}

