/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ATileSet {
    private Image m_tileSetImg;
    private byte[] m_tileMap_data;
    private byte[] m_tileMap_flip;
    private int m_numTilesW;
    private int m_numTilesH;
    private int m_mapW;
    private int m_mapH;
    private int m_DestW;
    private int m_DestHalfW;
    private int m_DestH;
    private int m_DestHalfH;
    private Image m_cb_img;
    private int m_cb_imgW;
    private int m_cb_imgH;
    private Graphics m_cb_graphics;
    private int m_firstTileX;
    private int m_firstTileY;
    private int m_lastTileX;
    private int m_lastTileY;
    private boolean m_useCBasBB;
    private int m_TileWidth;
    private int m_TileWidthShift;
    private int m_TileWidthMask;
    private int m_TileHeight;
    private int m_TileHeightShift;
    private int m_TileHeightMask;
    public int m_camX;
    public int m_camY;

    ATileSet(int n, int n2, int n3, int n4) {
        this.m_DestW = n;
        this.m_DestHalfW = this.m_DestW >> 1;
        this.m_DestH = n2;
        this.m_DestHalfH = this.m_DestH >> 1;
        this.m_TileWidthShift = n3;
        this.m_TileHeightShift = n4;
        this.m_TileWidth = 1 << this.m_TileWidthShift;
        this.m_TileHeight = 1 << this.m_TileHeightShift;
        this.m_TileWidthMask = this.m_TileWidth - 1;
        this.m_TileHeightMask = this.m_TileHeight - 1;
        this.m_camX = this.m_DestHalfW;
        this.m_camY = this.m_DestHalfH;
    }

    void Init(int n, int n2, byte[] byArray, byte[] byArray2, Image image) {
        try {
            this.m_numTilesW = n;
            this.m_numTilesH = n2;
            this.m_tileMap_data = byArray;
            this.m_tileMap_flip = byArray2;
            this.m_mapW = this.m_numTilesW * this.m_TileWidth;
            this.m_mapH = this.m_numTilesH * this.m_TileHeight;
            this.m_tileSetImg = image;
            this.m_cb_imgW = (this.m_DestW & ~this.m_TileWidthMask) + 1 * this.m_TileWidth;
            this.m_cb_imgH = (this.m_DestH & ~this.m_TileHeightMask) + 1 * this.m_TileHeight;
            this.m_cb_img = Image.createImage((int)this.m_cb_imgW, (int)this.m_cb_imgH);
            this.m_cb_graphics = this.m_cb_img.getGraphics();
            this.m_firstTileX = -1;
            this.m_firstTileY = -1;
            this.m_lastTileX = -1;
            this.m_lastTileY = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void Destroy() {
        this.m_tileSetImg = null;
        this.m_cb_img = null;
        this.m_cb_graphics = null;
        this.m_tileMap_data = null;
        this.m_tileMap_flip = null;
    }

    void Draw(Graphics graphics) {
        if (this.m_useCBasBB) {
            return;
        }
        int n = this.m_camX - this.m_DestHalfW;
        int n2 = this.m_camY - this.m_DestHalfH;
        int n3 = n % this.m_cb_imgW;
        int n4 = n2 % this.m_cb_imgH;
        int n5 = (n + this.m_DestW) % this.m_cb_imgW;
        int n6 = (n2 + this.m_DestH) % this.m_cb_imgH;
        if (n5 > n3) {
            if (n6 > n4) {
                this.Draw2Screen(graphics, n3, n4, this.m_DestW, this.m_DestH, 0, 0);
            } else {
                this.Draw2Screen(graphics, n3, n4, this.m_DestW, this.m_DestH - n6, 0, 0);
                this.Draw2Screen(graphics, n3, 0, this.m_DestW, n6, 0, this.m_DestH - n6);
            }
        } else if (n6 > n4) {
            this.Draw2Screen(graphics, n3, n4, this.m_DestW - n5, this.m_DestH, 0, 0);
            this.Draw2Screen(graphics, 0, n4, n5, this.m_DestH, this.m_DestW - n5, 0);
        } else {
            this.Draw2Screen(graphics, n3, n4, this.m_DestW - n5, this.m_DestH - n6, 0, 0);
            this.Draw2Screen(graphics, n3, 0, this.m_DestW - n5, n6, 0, this.m_DestH - n6);
            this.Draw2Screen(graphics, 0, n4, n5, this.m_DestH - n6, this.m_DestW - n5, 0);
            this.Draw2Screen(graphics, 0, 0, n5, n6, this.m_DestW - n5, this.m_DestH - n6);
        }
        graphics.setClip(0, 0, this.m_DestW, this.m_DestH);
    }

    void Draw2Screen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(n5, n6, n3, n4);
        graphics.drawImage(this.m_cb_img, n5 - n, n6 - n2, 0);
    }

    void Update() {
        int n;
        int n2;
        if (this.m_useCBasBB) {
            return;
        }
        if (this.m_camX - this.m_DestHalfW < 0) {
            this.m_camX = this.m_DestHalfW;
        } else if (this.m_camX + this.m_DestHalfW > this.m_mapW) {
            this.m_camX = this.m_mapW - this.m_DestHalfW;
        }
        if (this.m_camY - this.m_DestHalfH < 0) {
            this.m_camY = this.m_DestHalfH;
        } else if (this.m_camY + this.m_DestHalfH > this.m_mapH) {
            this.m_camY = this.m_mapH - this.m_DestHalfH;
        }
        int n3 = this.m_camX - this.m_DestHalfW;
        int n4 = this.m_camY - this.m_DestHalfH;
        int n5 = n3 >> this.m_TileWidthShift;
        int n6 = n4 >> this.m_TileHeightShift;
        int n7 = n3 + this.m_DestW >> this.m_TileWidthShift;
        int n8 = n4 + this.m_DestH >> this.m_TileHeightShift;
        if (this.m_firstTileX != n5 || this.m_lastTileX != n7) {
            if (this.m_firstTileX < n5 || this.m_lastTileX < n7) {
                n2 = this.m_lastTileX + 1;
                n = n7;
            } else {
                n2 = n5;
                n = this.m_firstTileX - 1;
            }
            this.UpdateBuffer(n2, n6, n, n8);
            this.m_firstTileX = n5;
            this.m_lastTileX = n7;
        }
        if (this.m_firstTileY != n6 || this.m_lastTileY != n8) {
            if (this.m_firstTileY < n6 || this.m_lastTileY < n8) {
                n2 = this.m_lastTileY + 1;
                n = n8;
            } else {
                n2 = n6;
                n = this.m_firstTileY - 1;
            }
            this.UpdateBuffer(n5, n2, n7, n);
            this.m_firstTileY = n6;
            this.m_lastTileY = n8;
        }
    }

    void UpdateBuffer(int n, int n2, int n3, int n4) {
        int n5 = n2 * this.m_numTilesW + n;
        int n6 = this.m_numTilesW - 1 - n3 + n;
        int n7 = (n << this.m_TileWidthShift) % this.m_cb_imgW;
        int n8 = (n2 << this.m_TileHeightShift) % this.m_cb_imgH;
        if (this.m_useCBasBB) {
            n8 = 0;
            n7 = 0;
        }
        for (int i = n2; i <= n4; ++i) {
            int n9 = n7;
            for (int j = n; j <= n3; ++j) {
                int n10 = n5 << 1;
                if (n10 + 1 >= this.m_tileMap_data.length) continue;
                byte by = this.m_tileMap_data[n10];
                byte by2 = this.m_tileMap_data[n10 + 1];
                int n11 = 2;
                int n12 = by << this.m_TileWidthShift;
                int n13 = by2 << this.m_TileHeightShift;
                this.m_cb_graphics.setClip(n9, n8, this.m_TileWidth, this.m_TileHeight);
                if (n11 == 0) {
                    this.m_cb_graphics.drawImage(this.m_tileSetImg, n9 - n12, n8 - n13, 0);
                } else {
                    this.m_cb_graphics.drawRegion(this.m_tileSetImg, n12, n13, this.m_TileWidth, this.m_TileHeight, n11, n9, n8, 0);
                }
                if ((n9 += this.m_TileWidth) >= this.m_cb_imgW) {
                    n9 -= this.m_cb_imgW;
                }
                ++n5;
            }
            n5 += n6;
            if ((n8 += this.m_TileHeight) < this.m_cb_imgH) continue;
            n8 -= this.m_cb_imgH;
        }
    }

    void ToggleCBandBB() {
        this.m_useCBasBB = !this.m_useCBasBB;
        int n = this.m_camX - this.m_DestHalfW;
        int n2 = this.m_camY - this.m_DestHalfH;
        int n3 = n >> this.m_TileWidthShift;
        int n4 = n2 >> this.m_TileHeightShift;
        int n5 = n + this.m_DestW >> this.m_TileWidthShift;
        int n6 = n2 + this.m_DestH >> this.m_TileHeightShift;
        this.UpdateBuffer(n3, n4, n5, n6);
    }
}

