/*
 * Decompiled with CFR 0.152.
 */
public class Util {
    public static int[] smTemp = new int[6];
    private static int[] smSinTable;
    public static long smSeed;
    public static int smRandomSeed;

    public static final int catmullRomSpline(int n) {
        int n2 = n * n >> 12;
        int n3 = n2 * n >> 12;
        int[] nArray = smTemp;
        return (((-nArray[0] + nArray[2]) * n >> 12) + (((nArray[0] << 1) - 5 * nArray[1] + (nArray[2] << 2) - nArray[3]) * n2 >> 12) + ((-nArray[0] + 3 * (nArray[1] - nArray[2]) + nArray[3]) * n3 >> 12) >> 1) + nArray[1];
    }

    public static final int lerp(int n, int n2, int n3) {
        if (n < n2) {
            return 0;
        }
        if (n > n3) {
            return 1024;
        }
        return (n - n2 << 10) / (n3 - n2);
    }

    public static final int smoothStep(int n, int n2, int n3) {
        int n4;
        int n5 = n3 - n2;
        if (n5 == 0) {
            n5 = 1;
        }
        if ((n4 = (n - n2 << 10) / n5) < 0) {
            return 0;
        }
        if (n4 > 1024) {
            return 1024;
        }
        return (n4 * n4 >> 10) * (3072 - (2048 * n4 >> 10)) >> 10;
    }

    public static final int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static final void initializeTables() {
        int n = 0;
        int n2 = 4096;
        if (smSinTable == null) {
            smSinTable = new int[1024];
            for (int i = 0; i < 1024; ++i) {
                Util.smSinTable[i] = n;
                n += (n2 -= n * 25 >> 12) * 25 >> 12;
            }
        }
    }

    public static final int getSin(int n) {
        return smSinTable[n & 0x3FF];
    }

    public static final int getCos(int n) {
        return smSinTable[n + 256 & 0x3FF];
    }

    public static int atan2(int n, int n2) {
        long l;
        long l2;
        if (n == 0) {
            n = 1;
        }
        long l3 = 0x20000000L;
        long l4 = 0x60000000L;
        long l5 = l2 = n < 0 ? (long)(-n) : (long)n;
        if (n2 >= 0) {
            long l6 = ((long)n2 - l2 << 32) / ((long)n2 + l2);
            l = l3 - (l3 * l6 >> 32);
        } else {
            long l7 = ((long)n2 + l2 << 32) / (l2 - (long)n2);
            l = l4 - (l3 * l7 >> 32);
        }
        if (n < 0) {
            l = -l;
        }
        return (int)((l >> 16) + 65536L) & 0xFFFF;
    }

    public static final void setSeed(long l) {
        smSeed = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public static final int getRandom() {
        smSeed = smSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(smSeed >>> 16) & 0xFFFFFF;
    }

    public static final int getRandom(int n) {
        smRandomSeed = -1644122275 * smRandomSeed + -1644122275;
        return n * (smRandomSeed & 0xFFFF) >>> 16;
    }

    public static int sqrtApproximate(int n, int n2) {
        n2 = Math.abs(n2);
        n = Math.abs(n);
        return Math.max(n, n2) + (Math.min(n, n2) * 53 >> 7);
    }

    public static final int getManhattanDistance(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return (n5 < 0 ? -n5 : n5) + (n6 < 0 ? -n6 : n6);
    }

    public static final boolean rectangleCollision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n2 + n4 > n6 && n2 < n6 + n8 && n + n3 > n5 && n < n5 + n7;
    }

    public static final int distanceLineToPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n4 - n2;
        int n9 = n7 < 0 ? -n7 : n7;
        int n10 = n8 < 0 ? -n8 : n8;
        int n11 = Math.max(n9, n10) + (Math.min(n9, n10) * 53 >> 7);
        int n12 = n - n5;
        int n13 = n2 - n6;
        int n14 = (n7 * n13 - n12 * n8) / n11;
        return n14 < 0 ? -n14 : n14;
    }

    public static int lerpColors(int n, int n2, int n3) {
        if (n3 <= 0) {
            return n;
        }
        if (n3 >= 255) {
            return n2;
        }
        int n4 = n >> 16;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 16;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        return Math.min(Math.max(n4 + ((n7 - n4) * n3 >> 8), 0), 255) << 16 | Math.min(Math.max(n5 + ((n8 - n5) * n3 >> 8), 0), 255) << 8 | Math.min(Math.max(n6 + ((n9 - n6) * n3 >> 8), 0), 255);
    }

    public static final int getCollisionBoxValue(SpriteObject spriteObject, int n, int n2) {
        if (n2 == 5) {
            return spriteObject.getCollisionBoxes().length;
        }
        CollisionBox collisionBox = spriteObject.getCollisionBox(n);
        if (n2 == 0) {
            return collisionBox.getId();
        }
        if (n2 == 1) {
            return collisionBox.getX();
        }
        if (n2 == 2) {
            return collisionBox.getY();
        }
        if (n2 == 3) {
            return collisionBox.getWidth();
        }
        return collisionBox.getHeight();
    }

    static {
        smRandomSeed = (int)System.currentTimeMillis();
    }
}

