/*
 * Decompiled with CFR 0.152.
 */
public class TimelineChannel {
    private int mType;
    private int[] mValue;
    private int[] mTime;
    private byte[] mMode;
    private int mDuration;

    public TimelineChannel(int n, int n2) {
        this.mType = n;
        this.mDuration = n2;
    }

    public int load(byte[] byArray, int n, boolean bl) {
        int n2 = byArray[n++] & 0xFF;
        this.mValue = new int[n2];
        this.mTime = new int[n2];
        this.mMode = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = (byArray[n++] & 0xFF) << 24;
            n3 |= (byArray[n++] & 0xFF) << 16;
            n3 |= (byArray[n++] & 0xFF) << 8;
            this.mTime[i] = n3 |= byArray[n++] & 0xFF;
            this.mMode[i] = byArray[n++];
            int n4 = -1;
            if (this.mType == 0 || this.mType == 3 || this.mType == 4) {
                n4 = (byArray[n++] & 0xFF) << 24;
                n4 |= (byArray[n++] & 0xFF) << 16;
                n4 |= (byArray[n++] & 0xFF) << 8;
                n4 |= byArray[n++] & 0xFF;
            } else if (this.mType == 1 || this.mType == 2) {
                n4 = bl ? byArray[n++] : (int)((short)(byArray[n++] << 8 | byArray[n++] & 0xFF));
            } else if (this.mType == 5) {
                n4 = (short)(byArray[n++] << 8 | byArray[n++] & 0xFF);
                n4 <<= 8;
            }
            this.mValue[i] = n4;
        }
        return n;
    }

    private int getIndexInTime(int n) {
        int n2 = this.mTime.length;
        while (--n2 >= 0) {
            if (n < this.mTime[n2]) continue;
            return n2;
        }
        return -1;
    }

    private int getNeutralValue() {
        if (this.mType == 0) {
            return -8355712;
        }
        if (this.mType == 3 || this.mType == 4) {
            return 1024;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getValue(int n, boolean bl) {
        if (this.mTime.length == 0) {
            return this.getNeutralValue();
        }
        int n2 = this.getIndexInTime(n);
        if (this.mMode[n2] == 1) {
            return this.mValue[n2];
        }
        n -= this.mTime[n2];
        int n3 = -1;
        int n4 = n2 + 1;
        if (n4 == this.mTime.length) {
            if (!bl) return this.mValue[n2];
            n4 = 0;
            n3 = this.mDuration - this.mTime[n2];
        } else {
            n3 = this.mTime[n4] - this.mTime[n2];
        }
        if (this.mMode[n2] != 0) return -1;
        if (this.mType != 0) return DavinciUtilities.interpolateValue(this.mValue[n2], this.mValue[n4], n, n3);
        return DavinciUtilities.interpolateColor(this.mValue[n2], this.mValue[n4], n, n3);
    }

    public int getEventCount() {
        return this.mTime.length;
    }
}

