/*
 * Decompiled with CFR 0.152.
 */
public class ObjectManager {
    public static GameObject[] smObjects = new GameObject[150];
    private static short smObjectCount;
    private static short smRotatingPointCount;
    public static boolean smBackgroundLayerObjectExists;

    public static final void initialize() {
        ObjectManager.reset();
    }

    public static final void reset() {
        GameObject.smIdStack = 1;
        smObjectCount = 0;
        smRotatingPointCount = 0;
        for (int n = 0; n < 150; n = (int)((short)(n + 1))) {
            ObjectManager.smObjects[n] = new GameObject();
        }
    }

    public static final void logicUpdate(int n) {
        boolean bl = false;
        boolean bl2 = false;
        for (short s = 0; s < smObjectCount; s = (short)(s + 1)) {
            if ((ObjectManager.smObjects[s].mBitmask & 1) == 0) {
                bl2 = true;
                continue;
            }
            smObjects[s].update(n);
        }
        if (bl2) {
            ObjectManager.removeDeadObjects();
        }
    }

    public static final GameObject addObject(byte by, int n, int n2) {
        if (smObjectCount >= 150) {
            return null;
        }
        if (by == 1) {
            smRotatingPointCount = (short)(smRotatingPointCount + 1);
        }
        short s = smObjectCount;
        smObjectCount = (short)(s + 1);
        smObjects[s].setProperties(by, n, n2);
        return smObjects[smObjectCount - 1];
    }

    public static final int getObjectCount() {
        return smObjectCount;
    }

    public static final GameObject[] getObjects() {
        return smObjects;
    }

    private static final void removeDeadObjects() {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if ((gameObject.mBitmask & 1) != 0) continue;
            smObjectCount = (short)(smObjectCount - 1);
            GameObject gameObject2 = smObjects[i];
            ObjectManager.smObjects[i] = smObjects[smObjectCount];
            ObjectManager.smObjects[ObjectManager.smObjectCount] = gameObject2;
            --i;
        }
    }

    public static final void collidePlayerWithItems(int n, int n2, int n3, int n4) {
        VisualEngine.smShadowClipXSmall = 0;
        VisualEngine.smShadowClipXMax = 0;
        VisualEngine.smPlayerShadowX = n + (n3 >> 1);
        VisualEngine.smPlayerShadowY = GameEngine.smLevelHeight;
        block6: for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.getBoolean(8)) continue;
            gameObject.getBoundingBox();
            switch (gameObject.mCollisionType) {
                case 0: {
                    if (gameObject.mType == 3 && n + n3 > GameObject.smBoundingBoxX && n < GameObject.smBoundingBoxX + GameObject.smBoundingBoxW && n2 < GameObject.smBoundingBoxY && VisualEngine.smPlayerShadowY > GameObject.smBoundingBoxY) {
                        VisualEngine.smShadowClipXSmall = GameObject.smBoundingBoxX;
                        VisualEngine.smShadowClipXMax = GameObject.smBoundingBoxX + GameObject.smBoundingBoxW;
                        VisualEngine.smPlayerShadowY = GameObject.smBoundingBoxY;
                    }
                    if (Util.rectangleCollision(n, n2, n3, n4, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH)) {
                        GameEngine.playerObjectCollision(gameObject);
                        continue block6;
                    }
                    if (GameEngine.smPlayerLastHoldRotatingDot != gameObject.mUniqueId) continue block6;
                    GameEngine.smPlayerLastHoldRotatingDot = -1;
                    continue block6;
                }
                case 1: {
                    int n5;
                    int n6;
                    int n7;
                    if (Util.rectangleCollision(n, n2, n3, n4, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH)) {
                        n7 = gameObject.mPosX >> 8;
                        n6 = gameObject.mPosY >> 8;
                        n5 = Util.sqrtApproximate(n7 - (n + (n3 >> 1)), n6 - (n2 + (n4 >> 1)));
                        if (n5 >= gameObject.mRadius + 12) continue block6;
                        GameEngine.playerObjectCollision(gameObject);
                        continue block6;
                    }
                    if (GameEngine.smPlayerLastHoldRotatingDot != gameObject.mUniqueId) continue block6;
                    GameEngine.smPlayerLastHoldRotatingDot = -1;
                    continue block6;
                }
                case 2: {
                    if (Util.rectangleCollision(n, n2, n3, n4, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH) && Util.distanceLineToPoint(gameObject.mPosX >> 8, gameObject.mPosY >> 8, gameObject.mWidth >> 8, gameObject.mHeight >> 8, n + (n3 >> 1), n2 + (n4 >> 1)) < n3) {
                        GameEngine.playerObjectCollision(gameObject);
                        continue block6;
                    }
                    if (GameEngine.smPlayerState != 0 || GameEngine.smPlayerLastHoldRotatingDot != gameObject.mUniqueId) continue block6;
                    GameEngine.smPlayerLastHoldRotatingDot = -1;
                    continue block6;
                }
                case 3: 
                case 4: {
                    int n5;
                    int n6;
                    int n7;
                    if (Util.rectangleCollision(n, n2, n3, n4, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH)) {
                        n7 = gameObject.mPosX >> 8;
                        n6 = gameObject.mPosY >> 8;
                        n5 = Util.sqrtApproximate(n7 - (n + (n3 >> 1)), n6 - (n2 + (n4 >> 1)));
                        if (n5 >= gameObject.mRadius + 12) continue block6;
                        GameEngine.playerObjectCollision(gameObject);
                        continue block6;
                    }
                    if (n2 >= GameObject.smBoundingBoxY + GameObject.smBoundingBoxH * 3 / 4 || n2 + n4 <= GameObject.smBoundingBoxY + GameObject.smBoundingBoxH / 4) continue block6;
                    if (gameObject.mCollisionType == 3) {
                        if (n >= GameObject.smBoundingBoxX) continue block6;
                        GameEngine.playerObjectCollision(gameObject);
                        continue block6;
                    }
                    if (gameObject.mCollisionType != 4 || n <= GameObject.smBoundingBoxX + GameObject.smBoundingBoxW) continue block6;
                    GameEngine.playerObjectCollision(gameObject);
                }
            }
        }
    }

    public static GameObject findNearestRotationPoint(int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 * n5;
        n3 >>= 8;
        n4 >>= 8;
        int n7 = Integer.MAX_VALUE;
        GameObject gameObject = null;
        for (int i = 0; i < smObjectCount; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            GameObject gameObject2 = smObjects[i];
            if (gameObject2.mType != 1 && gameObject2.mType != 13 && gameObject2.mType != 12 || gameObject2.getBoolean(8) || (n11 = (n10 = n - gameObject2.mPosX >> 8) * n3 + (n9 = n2 - gameObject2.mPosY >> 8) * n4) >= 0 || (n8 = n10 * n10 + n9 * n9) >= n6 || n8 >= n7) continue;
            gameObject = gameObject2;
            n7 = n8;
        }
        return gameObject;
    }

    public static GameObject findNearestRotationPoint(int n, int n2, GameObject gameObject) {
        int n3 = GameEngine.getWaterHeight();
        int n4 = Integer.MAX_VALUE;
        GameObject gameObject2 = null;
        for (int i = 0; i < smObjectCount; ++i) {
            int n5;
            GameObject gameObject3 = smObjects[i];
            if (gameObject3 == gameObject || gameObject3.mType != 1 && gameObject3.mType != 12 || gameObject3.getBoolean(8) || gameObject3.mPosY >> 8 >= n3 || (n5 = Util.sqrtApproximate(n - gameObject3.mPosX, n2 - gameObject3.mPosY)) >= n4) continue;
            gameObject2 = gameObject3;
            n4 = n5;
        }
        return gameObject2;
    }

    public static final GameObject collideObjectWithFallingPegs(GameObject gameObject, boolean bl) {
        gameObject.getBoundingBox();
        int n = GameObject.smBoundingBoxX;
        int n2 = GameObject.smBoundingBoxY;
        int n3 = GameObject.smBoundingBoxW;
        int n4 = GameObject.smBoundingBoxH;
        int n5 = gameObject.mRadius;
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject2 = smObjects[i];
            if (gameObject2.mType != 1 || gameObject2.getBoolean(8) || !gameObject2.getBoolean(16) || !gameObject2.getBoolean(32) || !bl && GameEngine.smPlayerState == 1 && GameEngine.smPlayerCirclingCenter == gameObject2) continue;
            gameObject2.getBoundingBox();
            if (!Util.rectangleCollision(n, n2, n3, n4, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH)) continue;
            int n6 = Util.sqrtApproximate(gameObject.mPosX - gameObject2.mPosX >> 8, gameObject.mPosY - gameObject2.mPosY >> 8);
            if (gameObject.mPosY <= gameObject2.mPosY || n6 >= gameObject2.mRadius + n5) continue;
            return gameObject2;
        }
        return null;
    }

    public static final boolean areAllValvesSetOn() {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != 12 || gameObject.getBoolean(256)) continue;
            return false;
        }
        return true;
    }

    public static final boolean setValvesLifeTimeZero() {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != 12 || !gameObject.getBoolean(256)) continue;
            gameObject.mLifeTimer = 0;
        }
        return true;
    }

    public static final boolean resetItems() {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType == 1 && gameObject.getBoolean(16)) {
                gameObject.mPosX = gameObject.mStartPosX << 8;
                gameObject.mPosY = gameObject.mStartPosY << 8;
                gameObject.mTypeData = 0;
                gameObject.setBoolean(8, false);
                gameObject.setBoolean(32, false);
            }
            if (gameObject.mType == 12) {
                gameObject.setBoolean(256, false);
            }
            if (gameObject.mType != 33 && gameObject.mType != 32 && gameObject.mType != 34) continue;
            gameObject.setBoolean(8, false);
        }
        return true;
    }

    public static final GameObject findPeg(int n, int n2, int n3, int n4) {
        for (int i = 0; i < smObjectCount; ++i) {
            int n5;
            int n6;
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != 1 && gameObject.mType != 12 && gameObject.mType != 13 || !Util.rectangleCollision(n, n2, n3, n4, n6 = gameObject.mPosX >> 8, n5 = gameObject.mPosY >> 8, 1, 1)) continue;
            return gameObject;
        }
        return null;
    }

    public static final void startPreLevelCameraDrive() {
        GameObject gameObject;
        int n;
        boolean bl = false;
        VisualEngine.startCameraDrive(false);
        for (n = 0; n < smObjectCount; ++n) {
            gameObject = smObjects[n];
            if (GameEngine.smLevelHasHardBoss) {
                if (gameObject.mType != 1 || !gameObject.getBoolean(32768)) continue;
                VisualEngine.addCameraDriveTarget(gameObject);
                gameObject.setBoolean(65536, true);
                bl = true;
                continue;
            }
            if (gameObject.mType != 1 || !gameObject.getBoolean(4096)) continue;
            VisualEngine.addCameraDriveTarget(gameObject);
            gameObject.setBoolean(65536, true);
            bl = true;
        }
        while (n < smObjectCount) {
            gameObject = smObjects[n];
            if (gameObject.mType == 65 || gameObject.mType == 66 || gameObject.mType == 67 || gameObject.mType == 36) {
                bl = true;
                VisualEngine.addCameraDriveTarget(gameObject);
            }
            ++n;
        }
        if (!bl) {
            VisualEngine.stopCameraDrive();
        }
    }

    public static final void switchToggled(int n) {
        VisualEngine.startCameraDrive(true);
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mLinkedSwitch != n) continue;
            VisualEngine.addCameraDriveTarget(gameObject);
        }
    }

    public static final GameObject getRandomPeg() {
        int n = Util.getRandom(smRotatingPointCount);
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != 1 || --n > 0) continue;
            return gameObject;
        }
        return null;
    }

    public static final void markPegsBoss(int n, int n2, int n3, int n4) {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != 1 || n >= gameObject.mPosX || n + n3 <= gameObject.mPosX || n2 >= gameObject.mPosY || n2 + n4 <= gameObject.mPosY) continue;
            gameObject.setBoolean(8192, true);
            ++GameEngine.smHardBossPegLeft;
        }
    }

    public static final boolean areAllBossPegsBroken() {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != 1 || !gameObject.getBoolean(8192) || gameObject.getBoolean(16384)) continue;
            return false;
        }
        return true;
    }

    public static final void removeObjectsByType(int n) {
        for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.mType != n) continue;
            gameObject.setBoolean(1, false);
        }
    }

    public static final GameObject getPegNearPoint(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        GameObject gameObject = null;
        for (int i = 0; i < smObjectCount; ++i) {
            int n4;
            int n5;
            int n6;
            GameObject gameObject2 = smObjects[i];
            if (gameObject2.mType != 1 || (n6 = Util.sqrtApproximate(n5 = (gameObject2.mPosX >> 8) - n, n4 = (gameObject2.mPosY >> 8) - n2)) >= n3) continue;
            n3 = n6;
            gameObject = gameObject2;
        }
        return gameObject;
    }

    public static final void spawnBanana() {
        GameObject gameObject;
        GameObject gameObject2 = ObjectManager.getRandomPeg();
        while (gameObject2 == GameEngine.smPlayerStartObject) {
            gameObject2 = ObjectManager.getRandomPeg();
        }
        if (gameObject2 != null && (gameObject = ObjectManager.addObject((byte)100, 0, 0)) != null) {
            int n = Util.getRandom() & 0x3FF;
            gameObject.mWidth = 32;
            gameObject.mHeight = 32;
            gameObject.mPosX = gameObject2.mPosX + (Util.getSin(n) * 40 >> 4) - (gameObject.mWidth << 7);
            gameObject.mPosY = gameObject2.mPosY + (Util.getCos(n) * 40 >> 4) - (gameObject.mHeight << 7);
            gameObject.setBoolean(8, false);
            ParticleSystem.startSwitchFx(gameObject, gameObject.mWidth >> 1, gameObject.mHeight >> 1);
            ++GameEngine.smFruitCount;
        }
    }

    public static final void respawnFruits(int n, int n2, int n3) {
        GameObject gameObject = ObjectManager.findNearestRotationPoint(n2, n3, null);
        GameObject gameObject2 = ObjectManager.findNearestRotationPoint(n2, n3, gameObject);
        int n4 = 0;
        int n5 = Util.getRandom(8) * 1024 / 8;
        int n6 = 0;
        if (gameObject != null && gameObject2 != null) {
            for (int i = 0; i < smObjectCount; ++i) {
                GameObject gameObject3 = smObjects[i];
                if (!gameObject3.getBoolean(8) || gameObject3.getBoolean(2048) || gameObject3.mType != 104 && gameObject3.mType != 100 && gameObject3.mType != 102 && gameObject3.mType != 103 && gameObject3.mType != 101) continue;
                int n7 = n6 % 3;
                int n8 = 0;
                if (n6 > 2) {
                    gameObject = gameObject2;
                    n8 = n - 3;
                    if (n8 == 0) {
                        n8 = 1;
                    }
                } else {
                    n8 = 3;
                }
                int n9 = 1024 * n7 / n8 + n5;
                int n10 = Util.getSin(n9) * 30 >> 4;
                int n11 = Util.getCos(n9) * 30 >> 4;
                gameObject3.mPosX = gameObject.mPosX + n10 - (gameObject3.mWidth >> 1 << 8);
                gameObject3.mPosY = gameObject.mPosY + n11 - (gameObject3.mHeight >> 1 << 8);
                gameObject3.setBoolean(2048, true);
                gameObject3.mLifeTimer = 0;
                ParticleSystem.startFruitDroppedFx(n2, n3, gameObject3.mType - 100, (gameObject3.mPosX >> 8) + (gameObject3.mWidth >> 1), (gameObject3.mPosY >> 8) + (gameObject3.mHeight >> 1));
                ++n4;
                if (++n6 >= n) break;
            }
        }
        GameEngine.smFruitsCollected -= n4;
    }

    public static final int collideRectWithGeometry(int n, int n2, int n3, int n4) {
        if (n2 + n4 > GameEngine.smLevelHeight) {
            return n2 + n4 - GameEngine.smLevelHeight;
        }
        block3: for (int i = 0; i < smObjectCount; ++i) {
            GameObject gameObject = smObjects[i];
            if (gameObject.getBoolean(8)) continue;
            switch (gameObject.mCollisionType) {
                case 0: {
                    if (gameObject.mType != 3) continue block3;
                    gameObject.getBoundingBox();
                    if (!Util.rectangleCollision(n, n2, n3, n4, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH)) continue block3;
                    return n2 + n4 - GameObject.smBoundingBoxY;
                }
            }
        }
        return -1;
    }
}

