/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Animation {
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;
    private AnimationFrame[] mFrame;
    private int[] mFrameDuration;
    private int[] mFrameStartTime;
    private int[] mFrameColorModification;
    private byte[] mFrameReference;
    private int mAnimationDuration = Integer.MAX_VALUE;
    private boolean mLoopPreference;
    private boolean mContinuousNestedAnimations;
    private TimelineChannel[] mTimeline;
    private int mTimelineX;
    private int mTimelineY;
    private int mTimelineWidth;
    private int mTimelineHeight;

    private void createEmptyAnimation() {
        this.mFrame = new AnimationFrame[1];
        this.mFrame[0] = new AnimationFrame(true);
        this.mFrameReference = new byte[]{0};
        this.mFrameDuration = new int[]{Integer.MAX_VALUE};
        this.mFrameStartTime = new int[1];
        this.mFrameColorModification = new int[]{-8355712};
    }

    public Animation(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (n == -1) {
            this.createEmptyAnimation();
            return;
        }
        if (!bl) {
            DavinciUtilities.resetLoading();
        }
        byte[] byArray = Toolkit.getResourceBytes(n);
        boolean bl2 = (byArray[0] & 1) == 0;
        boolean bl3 = (byArray[0] & 2) == 0;
        int n6 = byArray[1] & 0xFF;
        this.mFrameDuration = new int[n6];
        this.mFrameStartTime = new int[n6];
        this.mFrame = new AnimationFrame[n6];
        this.mFrameReference = new byte[n6];
        this.mLoopPreference = byArray[2] == 1;
        this.mContinuousNestedAnimations = byArray[3] == 1;
        int n7 = 8;
        if (bl2) {
            this.mX = byArray[4];
            this.mY = byArray[5];
            this.mWidth = (short)(byArray[6] & 0xFF);
            this.mHeight = (short)(byArray[7] & 0xFF);
        } else {
            this.mX = (short)(byArray[4] << 8 | byArray[5] & 0xFF);
            this.mY = (short)(byArray[6] << 8 | byArray[7] & 0xFF);
            this.mWidth = (short)(byArray[8] << 8 | byArray[9] & 0xFF);
            this.mHeight = (short)(byArray[10] << 8 | byArray[11] & 0xFF);
            n7 = 12;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            this.mFrameReference[n5] = byArray[n7++];
            n4 = this.mFrameReference[n5] & 0xFF;
            if (n4 != 255) continue;
            this.mFrame[n5] = new AnimationFrame(false);
        }
        n5 = 0;
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = bl3 ? byArray[n7++] & 0xFF : (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
                n5 = 1;
            }
            this.mFrameDuration[n3] = n2;
            this.mFrameStartTime[n3] = n4;
            n4 += n2;
        }
        if (n5 == 0) {
            this.mAnimationDuration = this.mFrameStartTime[n6 - 1] + this.mFrameDuration[n6 - 1];
        }
        this.mFrameColorModification = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = (byArray[n7++] & 0xFF) << 24;
            n2 |= (byArray[n7++] & 0xFF) << 16;
            n2 |= (byArray[n7++] & 0xFF) << 8;
            this.mFrameColorModification[n3] = n2 |= byArray[n7++] & 0xFF;
        }
        this.mTimelineX = this.mX;
        this.mTimelineY = this.mY;
        this.mTimelineWidth = this.mWidth;
        this.mTimelineHeight = this.mHeight;
        int n8 = n3 = byArray[n7++] == 1 ? 1 : 0;
        if (n3 != 0) {
            if (bl2) {
                this.mTimelineX = byArray[n7++];
                this.mTimelineY = byArray[n7++];
                this.mTimelineWidth = (short)(byArray[n7++] & 0xFF);
                this.mTimelineHeight = (short)(byArray[n7++] & 0xFF);
            } else {
                this.mTimelineX = (short)(byArray[n7++] << 8 | byArray[n7++] & 0xFF);
                this.mTimelineY = (short)(byArray[n7++] << 8 | byArray[n7++] & 0xFF);
                this.mTimelineWidth = (short)(byArray[n7++] << 8 | byArray[n7++] & 0xFF);
                this.mTimelineHeight = (short)(byArray[n7++] << 8 | byArray[n7++] & 0xFF);
            }
            this.mTimeline = new TimelineChannel[6];
            for (n2 = 0; n2 < 6; ++n2) {
                this.mTimeline[n2] = new TimelineChannel(n2, this.getDuration());
                n7 = this.mTimeline[n2].load(byArray, n7, bl2);
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.mFrameReference[n3] & 0xFF;
            if (n2 != 255) continue;
            n7 = this.mFrame[n3].loadFrameData(byArray, n7, bl2, bl);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.mFrameReference[n3] & 0xFF;
            if (n2 == 255) continue;
            this.mFrame[n3] = this.mFrame[n2];
        }
    }

    public int getWithoutTimelineX() {
        return this.mX;
    }

    public int getWithoutTimelineY() {
        return this.mY;
    }

    public int getWithoutTimelineWidth() {
        return this.mWidth;
    }

    public int getWithoutTimelineHeight() {
        return this.mHeight;
    }

    public int getX() {
        return this.mTimelineX;
    }

    public int getY() {
        return this.mTimelineY;
    }

    public int getWidth() {
        return this.mTimelineWidth;
    }

    public int getHeight() {
        return this.mTimelineHeight;
    }

    public int getFrameCount() {
        return this.mFrame.length;
    }

    public boolean isLoopingPreferenced() {
        return this.mLoopPreference;
    }

    public int getFrameColorModification(int n) {
        return this.mFrameColorModification[n];
    }

    public int getDuration() {
        return this.mAnimationDuration;
    }

    public int getFrameStartTime(int n) {
        return this.mFrameStartTime[n];
    }

    public int getFrameDuration(int n) {
        return this.mFrameDuration[n];
    }

    public int getFrameInTime(int n) {
        int n2 = this.mFrameDuration.length;
        while (--n2 >= 0) {
            if (n < this.mFrameStartTime[n2]) continue;
            return n2;
        }
        return -1;
    }

    public void doDraw(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.getFrameInTime(n3);
        int n5 = n3;
        if (!this.mContinuousNestedAnimations) {
            n5 -= this.getFrameStartTime(n4);
        }
        this.mFrame[n4].doDraw(graphics, n - this.getWithoutTimelineX(), n2 - this.getWithoutTimelineY(), n5);
    }

    public AnimationFrame getFrame(int n) {
        return this.mFrame[n];
    }

    public boolean isFrameReference(int n) {
        return this.mFrameReference[n] == 255;
    }

    public int getTimelineValue(int n, int n2, boolean bl) {
        return this.mTimeline[n].getValue(n2, bl);
    }

    public boolean hasTimeline() {
        if (this.mTimeline != null) {
            int n = 6;
            while (--n >= 0) {
                if (this.mTimeline[n].getEventCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void freeResources() {
        int n = this.mFrame.length;
        while (--n >= 0) {
            this.mFrame[n].freeResources();
        }
        DavinciUtilities.modRefCounters(this, -1);
    }
}

