/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import com.lemonquest.utils.SSFont;
import javax.microedition.lcdui.Graphics;

public class SSTextBox {
    private static final long WAITING_TIME = 1000L;
    public int width = 0;
    public int height = 0;
    private int borderSize = 2;
    private int colorBorder = 0;
    private int colorBackground = 0xFFFFFF;
    private SSFont font = null;
    private StringBuffer text = null;
    private long lastKeyPressed = 0L;
    private int posLetter = 0;
    private int indexLast = 0;
    private char[][] letters = null;

    public SSTextBox(SSFont sSFont, int n) {
        this.font = sSFont;
        this.text = new StringBuffer(n);
        this.width = n * this.font.getFontHeight();
        this.height = this.font.getFontHeight() + 4 * this.borderSize;
        this.setAlphabet(" 0+()[]", "1.,@!?", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9");
    }

    public void setAlphabet(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this.letters = new char[10][];
        this.letters[0] = string.toCharArray();
        this.letters[1] = string2.toCharArray();
        this.letters[2] = string3.toCharArray();
        this.letters[3] = string4.toCharArray();
        this.letters[4] = string5.toCharArray();
        this.letters[5] = string6.toCharArray();
        this.letters[6] = string7.toCharArray();
        this.letters[7] = string8.toCharArray();
        this.letters[8] = string9.toCharArray();
        this.letters[9] = string10.toCharArray();
    }

    public void setSize(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.borderSize = n3;
    }

    public void setColor(int n, int n2) {
        this.colorBackground = n;
        this.colorBorder = n2;
    }

    public String getText() {
        return this.text.toString();
    }

    public void keyPressed(char c) {
        if (c >= '0' && c <= '9' && this.text.length() < this.text.capacity()) {
            int n = c - 48;
            if (System.currentTimeMillis() < this.lastKeyPressed + 1000L && n == this.indexLast) {
                this.posLetter = (this.posLetter + 1) % this.letters[n].length;
                this.text.setCharAt(this.text.length() - 1, this.letters[n][this.posLetter]);
            } else {
                this.indexLast = n;
                this.posLetter = 0;
                this.text.append(this.letters[n][this.posLetter]);
            }
            this.lastKeyPressed = System.currentTimeMillis();
        } else if (c == '\u0003') {
            if (this.text.length() > 0) {
                this.text.deleteCharAt(this.text.length() - 1);
            }
        } else if (c == '\u0004') {
            this.lastKeyPressed = 0L;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        graphics.setClip(n, n2, this.width + 1, this.height + 1);
        graphics.setColor(this.colorBorder);
        graphics.fillRect(n, n2, this.width, this.height);
        graphics.setColor(this.colorBackground);
        graphics.fillRect(n + this.borderSize, n2 + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
        if (System.currentTimeMillis() / 500L % 2L == 0L) {
            graphics.setColor(this.colorBorder);
            graphics.fillRect(n + this.font.getLineWidth(this.text.toString().toCharArray()) + 3 * this.borderSize, n2 + 2 * this.borderSize, this.borderSize, this.height - 4 * this.borderSize);
        }
        this.font.drawString(graphics, this.text.toString().toCharArray(), n + 2 * this.borderSize, n2 + 2 * this.borderSize, 20);
    }
}

