/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SSMusic {
    public static final int NO_SOUND = -1;
    public static final int SOUND_MIDI = 0;
    public static final int SOUND_AMR = 1;
    public static final int SOUND_MP3 = 2;
    public static final int SOUND_WAV = 3;
    private static final int MAX_ELEMENTS = 16;
    private Player[] midis = new Player[16];
    private byte[] soundType = new byte[16];
    private int lastSoundIndex;
    private int actualSound = -1;

    public SSMusic() {
        for (int i = 0; i < 16; ++i) {
            this.soundType[i] = -1;
        }
        this.lastSoundIndex = 0;
    }

    public int loadSound(byte[] byArray, int n) {
        Player player = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (byteArrayInputStream == null) {
            return -1;
        }
        try {
            ++this.lastSoundIndex;
            switch (n) {
                case 0: {
                    this.midis[this.lastSoundIndex] = player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
                    this.soundType[this.lastSoundIndex] = 0;
                    break;
                }
                case 2: {
                    this.midis[this.lastSoundIndex] = player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/mp3");
                    this.soundType[this.lastSoundIndex] = 2;
                    break;
                }
                case 1: {
                    this.midis[this.lastSoundIndex] = player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/amr");
                    this.soundType[this.lastSoundIndex] = 1;
                    break;
                }
                case 3: {
                    this.midis[this.lastSoundIndex] = player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/x-wav");
                    this.soundType[this.lastSoundIndex] = 3;
                }
            }
            if (player != null) {
                player.realize();
                player.prefetch();
            }
            return this.lastSoundIndex;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean playSound(int n, boolean bl) {
        if (n <= this.lastSoundIndex) {
            if (bl) {
                if (this.isSound(this.actualSound)) {
                    this.stopSound(this.actualSound);
                }
            } else if (this.isSound()) {
                return false;
            }
            try {
                switch (this.soundType[n]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[n].start();
                        this.actualSound = n;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void stopSound(int n) {
        if (n <= this.lastSoundIndex && this.actualSound != -1) {
            try {
                switch (this.soundType[n]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[n].stop();
                        this.actualSound = -1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSound() {
        try {
            for (int i = 0; i < 16; ++i) {
                if (this.soundType[i] == -1 || this.midis[i].getState() != 400) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean isSound(int n) {
        try {
            return this.midis[n].getState() == 400;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void unloadSound(int n) {
        if (n <= this.lastSoundIndex) {
            --this.lastSoundIndex;
            try {
                switch (this.soundType[n]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.midis[n].close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setVolume(int n, int n2) {
        try {
            VolumeControl volumeControl = (VolumeControl)this.midis[n].getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

