/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SSAnimation {
    private int numSprites;
    private int numFrames;
    private int numAnimations;
    private Image imageAnimation;
    private byte[] sprites;
    private short[][] frames;
    private short[][] animations;

    public SSAnimation(DataInputStream dataInputStream) {
        try {
            short s;
            short s2;
            short s3;
            int n;
            int n2;
            int n3;
            this.numSprites = dataInputStream.readUnsignedByte();
            this.sprites = new byte[this.numSprites << 2];
            for (n3 = 0; n3 < this.numSprites; ++n3) {
                n2 = dataInputStream.readUnsignedByte();
                n = dataInputStream.readUnsignedByte();
                s3 = (short)dataInputStream.readUnsignedByte();
                s2 = (short)dataInputStream.readUnsignedByte();
                this.sprites[(n3 << 2) + 0] = n2;
                this.sprites[(n3 << 2) + 1] = n;
                this.sprites[(n3 << 2) + 2] = s3;
                this.sprites[(n3 << 2) + 3] = s2;
            }
            this.numFrames = dataInputStream.readUnsignedByte();
            this.frames = new short[this.numFrames][];
            for (n3 = 0; n3 < this.numFrames; ++n3) {
                n2 = dataInputStream.readUnsignedByte();
                this.frames[n3] = new short[n2 * 3];
                for (n = 0; n < n2; ++n) {
                    s3 = (short)dataInputStream.readUnsignedByte();
                    s2 = dataInputStream.readShort();
                    s = dataInputStream.readShort();
                    this.frames[n3][n * 3 + 0] = s3;
                    this.frames[n3][n * 3 + 1] = s2;
                    this.frames[n3][n * 3 + 2] = s;
                }
            }
            this.numAnimations = dataInputStream.readUnsignedByte();
            this.animations = new short[this.numAnimations][];
            for (n3 = 0; n3 < this.numAnimations; ++n3) {
                n2 = 0;
                n = dataInputStream.readUnsignedByte();
                this.animations[n3] = new short[(n << 1) + 1];
                for (s3 = 0; s3 < n; s3 = (short)(s3 + 1)) {
                    s2 = (short)dataInputStream.readUnsignedByte();
                    s = dataInputStream.readShort();
                    this.animations[n3][1 + (s3 << 1) + 0] = s2;
                    this.animations[n3][1 + (s3 << 1) + 1] = s;
                    n2 = (short)(n2 + s);
                }
                this.animations[n3][0] = n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[128];
            n = dataInputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = dataInputStream.read(byArray);
            }
            byArray = byteArrayOutputStream.toByteArray();
            this.imageAnimation = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            byteArrayOutputStream.close();
            dataInputStream.close();
            byteArrayOutputStream = null;
            dataInputStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean drawAnimation(Graphics graphics, int n, long l, int n2, int n3, boolean bl) {
        int n4 = -1;
        try {
            n4 = this.getFramePos(n, Math.abs(l), bl);
            this.drawFrame(graphics, n4, n2, n3);
        }
        catch (Exception exception) {
            System.out.println("Time = " + l);
        }
        return n4 >= this.getNumFramesAnimation(n);
    }

    public boolean drawAnimation(Graphics graphics, int n, long l, int n2, int n3, int n4, boolean bl) {
        int n5 = -1;
        try {
            n5 = this.getFramePos(n, Math.abs(l), bl);
            this.drawFrame(graphics, n5, n2, n3, n4);
        }
        catch (Exception exception) {
            System.out.println("Time = " + l);
        }
        return n5 >= this.getNumFramesAnimation(n);
    }

    public int getNumAnimations() {
        return this.animations.length;
    }

    public int getNumFramesAnimation(int n) {
        return this.frames[this.numAnimations].length - 1 >> 1;
    }

    public void drawFrame(Graphics graphics, int n, int n2, int n3) {
        short[] sArray = this.frames[n];
        for (int i = 0; i < sArray.length / 3; ++i) {
            short s = sArray[i * 3 + 0];
            short s2 = sArray[i * 3 + 1];
            short s3 = sArray[i * 3 + 2];
            this.drawSprite(graphics, s, n2 + s2, n3 + s3);
        }
    }

    public void drawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        short[] sArray = this.frames[n];
        for (int i = 0; i < sArray.length / 3; ++i) {
            short s = sArray[i * 3 + 0];
            short s2 = sArray[i * 3 + 1];
            short s3 = sArray[i * 3 + 2];
            this.drawSprite(graphics, s, n2 + s2, n3 + s3, n4);
        }
    }

    public void drawSprite(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.sprites[(n << 2) + 0] & 0xFF;
        int n5 = this.sprites[(n << 2) + 1] & 0xFF;
        int n6 = this.sprites[(n << 2) + 2] & 0xFF;
        int n7 = this.sprites[(n << 2) + 3] & 0xFF;
        graphics.setClip(n2, n3, n6, n7);
        graphics.drawImage(this.imageAnimation, n2 - n4, n3 - n5, 20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawSprite(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.sprites[(n << 2) + 0] & 0xFF;
        int n6 = this.sprites[(n << 2) + 1] & 0xFF;
        int n7 = this.sprites[(n << 2) + 2] & 0xFF;
        int n8 = this.sprites[(n << 2) + 3] & 0xFF;
        if (n3 < n4) {
            int n9 = n8 - (n4 - n3);
            if (n9 <= 0) return;
            graphics.setClip(n2, n4, n7, n9);
        } else {
            graphics.setClip(n2, n3, n7, n8);
        }
        graphics.drawImage(this.imageAnimation, n2 - n5, n3 - n6, 20);
    }

    private int getFramePos(int n, long l, boolean bl) {
        int n2;
        long l2 = 0L;
        if (bl) {
            l %= (long)this.animations[n][0];
        }
        int n3 = this.animations[n].length - 1 >> 1;
        for (n2 = 0; l2 <= l && n2 < n3; l2 += (long)this.animations[n][1 + (n2 << 1) + 1], ++n2) {
        }
        return this.animations[n][1 + (n2 - 1 << 1)];
    }

    public int getFrameWidth(int n) {
        short[] sArray = this.frames[n];
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < sArray.length / 3; ++i) {
            short s = sArray[i * 3 + 0];
            short s2 = sArray[i * 3 + 1];
            int n4 = this.sprites[(s << 2) + 2] & 0xFF;
            n2 = Math.min(n2, s2);
            n3 = Math.max(n3, s2 + n4);
        }
        return Math.abs(n3 - n2);
    }

    public int getFrameHeight(int n) {
        short[] sArray = this.frames[n];
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < sArray.length / 3; ++i) {
            short s = sArray[i * 3 + 0];
            short s2 = sArray[i * 3 + 2];
            int n4 = this.sprites[(s << 2) + 3] & 0xFF;
            n2 = Math.min(n2, s2);
            n3 = Math.max(n3, s2 + n4);
        }
        return Math.abs(n3 - n2);
    }

    public int getWidthAnimation(int n) {
        int n2 = Integer.MIN_VALUE;
        for (int i = 1; i < this.animations[n].length; i += 2) {
            n2 = Math.max(n2, this.getFrameWidth(this.animations[n][i]));
        }
        return n2;
    }

    public int getHeightAnimation(int n) {
        int n2 = Integer.MIN_VALUE;
        for (int i = 1; i < this.animations[n].length; i += 2) {
            n2 = Math.max(n2, this.getFrameHeight(this.animations[n][i]));
        }
        return n2;
    }
}

