/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.Ball;
import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.Cwall;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Math2D;
import com.lemonquest.utils.SSMath;
import javax.microedition.lcdui.Graphics;

public class Thrower {
    GameEngine ge;
    public long[] pos = new long[2];
    public long[] posIni = new long[2];
    public long[] posDir = new long[2];
    public long[] posDirIni = new long[2];
    public long rad;
    public long fireTime;
    public long fireLastTime;
    public String firePattern;
    public int fireNumber;
    public long[] fireDir = new long[2];
    public int fireNext = -1;
    public int firePrev = -1;
    public int fireIndex = 0;
    private long[] u = new long[2];

    public Thrower(GameEngine gameEngine, int n, int n2, int n3, long l, String string, int n4) {
        this.ge = gameEngine;
        this.rad = 18432L;
        this.pos[0] = this.posIni[0] = (long)(n << 10);
        this.pos[1] = this.posIni[1] = (long)(n2 << 10);
        this.posDir[0] = this.posDirIni[0] = this.pos[0] + (this.rad * Math2D.cos(n3) >> 10);
        this.posDir[1] = this.posDirIni[1] = this.pos[1] + (this.rad * Math2D.sin(n3) >> 10);
        this.u = this.normal(this.posDir[0], this.posDir[1]);
        this.fireTime = l;
        this.fireNumber = n4;
        this.firePattern = string;
        this.fireLastTime = System.currentTimeMillis();
        this.nextBall();
        this.fireNext = this.firePrev;
        this.nextBall();
        BoardManager.cwalls[BoardManager.cWallCnt] = new Cwall(Math2D.getPixel(this.pos[0]), Math2D.getPixel(this.pos[1]), Math2D.getPixel(this.rad));
        ++BoardManager.cWallCnt;
    }

    public void nextBall() {
        if (this.fireNumber == 0) {
            this.firePrev = -1;
            return;
        }
        if (this.firePattern.length() == 0) {
            this.firePrev = Integer.parseInt(String.valueOf(this.firePattern.charAt(SSMath.rand(0, this.firePattern.length()))));
        } else {
            this.firePrev = Integer.parseInt(String.valueOf(this.firePattern.charAt(this.fireIndex)));
            this.fireIndex = (this.fireIndex + 1) % this.firePattern.length();
        }
        --this.fireNumber;
    }

    public void fireBall() {
        if (System.currentTimeMillis() - this.fireLastTime > this.fireTime) {
            switch (this.fireNext) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    FX.fireParticles(BoardManager.arenaOffsetOX + Math2D.getPixel(this.posDir[0]), BoardManager.arenaOffsetOY - Math2D.getPixel(this.posDir[1]), 0, 360, 6, 10, 6, 1, 1850, 6, this.fireNext, true);
                    break;
                }
                case 4: {
                    FX.fireParticles(BoardManager.arenaOffsetOX + Math2D.getPixel(this.posDir[0]), BoardManager.arenaOffsetOY - Math2D.getPixel(this.posDir[1]), 0, 360, 6, 10, 6, 1, 1850, 6, 0, true);
                    break;
                }
                case 5: {
                    FX.fireParticles(BoardManager.arenaOffsetOX + Math2D.getPixel(this.posDir[0]), BoardManager.arenaOffsetOY - Math2D.getPixel(this.posDir[1]), 0, 360, 6, 10, 6, 1, 1850, 6, 2, true);
                }
            }
            BoardManager.balls[BoardManager.ballCnt] = new Ball(this.ge, this.fireNext, 0, Math2D.getPixel(this.pos[0] + (5L * this.u[0] * this.rad / 3L >> 10)), Math2D.getPixel(this.pos[1] + (5L * this.u[1] * this.rad / 3L >> 10)), '-', false, 20);
            ++BoardManager.ballCnt;
            this.fireLastTime = System.currentTimeMillis();
            this.fireNext = this.firePrev;
            this.nextBall();
        }
    }

    public long[] normal(long l, long l2) {
        this.u[0] = l - this.pos[0];
        this.u[1] = l2 - this.pos[1];
        this.u = Math2D.normalize(this.u[0], this.u[1]);
        return this.u;
    }

    public void updatePosition(int n) {
        this.pos = Math2D.rotatePoint(this.posIni[0], this.posIni[1], n);
        this.posDir = Math2D.rotatePoint(this.posDirIni[0], this.posDirIni[1], n);
        this.u = this.normal(this.posDir[0], this.posDir[1]);
    }

    public void paintThrower(Graphics graphics, int n, int n2) {
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(BoardManager.arenaColor);
        graphics.drawArc(n + Math2D.getPixel(this.posDir[0] - 4096L), n2 - Math2D.getPixel(this.posDir[1] + 4096L), 8, 8, 0, 360);
        graphics.setColor(0);
        graphics.fillArc(n + Math2D.getPixel(this.pos[0] - this.rad + 2048L), n2 - Math2D.getPixel(this.pos[1] + this.rad - 2048L), Math2D.getPixel(this.rad - 2048L << 1), Math2D.getPixel(this.rad - 2048L << 1), 0, 360);
        if (this.firePrev == 8) {
            GameCanvas.paintImage(graphics, 13, n + Math2D.getPixel(this.pos[0] + (-this.u[0] * (this.rad >> 1) >> 10)), n2 - Math2D.getPixel(this.pos[1] + (-this.u[1] * (this.rad >> 1) >> 10)), 3);
        } else {
            GameCanvas.resAnimations[6].drawAnimation(graphics, this.firePrev, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0] + (-this.u[0] * (this.rad >> 1) >> 10)), n2 - Math2D.getPixel(this.pos[1] + (-this.u[1] * (this.rad >> 1) >> 10)), true);
        }
        if (this.fireNext == 8) {
            GameCanvas.paintImage(graphics, 13, n + Math2D.getPixel(this.pos[0] + (this.u[0] * (this.rad >> 1) >> 10)), n2 - Math2D.getPixel(this.pos[1] + (this.u[1] * (this.rad >> 1) >> 10)), 3);
        } else {
            GameCanvas.resAnimations[6].drawAnimation(graphics, this.fireNext, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0] + (this.u[0] * (this.rad >> 1) >> 10)), n2 - Math2D.getPixel(this.pos[1] + (this.u[1] * (this.rad >> 1) >> 10)), true);
        }
    }
}

