/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import javax.microedition.lcdui.Graphics;

public class MenuTrophies {
    private static GameEngine ge;
    public static final int MENU_WIDTH = 172;
    public static final int MENU_HEIGHT = 188;
    public static final int WINDOW_WIDTH = 160;
    public static final int WINDOW_HEIGHT = 150;
    public static final int SCROLLBAR_GAP = 28;
    private static final int[] SELECTOR_COLORS;
    private static int listX;
    private static int listXfinal;
    private static int listY;
    private static int listYfinal;
    public static int listSelected;
    private static int paintX;
    private static int paintY;
    public static StringBuffer auxString;

    public MenuTrophies(GameEngine gameEngine) {
        ge = gameEngine;
        listX = listXfinal;
        listY = listYfinal;
    }

    public static void pressUp() {
        listYfinal += 30;
        listSelected = Math.max(0, listSelected - 1);
    }

    public static void pressDown() {
        listYfinal -= 30;
        listSelected = Math.min(listSelected + 1, 24);
    }

    public static void paint(Graphics graphics) {
        switch (GameEngine.state) {
            case 7: {
                MenuTrophies.paintList(graphics);
                MenuTrophies.paintFrame(graphics);
                if (GameEngine.trophyVisible[listSelected]) {
                    GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[27].toCharArray(), 2, 206, 68);
                }
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[6].toCharArray(), 174, 206, 72);
                break;
            }
            case 8: {
                MenuTrophies.paintDetail(graphics, listSelected);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[6].toCharArray(), 174, 206, 72);
                break;
            }
            case 9: {
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[8].toCharArray(), 2, 206, 68);
            }
        }
    }

    public static void paintDetail(Graphics graphics, int n) {
        GameCanvas.paintFrameItem(graphics, 2, 5, 172, 188);
        graphics.setColor(0);
        graphics.setClip(7, 10, 162, GameCanvas.resFonts[3].getFontHeight() + 6);
        graphics.fillRoundRect(8, 11, 160, GameCanvas.resFonts[3].getFontHeight() + 4, 10, 10);
        GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[56].toCharArray(), 86, 12, 17);
        paintX = 88;
        paintY = 25;
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(0xFFFFFF);
        graphics.setStrokeStyle(1);
        graphics.drawLine(20, 40, 156, 40);
        GameCanvas.resFonts[2].drawString(graphics, GameEngine.trophyTitle[n].toCharArray(), paintX, paintY + 5, 17);
        GameCanvas.resFonts[1].drawString(graphics, GameEngine.trophyDescription[n].toCharArray(), 20, paintY += 20, 136, 30, 17);
        paintY += 30;
        if (GameEngine.trophyUnlocked[n]) {
            GameCanvas.resAnimations[12].drawAnimation(graphics, 1, System.currentTimeMillis(), paintX, paintY + 2, true);
        } else {
            GameCanvas.resAnimations[12].drawAnimation(graphics, 0, System.currentTimeMillis(), paintX, paintY + 2, true);
        }
        paintY += 15;
        auxString.setLength(0);
        auxString.append(GameEngine.trophyPoints[n]);
        auxString.append(" ");
        auxString.append(GameCanvas.lang[30]);
        GameCanvas.resFonts[0].drawString(graphics, auxString.toString().toCharArray(), paintX, paintY, 17);
        paintY += 15;
        auxString.setLength(0);
        auxString.append(GameEngine.trophyPoints[n]);
        auxString.append(" ");
        auxString.append(GameCanvas.lang[30]);
        if (GameEngine.trophyUnlocked[n]) {
            auxString.setLength(0);
            auxString.append(GameCanvas.lang[50]);
            GameCanvas.resFonts[0].drawString(graphics, auxString.toString().toCharArray(), paintX, paintY, 17);
        } else {
            auxString.setLength(0);
            auxString.append(GameCanvas.lang[51]);
            GameCanvas.resFonts[0].drawString(graphics, auxString.toString().toCharArray(), paintX, paintY, 17);
        }
        paintX = 10;
        paintY = 133;
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(0xFFFFFF);
        graphics.setStrokeStyle(0);
        graphics.drawLine(10, paintY + 12, 166, paintY + 12);
        GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[52].toCharArray(), 88, paintY, 17);
        paintY += 15;
        auxString.setLength(0);
        auxString.append(GameEngine.totalTrophiesUnlocked);
        auxString.append("/");
        auxString.append(25);
        GameCanvas.resFonts[1].drawString(graphics, GameCanvas.lang[53].toCharArray(), paintX, paintY, 20);
        GameCanvas.resFonts[2].drawString(graphics, auxString.toString().toCharArray(), 176 - paintX, paintY, 24);
        paintY += 12;
        auxString.setLength(0);
        auxString.append(GameEngine.totalTrophyPoints);
        auxString.append("/5000");
        GameCanvas.resFonts[1].drawString(graphics, GameCanvas.lang[54].toCharArray(), paintX, paintY, 20);
        GameCanvas.resFonts[2].drawString(graphics, auxString.toString().toCharArray(), 176 - paintX, paintY, 24);
        GameCanvas.resFonts[1].drawString(graphics, GameCanvas.lang[55].toCharArray(), paintX, paintY += 12, 20);
        GameCanvas.resFonts[2].drawString(graphics, Integer.toString(GameEngine.totalStars).toCharArray(), 176 - paintX - 16, paintY, 24);
        GameCanvas.resAnimations[4].drawAnimation(graphics, 0, System.currentTimeMillis(), 176 - paintX - 8, paintY + 5, true);
    }

    public static void paintFrame(Graphics graphics) {
        GameCanvas.paintFrameItem(graphics, 2, 5, 172, 188);
        graphics.setColor(0);
        graphics.setClip(7, 10, 162, GameCanvas.resFonts[3].getFontHeight() + 6);
        graphics.fillRoundRect(8, 11, 160, GameCanvas.resFonts[3].getFontHeight() + 4, 10, 10);
        GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[56].toCharArray(), 86, 12, 17);
        MenuTrophies.paintList(graphics);
    }

    public static void paintList(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        n = listYfinal - listY;
        if (n != 0) {
            n2 = Math.max(1, Math.abs(n / 3));
            if (Math.abs(n) < n2) {
                listY = listYfinal;
            } else if (n > 0) {
                listY += n2;
            } else if (n < 0) {
                listY -= n2;
            }
        }
        if (listYfinal + 32 * listSelected < 89) {
            listYfinal += 89 - listY - 32 * listSelected;
        } else if (listYfinal + 32 * listSelected > 89) {
            listYfinal -= listYfinal + 32 * listSelected - 14 - 75;
        }
        if (listY > 30) {
            listY = 30;
        }
        if (listY + 800 < 180) {
            listY = -620;
        }
        paintX = listX;
        paintY = listY;
        for (int i = 0; i < 25; ++i) {
            graphics.setClip(paintX, 30, 160, 152);
            if (i == listSelected) {
                graphics.setColor(SELECTOR_COLORS[GameEngine.gameFrames % 3]);
                graphics.fillRect(paintX, paintY, 153, 21);
            }
            if (30 <= paintY + 20 && paintY + 20 <= 180) {
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(1);
                graphics.drawLine(paintX, paintY + 22, paintX + 176 - 25, paintY + 22);
            }
            if (30 <= paintY + 5 && paintY + 5 <= 180) {
                if (GameEngine.trophyVisible[i]) {
                    GameCanvas.resFonts[2].drawString(graphics, GameEngine.trophyTitle[i].toCharArray(), paintX, paintY + 5, 110, 22, 20);
                } else {
                    GameCanvas.resFonts[3].drawString(graphics, GameCanvas.lang[57].toCharArray(), paintX + 2, paintY + 5, 20, 150);
                }
                if (GameEngine.trophyUnlocked[i] && !GameEngine.trophiesToShow[i]) {
                    if (i == listSelected) {
                        GameCanvas.resAnimations[12].drawAnimation(graphics, 1, System.currentTimeMillis(), paintX + 160 - 40 + 2, paintY + 11, true);
                    } else {
                        GameCanvas.resAnimations[12].drawAnimation(graphics, 0, System.currentTimeMillis(), paintX + 160 - 40 + 2, paintY + 11, true);
                    }
                }
                GameCanvas.resFonts[1].drawString(graphics, Integer.toString(GameEngine.trophyPoints[i]).toCharArray(), paintX + 160 - 7, paintY + 5, 24);
            }
            paintY += 32;
        }
        graphics.setColor(11297560);
        graphics.setStrokeStyle(0);
        graphics.setClip(162, 32, 5, 152);
        graphics.drawRect(162, 32, 4, 150);
        graphics.fillRect(163, 32 + Math.min(122, 150 * (32 * listSelected) / 800), 3, 28);
    }

    static {
        SELECTOR_COLORS = new int[]{9517321, 10306061, 9845005};
        listX = 8;
        listXfinal = 8;
        listY = 30;
        listYfinal = 30;
        listSelected = 0;
        paintX = 0;
        paintY = 0;
        auxString = new StringBuffer();
    }
}

