/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.MenuSelector;
import com.lemonquest.circulate.MenuTrophies;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSFont;
import com.lemonquest.utils.SSFunctions;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas {
    private GameEngine ge;
    public static final int TCIRCULATE = 0;
    public static final int TSOUND_QUESTION = 1;
    public static final int TYES = 2;
    public static final int TNO = 3;
    public static final int TLOADING = 4;
    public static final int TSELECT = 5;
    public static final int TBACK = 6;
    public static final int TPLAY = 7;
    public static final int TCONTINUE = 8;
    public static final int TRESTART = 9;
    public static final int TMENU = 10;
    public static final int TMENU_START_GAME = 11;
    public static final int TMENU_MOREGAMES = 12;
    public static final int TMENU_TROPHIES = 13;
    public static final int TMENU_OPTIONS = 14;
    public static final int TMENU_HELP = 15;
    public static final int TMENU_CREDITS = 16;
    public static final int TMENU_EXIT = 17;
    public static final int TMENU_ARE_YOU_SURE = 18;
    public static final int TMENU_RESET_GAME = 19;
    public static final int TMENU_RESET_GAME_INFO = 20;
    public static final int TMENU_SOUND = 21;
    public static final int TMENU_VIBRATION = 22;
    public static final int TMENU_CONTROL_A = 23;
    public static final int TMENU_CONTROL_B = 24;
    public static final int TON = 25;
    public static final int TOFF = 26;
    public static final int TVIEW = 27;
    public static final int TLEVEL = 28;
    public static final int TSTARS = 29;
    public static final int TPOINTS = 30;
    public static final int TLEVEL_COMPLETE = 31;
    public static final int TIMPOSSIBLE_COMPLETE = 32;
    public static final int THELP_TEXT = 33;
    public static final int TCREDITS_TEXT = 34;
    public static final int TLEVEL_SELECTION = 35;
    public static final int TYOU_HAVE_STARS = 36;
    public static final int TYOU_NEED_STARS = 37;
    public static final int TYOU_HAVE_ENOUGHT = 38;
    public static final int TTOTAL_SCORE = 39;
    public static final int TBEST_TIME = 40;
    public static final int THIGH_SCORE = 41;
    public static final int TTIME = 42;
    public static final int TSCORE = 43;
    public static final int TYOU_WON_STARS = 44;
    public static final int TPRESS_PLAY = 45;
    public static final int TOBJETIVE = 46;
    public static final int TCLEAR_BALLS = 47;
    public static final int TFILL_CONTAINERS = 48;
    public static final int TTROPHY_DETAILS = 49;
    public static final int TTROPHY_UNLOCKED = 50;
    public static final int TNOT_WON_YET = 51;
    public static final int TPLAYER_SCORE = 52;
    public static final int TTROPHIES_UNLOCKED = 53;
    public static final int TTROPHY_POINTS = 54;
    public static final int TGAME_STARS = 55;
    public static final int TTROPHIES_LIST = 56;
    public static final int THIDDEN_TROPHY = 57;
    public static final int TSLIDE_TO_OPEN = 58;
    public static final int TTIME_OUT = 59;
    public static final int TTROPHIES_DATA = 60;
    public static final int TLEVEL_DATA = 110;
    public static final int TPRESS5 = 210;
    public static final int TOTAL_TEXTS = 211;
    public static String[] lang = null;
    public static final int RES_LQA = 0;
    public static final int RES_PNG = 1;
    public static final int RES_SSF = 2;
    public static final int RES_MID = 3;
    public static final int RES_WAV = 4;
    public static final int RES_LQA_SPLASH = 0;
    public static final int RES_LQA_ICONS_MENU = 1;
    public static final int RES_LQA_ICONS_LEVEL = 2;
    public static final int RES_LQA_SPARKS = 3;
    public static final int RES_LQA_STAR = 4;
    public static final int RES_LQA_BORDER = 5;
    public static final int RES_LQA_BALLS = 6;
    public static final int RES_LQA_EXPLODE = 7;
    public static final int RES_LQA_BOMB = 8;
    public static final int RES_LQA_HOLE_DOWN = 9;
    public static final int RES_LQA_HOLE_UP = 10;
    public static final int RES_LQA_FLASH = 11;
    public static final int RES_LQA_MONEY = 12;
    public static final int RES_LQA_MINI_NUMBER = 13;
    public static final int RES_LQA_MAX = 14;
    public static SSAnimation[] resAnimations = new SSAnimation[14];
    public static final int RES_PNG_BG = 0;
    public static final int RES_PNG_BG_METAL = 0;
    public static final int RES_PNG_BG_SKY = 1;
    public static final int RES_PNG_BG_GRASS = 2;
    public static final int RES_PNG_BG_SWEET = 3;
    public static final int RES_PNG_BG_ORANGE = 4;
    public static final int RES_PNG_BG_MENU = 5;
    public static final int RES_PNG_SPLASH = 6;
    public static final int RES_PNG_COVER = 7;
    public static final int RES_PNG_TITLE = 8;
    public static final int RES_PNG_FRAME_TILES = 9;
    public static final int RES_PNG_ALPHA = 10;
    public static final int RES_PNG_LEFT_ARROW = 11;
    public static final int RES_PNG_RIGHT_ARROW = 12;
    public static final int RES_PNG_BUBBLE_NORMAL = 13;
    public static final int RES_PNG_BUBBLE_BIG = 14;
    public static final int RES_PNG_STAR_EMPTY = 15;
    public static final int RES_PNG_MAX = 16;
    public static Image[] resImages = new Image[16];
    public static int[] resImagesWidth = new int[16];
    public static int[] resImagesHeight = new int[16];
    public static final int RES_SSF_BIG = 0;
    public static final int RES_SSF_SMALL = 1;
    public static final int RES_SSF_SMALL_ORANGE = 2;
    public static final int RES_SSF_BIG_RED = 3;
    public static final int RES_SSF_MAX = 4;
    public static SSFont[] resFonts = new SSFont[4];
    public static final int RES_WAV_MAX = 0;
    public static final int RES_MID_MENU = 0;
    public static final int RES_MID_WIN = 1;
    public static final int RES_MID_LOSE = 2;
    public static final int RES_MID_MAX = 3;
    public StringBuffer auxString = new StringBuffer();
    public long aniTime = 0L;

    public GameCanvas(GameEngine gameEngine) {
        this.ge = gameEngine;
    }

    public void loadLanguage() {
        lang = null;
        GameEngine.garbageCollector();
        lang = SSFunctions.loadLangUnicode(SSFunctions.getResourceAsStream("/texts.dat"), 211);
        GameCanvas.lang[34] = SSFunctions.replace(lang[34], "%%SRL%%", "LQNS62001");
        GameCanvas.lang[34] = SSFunctions.replace(lang[34], "%%VERSION%%", this.ge.gm.getAppProperty("MIDlet-Version"));
        for (int i = 0; i < 25; ++i) {
            GameEngine.trophyTitle[i] = lang[60 + 2 * i];
            GameEngine.trophyDescription[i] = lang[60 + 2 * i + 1];
            GameEngine.trophyUnlocked[i] = false;
            GameEngine.trophyVisible[i] = true;
        }
        GameEngine.trophyPoints[0] = 100;
        GameEngine.trophyPoints[1] = 150;
        GameEngine.trophyPoints[2] = 200;
        GameEngine.trophyPoints[3] = 250;
        GameEngine.trophyPoints[4] = 500;
        GameEngine.trophyCounterFinal[0] = 10;
        GameEngine.trophyCounterFinal[1] = 20;
        GameEngine.trophyCounterFinal[2] = 30;
        GameEngine.trophyCounterFinal[3] = 40;
        GameEngine.trophyCounterFinal[4] = 50;
        GameEngine.trophyPoints[5] = 100;
        GameEngine.trophyPoints[6] = 200;
        GameEngine.trophyPoints[7] = 300;
        GameEngine.trophyPoints[8] = 400;
        GameEngine.trophyCounterFinal[5] = 50;
        GameEngine.trophyCounterFinal[6] = 100;
        GameEngine.trophyCounterFinal[7] = 150;
        GameEngine.trophyCounterFinal[8] = 200;
        GameEngine.trophyPoints[9] = 100;
        GameEngine.trophyPoints[10] = 150;
        GameEngine.trophyPoints[11] = 250;
        GameEngine.trophyPoints[12] = 500;
        GameEngine.trophyCounterFinal[9] = 10;
        GameEngine.trophyCounterFinal[10] = 20;
        GameEngine.trophyCounterFinal[11] = 30;
        GameEngine.trophyCounterFinal[12] = 40;
        GameEngine.trophyPoints[13] = 50;
        GameEngine.trophyPoints[14] = 100;
        GameEngine.trophyPoints[15] = 150;
        GameEngine.trophyPoints[16] = 200;
        GameEngine.trophyCounterFinal[13] = 50;
        GameEngine.trophyCounterFinal[14] = 100;
        GameEngine.trophyCounterFinal[15] = 200;
        GameEngine.trophyCounterFinal[16] = 500;
        GameEngine.trophyPoints[17] = 50;
        GameEngine.trophyPoints[18] = 50;
        GameEngine.trophyVisible[17] = false;
        GameEngine.trophyVisible[18] = false;
        GameEngine.trophyPoints[19] = 100;
        GameEngine.trophyPoints[20] = 200;
        GameEngine.trophyPoints[21] = 300;
        GameEngine.trophyCounterFinal[19] = 9000;
        GameEngine.trophyCounterFinal[20] = 18000;
        GameEngine.trophyCounterFinal[21] = 36000;
        GameEngine.trophyVisible[19] = false;
        GameEngine.trophyVisible[20] = false;
        GameEngine.trophyVisible[21] = false;
        GameEngine.trophyPoints[22] = 100;
        GameEngine.trophyPoints[23] = 200;
        GameEngine.trophyPoints[24] = 300;
        GameEngine.trophyCounterFinal[22] = 50;
        GameEngine.trophyCounterFinal[23] = 100;
        GameEngine.trophyCounterFinal[24] = 200;
        GameEngine.trophyVisible[22] = false;
        GameEngine.trophyVisible[23] = false;
        GameEngine.trophyVisible[24] = false;
    }

    public static void resLoad(int n, int n2) {
        System.out.println("   Load resource res=" + n + " type=" + n2);
        switch (n2) {
            case 0: {
                if (resAnimations[n] == null) {
                    GameCanvas.resAnimations[n] = new SSAnimation(SSFunctions.getResourceAsStream("/res" + n + ".lqa"));
                    break;
                }
                System.out.println("     RES_CACHE: LQA resource number " + n + " already loaded");
                break;
            }
            case 1: {
                String string = "gnp";
                if (resImages[n] == null) {
                    if (string.equals("gnp")) {
                        try {
                            GameCanvas.resImages[n] = Image.createImage((String)("/res" + n + ".gnp"));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    GameCanvas.resImagesWidth[n] = resImages[n].getWidth();
                    GameCanvas.resImagesHeight[n] = resImages[n].getHeight();
                    break;
                }
                System.out.println("      RES_CACHE: PNG resource number " + n + " already loaded");
                break;
            }
            case 2: {
                if (resFonts[n] == null) {
                    GameCanvas.resFonts[n] = new SSFont(SSFunctions.getResourceAsStream("/res" + n + ".ssf"), null);
                    break;
                }
                System.out.println("      RES_CACHE: SSF resource number " + n + " already loaded");
            }
        }
    }

    public static void resUnload(int n, int n2) {
        switch (n2) {
            case 0: {
                if (resAnimations[n] == null) {
                    System.out.println("      LQA resource number " + n + " is NOT in memory");
                    break;
                }
                GameCanvas.resAnimations[n] = null;
                System.out.println("      LQA resource number " + n + " unloaded");
                break;
            }
            case 1: {
                if (resImages[n] == null) {
                    System.out.println("      PNG resource number " + n + " is NOT in memory");
                    break;
                }
                GameCanvas.resImages[n] = null;
                System.out.println("      PNG resource number " + n + " unloaded");
                break;
            }
            case 2: {
                if (resFonts[n] == null) {
                    System.out.println("      SSF resource number " + n + " is NOT in memory");
                    break;
                }
                GameCanvas.resFonts[n] = null;
                System.out.println("      SSF resource number " + n + " unloaded");
            }
        }
    }

    public void paintMenu(Graphics graphics) {
        graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
        graphics.setColor(0);
        graphics.fillRect(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
        this.paintBackground(graphics);
        GameEngine.menu.paint(graphics);
    }

    public void paintMenuTrophies(Graphics graphics) {
        this.paintMenu(graphics);
        MenuTrophies.paint(graphics);
    }

    public void paintGame(Graphics graphics) {
        GameEngine.board.paint(graphics);
    }

    public void paintPause5(Graphics graphics) {
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 208);
        resFonts[1].drawString(graphics, lang[210].toCharArray(), 88, 104, 3);
    }

    public void paintSplash(Graphics graphics) {
        if (resAnimations[0] != null) {
            graphics.setClip(0, 0, 176, 208);
            graphics.setColor(0);
            graphics.fillRect(0, 0, 176, 208);
            resAnimations[0].drawAnimation(graphics, 0, System.currentTimeMillis() - GameEngine.waitingTime, 15, 104, false);
        }
    }

    public void paintSplashPieEye(Graphics graphics) {
        if (resImages[6] != null) {
            graphics.setClip(0, 0, 176, 208);
            graphics.setColor(0);
            graphics.fillRect(0, 0, 176, 208);
            GameCanvas.paintImage(graphics, 6, 88, 104, 3);
        }
    }

    public void paintSoundQuestion(Graphics graphics) {
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 208);
        resFonts[0].drawString(graphics, lang[1].toCharArray(), 88, 104, 3);
        resFonts[0].drawString(graphics, lang[2].toCharArray(), 2, 206, 68);
        resFonts[0].drawString(graphics, lang[3].toCharArray(), 174, 206, 72);
    }

    public void paintLoading(Graphics graphics) {
        if (resImages[7] != null) {
            graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
            graphics.setColor(0);
            graphics.fillRect(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
            GameCanvas.paintImage(graphics, 7, 0, 0, 20);
        }
        graphics.setColor(0);
        graphics.fillRect(8, 196, 159, 6);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(8, 196, 159, 6);
        graphics.setColor(0xFF0000);
        graphics.fillRect(10, 198, GameEngine.loadingStep * 156 / GameEngine.loadingTotal, 3);
    }

    public void paintObjects(Graphics graphics) {
        switch (GameEngine.state) {
            case 6: {
                resFonts[0].drawString(graphics, lang[35].toCharArray(), GameEngine.objectX[1], GameEngine.objectY[1], 17);
                resAnimations[2].drawAnimation(graphics, GameEngine.levelIcon[GameEngine.levelSelected], System.currentTimeMillis() - MenuSelector.timeIconAnimation, GameEngine.objectX[4], GameEngine.objectY[4], true);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[2], 176, 40);
                this.auxString.setLength(0);
                this.auxString.append(lang[28]);
                this.auxString.append(" ");
                this.auxString.append(GameEngine.levelSelected + 1);
                this.auxString.append("/");
                this.auxString.append(50);
                resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[2], GameEngine.objectY[2] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), GameEngine.objectX[2], GameEngine.objectY[2] + 5 + resFonts[0].getFontHeight() + 8, 17);
                GameCanvas.paintAlpha(graphics, GameEngine.objectX[6], GameEngine.objectY[6], 176, 75);
                this.auxString.setLength(0);
                this.auxString.append(SSFunctions.replace(lang[36], "%%STARS%%", Integer.toString(GameEngine.totalStars)));
                resFonts[2].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 88, GameEngine.objectY[6] + 5, 17);
                this.auxString.setLength(0);
                this.auxString.append(lang[39]);
                this.auxString.append(": ");
                this.auxString.append(GameEngine.totalScore);
                resFonts[2].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 88, GameEngine.objectY[6] + (resFonts[0].getFontHeight() + 7), 17);
                if (GameEngine.totalStars < GameEngine.levelStarsNeeded[GameEngine.levelSelected]) {
                    this.auxString.setLength(0);
                    this.auxString.append(SSFunctions.replace(lang[37], "%%STARS%%", Integer.toString(GameEngine.levelStarsNeeded[GameEngine.levelSelected])));
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 5, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 4), 166, 36, 17);
                } else if (GameEngine.levelBestStars[GameEngine.levelSelected] == 0) {
                    resFonts[0].drawString(graphics, lang[38].toCharArray(), 5, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 4), 166, 36, 17);
                } else {
                    this.auxString.setLength(0);
                    this.auxString.append(lang[40]);
                    this.auxString.append(": ");
                    this.auxString.append(GameEngine.clock.getTimeString(4, GameEngine.levelBestTime[GameEngine.levelSelected]));
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 132 - 10, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 5), 17);
                    this.auxString.setLength(0);
                    this.auxString.append(lang[41]);
                    this.auxString.append(": ");
                    this.auxString.append(GameEngine.levelBestScore[GameEngine.levelSelected]);
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 132 - 10, GameEngine.objectY[6] + 4 * (resFonts[0].getFontHeight() + 5), 17);
                    this.auxString.setLength(0);
                    this.auxString.append(GameEngine.levelBestStars[GameEngine.levelSelected]);
                    this.auxString.append(" ");
                    this.auxString.append(lang[29]);
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 15 + 20, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 5), 17);
                    GameCanvas.paintStars(graphics, GameEngine.levelBestStars[GameEngine.levelSelected], GameEngine.objectX[6] + 40, GameEngine.objectY[6] + 4 + 4 * (resFonts[0].getFontHeight() + 5));
                }
                graphics.setColor(0xFFFFFF);
                graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
                graphics.setStrokeStyle(0);
                graphics.drawLine(GameEngine.objectX[2] - 60, GameEngine.objectY[2] + 5 + resFonts[0].getFontHeight() + 3, GameEngine.objectX[2] + 60, GameEngine.objectY[2] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(GameEngine.objectX[6] + 88 - 100, GameEngine.objectY[6] + 2 * (resFonts[0].getFontHeight() + 5) + 3, GameEngine.objectX[6] + 88 + 100, GameEngine.objectY[6] + 2 * (resFonts[0].getFontHeight() + 5) + 3);
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[3], GameEngine.objectY[3], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[5], GameEngine.objectY[5], 3);
                FX.paintParticles(graphics, resAnimations[3]);
                GameCanvas.paintImage(graphics, 8, GameEngine.objectX[0], GameEngine.objectY[0], 17);
                break;
            }
            case 15: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 176, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 176, GameEngine.objectH[8]);
                if (GameEngine.objectY[7] == GameEngine.objectYfinal[7]) {
                    if (System.currentTimeMillis() - this.aniTime < 400L) {
                        resAnimations[11].drawAnimation(graphics, 0, System.currentTimeMillis() - this.aniTime, 88, 104, false);
                    }
                    this.auxString.setLength(0);
                    this.auxString.append(lang[28]);
                    this.auxString.append(" ");
                    this.auxString.append(GameEngine.levelSelected + 1);
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5, 17);
                    resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 88, GameEngine.objectY[7] + 20, 17);
                    if (GameEngine.gameFramesAux > 10) {
                        resFonts[1].drawString(graphics, GameEngine.levelDescription[GameEngine.levelSelected].toCharArray(), 10, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 20, 156, 65, 17);
                    }
                    if (GameEngine.gameFramesAux > 15 && GameEngine.gameFramesAux % 14 < 7) {
                        resFonts[2].drawString(graphics, lang[45].toCharArray(), 88, GameEngine.objectY[7] + 112, 65);
                    }
                    if (GameEngine.gameFramesAux > 5) {
                        graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.drawLine(88 - Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 88 + Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                        graphics.setStrokeStyle(1);
                        graphics.drawLine(88 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 88 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                        graphics.drawLine(88 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95, 88 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95);
                    }
                } else {
                    GameEngine.gameFramesAux = 0;
                    this.aniTime = System.currentTimeMillis();
                }
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 16: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 176, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 176, GameEngine.objectH[8]);
                this.auxString.setLength(0);
                this.auxString.append(lang[28]);
                this.auxString.append(" ");
                this.auxString.append(GameEngine.levelSelected + 1);
                resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 88, GameEngine.objectY[7] + 20, 17);
                resFonts[1].drawString(graphics, GameEngine.levelDescription[GameEngine.levelSelected].toCharArray(), 10, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 20, 156, 65, 17);
                resFonts[2].drawString(graphics, lang[45].toCharArray(), 88, GameEngine.objectY[7] + 112, 65);
                graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(0);
                graphics.drawLine(88 - Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 88 + Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(88 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 88 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                graphics.drawLine(88 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95, 88 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95);
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 17: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 176, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 176, GameEngine.objectH[8]);
                if (GameEngine.objectY[7] == GameEngine.objectYfinal[7]) {
                    if (GameEngine.gameFramesAux < 10) {
                        graphics.setClip(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.fillRect(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                    }
                    this.auxString.setLength(0);
                    this.auxString.append(SSFunctions.replace(lang[31], "%%NUMBER%%", Integer.toString(GameEngine.levelSelected + 1)));
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5, 17);
                    resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 88, GameEngine.objectY[7] + 20, 17);
                    if (GameEngine.gameFramesAux > 10) {
                        this.auxString.setLength(0);
                        this.auxString.append(lang[42]);
                        this.auxString.append(": ");
                        this.auxString.append(GameEngine.levelTimeString);
                        resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 22, 17);
                    }
                    if (GameEngine.gameFramesAux > 15) {
                        this.auxString.setLength(0);
                        this.auxString.append(lang[43]);
                        this.auxString.append(": ");
                        this.auxString.append(GameEngine.levelScore);
                        resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5 + 3 * resFonts[0].getFontHeight() + 24, 17);
                    }
                    if (GameEngine.gameFramesAux > 20) {
                        this.auxString.setLength(0);
                        this.auxString.append(SSFunctions.replace(lang[44], "%%STARS%%", Integer.toString(GameEngine.levelStars)));
                        resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 26, 17);
                    }
                    if (GameEngine.gameFramesAux > 25) {
                        GameCanvas.paintStars(graphics, 5, 5 - GameEngine.levelStars, 93, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 45);
                    }
                    if (GameEngine.gameFramesAux > 5) {
                        graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                        graphics.setStrokeStyle(1);
                        graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                        graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103);
                    }
                } else {
                    GameEngine.gameFramesAux = 0;
                }
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 18: 
            case 19: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 176, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 176, GameEngine.objectH[8]);
                if (GameEngine.objectY[7] == GameEngine.objectYfinal[7]) {
                    if (GameEngine.gameFramesAux < 10) {
                        graphics.setClip(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.fillRect(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                    }
                    this.auxString.setLength(0);
                    this.auxString.append(lang[28]);
                    this.auxString.append(" ");
                    this.auxString.append(GameEngine.levelSelected + 1);
                    this.auxString.append("/");
                    this.auxString.append(50);
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5, 17);
                    resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 88, GameEngine.objectY[7] + 20, 17);
                    if (GameEngine.gameFramesAux > 10) {
                        if (GameEngine.state == 18) {
                            resFonts[3].drawString(graphics, lang[32].toCharArray(), 88, 114, 3);
                        } else {
                            resFonts[3].drawString(graphics, lang[59].toCharArray(), 88, 114, 3);
                        }
                    }
                    if (GameEngine.gameFramesAux > 5) {
                        graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                        graphics.setStrokeStyle(1);
                        graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                        graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103);
                    }
                } else {
                    GameEngine.gameFramesAux = 0;
                }
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 22: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 176, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 176, GameEngine.objectH[8]);
                this.auxString.setLength(0);
                this.auxString.append(lang[28]);
                this.auxString.append(" ");
                this.auxString.append(GameEngine.levelSelected + 1);
                resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 88, GameEngine.objectY[7] + 20, 17);
                resFonts[1].drawString(graphics, GameEngine.levelDescription[GameEngine.levelSelected].toCharArray(), 10, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 20, 156, 65, 17);
                if (GameEngine.gameFramesAux > 15 && GameEngine.gameFramesAux % 14 < 7) {
                    resFonts[2].drawString(graphics, lang[8].toCharArray(), 88, GameEngine.objectY[7] + 112, 65);
                }
                graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(0);
                graphics.drawLine(88 - Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 88 + Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(88 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 88 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                graphics.drawLine(88 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95, 88 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95);
                break;
            }
            case 9: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 176, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 176, GameEngine.objectH[8]);
                resFonts[3].drawString(graphics, lang[50].toString().toCharArray(), 88, GameEngine.objectY[7] + 5, 17);
                resFonts[2].drawString(graphics, GameEngine.trophyTitle[GameEngine.trophyToShow].toCharArray(), 88, GameEngine.objectY[7] + 20, 17);
                resFonts[1].drawString(graphics, GameEngine.trophyDescription[GameEngine.trophyToShow].toString().toCharArray(), 2, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 22, 172, 30, 17);
                resAnimations[12].drawAnimation(graphics, 1, System.currentTimeMillis(), 88, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 37, true);
                this.auxString.setLength(0);
                this.auxString.append(GameEngine.trophyPoints[GameEngine.trophyToShow]);
                this.auxString.append(" ");
                this.auxString.append(lang[30]);
                resFonts[0].drawString(graphics, this.auxString.toString().toCharArray(), 88, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 50, 17);
                graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(0);
                graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(88 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 88 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
            }
        }
    }

    public void paintScoreBoard(Graphics graphics) {
        resFonts[0].drawString(graphics, lang[46].toCharArray(), 5, 2, 20);
        if (BoardManager.arenaVictory == 0) {
            resFonts[2].drawString(graphics, lang[47].toCharArray(), 5, 15, 20);
        } else {
            resFonts[2].drawString(graphics, lang[48].toCharArray(), 5, 15, 20);
        }
        resFonts[0].drawString(graphics, lang[42].toCharArray(), 171, 2, 24);
        resFonts[2].drawString(graphics, GameEngine.clock.getTimeString(4).toCharArray(), 171, 15, 24);
        if (GameEngine.clock.getMilliseconds() < 46000L) {
            GameCanvas.paintStars(graphics, 5, 151, 36);
        } else if (GameEngine.clock.getMilliseconds() < 56000L) {
            GameCanvas.paintStars(graphics, 5, 1, 151, 36);
        } else if (GameEngine.clock.getMilliseconds() < 66000L) {
            GameCanvas.paintStars(graphics, 5, 2, 151, 36);
        } else if (GameEngine.clock.getMilliseconds() < 91000L) {
            GameCanvas.paintStars(graphics, 5, 3, 151, 36);
        } else {
            GameCanvas.paintStars(graphics, 5, 4, 151, 36);
        }
    }

    public void paintBackgroundOld(Graphics graphics) {
        if (GameEngine.uiBackgroundSwap) {
            int n = 4;
            GameCanvas.paintImage(graphics, GameEngine.uiBackgroundOut, 0, 0, 20);
            switch (GameEngine.uiBackgroundSwapDir) {
                case -1: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    if (GameEngine.uiBackgroundStep > 20 + 176 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                    break;
                }
                case 0: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(Math.max(0, 176 - GameEngine.uiBackgroundStep * n), 0, 176, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    if (GameEngine.uiBackgroundStep > 20 + 176 / (2 * n)) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 3;
                    break;
                }
                case 1: {
                    graphics.setClip(Math.max(0, 176 - GameEngine.uiBackgroundStep * n), 0, 176, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(176 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    if (GameEngine.uiBackgroundStep > 20 + 176 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                }
            }
        } else {
            GameCanvas.paintImage(graphics, GameEngine.uiBackground, 0, 0, 20);
            if (System.currentTimeMillis() - GameEngine.lastKeyPressedTime > 200L) {
                if (GameEngine.uiBackground != GameEngine.uiBackgroundNext) {
                    GameEngine.uiBackgroundSwap = true;
                    GameEngine.uiBackgroundStep = -20;
                    GameEngine.uiBackgroundIn = GameEngine.uiBackgroundNext;
                    GameEngine.uiBackgroundOut = GameEngine.uiBackground;
                    GameEngine.uiBackgroundSwapDir = GameEngine.uiBackgroundSwapDirNext;
                }
            }
        }
    }

    public void paintBackground(Graphics graphics) {
        if (GameEngine.uiBackgroundSwap) {
            int n = 4;
            GameCanvas.paintImage(graphics, GameEngine.uiBackgroundOut, 88, 104, 3);
            switch (GameEngine.uiBackgroundSwapDir) {
                case -1: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    if (GameEngine.uiBackgroundStep > 20 + 176 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                    break;
                }
                case 0: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(Math.max(0, 176 - GameEngine.uiBackgroundStep * n), 0, 176, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    if (GameEngine.uiBackgroundStep > 20 + 176 / (2 * n)) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 3;
                    break;
                }
                case 1: {
                    graphics.setClip(Math.max(0, 176 - GameEngine.uiBackgroundStep * n), 0, 176, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    graphics.setClip(176 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 208);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 88, 104, 3);
                    if (GameEngine.uiBackgroundStep > 20 + 176 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                }
            }
        } else {
            GameCanvas.paintImage(graphics, GameEngine.uiBackground, 88, 104, 3);
            if (System.currentTimeMillis() - GameEngine.lastKeyPressedTime > 200L) {
                if (GameEngine.uiBackground != GameEngine.uiBackgroundNext) {
                    GameEngine.uiBackgroundSwap = true;
                    GameEngine.uiBackgroundStep = -20;
                    GameEngine.uiBackgroundIn = GameEngine.uiBackgroundNext;
                    GameEngine.uiBackgroundOut = GameEngine.uiBackground;
                    GameEngine.uiBackgroundSwapDir = GameEngine.uiBackgroundSwapDirNext;
                }
            }
        }
    }

    public static void paintAlpha(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i <= n3 / 20; ++i) {
            for (int j = 0; j <= n4 / 20; ++j) {
                graphics.setClip(n + i * 20, n2 + j * 20, Math.min(n3 - i * 20, 20), Math.min(n4 - j * 20, 20));
                graphics.drawImage(resImages[10], n + i * 20, n2 + j * 20, 20);
            }
        }
    }

    public static void paintFrameItem(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        graphics.setClip(n, n2, 8, 8);
        graphics.drawImage(resImages[9], n, n2, 20);
        graphics.setClip(n + n3 - 8, n2, 8, 8);
        graphics.drawImage(resImages[9], n + n3 - 36, n2, 20);
        graphics.setClip(n, n2 + n4 - 8, 8, 8);
        graphics.drawImage(resImages[9], n, n2 + n4 - 36, 20);
        graphics.setClip(n + n3 - 8, n2 + n4 - 8, 8, 8);
        graphics.drawImage(resImages[9], n + n3 - 36, n2 + n4 - 36, 20);
        for (n5 = 0; n5 <= (n3 - 16) / 20; ++n5) {
            graphics.setClip(n + 8 + n5 * 20, n2, Math.min(n3 - 16 - n5 * 20, 20), 8);
            graphics.drawImage(resImages[9], n + n5 * 20, n2, 20);
            graphics.setClip(n + 8 + n5 * 20, n2 + n4 - 8, Math.min(n3 - 16 - n5 * 20, 20), 8);
            graphics.drawImage(resImages[9], n + n5 * 20, n2 + n4, 36);
        }
        for (n5 = 0; n5 <= (n4 - 16) / 20; ++n5) {
            graphics.setClip(n, n2 + 8 + n5 * 20, 8, Math.min(n4 - 16 - n5 * 20, 20));
            graphics.drawImage(resImages[9], n, n2 + n5 * 20, 20);
            graphics.setClip(n + n3 - 8, n2 + 8 + n5 * 20, 8, Math.min(n4 - 16 - n5 * 20, 20));
            graphics.drawImage(resImages[9], n + n3, n2 + n5 * 20, 24);
        }
        for (n5 = 0; n5 <= (n3 - 16) / 20; ++n5) {
            for (int i = 0; i <= (n4 - 16) / 20; ++i) {
                graphics.setClip(n + 8 + n5 * 20, n2 + 8 + i * 20, Math.min(n3 - 16 - n5 * 20, 20), Math.min(n4 - 16 - i * 20, 20));
                graphics.drawImage(resImages[9], n + n5 * 20, n2 + i * 20, 20);
            }
        }
    }

    public static void paintStars(Graphics graphics, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            resAnimations[4].drawAnimation(graphics, 0, System.currentTimeMillis() - (long)(50 * i), n2 - 5 * n + 10 * i, n3, true);
        }
    }

    public static void paintStars(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n; ++i) {
            if (i < n - n2) {
                resAnimations[4].drawAnimation(graphics, 0, System.currentTimeMillis() - (long)(50 * i), n3 - 5 * n + 10 * i, n4, true);
                continue;
            }
            GameCanvas.paintImage(graphics, 15, n3 - 5 * n + 10 * i, n4, 3);
        }
    }

    public static void paintImage(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 20: {
                graphics.setClip(n2, n3, resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 17: {
                graphics.setClip(n2 - (resImagesWidth[n] >> 1), n3, resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 24: {
                graphics.setClip(n2 - resImagesWidth[n], n3, resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 6: {
                graphics.setClip(n2, n3 - (resImagesHeight[n] >> 1), resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 3: {
                graphics.setClip(n2 - (resImagesWidth[n] >> 1), n3 - (resImagesHeight[n] >> 1), resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 10: {
                graphics.setClip(n2 - resImagesWidth[n], n3 - (resImagesHeight[n] >> 1), resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 36: {
                graphics.setClip(n2, n3 - resImagesHeight[n], resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 33: {
                graphics.setClip(n2 - (resImagesWidth[n] >> 1), n3 - resImagesHeight[n], resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 40: {
                graphics.setClip(n2 - resImagesWidth[n], n3 - resImagesHeight[n], resImagesWidth[n], resImagesHeight[n]);
            }
        }
        if (resImages[n] == null) {
            System.out.println("*** resImages[" + n + "] is NULL");
        } else {
            graphics.drawImage(resImages[n], n2, n3, n4);
        }
    }

    public void paintLandscape(Graphics graphics) {
        GameCanvas.paintImage(graphics, 8, this.ge.getWidth() >> 1, this.ge.getHeight() >> 1, 3);
        resFonts[0].drawString(graphics, lang[58].toCharArray(), this.ge.getWidth() >> 1, this.ge.getHeight() + resImages[8].getHeight() + 10 >> 1, 17);
    }
}

