/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.Ball;
import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Math2D;
import com.lemonquest.circulate.Wall;
import javax.microedition.lcdui.Graphics;

public class Container {
    GameEngine ge;
    public int typeBall;
    public int quantity;
    public Wall invisibleWall = null;
    public int offsetWall = 0;
    public long width = 0L;
    public long height = 0L;
    public long width2 = 0L;
    public long height2 = 0L;
    public long[] center = new long[2];
    public long[] centerIni = new long[2];
    public int ballsInside = 0;
    public boolean full = false;
    private long d1 = 0L;
    private long d2 = 0L;

    public Container(GameEngine gameEngine, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ge = gameEngine;
        this.typeBall = n;
        this.quantity = n2;
        this.width2 = (long)(n5 * n5) << 10;
        this.height2 = (long)(n6 * n6) << 10;
        this.width = (long)n5 << 10;
        this.height = (long)n6 << 10;
        this.center[0] = (long)n3 << 10;
        this.center[1] = (long)n4 << 10;
        this.centerIni[0] = (long)n3 << 10;
        this.centerIni[1] = (long)n4 << 10;
        long[] lArray = new long[]{this.height / 2L, this.width / 2L};
        long[] lArray2 = new long[]{-this.height / 2L, this.width / 2L};
        long[] lArray3 = new long[]{-this.height / 2L, -this.width / 2L};
        long[] lArray4 = new long[]{this.height / 2L, -this.width / 2L};
        lArray = Math2D.rotatePoint(lArray[0], lArray[1], n7);
        lArray2 = Math2D.rotatePoint(lArray2[0], lArray2[1], n7);
        lArray3 = Math2D.rotatePoint(lArray3[0], lArray3[1], n7);
        lArray4 = Math2D.rotatePoint(lArray4[0], lArray4[1], n7);
        lArray[0] = lArray[0] + (long)(n3 << 10);
        lArray2[0] = lArray2[0] + (long)(n3 << 10);
        lArray3[0] = lArray3[0] + (long)(n3 << 10);
        lArray4[0] = lArray4[0] + (long)(n3 << 10);
        lArray[1] = lArray[1] + (long)(n4 << 10);
        lArray2[1] = lArray2[1] + (long)(n4 << 10);
        lArray3[1] = lArray3[1] + (long)(n4 << 10);
        lArray4[1] = lArray4[1] + (long)(n4 << 10);
        this.invisibleWall = new Wall(-1, Math2D.getPixel(lArray[0]), Math2D.getPixel(lArray[1]), Math2D.getPixel(lArray4[0]), Math2D.getPixel(lArray4[1]));
        this.offsetWall = BoardManager.wallCnt;
        BoardManager.walls[BoardManager.wallCnt] = new Wall(BoardManager.wallCnt, Math2D.getPixel(lArray[0]), Math2D.getPixel(lArray[1]), Math2D.getPixel(lArray2[0]), Math2D.getPixel(lArray2[1]));
        BoardManager.walls[++BoardManager.wallCnt] = new Wall(BoardManager.wallCnt, Math2D.getPixel(lArray2[0]), Math2D.getPixel(lArray2[1]), Math2D.getPixel(lArray3[0]), Math2D.getPixel(lArray3[1]));
        BoardManager.walls[++BoardManager.wallCnt] = new Wall(BoardManager.wallCnt, Math2D.getPixel(lArray3[0]), Math2D.getPixel(lArray3[1]), Math2D.getPixel(lArray4[0]), Math2D.getPixel(lArray4[1]));
        ++BoardManager.wallCnt;
    }

    public boolean checkBallInside(Ball ball) {
        this.d1 = Math2D.distanceBallWall_Pow2(ball, BoardManager.walls[this.offsetWall]);
        this.d2 = Math2D.distanceBallWall_Pow2(ball, BoardManager.walls[this.offsetWall + 2]);
        if (this.d1 < Math2D.pow2(this.width - (ball.rad >> 1)) && this.d2 < Math2D.pow2(this.width - (ball.rad >> 1))) {
            this.d1 = Math2D.distanceBallWall_Pow2(ball, BoardManager.walls[this.offsetWall + 1]);
            this.d2 = Math2D.distanceBallWall_Pow2(ball, this.invisibleWall);
            if (this.d1 < Math2D.pow2(this.height - (ball.rad >> 1)) && this.d2 < Math2D.pow2(this.height - (ball.rad >> 1))) {
                return true;
            }
        }
        return false;
    }

    public boolean checkIsFull(Ball[] ballArray, int n) {
        this.ballsInside = 0;
        for (int i = 0; i < n; ++i) {
            if (ballArray[i].type != this.typeBall || !this.checkBallInside(ballArray[i])) continue;
            ++this.ballsInside;
        }
        return this.ballsInside >= this.quantity;
    }

    public void updatePosition(int n) {
        this.center = Math2D.rotatePoint(this.centerIni[0], this.centerIni[1], n);
        this.invisibleWall.updatePosition(n);
    }

    public void paintContainer(Graphics graphics, int n, int n2) {
        graphics.setColor(BoardManager.BALL_COLORS[this.typeBall]);
        graphics.setClip(0, 0, 176, 208);
        graphics.drawLine(n + Math2D.getPixel(BoardManager.walls[this.offsetWall].posA[0]), n2 - Math2D.getPixel(BoardManager.walls[this.offsetWall].posA[1]), n + Math2D.getPixel(BoardManager.walls[this.offsetWall + 2].posA[0]), n2 - Math2D.getPixel(BoardManager.walls[this.offsetWall + 2].posA[1]));
        graphics.drawLine(n + Math2D.getPixel(BoardManager.walls[this.offsetWall].posB[0]), n2 - Math2D.getPixel(BoardManager.walls[this.offsetWall].posB[1]), n + Math2D.getPixel(BoardManager.walls[this.offsetWall + 2].posB[0]), n2 - Math2D.getPixel(BoardManager.walls[this.offsetWall + 2].posB[1]));
        graphics.fillArc(n + Math2D.getPixel(this.center[0]) - 9, n2 - Math2D.getPixel(this.center[1]) - 9, 18, 18, 0, 360);
        GameCanvas.resFonts[0].drawString(graphics, Integer.toString(Math.max(0, this.quantity - this.ballsInside)).toCharArray(), n + Math2D.getPixel(this.center[0]), n2 - Math2D.getPixel(this.center[1]), 3);
    }
}

