/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.Ball;
import com.lemonquest.circulate.Container;
import com.lemonquest.circulate.Cwall;
import com.lemonquest.circulate.Door;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Hole;
import com.lemonquest.circulate.Math2D;
import com.lemonquest.circulate.Thrower;
import com.lemonquest.circulate.Wall;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSMath;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class BoardManager {
    GameEngine ge;
    public static final int SPEED = 3;
    public static final int MIN_STEP = 2;
    private static final int MAX_ITERATIONS = 15;
    private static final long ERROR_ALLOWED = 3072L;
    private static final int MOVE_STEPS = 1;
    public static boolean paintObjects = true;
    public static final int VICTORY_CLEAR_BALLS = 0;
    public static final int VICTORY_FILL_CONTAINERS = 1;
    public static int arenaVictory = 0;
    public static int arenaOffsetOX = 0;
    public static int arenaOffsetOY = 0;
    public static long arenaRadius = 0L;
    public static int arenaAngle = 0;
    public static int arenaAngleSpeed = 0;
    public static int arenaAngleStep = 1;
    public static int arenaAngleSpeedMin = 2;
    public static int arenaAngleSpeedMax = 10;
    public static int arenaSpeedUpTime = 250;
    public static long arenaGravity = 0L;
    public static int arenaBgActive = 0;
    public static int arenaColor = 0xFFFFFF;
    public static final int BALL_RED = 0;
    public static final int BALL_GREEN = 1;
    public static final int BALL_BLUE = 2;
    public static final int BALL_YELLOW = 3;
    public static final int BALL_FIRE = 4;
    public static final int BALL_ICE = 5;
    public static final int BALL_METAL = 6;
    public static final int BALL_STOP = 7;
    public static final int BALL_BUBBLE = 8;
    public static final int BALL_BOMB = 9;
    public static final int[] BALL_COLORS = new int[]{11806762, 11656995, 37879, 16374054, 14965251, 12246770, 0x808080, 11357425, 4614524, 0};
    public static final int BALL_NORMAL = 0;
    public static final int BALL_BIG = 1;
    public static final long TIME_ACTIONKEY = 2000L;
    public static final long TIME_DESTROY = 690L;
    public static final long TIME_TOGETHER = 1800L;
    public static final long TIME_EXPLODE = 490L;
    public static final long BOMB_RANGE = 921600L;
    public static final int MAX_BALLS = 16;
    public static Ball[] balls = new Ball[16];
    public static int ballCnt = 0;
    public static int[] ballTypeCnt = new int[15];
    public static int[] ballTypeCntInit = new int[15];
    public static int[][] ballsTogether = new int[16][16];
    public static int[] ballTypeTogetherCnt = new int[15];
    public static boolean[] ballTogetherList = new boolean[16];
    public SSAnimation holeDownGraph = null;
    public SSAnimation holeUpGraph = null;
    public static boolean isAnyBallDestroyed = false;
    public static final int MAX_WALLS = 32;
    public static Wall[] walls = new Wall[32];
    public static int wallCnt = 0;
    public static final int MAX_CWALLS = 16;
    public static Cwall[] cwalls = new Cwall[16];
    public static int cWallCnt = 0;
    public static final int MAX_CONTAINERS = 4;
    public static Container[] containers = new Container[4];
    public static int containerCnt = 0;
    public static final int MAX_DOORS = 4;
    public static Door[] doors = new Door[4];
    public static int doorCnt = 0;
    public static final int MAX_HOLES = 4;
    public static Hole[] holes = new Hole[4];
    public static int holeCnt = 0;
    public static final int MAX_THROWERS = 4;
    public static Thrower[] throwers = new Thrower[4];
    public static int throwerCnt = 0;
    public static final int COLLISION_BEFORE = 0;
    public static final int COLLISION_AFTER = 1;
    public static final int COLLISION_NONE = 0;
    public static final int COLLISION_INNER = 1;
    public static final int COLLISION_VERTEX_A = 2;
    public static final int COLLISION_VERTEX_B = 3;
    public int it = 0;
    public long d = 0L;
    public long dA = 0L;
    public long dB = 0L;
    public long[] u = new long[]{0L, 0L};
    public long[] v = new long[]{0L, 0L};
    public String auxString = "";
    public StringBuffer auxStringBuffer = new StringBuffer(16);
    public static long auxFrames = 1L;

    public BoardManager(GameEngine gameEngine) {
        this.ge = gameEngine;
        arenaAngleSpeed = 0;
        arenaRadius = 86016L;
        arenaGravity = 5120L;
        arenaOffsetOX = GameEngine.uiDeviceWidth >> 1;
        arenaOffsetOY = GameEngine.uiDeviceHeight >> 1;
        this.in();
    }

    public void processArena() {
        this.updateArena();
        this.it = 0;
        while (this.it < 15) {
            this.checkArenaCollisions();
            ++this.it;
        }
        this.logic();
    }

    public void in() {
        paintObjects = true;
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameEngine.objectXfinal[3] = -GameCanvas.resImagesWidth[11];
        GameEngine.objectYfinal[3] = 150;
        GameEngine.objectXfinal[4] = 88;
        GameEngine.objectYfinal[4] = 208 + GameEngine.objectH[4];
        GameCanvas cfr_ignored_1 = this.ge.gc;
        GameEngine.objectXfinal[5] = 176 + GameCanvas.resImagesWidth[11];
        GameEngine.objectYfinal[5] = 150;
    }

    public void out() {
        paintObjects = true;
        GameEngine.objectXfinal[3] = 50;
        GameEngine.objectYfinal[3] = 150;
        GameEngine.objectXfinal[4] = 88;
        GameEngine.objectYfinal[4] = 150;
        GameEngine.objectXfinal[5] = 126;
        GameEngine.objectYfinal[5] = 150;
    }

    public void inLabels() {
        paintObjects = true;
        GameEngine.objectY[7] = -GameEngine.objectH[7];
        GameEngine.objectYfinal[7] = (208 - GameEngine.objectH[7] - GameEngine.objectH[8]) / 2;
        GameEngine.objectY[8] = 208;
        GameEngine.objectYfinal[8] = GameEngine.objectYfinal[7] + GameEngine.objectH[7];
    }

    public void outLabels() {
        paintObjects = true;
        GameEngine.objectYfinal[7] = 208;
        GameEngine.objectYfinal[8] = 208 + GameEngine.objectH[7];
    }

    public void inPreview() {
        paintObjects = true;
        GameEngine.objectXfinal[4] = -GameCanvas.resImagesWidth[11];
        GameEngine.objectYfinal[4] = 150;
        GameEngine.objectXfinal[6] = 176 + GameCanvas.resImagesWidth[11];
        GameEngine.objectYfinal[6] = 150;
        GameEngine.objectY[7] = -GameEngine.objectH[7];
        GameEngine.objectYfinal[7] = (208 - GameEngine.objectH[7] - GameEngine.objectH[8]) / 2;
        GameEngine.objectY[8] = 208;
        GameEngine.objectYfinal[8] = GameEngine.objectYfinal[7] + GameEngine.objectH[7];
    }

    private void updateArena() {
        if (arenaAngleSpeed == 0) {
            for (int i = 0; i < ballCnt; ++i) {
                BoardManager.ballTogetherList[i] = false;
                if (BoardManager.balls[i].status != 0 && BoardManager.balls[i].status != 1) continue;
                BoardManager.balls[i].pos[1] = BoardManager.balls[i].pos[1] - (arenaGravity * BoardManager.balls[i].gravity >> 10);
            }
        } else {
            int n;
            for (n = 0; n < ballCnt; ++n) {
                BoardManager.ballTogetherList[n] = false;
                if (BoardManager.balls[n].type == 8 || BoardManager.balls[n].status != 0 && BoardManager.balls[n].status != 1) continue;
                BoardManager.balls[n].pos[1] = BoardManager.balls[n].pos[1] - arenaGravity / 4L;
            }
            for (n = 0; n < containerCnt; ++n) {
                containers[n].updatePosition(arenaAngle);
            }
            for (n = 0; n < wallCnt; ++n) {
                walls[n].updatePosition(arenaAngle);
            }
            for (n = 0; n < cWallCnt; ++n) {
                BoardManager.cwalls[n].pos = Math2D.rotatePoint(BoardManager.cwalls[n].posIni[0], BoardManager.cwalls[n].posIni[1], arenaAngle);
            }
            for (n = 0; n < throwerCnt; ++n) {
                throwers[n].updatePosition(arenaAngle);
            }
            for (n = 0; n < holeCnt; ++n) {
                BoardManager.holes[n].pos = Math2D.rotatePoint(BoardManager.holes[n].posIni[0], BoardManager.holes[n].posIni[1], arenaAngle);
            }
            for (n = 0; n < ballCnt; ++n) {
                if (BoardManager.balls[n].status != 0 && BoardManager.balls[n].status != 1 && BoardManager.balls[n].status != 2) continue;
                BoardManager.balls[n].pos = Math2D.rotatePoint(BoardManager.balls[n].pos[0], BoardManager.balls[n].pos[1], arenaAngleSpeed);
            }
        }
        FX.processParticles();
    }

    private void checkArenaCollisions() {
        for (int i = 0; i < ballCnt; ++i) {
            int n;
            if (BoardManager.balls[i].status == -2) continue;
            BoardManager.ballsTogether[i][i] = 1;
            block6: for (n = 0; n < ballCnt; ++n) {
                if (i == n) continue;
                BoardManager.ballsTogether[i][n] = 0;
                BoardManager.ballsTogether[n][i] = 0;
                if (!this.checkCollisionFast(balls[i], balls[n])) continue;
                this.d = Math2D.distancePointPoint_Pow2(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1], BoardManager.balls[n].pos[0], BoardManager.balls[n].pos[1]);
                if (this.d < Math2D.pow2(BoardManager.balls[i].rad + BoardManager.balls[n].rad)) {
                    this.d = BoardManager.balls[i].rad + BoardManager.balls[n].rad - Math2D.sqrt(this.d);
                    this.u = Math2D.normalize(BoardManager.balls[n].pos[0] - BoardManager.balls[i].pos[0], BoardManager.balls[n].pos[1] - BoardManager.balls[i].pos[1]);
                    if (BoardManager.balls[i].status == 2) {
                        balls[n].displace(this.u[0], this.u[1], this.d / 1L);
                    } else if (BoardManager.balls[n].status == 2) {
                        balls[i].displace(this.u[0], this.u[1], -this.d / 1L);
                    } else {
                        balls[i].displace(this.u[0], this.u[1], -this.d / 2L / 1L);
                        balls[n].displace(this.u[0], this.u[1], this.d / 2L / 1L);
                    }
                }
                if (this.it != 14) continue;
                switch (BoardManager.balls[i].type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (BoardManager.balls[i].type != BoardManager.balls[n].type || this.d > Math2D.pow2(BoardManager.balls[i].rad + BoardManager.balls[n].rad + 3072L)) continue block6;
                        BoardManager.ballsTogether[i][n] = 1;
                        BoardManager.ballsTogether[n][i] = 1;
                        continue block6;
                    }
                    case 4: 
                    case 5: {
                        if (BoardManager.balls[i].type == BoardManager.balls[n].type || BoardManager.balls[n].type != 4 && BoardManager.balls[n].type != 5 || this.d > Math2D.pow2(BoardManager.balls[i].rad + BoardManager.balls[n].rad)) continue block6;
                        BoardManager.ballsTogether[i][n] = 1;
                        BoardManager.ballsTogether[n][i] = 1;
                        continue block6;
                    }
                    case 8: {
                        if (BoardManager.balls[n].type == 8 || BoardManager.balls[n].type == 7 || this.d > Math2D.pow2(BoardManager.balls[i].rad + BoardManager.balls[n].rad)) continue block6;
                        balls[i].setDestroy(System.currentTimeMillis());
                    }
                }
            }
            if (Math2D.distancePointPoint_Pow2(0L, 0L, BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1]) > Math2D.pow2(arenaRadius - BoardManager.balls[i].rad)) {
                this.u = Math2D.normalize(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1]);
                balls[i].place(this.u[0] * (arenaRadius - BoardManager.balls[i].rad) >> 10, this.u[1] * (arenaRadius - BoardManager.balls[i].rad) >> 10);
            }
            if (this.it == 14 || this.it % 2 == 1) {
                for (n = 0; n < wallCnt; ++n) {
                    if (!BoardManager.walls[n].isVisible) continue;
                    balls[i].checkCollisionTypeWith(walls[n]);
                }
                for (n = 0; n < wallCnt; ++n) {
                    if (!BoardManager.walls[n].isVisible || BoardManager.balls[i].collideWithWall[n] != 1) continue;
                    this.d = Math2D.distanceBallWall_Pow2(balls[i], walls[n]);
                    if (this.d >= BoardManager.balls[i].rad2) continue;
                    this.d = Math2D.sqrt(this.d);
                    this.v = walls[n].normal(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1]);
                    balls[i].displace(this.v[0], this.v[1], BoardManager.balls[i].rad - this.d);
                }
                for (n = 0; n < wallCnt; ++n) {
                    if (!BoardManager.walls[n].isVisible) continue;
                    if (BoardManager.balls[i].collideWithWall[n] == 2) {
                        this.dA = Math2D.distancePointPoint_Pow2(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1], BoardManager.walls[n].posA[0], BoardManager.walls[n].posA[1]);
                        this.dA = Math2D.sqrt(this.dA);
                        this.v = Math2D.normalize(BoardManager.balls[i].pos[0] - BoardManager.walls[n].posA[0], BoardManager.balls[i].pos[1] - BoardManager.walls[n].posA[1]);
                        balls[i].displace(this.v[0], this.v[1], BoardManager.balls[i].rad - this.dA);
                        continue;
                    }
                    if (BoardManager.balls[i].collideWithWall[n] != 3) continue;
                    this.dB = Math2D.distancePointPoint_Pow2(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1], BoardManager.walls[n].posB[0], BoardManager.walls[n].posB[1]);
                    this.dB = Math2D.sqrt(this.dB);
                    this.v = Math2D.normalize(BoardManager.balls[i].pos[0] - BoardManager.walls[n].posB[0], BoardManager.balls[i].pos[1] - BoardManager.walls[n].posB[1]);
                    balls[i].displace(this.v[0], this.v[1], BoardManager.balls[i].rad - this.dB);
                }
            }
            if (this.it == 14 || this.it % 2 == 0) {
                for (n = 0; n < cWallCnt; ++n) {
                    long l;
                    if (!this.checkCollisionFast(balls[i], cwalls[n]) || (l = Math2D.distancePointPoint_Pow2(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1], BoardManager.cwalls[n].pos[0], BoardManager.cwalls[n].pos[1])) >= Math2D.pow2(BoardManager.balls[i].rad + BoardManager.cwalls[n].rad)) continue;
                    l = Math2D.sqrt(l);
                    this.v = cwalls[n].normal(BoardManager.balls[i].pos[0], BoardManager.balls[i].pos[1]);
                    balls[i].displace(this.v[0], this.v[1], (BoardManager.balls[i].rad + BoardManager.cwalls[n].rad - l) / 1L);
                }
            }
            if (this.it != 14 || BoardManager.balls[i].isTrapped) continue;
            for (n = 0; !(n >= holeCnt || this.checkCollisionFast(balls[i], holes[n]) && holes[n].isBallTrapped(i)); ++n) {
            }
        }
    }

    public void logic() {
        int n;
        isAnyBallDestroyed = false;
        if (ballTypeCnt[0] + ballTypeCnt[1] + ballTypeCnt[2] + ballTypeCnt[3] != 0) {
            isAnyBallDestroyed = this.destroyBallsColor();
        }
        if (ballTypeCnt[4] + ballTypeCnt[5] != 0) {
            isAnyBallDestroyed = isAnyBallDestroyed || this.destroyBallsFireIce();
        }
        for (n = 0; n < throwerCnt; ++n) {
            if (ballCnt >= 16 || BoardManager.throwers[n].fireNext < 0) continue;
            throwers[n].fireBall();
        }
        if (!isAnyBallDestroyed) {
            this.gcBalls();
        }
        switch (arenaVictory) {
            case 0: {
                if (!(ballTypeCntInit[0] == 0 && ballTypeCntInit[1] == 0 && ballTypeCntInit[2] == 0 && ballTypeCntInit[3] == 0 || ballTypeCnt[0] == 0 && ballTypeCnt[1] == 0 && ballTypeCnt[2] == 0 && ballTypeCnt[3] == 0)) {
                    if (!(ballTypeCnt[0] != 0 && ballTypeCnt[0] != ballTypeCntInit[0] || ballTypeCnt[1] != 0 && ballTypeCnt[1] != ballTypeCntInit[1] || ballTypeCnt[2] != 0 && ballTypeCnt[2] != ballTypeCntInit[2]) && (ballTypeCnt[3] == 0 || ballTypeCnt[3] == ballTypeCntInit[3])) break;
                    GameEngine.state = 18;
                    GameEngine.uiKeyLeftPressed = false;
                    GameEngine.uiKeyRightPressed = false;
                    GameEngine.clock.stop();
                    this.inLabels();
                    if (!GameEngine.configSound) break;
                    this.ge.sound.playMidi(2, 1);
                    break;
                }
                if (ballTypeCnt[4] != 0 || ballTypeCnt[5] != 0 || ballTypeCnt[6] != 0 && ballTypeCntInit[0] == 0 && ballTypeCntInit[1] == 0 && ballTypeCntInit[2] == 0 && ballTypeCntInit[3] == 0) break;
                GameEngine.state = 17;
                this.andThenThereWasVictory();
                if (!GameEngine.configSound) break;
                this.ge.sound.playMidi(1, 1);
                break;
            }
            case 1: {
                GameEngine.state = 17;
                for (n = 0; n < containerCnt; ++n) {
                    if (throwerCnt == 0 && BoardManager.containers[n].quantity > ballTypeCnt[BoardManager.containers[n].typeBall]) {
                        GameEngine.state = 18;
                        GameEngine.uiKeyLeftPressed = false;
                        GameEngine.uiKeyRightPressed = false;
                        GameEngine.clock.stop();
                        this.inLabels();
                        if (!GameEngine.configSound) break;
                        this.ge.sound.playMidi(2, 1);
                        break;
                    }
                    if (containers[n].checkIsFull(balls, ballCnt)) continue;
                    GameEngine.state = GameEngine.editorMode ? 24 : 16;
                }
                if (GameEngine.state != 17) break;
                this.andThenThereWasVictory();
                if (!GameEngine.configSound) break;
                this.ge.sound.playMidi(1, 1);
            }
        }
        if (GameEngine.clock.getMilliseconds() > GameEngine.TIME_OVER) {
            GameEngine.state = 19;
            GameEngine.clock.stop();
            this.inLabels();
            if (GameEngine.configSound) {
                this.ge.sound.playMidi(2, 1);
            }
        }
    }

    public void andThenThereWasVictory() {
        GameEngine.clock.stop();
        GameEngine.levelTime = GameEngine.clock.getMilliseconds();
        GameEngine.levelTimeString = GameEngine.clock.getTimeString(4);
        this.inLabels();
        GameEngine.levelScore = Math.max(0, 91000 - (int)GameEngine.levelTime) / 100;
        GameEngine.levelStars = GameEngine.levelTime < 46000L ? 5 : (GameEngine.levelTime < 56000L ? 4 : (GameEngine.levelTime < 66000L ? 3 : (GameEngine.levelTime < 91000L ? 2 : 1)));
        if (GameEngine.levelScore >= GameEngine.levelBestScore[GameEngine.levelSelected]) {
            GameEngine.levelBestTime[GameEngine.levelSelected] = GameEngine.levelTime;
            GameEngine.levelBestScore[GameEngine.levelSelected] = GameEngine.levelScore;
            GameEngine.levelBestStars[GameEngine.levelSelected] = GameEngine.levelStars;
            GameEngine.totalScore = SSMath.sum(GameEngine.levelBestScore);
            GameEngine.totalStars = SSMath.sum(GameEngine.levelBestStars);
            this.ge.saveScores();
        }
        GameEngine.totalLevelsComplete = this.ge.countLevelsComplete();
        GameEngine.totalLevelsFiveStars = this.ge.countLevelsWithFiveStars();
        for (int i = 0; i < 25; ++i) {
            if (GameEngine.trophyUnlocked[i] || !this.ge.checkTrophy(i)) continue;
            GameEngine.trophyVisible[i] = true;
            GameEngine.trophyUnlocked[i] = true;
            GameEngine.trophiesToShow[i] = true;
        }
        GameEngine.totalTrophiesUnlocked = SSMath.sum(GameEngine.trophyUnlocked);
        GameEngine.totalTrophyPoints = this.ge.countTrophiesPoints();
        this.ge.saveTrophies();
    }

    private boolean checkCollisionFast(Ball ball, Cwall cwall) {
        return ball.pos[0] + ball.rad >= cwall.pos[0] - cwall.rad && ball.pos[0] - ball.rad <= cwall.pos[0] + cwall.rad && ball.pos[1] + ball.rad >= cwall.pos[1] - cwall.rad && ball.pos[1] - ball.rad <= cwall.pos[1] + cwall.rad;
    }

    private boolean checkCollisionFast(Ball ball, Ball ball2) {
        return ball.pos[0] + ball.rad >= ball2.pos[0] - ball2.rad && ball.pos[0] - ball.rad <= ball2.pos[0] + ball2.rad && ball.pos[1] + ball.rad >= ball2.pos[1] - ball2.rad && ball.pos[1] - ball.rad <= ball2.pos[1] + ball2.rad;
    }

    private boolean checkCollisionFast(Ball ball, Hole hole) {
        return ball.pos[0] + ball.rad >= hole.pos[0] - hole.rad && ball.pos[0] - ball.rad <= hole.pos[0] + hole.rad && ball.pos[1] + ball.rad >= hole.pos[1] - hole.rad && ball.pos[1] - ball.rad <= hole.pos[1] + hole.rad;
    }

    public boolean destroyBallsFireIce() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        for (int i = 0; i < ballCnt; ++i) {
            if (BoardManager.balls[i].status == -2 || BoardManager.balls[i].status == -1 || BoardManager.balls[i].type != 4 && BoardManager.balls[i].type != 5) continue;
            for (int j = i + 1; j < ballCnt; ++j) {
                if (ballsTogether[i][j] != 1 || BoardManager.balls[i].type == BoardManager.balls[j].type) continue;
                bl = true;
                if (BoardManager.balls[i].size > BoardManager.balls[j].size) {
                    balls[j].setDestroy(l);
                    continue;
                }
                if (BoardManager.balls[i].size < BoardManager.balls[j].size) {
                    balls[i].setDestroy(l);
                    continue;
                }
                balls[i].setDestroy(l);
                balls[j].setDestroy(l);
            }
        }
        return bl;
    }

    public boolean destroyBallsColor() {
        int n;
        long l = System.currentTimeMillis();
        boolean bl = false;
        BoardManager.ballTypeTogetherCnt[0] = 1;
        BoardManager.ballTypeTogetherCnt[1] = 1;
        BoardManager.ballTypeTogetherCnt[2] = 1;
        BoardManager.ballTypeTogetherCnt[3] = 1;
        this.countBallsTogether_RE(0);
        for (n = 0; n < ballCnt; ++n) {
            if (BoardManager.balls[n].status == -2 || BoardManager.balls[n].status == -1 || BoardManager.balls[n].type > 3 || ballTogetherList[n]) continue;
            BoardManager.ballTypeTogetherCnt[BoardManager.balls[n].type] = 1;
            this.countBallsTogether_RE(n);
        }
        for (n = 0; n < ballCnt; ++n) {
            if (BoardManager.balls[n].status == -2 || BoardManager.balls[n].type > 3) continue;
            bl = ballTypeTogetherCnt[BoardManager.balls[n].type] > 1 && ballTypeTogetherCnt[BoardManager.balls[n].type] == ballTypeCntInit[BoardManager.balls[n].type] ? balls[n].setTogether(true, l) : balls[n].setTogether(false, l);
        }
        return bl;
    }

    public void countBallsTogether_RE(int n) {
        BoardManager.ballTogetherList[n] = true;
        for (int i = 0; i < ballCnt; ++i) {
            if (BoardManager.balls[i].type > 3 || i == n || ballTogetherList[i] || ballsTogether[i][n] != 1) continue;
            int n2 = BoardManager.balls[n].type;
            ballTypeTogetherCnt[n2] = ballTypeTogetherCnt[n2] + 1;
            this.countBallsTogether_RE(i);
        }
    }

    public void resetBallsTogether() {
        for (int i = 0; i < ballCnt; ++i) {
            if (BoardManager.balls[i].type >= 3 || BoardManager.balls[i].status != 1) continue;
            BoardManager.balls[i].status = 0;
        }
    }

    private void gcBalls() {
        int n = ballCnt - 1;
        while (n >= 0) {
            if (BoardManager.balls[n].status == -2) {
                int n2 = BoardManager.balls[n].type;
                ballTypeCnt[n2] = ballTypeCnt[n2] - 1;
                for (int i = n; i < ballCnt - 1; ++i) {
                    BoardManager.balls[i] = balls[i + 1];
                    for (int j = 0; j < holeCnt; ++j) {
                        BoardManager.holes[j].ballsTrapped[i] = BoardManager.holes[j].ballsTrapped[i + 1];
                    }
                }
                --ballCnt;
                GameEngine.trophyCounter[13] = GameEngine.trophyCounter[13] + 1;
                GameEngine.trophyCounter[14] = GameEngine.trophyCounter[14] + 1;
                GameEngine.trophyCounter[15] = GameEngine.trophyCounter[15] + 1;
                GameEngine.trophyCounter[16] = GameEngine.trophyCounter[16] + 1;
            }
            --n;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
        graphics.setColor(0);
        graphics.fillRect(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
        this.ge.gc.paintBackground(graphics);
        switch (GameEngine.state) {
            case 15: {
                this.paintArena(graphics);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[7].toCharArray(), 2, 206, 68);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[6].toCharArray(), 174, 206, 72);
                break;
            }
            case 20: {
                this.paintArena(graphics);
                GameCanvas.paintAlpha(graphics, 0, 0, 176, 208);
                GameEngine.menu.paint(graphics);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[5].toCharArray(), 2, 206, 68);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[8].toCharArray(), 174, 206, 72);
                break;
            }
            case 21: {
                this.paintArena(graphics);
                GameCanvas.paintAlpha(graphics, 0, 0, 176, 208);
                graphics.setColor(11297560);
                graphics.setClip(8, 8, 160, GameCanvas.resFonts[0].getFontHeight() + 8);
                graphics.fillRoundRect(10, 10, 156, GameCanvas.resFonts[0].getFontHeight() + 4, 10, 10);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[15].toCharArray(), 88, 11, 17);
                GameEngine.uiTextLine = GameCanvas.resFonts[1].drawString(graphics, GameCanvas.lang[33].toCharArray(), 2, 30, 172, 163, 17, GameEngine.uiTextLine, 7, 11297560);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[6].toCharArray(), 174, 206, 72);
                break;
            }
            case 24: {
                this.paintArena(graphics);
                this.ge.gc.paintScoreBoard(graphics);
                ++auxFrames;
                break;
            }
            case 16: {
                this.paintArena(graphics);
                this.ge.gc.paintScoreBoard(graphics);
                GameCanvas.resFonts[2].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 2, 194, 68);
                GameCanvas.resFonts[0].drawString(graphics, this.auxString.toCharArray(), 2, 206, 68);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[10].toCharArray(), 174, 206, 72);
                ++auxFrames;
                break;
            }
            case 18: 
            case 19: {
                this.paintArena(graphics);
                this.ge.gc.paintScoreBoard(graphics);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[9].toCharArray(), 2, 206, 68);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[10].toCharArray(), 174, 206, 72);
                break;
            }
            case 9: 
            case 17: {
                this.paintArena(graphics);
                this.ge.gc.paintScoreBoard(graphics);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[8].toCharArray(), 2, 206, 68);
                break;
            }
            case 22: {
                this.paintArena(graphics);
                this.ge.gc.paintScoreBoard(graphics);
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[8].toCharArray(), 2, 206, 68);
            }
        }
        FX.paintParticles(graphics, GameCanvas.resAnimations[3]);
        if (paintObjects) {
            this.ge.updateObjects(2, 3);
            this.ge.gc.paintObjects(graphics);
            if (!GameEngine.objectsOnScreen) {
                paintObjects = false;
            }
        }
    }

    public void paintArena(Graphics graphics) {
        int n;
        for (n = 0; n < holeCnt; ++n) {
            holes[n].paintHole(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        for (n = 0; n < ballCnt; ++n) {
            balls[n].paintBall(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        for (n = 0; n < containerCnt; ++n) {
            containers[n].paintContainer(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        for (n = 0; n < wallCnt; ++n) {
            if (!BoardManager.walls[n].isVisible && !BoardManager.walls[n].isDoor) continue;
            if (BoardManager.walls[n].isDoor) {
                walls[n].paintWall(graphics, arenaOffsetOX, arenaOffsetOY, 1);
                continue;
            }
            walls[n].paintWall(graphics, arenaOffsetOX, arenaOffsetOY, 0);
        }
        for (n = 0; n < cWallCnt; ++n) {
            cwalls[n].paintCwall(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        graphics.setClip(0, 0, 176, 208);
        for (n = 0; n < throwerCnt; ++n) {
            throwers[n].paintThrower(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        for (n = 0; n < doorCnt; ++n) {
            doors[n].paintDoor(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        for (n = 0; n < holeCnt; ++n) {
            holes[n].paintRays(graphics, arenaOffsetOX, arenaOffsetOY);
        }
        GameCanvas.resAnimations[5].drawAnimation(graphics, 0, System.currentTimeMillis(), arenaOffsetOX, arenaOffsetOY, true);
        GameCanvas.resAnimations[5].drawAnimation(graphics, 1, System.currentTimeMillis(), arenaOffsetOX, arenaOffsetOY, true);
    }

    public void loadLevelTitles() {
        int n;
        for (n = 0; n < 50; ++n) {
            String[] stringArray = BoardManager.split(GameEngine.levelData[n], '\n');
            String[] stringArray2 = BoardManager.split(stringArray[0], ',');
            GameEngine.levelBackground[n] = Integer.parseInt(stringArray2[1]);
            GameEngine.levelIcon[n] = Integer.parseInt(stringArray2[8]);
            GameEngine.levelTitle[n] = GameCanvas.lang[110 + 2 * n];
            GameEngine.levelDescription[n] = GameCanvas.lang[110 + 2 * n + 1];
        }
        for (n = 0; n < 9; ++n) {
            GameEngine.levelStarsNeeded[n] = 0;
        }
        for (n = 9; n < 20; ++n) {
            GameEngine.levelStarsNeeded[n] = 9 + 3 * (n - 9);
        }
        for (n = 20; n < 23; ++n) {
            GameEngine.levelStarsNeeded[n] = 43 + 4 * (n - 20);
        }
        for (n = 23; n < 29; ++n) {
            GameEngine.levelStarsNeeded[n] = 56 + 5 * (n - 23);
        }
        for (n = 29; n < 35; ++n) {
            GameEngine.levelStarsNeeded[n] = 87 + 6 * (n - 29);
        }
        for (n = 35; n < 50; ++n) {
            GameEngine.levelStarsNeeded[n] = 124 + 7 * (n - 35);
        }
    }

    public boolean loadAndBuildLevel(String string) {
        return this.buildLevel(this.loadLevel(string));
    }

    public String[] loadLevels() {
        this.auxString = new String(SSFunctions.getResourceAsByteArray("/levels.bin"));
        String[] stringArray = BoardManager.split(this.auxString, '|');
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.desObfuscateString(stringArray[i]);
        }
        return stringArray;
    }

    public String loadLevel(String string) {
        this.auxStringBuffer.setLength(0);
        DataInputStream dataInputStream = SSFunctions.getResourceAsStream(string);
        try {
            int n;
            boolean bl = false;
            while ((n = dataInputStream.read()) != -1) {
                this.auxStringBuffer.append((char)n);
            }
        }
        catch (Exception exception) {
            System.out.println("Can't open " + string + " file");
            return "";
        }
        return this.auxStringBuffer.toString();
    }

    public boolean buildLevel(String string) {
        int n;
        this.auxString = GameCanvas.lang[28] + " " + (GameEngine.levelSelected + 1);
        String[] stringArray = BoardManager.split(string, '\n');
        arenaAngle = 0;
        arenaAngleSpeed = 0;
        ballCnt = 0;
        wallCnt = 0;
        cWallCnt = 0;
        containerCnt = 0;
        doorCnt = 0;
        holeCnt = 0;
        throwerCnt = 0;
        for (n = 0; n < ballTypeCnt.length; ++n) {
            BoardManager.ballTypeCnt[n] = 0;
        }
        String[] stringArray2 = BoardManager.split(stringArray[0], ',');
        GameEngine.uiBackgroundNext = Integer.parseInt(stringArray2[1]);
        arenaGravity = Integer.parseInt(stringArray2[2]) << 10;
        arenaColor = 65536 * Integer.parseInt(stringArray2[3]) + 256 * Integer.parseInt(stringArray2[4]) + Integer.parseInt(stringArray2[5]);
        arenaVictory = Integer.parseInt(stringArray2[6]);
        for (n = 1; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("END")) {
                for (int i = 0; i < ballTypeCnt.length; ++i) {
                    BoardManager.ballTypeCntInit[i] = ballTypeCnt[i];
                }
                return true;
            }
            stringArray2 = BoardManager.split(stringArray[n], ',');
            if (stringArray2[0].equals("BA")) {
                BoardManager.balls[BoardManager.ballCnt] = new Ball(this.ge, Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]), Integer.parseInt(stringArray2[4]), stringArray2[5].charAt(0), false, Integer.parseInt(stringArray2[7]));
                if (Integer.parseInt(stringArray2[1]) == 7 && Integer.parseInt(stringArray2[6]) == 1) {
                    BoardManager.balls[BoardManager.ballCnt].status = 2;
                }
                ++ballCnt;
                continue;
            }
            if (stringArray2[0].equals("WA")) {
                BoardManager.walls[BoardManager.wallCnt] = new Wall(wallCnt, Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]), Integer.parseInt(stringArray2[4]));
                ++wallCnt;
                continue;
            }
            if (stringArray2[0].equals("CW")) {
                BoardManager.cwalls[BoardManager.cWallCnt] = new Cwall(Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]));
                ++cWallCnt;
                continue;
            }
            if (stringArray2[0].equals("CO")) {
                BoardManager.containers[BoardManager.containerCnt] = new Container(this.ge, Integer.parseInt(stringArray2[6]), Integer.parseInt(stringArray2[7]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]), Integer.parseInt(stringArray2[4]), Integer.parseInt(stringArray2[5]));
                ++containerCnt;
                continue;
            }
            if (stringArray2[0].equals("DO")) {
                BoardManager.doors[BoardManager.doorCnt] = new Door(this.ge, Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]), Integer.parseInt(stringArray2[4]), stringArray2[5].charAt(0), false);
                if (Integer.parseInt(stringArray2[6]) == 1) {
                    doors[doorCnt].activeDoor();
                }
                ++doorCnt;
                continue;
            }
            if (stringArray2[0].equals("HO")) {
                BoardManager.holes[BoardManager.holeCnt] = new Hole(this.ge, Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]));
                ++holeCnt;
                continue;
            }
            if (!stringArray2[0].equals("TH")) continue;
            BoardManager.throwers[BoardManager.throwerCnt] = new Thrower(this.ge, Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]), Long.parseLong(stringArray2[4]), stringArray2[5], Integer.parseInt(stringArray2[6]));
            ++throwerCnt;
        }
        return false;
    }

    public static final String[] split(String string, char c) {
        int n;
        String[] stringArray = null;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != c) continue;
            ++n2;
        }
        stringArray = new String[n2 + 1];
        n = 0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = string.indexOf(String.valueOf(c), n);
            stringArray[i] = string.substring(n, n3);
            n = n3 + 1;
        }
        stringArray[n2] = string.substring(n);
        return stringArray;
    }

    private String desObfuscateString(String string) {
        String[] stringArray = new String[]{"MURCIELAGOS.0123456789"};
        String[] stringArray2 = new String[]{"0123456789,BAWCODHTEND"};
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = stringArray[i % stringArray.length].indexOf(c);
            if (n == -1) {
                stringBuffer.append(c);
                continue;
            }
            char c2 = stringArray2[i % stringArray2.length].charAt(n);
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

