/*
 * Decompiled with CFR 0.152.
 */
public class GameAI
extends GameBoardElement
implements PSSpriteConstants {
    public static final int INITIAL_MAX_GUARD_TURN_NUMBER = 2;
    public static final int INITIAL_MAX_GUARD_LIFE_POINTS = 200;
    public static final int INITIAL_MAX_GUARD_DECKS_CARDS_NUMBER = 12;
    public static final int INITIAL_MAX_GUARD_HAND_CARDS = 6;
    public static final int SHADOW_WIDTH = 20;
    public static final int SHADOW_HEIGHT = 10;
    public static PSSprite spriteGuard;
    public static PSSprite spriteRikishi;
    public static PSSprite spriteSukiyaki;
    public static PSSprite spriteMetalGear;
    public static PSSprite spriteCamera;
    public static PSSprite spriteVince;
    public static PSSprite spriteGuncypher;
    public static PSSprite spriteExplosions;
    public PSSprite sprite;
    public PSSpritePlayer explosionSpritePlayer;
    public PSSpritePlayer spritePlayer;
    private int[] animatedActions;
    private static final int ANIMATED_ACTION_SHOOT_UP = 0;
    private static final int ANIMATED_ACTION_SHOOT_LEFT = 1;
    private static final int ANIMATED_ACTION_SHOOT_DOWN = 2;
    private static final int ANIMATED_ACTION_SHOOT_RIGHT = 3;
    private static final int ANIMATED_ACTION_HIT_UP = 4;
    private static final int ANIMATED_ACTION_HIT_LEFT = 5;
    private static final int ANIMATED_ACTION_HIT_DOWN = 6;
    private static final int ANIMATED_ACTION_HIT_RIGHT = 7;
    private static final int ANIMATED_ACTION_DEATH_LEFT = 8;
    private static final int ANIMATED_ACTION_DEATH_RIGHT = 9;
    private static final int ANIMATED_ACTION_WALK_UP = 10;
    private static final int ANIMATED_ACTION_WALK_LEFT = 11;
    private static final int ANIMATED_ACTION_WALK_DOWN = 12;
    private static final int ANIMATED_ACTION_WALK_RIGHT = 13;
    private static final int ANIMATED_ACTION_FACE_UP = 14;
    private static final int ANIMATED_ACTION_FACE_LEFT = 15;
    private static final int ANIMATED_ACTION_FACE_DOWN = 16;
    private static final int ANIMATED_ACTION_FACE_RIGHT = 17;
    private static final int ANIMATED_ACTION_KNOCKDOWN_UP = 18;
    private static final int ANIMATED_ACTION_KNOCKDOWN_LEFT = 19;
    private static final int ANIMATED_ACTION_KNOCKDOWN_DOWN = 20;
    private static final int ANIMATED_ACTION_KNOCKDOWN_RIGHT = 21;
    private static final int ANIMATED_ACTION_SHOOT_UP_LEFT = 22;
    private static final int ANIMATED_ACTION_SHOOT_UP_RIGHT = 23;
    private static final int ANIMATED_ACTION_SHOOT_DOWN_LEFT = 24;
    private static final int ANIMATED_ACTION_SHOOT_DOWN_RIGHT = 25;
    private static final int ANIMATED_ACTION_BAZOOKA_UP = 26;
    private static final int ANIMATED_ACTION_BAZOOKA_LEFT = 27;
    private static final int ANIMATED_ACTION_BAZOOKA_DOWN = 28;
    private static final int ANIMATED_ACTION_BAZOOKA_RIGHT = 29;
    private static final int ANIMATED_ACTION_BAZOOKA_UP_LEFT = 30;
    private static final int ANIMATED_ACTION_BAZOOKA_UP_RIGHT = 31;
    private static final int ANIMATED_ACTION_BAZOOKA_DOWN_LEFT = 32;
    private static final int ANIMATED_ACTION_BAZOOKA_DOWN_RIGHT = 33;
    private static final int[] GUARD_ANIMATED_ACTIONS;
    private static final int[] RIKISHI_ANIMATED_ACTIONS;
    private static final int[] SUKIYAKI_ANIMATED_ACTIONS;
    private static final int[] METAL_GEAR_ANIMATED_ACTIONS;
    private static final int[] CAMERA_ANIMATED_ACTIONS;
    private static final int[] VINCE_ANIMATED_ACTIONS;
    private static final int[] GUNCYPHER_ANIMATED_ACTIONS;
    public static final int ANIMATION_WALK_RIGHT_REPEAT = 0;
    public static final int ANIMATION_WALK_LEFT_REPEAT = 0;
    public static final int ANIMATION_WALK_UP_REPEAT = 0;
    public static final int ANIMATION_WALK_DOWN_REPEAT = 0;
    public static final int ANIMATION_BOX_WALK_RIGHT_REPEAT = 5;
    public static final int ANIMATION_BOX_WALK_LEFT_REPEAT = 5;
    public static final int ANIMATION_BOX_WALK_UP_REPEAT = 5;
    public static final int ANIMATION_BOX_WALK_DOWN_REPEAT = 5;
    public static final int ANIMATION_SHOOT_UP_REPEAT = 3;
    public static final int ANIMATION_SHOOT_LEFT_REPEAT = 3;
    public static final int ANIMATION_SHOOT_DOWN_REPEAT = 3;
    public static final int ANIMATION_SHOOT_RIGHT_REPEAT = 3;
    public static final int ANIMATION_DEATH_LEFT_REPEAT = 0;
    public static final int ANIMATION_DEATH_RIGHT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_LEFT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_UP_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_DOWN_REPEAT = 0;
    public static final int ANIMATION_BOX_KNOCKDOWN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_BOX_KNOCKDOWN_LEFT_REPEAT = 0;
    public static final int ANIMATION_BOX_KNOCKDOWN_UP_REPEAT = 0;
    public static final int ANIMATION_BOX_KNOCKDOWN_DOWN_REPEAT = 0;
    public static final int ANIMATION_MGEAR_WALK_RIGHT_REPEAT = 17;
    public static final int ANIMATION_MGEAR_WALK_LEFT_REPEAT = 17;
    public static final int ANIMATION_BAZOOKA_UP_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_LEFT_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_DOWN_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_RIGHT_REPEAT = 0;
    public static final int AI_CHECKPOINTS_STATS = 4;
    public static final int AI_TILE_ROW_POS = 0;
    public static final int AI_TILE_COL_POS = 1;
    public static final int AI_DIRECTION = 2;
    public static final int AI_WAIT_TURN = 3;
    private final int[][][] VISION_GRID = new int[][][]{new int[][]{{-2, -2}, {-2, -1}, {-3, -1}, {-4, 0}, {-3, 1}, {-2, 1}, {-2, 2}}, new int[][]{{2, -2}, {1, -2}, {1, -3}, {0, -4}, {-1, -3}, {-1, -2}, {-2, -2}}, new int[][]{{2, -2}, {2, -1}, {3, -1}, {4, 0}, {3, 1}, {2, 1}, {2, 2}}, new int[][]{{2, 2}, {1, 2}, {1, 3}, {0, 4}, {-1, 3}, {-1, 2}, {-2, 2}}};
    public static final int MAX_AI_VISION_POINTS = 12;
    public int[] currentVisionGrid = null;
    public int speedX = 40;
    public int speedY = 40;
    private int speedTileX = this.speedX / 20;
    private int speedTileY = this.speedY / 20;
    private boolean isMoving = false;
    public boolean isKnockedDown = false;
    public int effectDuration = 0;
    int posSubX;
    int posSubY;
    public int moveNumber = 3;
    public int moveNumberLeft = 0;
    public int facingDirection = 0;
    public boolean setDirection = false;
    private int displayX;
    private int displayY;
    private int setClipX;
    private int setClipY;
    public int damageToPrint = -1;
    public int damagePrintDuration = 20;
    public int shadowOffsetX = 0;
    public int shadowOffsetY = 0;
    public int fillDisplayQueueOffsetX1 = 0;
    public int fillDisplayQueueOffsetX2 = 0;
    public int fillDisplayQueueOffsetY1 = 0;
    public int fillDisplayQueueOffsetY2 = 0;
    private int laserRadius = 0;
    private int smokeFrame = 0;
    private int movingSign = 1;
    private int movingOffset = 0;
    public boolean alertDisplay = true;
    public boolean isAnimated = false;
    public int tileRow;
    public int tileCol;
    public int goalRow;
    public int goalCol;
    public int AiID = -1;
    private int[][] checkPointList;
    private int currentCheckPoint = 0;
    private int currentWait = 0;
    public int currentPathPoint = 0;
    private int[][] pathPoints;
    public int type = 0;
    public int lifeNumberLeft = 0;
    public int maxLifeNumber = 0;
    public int actionNumberLeft = 0;
    public int maxActionNumber = 2;
    public int decksCardsNumberLeft = 12;
    public int maxDecksCardsNumber = 12;
    public int cardsHandNumber = 6;
    public int status = -1;
    private int shootRange = 0;
    private int costMoveMin = 0;
    private int costMoveMax = 0;
    private int costAttackMin = 0;
    private int costAttackMax = 0;
    private int moveNumberMax = 0;
    private int attackDamage = 0;
    private int healNumber = 1;
    public int isHit = 0;
    public boolean isAlive = true;
    public boolean isAlerted = false;
    public boolean isCaution = false;
    public boolean isShooting = false;
    public boolean forceMove = false;
    public boolean forceRetreat = false;
    public boolean immuneKnockdown = false;
    public boolean immuneStun = false;
    public boolean immuneBlind = true;
    public boolean isMachine = false;
    public int lastAlertCol = -1;
    public int lastAlertRow = -1;
    public int currentAlertCol = -1;
    public int currentAlertRow = -1;
    public boolean hasCautionSet = false;
    public boolean hasAlertSet = false;
    public boolean isTargetable = false;
    public boolean requestCamTravel = false;
    public boolean launchProjectile = false;
    public int projectileDamage = 0;
    private int shootingLaser = 0;
    public Deck deck;

    public GameAI() {
    }

    public GameAI(int tileRow, int tileCol, int posZ, int type, int[][] checkPointList, int AiID) {
        this.tileCol = tileCol;
        this.tileRow = tileRow;
        this.goalCol = tileCol;
        this.goalRow = tileRow;
        this.posX = tileCol * 20;
        this.posY = tileRow * 20;
        this.posZ = posZ * 20;
        this.type = type;
        switch (type) {
            case 1: 
            case 8: {
                this.imageId = 65;
                this.sprite = spriteGuard;
                this.animatedActions = GUARD_ANIMATED_ACTIONS;
                this.lifeNumberLeft = this.maxLifeNumber = 200;
                this.shootRange = 8;
                this.costMoveMin = 4;
                this.costMoveMax = 5;
                this.costAttackMin = 6;
                this.costAttackMax = 8;
                this.attackDamage = 60;
                break;
            }
            case 2: {
                this.imageId = 66;
                this.sprite = spriteSukiyaki;
                this.animatedActions = SUKIYAKI_ANIMATED_ACTIONS;
                this.lifeNumberLeft = this.maxLifeNumber = 200;
                this.shootRange = 8;
                this.costMoveMin = 4;
                this.costMoveMax = 5;
                this.costAttackMin = 6;
                this.costAttackMax = 8;
                this.attackDamage = 60;
                this.immuneStun = true;
                this.isMachine = true;
                this.immuneBlind = false;
                break;
            }
            case 3: {
                this.imageId = 67;
                this.sprite = spriteRikishi;
                this.animatedActions = RIKISHI_ANIMATED_ACTIONS;
                this.lifeNumberLeft = this.maxLifeNumber = 200;
                this.shootRange = 8;
                this.costMoveMin = 4;
                this.costMoveMax = 5;
                this.costAttackMin = 6;
                this.costAttackMax = 8;
                this.attackDamage = 60;
                this.immuneStun = true;
                this.isMachine = true;
                this.immuneBlind = false;
                break;
            }
            case 4: {
                this.imageId = 68;
                this.sprite = spriteVince;
                this.animatedActions = VINCE_ANIMATED_ACTIONS;
                this.alertDisplay = false;
                this.lifeNumberLeft = this.maxLifeNumber = 1000;
                this.currentAlertRow = GameBoard.snake.tileRow;
                this.currentAlertCol = GameBoard.snake.tileCol;
                this.isAlerted = true;
                this.immuneKnockdown = true;
                this.immuneStun = true;
                this.shootRange = 8;
                this.costMoveMin = 4;
                this.costMoveMax = 5;
                this.costAttackMin = 6;
                this.costAttackMax = 8;
                this.attackDamage = 60;
                this.projectileDamage = 150;
                break;
            }
            case 5: {
                this.imageId = 71;
                this.sprite = spriteMetalGear;
                this.animatedActions = METAL_GEAR_ANIMATED_ACTIONS;
                this.alertDisplay = false;
                this.immuneKnockdown = true;
                this.immuneStun = true;
                this.isMachine = true;
                this.lifeNumberLeft = this.maxLifeNumber = 1500;
                this.currentAlertRow = GameBoard.snake.tileRow;
                this.currentAlertCol = GameBoard.snake.tileCol;
                this.shootRange = 10;
                this.costMoveMin = 5;
                this.costMoveMax = 5;
                this.costAttackMin = 7;
                this.costAttackMax = 15;
                this.attackDamage = 150;
                this.projectileDamage = 80;
                for (int i = tileRow - 4; i < tileRow + 1; i += 2) {
                    for (int j = tileCol - 4; j < tileCol + 5; j += 2) {
                        byte[] byArray = GameBoard.boundMapData[i];
                        int n = j;
                        byArray[n] = (byte)(byArray[n] + 16);
                    }
                }
                this.fillDisplayQueueOffsetX1 = 176;
                this.fillDisplayQueueOffsetX2 = 176;
                this.fillDisplayQueueOffsetY1 = 208;
                this.fillDisplayQueueOffsetY2 = 208;
                break;
            }
            case 6: 
            case 7: {
                this.imageId = 0;
                this.alertDisplay = false;
                this.lifeNumberLeft = this.maxLifeNumber = 300;
                this.immuneKnockdown = true;
                this.immuneStun = true;
                this.isMachine = true;
                this.posZ = (posZ + 5) * 20;
                break;
            }
            case 9: {
                this.imageId = 18;
                this.sprite = spriteCamera;
                this.animatedActions = CAMERA_ANIMATED_ACTIONS;
                this.alertDisplay = false;
                this.posY -= 60;
                this.lifeNumberLeft = this.maxLifeNumber = 10;
                this.immuneKnockdown = true;
                this.immuneStun = true;
                this.isMachine = false;
                this.immuneBlind = false;
                break;
            }
            case 10: {
                this.imageId = 70;
                this.sprite = spriteGuncypher;
                this.animatedActions = GUNCYPHER_ANIMATED_ACTIONS;
                this.lifeNumberLeft = this.maxLifeNumber = 200;
                this.shootRange = 14;
                this.costMoveMin = 4;
                this.costMoveMax = 5;
                this.costAttackMin = 6;
                this.costAttackMax = 8;
                this.attackDamage = 60;
                this.alertDisplay = false;
                this.immuneKnockdown = true;
                this.immuneStun = true;
                break;
            }
            default: {
                this.imageId = 65;
                this.sprite = spriteGuard;
                this.animatedActions = GUARD_ANIMATED_ACTIONS;
                this.lifeNumberLeft = this.maxLifeNumber = 200;
            }
        }
        if (this.spritePlayer == null) {
            this.spritePlayer = new PSSpritePlayer(this.sprite);
        }
        this.checkPointList = checkPointList;
        this.AiID = AiID;
        this.setDirection(checkPointList[0][2]);
        this.currentCost = 0;
        this.currentCheckPoint = 0;
        this.currentWait = 0;
        this.pathPoints = null;
        if (type != 5 && type != 6 && type != 7 && type != 9) {
            byte[] byArray = GameBoard.boundMapData[tileRow];
            int n = tileCol;
            byArray[n] = (byte)(byArray[n] + 16);
        }
        this.updateDisplayPositions();
        this.currentVisionGrid = type == 5 ? new int[GameBoard.mapWidth * GameBoard.mapHeight] : new int[24];
        this.computeVisionGrid();
        this.deck = new Deck(this.maxDecksCardsNumber, true);
        this.deck.addCardToDeck(14);
        this.deck.addCardToDeck(0);
        this.deck.addCardToDeck(14);
        this.deck.addCardToDeck(0);
        this.deck.addCardToDeck(14);
        this.deck.addCardToDeck(0);
        this.deck.addCardToDeck(14);
        this.deck.addCardToDeck(0);
        this.deck.addCardToDeck(14);
        this.deck.addCardToDeck(0);
        this.deck.addCardToDeck(14);
        this.deck.addCardToDeck(0);
        this.deck.drawCards(6);
    }

    public void display(PSGraphics g) {
        if (this.type == 6 || this.type == 7) {
            int barY;
            int barX;
            if (this.type == 6) {
                barX = this.posX - GameBoard.camX + 10;
                barY = this.posY - GameBoard.camY - 60 + 5;
            } else {
                barX = this.posX - GameBoard.camX + 30;
                barY = this.posY - GameBoard.camY - 60 + 5;
            }
            if (this.isAlive) {
                int lifeBarWidth = 17;
                if (this.lifeNumberLeft != 0) {
                    int percentLifeLeft = this.lifeNumberLeft * 100 / this.maxLifeNumber * 100;
                    lifeBarWidth = percentLifeLeft * lifeBarWidth / 10000;
                } else {
                    lifeBarWidth = 0;
                }
                g.setClip(barX, barY, 17, 6);
                g.setColor(0);
                g.fillRect(barX, barY, 17, 6);
                g.setColor(0xFFFFFF);
                g.fillRect(barX, barY, lifeBarWidth, 5);
                g.setColor(0);
                g.drawRect(barX, barY, 16, 5);
            } else if (GameBoard.AiArray[0].isAlive) {
                barX -= PSCanvas.imageWidth[33] / 2;
                barY -= PSCanvas.imageHeight[33] / 6;
                ++this.smokeFrame;
                if (this.smokeFrame > 5) {
                    this.smokeFrame = 0;
                }
                g.setClip(barX, barY, PSCanvas.imageWidth[33], PSCanvas.imageHeight[33] / 6);
                g.drawImage(PSCanvas.imageArray[33], barX, barY - this.smokeFrame * PSCanvas.imageHeight[33] / 6);
            }
            return;
        }
        g.setClip(this.setClipX, this.setClipY, this.sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()), this.sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()));
        if (this.isHit > 0) {
            if (this.isHit % 4 != 0 && this.isHit % 4 != 3) {
                this.spritePlayer.moveTo(this.displayX, this.displayY);
                this.spritePlayer.draw(g);
            }
            if (!this.isAlive && this.explosionSpritePlayer != null) {
                this.explosionSpritePlayer.moveTo((this.setClipX << 1) + this.sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()) - spriteExplosions.getAnimationWidth(this.explosionSpritePlayer.getAnimIdx()) >> 1, (this.setClipY << 1) + this.sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()) - spriteExplosions.getAnimationHeight(this.explosionSpritePlayer.getAnimIdx()) >> 1);
                this.explosionSpritePlayer.draw(g);
                this.explosionSpritePlayer.update();
            }
            --this.isHit;
        } else if (this.isAlive) {
            if (this.type == 10) {
                if (this.movingOffset * this.movingSign < 4) {
                    this.movingOffset += this.movingSign;
                } else {
                    this.movingSign = -this.movingSign;
                }
                this.spritePlayer.moveTo(this.displayX, this.displayY + this.movingOffset);
            } else {
                this.spritePlayer.moveTo(this.displayX, this.displayY);
            }
            this.spritePlayer.draw(g);
        }
        if (this.shootingLaser > 0) {
            g.setClip(0, 0, 176, 208);
            g.drawLine(this.posX + 20 - GameBoard.camX, this.posY - GameBoard.camY, GameBoard.snake.posX + 20 - GameBoard.camX, GameBoard.snake.posY - GameBoard.camY);
            for (int i = 0; i < this.laserRadius; ++i) {
                int color = 0xFFFFFF - (GameBoard.getRandom(i * 15, i * 20) << 8) - (GameBoard.getRandom(i * 20, i * 25) << 16);
                g.setColor(color);
                g.drawLine(this.posX + 20 - GameBoard.camX - i, this.posY - GameBoard.camY, GameBoard.snake.posX + 20 - GameBoard.camX - i, GameBoard.snake.posY - GameBoard.camY);
                g.drawLine(this.posX + 20 - GameBoard.camX + i, this.posY - GameBoard.camY, GameBoard.snake.posX + 20 - GameBoard.camX + i, GameBoard.snake.posY - GameBoard.camY);
            }
        }
    }

    public void displayShadow(PSGraphics g) {
        if (this.type == 6 || this.type == 7 || this.type == 10) {
            return;
        }
        g.setClip(this.setClipX, this.setClipY, this.sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()), this.sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()));
        g.setColor(Constants.LEVELS_SHADOW_COLOR[GameBoard.currentLevel]);
        if (this.isAlive) {
            if (this.type == 5) {
                g.fillArc(this.posX - GameBoard.camX - 40, this.posY - GameBoard.camY - 40, 120, 60, 0, 360);
            }
            if (this.type == 2) {
                g.fillRect(this.posX - GameBoard.camX + 5, this.posY - GameBoard.camY - 5, 32, 20);
            } else if (this.type == 3) {
                g.fillRect(this.posX - GameBoard.camX + 5, this.posY - GameBoard.camY - 5 - 7, 32, 27);
            } else {
                g.fillArc(this.posX + 20 - 10 - GameBoard.camX + this.shadowOffsetX, this.posY - GameBoard.camY - 2, 20 + this.shadowOffsetY, 10, 0, 360);
            }
        }
    }

    public void initTurn() {
        if (this.status == 4 || this.status == 3) {
            if (this.effectDuration <= 0) {
                if (PSCanvas.getRandom(0, 100) > 50 || this.status == 3) {
                    this.status = -1;
                    this.setDirection = true;
                }
            } else {
                --this.effectDuration;
            }
            this.moveNumberLeft = 0;
            if (this.status == 4 || this.status == 3) {
                this.setDirection = false;
                this.actionNumberLeft = 0;
                this.currentCost += this.costMoveMin;
            }
        } else {
            this.moveNumberLeft = 3;
            this.actionNumberLeft = this.maxActionNumber;
            if (this.status == 1 || this.status == 2) {
                if (this.effectDuration > 0) {
                    if (this.status == 1) {
                        this.setDamage(30, 0, -1);
                    } else {
                        this.setDamage(50, 0, -1);
                    }
                    --this.effectDuration;
                } else {
                    this.status = -1;
                }
            }
            this.setDirection = true;
            this.requestCamTravel = false;
        }
        this.isShooting = false;
        this.requestCamTravel = false;
    }

    public void update() {
        try {
            if (this.isAnimated) {
                if (this.shootingLaser > 0) {
                    --this.shootingLaser;
                    if (this.shootingLaser > 28) {
                        ++this.laserRadius;
                    } else if (this.shootingLaser <= 10) {
                        --this.laserRadius;
                    }
                    if (this.shootingLaser <= 0) {
                        this.isAnimated = false;
                    }
                } else {
                    this.spritePlayer.update();
                    if (this.spritePlayer.getDurationFrame() == 0 && this.spritePlayer.isPlaying()) {
                        if (this.isMoving) {
                            this.updateMovePos();
                        }
                        this.updateDisplayPositions();
                    }
                    if (!this.spritePlayer.isPlaying()) {
                        this.isAnimated = false;
                        if (!this.isMoving) {
                            this.setDirection(this.facingDirection);
                        }
                        this.isMoving = false;
                        if (this.isKnockedDown) {
                            this.isKnockedDown = false;
                        }
                    }
                    this.updateDisplayPositions();
                }
            }
            if (!this.isAnimated) {
                if (this.type == 5) {
                    if (this.moveNumberLeft > 0) {
                        int j;
                        int i;
                        int random = GameBoard.getRandom(0, 100);
                        int movingDirection = 0;
                        if (GameBoard.snake.tileRow <= 21 && (GameBoard.lineOfSight(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 4) || GameBoard.lineOfSight(this.tileRow, this.tileCol - 2, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 4) || GameBoard.lineOfSight(this.tileRow, this.tileCol + 2, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 4))) {
                            if (GameBoard.AiArray[1].isAlive || GameBoard.AiArray[2].isAlive) {
                                if (random < 20) {
                                    this.shootingLaser = 40;
                                    this.isShooting = true;
                                    this.isAnimated = true;
                                    this.requestCamTravel = true;
                                    this.setDirection = false;
                                    this.moveNumberLeft = 0;
                                    this.currentCost += this.costAttackMax;
                                    GameBoard.snake.setDamage(150, 0);
                                    return;
                                }
                                if (random < 50) {
                                    this.launchProjectile = true;
                                    this.requestCamTravel = true;
                                    this.setDirection = false;
                                    this.moveNumberLeft = 0;
                                    this.currentCost += this.costAttackMin;
                                    return;
                                }
                                if (random < 80) {
                                    this.setShoot(GameBoard.computeFullDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0));
                                    this.requestCamTravel = true;
                                    this.setDirection = false;
                                    this.moveNumberLeft = 0;
                                    this.currentCost += this.costAttackMin;
                                    GameBoard.snake.setDamage(this.projectileDamage, 0);
                                    return;
                                }
                            } else {
                                if (random < 50) {
                                    this.shootingLaser = 40;
                                    this.isShooting = true;
                                    this.isAnimated = true;
                                    this.requestCamTravel = true;
                                    this.setDirection = false;
                                    this.moveNumberLeft = 0;
                                    this.currentCost += this.costAttackMax;
                                    GameBoard.snake.setDamage(150, 0);
                                    return;
                                }
                                if (random < 75) {
                                    this.setDirection = false;
                                    this.moveNumberLeft = 0;
                                    this.currentCost += this.costAttackMin;
                                    return;
                                }
                            }
                        }
                        if (this.tileCol < 11) {
                            movingDirection = 8;
                        } else if (this.tileCol > 11) {
                            movingDirection = 2;
                        } else if (this.tileCol == 11) {
                            movingDirection = GameBoard.snake.tileCol < this.tileCol ? 2 : 8;
                        }
                        for (i = this.tileRow - 4; i < this.tileRow + 1; i += 2) {
                            for (j = this.tileCol - 4; j < this.tileCol + 5; j += 2) {
                                byte[] byArray = GameBoard.boundMapData[i];
                                int n = j;
                                byArray[n] = (byte)(byArray[n] - 16);
                            }
                        }
                        this.posSubX = this.tileCol * 20 << 8;
                        this.posSubY = this.tileRow * 20 << 8;
                        if (movingDirection == 2) {
                            this.setAnimation(11, 17);
                            this.facingDirection = 2;
                            this.tileCol -= 6;
                            GameBoard.AiArray[1].tileCol -= 6;
                            GameBoard.AiArray[2].tileCol -= 6;
                        } else if (movingDirection == 8) {
                            this.setAnimation(13, 17);
                            this.facingDirection = 8;
                            this.tileCol += 6;
                            GameBoard.AiArray[1].tileCol += 6;
                            GameBoard.AiArray[2].tileCol += 6;
                        }
                        for (i = this.tileRow - 4; i < this.tileRow + 1; i += 2) {
                            for (j = this.tileCol - 4; j < this.tileCol + 5; j += 2) {
                                if (i == GameBoard.snake.tileRow && j == GameBoard.snake.tileCol) {
                                    GameBoard.snake.lifeNumberLeft = 0;
                                }
                                byte[] byArray = GameBoard.boundMapData[i];
                                int n = j;
                                byArray[n] = (byte)(byArray[n] + 16);
                            }
                        }
                        this.moveNumberLeft = 0;
                        this.isMoving = true;
                        this.updateMovePos();
                        this.currentCost += this.costMoveMax;
                    } else if (this.setDirection) {
                        this.setDirection(4);
                        this.computeVisionGrid();
                        this.setDirection = false;
                    }
                } else if (!this.isAlerted && !this.isCaution) {
                    if (this.tileRow == this.checkPointList[this.currentCheckPoint][0] && this.tileCol == this.checkPointList[this.currentCheckPoint][1] && this.checkPointList[this.currentCheckPoint][3] == -1) {
                        this.setDirection(this.checkPointList[this.currentCheckPoint][2]);
                        this.computeVisionGrid();
                        this.moveNumberLeft = 0;
                        this.setDirection = false;
                        this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                        return;
                    }
                    if (this.moveNumberLeft == 0 && this.setDirection) {
                        if (this.tileRow == this.checkPointList[this.currentCheckPoint][0] && this.tileCol == this.checkPointList[this.currentCheckPoint][1]) {
                            if (this.facingDirection != this.checkPointList[this.currentCheckPoint][2]) {
                                this.setDirection(this.checkPointList[this.currentCheckPoint][2]);
                                this.computeVisionGrid();
                                this.checkPlayerPos();
                            }
                        } else {
                            this.setDirection(this.facingDirection);
                        }
                        this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                        this.setDirection = false;
                    }
                    if (this.tileRow == this.checkPointList[this.currentCheckPoint][0] && this.tileCol == this.checkPointList[this.currentCheckPoint][1]) {
                        if (this.checkPointList[this.currentCheckPoint][3] == 0) {
                            this.setDirection(this.checkPointList[this.currentCheckPoint][2]);
                            this.computeVisionGrid();
                            this.checkPlayerPos();
                            this.currentWait = 0;
                            ++this.currentCheckPoint;
                            if (this.currentCheckPoint >= this.checkPointList.length) {
                                this.currentCheckPoint = 0;
                            }
                            this.computePath(this.checkPointList[this.currentCheckPoint][0], this.checkPointList[this.currentCheckPoint][1]);
                        } else if (this.currentWait < this.checkPointList[this.currentCheckPoint][3]) {
                            this.setDirection(this.checkPointList[this.currentCheckPoint][2]);
                            this.computeVisionGrid();
                            this.checkPlayerPos();
                            if (this.pathPoints != null) {
                                this.pathPoints = null;
                            }
                            ++this.currentWait;
                            this.moveNumberLeft = 0;
                            this.actionNumberLeft = 0;
                        } else if (this.pathPoints == null) {
                            this.currentWait = 0;
                            ++this.currentCheckPoint;
                            if (this.currentCheckPoint >= this.checkPointList.length) {
                                this.currentCheckPoint = 0;
                            }
                            this.computePath(this.checkPointList[this.currentCheckPoint][0], this.checkPointList[this.currentCheckPoint][1]);
                        }
                    } else if (this.pathPoints == null) {
                        this.currentWait = 0;
                        ++this.currentCheckPoint;
                        if (this.currentCheckPoint >= this.checkPointList.length) {
                            this.currentCheckPoint = 0;
                        }
                        this.computePath(this.checkPointList[this.currentCheckPoint][0], this.checkPointList[this.currentCheckPoint][1]);
                    }
                    if (this.pathPoints != null) {
                        if (this.moveNumberLeft > 0) {
                            if ((GameBoard.boundMapData[this.pathPoints[this.currentPathPoint][0]][this.pathPoints[this.currentPathPoint][1]] & 0x10) != 0) {
                                this.moveNumberLeft = 0;
                                this.computePath(this.checkPointList[this.currentCheckPoint][0], this.checkPointList[this.currentCheckPoint][1]);
                                return;
                            }
                            this.facingDirection = GameBoard.computeDirection(this.tileRow, this.tileCol, this.pathPoints[this.currentPathPoint][0], this.pathPoints[this.currentPathPoint][1]);
                            this.computeVisionGrid();
                            if (this.pathPoints[this.currentPathPoint][0] == GameBoard.snake.tileRow && this.pathPoints[this.currentPathPoint][1] == GameBoard.snake.tileCol && GameBoard.snake.getEquipment(11) != -1) {
                                GameBoard.snake.removeEquipment(GameBoard.snake.getEquipment(11));
                            }
                            if (this.checkPlayerPos()) {
                                this.setDirection(this.facingDirection);
                                this.setDirection = false;
                                this.moveNumberLeft = 0;
                                this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                                return;
                            }
                            byte[] byArray = GameBoard.boundMapData[this.tileRow];
                            int n = this.tileCol;
                            byArray[n] = (byte)(byArray[n] - 16);
                            this.posSubX = this.tileCol * 20 << 8;
                            this.posSubY = this.tileRow * 20 << 8;
                            this.tileRow = this.pathPoints[this.currentPathPoint][0];
                            this.tileCol = this.pathPoints[this.currentPathPoint][1];
                            byte[] byArray2 = GameBoard.boundMapData[this.tileRow];
                            int n2 = this.tileCol;
                            byArray2[n2] = (byte)(byArray2[n2] + 16);
                            this.setWalk();
                            this.updateMovePos();
                            --this.currentPathPoint;
                            --this.moveNumberLeft;
                            this.computeVisionGrid();
                            this.checkPlayerPos();
                            this.updateDisplayPositions();
                        }
                    } else {
                        this.moveNumberLeft = 0;
                        this.setDirection = false;
                        this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                    }
                } else {
                    if (!(this.type != 4 && this.type != 5 && this.type != 11 && this.type != 12 && this.type != 13 || this.forceRetreat)) {
                        this.currentAlertRow = GameBoard.snake.tileRow;
                        this.currentAlertCol = GameBoard.snake.tileCol;
                    }
                    if (this.lastAlertCol != this.currentAlertCol || this.lastAlertRow != this.currentAlertRow && !this.forceRetreat) {
                        this.computePath(this.currentAlertRow, this.currentAlertCol);
                        this.lastAlertCol = this.currentAlertCol;
                        this.lastAlertRow = this.currentAlertRow;
                    }
                    if (this.isAlerted && this.type != 10) {
                        GameBoard.alertAiAround(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 8, false);
                    }
                    if (this.type == 10) {
                        if (this.pathPoints == null) {
                            this.pathPoints = new int[1][2];
                        }
                        this.currentPathPoint = -1;
                    }
                    if (this.pathPoints != null) {
                        if (this.moveNumberLeft == this.moveNumber && this.isAlerted) {
                            if (this.type == 4) {
                                int random = GameBoard.getRandom(0, 100);
                                if (!this.forceMove && GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) <= 2 && GameBoard.lineOfSight(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.facingDirection)) {
                                    if (random < 50) {
                                        this.setShoot(GameBoard.computeFullDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0));
                                        GameBoard.snake.setDamage(this.attackDamage, 0);
                                        this.requestCamTravel = true;
                                        this.moveNumberLeft = 0;
                                        this.currentCost += GameBoard.getRandom(this.costAttackMin, this.costAttackMax);
                                        PSCanvas.soundManager.play(0, 16, 0);
                                        this.setDirection = false;
                                    } else if (random >= 50 && random <= 90) {
                                        this.forceRetreat = true;
                                        if (GameBoard.lineOfSight(this.tileRow, this.tileCol, this.tileRow - 4, this.tileCol) && GameBoard.snake.tileRow != this.tileRow - 2) {
                                            this.computePathAvoidPlayer(this.tileRow - 4, this.tileCol);
                                        } else if (GameBoard.lineOfSight(this.tileRow, this.tileCol, this.tileRow + 4, this.tileCol) && GameBoard.snake.tileRow != this.tileRow + 2) {
                                            this.computePathAvoidPlayer(this.tileRow + 4, this.tileCol);
                                        } else if (GameBoard.lineOfSight(this.tileRow, this.tileCol, this.tileRow, this.tileCol + 4) && GameBoard.snake.tileCol != this.tileCol + 2) {
                                            this.computePathAvoidPlayer(this.tileRow, this.tileCol + 4);
                                        } else if (GameBoard.lineOfSight(this.tileRow, this.tileCol, this.tileRow, this.tileCol - 4) && GameBoard.snake.tileCol != this.tileCol - 2) {
                                            this.computePathAvoidPlayer(this.tileRow, this.tileCol - 4);
                                        }
                                    } else {
                                        this.launchProjectile = true;
                                        this.requestCamTravel = true;
                                        this.moveNumberLeft = 0;
                                        this.currentCost += GameBoard.getRandom(this.costAttackMin, this.costAttackMax);
                                        this.setShoot(GameBoard.computeFullDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0));
                                        PSCanvas.soundManager.play(0, 17, 0);
                                        this.setDirection = false;
                                    }
                                } else if (!this.forceMove && GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) <= this.shootRange && GameBoard.lineOfSight(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.facingDirection)) {
                                    if (random < 50) {
                                        this.launchProjectile = true;
                                        this.requestCamTravel = true;
                                        this.moveNumberLeft = 0;
                                        this.currentCost += GameBoard.getRandom(this.costAttackMin, this.costAttackMax);
                                        this.setShoot(GameBoard.computeFullDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0));
                                        PSCanvas.soundManager.play(0, 17, 0);
                                    } else {
                                        this.setShoot(GameBoard.computeFullDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0));
                                        GameBoard.snake.setDamage(this.attackDamage, 0);
                                        this.requestCamTravel = true;
                                        this.moveNumberLeft = 0;
                                        this.setDirection = false;
                                        PSCanvas.soundManager.play(0, 16, 0);
                                        this.currentCost += GameBoard.getRandom(this.costAttackMin, this.costAttackMax);
                                    }
                                }
                            } else if (!this.forceMove && GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) <= this.shootRange && GameBoard.lineOfSight(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.facingDirection)) {
                                GameBoard.setAlert(true);
                                GameBoard.alertAiAround(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 10, true);
                                this.setShoot(GameBoard.computeFullDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0));
                                GameBoard.snake.setDamage(this.attackDamage, 0);
                                this.requestCamTravel = true;
                                this.moveNumberLeft = 0;
                                this.setDirection = false;
                                PSCanvas.soundManager.play(0, 16, 0);
                                this.currentCost += GameBoard.getRandom(this.costAttackMin, this.costAttackMax);
                            }
                        }
                        if (this.currentPathPoint == -1) {
                            if (this.type == 10) {
                                this.moveNumberLeft = 0;
                                this.setDirection = false;
                                this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                            } else if (this.type == 4 || this.type == 13 || this.type == 11 || this.type == 12) {
                                this.lastAlertCol = -1;
                                this.lastAlertRow = -1;
                                this.currentAlertRow = GameBoard.snake.tileRow;
                                this.currentAlertCol = GameBoard.snake.tileCol;
                                this.moveNumberLeft = 0;
                            } else if (!this.checkPlayerPos()) {
                                if (this.isCaution) {
                                    this.setAlertOff();
                                    this.moveNumberLeft = 0;
                                    this.actionNumberLeft = 0;
                                    this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                                } else if (GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) > this.shootRange) {
                                    this.isAlerted = false;
                                    this.isCaution = true;
                                    this.moveNumberLeft = 0;
                                    this.actionNumberLeft = 0;
                                    this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                                } else {
                                    this.moveNumberLeft = 0;
                                }
                            } else {
                                this.moveNumberLeft = 0;
                            }
                        }
                        if (this.moveNumberLeft > 0) {
                            this.facingDirection = GameBoard.computeDirection(this.tileRow, this.tileCol, this.pathPoints[this.currentPathPoint][0], this.pathPoints[this.currentPathPoint][1]);
                            this.computeVisionGrid();
                            if (!this.forceRetreat && !this.forceMove && GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) <= this.shootRange && GameBoard.lineOfSight(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.computeDirection(this.tileRow, this.tileCol, this.lastAlertRow, this.lastAlertCol))) {
                                GameBoard.setAlert(true);
                                GameBoard.alertAiAround(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 12, true);
                                this.isAlerted = true;
                                this.setDirection(GameBoard.computeDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol));
                                this.computeVisionGrid();
                                this.moveNumberLeft = 0;
                                return;
                            }
                            if ((GameBoard.boundMapData[this.pathPoints[this.currentPathPoint][0]][this.pathPoints[this.currentPathPoint][1]] & 0x10) != 0) {
                                for (int i = 0; i < GameBoard.AiArray.length; ++i) {
                                    if (!GameBoard.AiArray[i].isAlive || GameBoard.AiArray[i].tileRow != this.pathPoints[this.currentPathPoint][0] || GameBoard.AiArray[i].tileCol != this.pathPoints[this.currentPathPoint][1]) continue;
                                    if (GameBoard.AiArray[i].currentPathPoint <= 0) break;
                                    GameBoard.AiArray[i].forceMove = true;
                                    break;
                                }
                                this.moveNumberLeft = 0;
                                this.computePath(this.currentAlertRow, this.currentAlertCol);
                                return;
                            }
                            if (this.pathPoints[this.currentPathPoint][0] != GameBoard.snake.tileRow || this.pathPoints[this.currentPathPoint][1] != GameBoard.snake.tileCol) {
                                byte[] byArray = GameBoard.boundMapData[this.tileRow];
                                int n = this.tileCol;
                                byArray[n] = (byte)(byArray[n] - 16);
                                this.posSubX = this.tileCol * 20 << 8;
                                this.posSubY = this.tileRow * 20 << 8;
                                this.tileRow = this.pathPoints[this.currentPathPoint][0];
                                this.tileCol = this.pathPoints[this.currentPathPoint][1];
                                byte[] byArray3 = GameBoard.boundMapData[this.tileRow];
                                int n3 = this.tileCol;
                                byArray3[n3] = (byte)(byArray3[n3] + 16);
                                --this.currentPathPoint;
                                --this.moveNumberLeft;
                                this.setWalk();
                                this.updateMovePos();
                                this.computeVisionGrid();
                                this.checkPlayerPos();
                                if (this.isAlerted && this.checkSound(GameBoard.snake.tileRow, GameBoard.snake.tileCol)) {
                                    this.setAlert(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
                                }
                                this.updateDisplayPositions();
                            } else {
                                this.forceRetreat = false;
                                this.moveNumberLeft = 0;
                            }
                        } else if (this.setDirection) {
                            this.forceMove = false;
                            this.forceRetreat = false;
                            if (GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) <= 8 && GameBoard.lineOfSight(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.computeDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol))) {
                                this.setDirection(GameBoard.computeDirection(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol));
                                this.computeVisionGrid();
                                this.checkPlayerPos();
                            } else {
                                this.setDirection(this.facingDirection);
                            }
                            this.setDirection = false;
                            this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                        }
                    } else {
                        this.computePath(this.currentAlertRow, this.currentAlertCol);
                        this.setDirection = false;
                        this.moveNumberLeft = 0;
                        this.currentCost += GameBoard.getRandom(this.costMoveMin, this.costMoveMax);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateMovePos() {
        int walkLeftRepeat = 0;
        int walkRightRepeat = 0;
        int walkUpRepeat = 0;
        int walkDownRepeat = 0;
        if (this.imageId == 66 || this.imageId == 67) {
            if (this.isKnockedDown) {
                walkLeftRepeat = 0;
                walkRightRepeat = 0;
                walkUpRepeat = 0;
                walkDownRepeat = 0;
            } else {
                walkLeftRepeat = 5;
                walkRightRepeat = 5;
                walkUpRepeat = 5;
                walkDownRepeat = 5;
            }
        } else if (this.imageId == 71) {
            walkLeftRepeat = 17;
            walkRightRepeat = 17;
        } else if (this.imageId == 68) {
            walkLeftRepeat = 3;
            walkRightRepeat = 3;
            walkUpRepeat = 3;
            walkDownRepeat = 3;
        } else {
            walkLeftRepeat = 0;
            walkRightRepeat = 0;
            walkUpRepeat = 0;
            walkDownRepeat = 0;
        }
        if (this.isAnimated && this.isMoving) {
            if (this.spritePlayer.isPlaying()) {
                if (this.isKnockedDown && !this.spritePlayer.isCurrentFrameFirst()) {
                    switch (this.facingDirection) {
                        case 4: {
                            this.posSubY -= 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkDownRepeat + 1) - 1);
                            this.posZ = this.posY = this.posSubY >> 8;
                            break;
                        }
                        case 8: {
                            this.posSubX -= 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkRightRepeat + 1) - 1);
                            this.posX = this.posSubX >> 8;
                            break;
                        }
                        case 1: {
                            this.posSubY += 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkUpRepeat + 1) - 1);
                            this.posZ = this.posY = this.posSubY >> 8;
                            break;
                        }
                        case 2: {
                            this.posSubX += 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkLeftRepeat + 1) - 1);
                            this.posX = this.posSubX >> 8;
                            break;
                        }
                    }
                } else if (!this.isKnockedDown) {
                    if (this.type == 5) {
                        switch (this.facingDirection) {
                            case 2: {
                                this.posSubX -= 30720 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkLeftRepeat + 1));
                                this.posX = this.posSubX >> 8;
                                GameBoard.AiArray[1].posX = this.posX - 80;
                                GameBoard.AiArray[2].posX = this.posX + 80;
                                break;
                            }
                            case 8: {
                                this.posSubX += 30720 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkRightRepeat + 1));
                                this.posX = this.posSubX >> 8;
                                GameBoard.AiArray[1].posX = this.posX - 80;
                                GameBoard.AiArray[2].posX = this.posX + 80;
                                break;
                            }
                        }
                    } else {
                        switch (this.facingDirection) {
                            case 1: {
                                this.posSubY -= 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkUpRepeat + 1));
                                this.posZ = this.posY = this.posSubY >> 8;
                                break;
                            }
                            case 2: {
                                this.posSubX -= 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkLeftRepeat + 1));
                                this.posX = this.posSubX >> 8;
                                break;
                            }
                            case 4: {
                                this.posSubY += 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkDownRepeat + 1));
                                this.posZ = this.posY = this.posSubY >> 8;
                                break;
                            }
                            case 8: {
                                this.posSubX += 10240 / (this.sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * (walkRightRepeat + 1));
                                this.posX = this.posSubX >> 8;
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
            }
        } else {
            this.isMoving = false;
            if (this.isKnockedDown) {
                this.fall();
            }
            this.isKnockedDown = false;
        }
    }

    public void computePath(int targetRow, int targetCol) {
        this.pathPoints = GameBoard.aStarSearch(this.tileRow, this.tileCol, targetRow, targetCol, false);
        if (this.pathPoints == null) {
            this.moveNumberLeft = 0;
            this.setDirection = false;
        } else {
            this.goalRow = this.pathPoints[0][0];
            this.goalCol = this.pathPoints[0][1];
            this.currentPathPoint = this.pathPoints.length - 1;
        }
    }

    public void computePathAvoidPlayer(int targetRow, int targetCol) {
        this.pathPoints = GameBoard.aStarSearch(this.tileRow, this.tileCol, targetRow, targetCol, true);
        if (this.pathPoints == null) {
            this.moveNumberLeft = 0;
            this.setDirection = false;
        } else {
            this.goalRow = this.pathPoints[0][0];
            this.goalCol = this.pathPoints[0][1];
            this.currentPathPoint = this.pathPoints.length - 1;
        }
    }

    public void computeVisionGrid() {
        if (this.type == 5) {
            int i;
            int insertIndex = 0;
            for (i = 1; i < GameBoard.mapHeight; i += 2) {
                for (int j = 1; j < GameBoard.mapWidth; j += 2) {
                    if (i <= 21 && i > 10 && (GameBoard.lineOfSight(this.tileRow, this.tileCol, i, j, 4) || GameBoard.lineOfSight(this.tileRow, this.tileCol - 2, i, j, 4) || GameBoard.lineOfSight(this.tileRow, this.tileCol + 2, i, j, 4))) {
                        this.currentVisionGrid[insertIndex] = i;
                        this.currentVisionGrid[insertIndex + 1] = j;
                        insertIndex += 2;
                        continue;
                    }
                    this.currentVisionGrid[insertIndex] = -1;
                    this.currentVisionGrid[insertIndex + 1] = -1;
                    insertIndex += 2;
                }
            }
            for (i = insertIndex; i < this.currentVisionGrid.length; ++i) {
                this.currentVisionGrid[i] = -1;
            }
        } else {
            int[][] visionGrid = null;
            switch (this.facingDirection) {
                case 1: {
                    visionGrid = this.VISION_GRID[0];
                    break;
                }
                case 2: {
                    visionGrid = this.VISION_GRID[1];
                    break;
                }
                case 4: {
                    visionGrid = this.VISION_GRID[2];
                    break;
                }
                case 8: {
                    visionGrid = this.VISION_GRID[3];
                    break;
                }
            }
            GameBoard.computeVisionGrid(visionGrid, this.currentVisionGrid, this.tileRow, this.tileCol, this.facingDirection);
        }
    }

    public void setDirection(int direction) {
        if (this.isAlive) {
            block0 : switch (this.imageId) {
                case 18: 
                case 66: 
                case 67: {
                    switch (direction) {
                        case 1: {
                            if (!this.spritePlayer.isPlaying()) {
                                this.spritePlayer.play(this.animatedActions[14], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 1;
                            break block0;
                        }
                        case 2: {
                            if (!this.spritePlayer.isPlaying()) {
                                this.spritePlayer.play(this.animatedActions[15], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 2;
                            break block0;
                        }
                        case 4: {
                            if (!this.spritePlayer.isPlaying()) {
                                this.spritePlayer.play(this.animatedActions[16], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 4;
                            break block0;
                        }
                        case 8: {
                            if (!this.spritePlayer.isPlaying()) {
                                this.spritePlayer.play(this.animatedActions[17], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 8;
                            break block0;
                        }
                    }
                    break;
                }
                case 71: {
                    if (!this.spritePlayer.isPlaying()) {
                        this.spritePlayer.play(this.animatedActions[16], 0);
                        this.spritePlayer.stop();
                    }
                    this.facingDirection = direction;
                    break;
                }
                default: {
                    if (this.status == 4) {
                        if (this.spritePlayer.isPlaying()) break;
                        switch (direction) {
                            case 2: 
                            case 4: {
                                this.spritePlayer.reversePlay(this.animatedActions[8], 0);
                                this.spritePlayer.stop();
                                break block0;
                            }
                            case 1: 
                            case 8: {
                                this.spritePlayer.reversePlay(this.animatedActions[9], 0);
                                this.spritePlayer.stop();
                                break block0;
                            }
                        }
                        break;
                    }
                    switch (direction) {
                        case 1: {
                            if (!this.spritePlayer.isPlaying() && this.animatedActions != null) {
                                this.spritePlayer.play(this.animatedActions[14], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 1;
                            break block0;
                        }
                        case 2: {
                            if (!this.spritePlayer.isPlaying() && this.animatedActions != null) {
                                this.spritePlayer.play(this.animatedActions[15], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 2;
                            break block0;
                        }
                        case 4: {
                            if (!this.spritePlayer.isPlaying() && this.animatedActions != null) {
                                this.spritePlayer.play(this.animatedActions[16], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 4;
                            break block0;
                        }
                        case 8: {
                            if (!this.spritePlayer.isPlaying() && this.animatedActions != null) {
                                this.spritePlayer.play(this.animatedActions[17], 0);
                                this.spritePlayer.stop();
                            }
                            this.facingDirection = 8;
                            break block0;
                        }
                    }
                }
            }
        }
        this.updateDisplayPositions();
    }

    public void setWalk() {
        block0 : switch (this.imageId) {
            case 68: {
                switch (this.facingDirection) {
                    case 1: {
                        this.setAnimation(10, 3);
                        break block0;
                    }
                    case 2: {
                        this.setAnimation(11, 3);
                        break block0;
                    }
                    case 4: {
                        this.setAnimation(12, 3);
                        break block0;
                    }
                    case 8: {
                        this.setAnimation(13, 3);
                        break block0;
                    }
                }
                break;
            }
            case 66: 
            case 67: {
                switch (this.facingDirection) {
                    case 1: {
                        this.setAnimation(10, 5);
                        break block0;
                    }
                    case 2: {
                        this.setAnimation(11, 5);
                        break block0;
                    }
                    case 4: {
                        this.setAnimation(12, 5);
                        break block0;
                    }
                    case 8: {
                        this.setAnimation(13, 5);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (this.facingDirection) {
                    case 1: {
                        this.setAnimation(10, 0);
                        break block0;
                    }
                    case 2: {
                        this.setAnimation(11, 0);
                        break block0;
                    }
                    case 4: {
                        this.setAnimation(12, 0);
                        break block0;
                    }
                    case 8: {
                        this.setAnimation(13, 0);
                        break block0;
                    }
                }
            }
        }
        this.isMoving = true;
    }

    public void setShoot(int direction) {
        switch (direction) {
            case 1: {
                if (this.launchProjectile) {
                    this.setAnimation(26, 0);
                    break;
                }
                this.setAnimation(0, 3);
                break;
            }
            case 2: {
                if (this.launchProjectile) {
                    this.setAnimation(27, 0);
                    break;
                }
                this.setAnimation(1, 3);
                break;
            }
            case 4: {
                if (this.launchProjectile) {
                    this.setAnimation(28, 0);
                    break;
                }
                this.setAnimation(2, 3);
                break;
            }
            case 8: {
                if (this.launchProjectile) {
                    this.setAnimation(29, 0);
                    break;
                }
                this.setAnimation(3, 3);
                break;
            }
        }
        if (!this.launchProjectile) {
            this.isShooting = true;
        }
    }

    public void isHit() {
        this.isHit = 18;
        if (GameBoard.manhattanDistance(this.tileRow, this.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol) <= 10) {
            if (!(this.status != 0 && this.status != 4 || this.isAlerted)) {
                this.setCaution(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
            } else {
                this.setAlert(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
            }
        }
    }

    public void knockdown(int direction, int target) {
        if (this.isKnockedDown) {
            return;
        }
        int fallLeftRepeat = 0;
        int fallRightRepeat = 0;
        int fallUpRepeat = 0;
        int fallDownRepeat = 0;
        if (this.immuneKnockdown) {
            this.isHit();
            return;
        }
        this.posSubX = this.tileCol * 20 << 8;
        this.posSubY = this.tileRow * 20 << 8;
        this.posX = this.posSubX >> 8;
        this.posY = this.posSubY >> 8;
        this.spritePlayer.stop();
        byte[] byArray = GameBoard.boundMapData[this.tileRow];
        int n = this.tileCol;
        byArray[n] = (byte)(byArray[n] - 16);
        switch (direction) {
            case 1: {
                this.facingDirection = 4;
                if ((this.tileRow - 1 >= 0 && (GameBoard.boundMapData[this.tileRow - 1][this.tileCol] & 1) == 0 || this.tileRow - 2 >= 0 && (GameBoard.tileLayerZ[this.tileRow - 2][this.tileCol] & 0xF) == 15) && this.tileRow - 2 >= 0 && (GameBoard.boundMapData[this.tileRow - 2][this.tileCol] & 0x10) == 0 && (this.tileCol != GameBoard.snake.tileCol || this.tileRow - 2 != GameBoard.snake.tileRow)) {
                    this.setAnimation(20, fallDownRepeat);
                    this.tileRow -= 2;
                    break;
                }
                this.setDirection(this.facingDirection);
                break;
            }
            case 2: {
                this.facingDirection = 8;
                if (((GameBoard.boundMapData[this.tileRow][this.tileCol] & 2) == 0 || this.tileCol - 1 >= 0 && (GameBoard.tileLayerZ[this.tileRow][this.tileCol - 1] & 0xF) == 15) && this.tileCol - 2 >= 0 && (GameBoard.boundMapData[this.tileRow][this.tileCol - 2] & 0x10) == 0 && (this.tileCol - 2 != GameBoard.snake.tileCol || this.tileRow != GameBoard.snake.tileRow)) {
                    this.setAnimation(21, fallRightRepeat);
                    this.tileCol -= 2;
                    break;
                }
                this.setDirection(this.facingDirection);
                break;
            }
            case 4: {
                this.facingDirection = 1;
                if (((GameBoard.boundMapData[this.tileRow][this.tileCol] & 4) == 0 || this.tileRow + 1 < GameBoard.mapHeight && (GameBoard.tileLayerZ[this.tileRow + 1][this.tileCol] & 0xF) == 15) && this.tileRow + 2 < GameBoard.mapHeight && (GameBoard.boundMapData[this.tileRow + 2][this.tileCol] & 0x10) == 0 && (this.tileCol != GameBoard.snake.tileCol || this.tileRow + 2 != GameBoard.snake.tileRow)) {
                    this.setAnimation(18, fallUpRepeat);
                    this.tileRow += 2;
                    break;
                }
                this.setDirection(this.facingDirection);
                break;
            }
            case 8: {
                this.facingDirection = 2;
                if ((this.tileCol + 1 >= 0 && (GameBoard.boundMapData[this.tileRow][this.tileCol + 1] & 8) == 0 || this.tileCol + 2 < GameBoard.mapHeight && (GameBoard.tileLayerZ[this.tileRow][this.tileCol + 2] & 0xF) == 15) && this.tileCol + 2 < GameBoard.mapHeight && (GameBoard.boundMapData[this.tileRow][this.tileCol + 2] & 0x10) == 0 && (this.tileCol + 2 != GameBoard.snake.tileCol || this.tileRow != GameBoard.snake.tileRow)) {
                    this.setAnimation(19, fallLeftRepeat);
                    this.tileCol += 2;
                    break;
                }
                this.setDirection(this.facingDirection);
                break;
            }
        }
        this.isKnockedDown = true;
        this.isMoving = true;
        this.updateMovePos();
        byte[] byArray2 = GameBoard.boundMapData[this.tileRow];
        int n2 = this.tileCol;
        byArray2[n2] = (byte)(byArray2[n2] + 16);
        if ((GameBoard.tileLayerZ[this.tileRow][this.tileCol] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow - 1][this.tileCol] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + 1] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow - 1][this.tileCol + 1] & 0xF) == 15) {
            this.lifeNumberLeft = 0;
        } else {
            this.computeVisionGrid();
            this.isHit();
        }
        this.moveNumberLeft = 0;
        if (this.isAlerted || this.isCaution) {
            this.computePath(this.currentAlertRow, this.currentAlertCol);
        } else {
            this.computePath(this.checkPointList[this.currentCheckPoint][0], this.checkPointList[this.currentCheckPoint][1]);
        }
    }

    public void fall() {
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(18, 0);
                break;
            }
            case 2: {
                this.setAnimation(8, 0);
                break;
            }
            case 4: {
                this.setAnimation(20, 0);
                break;
            }
            case 8: {
                this.setAnimation(9, 0);
                break;
            }
        }
    }

    public void die() {
        this.lifeNumberLeft = 0;
        this.moveNumberLeft = 0;
        this.actionNumberLeft = 0;
        if (this.status != 4 && this.status != 0) {
            this.fall();
        }
        this.isHit = 18;
        if (this.type != 9 && this.type != 6 && this.type != 7) {
            byte[] byArray = GameBoard.boundMapData[this.tileRow];
            int n = this.tileCol;
            byArray[n] = (byte)(byArray[n] - 16);
        }
        this.isTargetable = false;
        this.isAlerted = false;
        this.hasAlertSet = true;
        this.isAlive = false;
        GameBoard.snake.isTargetingObject = false;
        switch (this.imageId) {
            case 66: 
            case 67: {
                if (this.explosionSpritePlayer == null) {
                    this.explosionSpritePlayer = new PSSpritePlayer(spriteExplosions);
                }
                this.explosionSpritePlayer.play(1, 0);
            }
        }
        if (GameBoard.instance.missionType == 2) {
            GameBoard.instance.checkActiveScript();
        }
    }

    public void updateDisplayPositions() {
        if (this.type == 6 || this.type == 7) {
            return;
        }
        short spriteWidth = this.sprite.getAnimationWidth(this.spritePlayer.getAnimIdx());
        short spriteHeight = this.sprite.getAnimationHeight(this.spritePlayer.getAnimIdx());
        switch (this.imageId) {
            case 71: {
                this.setClipX = this.posX - GameBoard.camX - 100 + 10;
                this.setClipY = this.posY - 160 - GameBoard.camY;
                break;
            }
            case 18: {
                this.setClipX = this.posX - GameBoard.camX + 20;
                this.setClipY = this.posY - GameBoard.camY;
                break;
            }
            default: {
                this.setClipX = this.posX - GameBoard.camX - (spriteWidth >> 1) + 20;
                this.setClipY = this.posY - spriteHeight / 5 * 3 - GameBoard.camY;
            }
        }
        this.displayX = this.setClipX;
        this.displayY = this.setClipY;
    }

    private boolean checkPlayerPos() {
        if (GameBoard.snake.getEquipment(11) == -1) {
            for (int i = 0; i < this.currentVisionGrid.length && this.currentVisionGrid[i] > -1; i += 2) {
                if (this.currentVisionGrid[i] != GameBoard.snake.tileRow || this.currentVisionGrid[i + 1] != GameBoard.snake.tileCol) continue;
                this.setAlert(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
                return true;
            }
        }
        return false;
    }

    public boolean checkPlayerPosOutOfAI() {
        for (int i = 0; i < this.currentVisionGrid.length && this.currentVisionGrid[i] > -1; i += 2) {
            if (this.currentVisionGrid[i] != GameBoard.snake.tileRow || this.currentVisionGrid[i + 1] != GameBoard.snake.tileCol) continue;
            this.setAlert(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
            return true;
        }
        return false;
    }

    public void setAnimation(int animatedAction, int repeatCount) {
        if (animatedAction >= this.animatedActions.length || this.animatedActions[animatedAction] == -1) {
            return;
        }
        this.isAnimated = true;
        this.spritePlayer.play(this.animatedActions[animatedAction], repeatCount);
        this.updateDisplayPositions();
    }

    public boolean checkSound(int rowToCheck, int colToCheck) {
        return (GameBoard.tileLayerZ[rowToCheck][colToCheck] & 0x20) == 0 && GameBoard.manhattanDistance(this.tileRow, this.tileCol, rowToCheck, colToCheck) <= 8;
    }

    public void setCaution(int row, int col) {
        if (!this.isAlerted && this.isAlive) {
            if (!this.hasCautionSet) {
                PSCanvas.soundManager.play(0, 19, 0);
                PSCanvas.setVibration(200);
                this.hasCautionSet = true;
            }
            this.isCaution = true;
            this.currentAlertRow = row;
            this.currentAlertCol = col;
        }
    }

    public void setAlert(int row, int col) {
        if (this.status != 4 && this.status != 0 && this.isAlive) {
            if (!this.hasAlertSet) {
                PSCanvas.soundManager.play(0, 19, 0);
                PSCanvas.setVibration(200);
                this.hasAlertSet = true;
            }
            this.isAlerted = true;
            this.currentAlertRow = row;
            this.currentAlertCol = col;
        }
    }

    public void setAlertOff() {
        if (this.type == 4 || this.type == 5 || this.type == 11 || this.type == 12 || this.type == 13) {
            return;
        }
        this.hasAlertSet = false;
        this.hasCautionSet = false;
        this.isAlerted = false;
        this.isCaution = false;
        this.pathPoints = null;
    }

    public void setDamage(int damage, int type, int statusEffect) {
        this.damageToPrint = type == -1 ? -damage : damage;
        this.damagePrintDuration = 0;
        this.lifeNumberLeft -= this.damageToPrint;
        if (this.lifeNumberLeft <= 0) {
            this.moveNumberLeft = 0;
            this.actionNumberLeft = 0;
            if (this.type == 6 || this.type == 7) {
                this.isAlive = false;
                this.isTargetable = false;
                this.lifeNumberLeft = 0;
            } else if (this.type == 5) {
                GameBoard.AiArray[1].isAlive = false;
                GameBoard.AiArray[1].lifeNumberLeft = 0;
                GameBoard.AiArray[2].isAlive = false;
                GameBoard.AiArray[2].lifeNumberLeft = 0;
            }
        }
        if (statusEffect > -1 && statusEffect < 5) {
            if (!(statusEffect != 4 && statusEffect != 0 || this.immuneStun)) {
                this.effectDuration = 2;
                this.status = statusEffect;
                this.moveNumberLeft = 0;
                this.actionNumberLeft = 0;
            } else if (!(statusEffect != 1 && statusEffect != 2 || this.isMachine)) {
                this.effectDuration = 3;
                this.status = statusEffect;
            } else if (statusEffect == 3 && !this.immuneBlind) {
                if (type == 9) {
                    this.die();
                } else {
                    this.effectDuration = 5;
                    this.status = statusEffect;
                }
            }
        }
    }

    static {
        GUARD_ANIMATED_ACTIONS = new int[]{4, 7, 5, 6, -1, -1, -1, -1, 26, 27, 0, 3, 1, 2, 18, 21, 19, 20, 32, 16, 33, 17, -1, -1, -1, -1};
        RIKISHI_ANIMATED_ACTIONS = new int[]{2, 0, 3, 1, -1, -1, -1, -1, -1, -1, 10, 8, 11, 9, 10, 8, 11, 9, 14, 12, 15, 13, -1, -1, -1, -1};
        SUKIYAKI_ANIMATED_ACTIONS = new int[]{2, 0, 3, 7, -1, -1, -1, -1, -1, -1, 10, 8, 11, 15, 10, 8, 11, 15, 18, 16, 19, 23, -1, -1, -1, -1};
        METAL_GEAR_ANIMATED_ACTIONS = new int[]{-1, 4, 3, 5, -1, -1, -1, -1, -1, -1, -1, 1, -1, 2, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        CAMERA_ANIMATED_ACTIONS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        VINCE_ANIMATED_ACTIONS = new int[]{10, 11, 9, 8, -1, -1, -1, -1, 27, 25, 7, 6, 5, 4, 2, 3, 0, 1, 26, 27, 24, 25, -1, -1, -1, -1, 18, 19, 17, 16, -1, -1, -1, -1};
        GUNCYPHER_ANIMATED_ACTIONS = new int[]{-1, -1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }
}

