/*
 * Decompiled with CFR 0.152.
 */
public class DeckEditor
implements Constants,
PSText {
    private PSGraphics g;
    private int optionIndex = 0;
    private int stateDeckEditor = 0;
    private int x = 0;
    private int y = 0;
    private int offsetCardList = 0;
    private int selectedCard = 0;
    private int[] cardsInDeckCount;
    private int messageText = 0;
    private int unlockedCardsNumber = 0;
    private int[] unlockedCards;
    private int upgradableCardsNumber = 0;
    private int[] upgradableCards;
    private int pagesNumber = 0;
    private int pagesUpgradableNumber = 0;
    private boolean isCardUpgraded = false;
    private long startTime;
    private long endTime;
    private int keyBlocked = 0;
    private int cardIconBigWidth;
    private int cardIconBigHeight;
    private int cardBigWidth;
    private int cardBigHeight;
    private boolean refreshAll = true;

    public DeckEditor() {
        if (PSCanvas.isFirstRunDeckEditor) {
            this.stateDeckEditor = 5;
            this.messageText = 558;
            PSCanvas.isFirstRunDeckEditor = false;
        }
        this.cardsInDeckCount = new int[5];
        this.cardIconBigWidth = 68;
        this.cardIconBigHeight = 44;
        this.cardBigWidth = 78;
        this.cardBigHeight = 105;
    }

    private void prepareUnlockedCards() {
        int i;
        int unlockedIndex = 0;
        this.unlockedCardsNumber = 0;
        this.unlockedCards = null;
        for (i = 0; i < CardSet.CARD_LIST.length; ++i) {
            if (!CardSet.CARD_LIST[i].getIsUnlocked()) continue;
            ++this.unlockedCardsNumber;
        }
        for (i = 0; i < this.cardsInDeckCount.length; ++i) {
            this.cardsInDeckCount[i] = 0;
        }
        this.unlockedCards = new int[this.unlockedCardsNumber];
        for (i = 0; i < CardSet.CARD_LIST.length; ++i) {
            if (!CardSet.CARD_LIST[i].getIsUnlocked()) continue;
            this.unlockedCards[unlockedIndex++] = i;
            if (CardSet.CARD_LIST[i].getCardsInDeckAmount() <= 0) continue;
            int n = CardSet.CARD_LIST[i].getCardType();
            this.cardsInDeckCount[n] = this.cardsInDeckCount[n] + CardSet.CARD_LIST[i].getCardsInDeckAmount();
        }
        this.pagesNumber = this.unlockedCardsNumber / 4;
        if (this.unlockedCardsNumber % 4 != 0) {
            ++this.pagesNumber;
        }
    }

    private void prepareUpgradableCards() {
        int i;
        int upgradableIndex = 0;
        this.upgradableCardsNumber = 0;
        this.upgradableCards = null;
        for (i = 0; i < CardSet.CARD_LIST.length; ++i) {
            if (!CardSet.CARD_LIST[i].getIsUnlocked() || !CardSet.CARD_LIST[i].getIsUpgradable()) continue;
            ++this.upgradableCardsNumber;
        }
        this.upgradableCards = new int[this.upgradableCardsNumber];
        for (i = 0; i < CardSet.CARD_LIST.length; ++i) {
            if (!CardSet.CARD_LIST[i].getIsUnlocked() || !CardSet.CARD_LIST[i].getIsUpgradable()) continue;
            this.upgradableCards[upgradableIndex++] = i;
        }
        this.pagesUpgradableNumber = this.upgradableCardsNumber / 4;
        if (this.upgradableCardsNumber % 4 != 0) {
            ++this.pagesUpgradableNumber;
        }
    }

    public void updateDisplayDeckEditor(PSGraphics gDeckEditor) {
        this.x = 0;
        this.y = 0;
        this.g = gDeckEditor;
        PSCanvas.fontEngine.setSpacing(1);
        if (this.refreshAll) {
            if (this.stateDeckEditor != 4 && this.stateDeckEditor != 5) {
                this.displayEditorBase();
            }
            if (this.stateDeckEditor == 1) {
                this.displayEdit();
            }
            if (this.stateDeckEditor == 4) {
                this.displayMessage();
            }
            if (this.stateDeckEditor == 2) {
                this.displayAutoDeck();
            }
            if (this.stateDeckEditor == 3) {
                this.displayUpgrade();
            }
            if (this.stateDeckEditor == 5) {
                this.displayMessage();
            }
        }
        PSCanvas.fontEngine.resetSpacing();
        this.refreshAll = false;
    }

    public void updateDeckEditor() {
        this.endTime = System.currentTimeMillis();
        switch (this.stateDeckEditor) {
            case 0: {
                if ((PSCanvas.keyPressed & 2) != 0) {
                    --this.optionIndex;
                    if (this.optionIndex < 0) {
                        this.optionIndex = 2;
                    }
                    this.refreshAll = true;
                } else if ((PSCanvas.keyPressed & 8) != 0) {
                    ++this.optionIndex;
                    if (this.optionIndex > 2) {
                        this.optionIndex = 0;
                    }
                    this.refreshAll = true;
                } else if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                    this.stateDeckEditor = this.optionIndex + 1;
                    this.selectedCard = 0;
                    this.offsetCardList = 0;
                    if (this.stateDeckEditor != 3) {
                        this.prepareUnlockedCards();
                    } else {
                        this.prepareUpgradableCards();
                    }
                    PSCanvas.soundManager.play(0, 12, 0);
                    this.refreshAll = true;
                } else if ((PSCanvas.keyPressed & 0x100) != 0) {
                    PSCanvas.nextState = 4;
                }
                PSCanvas.keyClear();
                break;
            }
            case 1: {
                --this.keyBlocked;
                if ((PSCanvas.keyPressed & 1) != 0) {
                    if (this.keyBlocked > 0) break;
                    --this.selectedCard;
                    if (this.selectedCard < this.offsetCardList * 4) {
                        --this.offsetCardList;
                    }
                    if (this.offsetCardList < 0) {
                        this.offsetCardList = this.pagesNumber - 1;
                    }
                    if (this.selectedCard < 0) {
                        this.selectedCard = this.unlockedCardsNumber - 1;
                        this.offsetCardList = this.pagesNumber - 1;
                    }
                    this.keyBlocked = 2;
                    this.refreshAll = true;
                    break;
                }
                if ((PSCanvas.keyPressed & 4) != 0) {
                    if (this.keyBlocked > 0) break;
                    ++this.selectedCard;
                    if (this.selectedCard == this.offsetCardList * 4 + 4) {
                        ++this.offsetCardList;
                    }
                    if (this.selectedCard > this.unlockedCardsNumber - 1) {
                        this.selectedCard = 0;
                        this.offsetCardList = 0;
                    }
                    this.keyBlocked = 2;
                    this.refreshAll = true;
                    break;
                }
                if ((PSCanvas.keyPressed & 8) != 0) {
                    int cardsInDeck = CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardsInDeckAmount();
                    if (cardsInDeck < CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getLimitInDeck() && CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardsOwnAmount() - cardsInDeck > 0 && PSCanvas.gameDeck.getDeckSize() > this.checkCardsInDeckNumber()) {
                        PSCanvas.soundManager.play(0, 13, 0);
                        ++cardsInDeck;
                        int n = CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardType();
                        this.cardsInDeckCount[n] = this.cardsInDeckCount[n] + 1;
                        PSCanvas.gameDeck.addCardToDeck(this.unlockedCards[this.selectedCard]);
                        this.refreshAll = true;
                    }
                    PSCanvas.keyClear();
                    break;
                }
                if ((PSCanvas.keyPressed & 2) != 0) {
                    int cardsInDeck = CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardsInDeckAmount();
                    if (cardsInDeck > 0 && this.checkCardsInDeckNumber() > 10) {
                        PSCanvas.soundManager.play(0, 13, 0);
                        --cardsInDeck;
                        int n = CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardType();
                        this.cardsInDeckCount[n] = this.cardsInDeckCount[n] - 1;
                        PSCanvas.gameDeck.removeCardFromDeck(this.unlockedCards[this.selectedCard]);
                        this.refreshAll = true;
                    }
                    PSCanvas.keyClear();
                    break;
                }
                if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                    this.messageText = 485;
                    this.stateDeckEditor = 4;
                    PSCanvas.keyClear();
                    this.refreshAll = true;
                    break;
                }
                if ((PSCanvas.keyPressed & 0x100) == 0) break;
                this.messageText = 486;
                this.stateDeckEditor = 4;
                PSCanvas.keyClear();
                this.refreshAll = true;
                break;
            }
            case 2: {
                if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                    this.autoDeckConfiguration();
                    this.stateDeckEditor = 0;
                    this.refreshAll = true;
                } else if ((PSCanvas.keyPressed & 0x100) != 0) {
                    this.stateDeckEditor = 0;
                    this.refreshAll = true;
                }
                PSCanvas.keyClear();
                break;
            }
            case 3: {
                if ((PSCanvas.keyPressed & 1) != 0) {
                    if (this.keyBlocked <= 0) {
                        --this.selectedCard;
                        if (this.selectedCard < this.offsetCardList * 4) {
                            --this.offsetCardList;
                        }
                        if (this.offsetCardList < 0) {
                            this.offsetCardList = this.pagesUpgradableNumber - 1;
                        }
                        if (this.selectedCard < 0) {
                            this.selectedCard = this.upgradableCardsNumber - 1;
                            this.offsetCardList = this.pagesUpgradableNumber - 1;
                        }
                        this.keyBlocked = 2;
                        this.refreshAll = true;
                        break;
                    }
                    --this.keyBlocked;
                    break;
                }
                if ((PSCanvas.keyPressed & 4) != 0) {
                    if (this.keyBlocked <= 0) {
                        ++this.selectedCard;
                        if (this.selectedCard == this.offsetCardList * 4 + 4) {
                            ++this.offsetCardList;
                        }
                        if (this.selectedCard > this.upgradableCardsNumber - 1) {
                            this.selectedCard = 0;
                            this.offsetCardList = 0;
                        }
                        this.keyBlocked = 2;
                        this.refreshAll = true;
                        break;
                    }
                    --this.keyBlocked;
                    break;
                }
                if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                    if (PSCanvas.gamePoints >= CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getPointsPrice()) {
                        this.refreshAll = true;
                        this.upgradeSelectedCard(this.upgradableCards[this.selectedCard]);
                    }
                    PSCanvas.keyClear();
                    break;
                }
                if ((PSCanvas.keyPressed & 0x100) == 0) break;
                this.stateDeckEditor = 0;
                PSCanvas.saveData();
                PSCanvas.keyClear();
                this.refreshAll = true;
                break;
            }
            case 4: {
                if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                    if (this.isCardUpgraded) {
                        this.stateDeckEditor = 3;
                        this.isCardUpgraded = false;
                    } else {
                        if (this.messageText == 485) {
                            PSCanvas.saveData();
                        }
                        this.stateDeckEditor = 0;
                    }
                    this.refreshAll = true;
                } else if ((PSCanvas.keyPressed & 0x100) != 0) {
                    if (!this.isCardUpgraded) {
                        this.stateDeckEditor = 1;
                    }
                    this.refreshAll = true;
                }
                PSCanvas.keyClear();
                break;
            }
            case 5: {
                if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                    this.stateDeckEditor = 0;
                    this.refreshAll = true;
                } else if ((PSCanvas.keyPressed & 0x100) != 0) {
                    PSCanvas.nextState = 4;
                    this.refreshAll = true;
                }
                PSCanvas.keyClear();
            }
        }
    }

    private void displayEditorBase() {
        int textDeckEditorLength = PSCanvas.fontEngine.getTextLength(1, PSCanvas.textArray[480]);
        int pointsWidth = PSCanvas.fontEngine.getTextLength(1, "0000000");
        int buttonWidth = PSCanvas.imageWidth[52] / 6;
        int buttonHeight = PSCanvas.imageHeight[52];
        this.g.setClip(this.x, this.y, 176, 208);
        this.g.drawImage(PSCanvas.imageArray[40], this.x, this.y);
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(this.x, this.y, 176, 12);
        this.g.setColor(0);
        this.g.drawLine(this.x, 12, 176, 12);
        this.x += 2;
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[0], 12);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[0], this.y);
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.DOTED);
        this.x += 2 + Constants.DECK_EDITOR_ICONS_WIDTH[0];
        this.g.drawLine(this.x, this.y, this.x, 12);
        this.x += 3;
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[480], this.x, 6, 35);
        this.x += 2 + textDeckEditorLength + Constants.DECK_EDITOR_ICONS_WIDTH[0];
        this.g.drawLine(this.x, this.y, this.x, 12);
        this.x += 3;
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[1], 12);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[1], this.y);
        this.x += Constants.DECK_EDITOR_ICONS_WIDTH[1] + 2 + pointsWidth + 1;
        PSCanvas.fontEngine.drawFont(this.g, 1, "" + PSCanvas.gamePoints, this.x, 6, 37);
        this.g.setClip(0, 0, 176, 208);
        this.x += Constants.DECK_EDITOR_ICONS_WIDTH[1];
        this.g.drawLine(this.x, this.y, this.x, 12);
        this.y += 15;
        this.x = 88 - (3 * buttonWidth + 6) / 2;
        for (int i = 0; i < 3; ++i) {
            this.g.setClip(this.x + i * (3 + buttonWidth), this.y, buttonWidth, buttonHeight);
            if (i == this.optionIndex) {
                this.g.drawImage(PSCanvas.imageArray[52], this.x + i * (3 + buttonWidth) - (buttonWidth * i + 3 * buttonWidth), this.y);
                if (this.stateDeckEditor != 0) continue;
                PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[487 + i], 88, 104, 176, 40);
                continue;
            }
            this.g.drawImage(PSCanvas.imageArray[52], this.x + i * (3 + buttonWidth) - buttonWidth * i, this.y);
        }
        if (this.stateDeckEditor == 1) {
            PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[549] + " " + this.checkCardsInDeckNumber() + "/" + PSCanvas.gameDeck.getDeckSize(), this.x + 3 * (3 + buttonWidth), this.y + buttonHeight / 2, 176, 35);
        }
        this.y += buttonHeight + 3;
        this.g.setStrokeStyle(PSGraphics.SOLID);
    }

    private void displayEdit() {
        int i;
        this.x = 0;
        int idColumnWidth = PSCanvas.fontEngine.getTextLength(1, "000");
        int nameColumnWidth = 88 + idColumnWidth / 2;
        nameColumnWidth -= 17;
        int costColumnWidth = PSCanvas.fontEngine.getTextLength(1, "00");
        int categoryColumnWidth = Constants.DECK_EDITOR_ICONS_WIDTH[6];
        int cardsInStockWidth = Constants.DECK_EDITOR_ICONS_WIDTH[5] + idColumnWidth / 2;
        int elementHeight = 12;
        int listHeight = elementHeight * 4;
        int allColumsWidth = idColumnWidth + nameColumnWidth + costColumnWidth + categoryColumnWidth + cardsInStockWidth + 20;
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.g.drawRect(this.x, this.y, 176, listHeight + elementHeight + 2);
        this.g.setStrokeStyle(PSGraphics.DOTED);
        this.x += idColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.x += nameColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.x += costColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.x += categoryColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.x = 2 + idColumnWidth / 2;
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[482], this.x, this.y + elementHeight / 2, 41);
        this.x += 8 + idColumnWidth / 2;
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[481], this.x, this.y + elementHeight / 2, 35);
        this.x += nameColumnWidth + 2 + (costColumnWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[3] / 2);
        ++this.y;
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[3], elementHeight);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[3], this.y);
        this.x += costColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[3] / 2 + 4 + (categoryColumnWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[4] / 2);
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[4], elementHeight);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[4], this.y);
        this.x += 4 + (categoryColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[4] / 2) + (cardsInStockWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[5] / 2);
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[5], elementHeight);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[5], this.y);
        this.g.setClip(0, 0, 176, 208);
        this.x = 0;
        this.y += elementHeight + 1;
        this.g.drawLine(this.x, this.y, 176, this.y);
        int limit = this.offsetCardList * 4 + 4;
        if (limit > this.unlockedCardsNumber) {
            limit = this.offsetCardList * 4 + (this.unlockedCardsNumber - this.offsetCardList * 4);
        }
        for (i = this.offsetCardList * 4; i < limit; ++i) {
            if (i == this.selectedCard) {
                this.x = 0;
                this.g.setColor(0);
                this.g.setClip(this.x, this.y, allColumsWidth, elementHeight);
                this.g.fillRect(this.x, this.y, allColumsWidth, elementHeight);
                this.x += 2;
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + CardSet.CARD_LIST[this.unlockedCards[i]].getCardID(), this.x, this.y + elementHeight / 2, 35);
                this.x += 6 + idColumnWidth;
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[CardSet.CARD_LIST[this.unlockedCards[i]].getCardName()].toUpperCase(), this.x, this.y + elementHeight / 2, 35);
                this.x += nameColumnWidth + 2 + costColumnWidth / 2;
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + CardSet.CARD_LIST[this.unlockedCards[i]].getCardCost(), this.x, this.y + elementHeight / 2, 41);
                this.x += costColumnWidth / 2 - 2 + (categoryColumnWidth - Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()] / 2);
                this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[16 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()], elementHeight);
                this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[16 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()], this.y);
                this.x += 6 + (categoryColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[16 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()] / 2) + (cardsInStockWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[5] / 2);
                PSCanvas.fontEngine.drawFont(this.g, 2, CardSet.CARD_LIST[this.unlockedCards[i]].getCardsInDeckAmount() + "/" + CardSet.CARD_LIST[this.unlockedCards[i]].getLimitInDeck() + "(" + (CardSet.CARD_LIST[this.unlockedCards[i]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[i]].getCardsInDeckAmount()) + ")", this.x, this.y + (elementHeight / 2 + 1), 35);
                this.y += elementHeight;
                continue;
            }
            this.x = 2;
            PSCanvas.fontEngine.drawFont(this.g, 1, "" + CardSet.CARD_LIST[this.unlockedCards[i]].getCardID(), this.x, this.y + elementHeight / 2, 35);
            this.x += 6 + idColumnWidth;
            PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[CardSet.CARD_LIST[this.unlockedCards[i]].getCardName()].toUpperCase(), this.x, this.y + elementHeight / 2, 35);
            this.x += nameColumnWidth + 2 + costColumnWidth / 2;
            PSCanvas.fontEngine.drawFont(this.g, 1, "" + CardSet.CARD_LIST[this.unlockedCards[i]].getCardCost(), this.x, this.y + elementHeight / 2, 41);
            this.x += costColumnWidth / 2 - 2 + (categoryColumnWidth - Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()] / 2);
            this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()], elementHeight);
            this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[6 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()], this.y);
            this.x += 6 + (categoryColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.unlockedCards[i]].getCardType()] / 2) + (cardsInStockWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[5] / 2);
            PSCanvas.fontEngine.drawFont(this.g, 1, CardSet.CARD_LIST[this.unlockedCards[i]].getCardsInDeckAmount() + "/" + CardSet.CARD_LIST[this.unlockedCards[i]].getLimitInDeck() + "(" + (CardSet.CARD_LIST[this.unlockedCards[i]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[i]].getCardsInDeckAmount()) + ")", this.x, this.y + (elementHeight / 2 + 1), 35);
            this.y += elementHeight;
        }
        if (this.offsetCardList * 4 + 4 - limit < 4) {
            this.y += (this.offsetCardList * 4 + 4 - limit) * elementHeight;
        }
        this.x = 0;
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.x += categoryColumnWidth;
        this.g.drawLine(this.x, this.y + 1, this.x, this.y + elementHeight - 1);
        this.x = 176 - categoryColumnWidth - 1;
        this.g.drawLine(this.x, this.y + 1, this.x, this.y + elementHeight - 1);
        this.x = categoryColumnWidth / 2 - 2;
        for (i = 1; i <= 4; ++i) {
            this.g.fillRect(this.x + 4 - i - 1, this.y + (elementHeight / 2 - 2) + (i - 1), 2 * i - 1, 1);
        }
        this.x = 176 - categoryColumnWidth / 2 - 2;
        for (i = 4; i > 0; --i) {
            this.g.fillRect(this.x + 2 - i, this.y + (elementHeight / 2 + 2) - (i - 1), 2 * i - 1, 1);
        }
        PSCanvas.fontEngine.drawFont(this.g, 1, this.offsetCardList + 1 + "/" + this.pagesNumber, 88, this.y + elementHeight / 2, 41);
        this.x = 0;
        this.y += elementHeight;
        this.g.drawLine(this.x, this.y, 176, this.y);
        this.g.drawLine(this.x, this.y + PSCanvas.imageHeight[43], 176, this.y + PSCanvas.imageHeight[43]);
        this.x += 2;
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.DOTED);
        for (i = 0; i < 6; ++i) {
            this.g.drawLine(this.x + i * (8 + categoryColumnWidth + costColumnWidth), this.y, this.x + i * (8 + categoryColumnWidth + costColumnWidth), this.y + PSCanvas.imageHeight[43]);
        }
        this.x += 2;
        for (i = 0; i < 5; ++i) {
            this.g.setClip(this.x + i * (8 + categoryColumnWidth + costColumnWidth), this.y + (PSCanvas.imageHeight[43] / 2 - 6), Constants.DECK_EDITOR_ICONS_WIDTH[6 + i], 12);
            this.g.drawImage(PSCanvas.imageArray[53], this.x + i * (8 + categoryColumnWidth + costColumnWidth) - Constants.DECK_EDITOR_ICONS_OFFSET[6 + i], this.y + (PSCanvas.imageHeight[43] / 2 - 6));
            PSCanvas.fontEngine.drawFont(this.g, 1, (this.cardsInDeckCount[i] < 10 ? "0" : "") + this.cardsInDeckCount[i], this.x + i * (8 + categoryColumnWidth + costColumnWidth) + categoryColumnWidth + costColumnWidth, this.y + (PSCanvas.imageHeight[43] / 2 - PSCanvas.fontEngine.getFontHeight(1) / 2), 58, 21);
        }
        this.y += PSCanvas.imageHeight[43];
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.g.setClip(0, 0, 176, 208);
        this.g.drawLine(88, this.y, 88, 208);
        this.x = 44 - this.cardBigWidth / 2;
        this.y += 3;
        this.displayCard(this.unlockedCards[this.selectedCard], this.x, this.y);
        PSCanvas.fontEngine.setSpacing(1);
        String cardDescription = PSCanvas.textArray[CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardDescription()];
        if (CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardUsageType() == 2) {
            cardDescription = PSCanvas.textArray[500] + ":" + CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardReactionChance() + "%|" + cardDescription;
        }
        if (CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardUsageType() == 1 && CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardType() == 0) {
            cardDescription = PSCanvas.textArray[498] + ":" + CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardAttackDamage() + (CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getAttacksNumber() > 1 ? " x " + CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getAttacksNumber() : "") + "|" + PSCanvas.textArray[499] + ":" + CardSet.CARD_LIST[this.unlockedCards[this.selectedCard]].getCardHitChance() + "%|" + cardDescription;
        }
        this.x = 90;
        PSCanvas.fontEngine.drawFont(this.g, 1, cardDescription.toUpperCase(), this.x, this.y, 82, 18);
    }

    private void displayMessage() {
        this.g.setColor(0);
        this.g.setClip(0, 0, 176, 208);
        this.g.fillRect(0, 0, 176, 208);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[this.messageText], 88, 104, 170, 40);
    }

    private void displayCard(int card, int x, int y) {
        int startX = x;
        int startY = y;
        int cardColor = 0;
        switch (CardSet.CARD_LIST[card].getCardType()) {
            case 0: {
                cardColor = 16716947;
                break;
            }
            case 3: {
                cardColor = 255;
                break;
            }
            case 1: {
                cardColor = 4312599;
                break;
            }
            case 4: {
                cardColor = 0x444444;
                break;
            }
            case 2: {
                cardColor = 16743936;
            }
        }
        int fontHeight = PSCanvas.fontEngine.getFontHeight(0);
        this.g.setClip(startX + 2, startY + 2, this.cardBigWidth, this.cardBigHeight);
        this.g.setColor(0);
        this.g.fillRect(startX + 2, startY + 2, this.cardBigWidth, this.cardBigHeight);
        this.g.setClip(startX, startY, this.cardBigWidth, this.cardBigHeight);
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(startX, startY, this.cardBigWidth, this.cardBigHeight);
        this.g.setColor(cardColor);
        for (int i = 0; i < 2; ++i) {
            this.g.drawRect(startX + i, startY + i, this.cardBigWidth - 1 - 2 * i, this.cardBigHeight - 1 - 2 * i);
        }
        this.g.setColor(cardColor);
        this.g.fillRect(startX + 5, startY + 5, this.cardBigWidth - 10, this.cardIconBigHeight);
        this.g.setColor(0x343434);
        this.g.fillRect(startX + 5, startY + 10, this.cardBigWidth - 10, this.cardIconBigHeight - fontHeight - 5);
        this.g.setColor(0xCCCCCC);
        this.g.fillRect(startX + 5 + 3, startY + 10 + 3, this.cardBigWidth - 10 - 6, this.cardIconBigHeight - fontHeight - 5 - 6);
        PSCanvas.fontEngine.setSpacing(0);
        int textWidth = PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[57 + CardSet.CARD_LIST[card].getCardUsageType()].toUpperCase());
        PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[57 + CardSet.CARD_LIST[card].getCardUsageType()].toUpperCase(), startX + 5 + 3, startY + 10 + 3, 19);
        textWidth = PSCanvas.fontEngine.getTextLength(4, "" + CardSet.CARD_LIST[card].getCardCost());
        PSCanvas.fontEngine.drawFont(this.g, 4, "" + CardSet.CARD_LIST[card].getCardCost(), startX + this.cardBigWidth - 2 - 4, startY + this.cardBigHeight / 3 + -8 + fontHeight / 2 - 1, 37);
        textWidth = PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()]);
        String tempTxt = PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()];
        if (tempTxt.length() > 1) {
            tempTxt = PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].substring(0, PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].length() > 10 ? 10 : PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].length()) + (PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].length() > 10 ? "." : "");
        }
        PSCanvas.fontEngine.drawFont(this.g, 0, tempTxt, startX + this.cardBigWidth / 2, startY + this.cardBigHeight / 2 + -8, 41);
    }

    private void displayAutoDeck() {
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[488].toUpperCase(), 88, this.y, 24);
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[501].toUpperCase(), 88, 104, 170, 40);
    }

    private void autoDeckConfiguration() {
        int i;
        int cardCount = 0;
        int indexCard = 0;
        int amountAdd = 0;
        int randomAmount = 0;
        int allUnlockedCardsCount = 0;
        PSCanvas.gameDeck.removeAllCardFromDeck();
        for (i = 0; i < this.unlockedCards.length; ++i) {
            if (CardSet.CARD_LIST[this.unlockedCards[i]].getCardSubType() == 12 && CardSet.CARD_LIST[this.unlockedCards[indexCard = i]].getCardsInDeckAmount() < CardSet.CARD_LIST[this.unlockedCards[indexCard]].getLimitInDeck() && CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount() > 0) {
                amountAdd = CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount() >= CardSet.CARD_LIST[this.unlockedCards[indexCard]].getLimitInDeck() ? CardSet.CARD_LIST[this.unlockedCards[indexCard]].getLimitInDeck() : CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount();
                randomAmount = PSCanvas.getRandom(1, amountAdd);
                for (int j = 1; j <= randomAmount; ++j) {
                    PSCanvas.gameDeck.addCardToDeck(this.unlockedCards[indexCard]);
                    ++cardCount;
                }
            }
            allUnlockedCardsCount += CardSet.CARD_LIST[this.unlockedCards[i]].getCardsOwnAmount();
        }
        block2: while (cardCount < PSCanvas.gameDeck.getDeckSize() && cardCount < allUnlockedCardsCount) {
            indexCard = PSCanvas.getRandom(0, this.unlockedCards.length - 1);
            if (CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount() >= CardSet.CARD_LIST[this.unlockedCards[indexCard]].getLimitInDeck() || CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount() <= 0) continue;
            amountAdd = CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount() >= CardSet.CARD_LIST[this.unlockedCards[indexCard]].getLimitInDeck() ? CardSet.CARD_LIST[this.unlockedCards[indexCard]].getLimitInDeck() : CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsOwnAmount() - CardSet.CARD_LIST[this.unlockedCards[indexCard]].getCardsInDeckAmount();
            randomAmount = PSCanvas.getRandom(1, amountAdd);
            for (i = 1; i <= randomAmount; ++i) {
                PSCanvas.gameDeck.addCardToDeck(this.unlockedCards[indexCard]);
                if (++cardCount == PSCanvas.gameDeck.getDeckSize()) continue block2;
            }
        }
    }

    private void displayUpgrade() {
        int i;
        this.x = 0;
        int idColumnWidth = PSCanvas.fontEngine.getTextLength(1, "000");
        int nameColumnWidth = 88 + idColumnWidth / 2;
        nameColumnWidth -= 17;
        int costColumnWidth = PSCanvas.fontEngine.getTextLength(1, "00");
        int categoryColumnWidth = Constants.DECK_EDITOR_ICONS_WIDTH[6];
        int cardsPriceWidth = Constants.DECK_EDITOR_ICONS_WIDTH[5] + idColumnWidth / 2;
        int elementHeight = 12;
        int listHeight = elementHeight * 4;
        int allColumsWidth = idColumnWidth + nameColumnWidth + costColumnWidth + categoryColumnWidth + cardsPriceWidth + 20;
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.g.drawRect(this.x, this.y, 176, listHeight + elementHeight + 2);
        this.g.setStrokeStyle(PSGraphics.DOTED);
        this.x += idColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.x += nameColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.x += costColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.x += categoryColumnWidth + 4;
        this.g.drawLine(this.x, this.y, this.x, this.y + listHeight + elementHeight + 2);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.x = 2 + idColumnWidth / 2;
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[482], this.x, this.y + elementHeight / 2, 41);
        this.x += 8 + idColumnWidth / 2;
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[481], this.x, this.y + elementHeight / 2, 35);
        this.x += nameColumnWidth + 2 + (costColumnWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[3] / 2);
        ++this.y;
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[3], elementHeight);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[3], this.y);
        this.x += costColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[3] / 2 + 4 + (categoryColumnWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[4] / 2);
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[4], elementHeight);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[4], this.y);
        this.x += 4 + (categoryColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[4] / 2) + (cardsPriceWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[1] / 2);
        this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[1], elementHeight);
        this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[1], this.y);
        this.g.setClip(0, 0, 176, 208);
        this.x = 0;
        this.y += elementHeight + 1;
        this.g.drawLine(this.x, this.y, 176, this.y);
        int limit = this.offsetCardList * 4 + 4;
        if (limit > this.upgradableCardsNumber) {
            limit = this.offsetCardList * 4 + (this.upgradableCardsNumber - this.offsetCardList * 4);
        }
        for (i = this.offsetCardList * 4; i < limit; ++i) {
            if (i == this.selectedCard) {
                this.x = 0;
                this.g.setColor(0);
                this.g.setClip(this.x, this.y, allColumsWidth, elementHeight);
                this.g.fillRect(this.x, this.y, allColumsWidth, elementHeight);
                this.x += 2;
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + CardSet.CARD_LIST[this.upgradableCards[i]].getCardID(), this.x, this.y + elementHeight / 2, 35);
                this.x += 6 + idColumnWidth;
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[CardSet.CARD_LIST[this.upgradableCards[i]].getCardName()].toUpperCase(), this.x, this.y + elementHeight / 2, 35);
                this.x += nameColumnWidth + 2 + costColumnWidth / 2;
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + CardSet.CARD_LIST[this.upgradableCards[i]].getCardCost(), this.x, this.y + elementHeight / 2, 41);
                this.x += costColumnWidth / 2 - 2 + (categoryColumnWidth - Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()] / 2);
                this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[16 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()], elementHeight);
                this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[16 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()], this.y);
                this.x += 6 + (categoryColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[16 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()] / 2) + (cardsPriceWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[5] / 2);
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + CardSet.CARD_LIST[this.upgradableCards[i]].getPointsPrice(), this.x, this.y + (elementHeight / 2 + 1), 35);
                this.y += elementHeight;
                continue;
            }
            this.x = 2;
            PSCanvas.fontEngine.drawFont(this.g, 1, "" + CardSet.CARD_LIST[this.upgradableCards[i]].getCardID(), this.x, this.y + elementHeight / 2, 35);
            this.x += 6 + idColumnWidth;
            PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[CardSet.CARD_LIST[this.upgradableCards[i]].getCardName()].toUpperCase(), this.x, this.y + elementHeight / 2, 35);
            this.x += nameColumnWidth + 2 + costColumnWidth / 2;
            PSCanvas.fontEngine.drawFont(this.g, 1, "" + CardSet.CARD_LIST[this.upgradableCards[i]].getCardCost(), this.x, this.y + elementHeight / 2, 41);
            this.x += costColumnWidth / 2 - 2 + (categoryColumnWidth - Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()] / 2);
            this.g.setClip(this.x, this.y, Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()], elementHeight);
            this.g.drawImage(PSCanvas.imageArray[53], this.x - Constants.DECK_EDITOR_ICONS_OFFSET[6 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()], this.y);
            this.x += 6 + (categoryColumnWidth / 2 + Constants.DECK_EDITOR_ICONS_WIDTH[6 + CardSet.CARD_LIST[this.upgradableCards[i]].getCardType()] / 2) + (cardsPriceWidth / 2 - Constants.DECK_EDITOR_ICONS_WIDTH[5] / 2);
            PSCanvas.fontEngine.drawFont(this.g, 1, "" + CardSet.CARD_LIST[this.upgradableCards[i]].getPointsPrice(), this.x, this.y + (elementHeight / 2 + 1), 35);
            this.y += elementHeight;
        }
        if (this.offsetCardList * 4 + 4 - limit < 4) {
            this.y += (this.offsetCardList * 4 + 4 - limit) * elementHeight;
        }
        this.x = 0;
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.x += categoryColumnWidth;
        this.g.drawLine(this.x, this.y + 1, this.x, this.y + elementHeight - 1);
        this.x = 176 - categoryColumnWidth - 1;
        this.g.drawLine(this.x, this.y + 1, this.x, this.y + elementHeight - 1);
        this.x = categoryColumnWidth / 2 - 2;
        for (i = 1; i <= 4; ++i) {
            this.g.fillRect(this.x + 4 - i - 1, this.y + (elementHeight / 2 - 2) + (i - 1), 2 * i - 1, 1);
        }
        this.x = 176 - categoryColumnWidth / 2 - 2;
        for (i = 4; i > 0; --i) {
            this.g.fillRect(this.x + 2 - i, this.y + (elementHeight / 2 + 2) - (i - 1), 2 * i - 1, 1);
        }
        PSCanvas.fontEngine.drawFont(this.g, 1, this.offsetCardList + 1 + "/" + this.pagesUpgradableNumber, 88, this.y + elementHeight / 2, 41);
        this.x = 0;
        this.y += elementHeight;
        this.g.drawLine(this.x, this.y, 176, this.y);
        this.g.drawLine(this.x, this.y + PSCanvas.imageHeight[43], 176, this.y + PSCanvas.imageHeight[43]);
        this.x += 2;
        this.g.setClip(0, 0, 176, 208);
        this.g.setStrokeStyle(PSGraphics.DOTED);
        for (i = 0; i < 6; ++i) {
            this.g.drawLine(this.x + i * (8 + categoryColumnWidth + costColumnWidth), this.y, this.x + i * (8 + categoryColumnWidth + costColumnWidth), this.y + PSCanvas.imageHeight[43]);
        }
        this.x += 2;
        for (i = 0; i < 5; ++i) {
            this.g.setClip(this.x + i * (8 + categoryColumnWidth + costColumnWidth), this.y + (PSCanvas.imageHeight[43] / 2 - 6), Constants.DECK_EDITOR_ICONS_WIDTH[6 + i], 12);
            this.g.drawImage(PSCanvas.imageArray[53], this.x + i * (8 + categoryColumnWidth + costColumnWidth) - Constants.DECK_EDITOR_ICONS_OFFSET[6 + i], this.y + (PSCanvas.imageHeight[43] / 2 - 6));
            PSCanvas.fontEngine.drawFont(this.g, 1, (this.cardsInDeckCount[i] < 10 ? "0" : "") + this.cardsInDeckCount[i], this.x + i * (8 + categoryColumnWidth + costColumnWidth) + categoryColumnWidth + costColumnWidth, this.y + (PSCanvas.imageHeight[43] / 2 - PSCanvas.fontEngine.getFontHeight(1) / 2), 58, 21);
        }
        this.y += PSCanvas.imageHeight[43];
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.g.setClip(0, 0, 176, 208);
        this.g.drawLine(88, this.y, 88, 208);
        this.x = 44 - this.cardBigWidth / 2;
        this.y += 3;
        this.displayCard(this.upgradableCards[this.selectedCard], this.x, this.y);
        PSCanvas.fontEngine.setSpacing(1);
        String cardDescription = PSCanvas.textArray[CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardDescription()];
        if (CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardUsageType() == 2) {
            cardDescription = PSCanvas.textArray[500] + ":" + CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardReactionChance() + "%|" + cardDescription;
        }
        if (CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardUsageType() == 1 && CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardType() == 0) {
            cardDescription = PSCanvas.textArray[498] + ":" + CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardAttackDamage() + (CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getAttacksNumber() > 1 ? " x " + CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getAttacksNumber() : "") + "|" + PSCanvas.textArray[499] + ":" + CardSet.CARD_LIST[this.upgradableCards[this.selectedCard]].getCardHitChance() + "%|" + cardDescription;
        }
        this.x = 90;
        PSCanvas.fontEngine.drawFont(this.g, 1, cardDescription.toUpperCase(), this.x, this.y, 82, 18);
    }

    private void upgradeSelectedCard(int cardId) {
        int upgradedCardId = CardSet.CARD_LIST[cardId].getUpgradedCardId();
        int upgradedCard = 0;
        for (int i = 0; i < CardSet.CARD_LIST.length; ++i) {
            if (CardSet.CARD_LIST[i].getCardID() != upgradedCardId) continue;
            upgradedCard = i;
            break;
        }
        CardSet.CARD_LIST[upgradedCard].setUnlock();
        CardSet.CARD_LIST[upgradedCard].setCardsOwnAmount(CardSet.CARD_LIST[upgradedCard].getCardsOwnAmount() + 1);
        if (CardSet.CARD_LIST[cardId].getCardsOwnAmount() == CardSet.CARD_LIST[cardId].getCardsInDeckAmount()) {
            CardSet.CARD_LIST[cardId].setCardsInDeckAmount(CardSet.CARD_LIST[cardId].getCardsInDeckAmount() - 1);
        }
        if (CardSet.CARD_LIST[cardId].getCardsOwnAmount() <= 1) {
            CardSet.CARD_LIST[cardId].setLock();
        }
        CardSet.CARD_LIST[cardId].setCardsOwnAmount(CardSet.CARD_LIST[cardId].getCardsOwnAmount() - 1);
        PSCanvas.gamePoints -= CardSet.CARD_LIST[cardId].getPointsPrice();
        this.messageText = 503;
        this.isCardUpgraded = true;
        this.prepareUpgradableCards();
        this.stateDeckEditor = 4;
    }

    private int checkCardsInDeckNumber() {
        int cardsNumber = 0;
        for (int i = 0; i < this.cardsInDeckCount.length; ++i) {
            cardsNumber += this.cardsInDeckCount[i];
        }
        return cardsNumber;
    }

    public boolean isCardUpgraded() {
        return this.isCardUpgraded;
    }
}

