/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class PSFontEngine {
    private static final StringBuffer CHARSET = new StringBuffer().append("!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}").append("\u00c0").append("\u00c1").append("\u00c2").append("\u00c3").append("\u00c4").append("\u00c6").append("\u00c7").append("\u00c8").append("\u00c9").append("\u00ca").append("\u00cb").append("\u00cc").append("\u00cd").append("\u00ce").append("\u00cf").append("\u00d0").append("\u00d1").append("\u00d2").append("\u00d3").append("\u00d4").append("\u00d5").append("\u00d6").append("\u00d9").append("\u00da").append("\u00db").append("\u00dc").append("\u00df").append("\u00a1").append("\u00bf").append("\u00e0").append("\u00e1").append("\u00e2").append("\u00e3").append("\u00e4").append("\u00e6").append("\u00e7").append("\u00e8").append("\u00e9").append("\u00ea").append("\u00eb").append("\u00ec").append("\u00ed").append("\u00ec").append("\u00ed").append("\u00ee").append("\u00ef").append("\u00f0").append("\u00f1").append("\u00f2").append("\u00f3").append("\u00f4").append("\u00f5").append("\u00f6").append("\u00f9").append("\u00fa").append("\u00fb").append("\u00fc");
    private static final String CHARSET_STRING = CHARSET.toString();
    private int screenWidth;
    private int textDrawWidth;
    private int fontsCount;
    private Image[] fontImage;
    private int[] fontHeight;
    private int[][] fontLetterWidths;
    private int indexCurrentFont;
    private int characterSpacing;
    private PSGraphics fontG;
    private char characterLinebreak = (char)124;
    private char characterPagebreak = (char)94;
    private char characterSpace = (char)95;
    private int wordMaxLength = 10;
    public static final int NOWRAP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 8;
    public static final int TOP = 16;
    public static final int VCENTER = 32;
    public static final int BOTTOM = 64;
    public static final int AXIS_CENTER = 128;

    public PSFontEngine(int screenWidthRestriction, int numberFonts) {
        this.screenWidth = screenWidthRestriction;
        this.textDrawWidth = screenWidthRestriction;
        this.fontsCount = numberFonts;
        this.fontImage = new Image[numberFonts];
        this.fontHeight = new int[numberFonts];
        this.fontLetterWidths = new int[numberFonts][];
        this.characterSpacing = 0;
    }

    public boolean addFont(int index, String resource, int[] widths, int height) {
        if (index >= this.fontsCount) {
            return false;
        }
        this.fontImage[index] = null;
        try {
            this.fontImage[index] = Image.createImage((String)("/" + resource + ".png"));
        }
        catch (IOException ex) {
            return false;
        }
        this.fontLetterWidths[index] = widths;
        this.fontHeight[index] = height;
        return true;
    }

    public boolean removeFont(int index) {
        if (this.fontImage[index] == null) {
            return false;
        }
        this.fontImage[index] = null;
        this.fontLetterWidths[index] = null;
        this.fontHeight[index] = 0;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public boolean setCurrentFont(int index) {
        this.indexCurrentFont = index;
        return true;
    }

    public int getCurrentFont() {
        return this.indexCurrentFont;
    }

    public int getFontHeight(int index) {
        return this.fontHeight[index];
    }

    public int getCurrentFontHeight() {
        return this.getFontHeight(this.indexCurrentFont);
    }

    public void setPSGraphics(PSGraphics g) {
        this.fontG = g;
    }

    public void drawFont(PSGraphics g, int index, String text, int x, int y, int width, int align) {
        int charSpacing = this.characterSpacing;
        int textCharactersLength = 0;
        int letterWidth = -1;
        int dx = x;
        int dy = y;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int indexChar = 0;
        int textWidth = 0;
        boolean isSpace = false;
        int backupTextDrawWidth = this.textDrawWidth;
        textWidth = this.getTextMaxLineWidth(index, text, 0, width);
        if ((align & 8) != 0) {
            if (width != this.textDrawWidth) {
                this.textDrawWidth = textWidth;
            }
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.textDrawWidth);
                dx -= textWidth >> 1;
            } else {
                dx -= this.getTextLength(index, text) >> 1;
            }
        } else if ((align & 0x80) != 0) {
            if (width != this.textDrawWidth) {
                this.textDrawWidth = textWidth;
            }
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.textDrawWidth);
                dx -= this.getTextLineWidth(index, text, 0, this.textDrawWidth) >> 1;
            } else {
                dx -= this.getTextLineWidth(index, text, 0, this.textDrawWidth) >> 1;
            }
        } else if ((align & 4) != 0) {
            this.textDrawWidth = width != this.textDrawWidth ? textWidth : x;
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.textDrawWidth);
                dx -= this.getTextLineWidth(index, text, 0, this.textDrawWidth);
            } else {
                dx -= this.getTextLength(index, text);
            }
        } else {
            this.textDrawWidth = width != this.textDrawWidth ? width : (this.textDrawWidth -= x);
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.textDrawWidth);
            }
        }
        if ((align & 1) == 0) {
            if ((align & 0x20) != 0) {
                dy -= this.getTextHeight(index, text, this.textDrawWidth) / 2;
            } else if ((align & 0x40) != 0) {
                dy -= this.getTextHeight(index, text, this.textDrawWidth);
            }
        } else if ((align & 0x20) != 0) {
            dy -= this.fontHeight[index] / 2;
        } else if ((align & 0x40) != 0) {
            dy -= this.fontHeight[index];
        }
        textCharactersLength = text.length();
        for (int i = 0; i < textCharactersLength; ++i) {
            char character = text.charAt(i);
            if (character == this.characterLinebreak) {
                if ((align & 8) != 0) {
                    dx = x;
                    dx -= textWidth >> 1;
                    dy += this.fontHeight[index];
                    continue;
                }
                if ((align & 0x80) != 0) {
                    dx = x;
                    dx -= this.getTextLineWidth(index, text, i + 1, this.textDrawWidth) >> 1;
                    dy += this.fontHeight[index];
                    continue;
                }
                if ((align & 4) != 0) {
                    dx = x;
                    dx -= this.getTextLineWidth(index, text, i + 1, this.textDrawWidth);
                    dy += this.fontHeight[index];
                    continue;
                }
                if ((align & 2) == 0) continue;
                dx = x;
                dy += this.fontHeight[index];
                continue;
            }
            if (character == ' ') {
                isSpace = true;
                indexChar = this.getCharIndex(this.characterSpace);
            } else {
                indexChar = this.getCharIndex(character);
                isSpace = false;
            }
            letterWidth = this.fontLetterWidths[index][indexChar];
            if (letterWidth < 0) continue;
            int letterPosX = this.getCharPosX(index, indexChar);
            int letterPosY = this.getCharPosY(index, indexChar);
            g.setClip(dx, dy, letterWidth, this.fontHeight[index]);
            if (!isSpace) {
                g.drawImage(this.fontImage[index], dx - letterPosX, dy - letterPosY, 20);
            }
            dx += letterWidth + charSpacing;
        }
        this.textDrawWidth = backupTextDrawWidth;
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public void drawFont(PSGraphics g, int index, String text, int x, int y, int align) {
        this.drawFont(g, index, text, x, y, this.textDrawWidth, align);
    }

    public void drawFont(int index, String text, int x, int y, int width, int align) {
        this.drawFont(this.fontG, index, text, x, y, width, align);
    }

    public void drawFont(int index, String text, int x, int y, int align) {
        this.drawFont(this.fontG, index, text, x, y, this.textDrawWidth, align);
    }

    public void drawCurrentFont(String text, int x, int y, int width, int align) {
        this.drawFont(this.fontG, this.indexCurrentFont, text, x, y, width, align);
    }

    public void drawCurrentFont(String text, int x, int y, int align) {
        this.drawFont(this.fontG, this.indexCurrentFont, text, x, y, this.textDrawWidth, align);
    }

    public void drawCurrentFont(PSGraphics g, String text, int x, int y, int width, int align) {
        this.drawFont(g, this.indexCurrentFont, text, x, y, width, align);
    }

    public void drawCurrentFont(PSGraphics g, String text, int x, int y, int align) {
        this.drawFont(g, this.indexCurrentFont, text, x, y, this.textDrawWidth, align);
    }

    public String[] wrapTextPages(int index, String text, int width, int lines) {
        int i;
        int charSpacing = this.characterSpacing;
        int textLength = 0;
        int letterWidth = -1;
        int indexChar = -1;
        int textCharactersLength = text.length();
        int wordLength = -1;
        int spaceCharacterLength = this.fontLetterWidths[index][this.getCharIndex(this.characterSpace)] + charSpacing;
        int separatorCharacterLength = this.fontLetterWidths[index][this.getCharIndex('-')] + charSpacing;
        String wordBuffer = new String();
        StringBuffer wrapedText = new StringBuffer("");
        int lineCount = 0;
        int countPages = 1;
        int indexPagebreakDown = 0;
        int indexPagebreakTop = -1;
        String secondWordBuffer = "";
        int secondWordBufferWidth = 0;
        int wordOffset = 0;
        int secondBufferIndex = 0;
        boolean canRefreshBuffer = true;
        wrapedText.setLength(0);
        for (i = 0; i < textCharactersLength; ++i) {
            char character = text.charAt(i);
            if (character != this.characterLinebreak) {
                indexChar = character == ' ' ? this.getCharIndex(this.characterSpace) : this.getCharIndex(character);
                letterWidth = this.fontLetterWidths[index][indexChar] + charSpacing;
            }
            if (character == this.characterLinebreak) {
                canRefreshBuffer = true;
                if (textLength + wordLength - spaceCharacterLength - charSpacing >= width) {
                    wrapedText.append(this.characterLinebreak);
                    if (++lineCount == lines) {
                        lineCount = 0;
                        ++countPages;
                        if (wrapedText.charAt(wrapedText.length() - 1) == this.characterLinebreak) {
                            wrapedText.setCharAt(wrapedText.length() - 1, this.characterPagebreak);
                        } else {
                            wrapedText.append(this.characterPagebreak);
                        }
                    }
                }
                wrapedText.append(wordBuffer);
                textLength = 0;
                wordLength = spaceCharacterLength;
                wordBuffer = "";
                if (++lineCount == lines) {
                    lineCount = 0;
                    ++countPages;
                    if (wrapedText.charAt(wrapedText.length() - 1) == this.characterLinebreak) {
                        wrapedText.setCharAt(wrapedText.length() - 1, this.characterPagebreak);
                    } else {
                        wrapedText.append(this.characterPagebreak);
                    }
                }
            } else if (textLength + wordLength - spaceCharacterLength - charSpacing >= width && character == ' ') {
                canRefreshBuffer = true;
                textLength = 0;
                try {
                    if (++lineCount == lines) {
                        lineCount = 0;
                        ++countPages;
                        if (wrapedText.charAt(wrapedText.length() - 1) == ' ') {
                            wrapedText.setCharAt(wrapedText.length() - 1, this.characterPagebreak);
                        } else {
                            wrapedText.append(this.characterPagebreak);
                        }
                    } else if (wrapedText.charAt(wrapedText.length() - 1) == ' ') {
                        wrapedText.setCharAt(wrapedText.length() - 1, this.characterLinebreak);
                    } else {
                        wrapedText.append(this.characterLinebreak);
                    }
                }
                catch (StringIndexOutOfBoundsException ex) {
                    System.out.println("PSFontEngine Error:");
                    System.out.println("One of the words is longer then drawing region width ! In String :");
                    System.out.println(text);
                }
            }
            if (character == ' ' && character != this.characterLinebreak) {
                textLength += wordLength;
                wordLength = spaceCharacterLength;
                wrapedText.append(wordBuffer + ' ');
                wordBuffer = "";
                wordOffset = i + 1;
                canRefreshBuffer = true;
                continue;
            }
            wordLength += letterWidth;
            wordBuffer = wordBuffer + character;
            if (canRefreshBuffer) {
                secondWordBufferWidth = 0;
                secondBufferIndex = wordOffset;
                secondWordBuffer = "";
            }
            if (secondBufferIndex >= text.length()) continue;
            char secondBufferCharacter = text.charAt(secondBufferIndex);
            while (secondBufferCharacter != ' ' && secondBufferCharacter != this.characterLinebreak && secondBufferIndex != text.length() - 1 && canRefreshBuffer) {
                secondWordBuffer = secondWordBuffer + "" + secondBufferCharacter;
                secondWordBufferWidth += this.fontLetterWidths[index][this.getCharIndex(secondBufferCharacter)] + charSpacing;
                secondBufferCharacter = text.charAt(++secondBufferIndex);
            }
            canRefreshBuffer = false;
            secondBufferCharacter = ' ';
            secondBufferIndex = 0;
            if (textLength + wordLength + 2 * separatorCharacterLength < width || textLength + wordLength >= width || secondWordBuffer.length() < this.wordMaxLength || textLength + secondWordBufferWidth < width || textLength + 2 * separatorCharacterLength > width || wordBuffer.length() < 4 || wordBuffer.length() - 1 >= secondWordBuffer.length() - 4) continue;
            canRefreshBuffer = true;
            textLength = 0;
            wordLength = spaceCharacterLength;
            wrapedText.append(wordBuffer + '-' + this.characterLinebreak);
            wordBuffer = "";
            if (++lineCount != lines) continue;
            lineCount = 0;
            ++countPages;
            if (wrapedText.charAt(wrapedText.length() - 1) == this.characterLinebreak) {
                wrapedText.setCharAt(wrapedText.length() - 1, this.characterPagebreak);
                continue;
            }
            wrapedText.append(this.characterPagebreak);
        }
        if (textLength + wordLength <= width) {
            wrapedText.append(wordBuffer);
            wordBuffer = "";
        } else {
            char lastChar;
            int wrapedTextLength = wrapedText.length();
            if (wrapedTextLength != 0 && ((lastChar = wrapedText.charAt(wrapedTextLength - 1)) == ' ' || lastChar == this.characterLinebreak)) {
                wrapedText.deleteCharAt(wrapedTextLength - 1);
            }
            if (wordBuffer.indexOf(this.characterLinebreak) == -1) {
                if (++lineCount == lines) {
                    lineCount = 0;
                    ++countPages;
                    wrapedText.append(this.characterPagebreak + wordBuffer);
                } else {
                    wrapedText.append(this.characterLinebreak + wordBuffer);
                }
            } else {
                wrapedText.append(wordBuffer);
            }
            wordBuffer = "";
        }
        String[] textPages = new String[countPages];
        wordBuffer = wrapedText.toString();
        for (i = 0; i < countPages; ++i) {
            indexPagebreakTop = wordBuffer.indexOf(this.characterPagebreak, indexPagebreakDown);
            textPages[i] = indexPagebreakTop == -1 ? wordBuffer.substring(indexPagebreakDown) : wordBuffer.substring(indexPagebreakDown, indexPagebreakTop).replace(this.characterPagebreak, ' ');
            indexPagebreakDown = indexPagebreakTop + 1;
            if (textPages[i].charAt(0) != this.characterLinebreak) continue;
            textPages[i] = textPages[i].substring(1);
        }
        return textPages;
    }

    public String wrapText(int index, String text, int width) {
        int charSpacing = this.characterSpacing;
        int textLength = 0;
        int letterWidth = -1;
        int indexChar = -1;
        int textCharactersLength = text.length();
        int wordLength = -1;
        int spaceCharacterLength = this.fontLetterWidths[index][this.getCharIndex(this.characterSpace)] + charSpacing;
        int separatorCharacterLength = this.fontLetterWidths[index][this.getCharIndex('-')] + charSpacing;
        String wordBuffer = new String();
        StringBuffer wrapedText = new StringBuffer("");
        String secondWordBuffer = "";
        int secondWordBufferWidth = 0;
        int wordOffset = 0;
        int secondBufferIndex = 0;
        boolean canRefreshBuffer = true;
        wrapedText.setLength(0);
        for (int i = 0; i < textCharactersLength; ++i) {
            char character = text.charAt(i);
            if (character != this.characterLinebreak) {
                indexChar = character == ' ' ? this.getCharIndex(this.characterSpace) : this.getCharIndex(character);
                letterWidth = this.fontLetterWidths[index][indexChar] + charSpacing;
            }
            if (character == this.characterLinebreak) {
                canRefreshBuffer = true;
                textLength = 0;
                wordLength = 0;
                if (textLength + wordLength - spaceCharacterLength - charSpacing >= width) {
                    wrapedText.append(this.characterLinebreak);
                }
                wrapedText.append(wordBuffer);
                textLength = 0;
                wordLength = spaceCharacterLength;
                wordBuffer = "";
            } else if (textLength + wordLength - spaceCharacterLength - charSpacing >= width && character == ' ') {
                canRefreshBuffer = true;
                textLength = 0;
                try {
                    if (wrapedText.length() != 0) {
                        if (wrapedText.charAt(wrapedText.length() - 1) == ' ') {
                            wrapedText.setCharAt(wrapedText.length() - 1, this.characterLinebreak);
                        } else {
                            wrapedText.append(this.characterLinebreak);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException ex) {
                    System.out.println("PSFontEngine Error:");
                    System.out.println("One of the words is longer then drawing region width ! In String :");
                    System.out.println(text);
                }
            }
            if (character == ' ' && character != this.characterLinebreak) {
                wordOffset = i + 1;
                textLength += wordLength;
                wordLength = spaceCharacterLength;
                wrapedText.append(wordBuffer + ' ');
                wordBuffer = "";
                canRefreshBuffer = true;
                continue;
            }
            wordLength += letterWidth;
            wordBuffer = wordBuffer + character;
            if (canRefreshBuffer) {
                secondWordBuffer = "";
                secondWordBufferWidth = 0;
                secondBufferIndex = wordOffset;
            }
            if (secondBufferIndex >= text.length()) continue;
            char secondBufferCharacter = text.charAt(secondBufferIndex);
            while (secondBufferCharacter != ' ' && secondBufferCharacter != this.characterLinebreak && secondBufferIndex != text.length() - 1 && canRefreshBuffer) {
                secondWordBuffer = secondWordBuffer + "" + secondBufferCharacter;
                secondWordBufferWidth += this.fontLetterWidths[index][this.getCharIndex(secondBufferCharacter)] + charSpacing;
                secondBufferCharacter = text.charAt(++secondBufferIndex);
            }
            canRefreshBuffer = false;
            secondBufferCharacter = ' ';
            secondBufferIndex = 0;
            if (textLength + wordLength + 2 * separatorCharacterLength <= width || secondWordBuffer.length() < this.wordMaxLength || textLength + secondWordBufferWidth < width || textLength + 2 * separatorCharacterLength > width) continue;
            canRefreshBuffer = true;
            textLength = 0;
            wordLength = spaceCharacterLength;
            wrapedText.append(wordBuffer + '-' + this.characterLinebreak);
            wordBuffer = "";
        }
        if (textLength + wordLength - charSpacing <= width) {
            wrapedText.append(wordBuffer);
            wordBuffer = "";
        } else {
            char lastChar;
            int wrapedTextLength = wrapedText.length();
            if (wrapedTextLength != 0 && ((lastChar = text.charAt(wrapedTextLength - 1)) == ' ' || lastChar == this.characterLinebreak)) {
                wrapedText.deleteCharAt(wrapedTextLength - 1);
            }
            if (wordBuffer.indexOf(this.characterLinebreak) == -1) {
                wrapedText.append(this.characterLinebreak + wordBuffer);
            } else {
                wrapedText.append(wordBuffer);
            }
            wordBuffer = "";
        }
        return wrapedText.toString();
    }

    public String wrapText(int index, String text) {
        return this.wrapText(index, text, this.textDrawWidth);
    }

    public String wrapTextCurrentFont(String text, int width) {
        return this.wrapText(this.indexCurrentFont, text, width);
    }

    public String wrapTextCurrentFont(String text) {
        return this.wrapText(this.indexCurrentFont, text, this.textDrawWidth);
    }

    public int getFixedTextHeight(int index, String text) {
        int height = 0;
        int linebreakPosition = 0;
        while (linebreakPosition != -1) {
            ++height;
            if ((linebreakPosition = text.indexOf(this.characterLinebreak, linebreakPosition)) == -1) continue;
            ++linebreakPosition;
        }
        return height * this.fontHeight[index];
    }

    public int getCurrentFontFixedTextHeight(int index, String text) {
        return this.getFixedTextHeight(this.indexCurrentFont, text);
    }

    public int getTextHeight(int index, String text, int width) {
        int charSpacing = this.characterSpacing;
        int textHeight = 0;
        int wholeTextLength = this.getTextLength(index, text);
        int textCharactersLength = text.length();
        int indexChar = -1;
        int wordLength = -1;
        int currentTextLineLength = -1;
        int spaceCharacterLength = this.fontLetterWidths[index][this.getCharIndex(this.characterSpace)] + charSpacing;
        int letterWidth = -1;
        if (wholeTextLength <= width && text.indexOf("" + this.characterLinebreak) == -1) {
            textHeight = this.fontHeight[index];
        } else {
            ++textHeight;
            for (int i = 0; i < textCharactersLength; ++i) {
                char character = text.charAt(i);
                if (currentTextLineLength + wordLength <= width) {
                    if (character == this.characterLinebreak) continue;
                    indexChar = character == ' ' ? this.getCharIndex(this.characterSpace) : this.getCharIndex(character);
                    letterWidth = this.fontLetterWidths[index][indexChar] + charSpacing;
                } else {
                    ++textHeight;
                    currentTextLineLength = 0;
                    wordLength -= spaceCharacterLength;
                }
                if (character == ' ') {
                    currentTextLineLength += wordLength;
                    wordLength = spaceCharacterLength;
                    continue;
                }
                wordLength += letterWidth;
            }
            if (currentTextLineLength + wordLength > width) {
                ++textHeight;
            }
            textHeight *= this.fontHeight[index];
        }
        return textHeight;
    }

    public int getTextHeight(int index, String text) {
        return this.getTextHeight(index, text, this.textDrawWidth);
    }

    public int getCurrentFontTextHeight(String text) {
        return this.getTextHeight(this.indexCurrentFont, text, this.textDrawWidth);
    }

    public int getTextLength(int index, String text) {
        int textCharactersLength = text.length();
        char character = '\u0000';
        int textFontLength = 0;
        int indexChar = 0;
        int charSpacing = this.characterSpacing;
        for (int i = 0; i < textCharactersLength; ++i) {
            character = text.charAt(i);
            if (character == this.characterLinebreak) continue;
            indexChar = character == ' ' ? this.getCharIndex(this.characterSpace) : this.getCharIndex(character);
            textFontLength += this.fontLetterWidths[index][indexChar] + charSpacing;
        }
        return textFontLength;
    }

    public int getCurrentFontTextLength(String text) {
        return this.getTextLength(this.indexCurrentFont, text);
    }

    public int getTextLineWidth(int index, String text, int offset, int width) {
        int charSpacing = this.characterSpacing;
        int textLineLength = 0;
        int wholeTextLength = this.getTextLength(index, text);
        int textCharactersLength = text.length();
        int indexChar = -1;
        int wordLength = -1;
        int currentTextLineLength = -1;
        int spaceCharacterLength = this.fontLetterWidths[index][this.getCharIndex(this.characterSpace)] + charSpacing;
        int letterWidth = -1;
        int lastSpacePosition = -1;
        boolean isSpace = false;
        if (wholeTextLength - charSpacing <= width && text.indexOf("" + this.characterLinebreak) == -1) {
            textLineLength = wholeTextLength - charSpacing;
            lastSpacePosition = textCharactersLength - 1;
            while (text.charAt(lastSpacePosition--) == ' ') {
                textLineLength -= spaceCharacterLength;
            }
        } else {
            char character;
            for (int i = offset; i < textCharactersLength && (character = text.charAt(i)) != this.characterLinebreak && textLineLength + wordLength - charSpacing <= width; ++i) {
                indexChar = character == ' ' ? this.getCharIndex(this.characterSpace) : this.getCharIndex(character);
                letterWidth = this.fontLetterWidths[index][indexChar] + charSpacing;
                if (character == ' ') {
                    textLineLength += wordLength;
                    wordLength = spaceCharacterLength;
                    lastSpacePosition = i;
                    isSpace = true;
                    continue;
                }
                wordLength += letterWidth;
                isSpace = false;
            }
            if (isSpace) {
                while (text.charAt(lastSpacePosition--) == ' ') {
                    textLineLength -= spaceCharacterLength;
                }
            }
            textLineLength += wordLength;
        }
        return textLineLength;
    }

    public int getTextLineWidth(int index, String text, int offset) {
        return this.getTextLineWidth(index, text, offset, this.textDrawWidth);
    }

    public int getCurrentFontTextLineWidth(String text, int offset, int width) {
        return this.getTextLineWidth(this.indexCurrentFont, text, offset, width);
    }

    public int getCurrentFontTextLineWidth(String text, int offset) {
        return this.getTextLineWidth(this.indexCurrentFont, text, offset, this.textDrawWidth);
    }

    public int getTextLineWidth(int index, String text) {
        return this.getTextLineWidth(index, text, 0, this.textDrawWidth);
    }

    public int getCurrentFontTextLineWidth(String text) {
        return this.getTextLineWidth(this.indexCurrentFont, text, 0, this.textDrawWidth);
    }

    public int getTextMaxLineWidth(int index, String text, int offset, int width) {
        int charSpacing = this.characterSpacing;
        int textLineLength = 0;
        int wholeTextLength = this.getTextLength(index, text);
        int textCharactersLength = text.length();
        int indexChar = -1;
        int wordLength = 0;
        int currentTextLineLength = -1;
        int spaceCharacterLength = this.fontLetterWidths[index][this.getCharIndex(this.characterSpace)] + charSpacing;
        int letterWidth = -1;
        int longestTextLine = 0;
        if (wholeTextLength - charSpacing <= width && text.indexOf("" + this.characterLinebreak) == -1) {
            longestTextLine = wholeTextLength - charSpacing;
        } else {
            for (int i = offset; i < textCharactersLength; ++i) {
                char character = text.charAt(i);
                if (character == this.characterLinebreak) continue;
                if (textLineLength + wordLength - charSpacing <= width) {
                    indexChar = character == ' ' ? this.getCharIndex(this.characterSpace) : this.getCharIndex(character);
                    letterWidth = this.fontLetterWidths[index][indexChar] + charSpacing;
                } else {
                    if (textLineLength - charSpacing >= longestTextLine) {
                        longestTextLine = textLineLength;
                    }
                    textLineLength = 0;
                    wordLength -= spaceCharacterLength;
                }
                if (character == ' ') {
                    textLineLength += wordLength;
                    wordLength = spaceCharacterLength;
                    continue;
                }
                wordLength += letterWidth;
            }
            if (textLineLength + wordLength - charSpacing <= width) {
                if (textLineLength + wordLength - charSpacing >= longestTextLine) {
                    longestTextLine = textLineLength + wordLength;
                }
            } else if (textLineLength - charSpacing >= longestTextLine) {
                longestTextLine = textLineLength;
            }
            longestTextLine -= charSpacing;
        }
        return longestTextLine;
    }

    public int getCurrentFontTextMaxLineWidth(String text, int offset, int width) {
        return this.getTextMaxLineWidth(this.indexCurrentFont, text, offset, width);
    }

    public int getTextMaxLineWidth(int index, String text, int width) {
        return this.getTextMaxLineWidth(index, text, 0, width);
    }

    public int getTextMaxLineWidth(int index, String text) {
        return this.getTextMaxLineWidth(index, text, 0, this.textDrawWidth);
    }

    public int getCurrentFontTextMaxLineWidth(String text, int width) {
        return this.getTextMaxLineWidth(this.indexCurrentFont, text, 0, width);
    }

    public int getCurrentFontTextMaxLineWidth(String text) {
        return this.getTextMaxLineWidth(this.indexCurrentFont, text, 0, this.textDrawWidth);
    }

    private int getCharIndex(char character) {
        return CHARSET_STRING.indexOf(character);
    }

    private int getCharPosX(int indexFont, int indexCharacter) {
        int charPosX = 0;
        for (int i = this.getFontImagetLinebreak(this.getFontImageLineNumber(indexFont)); i < indexCharacter; ++i) {
            charPosX += this.fontLetterWidths[indexFont][i];
        }
        return charPosX;
    }

    private int getCharPosY(int indexFont, int indexCharacter) {
        return this.fontHeight[indexFont] * this.getFontImageLineNumber(indexCharacter);
    }

    private int getFontImageLineNumber(int indexCharacter) {
        int characterLinePosition = 0;
        if (indexCharacter <= 93) {
            characterLinePosition = 0;
        }
        return characterLinePosition;
    }

    private int getFontImagetLinebreak(int characterLinePosition) {
        int characterLinebreakPosition = 0;
        switch (characterLinePosition) {
            case 0: {
                characterLinebreakPosition = 0;
            }
        }
        return characterLinebreakPosition;
    }

    private boolean isFontAdded(int index) {
        return this.fontImage[index] != null;
    }

    public void setSpacing(int space) {
        this.characterSpacing = space;
    }

    public int getSpacing() {
        return this.characterSpacing;
    }

    public void resetSpacing() {
        this.characterSpacing = 0;
    }

    public void setDrawWidth(int width) {
        this.textDrawWidth = width;
    }

    public void resetDrawWidth() {
        this.textDrawWidth = this.screenWidth;
    }

    public int getDrawWidth() {
        return this.textDrawWidth;
    }

    public void setLinebreak(char linebreak) {
        this.characterLinebreak = linebreak;
    }

    public void resetLinebreak() {
        this.characterLinebreak = (char)124;
    }

    public char getLinebreak() {
        return this.characterLinebreak;
    }

    public void setPagebreak(char pagebreak) {
        this.characterPagebreak = pagebreak;
    }

    public void resetPagebreak() {
        this.characterPagebreak = (char)94;
    }

    public char getPagebreak() {
        return this.characterPagebreak;
    }

    public void setSpace(char space) {
        this.characterSpace = space;
    }

    public void resetSpace() {
        this.characterSpace = (char)95;
    }

    public char getSpace() {
        return this.characterSpace;
    }
}

