/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class GameBoardHud
implements Constants,
PSText {
    private PSGraphics g;
    public static int[] ingameMenuArray = null;
    public static int[] ingameSubMenuArray = null;
    public static int[] ingameMenuArrayText = null;
    public static int[] ingameSubMenuArrayText = null;
    public static int[] ingameCardMenuArray = null;
    public static int[] ingameCardMenuArrayText = null;
    private int menuX = 8;
    private int menuY = 26;
    private int menuStepX = 0;
    private int ingameMenuSelectedOption = 0;
    private int ingameSubMenuSelectedOption = 0;
    private int ingameMenuCurrentState = -1;
    private boolean isSubMenu = false;
    public boolean isEndMenu = false;
    private Integer[] snakeHand;
    private int snakeSelectedCard = -1;
    private boolean canDisplayCards = false;
    private int lastSelectedCard = -1;
    private int[][] playerStatusArray;
    public boolean isAttack = false;
    private int ingameStates = 0;
    private int ingameLastState = 0;
    private int cardMoveX = 0;
    private int cardMoveY = 0;
    private int freeCamMoveX = 0;
    private int freeCamMoveY = 0;
    private int freeCamStepY = 0;
    private int freeCamX = 0;
    private int freeCamY = 0;
    private boolean isMoveLeft = false;
    private boolean isMoveRight = false;
    private boolean blockKeyPress = false;
    private int cardIconSmallWidth = 0;
    private int cardSmallWidth = 0;
    private int cardIconBigWidth = 0;
    private int cardBigWidth = 0;
    private int cardIconSmallHeight = 0;
    private int cardSmallHeight = 0;
    private int cardIconBigHeight = 0;
    private int cardBigHeight = 0;
    private Vector dialogs;
    private int dialogDisplayIndex = 0;
    private boolean isDialogOver = true;
    private boolean isDialogChanged = true;
    private int dialogWidth = 0;
    private int dialogHeight = 0;
    private int menuColor = 255;
    private boolean isMenuReady = false;
    private int selectedCardPosX = 0;
    private int cardStepX = 0;
    private int miniCardStartPosY;
    private int miniCardStepY;
    private boolean isSnakeCrawled = false;
    private boolean isSnakeFlattened = false;
    private boolean canSnakePunch = false;
    private int snakeMoveNumberLeft = 0;
    private int snakeMoveNumber = 0;
    private int menuColorBarWidth = 0;
    private static boolean isCardsFadeIn = false;
    private static boolean isCardsFadeOut = false;
    private static boolean isFreeCamFadeIn = false;
    private static boolean isFreeCamFadeOut = true;
    private int contextStatusOffsetY = 0;
    private int textMessageIndex;
    private int previewCost = 0;
    private int previewInitiative = 0;
    private boolean isPreviewCost = false;
    private int paintCount = 0;
    private int snakeEquipIndex = 0;
    private int[] snakeEquipment = new int[2];
    private boolean isEquipDisplay = false;
    private boolean hasSnakePunched = false;
    private boolean hasSnakeKnocked = false;
    private int resultCost = 0;
    private int resultKills = 0;
    private int resultAlarms = 0;
    private int resultPointsEarned = 0;
    private int resultGamePoints = 0;
    private int resultFound = 0;
    private int resultTotalToFind = 0;
    private int[] resultCards;
    private int resultOffset = 0;
    private String[] helpTextPages;
    private int helpPagesIndex = 0;
    private int helpCategoryIndex = 0;
    private boolean canSnakeCancelMove = true;
    private long cardDescStartTime = 0L;
    private long cardDescEndTime = 0L;
    private boolean isCardDescScrolling = false;
    private String[] cardDescriptionPages;
    private int cardDescPageIndex = 0;

    public GameBoardHud() {
        this.initCardsSize();
        this.initDialogSize();
        this.freeCamY = 208 - this.cardSmallHeight - 12 - 32;
    }

    public void setPreviewCost(int cost) {
        this.previewCost = cost;
        this.isPreviewCost = true;
    }

    public void resetPreviewCost() {
        this.isPreviewCost = false;
    }

    public void initDialogSize() {
        this.dialogWidth = 168;
        this.dialogHeight = 52;
    }

    public void createPlayersStatsArray(int number) {
        this.playerStatusArray = new int[1 + number][16];
    }

    private void updateCardTime() {
        if (this.cardDescStartTime == 0L) {
            this.cardDescStartTime = System.currentTimeMillis();
        }
        this.cardDescEndTime = System.currentTimeMillis();
        if (this.cardDescEndTime - this.cardDescStartTime > 2000L) {
            this.isCardDescScrolling = true;
        }
    }

    public void updateDisplayGameboardHud(PSGraphics gHud) {
        ++this.paintCount;
        if (this.paintCount == 8) {
            this.paintCount = 0;
        }
        this.g = gHud;
        this.g.setClip(0, 0, 176, 208);
        if (this.ingameStates == 22) {
            this.displayAiContextStatus();
            this.displaySnakeContextStatus();
        }
        this.displaySnakesCostTurn();
        this.displaySnakeStatus();
        if (this.isAttack && this.ingameStates == 11) {
            if (isCardsFadeOut) {
                this.displaySnakesCardsInHand();
            } else {
                this.displaySelectTarget();
            }
        }
        if (this.ingameStates == 14) {
            this.displayFreeCamIcon();
            this.displayConfirmationTurn();
        }
        if (this.ingameStates == 25) {
            this.displayMessage();
        }
        if (this.ingameStates == 8 || this.ingameStates == 24 || this.ingameStates == 9 || this.ingameStates == 10) {
            if (isCardsFadeOut) {
                this.displaySnakesCardsInHand();
            } else if (this.ingameStates == 24 || this.ingameStates == 9) {
                this.displayMessage();
            } else {
                this.displayMessageCard();
            }
            if (this.canDisplayCards && (this.ingameStates == 8 || this.ingameStates == 10)) {
                this.updateCardTime();
                this.displaySelectedCard();
            }
        }
        if (this.ingameStates == 22) {
            if (isCardsFadeOut && this.playerStatusArray[0][2] > 0) {
                this.displaySnakesCardsInHand();
            }
            this.displayFreeCamArrows();
        } else {
            if (this.ingameStates == 13) {
                this.displayFreeCamIcon();
                if (isCardsFadeOut) {
                    this.displaySnakesCardsInHand();
                }
            }
            if (this.ingameStates == 4) {
                this.displayMessageBar(PSCanvas.textArray[495] + " " + PSCanvas.textArray[528]);
            }
            if (this.isEndMenu) {
                if (this.ingameStates != 16) {
                    if (this.ingameLastState == 25) {
                        isCardsFadeOut = false;
                    }
                    this.displayFreeCamIcon();
                    if (isCardsFadeOut && this.playerStatusArray[0][2] > 0) {
                        this.displaySnakesCardsInHand();
                    }
                } else {
                    this.displayMessagePause();
                }
                this.drawMenus();
            } else if (this.canDisplayCards && this.ingameStates == 7) {
                this.displayFreeCamIcon();
                this.updateCardTime();
                this.displaySnakesCardsInHand();
            }
            if (this.ingameStates == 1 && !this.isDialogOver) {
                this.displayDialog();
            }
            if (this.ingameStates == 27 && !this.isDialogOver) {
                this.displayIntermissionDialog();
            }
            if (this.ingameStates == 18) {
                this.displayLevelResult();
            }
            if (this.ingameStates == 17) {
                this.displayStateHelp();
            }
            if (this.ingameStates == 29) {
                this.displayDemo();
            }
        }
        if (PSCanvas.nextState == 17) {
            this.displaySoftkeys();
            this.displayContextualIcon();
        }
    }

    public void displayFreeCamIcon() {
        int arrowsHeightLR = 10;
        int arrowsHeightUD = 5;
        int cameraHeight = 20;
        if (isFreeCamFadeOut && this.ingameStates == 15 && this.playerStatusArray[0][2] == 0) {
            this.freeCamY = 144;
        } else if (isFreeCamFadeOut && this.freeCamY + this.cardSmallHeight - 20 - 2 * arrowsHeightUD >= this.freeCamY + this.freeCamMoveY) {
            this.freeCamMoveY = this.cardSmallHeight - 20 - 2 * arrowsHeightUD - 15;
        } else {
            isFreeCamFadeOut = false;
        }
        if (isFreeCamFadeIn && this.ingameStates == 15 && this.playerStatusArray[0][2] == 0) {
            this.freeCamY = 144;
        } else if (isFreeCamFadeIn && this.freeCamY <= this.freeCamY + this.freeCamMoveY) {
            this.freeCamMoveY -= this.freeCamMoveY;
        } else {
            isFreeCamFadeIn = false;
        }
        this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1, Constants.HUD_CAMERA_SPIN_ICON_WIDTH[1], cameraHeight);
        this.g.drawImage(PSCanvas.imageArray[50], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1);
        this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] - Constants.HUD_ZERO_STAR_ICON_WIDTH[1] + Constants.HUD_CAMERA_SPIN_ICON_WIDTH[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1, Constants.HUD_ZERO_STAR_ICON_WIDTH[1], 9);
        this.g.drawImage(PSCanvas.imageArray[54], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] - Constants.HUD_ZERO_STAR_ICON_WIDTH[1] - Constants.HUD_ZERO_STAR_ICON_WIDTH[0] + Constants.HUD_CAMERA_SPIN_ICON_WIDTH[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1);
    }

    public void displayFreeCamArrows() {
        int arrowsHeightLR = 10;
        int arrowsHeightUD = 5;
        int cameraHeight = 20;
        if (isFreeCamFadeOut && this.ingameStates == 15 && this.playerStatusArray[0][2] == 0) {
            this.freeCamY = 144;
        } else if (isFreeCamFadeOut && this.freeCamY + this.cardSmallHeight - 20 - 2 * arrowsHeightUD >= this.freeCamY + this.freeCamMoveY) {
            this.freeCamMoveY = this.cardSmallHeight - 20 - 2 * arrowsHeightUD - 15;
        } else {
            isFreeCamFadeOut = false;
        }
        if (isFreeCamFadeIn && this.ingameStates == 15 && this.playerStatusArray[0][2] == 0) {
            this.freeCamY = 144;
        } else if (isFreeCamFadeIn && this.freeCamY <= this.freeCamY + this.freeCamMoveY) {
            this.freeCamMoveY -= this.freeCamMoveY;
        } else {
            isFreeCamFadeIn = false;
        }
        this.g.setClip(176 - (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] + 2 + Constants.HUD_CAMERA_ARROWS_WIDTHS[4] + 1 + Constants.HUD_CAMERA_ARROWS_WIDTHS[5]), this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2), Constants.HUD_CAMERA_ARROWS_WIDTHS[4], arrowsHeightLR);
        this.g.drawImage(PSCanvas.imageArray[49], 176 - (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] + 2 + Constants.HUD_CAMERA_ARROWS_WIDTHS[4] + 1 + Constants.HUD_CAMERA_ARROWS_WIDTHS[5]) - Constants.HUD_CAMERA_ARROWS_OFFSETS[4], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2));
        this.g.setClip(174 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] + 1, this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2), Constants.HUD_CAMERA_ARROWS_WIDTHS[5], arrowsHeightLR);
        this.g.drawImage(PSCanvas.imageArray[49], 174 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] + 1 - Constants.HUD_CAMERA_ARROWS_OFFSETS[5], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2));
        this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[6] / 2), this.freeCamY + this.freeCamMoveY, Constants.HUD_CAMERA_ARROWS_WIDTHS[6], arrowsHeightUD);
        this.g.drawImage(PSCanvas.imageArray[49], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] - Constants.HUD_CAMERA_ARROWS_OFFSETS[6] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[6] / 2), this.freeCamY + this.freeCamMoveY);
        this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[7] / 2), this.freeCamY + this.freeCamMoveY + cameraHeight + 2 + arrowsHeightUD, Constants.HUD_CAMERA_ARROWS_WIDTHS[7], arrowsHeightUD);
        this.g.drawImage(PSCanvas.imageArray[49], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] - Constants.HUD_CAMERA_ARROWS_OFFSETS[7] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[7] / 2), this.freeCamY + this.freeCamMoveY + cameraHeight + 2 + arrowsHeightUD);
        if ((PSCanvas.keyPressed & 2) != 0) {
            this.g.setClip(176 - (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] + 2 + Constants.HUD_CAMERA_ARROWS_WIDTHS[0] + 1 + Constants.HUD_CAMERA_ARROWS_WIDTHS[1]), this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2), Constants.HUD_CAMERA_ARROWS_WIDTHS[0], arrowsHeightLR);
            this.g.drawImage(PSCanvas.imageArray[49], 176 - (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] + 2 + Constants.HUD_CAMERA_ARROWS_WIDTHS[0] + 1 + Constants.HUD_CAMERA_ARROWS_WIDTHS[1]) - Constants.HUD_CAMERA_ARROWS_OFFSETS[0], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2));
        }
        if ((PSCanvas.keyPressed & 8) != 0) {
            this.g.setClip(174 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] + 1, this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2), Constants.HUD_CAMERA_ARROWS_WIDTHS[1], arrowsHeightLR);
            this.g.drawImage(PSCanvas.imageArray[49], 174 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] + 1 - Constants.HUD_CAMERA_ARROWS_OFFSETS[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1 + (cameraHeight / 2 - arrowsHeightLR / 2));
        }
        if ((PSCanvas.keyPressed & 1) != 0) {
            this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[2] / 2), this.freeCamY + this.freeCamMoveY, Constants.HUD_CAMERA_ARROWS_WIDTHS[2], arrowsHeightUD);
            this.g.drawImage(PSCanvas.imageArray[49], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] - Constants.HUD_CAMERA_ARROWS_OFFSETS[2] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[2] / 2), this.freeCamY + this.freeCamMoveY);
        }
        if ((PSCanvas.keyPressed & 4) != 0) {
            this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[3] / 2), this.freeCamY + this.freeCamMoveY + cameraHeight + 2 + arrowsHeightUD, Constants.HUD_CAMERA_ARROWS_WIDTHS[3], arrowsHeightUD);
            this.g.drawImage(PSCanvas.imageArray[49], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1] - Constants.HUD_CAMERA_ARROWS_OFFSETS[3] + (Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] / 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[3] / 2), this.freeCamY + this.freeCamMoveY + cameraHeight + 2 + arrowsHeightUD);
        }
        this.g.setClip(176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1, Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0], cameraHeight);
        this.g.drawImage(PSCanvas.imageArray[50], 176 - Constants.HUD_CAMERA_SPIN_ICON_WIDTH[0] - 2 - Constants.HUD_CAMERA_ARROWS_WIDTHS[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1);
        this.g.setClip(174 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] - Constants.HUD_ZERO_STAR_ICON_WIDTH[1], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1, Constants.HUD_ZERO_STAR_ICON_WIDTH[1], 9);
        this.g.drawImage(PSCanvas.imageArray[54], 174 - Constants.HUD_CAMERA_ARROWS_WIDTHS[5] - Constants.HUD_ZERO_STAR_ICON_WIDTH[1] - Constants.HUD_ZERO_STAR_ICON_WIDTH[0], this.freeCamY + this.freeCamMoveY + arrowsHeightUD + 1);
        if (!isCardsFadeOut && this.freeCamY <= this.freeCamY + this.freeCamMoveY && this.paintCount < 4) {
            PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[490], 168, this.freeCamY + this.freeCamMoveY - 5, 176, 69);
        }
    }

    public int computeCharactersLifeBarWidth(int charactersLife, int charactersMaxLife, int maxLifeBarWidth) {
        int lifeBarWidth = maxLifeBarWidth;
        if (charactersLife == 0) {
            return 0;
        }
        int percentLifeLeft = charactersLife * 100 / charactersMaxLife * 100;
        lifeBarWidth = percentLifeLeft * lifeBarWidth / 10000;
        return lifeBarWidth;
    }

    public void displaySnakeMoves() {
        int fontHeight = PSCanvas.fontEngine.getFontHeight(0);
        PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[470], 141, 193 - fontHeight, 67);
        PSCanvas.fontEngine.drawFont(this.g, 0, this.snakeMoveNumberLeft + "/" + this.snakeMoveNumber, 141 + PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[470]), 193, 69);
    }

    /*
     * Unable to fully structure code
     */
    public void updateSnakeStatus(Snake snake) {
        this.playerStatusArray[0][14] = 0;
        this.playerStatusArray[0][0] = snake.lifeNumberLeft;
        this.playerStatusArray[0][1] = snake.deck.getDeckCardsLeftNumber();
        this.playerStatusArray[0][2] = snake.actionNumberLeft;
        this.playerStatusArray[0][3] = snake.maxActionNumber;
        this.playerStatusArray[0][4] = snake.currentCost;
        this.playerStatusArray[0][5] = snake.initiativeTurnNumber;
        this.playerStatusArray[0][6] = snake.deck.getHandCardsCount();
        this.playerStatusArray[0][7] = snake.posX - GameBoard.camX;
        this.playerStatusArray[0][8] = snake.posY - GameBoard.camY;
        this.playerStatusArray[0][9] = Snake.sprite.getAnimationWidth(snake.spritePlayer.getAnimIdx());
        this.playerStatusArray[0][10] = Snake.sprite.getAnimationHeight(snake.spritePlayer.getAnimIdx());
        this.playerStatusArray[0][11] = snake.maxLifeNumber;
        this.playerStatusArray[0][13] = snake.facingDirection;
        this.playerStatusArray[0][15] = -1;
        if (Snake.currentState == 3) ** GOTO lbl-1000
        if (Snake.currentState == 7) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.isSnakeCrawled = v0;
        if (Snake.currentState == 2) ** GOTO lbl-1000
        if (Snake.currentState == 14) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        this.isSnakeFlattened = v1;
        this.hasSnakePunched = snake.hasPunched;
        this.canSnakePunch = snake.canPunch;
        this.hasSnakeKnocked = snake.hasKnocked;
        this.snakeMoveNumberLeft = snake.moveNumberLeft;
        this.canSnakeCancelMove = snake.blockCancelMove;
        this.snakeMoveNumber = snake.moveNumber;
        this.snakeEquipIndex = snake.equipIndex;
        this.snakeEquipment = snake.equipment;
        if (snake.deck.getHandCardsCount() > 0) {
            this.snakeHand = new Integer[snake.deck.getHandCardsCount()];
            snake.deck.getCardsFromHand(this.snakeHand);
        }
        if (snake.deck.getSelectedCardIndex() != -1 && snake.deck.getSelectedCard() != -1 && this.lastSelectedCard != snake.deck.getSelectedCard()) {
            this.snakeSelectedCard = snake.deck.getSelectedCardIndex();
            this.cardDescPageIndex = 0;
            this.cardDescStartTime = 0L;
            PSCanvas.fontEngine.setSpacing(1);
            cardDescription = PSCanvas.textArray[CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardDescription()];
            if (CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardUsageType() == 2) {
                cardDescription = PSCanvas.textArray[500] + ":" + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardReactionChance() + "%|" + cardDescription;
            }
            if (CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardUsageType() == 1 && CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardType() == 0) {
                cardDescription = PSCanvas.textArray[498] + ":" + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardAttackDamage() + (CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getAttacksNumber() > 1 ? " x " + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getAttacksNumber() : "") + "|" + PSCanvas.textArray[499] + ":" + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardHitChance() + "%|" + cardDescription;
            }
            this.cardDescriptionPages = PSCanvas.fontEngine.wrapTextPages(1, cardDescription.toUpperCase(), this.cardBigWidth - 10 - 2, 6);
            PSCanvas.fontEngine.resetSpacing();
        }
        this.lastSelectedCard = snake.deck.getSelectedCard();
        this.snakeSelectedCard = snake.deck.getSelectedCardIndex();
    }

    public void updateAIStatus(GameAI[] ai) {
        for (int i = 0; i < ai.length; ++i) {
            if (ai[i].type == 6 || ai[i].type == 7 || ai[i].type == 9) continue;
            this.playerStatusArray[i + 1][14] = 0;
            this.playerStatusArray[i + 1][12] = ai[i].maxLifeNumber;
            this.playerStatusArray[i + 1][0] = ai[i].lifeNumberLeft;
            this.playerStatusArray[i + 1][1] = ai[i].deck.getDeckCardsLeftNumber();
            this.playerStatusArray[i + 1][2] = ai[i].actionNumberLeft;
            this.playerStatusArray[i + 1][3] = ai[i].maxActionNumber;
            this.playerStatusArray[i + 1][4] = ai[i].currentCost;
            this.playerStatusArray[i + 1][5] = ai[i].initiativeTurnNumber;
            this.playerStatusArray[i + 1][6] = ai[i].deck.getHandCardsCount();
            this.playerStatusArray[i + 1][7] = ai[i].type == 5 ? ai[i].posX - GameBoard.camX - ai[i].sprite.getAnimationWidth(ai[i].spritePlayer.getAnimIdx()) / 2 : ai[i].posX - GameBoard.camX;
            this.playerStatusArray[i + 1][8] = ai[i].posY - GameBoard.camY;
            this.playerStatusArray[i + 1][9] = ai[i].sprite.getAnimationWidth(ai[i].spritePlayer.getAnimIdx());
            this.playerStatusArray[i + 1][10] = ai[i].sprite.getAnimationHeight(ai[i].spritePlayer.getAnimIdx());
            this.playerStatusArray[i + 1][11] = ai[i].maxLifeNumber;
            this.playerStatusArray[i + 1][13] = ai[i].facingDirection;
            this.playerStatusArray[i + 1][15] = ai[i].type;
        }
    }

    public void displaySnakeStatus() {
        int snakeHudIconWidth = PSCanvas.imageWidth[43];
        int snakeHudIconHeight = PSCanvas.imageHeight[43];
        int lifeBarWidth = 0;
        int x = 0;
        int y = 3;
        int fontHeight = PSCanvas.fontEngine.getFontHeight(0);
        int fontHeight2 = PSCanvas.fontEngine.getFontHeight(0);
        this.contextStatusOffsetY = y + 13 + 1 + fontHeight;
        this.g.setClip(x += snakeHudIconWidth / 8, y, snakeHudIconWidth, snakeHudIconHeight);
        this.g.drawImage(PSCanvas.imageArray[43], x, y);
        lifeBarWidth = this.computeCharactersLifeBarWidth(this.playerStatusArray[0][0], 500, 46);
        this.g.setClip(x += PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[466]), y, 46, 13);
        this.g.setColor(0);
        this.g.fillRect(x, y, 46, 13);
        this.g.setColor(0xCCCCCC);
        this.g.fillRect(x, y, lifeBarWidth - 1, 12);
        this.g.setColor(0);
        this.g.drawRect(x, y, 46, 13);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x + 1, y + 1, 43, 10);
        this.g.setColor(0);
        this.g.drawRect(x + 2, y + 2, 41, 8);
        for (int i = 0; i < 2; ++i) {
            if (this.snakeEquipment[i] == -1) continue;
            if (this.ingameStates == 9 && this.isEquipDisplay) {
                if (i == this.snakeEquipIndex) continue;
                this.g.setClip(x + (Constants.HUD_EQUIP_ICON_WIDTH[1] / 2 - Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()] / 2) + i * Constants.HUD_EQUIP_ICON_WIDTH[1], y + 13 + 1 - (6 - fontHeight / 2), Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()], 12);
                this.g.drawImage(PSCanvas.imageArray[55], x + (Constants.HUD_EQUIP_ICON_WIDTH[1] / 2 - Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()] / 2) + i * Constants.HUD_EQUIP_ICON_WIDTH[1] - Constants.HUD_EQUIP_ICON_OFFSET[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()], y + 13 + 1 - (6 - fontHeight / 2));
                continue;
            }
            this.g.setClip(x + (Constants.HUD_EQUIP_ICON_WIDTH[1] / 2 - Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()] / 2) + i * Constants.HUD_EQUIP_ICON_WIDTH[1], y + 13 + 1 - (6 - fontHeight / 2), Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()], 12);
            this.g.drawImage(PSCanvas.imageArray[55], x + (Constants.HUD_EQUIP_ICON_WIDTH[1] / 2 - Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()] / 2) + i * Constants.HUD_EQUIP_ICON_WIDTH[1] - Constants.HUD_EQUIP_ICON_OFFSET[0 + CardSet.CARD_LIST[this.snakeEquipment[i]].getCardType()], y + 13 + 1 - (6 - fontHeight / 2));
        }
        if (this.ingameStates == 9 && this.isEquipDisplay && this.paintCount < 4) {
            this.g.setClip(x + (Constants.HUD_EQUIP_ICON_WIDTH[1] / 2 - Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardType()] / 2) + this.snakeEquipIndex * Constants.HUD_EQUIP_ICON_WIDTH[1], y + 13 + 1 - (6 - fontHeight / 2), Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardType()], 12);
            this.g.drawImage(PSCanvas.imageArray[55], x + (Constants.HUD_EQUIP_ICON_WIDTH[1] / 2 - Constants.HUD_EQUIP_ICON_WIDTH[0 + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardType()] / 2) + this.snakeEquipIndex * Constants.HUD_EQUIP_ICON_WIDTH[1] - Constants.HUD_EQUIP_ICON_OFFSET[0 + CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardType()], y + 13 + 1 - (6 - fontHeight / 2));
        }
        this.g.setClip(x, y + 13 + 2 + fontHeight, 46, fontHeight);
        PSCanvas.fontEngine.drawFont(this.g, 0, this.playerStatusArray[0][2] + "/" + this.playerStatusArray[0][3], x + 46, y + 13 + 1, 21);
    }

    public void displayCostTurn(int cost) {
        int fontDigitIndex = 4;
        int currentCost = cost;
        if (this.isPreviewCost) {
            if ((currentCost += this.previewCost) < 0) {
                currentCost = 0;
            }
            fontDigitIndex = 5;
        }
        this.g.setClip(140, 5, Constants.HUD_ICON_COST_TURN_WIDTHS[0], 15);
        this.g.drawImage(PSCanvas.imageArray[48], 140 - Constants.HUD_ICON_COST_TURN_OFFSETS[0], 5);
        PSCanvas.fontEngine.drawFont(this.g, fontDigitIndex, "" + currentCost, 140 + Constants.HUD_ICON_COST_TURN_WIDTHS[0] + 0, 20, 67);
    }

    public void displaySnakesCostTurn() {
        this.displayCostTurn(this.playerStatusArray[0][4]);
    }

    public void contextStatus(int x, int y, int sprW, int sprH, int lifeLeft, int maxLife, int cards, int cost, int initiative, int direction, int statusChanged, int id, int aiType) {
        try {
            int lifeBarWidth = 0;
            int contextStatusHeight = 29;
            int contextStatusWidth = 17;
            int startX = 0;
            int startY = 0;
            startX = x;
            startY = y - (sprH / 2 - contextStatusHeight / 2);
            if (aiType != 5) {
                if (direction == 8) {
                    startX = x - (contextStatusWidth + 5);
                    if (startX > 176) {
                        startX = x - 5;
                    } else if (startX < 0) {
                        startX = x + 2 * contextStatusWidth + 5;
                    }
                    if (id == 0 && this.ingameStates == 7 && startX <= this.cardBigWidth) {
                        startX = this.cardBigWidth + sprW / 2;
                    }
                } else {
                    startX = x + sprW / 2 + 5;
                    if (startX + contextStatusWidth > 176) {
                        startX = x - contextStatusWidth - 5;
                    } else if (startX + contextStatusWidth < 0) {
                        startX = 0;
                    }
                }
            } else {
                startX = x + sprW / 2 + contextStatusWidth + 5;
                startY = y - (sprH / 2 - contextStatusHeight / 2) + contextStatusHeight;
            }
            if (startY + contextStatusHeight > 208) {
                startY -= contextStatusHeight;
            } else if (startY < 0) {
                startY = 0;
            }
            if (startX + contextStatusWidth + 5 < 0 || startX > 176 || startY + contextStatusHeight + 5 < 0 || startY > 208) {
                return;
            }
            if (startY > this.contextStatusOffsetY) {
                lifeBarWidth = this.computeCharactersLifeBarWidth(lifeLeft, maxLife, 17);
                this.g.setClip(startX, startY, contextStatusWidth, contextStatusHeight);
                this.g.setColor(0);
                this.g.fillRect(startX, startY, contextStatusWidth, contextStatusHeight);
                this.g.setColor(0xFFFFFF);
                this.g.fillRect(startX, startY, lifeBarWidth, 5);
                this.g.setColor(0);
                this.g.drawRect(startX, startY, 16, 5);
                this.g.setClip(startX + 1, startY + 5 + 8 - 8, Constants.HUD_ICONS_WIDTHS[2], 8);
                this.g.drawImage(PSCanvas.imageArray[45], startX + 1 - Constants.HUD_ICONS_OFFSETS[2], startY + 5 + 8 - 8);
                PSCanvas.fontEngine.setSpacing(1);
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + cards, startX + contextStatusWidth - 1, startY + 5 + 8, 69);
                this.g.setClip(startX + 1, startY + 5 + 16 - 8, Constants.HUD_ICONS_WIDTHS[3], 8);
                this.g.drawImage(PSCanvas.imageArray[45], startX + 1 - Constants.HUD_ICONS_OFFSETS[3], startY + 5 + 16 - 8);
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + cost, startX + contextStatusWidth - 1, startY + 5 + 16, 69);
                this.g.setClip(startX + 1, startY + 5 + 24 - 8, Constants.HUD_ICONS_WIDTHS[4], 8);
                this.g.drawImage(PSCanvas.imageArray[45], startX + 1 - Constants.HUD_ICONS_OFFSETS[4], startY + 5 + 24 - 8);
                PSCanvas.fontEngine.drawFont(this.g, 2, "" + initiative, startX + contextStatusWidth - 1, startY + 5 + 24, 69);
                PSCanvas.fontEngine.resetSpacing();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void displaySnakeContextStatus() {
        this.contextStatus(this.playerStatusArray[0][7], this.playerStatusArray[0][8], this.playerStatusArray[0][9], this.playerStatusArray[0][10], this.playerStatusArray[0][0], this.playerStatusArray[0][11], this.playerStatusArray[0][6], this.playerStatusArray[0][4], this.playerStatusArray[0][5], this.playerStatusArray[0][13], this.playerStatusArray[0][14], 0, this.playerStatusArray[0][15]);
    }

    public void displayAiContextStatus() {
        for (int i = 1; i < this.playerStatusArray.length; ++i) {
            if (this.playerStatusArray[i][0] <= 0 || this.playerStatusArray[i][7] <= -this.playerStatusArray[i][9] || this.playerStatusArray[i][7] >= 176 + this.playerStatusArray[i][9] || this.playerStatusArray[i][8] <= -this.playerStatusArray[i][10] || this.playerStatusArray[i][8] >= 208 + this.playerStatusArray[i][10]) continue;
            this.contextStatus(this.playerStatusArray[i][7], this.playerStatusArray[i][8], this.playerStatusArray[i][9], this.playerStatusArray[i][10], this.playerStatusArray[i][0], this.playerStatusArray[i][11], this.playerStatusArray[i][6], this.playerStatusArray[i][4], this.playerStatusArray[i][5], this.playerStatusArray[i][13], this.playerStatusArray[i][14], i, this.playerStatusArray[i][15]);
        }
    }

    public void initIngameMenu() {
        int i;
        this.clearIngameMenu();
        this.menuColorBarWidth = 5;
        this.menuStepX = 2 * (this.menuColorBarWidth + 1 + 99) / 12;
        if (this.menuStepX == 0) {
            this.menuStepX = 1;
        }
        this.menuX = -(this.menuColorBarWidth + 1 + 99);
        this.blockKeyPress = true;
        ingameCardMenuArray = null;
        ingameMenuArray = new int[Constants.GAMEBOARD_MENU_MAIN.length];
        for (i = 0; i < Constants.GAMEBOARD_MENU_MAIN.length; ++i) {
            GameBoardHud.ingameMenuArray[i] = Constants.GAMEBOARD_MENU_MAIN[i];
        }
        ingameMenuArrayText = new int[Constants.GAMEBOARD_MENU_MAIN.length];
        for (i = 0; i < Constants.GAMEBOARD_MENU_MAIN.length; ++i) {
            GameBoardHud.ingameMenuArrayText[i] = 46 + (ingameMenuArray[i] - ingameMenuArray[0]);
        }
        ingameSubMenuArray = null;
        ingameSubMenuArrayText = null;
        this.isSubMenu = false;
        this.isMenuReady = true;
        this.ingameMenuCurrentState = 0;
    }

    public void initIngamePauseMenu() {
        int i;
        this.clearIngameMenu();
        this.menuColorBarWidth = 5;
        this.menuStepX = 2 * (this.menuColorBarWidth + 1 + 99) / 12;
        if (this.menuStepX == 0) {
            this.menuStepX = 1;
        }
        this.menuX = -(this.menuColorBarWidth + 1 + 99);
        this.blockKeyPress = true;
        ingameCardMenuArray = null;
        ingameMenuArray = new int[Constants.GAMEBOARD_MENU_PAUSE.length];
        for (i = 0; i < Constants.GAMEBOARD_MENU_PAUSE.length; ++i) {
            GameBoardHud.ingameMenuArray[i] = Constants.GAMEBOARD_MENU_PAUSE[i];
        }
        ingameMenuArrayText = new int[Constants.GAMEBOARD_MENU_PAUSE.length];
        for (i = 0; i < Constants.GAMEBOARD_MENU_PAUSE.length; ++i) {
            GameBoardHud.ingameMenuArrayText[i] = 47 + (ingameMenuArray[i] - ingameMenuArray[0]);
        }
        ingameSubMenuArray = null;
        ingameSubMenuArrayText = null;
        this.isSubMenu = false;
        this.isMenuReady = true;
        this.ingameMenuCurrentState = 0;
    }

    public void clearIngameMenu() {
        this.menuX = 0;
        this.menuY = 0;
        this.menuStepX = 0;
        ingameMenuArray = null;
        ingameSubMenuArray = null;
        ingameMenuArrayText = null;
        ingameSubMenuArrayText = null;
        this.ingameMenuSelectedOption = 0;
        this.ingameSubMenuSelectedOption = 0;
        this.ingameMenuCurrentState = -1;
        this.isSubMenu = false;
        this.isMenuReady = false;
        ingameCardMenuArray = null;
        PSGraphics.Gc();
    }

    public void drawMenu(int menuSelectedOption, int[] menuArray, int[] menuTextArray, boolean isSubMenu) {
        if (menuArray != null) {
            int arrowHeight = PSCanvas.imageHeight[46];
            int arrowWidth = PSCanvas.imageWidth[46] / 2;
            int elementMenuHeight = arrowHeight;
            int fontHeight = PSCanvas.fontEngine.getFontHeight(1);
            int longestMenuText = 0;
            int indexLongestMenuText = 0;
            int menusWidth = 0;
            int menuHeight = (menuArray != null ? menuArray.length : 1) * elementMenuHeight;
            for (int i = 0; i < menuTextArray.length; ++i) {
                if (PSCanvas.textArray[menuTextArray[i]].length() < longestMenuText) continue;
                indexLongestMenuText = i;
                longestMenuText = PSCanvas.textArray[menuTextArray[i]].length();
            }
            menusWidth = this.ingameStates == 7 ? PSCanvas.fontEngine.getTextLength(2, PSCanvas.textArray[menuTextArray[indexLongestMenuText]]) : PSCanvas.fontEngine.getTextLength(2, PSCanvas.textArray[menuTextArray[indexLongestMenuText]] + "__");
            int menuWidth = this.menuColorBarWidth + 1 + 6 + arrowWidth + menusWidth;
            this.g.setColor(this.menuColor);
            this.g.setClip(this.menuX, this.menuY - 2, menuWidth + 2, menuHeight + 4);
            this.g.fillRect(this.menuX, this.menuY - 2, menuWidth + 2, menuHeight + 4);
            this.g.setColor(this.menuColor);
            this.g.setColor(0);
            this.g.setClip(this.menuX + this.menuColorBarWidth, this.menuY, menuWidth - this.menuColorBarWidth, menuHeight);
            this.g.fillRect(this.menuX + this.menuColorBarWidth, this.menuY, menuWidth - this.menuColorBarWidth, menuHeight);
            String tmp = "";
            if (menuArray != null) {
                for (int i = 0; i < menuArray.length; ++i) {
                    tmp = PSCanvas.textArray[menuTextArray[i]].toUpperCase();
                    if (menuArray[i] == 7) {
                        tmp = PSSoundManager.soundOn ? PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (menuArray[i] == 6) {
                        tmp = PSSoundManager.musicOn ? PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (menuArray[i] == 8) {
                        tmp = PSCanvas.isVibration ? PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (menuArray[i] == 4) {
                        tmp = PSCanvas.textArray[menuTextArray[i]].toUpperCase() + " " + PSCanvas.gameSpeed;
                    }
                    PSCanvas.fontEngine.drawFont(this.g, 3, tmp, this.menuX + this.menuColorBarWidth + 1 + arrowWidth + 3, this.menuY + elementMenuHeight * i + (elementMenuHeight / 2 - fontHeight / 2), 19);
                }
                if (menuSelectedOption < menuArray.length) {
                    tmp = PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase();
                    if (menuArray[menuSelectedOption] == 7) {
                        tmp = PSSoundManager.soundOn ? PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (menuArray[menuSelectedOption] == 6) {
                        tmp = PSSoundManager.musicOn ? PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (menuArray[menuSelectedOption] == 8) {
                        tmp = PSCanvas.isVibration ? PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (menuArray[menuSelectedOption] == 4) {
                        tmp = PSCanvas.textArray[menuTextArray[menuSelectedOption]].toUpperCase() + " " + PSCanvas.gameSpeed;
                    }
                    this.g.setColor(this.menuColor);
                    this.g.setClip(this.menuX, this.menuY + elementMenuHeight * menuSelectedOption, this.menuColorBarWidth, elementMenuHeight);
                    this.g.fillRect(this.menuX, this.menuY + elementMenuHeight * menuSelectedOption, this.menuColorBarWidth, elementMenuHeight);
                    this.g.setColor(0);
                    this.g.setClip(this.menuX + this.menuColorBarWidth, this.menuY + elementMenuHeight * menuSelectedOption, menusWidth, elementMenuHeight);
                    this.g.fillRect(this.menuX + this.menuColorBarWidth, this.menuY + elementMenuHeight * menuSelectedOption, menusWidth, elementMenuHeight);
                    PSCanvas.fontEngine.drawFont(this.g, 2, tmp, this.menuX + this.menuColorBarWidth + 1 + arrowWidth + 3, this.menuY + elementMenuHeight * menuSelectedOption + (elementMenuHeight / 2 - fontHeight / 2), 19);
                    if (!isSubMenu) {
                        this.g.setClip(this.menuX + this.menuColorBarWidth + 1, this.menuY + elementMenuHeight * menuSelectedOption, arrowWidth, arrowHeight);
                        this.g.drawImage(PSCanvas.imageArray[46], this.menuX + this.menuColorBarWidth + 1, this.menuY + elementMenuHeight * menuSelectedOption);
                    }
                }
            }
        }
    }

    public void drawSubMenu(int menuSelectedOption, int[] subMenuArray, int subMenuOffset) {
        if (subMenuArray != null) {
            int arrowHeight = PSCanvas.imageHeight[46];
            int arrowWidth = PSCanvas.imageWidth[46] / 2;
            int elementMenuHeight = arrowHeight;
            int fontHeight = PSCanvas.fontEngine.getFontHeight(1);
            int subMenuYOffset = elementMenuHeight * subMenuOffset;
            String tmp = "";
            int menusWidth = 0;
            int longestMenuText = 0;
            int indexLongestMenuText = 0;
            int menuHeight = (subMenuArray != null ? subMenuArray.length : 1) * elementMenuHeight;
            for (int i = 0; i < ingameSubMenuArrayText.length; ++i) {
                if (PSCanvas.textArray[ingameSubMenuArrayText[i]].length() < longestMenuText) continue;
                indexLongestMenuText = i;
                longestMenuText = PSCanvas.textArray[ingameSubMenuArrayText[i]].length();
            }
            menusWidth = PSCanvas.fontEngine.getTextLength(2, PSCanvas.textArray[ingameSubMenuArrayText[indexLongestMenuText]] + "_OFF");
            int menuWidth = this.menuColorBarWidth + 1 + 6 + arrowWidth + menusWidth;
            this.g.setColor(this.menuColor);
            this.g.setClip(this.menuX + arrowWidth, this.menuY + subMenuYOffset - 2, menuWidth + 2, menuHeight + 4);
            this.g.fillRect(this.menuX + arrowWidth, this.menuY + subMenuYOffset - 2, menuWidth + 2, menuHeight + 4);
            this.g.setColor(0);
            this.g.setClip(this.menuX + this.menuColorBarWidth + (arrowWidth - 1), this.menuY + subMenuYOffset, menuWidth - this.menuColorBarWidth, menuHeight);
            this.g.fillRect(this.menuX + this.menuColorBarWidth, this.menuY + subMenuYOffset, menuWidth - this.menuColorBarWidth + (arrowWidth - 1), menuHeight);
            if (subMenuArray != null) {
                for (int i = 0; i < subMenuArray.length; ++i) {
                    tmp = PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase();
                    if (subMenuArray[i] == 7) {
                        tmp = PSSoundManager.soundOn ? PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (subMenuArray[i] == 6) {
                        tmp = PSSoundManager.musicOn ? PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (subMenuArray[i] == 8) {
                        tmp = PSCanvas.isVibration ? PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[ingameSubMenuArrayText[i]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    PSCanvas.fontEngine.drawFont(this.g, 3, tmp, this.menuX + this.menuColorBarWidth + 1 + 2 * (arrowWidth - 1) + 3, this.menuY + elementMenuHeight * i + subMenuYOffset + (elementMenuHeight / 2 - fontHeight / 2), 19);
                    if (i != menuSelectedOption) continue;
                }
                if (menuSelectedOption < subMenuArray.length) {
                    tmp = PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase();
                    this.g.setClip(this.menuX + this.menuColorBarWidth + 1 + arrowWidth - 1, this.menuY + elementMenuHeight * menuSelectedOption + subMenuYOffset, arrowWidth, arrowHeight);
                    this.g.drawImage(PSCanvas.imageArray[46], this.menuX + this.menuColorBarWidth + 1 + arrowWidth - 1, this.menuY + elementMenuHeight * menuSelectedOption + subMenuYOffset);
                    if (subMenuArray[menuSelectedOption] == 7) {
                        tmp = PSSoundManager.soundOn ? PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (subMenuArray[menuSelectedOption] == 6) {
                        tmp = PSSoundManager.musicOn ? PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    if (subMenuArray[menuSelectedOption] == 8) {
                        tmp = PSCanvas.isVibration ? PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[1].toUpperCase() : PSCanvas.textArray[ingameSubMenuArrayText[menuSelectedOption]].toUpperCase() + " " + PSCanvas.textArray[2].toUpperCase();
                    }
                    PSCanvas.fontEngine.drawFont(this.g, 2, tmp, this.menuX + this.menuColorBarWidth + 1 + 2 * (arrowWidth - 1) + 3, this.menuY + elementMenuHeight * menuSelectedOption + subMenuYOffset + (elementMenuHeight / 2 - fontHeight / 2), 19);
                }
            }
        }
    }

    public void drawMenus() {
        this.menuX = 8;
        this.blockKeyPress = false;
        this.menuY = 26;
        this.menuColor = 255;
        if (this.isMenuReady) {
            PSCanvas.fontEngine.setSpacing(2);
            this.drawMenu(this.ingameMenuSelectedOption, ingameMenuArray, ingameMenuArrayText, this.isSubMenu);
            if (this.isSubMenu) {
                this.drawSubMenu(this.ingameSubMenuSelectedOption, ingameSubMenuArray, this.ingameMenuSelectedOption + 1);
            }
            PSCanvas.fontEngine.resetSpacing();
        }
    }

    public void displayAlert(int alertPercent) {
        int x = 80;
        this.g.setClip(x, 3, 58, 8);
        this.g.setColor(0xFF0000);
        this.g.fillRect(x, 3, 58, 8);
        this.g.setColor(0);
        this.g.fillRect(x, 3, 58, 8);
        if (this.paintCount < 4) {
            this.g.setColor(0xFF0000);
        } else {
            this.g.setColor(11480367);
        }
        this.g.fillRect(x, 3, alertPercent * 57 / 100, 7);
        this.g.setColor(0);
        this.g.drawRect(x, 3, 58, 8);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x + 1, 4, 55, 5);
        this.g.setColor(0);
        this.g.drawRect(x + 2, 5, 53, 3);
        PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[491], x, 12, 3);
        PSCanvas.fontEngine.drawFont(this.g, 0, alertPercent + "%", x + 58, 12, 5);
    }

    public void displayEquipOn() {
        this.isEquipDisplay = true;
    }

    public void displayEquipOff() {
        this.isEquipDisplay = false;
    }

    public void setResult(int totalCost, int totalKills, int totalAlarms, int pointsEarned, int gamePoints, int found, int total, int[] cards) {
        this.resultCost = totalCost;
        this.resultKills = totalKills;
        this.resultAlarms = totalAlarms;
        this.resultPointsEarned = pointsEarned;
        this.resultGamePoints = gamePoints;
        this.resultFound = found;
        this.resultTotalToFind = total;
        this.resultOffset = 0;
        if (cards != null) {
            this.resultCards = new int[cards.length];
            for (int i = 0; i < cards.length; ++i) {
                this.resultCards[i] = cards[i];
            }
        } else {
            this.resultCards = null;
        }
    }

    public void clearResult() {
        this.resultCost = 0;
        this.resultKills = 0;
        this.resultAlarms = 0;
        this.resultPointsEarned = 0;
        this.resultGamePoints = 0;
        this.resultFound = 0;
        this.resultTotalToFind = 0;
        this.resultCards = null;
        this.resultOffset = 0;
    }

    public void nextResultLine() {
        if (this.resultCards.length > 9) {
            ++this.resultOffset;
            if (this.resultOffset + 9 > this.resultCards.length) {
                this.resultOffset = this.resultCards.length - 9;
            }
        }
    }

    public void prevResultLine() {
        if (this.resultCards.length > 9) {
            --this.resultOffset;
            if (this.resultOffset < 0) {
                this.resultOffset = 0;
            }
        }
    }

    private void displayLevelResult() {
        PSCanvas.fontEngine.setSpacing(1);
        int fontHeight = PSCanvas.fontEngine.getFontHeight(2);
        int cardsCount = 0;
        int x = 0;
        int y = 0;
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(0, 0, 176, 208);
        this.g.setClip(0, 0, 176, 20);
        this.g.setColor(255);
        this.g.fillRect(0, 0, 176, 20);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[529], 10, y + 10, 35);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[530], 10, y += 30, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, "" + this.resultCost, 166, y, 21);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[531], 10, y += 10, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, "" + this.resultKills, 166, y, 21);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[532], 10, y += 10, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, "" + this.resultAlarms, 166, y, 21);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[533], 10, y += 10, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, "" + this.resultPointsEarned, 166, y, 21);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[534], 10, y += 10, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, "" + this.resultGamePoints, 166, y, 21);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[561], 10, y += 10, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, this.resultFound + "/" + this.resultTotalToFind, 166, y, 21);
        cardsCount = this.resultCards != null ? this.resultCards.length : 0;
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[552], 10, y += 10, 19);
        PSCanvas.fontEngine.drawFont(this.g, 2, "" + cardsCount, 166, y, 21);
        y += 10;
        x = 163;
        this.g.setClip(0, 0, 176, 208);
        if (this.resultCards != null) {
            int i;
            int resultLimit = this.resultCards.length;
            if (resultLimit > 9) {
                resultLimit = this.resultOffset + 9;
                if (this.resultOffset > 0) {
                    this.g.setColor(0xFFFFFF);
                    for (i = 1; i <= 5; ++i) {
                        this.g.fillRect(x - 2 - i - 1, y + (i - 1), 2 * i - 1, 1);
                    }
                }
            }
            for (i = this.resultOffset; i < resultLimit; ++i) {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[CardSet.CARD_LIST[this.resultCards[i]].getCardName()].toUpperCase(), 88, y, 25);
                y += fontHeight;
            }
            if (this.resultCards.length > 9 && this.resultOffset + 9 < this.resultCards.length) {
                this.g.setColor(0xFFFFFF);
                for (i = 1; i <= 5; ++i) {
                    this.g.fillRect(x - 2 - i - 1, y - (i - 1), 2 * i - 1, 1);
                }
            }
        }
        PSCanvas.fontEngine.resetSpacing();
    }

    private int executeMenu(int selectedOption, int[] menuOptions, boolean isSubMenuOpen) {
        if (!isSubMenuOpen) {
            if ((PSCanvas.keyPressed & 1) != 0) {
                if (--selectedOption < 0) {
                    selectedOption = menuOptions.length - 1;
                }
                PSCanvas.keyClear();
            } else if ((PSCanvas.keyPressed & 4) != 0) {
                if (++selectedOption > menuOptions.length - 1) {
                    selectedOption = 0;
                }
                PSCanvas.keyClear();
            } else if ((PSCanvas.keyPressed & 0x10) != 0 || (PSCanvas.keyPressed & 0x200) != 0) {
                switch (menuOptions[selectedOption]) {
                    case 3: {
                        this.ingameMenuCurrentState = 3;
                        this.isSubMenu = true;
                        this.loadMenuData(Constants.GAMEBOARD_MENU_OPTIONS_MENU, 54, this.isSubMenu);
                        break;
                    }
                    case 4: {
                        if (++PSCanvas.gameSpeed <= 3) break;
                        PSCanvas.gameSpeed = 1;
                        break;
                    }
                    case 7: {
                        PSCanvas.soundManager.soundOnOff();
                        if (!PSSoundManager.soundOn) break;
                        PSCanvas.soundManager.play(0, 13, 0);
                        break;
                    }
                    case 6: {
                        PSCanvas.soundManager.musicOnOff();
                        break;
                    }
                    case 8: {
                        PSCanvas.setVibrationOnOff();
                        if (!PSCanvas.isVibration) break;
                        PSCanvas.setVibration(200);
                        break;
                    }
                }
                PSCanvas.keyClear();
            } else if ((PSCanvas.keyPressed & 0x100) != 0) {
                if (this.ingameMenuCurrentState != 0) {
                    this.isSubMenu = false;
                    if (this.ingameStates == 16) {
                        this.loadMenuData(Constants.GAMEBOARD_MENU_PAUSE, 47, this.isSubMenu);
                    } else {
                        this.loadMenuData(Constants.GAMEBOARD_MENU_MAIN, 46, this.isSubMenu);
                    }
                    ingameSubMenuArray = null;
                    ingameSubMenuArrayText = null;
                    this.ingameSubMenuSelectedOption = 0;
                    selectedOption = 0;
                    this.ingameMenuCurrentState = 0;
                } else {
                    this.isSubMenu = false;
                }
                PSCanvas.keyClear();
            }
        }
        return selectedOption;
    }

    public void loadMenuData(int[] menuStates, int menuText, boolean isSubMenu) {
        if (isSubMenu) {
            int i;
            ingameSubMenuArray = new int[menuStates.length];
            for (i = 0; i < menuStates.length; ++i) {
                GameBoardHud.ingameSubMenuArray[i] = menuStates[i];
            }
            ingameSubMenuArrayText = new int[menuStates.length];
            for (i = 0; i < menuStates.length; ++i) {
                GameBoardHud.ingameSubMenuArrayText[i] = menuText + (ingameSubMenuArray[i] - ingameSubMenuArray[0]);
            }
        } else {
            int i;
            ingameMenuArray = new int[menuStates.length];
            for (i = 0; i < menuStates.length; ++i) {
                GameBoardHud.ingameMenuArray[i] = menuStates[i];
            }
            ingameMenuArrayText = new int[menuStates.length];
            for (i = 0; i < menuStates.length; ++i) {
                GameBoardHud.ingameMenuArrayText[i] = menuText + (ingameMenuArray[i] - ingameMenuArray[0]);
            }
        }
    }

    public int executeMenus() {
        this.ingameMenuSelectedOption = this.executeMenu(this.ingameMenuSelectedOption, ingameMenuArray, this.isSubMenu);
        if (this.isSubMenu) {
            this.ingameSubMenuSelectedOption = this.executeMenu(this.ingameSubMenuSelectedOption, ingameSubMenuArray, false);
            if (ingameSubMenuArray != null) {
                return ingameSubMenuArray[this.ingameSubMenuSelectedOption];
            }
            return 0;
        }
        return ingameMenuArray[this.ingameMenuSelectedOption];
    }

    public void initCardsSize() {
        this.cardIconBigWidth = 68;
        this.cardIconBigHeight = 44;
        this.cardIconSmallWidth = 19;
        this.cardIconSmallHeight = 9;
        this.cardSmallWidth = 27;
        this.cardBigWidth = 78;
        this.cardSmallHeight = 36;
        this.cardBigHeight = 105;
    }

    public void drawCardMenus() {
        this.menuX = this.cardBigWidth + 2;
        this.menuY = 208 - this.cardSmallHeight - 15 - (ingameCardMenuArray != null ? ingameCardMenuArray.length * PSCanvas.imageHeight[46] : 1) - 4;
        this.menuColorBarWidth = 2;
        switch (CardSet.CARD_LIST[this.snakeHand[this.snakeSelectedCard]].getCardType()) {
            case 0: {
                this.menuColor = 16716947;
                break;
            }
            case 3: {
                this.menuColor = 255;
                break;
            }
            case 1: {
                this.menuColor = 4312599;
                break;
            }
            case 4: {
                this.menuColor = 0x444444;
                break;
            }
            case 2: {
                this.menuColor = 16743936;
            }
        }
        PSCanvas.fontEngine.setSpacing(2);
        if (this.canDisplayCards) {
            this.drawMenu(this.ingameMenuSelectedOption, ingameCardMenuArray, ingameCardMenuArrayText, false);
        }
        PSCanvas.fontEngine.resetSpacing();
    }

    public int executeCardMenu() {
        this.ingameMenuSelectedOption = this.executeMenu(this.ingameMenuSelectedOption, ingameCardMenuArray, false);
        if ((PSCanvas.keyPressed & 2) != 0 || (PSCanvas.keyPressed & 8) != 0) {
            this.ingameMenuSelectedOption = 0;
        }
        return ingameCardMenuArray[this.ingameMenuSelectedOption];
    }

    public boolean isMenuDataLoaded() {
        return ingameCardMenuArray != null;
    }

    public void prepareCardData(int card) {
        this.clearIngameMenu();
        switch (CardSet.CARD_LIST[card].getCardType()) {
            case 0: {
                this.LoadCardData(Constants.CARD_USE_MOVE, 57);
                break;
            }
            case 4: {
                if (CardSet.CARD_LIST[card].getCardSubType() == 0) {
                    this.LoadCardData(Constants.CARD_MOVE, 57);
                    break;
                }
                this.LoadCardData(Constants.CARD_USE_MOVE, 57);
                break;
            }
            case 2: {
                this.LoadCardData(Constants.CARD_USE, 57);
                break;
            }
            case 3: {
                if (CardSet.CARD_LIST[card].getCardUsageType() == 2) {
                    this.LoadCardData(Constants.CARD_EQUIP_MOVE, 57);
                    break;
                }
                this.LoadCardData(Constants.CARD_USE_MOVE, 57);
                break;
            }
            case 1: {
                if (CardSet.CARD_LIST[card].getCardUsageType() == 2) {
                    this.LoadCardData(Constants.CARD_EQUIP_MOVE, 57);
                    break;
                }
                this.LoadCardData(Constants.CARD_USE_MOVE, 57);
            }
        }
    }

    public void LoadCardData(int[] menuStates, int menuText) {
        int i;
        ingameCardMenuArray = new int[menuStates.length];
        for (i = 0; i < menuStates.length; ++i) {
            GameBoardHud.ingameCardMenuArray[i] = menuStates[i];
        }
        ingameCardMenuArrayText = new int[menuStates.length];
        for (i = 0; i < menuStates.length; ++i) {
            GameBoardHud.ingameCardMenuArrayText[i] = menuText + menuStates[i];
        }
    }

    private int executeCardMenu(int selectedOption, int[] menuOptions, boolean isSubMenuOpen) {
        if (!isSubMenuOpen && menuOptions.length > 1) {
            if ((PSCanvas.keyPressed & 1) != 0) {
                if (--selectedOption < 0) {
                    selectedOption = menuOptions.length - 1;
                }
                PSCanvas.keyClear();
            } else if ((PSCanvas.keyPressed & 4) != 0) {
                if (++selectedOption > menuOptions.length - 1) {
                    selectedOption = 0;
                }
                PSCanvas.keyClear();
            }
        }
        return selectedOption;
    }

    public void displayArrowYellowLeft(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[6], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[6], y);
    }

    public void displayArrowYellowRight(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[7], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[7], y);
    }

    public void displayArrowYellowUp(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[4], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[4], y);
    }

    public void displayArrowYellowDown(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[5], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[5], y);
    }

    public void displayArrowBlackLeft(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[2], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[2], y);
    }

    public void displayArrowBlackRight(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[3], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[3], y);
    }

    public void displayArrowBlackUp(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[0], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[0], y);
    }

    public void displayArrowBlackDown(int x, int y) {
        this.g.setClip(x, y, Constants.HUD_ARROW_BUTTONS_WIDTHS[1], 12);
        this.g.drawImage(PSCanvas.imageArray[47], x - Constants.HUD_ARROW_BUTTONS_OFFSETS[1], y);
    }

    public void displaySnakesCardsInHand() {
        if (GameBoard.camIsTraveling) {
            return;
        }
        if (this.snakeHand != null && this.snakeSelectedCard != -1) {
            int y = 208 - this.cardSmallHeight;
            if (this.selectedCardPosX < 0 && isCardsFadeIn) {
                this.displayCardsInHand(this.snakeHand);
                this.displayFadeInSelectedCard(this.snakeHand[this.snakeSelectedCard]);
            } else if (this.selectedCardPosX > -this.cardBigWidth && isCardsFadeOut) {
                this.displayCardsInHand(this.snakeHand);
                this.displayFadeOutSelectedCard(this.snakeHand[this.snakeSelectedCard]);
            } else {
                if (!isCardsFadeOut) {
                    this.displayCardsInHand(this.snakeHand);
                    if (this.blockKeyPress && this.isMoveLeft) {
                        this.displayArrowYellowLeft(Constants.HUD_ARROW_BUTTONS_WIDTHS[2] / 2, y);
                    } else {
                        this.displayArrowBlackLeft(Constants.HUD_ARROW_BUTTONS_WIDTHS[2] / 2, y);
                    }
                    if (this.blockKeyPress && this.isMoveRight) {
                        this.displayArrowYellowRight(176 - Constants.HUD_ARROW_BUTTONS_WIDTHS[3] - Constants.HUD_ARROW_BUTTONS_WIDTHS[3] / 2, y);
                    } else {
                        this.displayArrowBlackRight(176 - Constants.HUD_ARROW_BUTTONS_WIDTHS[3] - Constants.HUD_ARROW_BUTTONS_WIDTHS[3] / 2, y);
                    }
                    this.displaySelectedCard(this.snakeHand[this.snakeSelectedCard]);
                    this.drawCardMenus();
                }
                isCardsFadeOut = false;
                isFreeCamFadeOut = false;
                isCardsFadeIn = false;
                isFreeCamFadeIn = false;
            }
        }
    }

    public void prepareFadeInCardAnimation() {
        this.freeCamStepY = (this.cardSmallHeight - 2) / 6;
        this.freeCamY = 208 - this.cardSmallHeight - 12 - 32;
        if (this.freeCamStepY == 0) {
            this.freeCamStepY = 1;
        }
        isFreeCamFadeIn = true;
        isFreeCamFadeOut = false;
    }

    public void prepareFadeOutCardAnimation() {
        this.freeCamStepY = (this.cardSmallHeight - 2) / 6;
        this.freeCamY = 159;
        if (this.freeCamStepY == 0) {
            this.freeCamStepY = 1;
        }
        isFreeCamFadeOut = true;
        isFreeCamFadeIn = false;
    }

    public void displayFadeInSelectedCard(int card) {
        this.displayCard(card, this.selectedCardPosX += this.cardStepX, 208 - this.cardBigHeight - this.cardSmallHeight - 15);
    }

    public void displayFadeOutSelectedCard(int card) {
        this.displayCard(card, this.selectedCardPosX -= this.cardStepX, 208 - this.cardBigHeight - this.cardSmallHeight - 15);
    }

    public void displaySelectedCard() {
        this.displayCard(this.snakeHand[this.snakeSelectedCard], 0, 208 - this.cardBigHeight - this.cardSmallHeight - 15);
    }

    public void displayCard(int card, int x, int y) {
        int startX = x;
        int startY = y;
        int cardColor = 0;
        switch (CardSet.CARD_LIST[card].getCardType()) {
            case 0: {
                cardColor = 16716947;
                break;
            }
            case 3: {
                cardColor = 255;
                break;
            }
            case 1: {
                cardColor = 4312599;
                break;
            }
            case 4: {
                cardColor = 0x444444;
                break;
            }
            case 2: {
                cardColor = 16743936;
            }
        }
        PSCanvas.fontEngine.setSpacing(1);
        int fontHeight = PSCanvas.fontEngine.getFontHeight(0);
        this.g.setClip(startX + 2, startY + 2, this.cardBigWidth, this.cardBigHeight);
        this.g.setColor(0);
        this.g.fillRect(startX + 2, startY + 2, this.cardBigWidth, this.cardBigHeight);
        this.g.setClip(startX, startY, this.cardBigWidth, this.cardBigHeight);
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(startX, startY, this.cardBigWidth, this.cardBigHeight);
        for (int i = 0; i < 2; ++i) {
            this.g.setColor(cardColor);
            this.g.drawRect(startX + i, startY + i, this.cardBigWidth - 1 - 2 * i, this.cardBigHeight - 1 - 2 * i);
        }
        this.g.setColor(cardColor);
        this.g.fillRect(startX + 5, startY + 5, this.cardBigWidth - 10, this.cardIconBigHeight);
        this.g.setColor(0x343434);
        this.g.fillRect(startX + 5, startY + 10, this.cardBigWidth - 10, this.cardIconBigHeight - fontHeight - 5);
        this.g.setColor(0xCCCCCC);
        this.g.fillRect(startX + 5 + 3, startY + 10 + 3, this.cardBigWidth - 10 - 6, this.cardIconBigHeight - fontHeight - 5 - 6);
        PSCanvas.fontEngine.setSpacing(0);
        int textWidth = PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[57 + CardSet.CARD_LIST[card].getCardUsageType()].toUpperCase());
        PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[57 + CardSet.CARD_LIST[card].getCardUsageType()].toUpperCase(), startX + 5 + 3, startY + 10 + 3, 19);
        textWidth = PSCanvas.fontEngine.getTextLength(0, "" + CardSet.CARD_LIST[card].getCardCost());
        PSCanvas.fontEngine.drawFont(this.g, 4, "" + CardSet.CARD_LIST[card].getCardCost(), startX + this.cardBigWidth - 2 - 4, startY + this.cardBigHeight / 3 + -8 + fontHeight / 2 - 1, 37);
        textWidth = PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()]);
        String tempTxt = PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()];
        if (tempTxt.length() > 1) {
            tempTxt = PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].substring(0, PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].length() > 10 ? 10 : PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].length()) + (PSCanvas.textArray[CardSet.CARD_LIST[card].getCardName()].length() > 10 ? "." : "");
        }
        PSCanvas.fontEngine.drawFont(this.g, 0, tempTxt, startX + this.cardBigWidth / 2, startY + this.cardBigHeight / 2 + -8, 41);
        PSCanvas.fontEngine.setSpacing(1);
        if (this.isCardDescScrolling) {
            if (this.cardDescriptionPages.length > 1) {
                ++this.cardDescPageIndex;
                if (this.cardDescPageIndex > this.cardDescriptionPages.length - 1) {
                    this.cardDescPageIndex = 0;
                }
                this.cardDescStartTime = 0L;
            }
            this.isCardDescScrolling = false;
        }
        PSCanvas.fontEngine.drawFont(this.g, 1, this.cardDescriptionPages[this.cardDescPageIndex], startX + 5, startY + 5 + this.cardIconBigHeight, this.cardBigWidth - 10 - 2, 19);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displayCardConnector() {
        int cardsHandWidth = 176 - 6 * this.cardSmallWidth;
        int cardsSpacing = 0;
        int startX = 0;
        if (cardsHandWidth == 0) {
            cardsSpacing = 0;
        } else if (cardsHandWidth > 0) {
            startX = cardsSpacing = cardsHandWidth / 6;
        } else if (cardsHandWidth < 0) {
            cardsSpacing = -(Math.abs(cardsHandWidth) / 6);
        }
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0xFFFFFF);
        this.g.drawLine((176 - this.cardBigWidth) / 10 + this.cardBigWidth / 2, 104 + this.cardBigHeight / 2, (176 - this.cardBigWidth) / 10 + this.cardBigWidth / 2, 104 + this.cardBigHeight / 2 + (104 + this.cardBigHeight / 2 - (208 - this.cardSmallHeight)) / 2);
        this.g.drawLine(startX + 2 * (this.cardSmallWidth + cardsSpacing), 104 + this.cardBigHeight / 2 + (104 + this.cardBigHeight / 2 - (208 - this.cardSmallHeight)) / 2, startX + 2 * (this.cardSmallWidth + cardsSpacing), 208 - this.cardSmallHeight);
        this.g.drawLine((176 - this.cardBigWidth) / 10 + this.cardBigWidth / 2, 104 + this.cardBigHeight / 2 + (104 + this.cardBigHeight / 2 - (208 - this.cardSmallHeight)) / 2, startX + 2 * (this.cardSmallWidth + cardsSpacing), 104 + this.cardBigHeight / 2 + (104 + this.cardBigHeight / 2 - (208 - this.cardSmallHeight)) / 2);
    }

    public void displaySelectedCard(int card) {
        this.displayCard(card, 0, 208 - this.cardBigHeight - this.cardSmallHeight - 15);
    }

    public void displayMiniCard(int card, int x, int y) {
        int cardColor = 0;
        switch (CardSet.CARD_LIST[card].getCardType()) {
            case 0: {
                cardColor = 16716947;
                break;
            }
            case 3: {
                cardColor = 255;
                break;
            }
            case 1: {
                cardColor = 4312599;
                break;
            }
            case 4: {
                cardColor = 0x444444;
                break;
            }
            case 2: {
                cardColor = 16743936;
            }
        }
        this.g.setClip(x + 1, y + 1, this.cardSmallWidth, this.cardSmallHeight);
        this.g.setColor(0);
        this.g.fillRect(x + 1, y + 1, this.cardSmallWidth, this.cardSmallHeight);
        this.g.setClip(x, y, this.cardSmallWidth, this.cardSmallHeight);
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(x, y, this.cardSmallWidth, this.cardSmallHeight);
        for (int i = 0; i < 2; ++i) {
            this.g.setColor(cardColor);
            this.g.drawRect(x + i, y + i, this.cardSmallWidth - 1 - 2 * i, this.cardSmallHeight - 1 - 2 * i);
        }
        this.g.setColor(0xCCCCCC);
        this.g.fillRect(x + 4, y + 4, this.cardIconSmallWidth, this.cardIconSmallHeight);
    }

    public void displayCardsInHand(Integer[] hand) {
        int cardsHandWidth = 176 - 6 * this.cardSmallWidth;
        int cardsSpacing = 0;
        int startX = 0;
        int cardPosition = 0;
        int cardOffset = 0;
        int destX = 0;
        int srcX = 0;
        int destX0 = 0;
        int srcX0 = 0;
        int destY = 0;
        int srcY = 0;
        int destY0 = 0;
        int srcY0 = 0;
        if (hand.length >= 3 && hand.length != 6) {
            cardOffset = 1;
        } else if (hand.length <= 2) {
            cardOffset = 2;
        }
        if (hand.length == 1) {
            cardOffset = 2;
            this.isMoveLeft = true;
            this.isMoveRight = false;
        }
        if (hand.length >= 3) {
            cardPosition = this.snakeSelectedCard - (2 - cardOffset);
            if (cardPosition < 0) {
                cardPosition += hand.length;
            }
        } else if (hand.length == 2) {
            cardPosition = this.snakeSelectedCard;
        } else if (hand.length == 1) {
            cardPosition = this.snakeSelectedCard;
        } else {
            cardPosition = this.snakeSelectedCard - (1 - cardOffset);
            if (cardPosition < 0) {
                cardPosition += hand.length;
            }
        }
        if (cardsHandWidth == 0) {
            cardsSpacing = 0;
        } else if (cardsHandWidth > 0) {
            startX = cardsSpacing = cardsHandWidth / 6;
        } else if (cardsHandWidth < 0) {
            cardsSpacing = -(Math.abs(cardsHandWidth) / 6);
        }
        if (this.isMoveRight) {
            if (hand.length == 2) {
                srcX0 = startX + (-1 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                destX0 = startX + (0 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
            } else {
                srcX0 = startX + (0 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                destX0 = startX + (-1 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
            }
            srcY0 = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
            destY0 = 208 - (this.cardSmallHeight - this.cardSmallHeight / 2) + 2;
        } else {
            srcX0 = startX + (-1 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
            destX0 = startX + (0 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
            srcY0 = 208 - (this.cardSmallHeight - this.cardSmallHeight / 2) + 2;
            destY0 = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
        }
        int stepY = Math.abs(destY0 - srcY0) / ((this.cardSmallHeight - 2) / 4);
        int stepX = (destX0 - srcX0) / ((this.cardSmallHeight - 2) / 4);
        if (this.isMoveRight) {
            this.cardMoveX -= stepX;
            this.cardMoveY += stepY;
        } else {
            this.cardMoveX += stepX;
            this.cardMoveY -= stepY;
        }
        if (hand.length == 2) {
            this.cardMoveX = 0;
        }
        for (int i = 0; i < hand.length; ++i) {
            if (this.isMoveRight) {
                if (hand.length != 2) {
                    srcX = startX + (i + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                    destX = startX + (i - 1 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                } else {
                    srcX = startX + (i - 1 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                    destX = startX + (i + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                }
            } else {
                srcX = startX + (i - 1 + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
                destX = startX + (i + cardOffset) * (this.cardSmallWidth + cardsSpacing) + this.cardSmallWidth / 2 * cardOffset;
            }
            if (hand[i] == null) break;
            if (cardPosition >= hand.length) {
                cardPosition = 0;
            }
            switch (i + cardOffset) {
                case 1: {
                    if (this.isMoveRight) {
                        destY = srcY = 208 - this.cardSmallHeight + 2;
                        break;
                    }
                    destY = srcY = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
                    break;
                }
                case 2: {
                    if (this.isMoveRight) {
                        destY = srcY = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
                        break;
                    }
                    destY = srcY = 208 - this.cardSmallHeight + 2;
                    break;
                }
                default: {
                    if (this.isMoveRight) {
                        srcY = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
                        destY = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
                        break;
                    }
                    destY = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
                    srcY = 208 - (this.cardSmallHeight - this.cardSmallHeight / 4) + 2;
                }
            }
            if (hand.length == 2) {
                destX = srcX;
            }
            if (hand.length == 1) {
                int n;
                this.blockKeyPress = false;
                int n2 = hand[cardPosition];
                int n3 = srcX + this.cardSmallWidth / 2;
                if (isCardsFadeIn && this.miniCardStartPosY >= 0) {
                    n = this.miniCardStartPosY - this.miniCardStepY;
                    this.miniCardStartPosY = this.miniCardStartPosY;
                } else if (isCardsFadeOut && this.miniCardStartPosY < 208) {
                    n = this.miniCardStartPosY + this.miniCardStepY;
                    this.miniCardStartPosY = this.miniCardStartPosY;
                } else {
                    n = 0;
                }
                this.displayMiniCard(n2, n3, destY + n);
            } else if (this.isMoveLeft && srcY0 + this.cardMoveY > destY0 && hand.length != 1) {
                if (i + cardOffset <= 2 && i + cardOffset != 0) {
                    this.displayMiniCard(hand[cardPosition], srcX + this.cardMoveX, srcY + this.cardMoveY);
                    if (hand.length == 4 && i + cardOffset == 1) {
                        this.displayMiniCard(hand[cardPosition], srcX + this.cardMoveX + hand.length * (this.cardSmallWidth + cardsSpacing), destY + this.cardSmallHeight / 4 - this.cardMoveY);
                    }
                    if (hand.length < 4 && i + cardOffset == 1) {
                        this.displayMiniCard(hand[cardPosition], srcX + this.cardMoveX + hand.length * (this.cardSmallWidth + cardsSpacing), destY - this.cardMoveY);
                    }
                } else if (i + cardOffset == 3 || i + cardOffset == 5 || i + cardOffset == 4 && hand.length <= 5) {
                    this.displayMiniCard(hand[cardPosition], srcX + this.cardMoveX, srcY - this.cardMoveY);
                } else if (i + cardOffset == 4 || i + cardOffset == 0) {
                    this.displayMiniCard(hand[cardPosition], srcX + this.cardMoveX, destY);
                }
            } else if (this.isMoveRight && srcY0 + this.cardMoveY < destY0 && hand.length != 1) {
                if (i + cardOffset <= 2) {
                    this.displayMiniCard(hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1], srcX - this.cardMoveX, srcY + this.cardMoveY);
                    if (hand.length == 4 && i + cardOffset <= 1) {
                        this.displayMiniCard(hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1], srcX - this.cardMoveX + hand.length * (this.cardSmallWidth + cardsSpacing), destY + this.cardSmallHeight / 4 - this.cardMoveY);
                    }
                    if (hand.length < 4 && i + cardOffset <= 1) {
                        this.displayMiniCard(hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1], srcX - this.cardMoveX + hand.length * (this.cardSmallWidth + cardsSpacing), destY - this.cardMoveY);
                    }
                } else if (i + cardOffset == 3 || i + cardOffset == 5 && hand.length == 6 || i + cardOffset == 4 && hand.length <= 5) {
                    this.displayMiniCard(hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1], srcX - this.cardMoveX, srcY - this.cardMoveY);
                } else if (i + cardOffset == 4 || i + cardOffset == 5 && hand.length <= 5) {
                    this.displayMiniCard(hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1], srcX - this.cardMoveX, destY);
                }
                if ((i + cardOffset == 3 || i + cardOffset == 5) && hand.length == 6) {
                    this.displayMiniCard(hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1], srcX - this.cardMoveX, srcY - this.cardMoveY);
                }
            } else {
                if (this.isMoveRight) {
                    if (i + cardOffset != 1 || hand.length > 4) {
                        int n;
                        int n4 = hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1];
                        if (isCardsFadeIn && this.miniCardStartPosY >= 0) {
                            n = this.miniCardStartPosY - this.miniCardStepY;
                            this.miniCardStartPosY = this.miniCardStartPosY;
                        } else if (isCardsFadeOut && this.miniCardStartPosY < 208) {
                            n = this.miniCardStartPosY + this.miniCardStepY;
                            this.miniCardStartPosY = this.miniCardStartPosY;
                        } else {
                            n = 0;
                        }
                        this.displayMiniCard(n4, destX, destY + n);
                    }
                    if (hand.length < 4 && i + cardOffset <= 1 || hand.length == 6 && i + cardOffset == 0) {
                        int n;
                        int n5 = hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1];
                        int n6 = destX + hand.length * (this.cardSmallWidth + cardsSpacing);
                        if (isCardsFadeIn && this.miniCardStartPosY >= 0) {
                            n = this.miniCardStartPosY - this.miniCardStepY;
                            this.miniCardStartPosY = this.miniCardStartPosY;
                        } else if (isCardsFadeOut && this.miniCardStartPosY < 208) {
                            n = this.miniCardStartPosY + this.miniCardStepY;
                            this.miniCardStartPosY = this.miniCardStartPosY;
                        } else {
                            n = 0;
                        }
                        this.displayMiniCard(n5, n6, srcY + n);
                    }
                    if (hand.length == 4 && i + cardOffset <= 1 || hand.length == 6 && i + cardOffset == 0) {
                        int n;
                        int n7 = hand[cardPosition - 1 < 0 ? hand.length - 1 : cardPosition - 1];
                        int n8 = destX + hand.length * (this.cardSmallWidth + cardsSpacing);
                        int n9 = srcY + this.cardSmallHeight / 4;
                        if (isCardsFadeIn && this.miniCardStartPosY >= 0) {
                            n = this.miniCardStartPosY - this.miniCardStepY;
                            this.miniCardStartPosY = this.miniCardStartPosY;
                        } else if (isCardsFadeOut && this.miniCardStartPosY < 208) {
                            n = this.miniCardStartPosY + this.miniCardStepY;
                            this.miniCardStartPosY = this.miniCardStartPosY;
                        } else {
                            n = 0;
                        }
                        this.displayMiniCard(n7, n8, n9 + n);
                    }
                } else if (i + cardOffset == 5 && hand.length <= 5) {
                    int n;
                    int n10 = hand[cardPosition];
                    int n11 = destX - hand.length * (this.cardSmallWidth + cardsSpacing);
                    if (isCardsFadeIn && this.miniCardStartPosY >= 0) {
                        n = this.miniCardStartPosY - this.miniCardStepY;
                        this.miniCardStartPosY = this.miniCardStartPosY;
                    } else if (isCardsFadeOut && this.miniCardStartPosY < 208) {
                        n = this.miniCardStartPosY + this.miniCardStepY;
                        this.miniCardStartPosY = this.miniCardStartPosY;
                    } else {
                        n = 0;
                    }
                    this.displayMiniCard(n10, n11, destY + n);
                } else {
                    int n;
                    int n12 = hand[cardPosition];
                    if (isCardsFadeIn && this.miniCardStartPosY >= 0) {
                        n = this.miniCardStartPosY - this.miniCardStepY;
                        this.miniCardStartPosY = this.miniCardStartPosY;
                    } else if (isCardsFadeOut && this.miniCardStartPosY < 208) {
                        n = this.miniCardStartPosY + this.miniCardStepY;
                        this.miniCardStartPosY = this.miniCardStartPosY;
                    } else {
                        n = 0;
                    }
                    this.displayMiniCard(n12, destX, destY + n);
                }
                this.blockKeyPress = false;
            }
            ++cardPosition;
        }
    }

    public void moveCardsLeft() {
        this.cardMoveX = 0;
        this.cardMoveY = 0;
        this.isMoveLeft = true;
        this.isMoveRight = false;
        this.blockKeyPress = true;
        this.cardDescStartTime = 0L;
    }

    public void moveCardsRight() {
        this.cardMoveX = 0;
        this.cardMoveY = 0;
        this.isMoveRight = true;
        this.isMoveLeft = false;
        this.blockKeyPress = true;
        this.cardDescStartTime = 0L;
    }

    public boolean isKeyBlocked() {
        return this.blockKeyPress;
    }

    public void resetCardAnimation() {
        this.cardMoveX = 0;
        this.cardMoveY = 0;
    }

    public void displayCardsOn() {
        this.canDisplayCards = true;
    }

    public void displayCardsOff() {
        this.canDisplayCards = false;
    }

    private void displayContextualIcon() {
        int softkeyWidth = Constants.SOFTKEYS_IMAGE_WIDTHS[0] + 52;
        int softkeyRightX = 176 - softkeyWidth;
        int softkeyRightY = 193;
        boolean softkeyLeftX = false;
        int softkeyLeftY = 193;
        int iconWidth = PSCanvas.imageWidth[51] / 4;
        int iconHeight = PSCanvas.imageHeight[51];
        switch (this.ingameStates) {
            case 14: {
                if (this.hasSnakePunched || !this.canSnakePunch) break;
                this.g.setClip(88 - iconWidth / 2, 208 - iconHeight - (iconHeight / 2 - 4), iconWidth, iconHeight);
                this.g.drawImage(PSCanvas.imageArray[51], 88 - iconWidth / 2 - 2 * iconWidth, 208 - iconHeight - (iconHeight / 2 - 4));
                this.g.setClip(88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6, Constants.HUD_ZERO_STAR_ICON_WIDTH[0], 9);
                this.g.drawImage(PSCanvas.imageArray[54], 88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6);
                break;
            }
            case 13: {
                if (this.isSnakeCrawled) {
                    this.g.setClip(88 - iconWidth / 2, 208 - iconHeight - (iconHeight / 2 - 4), iconWidth, iconHeight);
                    this.g.drawImage(PSCanvas.imageArray[51], 88 - iconWidth - iconWidth / 2, 208 - iconHeight - (iconHeight / 2 - 4));
                    this.g.setClip(88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6, Constants.HUD_ZERO_STAR_ICON_WIDTH[0], 9);
                    this.g.drawImage(PSCanvas.imageArray[54], 88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6);
                    break;
                }
                if (this.isSnakeFlattened) {
                    if (this.hasSnakeKnocked) break;
                    this.g.setClip(88 - iconWidth / 2, 208 - iconHeight - (iconHeight / 2 - 4), iconWidth, iconHeight);
                    this.g.drawImage(PSCanvas.imageArray[51], 88 - iconWidth / 2 - 3 * iconWidth, 208 - iconHeight - (iconHeight / 2 - 4));
                    this.g.setClip(88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6, Constants.HUD_ZERO_STAR_ICON_WIDTH[0], 9);
                    this.g.drawImage(PSCanvas.imageArray[54], 88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6);
                    break;
                }
                if (GameBoard.snake.getEquipment(11) != -1) break;
                this.g.setClip(88 - iconWidth / 2, 208 - iconHeight - (iconHeight / 2 - 4), iconWidth, iconHeight);
                this.g.drawImage(PSCanvas.imageArray[51], 88 - iconWidth / 2, 208 - iconHeight - (iconHeight / 2 - 4));
                this.g.setClip(88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6, Constants.HUD_ZERO_STAR_ICON_WIDTH[0], 9);
                this.g.drawImage(PSCanvas.imageArray[54], 88 + iconWidth / 2 - 2 * (Constants.HUD_ZERO_STAR_ICON_WIDTH[0] / 3), 208 - iconHeight - 6);
                break;
            }
        }
    }

    private void displaySoftkeys() {
        int softkeyWidth = Constants.SOFTKEYS_IMAGE_WIDTHS[0] + 52;
        int softkeyRightX = 176 - softkeyWidth;
        int softkeyRightY = 193;
        int softkeyLeftX = 0;
        int softkeyLeftY = 193;
        int iconWidth = PSCanvas.imageWidth[51] / 4;
        int iconHeight = PSCanvas.imageHeight[51];
        this.g.setColor(0);
        this.g.setClip(softkeyLeftX, softkeyLeftY, 176, 15);
        this.g.fillRect(softkeyLeftX, softkeyLeftY, 176, 15);
        switch (this.ingameStates) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: {
                if (this.playerStatusArray[0][2] > 0 && this.playerStatusArray[0][6] > 0 || this.ingameMenuCurrentState == 3 || this.ingameStates != 15) {
                    if (this.ingameStates == 13) {
                        if (!this.canSnakeCancelMove) {
                            this.g.setClip(softkeyLeftX + 2, softkeyLeftY, Constants.SOFTKEYS_IMAGE_WIDTHS[3], 15);
                            this.g.drawImage(PSCanvas.imageArray[41], softkeyLeftX - Constants.SOFTKEYS_IMAGE_OFFSETS[3] + 2, softkeyLeftY);
                        }
                    } else {
                        this.g.setClip(softkeyLeftX + 2, softkeyLeftY, Constants.SOFTKEYS_IMAGE_WIDTHS[3], 15);
                        this.g.drawImage(PSCanvas.imageArray[41], softkeyLeftX - Constants.SOFTKEYS_IMAGE_OFFSETS[3] + 2, softkeyLeftY);
                    }
                }
                if (this.ingameStates == 22 || this.ingameStates == 17 || this.ingameStates == 29 && PSCanvas.demoMode != 2) break;
                this.g.setClip(softkeyRightX + Constants.SOFTKEYS_IMAGE_WIDTHS[0] + 52 - (Constants.SOFTKEYS_IMAGE_WIDTHS[6] + 2), softkeyRightY, Constants.SOFTKEYS_IMAGE_WIDTHS[6], 15);
                this.g.drawImage(PSCanvas.imageArray[41], softkeyRightX - Constants.SOFTKEYS_IMAGE_OFFSETS[6] + Constants.SOFTKEYS_IMAGE_WIDTHS[0] + 52 - (Constants.SOFTKEYS_IMAGE_WIDTHS[6] + 2), softkeyRightY);
            }
        }
        this.g.setClip(0, 0, 176, 208);
        PSCanvas.fontEngine.setSpacing(1);
        switch (this.ingameStates) {
            case 15: {
                if (this.ingameMenuCurrentState == 3) {
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[6], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                } else if (this.playerStatusArray[0][2] != 0 && this.playerStatusArray[0][6] != 0) {
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[12], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                }
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[13], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 14: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[19], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[17], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 13: {
                if (this.isSnakeCrawled) {
                    if (!this.canSnakeCancelMove) {
                        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                    }
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[18], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                    break;
                }
                if (this.isSnakeFlattened) {
                    if (!this.canSnakeCancelMove) {
                        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                    }
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[17], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                    break;
                }
                if (!this.canSnakeCancelMove) {
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                }
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[18], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 7: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[10], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[13], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 4: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[20], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[10], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 16: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[6], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[13], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 29: {
                if (PSCanvas.demoMode == 2) {
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[21], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                }
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[10], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                break;
            }
            case 22: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[6], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                break;
            }
            case 2: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[15], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[8], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 20: 
            case 23: {
                String tmpString = "";
                tmpString = PSCanvas.gameSpeed == 3 ? tmpString + "-" : tmpString + "+";
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[22] + tmpString, softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[8], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 1: 
            case 27: {
                if (this.dialogDisplayIndex + 3 >= this.dialogs.size() || this.dialogs.size() == 3) {
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[15], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                    PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[14], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                    break;
                }
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[15], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[16], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 24: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[5], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[5], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 9: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[5], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 10: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[9], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[5], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 25: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[6], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[5], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 18: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[10], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[16], 176 - Constants.SOFTKEYS_IMAGE_WIDTHS[6] - 4, softkeyRightY + 7, 37);
                break;
            }
            case 17: {
                PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[6], softkeyLeftX + Constants.SOFTKEYS_IMAGE_WIDTHS[3] + 4, softkeyLeftY + 7, 35);
                break;
            }
        }
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displaySelectTarget() {
        int x = 88;
        int y = 173;
        PSCanvas.fontEngine.setSpacing(2);
        int textHeight = PSCanvas.fontEngine.getTextHeight(2, PSCanvas.textArray[473], 159) + 2;
        int textWidth = PSCanvas.fontEngine.getTextMaxLineWidth(2, PSCanvas.textArray[473], 159) + 2;
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(x - 1 - 4 - textWidth / 2, y - textHeight - 8, 8 + textWidth, 8 + textHeight);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x - 1 - 4 - textWidth / 2, y - textHeight - 8, 8 + textWidth - 1, 8 + textHeight - 1);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[473], x, y - (8 + textHeight) / 2, textWidth, 40);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displayConfirmationTurn() {
        int x = 88;
        int y = 104 + this.playerStatusArray[0][10] / 2;
        PSCanvas.fontEngine.setSpacing(2);
        this.g.setClip(0, 0, 176, 208);
        int textHeight = PSCanvas.fontEngine.getTextHeight(2, PSCanvas.textArray[472], 159);
        int textWidth = PSCanvas.fontEngine.getTextMaxLineWidth(2, PSCanvas.textArray[472], 159);
        this.g.setColor(0);
        this.g.fillRect(x - textWidth / 2 - 4, y - textHeight / 2 - 4, 8 + textWidth, 8 + textHeight);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x - textWidth / 2 - 4, y - textHeight / 2 - 4, 8 + textWidth - 1, 8 + textHeight - 1);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[472], x, y, textWidth, 160);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displayMessage() {
        int x = 88;
        int y = 104;
        PSCanvas.fontEngine.setSpacing(2);
        int textHeight = PSCanvas.fontEngine.getTextHeight(2, PSCanvas.textArray[this.textMessageIndex], 159);
        int textWidth = PSCanvas.fontEngine.getTextMaxLineWidth(2, PSCanvas.textArray[this.textMessageIndex], 159);
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(x - textWidth / 2 - 4, y - textHeight / 2 - 4, 8 + textWidth, 8 + textHeight);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x - textWidth / 2 - 4, y - textHeight / 2 - 4, 8 + textWidth - 1, 8 + textHeight - 1);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[this.textMessageIndex], x, y, textWidth, 160);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displayMessagePause() {
        int x = 88;
        int y = 163;
        PSCanvas.fontEngine.setSpacing(2);
        int textHeight = PSCanvas.fontEngine.getTextHeight(2, PSCanvas.textArray[527], 159);
        int textWidth = PSCanvas.fontEngine.getTextMaxLineWidth(2, PSCanvas.textArray[527], 159);
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(x - textWidth / 2 - 4, y - textHeight / 2 - 4, 8 + textWidth, 8 + textHeight);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x - textWidth / 2 - 4, y - textHeight / 2 - 4, 8 + textWidth - 1, 8 + textHeight - 1);
        PSCanvas.fontEngine.setSpacing(2);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[527], x, y, textWidth, 160);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displayMessageCard() {
        int x = 88;
        int y = 104;
        PSCanvas.fontEngine.setSpacing(2);
        int textHeight = PSCanvas.fontEngine.getTextHeight(2, PSCanvas.textArray[this.textMessageIndex], 80);
        int textWidth = PSCanvas.fontEngine.getTextMaxLineWidth(2, PSCanvas.textArray[this.textMessageIndex], 80);
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(x - 4, y - textHeight / 2 - 4, 8 + textWidth, 8 + textHeight);
        this.g.setColor(0xFFFFFF);
        this.g.drawRect(x - 4, y - textHeight / 2 - 4, 8 + textWidth - 1, 8 + textHeight - 1);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[this.textMessageIndex], x + textWidth / 2, y - textHeight / 2, textWidth, 144);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void displayMessageBar(String text) {
        this.g.setClip(0, 89, 176, 30);
        this.g.setColor(0x343434);
        this.g.fillRect(0, 89, 176, 30);
        this.g.setColor(0);
        this.g.fillRect(0, 96, 176, 15);
        PSCanvas.fontEngine.setSpacing(2);
        PSCanvas.fontEngine.drawFont(this.g, 2, text, 88, 104, 40);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void setMessage(int textIndex) {
        this.textMessageIndex = textIndex;
    }

    public void updateCheckGameState(int states, int lastState) {
        this.ingameStates = states;
        this.ingameLastState = lastState;
    }

    public void loadDialogText(int[] dialogIndex) {
        this.dialogs = new Vector();
        this.dialogDisplayIndex = 0;
        for (int j = 0; j < dialogIndex.length; j += 3) {
            String[] pages = PSCanvas.fontEngine.wrapTextPages(0, PSCanvas.textArray[dialogIndex[j]].toUpperCase(), 147, 3);
            for (int i = 0; i < pages.length; ++i) {
                switch (dialogIndex[j + 1]) {
                    case 285: {
                        this.dialogs.addElement(new Integer(2));
                        break;
                    }
                    case 286: {
                        this.dialogs.addElement(new Integer(4));
                        break;
                    }
                    case 288: {
                        this.dialogs.addElement(new Integer(1));
                        break;
                    }
                    case 289: {
                        this.dialogs.addElement(new Integer(8));
                        break;
                    }
                    case 290: {
                        this.dialogs.addElement(new Integer(5));
                        break;
                    }
                    case 291: {
                        this.dialogs.addElement(new Integer(6));
                        break;
                    }
                    case 292: {
                        this.dialogs.addElement(new Integer(7));
                        break;
                    }
                    case 294: {
                        this.dialogs.addElement(new Integer(3));
                        break;
                    }
                    default: {
                        this.dialogs.addElement(new Integer(-1));
                    }
                }
                this.dialogs.addElement(new Integer(dialogIndex[j + 1]));
                this.dialogs.addElement(pages[i]);
                this.dialogs.addElement(new Integer(dialogIndex[j + 2]));
            }
        }
        this.isDialogOver = false;
    }

    public void unloadDialogText() {
        this.dialogs.removeAllElements();
        this.dialogs.trimToSize();
        this.dialogDisplayIndex = 0;
        this.isDialogOver = true;
    }

    public void nextDialogText() {
        this.dialogDisplayIndex += 4;
        if (this.dialogDisplayIndex >= this.dialogs.size()) {
            this.dialogDisplayIndex = 0;
            this.isDialogOver = true;
        }
        this.isDialogChanged = true;
    }

    public boolean isDialogOver() {
        return this.isDialogOver;
    }

    public void endDialog() {
        this.isDialogOver = true;
    }

    public void displayDialog() {
        int x = 4;
        int y = 185 - this.dialogHeight;
        int fontHeight = PSCanvas.fontEngine.getFontHeight(0);
        int textBoxHeight = fontHeight + 2;
        int textDialogOffset = x + 8;
        int textBoxWidth = PSCanvas.fontEngine.getTextLength(0, PSCanvas.textArray[(Integer)this.dialogs.elementAt(this.dialogDisplayIndex + 1)].toUpperCase()) + 8;
        this.g.setColor(0);
        this.g.setClip(x, y, this.dialogWidth, this.dialogHeight);
        this.g.fillRect(x, y, this.dialogWidth, this.dialogHeight);
        this.g.setColor(0x343434);
        this.g.setClip(x + 2, y + 2, this.dialogWidth - 4, this.dialogHeight - 4);
        this.g.fillRect(x + 2, y + 2, this.dialogWidth - 4, this.dialogHeight - 4);
        PSCanvas.fontEngine.drawFont(this.g, 0, ((String)this.dialogs.elementAt(this.dialogDisplayIndex + 2)).toUpperCase(), textDialogOffset, y + (this.dialogHeight / 2 - 3 * fontHeight / 2), 147, 19);
        if ((Integer)this.dialogs.elementAt(this.dialogDisplayIndex + 3) == 0) {
            this.g.setClip(x, y, textBoxWidth, textBoxHeight);
            this.g.setColor(0);
            this.g.fillRect(x, y, textBoxWidth, textBoxHeight);
            this.g.setClip(x += textBoxWidth, y, textBoxHeight, textBoxHeight);
            for (int i = textBoxHeight; i > 0; --i) {
                this.g.fillRect(x + (textBoxHeight - i), y, 1, i);
            }
            PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[(Integer)this.dialogs.elementAt(this.dialogDisplayIndex + 1)].toUpperCase(), (x -= textBoxWidth) + 4, y + textBoxHeight / 2, 35);
        } else {
            this.g.setClip((x += this.dialogWidth) - textBoxWidth, y, textBoxWidth, textBoxHeight);
            this.g.setColor(0);
            this.g.fillRect(x - textBoxWidth, y, textBoxWidth, textBoxHeight);
            this.g.setClip((x -= textBoxWidth) - textBoxHeight, y, textBoxHeight, textBoxHeight);
            for (int i = textBoxHeight; i > 0; --i) {
                this.g.fillRect(x - (textBoxHeight - i), y, 1, i);
            }
            PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[(Integer)this.dialogs.elementAt(this.dialogDisplayIndex + 1)].toUpperCase(), (x += textBoxWidth) - 4, y + textBoxHeight / 2, 37);
        }
    }

    private void displayStateHelp() {
        int i;
        PSCanvas.fontEngine.setSpacing(1);
        int textOptionsLength = PSCanvas.fontEngine.getTextLength(1, PSCanvas.textArray[536].toUpperCase());
        int fontHeight = PSCanvas.fontEngine.getFontHeight(0);
        int pointsWidth = PSCanvas.fontEngine.getTextLength(1, "0000000");
        int x = 0;
        int y = 0;
        this.g.setClip(x, y, 176, 208);
        this.g.setColor(15659277);
        this.g.fillRect(x, y, 176, 208);
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(x, y, 176, 12);
        this.g.setColor(0);
        this.g.drawLine(x, 12, 176, 12);
        PSCanvas.fontEngine.drawFont(this.g, 1, PSCanvas.textArray[536].toUpperCase(), x += 88, 6, 41);
        y += 27;
        x = 25;
        this.g.setColor(0);
        for (i = 0; i < 6; ++i) {
            this.g.fillRect(x - 6 + i, y + (3 * fontHeight / 2 - 6) + 6 - i, 6 - i + 1, 1);
            this.g.fillRect(x - 6 + i, y + (3 * fontHeight / 2 - 6) + 6 + i, 6 - i + 1, 1);
        }
        x = 151;
        this.g.setColor(0);
        for (i = 0; i < 6; ++i) {
            this.g.fillRect(x, y + (3 * fontHeight / 2 - 6) + 6 - i, 6 - i + 1, 1);
            this.g.fillRect(x, y + (3 * fontHeight / 2 - 6) + 6 + i, 6 - i + 1, 1);
        }
        this.g.setColor(0);
        this.g.setStrokeStyle(PSGraphics.SOLID);
        this.g.drawRect(30, y, 117, 3 * fontHeight);
        PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[537 + this.helpCategoryIndex], 88, y + 3 * fontHeight / 2, 112, 160);
        this.g.setColor(0);
        this.g.drawRect(29, (y += 15 + 3 * fontHeight) - 1, 118, 13 * fontHeight + 1);
        x = 151;
        if (this.helpPagesIndex > 0) {
            this.g.setColor(0);
            for (i = 0; i < 6; ++i) {
                this.g.fillRect(x + 6 + i, y + 6 + i, 1, 6 - i + 1);
                this.g.fillRect(x + 6 - i, y + 6 + i, 1, 6 - i + 1);
            }
        }
        PSCanvas.fontEngine.drawFont(this.g, 0, this.helpTextPages[this.helpPagesIndex], 32, y + fontHeight / 2, 112, 19);
        y += 13 * fontHeight - 6;
        if (this.helpTextPages.length > 1 && this.helpPagesIndex < this.helpTextPages.length - 1) {
            this.g.setColor(0);
            this.g.setClip(0, 0, 176, 208);
            for (i = 0; i < 6; ++i) {
                this.g.fillRect(x + 6 + i, y, 1, 6 - i + 1);
                this.g.fillRect(x + 6 - i, y, 1, 6 - i + 1);
            }
        }
    }

    public void displayIntermissionDialog() {
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(0, 0, 176, 208);
        PSCanvas.fontEngine.setSpacing(1);
        PSCanvas.fontEngine.drawFont(this.g, 0, PSCanvas.textArray[535], 88, 52, 41);
        PSCanvas.fontEngine.resetSpacing();
        this.displayDialog();
    }

    public void nextHelpPage() {
        --this.helpCategoryIndex;
        if (this.helpCategoryIndex < 0) {
            this.helpCategoryIndex = 4;
        }
        this.loadHelpText(542 + this.helpCategoryIndex);
    }

    public void prevHelpPage() {
        ++this.helpCategoryIndex;
        if (this.helpCategoryIndex > 4) {
            this.helpCategoryIndex = 0;
        }
        this.loadHelpText(542 + this.helpCategoryIndex);
    }

    public void helpPageUp() {
        if (this.helpTextPages.length > 1) {
            --this.helpPagesIndex;
            if (this.helpPagesIndex < 0) {
                this.helpPagesIndex = 0;
            }
        }
    }

    public void helpPageDown() {
        if (this.helpTextPages.length > 1) {
            ++this.helpPagesIndex;
            if (this.helpPagesIndex > this.helpTextPages.length - 1) {
                this.helpPagesIndex = this.helpTextPages.length - 1;
            }
        }
    }

    public void loadHelpText(int descText) {
        this.helpPagesIndex = 0;
        PSCanvas.fontEngine.setSpacing(1);
        this.helpTextPages = PSCanvas.fontEngine.wrapTextPages(0, PSCanvas.textArray[descText], 107, 12);
        PSCanvas.fontEngine.resetSpacing();
    }

    public void unloadHelpText() {
        this.helpPagesIndex = 0;
        this.helpCategoryIndex = 0;
        this.helpTextPages = null;
    }

    public void displayDemo() {
        this.g.setClip(0, 0, 176, 208);
        this.g.setColor(0);
        this.g.fillRect(0, 0, 176, 208);
        PSCanvas.fontEngine.setSpacing(1);
        PSCanvas.fontEngine.drawFont(this.g, 2, PSCanvas.textArray[572].toUpperCase() + "|" + PSCanvas.demoUrl.toUpperCase(), 84, 104, 164, 40);
        PSCanvas.fontEngine.resetSpacing();
    }
}

