/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Deck {
    private Vector deckCards;
    private Vector usedDeckCards;
    private Vector handCards;
    private int tmpCard;
    private int deckSize;
    private int selectedCard = -1;
    private boolean isAiDeck = false;

    public Deck(int size, boolean aiDeck) {
        this.deckSize = size;
        this.deckCards = new Vector(size);
        this.usedDeckCards = new Vector();
        this.handCards = new Vector();
        this.isAiDeck = aiDeck;
    }

    public void addCardToDeck(int card) {
        if (this.deckCards.size() <= this.deckSize) {
            if (!this.isAiDeck) {
                CardSet.CARD_LIST[card].setCardsInDeckAmount(CardSet.CARD_LIST[card].getCardsInDeckAmount() + 1);
            }
            this.deckCards.addElement(new Integer(card));
        }
    }

    public void addInitCardToDeck(int card) {
        if (this.deckCards.size() <= this.deckSize) {
            this.deckCards.addElement(new Integer(card));
        }
    }

    public void removeCardFromDeck(int card) {
        if (!this.isAiDeck && CardSet.CARD_LIST[card].getCardsInDeckAmount() > 0) {
            CardSet.CARD_LIST[card].setCardsInDeckAmount(CardSet.CARD_LIST[card].getCardsInDeckAmount() - 1);
        }
        this.deckCards.removeElement(new Integer(card));
        this.deckCards.trimToSize();
    }

    public void removeAllCardFromDeck() {
        int card = 0;
        if (!this.isAiDeck) {
            for (int i = 0; i < this.deckCards.size(); ++i) {
                card = (Integer)this.deckCards.elementAt(i);
                if (CardSet.CARD_LIST[card].getCardsInDeckAmount() <= 0) continue;
                CardSet.CARD_LIST[card].setCardsInDeckAmount(0);
            }
        }
        this.deckCards.removeAllElements();
        this.deckCards.trimToSize();
    }

    public void discardCardsFromHand(int amountDiscard, int drawAmount) {
        this.handCards.trimToSize();
        if (this.handCards.size() != 0) {
            for (int i = 0; i < (this.handCards.size() <= amountDiscard ? this.handCards.size() : amountDiscard); ++i) {
                this.usedDeckCards.addElement(this.handCards.elementAt(i));
            }
            this.handCards.removeAllElements();
            this.handCards.trimToSize();
        }
        this.drawCards(drawAmount);
        if (this.handCards.size() == 0) {
            this.selectedCard = -1;
        } else if (this.selectedCard >= this.handCards.size()) {
            this.selectedCard = this.handCards.lastIndexOf(this.handCards.lastElement());
        }
    }

    public void drawCards(int numberCards) {
        for (int i = 0; i < numberCards; ++i) {
            if (this.handCards.size() >= 6) continue;
            if (this.deckCards.size() == 0) {
                this.reShuffleDeck();
            }
            this.tmpCard = (Integer)this.deckCards.firstElement();
            this.deckCards.removeElement(new Integer(this.tmpCard));
            this.handCards.addElement(new Integer(this.tmpCard));
        }
        this.deckCards.trimToSize();
    }

    public void reShuffleDeck() {
        this.deckCards.trimToSize();
        while (this.usedDeckCards.size() > 0) {
            int cardIndex = PSCanvas.getRandom(0, this.usedDeckCards.size() - 1);
            this.deckCards.addElement((Integer)this.usedDeckCards.elementAt(cardIndex));
            this.usedDeckCards.removeElementAt(cardIndex);
            this.usedDeckCards.trimToSize();
        }
    }

    public void shuffleDeck() {
        int i;
        this.deckCards.trimToSize();
        for (i = 0; i < this.handCards.size(); ++i) {
            this.usedDeckCards.addElement((Integer)this.handCards.elementAt(i));
        }
        this.handCards.removeAllElements();
        this.handCards.trimToSize();
        if (this.deckCards.size() > 0) {
            for (i = 0; i < this.deckCards.size(); ++i) {
                this.usedDeckCards.addElement((Integer)this.deckCards.elementAt(i));
            }
        }
        this.deckCards.removeAllElements();
        this.deckCards.trimToSize();
        while (this.usedDeckCards.size() > 0) {
            int cardIndex = PSCanvas.getRandom(0, this.usedDeckCards.size() - 1);
            this.deckCards.addElement((Integer)this.usedDeckCards.elementAt(cardIndex));
            this.usedDeckCards.removeElementAt(cardIndex);
            this.usedDeckCards.trimToSize();
        }
    }

    public void getCardsFromHand(Integer[] cards) {
        int size = this.handCards.size();
        if (size > 0) {
            this.handCards.copyInto(cards);
        }
    }

    public int getSelectedCardIndex() {
        return this.selectedCard;
    }

    public void selectNextCard() {
        if (this.selectedCard == -1) {
            this.selectedCard = 0;
        } else {
            ++this.selectedCard;
            if (this.selectedCard >= this.handCards.size()) {
                this.selectedCard = 0;
            }
        }
    }

    public void selectPrevCard() {
        if (this.selectedCard == -1 || this.selectedCard == 0) {
            this.selectedCard = this.handCards.size() - 1;
        } else {
            --this.selectedCard;
            if (this.selectedCard < 0) {
                this.selectedCard = this.handCards.size() - 1;
            }
        }
    }

    public int getSelectedCard() {
        if (this.handCards != null && !this.handCards.isEmpty() && this.selectedCard != -1) {
            return (Integer)this.handCards.elementAt(this.selectedCard);
        }
        return -1;
    }

    public void resetCardSelection() {
        this.selectedCard = -1;
    }

    public void useSelectedCard() {
        if (this.handCards.size() != 0) {
            this.usedDeckCards.addElement(new Integer(this.getSelectedCard()));
            this.handCards.removeElementAt(this.getSelectedCardIndex());
            this.handCards.trimToSize();
        }
        if (this.handCards.size() == 0) {
            this.selectedCard = -1;
        } else if (this.selectedCard >= this.handCards.size()) {
            this.selectedCard = this.handCards.lastIndexOf(this.handCards.lastElement());
        }
    }

    public int getHandCardsCount() {
        return this.handCards.size();
    }

    public int getDeckCardsLeftNumber() {
        return this.deckCards.size();
    }

    public int getDeckSize() {
        return this.deckSize;
    }

    public void setDeckSize(int size) {
        this.deckSize = size;
    }
}

