/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;

public class PSSprite
implements IPSSprite,
PSSpriteConstants {
    private boolean loaded = false;
    private short moduleNumber;
    private short modulesInFramesNumber;
    private short[] modules;
    private short[] modulesInFrames;
    private short frameNumber;
    private short framesInAnimationsNumber;
    private short[] frames;
    private short[] framesInAnimations;
    private short animationNumber;
    private short[] animations;
    private static Image[] moduleImages;
    private static final byte MODULE_SIZE = 6;
    private static final byte FRAME_SIZE = 3;
    private static final byte MODULE_IN_FRAME_SIZE = 4;
    private static final byte ANIMATION_SIZE = 4;
    private static final byte FRAME_IN_ANIMATION_SIZE = 3;
    private static int TRANS_MIRROR;
    private static int TRANS_MIRROR_ROT180;
    private static int TRANS_ROT180;

    public void load(String fileName) {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(fileName));
            this.moduleNumber = dis.readShort();
            this.modules = new short[6 * this.moduleNumber];
            for (int i = 0; i < this.modules.length; ++i) {
                this.modules[i] = dis.readShort();
            }
            this.frameNumber = dis.readShort();
            this.frames = new short[3 * this.frameNumber];
            this.modulesInFramesNumber = dis.readShort();
            this.modulesInFrames = new short[4 * this.modulesInFramesNumber];
            short moduleInFramesIndex = 0;
            for (int i = 0; i < this.frames.length; i += 3) {
                short modulesInFrame;
                this.frames[i] = dis.readShort();
                this.frames[i + 1] = modulesInFrame = dis.readShort();
                this.frames[i + 2] = moduleInFramesIndex;
                for (int j = 0; j < modulesInFrame * 4; ++j) {
                    this.modulesInFrames[moduleInFramesIndex + j] = dis.readShort();
                }
                moduleInFramesIndex = (short)(moduleInFramesIndex + modulesInFrame * 4);
            }
            this.animationNumber = dis.readShort();
            this.animations = new short[4 * this.animationNumber];
            this.framesInAnimationsNumber = dis.readShort();
            this.framesInAnimations = new short[3 * this.framesInAnimationsNumber];
            short framesInAnimationsIndex = 0;
            for (int i = 0; i < this.animations.length; i += 4) {
                short framesInAnimation;
                this.animations[i] = dis.readShort();
                this.animations[i + 1] = dis.readShort();
                this.animations[i + 2] = framesInAnimation = dis.readShort();
                this.animations[i + 3] = framesInAnimationsIndex;
                for (int j = 0; j < framesInAnimation * 3; ++j) {
                    this.framesInAnimations[framesInAnimationsIndex + j] = dis.readShort();
                }
                framesInAnimationsIndex = (short)(framesInAnimationsIndex + framesInAnimation * 3);
            }
            dis.close();
            dis = null;
            this.loadImagesPNG();
            this.loaded = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void loadImagesPNG() {
        if (moduleImages == null) {
            moduleImages = new Image[PSSpriteConstants.imgFiles.length];
        }
        for (int i = 0; i < this.moduleNumber; ++i) {
            short moduleImageId = this.getModuleImageId(i);
            if (moduleImages[moduleImageId] != null) continue;
            try {
                PSSprite.moduleImages[moduleImageId] = Image.createImage((String)("/" + PSSpriteConstants.imgFiles[moduleImageId]));
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public void unload() {
        this.loaded = false;
        this.moduleNumber = 0;
        this.modulesInFramesNumber = 0;
        this.modules = null;
        this.modulesInFrames = null;
        this.frameNumber = 0;
        this.framesInAnimationsNumber = 0;
        this.frames = null;
        this.framesInAnimations = null;
        this.animationNumber = 0;
        this.animations = null;
        System.gc();
    }

    public static void unloadImages() {
        if (moduleImages != null) {
            for (int i = 0; i < moduleImages.length; ++i) {
                PSSprite.moduleImages[i] = null;
                PSGraphics.Gc();
            }
        }
        moduleImages = null;
        PSGraphics.Gc();
    }

    public void drawAniFrame(PSGraphics g, int animationId, int frameId, int x, int y) {
        if (!this.loaded || frameId >= this.getAnimationFramesNumber(animationId)) {
            return;
        }
        int oldClipX = g.getClipX();
        int oldClipY = g.getClipY();
        int oldClipWidth = g.getClipWidth();
        int oldClipHeight = g.getClipHeight();
        g.setClip(x, y, this.getAnimationWidth(animationId), this.getAnimationHeight(animationId));
        this.drawFrame(g, this.getFrameInAnimationId(animationId, frameId), x, y, this.getAnimationWidth(animationId), this.getAnimationHeight(animationId), this.getFrameInAnimationTrans(animationId, frameId));
        g.setColor(0xFF0000);
    }

    public void drawFrame(PSGraphics g, short frameId, int x, int y, short frameWidth, short frameHeight, short transform) {
        if (!this.loaded) {
            return;
        }
        int frameModuleIdStart = this.getFrameFirstModuleIdx(frameId);
        short frameModuleNum = this.getFrameModulesNumber(frameId);
        int frameModuleIdLast = frameModuleIdStart + frameModuleNum * 4;
        int transformation = 0;
        for (int idx = frameModuleIdStart; idx < frameModuleIdLast; idx += 4) {
            short moduleInFrameX = this.modulesInFrames[idx + 1];
            short moduleInFrameY = this.modulesInFrames[idx + 2];
            short moduleTrans = this.modulesInFrames[idx + 3];
            switch (transform) {
                case 1: {
                    moduleInFrameX = (short)(frameWidth - (moduleInFrameX + this.getModuleWidth(this.modulesInFrames[idx])));
                    break;
                }
                case 2: {
                    moduleInFrameY = (short)(frameHeight - (moduleInFrameY + this.getModuleHeight(this.modulesInFrames[idx])));
                    break;
                }
            }
            transformation = transform == moduleTrans ? 0 : transform | moduleTrans;
            this.drawModule(g, this.modulesInFrames[idx], x + moduleInFrameX, y + moduleInFrameY, transformation);
        }
    }

    public void drawModule(PSGraphics g, short moduleId, int x, int y, int transform) {
        int trans;
        if (!this.loaded) {
            return;
        }
        switch (transform) {
            case 1: {
                trans = TRANS_MIRROR;
                break;
            }
            case 2: {
                trans = TRANS_MIRROR_ROT180;
                break;
            }
            case 3: {
                trans = TRANS_ROT180;
                break;
            }
            default: {
                trans = 0;
            }
        }
        g.drawRegionNokia(moduleImages[this.getModuleImageId(moduleId)], this.getModuleX(moduleId), this.getModuleY(moduleId), this.getModuleWidth(moduleId), this.getModuleHeight(moduleId), trans, x, y, 20);
    }

    public short getModuleId(int moduleIdx) {
        return this.modules[moduleIdx * 6];
    }

    public short getModuleImageId(int moduleIdx) {
        return this.modules[moduleIdx * 6 + 1];
    }

    public short getModuleX(int moduleIdx) {
        return this.modules[moduleIdx * 6 + 2];
    }

    public short getModuleY(int moduleIdx) {
        return this.modules[moduleIdx * 6 + 3];
    }

    public short getModuleWidth(int moduleIdx) {
        return this.modules[moduleIdx * 6 + 4];
    }

    public short getModuleHeight(int moduleIdx) {
        return this.modules[moduleIdx * 6 + 5];
    }

    public short getFrameId(int frameIdx) {
        return this.frames[frameIdx * 3];
    }

    public short getFrameModulesNumber(int frameIdx) {
        return this.frames[frameIdx * 3 + 1];
    }

    public short getFrameFirstModuleIdx(int frameIdx) {
        return this.frames[frameIdx * 3 + 2];
    }

    public short getModuleInFrameId(int frameIdx, int moduleIdx) {
        return this.modulesInFrames[this.getFrameFirstModuleIdx(frameIdx) + moduleIdx * 4];
    }

    public short getModuleInFrameX(int frameIdx, int moduleIdx) {
        return this.modulesInFrames[this.getFrameFirstModuleIdx(frameIdx) + moduleIdx * 4 + 1];
    }

    public short getModuleInFrameY(int frameIdx, int moduleIdx) {
        return this.modulesInFrames[this.getFrameFirstModuleIdx(frameIdx) + moduleIdx * 4 + 2];
    }

    public short getModuleInFrameTrans(int frameIdx, int moduleIdx) {
        return this.modulesInFrames[this.getFrameFirstModuleIdx(frameIdx) + moduleIdx * 4 + 3];
    }

    public short getAnimationWidth(int animationIdx) {
        return this.animations[animationIdx * 4];
    }

    public short getAnimationHeight(int animationIdx) {
        return this.animations[animationIdx * 4 + 1];
    }

    public short getAnimationFramesNumber(int animationIdx) {
        return this.animations[animationIdx * 4 + 2];
    }

    public short getAnimationFirstFrameIdx(int animationIdx) {
        return this.animations[animationIdx * 4 + 3];
    }

    public short getFrameInAnimationId(int animationIdx, int frameIdx) {
        return this.framesInAnimations[this.getAnimationFirstFrameIdx(animationIdx) + frameIdx * 3];
    }

    public short getFrameInAnimationTiming(int animationIdx, int frameIdx) {
        return this.framesInAnimations[this.getAnimationFirstFrameIdx(animationIdx) + frameIdx * 3 + 1];
    }

    public short getFrameInAnimationTrans(int animationIdx, int frameIdx) {
        return this.framesInAnimations[this.getAnimationFirstFrameIdx(animationIdx) + frameIdx * 3 + 2];
    }

    static {
        TRANS_MIRROR = 2;
        TRANS_MIRROR_ROT180 = 1;
        TRANS_ROT180 = 3;
    }
}

