/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class GameBoard
implements Constants,
PSText {
    public static final int SUB_PIXEL_SIZE = 3;
    public static final int TARGET_FILL_ARC_WIDTH = 10;
    public static final int TARGET_FILL_ARC_HEIGHT = 10;
    public static final int TARGET_DRAW_ARC_WIDTH = 40;
    public static final int TARGET_DRAW_ARC_HEIGHT = 40;
    public static final int AI_LINE_OF_SIGHT_SQUARE_SIZE = 9;
    public static final int MAX_CAM_OFFSET_X = 200;
    public static final int MAX_CAM_OFFSET_Y = 200;
    private final short MAX_CAM_VELOCITY = (short)96;
    private final short CAM_VELOCITY_INCREASE = (short)4;
    public static final int TRAVEL_CAM_SPEED = 40;
    public static final int TRAVEL_CAM_ORIENTATION_SPEED = 10;
    public static final int MOVEMENT_GRID_SIZE = 33;
    public static final int MOVEMENT_GRID_OFFSET = 3;
    public static final int UPPER_MOVEMENT_GRID_SIZE = 34;
    public static final int UPPER_MOVEMENT_GRID_OFFSET = 3;
    public static final int MISSILE_UP = 0;
    public static final int MISSILE_UP_RIGHT = 2;
    public static final int MISSILE_RIGHT = 4;
    public static final int MISSILE_DOWN_RIGHT = 6;
    public static final int MISSILE_DOWN = 8;
    public static final int MISSILE_DOWN_LEFT = 10;
    public static final int MISSILE_LEFT = 12;
    public static final int MISSILE_UP_LEFT = 14;
    public static final int TILE_NONE = -1;
    public static final int OBJECT_COLLISION = 16;
    public static final int MASK_LAYERZ_HEIGHT = 15;
    public static final int TILE_CRAWLABLE = 16;
    public static final int TILE_CANT_STANDUP = 32;
    public static final int TILE_IR_SENSOR = 64;
    public static final int TILE_EMPTY = 15;
    private final String[] LEVELS_BIN_NAME = new String[]{"tutorial.bin", "tutorial.bin", "tutorial.bin", "tutorial.bin", "tutorial.bin", "tutorial.bin", "level01.bin", "level03.bin", "level02.bin", "level05.bin", "level02.bin", "level09.bin", "level10.bin", "level05.bin", "level12.bin"};
    private final int START_ROW;
    private final int START_COL;
    private final int START_DIRECTION;
    private final int SNAKE_OR_VENUS;
    private final int[][] LEVELS_START_POSITION = new int[][]{{21, 3, 1, 0}, {21, 3, 1, 0}, {21, 3, 1, 0}, {15, 5, 8, 0}, {21, 3, 1, 0}, {21, 3, 1, 0}, {33, 3, 1, 0}, {21, 1, 8, 0}, {35, 31, 1, 0}, {29, 13, 1, 0}, {9, 1, 8, 1}, {23, 25, 2, 1}, {17, 1, 8, 0}, {29, 13, 1, 1}, {23, 11, 1, 0}};
    private final int SCRIPT_START_ROW;
    private final int SCRIPT_START_COL;
    private final int SCRIPT_END_ROW;
    private final int SCRIPT_END_COL;
    private final int SCRIPT_TYPE;
    private final int SCRIPT_PARAMETER1;
    private final int SCRIPT_PARAMETER2;
    private final int SCRIPT_DIALOG;
    private final int SCRIPT_TRAVEL_CAM;
    private final int SCRIPT_SET_CAM;
    private final int SCRIPT_POINT_OFF;
    private final int SCRIPT_END_MISSION;
    private final int SCRIPT_WAIT;
    private final int SCRIPT_MESSAGE;
    private final int SCRIPT_PLAYER_RESULT;
    private final int SCRIPT_SPECIAL_LEVEL06;
    private final int SCRIPT_INTERMISSION;
    private final int GLOBAL_SCRIPT_NONE;
    private final int GLOBAL_SCRIPT_SNEAK;
    private final int GLOBAL_SCRIPT_KILL_ALL;
    private final int GLOBAL_SCRIPT_KILL_AND_SNEAK;
    private final int[][][] LEVELS_SCRIPTS = new int[][][]{new int[][]{{1}, {21, 3, 21, 3, 0, 0}, {21, 3, 21, 3, 1, 5, 15}, {21, 3, 21, 3, 6, 30}, {21, 3, 21, 3, 1, 21, 3}, {21, 3, 21, 3, 7, 495, 496}, {5, 15, 5, 15, 5}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 0, 1}}, new int[][]{{1}, {21, 3, 21, 3, 0, 2}, {21, 3, 21, 3, 1, 5, 15}, {21, 3, 21, 3, 6, 30}, {21, 3, 21, 3, 1, 21, 3}, {21, 3, 21, 3, 7, 495, 496}, {5, 15, 5, 15, 5}, {21, 3, 21, 3, 7, 495, 497}, {5, 15, 5, 15, 0, 3}}, new int[][]{{1}, {21, 3, 21, 3, 0, 4}, {21, 3, 21, 3, 1, 5, 15}, {21, 3, 21, 3, 6, 30}, {21, 3, 21, 3, 1, 21, 3}, {21, 3, 21, 3, 7, 495, 496}, {5, 15, 5, 15, 5}, {21, 3, 21, 3, 7, 495, 497}}, new int[][]{{1}, {15, 5, 15, 5, 0, 5}, {15, 5, 15, 5, 1, 5, 15}, {15, 5, 15, 5, 6, 30}, {15, 5, 15, 5, 1, 21, 3}, {15, 5, 15, 5, 7, 495, 496}, {5, 15, 5, 15, 5}, {21, 3, 21, 3, 7, 495, 497}}, new int[][]{{2}, {21, 3, 21, 3, 0, 6}, {21, 3, 21, 3, 7, 495, 496}, {-1, -1, -1, -1, 5}, {-1, -1, -1, -1, 7, 495, 497}}, new int[][]{{0}, {21, 3, 21, 3, 0, 7}, {21, 3, 21, 3, 1, 5, 15}, {21, 3, 21, 3, 6, 30}, {21, 3, 21, 3, 1, 21, 3}, {21, 3, 21, 3, 7, 495, 496}, {5, 15, 5, 15, 5}, {21, 3, 21, 3, 7, 495, 497}, {21, 3, 21, 3, 0, 8}}, new int[][]{{0}, {33, 3, 33, 3, 10, 9}, {33, 3, 33, 3, 0, 10}, {33, 3, 33, 3, 1, 23, 9}, {33, 3, 33, 3, 6, 20}, {33, 3, 33, 3, 1, 21, 27}, {33, 3, 33, 3, 6, 20}, {33, 3, 33, 3, 1, 7, 3}, {33, 3, 33, 3, 6, 20}, {33, 3, 33, 3, 1, 13, 17}, {33, 3, 33, 3, 6, 10}, {33, 3, 33, 3, 0, 11}, {33, 3, 33, 3, 1, 33, 3}, {33, 3, 33, 3, 7, 495, 496}, {25, 11, 25, 11, 0, 12}, {21, 29, 21, 29, 0, 13}, {7, 3, 7, 3, 5}, {-1, -1, -1, -1, 0, 14}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{0}, {21, 1, 21, 1, 0, 17}, {21, 1, 21, 1, 1, 3, 41}, {21, 1, 21, 1, 6, 30}, {21, 1, 21, 1, 1, 21, 1}, {21, 1, 21, 1, 7, 495, 496}, {3, 41, 3, 41, 5}, {-1, -1, -1, -1, 0, 18}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{0}, {35, 31, 35, 31, 0, 19}, {35, 31, 35, 31, 1, 11, 11}, {35, 31, 35, 31, 6, 30}, {35, 31, 35, 31, 1, 35, 31}, {35, 31, 35, 31, 7, 495, 496}, {11, 11, 11, 11, 5}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{2}, {29, 13, 29, 13, 0, 20}, {29, 13, 29, 13, 1, 9, 13}, {29, 13, 29, 13, 6, 30}, {29, 13, 29, 13, 0, 21}, {29, 13, 29, 13, 1, 29, 13}, {29, 13, 29, 13, 7, 495, 496}, {-1, -1, -1, -1, 5}, {-1, -1, -1, -1, 0, 23}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 0, 24}, {-1, -1, -1, -1, 8}}, new int[][]{{0}, {9, 1, 9, 1, 0, 25}, {9, 1, 9, 1, 1, 27, 17}, {9, 1, 9, 1, 6, 30}, {9, 1, 9, 1, 1, 9, 1}, {9, 1, 9, 1, 7, 495, 496}, {27, 17, 27, 17, 0, 26}, {27, 17, 27, 17, 9}, {-1, -1, -1, -1, 5}, {-1, -1, -1, -1, 0, 27}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{0}, {23, 25, 23, 25, 10, 33}, {23, 25, 23, 25, 0, 34}, {23, 25, 23, 25, 7, 495, 496}, {5, 13, 5, 13, 5}, {-1, -1, -1, -1, 0, 39}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{0}, {17, 1, 17, 1, 0, 40}, {17, 1, 17, 1, 1, 17, 55}, {17, 1, 17, 1, 6, 30}, {17, 1, 17, 1, 1, 17, 1}, {17, 1, 17, 1, 7, 495, 496}, {17, 55, 17, 55, 5}, {-1, -1, -1, -1, 0, 41}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{2}, {29, 13, 29, 13, 0, 42}, {29, 13, 29, 13, 1, 9, 13}, {29, 13, 29, 13, 0, 43}, {29, 13, 29, 13, 1, 29, 13}, {29, 13, 29, 13, 7, 495, 496}, {-1, -1, -1, -1, 5}, {-1, -1, -1, -1, 0, 45}, {-1, -1, -1, -1, 7, 495, 497}, {-1, -1, -1, -1, 8}}, new int[][]{{2}, {23, 11, 23, 11, 0, 46}, {23, 11, 23, 11, 1, 9, 11}, {23, 11, 23, 11, 6, 30}, {23, 11, 23, 11, 1, 23, 11}, {23, 11, 23, 11, 7, 495, 496}, {-1, -1, -1, -1, 5}, {-1, -1, -1, -1, 0, 48}, {-1, -1, -1, -1, 7, 495, 497}}};
    private final int[][] MISSION_SCRIPT_KILL_ALL = new int[][]{{2}, {0, 45}};
    private final int AI_ID;
    private final int AI_TYPE;
    private final int AI_TILE_ROW_POS;
    private final int AI_TILE_COL_POS;
    private final int AI_DIRECTION;
    private final int AI_WAIT_TURN;
    public static final byte AI_GUARD = 1;
    public static final byte AI_BOX = 2;
    public static final byte AI_RISHIKI = 3;
    public static final byte AI_VINCE = 4;
    public static final byte AI_METAL_GEAR = 5;
    public static final byte AI_METAL_GEAR_LEFT_ARM = 6;
    public static final byte AI_METAL_GEAR_RIGHT_ARM = 7;
    public static final byte AI_GUARD_FLAMETHROWER = 8;
    public static final byte AI_CAMERA = 9;
    public static final byte AI_GUNCYPHER = 10;
    public static final byte AI_OCELOT = 11;
    public static final byte AI_LIQUID = 12;
    public static final byte AI_VENUS = 13;
    public static final byte AI_STATIONARY_POINT = -1;
    private final byte[][][] LEVELS_AI_DATA = new byte[][][]{new byte[][]{{0, 1, 11, 11, 4, -1}}, new byte[][]{{0, 1, 11, 11, 4, -1}}, new byte[][]{{0, 1, 11, 11, 4, -1}, {1, 1, 13, 1, 4, -1}}, new byte[][]{{0, 1, 9, 11, 4, -1}, {1, 1, 13, 1, 4, -1}}, new byte[][]{{0, 1, 11, 11, 4, -1}}, new byte[][]{{0, 1, 11, 11, 4, -1}}, new byte[][]{{0, 1, 23, 5, 2, 1}, {0, 1, 23, 9, 4, 1}, {1, 1, 21, 25, 2, 1}, {1, 1, 21, 25, 8, 1}, {2, 1, 9, 25, 2, -1}, {3, 1, 11, 5, 4, 1}, {3, 1, 7, 5, 4, 1}, {4, 9, 13, 17, 4, -1}}, new byte[][]{{0, 1, 13, 7, 8, -1}, {1, 2, 17, 15, 8, 2}, {1, 2, 17, 19, 8, 2}, {2, 2, 27, 27, 1, 1}, {2, 2, 23, 27, 8, 1}, {3, 1, 25, 41, 2, -1}, {4, 1, 13, 31, 8, 2}, {4, 1, 13, 35, 4, 2}, {5, 1, 7, 41, 4, 1}, {5, 1, 13, 41, 4, 1}}, new byte[][]{{0, 1, 21, 33, 1, 0}, {0, 1, 15, 33, 8, 0}, {0, 1, 15, 39, 4, 0}, {0, 1, 21, 39, 2, 0}, {1, 1, 25, 17, 4, 1}, {1, 1, 29, 17, 8, 1}, {2, 1, 31, 37, 2, 1}, {2, 1, 31, 31, 4, 1}, {3, 1, 17, 11, 1, 1}, {3, 1, 7, 11, 8, 1}, {3, 1, 7, 21, 4, 1}, {4, 1, 27, 47, 2, -1}, {5, 1, 7, 25, 4, -1}, {6, 9, 13, 39, 4, -1}}, new byte[][]{{0, 4, 9, 13, 4, -1}}, new byte[][]{{0, 1, 17, 7, 8, 2}, {0, 1, 17, 3, 1, 2}, {1, 1, 25, 7, 1, 1}, {1, 1, 25, 3, 8, 1}, {2, 1, 9, 21, 8, 0}, {2, 1, 17, 21, 2, 0}, {2, 1, 17, 11, 1, 0}, {2, 1, 9, 11, 8, 0}, {3, 1, 29, 41, 2, -1}, {4, 1, 17, 41, 2, -1}, {5, 9, 21, 27, 4, -1}}, new byte[][]{{0, 3, 13, 21, 8, 0}, {0, 3, 13, 29, 4, 0}, {0, 3, 17, 29, 2, 1}, {0, 3, 17, 21, 1, 0}, {1, 3, 27, 15, 1, 2}, {1, 3, 27, 7, 8, 2}, {2, 3, 17, 7, 8, 1}, {2, 3, 17, 9, 4, 1}, {2, 3, 17, 15, 4, 1}, {3, 3, 13, 15, 2, 1}, {3, 3, 13, 7, 4, 1}}, new byte[][]{{0, 8, 15, 9, 2, 0}, {0, 8, 15, 11, 4, 1}, {0, 8, 19, 11, 4, 0}, {0, 8, 19, 13, 8, 1}, {1, 10, 9, 23, 4, -1}, {2, 8, 13, 29, 2, 0}, {2, 8, 13, 21, 4, 2}, {3, 10, 7, 39, 4, -1}, {4, 8, 13, 43, 2, 0}, {4, 8, 13, 37, 2, 2}, {5, 8, 11, 45, 4, 0}, {5, 8, 17, 45, 2, 2}, {6, 10, 5, 47, 4, -1}}, new byte[][]{{0, 4, 9, 13, 4, -1}, {1, 8, 9, 1, 4, -1}, {2, 8, 9, 23, 4, -1}, {3, 8, 17, 3, 8, -1}, {4, 8, 15, 19, 2, -1}}, new byte[][]{{0, 5, 9, 11, 4, -1}, {1, 7, 9, 7, 4, -1}, {2, 6, 9, 15, 4, -1}}};
    private final byte[][] LEVEL_06_EXTRA_AI = new byte[][]{{0, 3, 27, 25, 2, -1}, {1, 3, 23, 29, 2, -1}, {2, 3, 17, 15, 4, -1}, {3, 3, 19, 33, 4, -1}, {4, 3, 13, 27, 8, -1}, {5, 3, 37, 17, 4, -1}};
    private final int OBJECT_ROW;
    private final int OBJECT_COL;
    private final int OBJECT_IMAGE;
    private final int OBJECT_NUMBER_MINES;
    private final int OBJECT_PROJECTILE;
    public static final int FAKE_IMAGE_SPR_DOOR_SIDE = 10000;
    private final int[][][] LEVELS_OBJECTS = new int[][][]{new int[][]{{5, 15, 56}}, new int[][]{{5, 15, 56}}, new int[][]{{5, 15, 56}}, new int[][]{{5, 15, 56}}, new int[][]{{5, 15, 56}}, new int[][]{{5, 15, 56}}, new int[][]{{25, 11, 56}, {23, 11, 28}, {21, 29, 56}, {19, 29, 28}, {7, 3, 56}, {7, 1, 28}, {23, 1, 32}, {5, 21, 32}, {17, 29, 32}}, new int[][]{{3, 41, 56}, {10, 17, 19}, {14, 17, 20}, {10, 25, 19}, {14, 25, 20}, {19, 11, 32}, {23, 37, 32}, {13, 39, 32}}, new int[][]{{11, 11, 56}, {15, 15, 22}, {21, 9, 22}, {19, 9, 22}, {31, 9, 22}, {21, 15, 22}, {23, 27, 23}, {7, 31, 32}, {27, 51, 32}, {11, 3, 32}}, new int[][]{{11, 9, 57}, {9, 15, 57}, {7, 19, 57}, {11, 1, 57}, {19, 5, 57}, {15, 19, 57}, {25, 5, 57}, {23, 23, 57}, {27, 23, 32}, {27, 1, 32}, {7, 1, 32}, {7, 23, 32}, {5, 11, 32}}, new int[][]{{27, 17, 56}, {15, 15, 22}, {21, 9, 22}, {19, 9, 22}, {31, 9, 22}, {21, 15, 22}, {23, 27, 23}, {9, 9, 32}, {17, 27, 32}, {17, 1, 32}, {41, 17, 32}, {27, 45, 32}, {19, 25, 32}}, new int[][]{{11, 7, 21}, {9, 7, 21}, {25, 3, 32}, {25, 19, 32}, {21, 29, 32}, {15, 25, 32}, {9, 23, 32}, {7, 13, 32}, {15, 7, 32}}, new int[][]{{17, 55, 56}, {15, 7, 32}, {13, 1, 32}, {17, 11, 32}, {9, 19, 32}, {7, 31, 32}, {21, 33, 32}, {5, 43, 32}}, new int[][]{{11, 9, 57}}, new int[][]{null}};
    private final int[] LEVELS_POINTS = new int[]{0, 0, 0, 0, 0, 0, 5000, 7000, 8000, 9000, 10000, 16000, 18000, 20000, 30000};
    private final int CARD_PACK_ROW;
    private final int CARD_PACK_COL;
    private final int CARD_PACK_INFO;
    private final int CARD_PACK_ORDER_ID;
    private Vector pickedUpCardsPacks;
    private String pickUpCardPack;
    private final int[][][] LEVELS_CARD_PACKS = new int[][][]{new int[][]{null}, new int[][]{null}, new int[][]{null}, new int[][]{null}, new int[][]{null}, new int[][]{null}, new int[][]{{23, 1, 99, 0}, {5, 21, 99, 1}, {17, 29, 99, 2}}, new int[][]{{19, 11, 100, 0}, {23, 37, 100, 1}, {13, 39, 100, 2}}, new int[][]{{7, 31, 100, 0}, {27, 51, 100, 1}, {11, 3, 99, 2}}, new int[][]{{27, 23, 101, 0}, {27, 1, 99, 1}, {7, 1, 100, 2}, {7, 23, 101, 3}, {5, 11, 101, 4}}, new int[][]{{9, 9, 100, 0}, {16, 27, 100, 1}, {17, 1, 99, 2}, {41, 17, 101, 3}, {27, 45, 101, 4}, {19, 25, 101, 5}}, new int[][]{{25, 3, 102, 0}, {25, 19, 99, 1}, {21, 29, 100, 2}, {15, 25, 101, 3}, {9, 23, 102, 4}, {7, 13, 100, 5}, {15, 7, 101, 6}}, new int[][]{{13, 1, 99, 0}, {17, 11, 100, 1}, {9, 19, 101, 2}, {7, 31, 102, 3}, {21, 33, 102, 4}, {5, 43, 102, 5}}, new int[][]{null}, new int[][]{null}};
    private final int[][][] GRENADE_GRID = new int[][][]{new int[][]{{-2, -2}, {-2, -1}, {-3, -1}, {-4, 0}, {-3, 1}, {-2, 1}, {-2, 2}}, new int[][]{{2, -2}, {1, -2}, {1, -3}, {0, -4}, {-1, -3}, {-1, -2}, {-2, -2}}, new int[][]{{2, -2}, {2, -1}, {3, -1}, {4, 0}, {3, 1}, {2, 1}, {2, 2}}, new int[][]{{2, 2}, {1, 2}, {1, 3}, {0, 4}, {-1, 3}, {-1, 2}, {-2, 2}}};
    public static Snake snake;
    public static int snakeTileColStart;
    public static int snakeTileRowStart;
    public static short camX;
    public static short camY;
    public static short camOffsetX;
    public static short camOffsetY;
    public static short camBorderOffsetX;
    public static short camBorderOffsetY;
    public static short displayStartX;
    public static short displayStartY;
    private static short camWidth;
    private static short camHeight;
    public static final int BUFFER_PIXEL_WIDTH;
    public static final int BUFFER_PIXEL_HEIGHT;
    public static final int BUFFER_TILE_WIDTH;
    public static final int BUFFER_TILE_HEIGHT;
    public static Image boardImageBuffer;
    public static PSGraphics boardImageGraphics;
    private Image scrollingImage = null;
    private int bufferPivotX = 0;
    private int bufferPivotY = 0;
    private int bufferPivotWidth = 0;
    private int bufferPivotHeight = 0;
    private short lastCamX = (short)(-BUFFER_PIXEL_WIDTH);
    private short lastCamY = (short)(-BUFFER_PIXEL_HEIGHT);
    private short camVelocityX = 0;
    private short camVelocityY = 0;
    private short[][] travelCamPath = null;
    private int currentTravelPoint = 0;
    public static boolean camIsTraveling;
    private boolean forceCamTraveling = false;
    private int lastTravelCamX = 0;
    private int lastTravelCamY = 0;
    private boolean forceTravelCam = false;
    public static int currentLevel;
    public static int mapWidth;
    public static int mapHeight;
    public static byte[][] tileLayer0;
    public static byte[][] tileLayer1;
    public static byte[][] tileLayer2;
    public static byte[][] tileLayerZ;
    public static byte[][] boundMapData;
    public static byte[][] visionMapData;
    private static boolean tilesAreTransparent;
    public static int[][] scriptArray;
    private int currentScript = 0;
    public static boolean isScriptActive;
    private boolean skipScripts = false;
    int missionType = 0;
    public static GameAI[] AiArray;
    public static GameBoardObject[] objectArray;
    private int currentActiveAi = -1;
    private boolean wasSnakeTurn = false;
    private int rowStart = 0;
    private int colStart = 0;
    private int rowEnd = 0;
    private int colEnd = 0;
    private int pixelRowStart = 0;
    private int pixelRowEnd = 0;
    private int pixelColStart = 0;
    private int pixelColEnd = 0;
    public static int offsetX;
    public static int offsetY;
    private int startDisplayTileX = 0;
    private int startDisplayTileY = 0;
    private int pointRow = 0;
    private int pointCol = 0;
    private boolean isPointing = false;
    private int frameCounter = 0;
    public boolean skipPaint = false;
    int targetReduceRadius = 0;
    private Vector displayQueue;
    private int firstDisplayY = 10000;
    private boolean enteringState = false;
    private boolean exitingState = false;
    private int lastState = 0;
    private int currentState = 0;
    private int nextState = 2;
    private int savedState = 0;
    public boolean missionStarted = false;
    private Vector initiativeList;
    private GameBoardHud ingameHud = null;
    private boolean isInitDrawCards = true;
    private boolean isInitRun = true;
    public static GameBoard instance;
    private int tmpCard;
    private int previewTurn;
    public static int alertPercent;
    private static int nextAlertPercent;
    private static boolean isAlertOn;
    private int waitTimer = 0;
    private int messageBarTimer = 0;
    private String messageBarText = "";
    private boolean levelUnloaded = false;
    private int bezierLevel = 4;
    private int[][] grenadePoints = new int[17][2];
    private int currentGrenadePoint = 0;
    private int[][] grenadePath = new int[][]{{0, 0}, {60, 120}, {120, 120}, {240, 0}};
    private int[] grenadeGrid = new int[24];
    private int grenadeGridPosition = 0;
    private boolean hasLaunchedGrenade = false;
    private boolean missileLaunching = false;
    private int generalEffectCard = -1;
    private int totalLevelCost = 0;
    private int totalKills = 0;
    private static int totalAlarms;
    private int pointsEarned = 0;
    private int pickUpPrintDuration = 20;
    private int[] pickedUpItems;
    private boolean hasMetalGearAppeared = false;
    private boolean wasMissionFailed = false;
    private boolean isProgressUpdated = false;

    public GameBoard(int width, int height, int level, int missionType) {
        this.START_ROW = 0;
        this.START_COL = 1;
        this.START_DIRECTION = 2;
        this.SNAKE_OR_VENUS = 3;
        this.SCRIPT_START_ROW = 0;
        this.SCRIPT_START_COL = 1;
        this.SCRIPT_END_ROW = 2;
        this.SCRIPT_END_COL = 3;
        this.SCRIPT_TYPE = 4;
        this.SCRIPT_PARAMETER1 = 5;
        this.SCRIPT_PARAMETER2 = 6;
        this.SCRIPT_DIALOG = 0;
        this.SCRIPT_TRAVEL_CAM = 1;
        this.SCRIPT_SET_CAM = 2;
        this.SCRIPT_POINT_OFF = 4;
        this.SCRIPT_END_MISSION = 5;
        this.SCRIPT_WAIT = 6;
        this.SCRIPT_MESSAGE = 7;
        this.SCRIPT_PLAYER_RESULT = 8;
        this.SCRIPT_SPECIAL_LEVEL06 = 9;
        this.SCRIPT_INTERMISSION = 10;
        this.GLOBAL_SCRIPT_NONE = 0;
        this.GLOBAL_SCRIPT_SNEAK = 1;
        this.GLOBAL_SCRIPT_KILL_ALL = 2;
        this.GLOBAL_SCRIPT_KILL_AND_SNEAK = 3;
        this.AI_ID = 0;
        this.AI_TYPE = 1;
        this.AI_TILE_ROW_POS = 2;
        this.AI_TILE_COL_POS = 3;
        this.AI_DIRECTION = 4;
        this.AI_WAIT_TURN = 5;
        this.OBJECT_ROW = 0;
        this.OBJECT_COL = 1;
        this.OBJECT_IMAGE = 2;
        this.OBJECT_NUMBER_MINES = 4;
        this.OBJECT_PROJECTILE = 0;
        this.CARD_PACK_ROW = 0;
        this.CARD_PACK_COL = 1;
        this.CARD_PACK_INFO = 2;
        this.CARD_PACK_ORDER_ID = 3;
        camIsTraveling = false;
        currentLevel = level;
        instance = this;
        this.missionType = missionType;
        this.loadLevel(this.LEVELS_BIN_NAME[currentLevel]);
        this.initLevel(missionType);
    }

    public void loadLevel(String name) {
        try {
            int j;
            int i;
            DataInputStream ds = new DataInputStream(instance.getClass().getResourceAsStream(name));
            mapWidth = ds.read();
            mapHeight = ds.read();
            tileLayer0 = new byte[mapHeight][mapWidth];
            tileLayer1 = new byte[mapHeight][mapWidth];
            tileLayer2 = new byte[mapHeight][mapWidth];
            tileLayerZ = new byte[mapHeight][mapWidth];
            boundMapData = new byte[mapHeight][mapWidth];
            visionMapData = new byte[mapHeight][mapWidth];
            for (i = 0; i < mapHeight; ++i) {
                for (j = 0; j < mapWidth; ++j) {
                    GameBoard.tileLayer0[i][j] = ds.readByte();
                }
            }
            for (i = 0; i < mapHeight; ++i) {
                for (j = 0; j < mapWidth; ++j) {
                    GameBoard.tileLayer1[i][j] = ds.readByte();
                }
            }
            for (i = 0; i < mapHeight; ++i) {
                for (j = 0; j < mapWidth; ++j) {
                    GameBoard.tileLayer2[i][j] = ds.readByte();
                }
            }
            for (i = 0; i < mapHeight; ++i) {
                for (j = 0; j < mapWidth; ++j) {
                    GameBoard.tileLayerZ[i][j] = ds.readByte();
                }
            }
            for (i = 0; i < mapHeight; ++i) {
                for (j = 0; j < mapWidth; ++j) {
                    GameBoard.boundMapData[i][j] = ds.readByte();
                    GameBoard.visionMapData[i][j] = boundMapData[i][j];
                }
            }
            ds.close();
            for (i = 0; i < mapHeight; ++i) {
                for (j = 0; j < mapWidth; ++j) {
                    if ((tileLayerZ[i][j] & 0xF) != 15) continue;
                    GameBoard.visionMapData[i - 1][j] = 0;
                    GameBoard.visionMapData[i + 1][j] = 0;
                    GameBoard.visionMapData[i][j + 1] = 0;
                    GameBoard.visionMapData[i][j - 1] = 0;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initLevel(int missionType) {
        int i;
        int i2;
        this.ingameHud = new GameBoardHud();
        this.ingameHud.initCardsSize();
        this.displayQueue = new Vector();
        this.pickedUpCardsPacks = new Vector();
        this.isInitDrawCards = true;
        this.wasMissionFailed = false;
        this.hasMetalGearAppeared = false;
        this.isProgressUpdated = false;
        snake = new Snake(this.LEVELS_START_POSITION[currentLevel][0], this.LEVELS_START_POSITION[currentLevel][1], this.LEVELS_START_POSITION[currentLevel][0], this.LEVELS_START_POSITION[currentLevel][2]);
        this.initiativeList = new Vector();
        this.initiativeList.addElement(snake);
        GameBoard.snake.initiativeTurnNumber = this.initiativeList.size();
        this.missionType = missionType;
        scriptArray = this.LEVELS_SCRIPTS[currentLevel];
        if (missionType == 2 || missionType == 3) {
            GameBoard.scriptArray[0][0] = 2;
            i2 = 1;
            while (scriptArray[i2][4] != 5) {
                ++i2;
            }
            GameBoard.scriptArray[i2][0] = -1;
            GameBoard.scriptArray[i2][1] = -1;
            GameBoard.scriptArray[i2][2] = -1;
            GameBoard.scriptArray[i2][3] = -1;
            i2 = 1;
            while (scriptArray[i2][4] != 7) {
                ++i2;
            }
            GameBoard.scriptArray[--i2][5] = 50;
            GameBoard.scriptArray[i2][4] = 0;
            this.currentScript = i2;
        } else if (missionType == 1) {
            GameBoard.scriptArray[0][0] = 1;
            i2 = 1;
            while (scriptArray[i2][4] != 0) {
                ++i2;
            }
            GameBoard.scriptArray[i2][5] = 49;
            this.currentScript = i2;
            for (int j = i2 + 1; j < scriptArray.length; ++j) {
                if (scriptArray[j][4] != 0) continue;
                GameBoard.scriptArray[j][5] = -1;
            }
        } else {
            this.currentScript = 1;
        }
        this.initAiArray(this.LEVELS_AI_DATA[currentLevel]);
        int objectLen = 0;
        if (this.LEVELS_OBJECTS[currentLevel][0] != null) {
            objectLen = this.LEVELS_OBJECTS[currentLevel].length;
        }
        objectArray = new GameBoardObject[objectLen + 1 + 4];
        for (i = 0; i < 5; ++i) {
            GameBoard.objectArray[i] = null;
        }
        block8: for (i = 0; i < objectLen; ++i) {
            switch (this.LEVELS_OBJECTS[currentLevel][i][2]) {
                case 32: {
                    if (this.LEVELS_CARD_PACKS[currentLevel][0] == null) continue block8;
                    if (PSCanvas.foundItems[currentLevel - 6].size() > 1) {
                        for (int j = 0; j < this.LEVELS_CARD_PACKS[currentLevel].length; ++j) {
                            if (this.LEVELS_CARD_PACKS[currentLevel][j][0] != this.LEVELS_OBJECTS[currentLevel][i][0] || this.LEVELS_CARD_PACKS[currentLevel][j][1] != this.LEVELS_OBJECTS[currentLevel][i][1] || PSCanvas.foundItems[currentLevel - 6].indexOf(new Integer(this.LEVELS_CARD_PACKS[currentLevel][j][3]), 1) != -1) continue;
                            GameBoard.objectArray[5 + i] = new GameBoardObject(this.LEVELS_OBJECTS[currentLevel][i][0], this.LEVELS_OBJECTS[currentLevel][i][1], this.LEVELS_OBJECTS[currentLevel][i][2]);
                        }
                        continue block8;
                    }
                    GameBoard.objectArray[5 + i] = new GameBoardObject(this.LEVELS_OBJECTS[currentLevel][i][0], this.LEVELS_OBJECTS[currentLevel][i][1], this.LEVELS_OBJECTS[currentLevel][i][2]);
                    continue block8;
                }
                default: {
                    GameBoard.objectArray[5 + i] = new GameBoardObject(this.LEVELS_OBJECTS[currentLevel][i][0], this.LEVELS_OBJECTS[currentLevel][i][1], this.LEVELS_OBJECTS[currentLevel][i][2]);
                }
            }
        }
        this.lastCamX = (short)(-BUFFER_PIXEL_WIDTH);
        this.lastCamY = (short)(-BUFFER_PIXEL_HEIGHT);
        tilesAreTransparent = false;
        camBorderOffsetX = 0;
        camBorderOffsetY = 0;
        this.setCam(GameBoard.snake.posX, GameBoard.snake.posY);
        snake.updateDisplayPositions();
        this.updateDisplayCoordinates();
        this.updateMapTiles();
        this.ingameHud.createPlayersStatsArray(AiArray.length);
        this.ingameHud.updateSnakeStatus(snake);
        this.ingameHud.updateAIStatus(AiArray);
        GameBoard.snake.deck.shuffleDeck();
    }

    private void initAiArray(byte[][] AiData) {
        AiArray = new GameAI[AiData[AiData.length - 1][0] + 1];
        boolean AiNumber = false;
        for (int i = 0; i < AiData.length; ++i) {
            int j;
            if (AiArray[AiData[i][0]] != null) continue;
            byte AiID = AiData[i][0];
            int checkPointListSize = 0;
            for (j = i; j < AiData.length && AiID == AiData[j][0]; ++j) {
                ++checkPointListSize;
            }
            int[][] checkPointList = new int[checkPointListSize][4];
            for (j = i; j < i + checkPointListSize; ++j) {
                checkPointList[j - i][0] = AiData[j][2];
                checkPointList[j - i][1] = AiData[j][3];
                checkPointList[j - i][2] = AiData[j][4];
                checkPointList[j - i][3] = AiData[j][5];
            }
            GameBoard.AiArray[AiData[i][0]] = new GameAI(AiData[i][2], AiData[i][3], AiData[i][2], AiData[i][1], checkPointList, AiData[i][0]);
            if (GameBoard.AiArray[AiData[i][0]].type == 6 || GameBoard.AiArray[AiData[i][0]].type == 7 || GameBoard.AiArray[AiData[i][0]].type == 9) continue;
            this.initiativeList.addElement(AiArray[AiData[i][0]]);
            GameBoard.AiArray[AiData[i][0]].initiativeTurnNumber = this.initiativeList.size();
        }
    }

    public void unloadLevel() {
        int i;
        this.ingameHud.clearResult();
        this.pickedUpCardsPacks = null;
        GameBoard.snake.deck.shuffleDeck();
        this.ingameHud = null;
        this.displayQueue = null;
        tileLayer0 = null;
        tileLayer1 = null;
        tileLayer2 = null;
        tileLayerZ = null;
        boundMapData = null;
        snake = null;
        this.initiativeList = null;
        for (i = 0; i < AiArray.length; ++i) {
            GameBoard.AiArray[i] = null;
        }
        AiArray = null;
        for (i = 0; i < objectArray.length; ++i) {
            GameBoard.objectArray[i] = null;
        }
        objectArray = null;
        alertPercent = 0;
        nextAlertPercent = 0;
        this.travelCamPath = null;
        camIsTraveling = false;
        this.lastCamX = (short)(-BUFFER_PIXEL_WIDTH);
        this.lastCamY = (short)(-BUFFER_PIXEL_HEIGHT);
        this.totalLevelCost = 0;
        this.totalKills = 0;
        totalAlarms = 0;
        this.pointsEarned = 0;
        this.waitTimer = 0;
        isScriptActive = false;
        this.levelUnloaded = true;
        PSGraphics.Gc();
    }

    /*
     * Unable to fully structure code
     */
    public void updateDisplayGameboard(PSGraphics g) {
        block81: {
            block79: {
                if (this.levelUnloaded || this.skipPaint) {
                    return;
                }
                if (this.isInitRun) {
                    this.ingameHud.updateDisplayGameboardHud(g);
                    this.isInitRun = false;
                }
                if (this.nextState == 27) {
                    g.setClip(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, GameBoard.camHeight);
                    this.ingameHud.updateDisplayGameboardHud(g);
                    return;
                }
                if (GameBoard.camY < 0 && GameBoard.camX < 0) {
                    g.setClip(GameBoard.displayStartX - GameBoard.camX, GameBoard.displayStartY - GameBoard.camY, GameBoard.camWidth + GameBoard.camX, GameBoard.camHeight + GameBoard.camY);
                } else if (GameBoard.camX < 0) {
                    g.setClip(GameBoard.displayStartX - GameBoard.camX, GameBoard.displayStartY, GameBoard.camWidth + GameBoard.camX, GameBoard.camHeight);
                } else if (GameBoard.camY < 0) {
                    g.setClip(GameBoard.displayStartX, GameBoard.displayStartY - GameBoard.camY, GameBoard.camWidth, GameBoard.camHeight + GameBoard.camY);
                } else {
                    g.setClip(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, GameBoard.camHeight);
                }
                g.drawImage(GameBoard.boardImageBuffer, -this.bufferPivotX, -this.bufferPivotY);
                g.drawImage(GameBoard.boardImageBuffer, -this.bufferPivotX, this.bufferPivotHeight);
                g.drawImage(GameBoard.boardImageBuffer, this.bufferPivotWidth, -this.bufferPivotY);
                g.drawImage(GameBoard.boardImageBuffer, this.bufferPivotWidth, this.bufferPivotHeight);
                g.setClip(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, GameBoard.camHeight);
                if (GameBoard.camX < 0) {
                    g.setColor(0);
                    g.fillRect(GameBoard.displayStartX, GameBoard.displayStartY, -GameBoard.camX, GameBoard.camHeight);
                }
                if (GameBoard.camY < 0) {
                    g.setColor(0);
                    g.fillRect(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, -GameBoard.camY);
                }
                for (i = 0; i < this.displayQueue.size(); ++i) {
                    toDisplay = (GameBoardElement)this.displayQueue.elementAt(i);
                    toDisplay.displayShadow(g);
                }
                if (this.currentState != 13 && (this.currentState != 22 || this.lastState != 13)) break block79;
                stepOffsetX = GameBoard.snake.moveColStart - (GameBoard.snake.moveArray.length >> 1 << 1);
                stepOffsetY = GameBoard.snake.moveRowStart - (GameBoard.snake.moveArray.length >> 1 << 1);
                g.setClip(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, GameBoard.camHeight);
                for (i = 0; i < GameBoard.snake.moveArray.length; ++i) {
                    for (j = 0; j < GameBoard.snake.moveArray[i].length; ++j) {
                        block80: {
                            if (GameBoard.snake.moveArray[i][j][0] <= -2) continue;
                            tmpTileRow = (i << 1) + GameBoard.snake.moveRowToBoundRow + 1;
                            tmpTileCol = (j << 1) + GameBoard.snake.moveColToBoundCol;
                            displayTileX = ((j << 1) + stepOffsetX) * 20 - GameBoard.camX - GameBoard.offsetX;
                            displayTileY = ((i << 1) + stepOffsetY - 1) * 20 - GameBoard.camY - GameBoard.offsetY;
                            if (Snake.nextState == 6) break block80;
                            if (Snake.nextState != 7) ** GOTO lbl-1000
                        }
                        if (tmpTileRow == GameBoard.snake.tileRow && tmpTileCol == GameBoard.snake.tileCol) {
                            g.setColor(913393);
                        } else if (tmpTileRow == GameBoard.snake.moveInitialRow && tmpTileCol == GameBoard.snake.moveInitialCol) {
                            g.setColor(0xFFFFFF);
                        } else if (GameBoard.snake.moveArray[i][j][0] == -1) {
                            g.setColor(0x444444);
                        } else {
                            g.setColor(15659277);
                        }
                        if (!(GameBoard.tileLayer2[tmpTileRow][tmpTileCol] != -1 && !GameBoard.tilesAreTransparent || GameBoard.tileLayer1[tmpTileRow][tmpTileCol] != -1 && GameBoard.tileLayer1[tmpTileRow][tmpTileCol + 1] != -1)) {
                            g.setClip(displayTileX + GameBoard.offsetX, displayTileY + GameBoard.offsetY + 20, 40, 20);
                            g.drawRect(displayTileX + GameBoard.offsetX + 3, displayTileY + GameBoard.offsetY + 3, 33, 33);
                        }
                        if (GameBoard.tileLayer2[tmpTileRow - 1][tmpTileCol] != -1 && !GameBoard.tilesAreTransparent || GameBoard.tileLayer1[tmpTileRow - 1][tmpTileCol] != -1 && GameBoard.tileLayer1[tmpTileRow - 1][tmpTileCol + 1] != -1) continue;
                        g.setClip(displayTileX + GameBoard.offsetX, displayTileY + GameBoard.offsetY, 40, 20);
                        g.drawRect(displayTileX + GameBoard.offsetX + 3, displayTileY + GameBoard.offsetY + 3, 33, 33);
                    }
                }
            }
            g.setClip(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, GameBoard.camHeight);
            if (GameBoard.objectArray[0] != null) {
                this.fillDisplayQueue(GameBoard.objectArray[0]);
                this.refillDisplayQueue(GameBoard.objectArray[0]);
            }
            for (i = 0; i < this.displayQueue.size(); ++i) {
                toDisplay = (GameBoardElement)this.displayQueue.elementAt(i);
                toDisplay.display(g);
            }
            if (this.currentState != 13 && (this.currentState != 22 || this.lastState != 13)) break block81;
            g.setClip(GameBoard.displayStartX, GameBoard.displayStartY, GameBoard.camWidth, GameBoard.camHeight);
            g.setStrokeStyle(1);
            stepOffsetX = GameBoard.snake.moveColStart - (GameBoard.snake.moveArray.length >> 1 << 1);
            stepOffsetY = GameBoard.snake.moveRowStart - (GameBoard.snake.moveArray.length >> 1 << 1);
            for (i = 0; i < GameBoard.snake.moveArray.length; ++i) {
                for (j = 0; j < GameBoard.snake.moveArray[i].length; ++j) {
                    block82: {
                        if (GameBoard.snake.moveArray[i][j][0] <= -2) continue;
                        tmpTileRow = (i << 1) + GameBoard.snake.moveRowToBoundRow + 1;
                        tmpTileCol = (j << 1) + GameBoard.snake.moveColToBoundCol;
                        displayTileX = ((j << 1) + stepOffsetX) * 20 - GameBoard.camX - GameBoard.offsetX;
                        displayTileY = ((i << 1) + stepOffsetY - 1) * 20 - GameBoard.camY - GameBoard.offsetY;
                        if (Snake.nextState == 6) break block82;
                        if (Snake.nextState != 7) ** GOTO lbl-1000
                    }
                    if (tmpTileRow == GameBoard.snake.tileRow && tmpTileCol == GameBoard.snake.tileCol) {
                        g.setColor(913393);
                    } else if (tmpTileRow == GameBoard.snake.moveInitialRow && tmpTileCol == GameBoard.snake.moveInitialCol) {
                        g.setColor(0xFFFFFF);
                    } else if (GameBoard.snake.moveArray[i][j][0] == -1) {
                        g.setColor(0x444444);
                    } else {
                        g.setColor(15659277);
                    }
                    if (GameBoard.tileLayer2[tmpTileRow][tmpTileCol] != -1 && !GameBoard.tilesAreTransparent || GameBoard.tileLayer1[tmpTileRow][tmpTileCol] != -1 && GameBoard.tileLayer1[tmpTileRow][tmpTileCol + 1] != -1) {
                        g.setClip(displayTileX + GameBoard.offsetX, displayTileY + GameBoard.offsetY + 20, 40, 20);
                        g.drawRect(displayTileX + GameBoard.offsetX + 3, displayTileY + GameBoard.offsetY + 3, 33, 33);
                    }
                    if ((GameBoard.tileLayer2[tmpTileRow - 1][tmpTileCol] == -1 || GameBoard.tilesAreTransparent) && (GameBoard.tileLayer1[tmpTileRow - 1][tmpTileCol] == -1 || GameBoard.tileLayer1[tmpTileRow - 1][tmpTileCol + 1] == -1)) continue;
                    g.setClip(displayTileX + GameBoard.offsetX, displayTileY + GameBoard.offsetY, 40, 20);
                    g.drawRect(displayTileX + GameBoard.offsetX + 3, displayTileY + GameBoard.offsetY + 3, 33, 33);
                }
            }
            g.setStrokeStyle(0);
        }
        if (this.currentState == 22) {
            g.setClip(0, 0, 176, 208);
            g.setColor(5915624);
            g.setStrokeStyle(1);
            for (i = 0; i < GameBoard.AiArray.length && (GameBoard.currentLevel != 14 || i <= 0); ++i) {
                if (!GameBoard.AiArray[i].isAlive || GameBoard.AiArray[i].status == 3 || GameBoard.AiArray[i].status == 4 || GameBoard.AiArray[i].status == 0 || GameBoard.AiArray[i].posX < this.pixelColStart - GameBoard.AiArray[i].fillDisplayQueueOffsetX1 || GameBoard.AiArray[i].posX > this.pixelColEnd + GameBoard.AiArray[i].fillDisplayQueueOffsetX2 || GameBoard.AiArray[i].posY < this.pixelRowStart - GameBoard.AiArray[i].fillDisplayQueueOffsetY1 || GameBoard.AiArray[i].posY > this.pixelRowEnd + GameBoard.AiArray[i].fillDisplayQueueOffsetY2) continue;
                for (j = 0; j < GameBoard.AiArray[i].currentVisionGrid.length; j += 2) {
                    if (GameBoard.AiArray[i].currentVisionGrid[j] <= -1) continue;
                    if (!(GameBoard.tileLayer1[GameBoard.AiArray[i].currentVisionGrid[j] - 1][GameBoard.AiArray[i].currentVisionGrid[j + 1]] == -1 && GameBoard.tileLayer2[GameBoard.AiArray[i].currentVisionGrid[j] - 1][GameBoard.AiArray[i].currentVisionGrid[j + 1]] == -1 || GameBoard.tileLayer1[GameBoard.AiArray[i].currentVisionGrid[j]][GameBoard.AiArray[i].currentVisionGrid[j + 1] + 1] == -1 && GameBoard.tileLayer2[GameBoard.AiArray[i].currentVisionGrid[j]][GameBoard.AiArray[i].currentVisionGrid[j + 1] + 1] == -1)) {
                        g.drawRect(GameBoard.AiArray[i].currentVisionGrid[j + 1] * 20 - GameBoard.camX + 20 - 4, (GameBoard.AiArray[i].currentVisionGrid[j] - 1) * 20 - GameBoard.camY + 20 - 4, 9, 9);
                        continue;
                    }
                    g.fillRect(GameBoard.AiArray[i].currentVisionGrid[j + 1] * 20 - GameBoard.camX + 20 - 4, (GameBoard.AiArray[i].currentVisionGrid[j] - 1) * 20 - GameBoard.camY + 20 - 4, 9, 9);
                }
            }
            g.setStrokeStyle(0);
        }
        if (this.currentState == 12 && !this.hasLaunchedGrenade) {
            g.setClip(0, 0, 176, 208);
            g.setStrokeStyle(1);
            for (j = 0; j < this.grenadeGrid.length; j += 2) {
                if (j == this.grenadeGridPosition) {
                    g.setColor(16743936);
                } else {
                    g.setColor(0xFF0000);
                }
                if (this.grenadeGrid[j] <= -1) continue;
                if (!(GameBoard.tileLayer1[this.grenadeGrid[j] - 1][this.grenadeGrid[j + 1]] == -1 && GameBoard.tileLayer2[this.grenadeGrid[j] - 1][this.grenadeGrid[j + 1]] == -1 || GameBoard.tileLayer1[this.grenadeGrid[j]][this.grenadeGrid[j + 1] + 1] == -1 && GameBoard.tileLayer2[this.grenadeGrid[j]][this.grenadeGrid[j + 1] + 1] == -1)) {
                    g.drawRect(this.grenadeGrid[j + 1] * 20 - GameBoard.camX + 20 - 4, (this.grenadeGrid[j] - 1) * 20 - GameBoard.camY + 20 - 4, 9, 9);
                    continue;
                }
                g.fillRect(this.grenadeGrid[j + 1] * 20 - GameBoard.camX + 20 - 4, (this.grenadeGrid[j] - 1) * 20 - GameBoard.camY + 20 - 4, 9, 9);
            }
            g.setStrokeStyle(0);
        }
        if (this.currentState == 13 || this.currentState == 14 || this.currentState == 22) {
            g.setClip(0, 0, 176, 208);
            this.targetReduceRadius += 2;
            this.targetReduceRadius %= 40;
            for (i = 0; i < GameBoard.AiArray.length; ++i) {
                if (!GameBoard.AiArray[i].isAlive || GameBoard.AiArray[i].posX < this.pixelColStart || GameBoard.AiArray[i].posX > this.pixelColEnd || GameBoard.AiArray[i].posY < this.pixelRowStart || GameBoard.AiArray[i].posY > this.pixelRowEnd || !GameBoard.AiArray[i].isTargetable) continue;
                finalTargetArcWidth = 40 - this.targetReduceRadius;
                g.setColor(16743936);
                g.drawArc(GameBoard.AiArray[i].posX + 20 - GameBoard.camX - (finalTargetArcWidth >> 1), GameBoard.AiArray[i].posY - GameBoard.camY - (finalTargetArcWidth >> 1), finalTargetArcWidth, finalTargetArcWidth, 0, 360);
                g.fillArc(GameBoard.AiArray[i].posX + 20 - GameBoard.camX - 5, GameBoard.AiArray[i].posY - GameBoard.camY - 5, 10, 10, 0, 360);
            }
        }
        if (this.currentState == 14) {
            if (Snake.currentState != 2 && !GameBoard.snake.isAnimated) {
                starSpace = 15;
                starHeight = PSCanvas.imageHeight[36] / 2;
                starWidth = PSCanvas.imageWidth[36] / 4;
                starX = GameBoard.snake.posX + 20 - starWidth / 2 - GameBoard.camX;
                starY = GameBoard.snake.posY - 25 - starHeight / 2 - GameBoard.camY;
                block16: for (i = 0; i < 4; ++i) {
                    starRow = 0;
                    if (1 << i == GameBoard.snake.facingDirection) {
                        starRow = 1;
                    }
                    switch (i) {
                        case 0: {
                            g.setClip(starX, starY - starSpace, starWidth, starHeight);
                            g.drawImage(PSCanvas.imageArray[36], starX, starY - starSpace - starHeight * starRow);
                            continue block16;
                        }
                        case 1: {
                            g.setClip(starX - starSpace, starY, starWidth, starHeight);
                            g.drawImage(PSCanvas.imageArray[36], starX - starSpace - starWidth * i, starY - starHeight * starRow);
                            continue block16;
                        }
                        case 2: {
                            g.setClip(starX, starY + starSpace, starWidth, starHeight);
                            g.drawImage(PSCanvas.imageArray[36], starX - starWidth * i, starY + starSpace - starHeight * starRow);
                            continue block16;
                        }
                        case 3: {
                            g.setClip(starX + starSpace, starY, starWidth, starHeight);
                            g.drawImage(PSCanvas.imageArray[36], starX + starSpace - starWidth * i, starY - starHeight * starRow);
                            continue block16;
                        }
                    }
                }
            }
        }
        if (this.currentState == 11 && !GameBoard.snake.hasFinishedAttack) {
            this.ingameHud.isAttack = true;
            this.targetReduceRadius += 2;
            this.targetReduceRadius %= 40;
            finalTargetArcWidth = 40 - this.targetReduceRadius;
            targetPosX = 0;
            targetPosY = 0;
            g.setClip(0, 0, 176, 208);
            g.setColor(16743936);
            if (GameBoard.snake.isTargetingObject) {
                targetPosX = GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].posX;
                targetPosY = GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].posY;
            } else {
                targetPosX = GameBoard.AiArray[GameBoard.snake.targetList[GameBoard.snake.currentTarget]].posX;
                targetPosY = GameBoard.AiArray[GameBoard.snake.targetList[GameBoard.snake.currentTarget]].posY;
            }
            g.fillArc(targetPosX + 20 - GameBoard.camX - 5, targetPosY - GameBoard.camY - 5, 10, 10, 0, 360);
            g.drawArc(targetPosX + 20 - GameBoard.camX - (finalTargetArcWidth >> 1), targetPosY - GameBoard.camY - (finalTargetArcWidth >> 1), finalTargetArcWidth, finalTargetArcWidth, 0, 360);
        } else {
            this.ingameHud.isAttack = false;
        }
        for (i = 0; i < GameBoard.AiArray.length; ++i) {
            if (!GameBoard.AiArray[i].isAlive) continue;
            displayX = GameBoard.AiArray[i].posX + 10 - GameBoard.camX;
            displayY = GameBoard.AiArray[i].posY - 30 - PSCanvas.imageHeight[29] - GameBoard.camY;
            if (GameBoard.AiArray[i].alertDisplay) {
                if (GameBoard.AiArray[i].isAlerted) {
                    g.setClip(displayX, displayY, PSCanvas.imageWidth[29] / 2, PSCanvas.imageHeight[29]);
                    g.drawImage(PSCanvas.imageArray[29], displayX - PSCanvas.imageWidth[29] / 2, displayY);
                } else if (GameBoard.AiArray[i].isCaution) {
                    g.setClip(displayX, displayY, PSCanvas.imageWidth[29] / 2, PSCanvas.imageHeight[29]);
                    g.drawImage(PSCanvas.imageArray[29], displayX, displayY);
                }
            }
            displayX += 10;
            displayY = GameBoard.AiArray[i].posY - 30 - PSCanvas.imageHeight[30] - GameBoard.camY;
            if (GameBoard.AiArray[i].status != -1) {
                g.setClip(displayX, displayY, PSCanvas.imageWidth[30] / 5, PSCanvas.imageHeight[30]);
                g.drawImage(PSCanvas.imageArray[30], displayX - PSCanvas.imageWidth[30] / 5 * GameBoard.AiArray[i].status, displayY);
            }
            if (GameBoard.AiArray[i].damagePrintDuration >= 20) continue;
            PSCanvas.fontEngine.setSpacing(1);
            if (GameBoard.AiArray[i].damageToPrint < 0) {
                PSCanvas.fontEngine.drawFont(g, 0, Integer.toString(-GameBoard.AiArray[i].damageToPrint), GameBoard.AiArray[i].posX - GameBoard.camX, GameBoard.AiArray[i].posY - GameBoard.camY - GameBoard.AiArray[i].damagePrintDuration, 41);
            } else {
                PSCanvas.fontEngine.drawFont(g, 7, Integer.toString(GameBoard.AiArray[i].damageToPrint), GameBoard.AiArray[i].posX - GameBoard.camX, GameBoard.AiArray[i].posY - GameBoard.camY - GameBoard.AiArray[i].damagePrintDuration, 41);
            }
            PSCanvas.fontEngine.resetSpacing();
            ++GameBoard.AiArray[i].damagePrintDuration;
        }
        if (GameBoard.snake.damagePrintDuration < 20) {
            PSCanvas.fontEngine.setSpacing(1);
            if (GameBoard.snake.damageToPrint < 0) {
                PSCanvas.fontEngine.drawFont(g, 0, Integer.toString(-GameBoard.snake.damageToPrint), GameBoard.snake.posX - GameBoard.camX, GameBoard.snake.posY - GameBoard.camY - GameBoard.snake.damagePrintDuration, 41);
            } else {
                PSCanvas.fontEngine.drawFont(g, 7, Integer.toString(GameBoard.snake.damageToPrint), GameBoard.snake.posX - GameBoard.camX, GameBoard.snake.posY - GameBoard.camY - GameBoard.snake.damagePrintDuration, 41);
            }
            PSCanvas.fontEngine.resetSpacing();
            ++GameBoard.snake.damagePrintDuration;
        }
        if (this.pickUpPrintDuration < 20) {
            PSCanvas.fontEngine.setSpacing(1);
            posText = 37;
            if (GameBoard.snake.posX - GameBoard.camX < 88) {
                posText = 35;
            }
            PSCanvas.fontEngine.drawFont(g, 0, this.pickUpCardPack, GameBoard.snake.posX - GameBoard.camX, GameBoard.snake.posY - GameBoard.camY - this.pickUpPrintDuration, posText);
            PSCanvas.fontEngine.resetSpacing();
            ++this.pickUpPrintDuration;
        }
        if (GameBoard.tileLayer1[GameBoard.snake.tileRow][GameBoard.snake.tileCol] != -1 && GameBoard.tileLayer1[GameBoard.snake.tileRow][GameBoard.snake.tileCol + 1] != -1 && this.displayQueue.contains(GameBoard.snake)) {
            arrowHeight = PSCanvas.imageHeight[31];
            arrowWidth = PSCanvas.imageWidth[31];
            arrowX = GameBoard.snake.posX + 20 - arrowWidth / 2 - GameBoard.camX;
            arrowY = GameBoard.snake.posY - 30 - arrowHeight - GameBoard.camY;
            arrowOffsetY = this.frameCounter % 16;
            if (arrowOffsetY > 8) {
                arrowOffsetY = 16 - arrowOffsetY;
            }
            g.setClip(arrowX, arrowY - (arrowOffsetY /= 2), arrowWidth, arrowHeight);
            g.drawImage(PSCanvas.imageArray[31], arrowX, arrowY - arrowOffsetY);
        }
        if (this.currentState == 7) {
            this.ingameHud.displayCardsOn();
        }
        this.ingameHud.updateDisplayGameboardHud(g);
        if (GameBoard.alertPercent > 0) {
            if (GameBoard.alertPercent > GameBoard.nextAlertPercent) {
                --GameBoard.alertPercent;
            } else if (GameBoard.alertPercent < GameBoard.nextAlertPercent) {
                ++GameBoard.alertPercent;
            }
            this.ingameHud.displayAlert(GameBoard.alertPercent);
        }
        if (this.currentState == 26) {
            this.ingameHud.displayMessageBar(this.messageBarText);
        }
        if (!(this.currentState != 7 && this.currentState != 25 || GameBoard.camIsTraveling)) {
            this.skipPaint = true;
        }
    }

    private void fillDisplayQueue(GameBoardElement gameElement) {
        int posZ = gameElement.posZ;
        if (posZ <= this.firstDisplayY) {
            this.displayQueue.insertElementAt(gameElement, 0);
            this.firstDisplayY = posZ;
        } else {
            int index;
            for (index = 0; index < this.displayQueue.size(); ++index) {
                GameBoardElement tmpElement = (GameBoardElement)this.displayQueue.elementAt(index);
                if (posZ > tmpElement.posZ) continue;
                this.displayQueue.insertElementAt(gameElement, index);
                break;
            }
            if (index == this.displayQueue.size()) {
                this.displayQueue.addElement(gameElement);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateGameLogic(int keyPressed) {
        block374: {
            ++this.frameCounter;
            if (this.frameCounter > 1000) {
                this.frameCounter = 0;
            }
            if (GameBoard.isScriptActive) {
                this.checkActiveScript();
            }
            if (this.waitTimer > 0) {
                if ((keyPressed & 256) != 0) {
                    this.currentState = this.savedState;
                    this.waitTimer = 0;
                }
                --this.waitTimer;
                return;
            }
            if (GameBoard.objectArray != null) {
                for (i = 0; i < GameBoard.objectArray.length; ++i) {
                    if (GameBoard.objectArray[i] == null || !GameBoard.objectArray[i].isExploding) continue;
                    if (!GameBoard.objectArray[i].explosionSpritePlayer.isPlaying()) {
                        switch (GameBoard.objectArray[i].imageId) {
                            case 57: {
                                GameBoard.objectArray[i].explosionSpritePlayer.play(1, 0);
                                break;
                            }
                            default: {
                                GameBoard.objectArray[i].explosionSpritePlayer.play(0, 0);
                                break;
                            }
                        }
                    } else if (GameBoard.objectArray[i].explosionSpritePlayer.isCurrentFrameLast()) {
                        GameBoard.objectArray[i].isExploding = false;
                        GameBoard.objectArray[i].isAlive = false;
                    }
                    GameBoard.objectArray[i].update();
                }
            }
            if (this.forceCamTraveling && this.savedState != 2) {
                if ((keyPressed & 256) != 0) {
                    this.currentState = this.savedState;
                    this.forceCamTraveling = false;
                }
                this.updateTravelCam();
                if (!this.forceCamTraveling) {
                    this.currentState = this.savedState;
                }
                return;
            }
            if (this.nextState != this.currentState) {
                if (!this.enteringState) {
                    this.exitState(this.currentState);
                }
                if (!this.exitingState) {
                    this.enterState(this.nextState);
                }
                if (!this.enteringState && !this.exitingState) {
                    this.lastState = this.currentState;
                    this.currentState = this.nextState;
                }
                PSCanvas.keyClear();
                keyPressed = 0;
            }
            if (this.nextState != this.currentState) break block374;
            block4 : switch (this.currentState) {
                case 1: {
                    if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                        this.ingameHud.nextDialogText();
                        if (this.ingameHud.isDialogOver()) {
                            this.nextState = this.lastState == 14 ? (GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7) : this.lastState;
                        }
                        PSCanvas.keyClear();
                        break;
                    }
                    if ((keyPressed & 256) == 0) break;
                    this.ingameHud.endDialog();
                    if (this.lastState == 14) {
                        if (GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0) {
                            this.nextState = 15;
                            break;
                        }
                        this.nextState = 7;
                        break;
                    }
                    this.nextState = this.lastState;
                    break;
                }
                case 27: {
                    if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                        this.ingameHud.nextDialogText();
                        if (this.ingameHud.isDialogOver()) {
                            this.nextState = this.lastState;
                        }
                        PSCanvas.keyClear();
                        break;
                    }
                    if ((keyPressed & 256) == 0) break;
                    this.ingameHud.endDialog();
                    this.nextState = this.lastState;
                    break;
                }
                case 2: {
                    if ((keyPressed & 256) != 0 || this.skipScripts) {
                        this.travelCamPath = null;
                        GameBoard.camIsTraveling = false;
                        this.setCam(GameBoard.snake.posX, GameBoard.snake.posY);
                        while (this.checkActiveScript()) {
                            if (GameBoard.scriptArray[this.currentScript][4] == 7) {
                                this.executeScript();
                                return;
                            }
                            ++this.currentScript;
                        }
                        this.skipScripts = false;
                        GameBoard.isScriptActive = false;
                        PSCanvas.soundManager.play(1, Constants.LEVELS_MUSIC[GameBoard.currentLevel], -1);
                        this.nextState = 23;
                    }
                    if (GameBoard.camIsTraveling) break;
                    if (this.checkActiveScript()) {
                        this.executeScript();
                        break;
                    }
                    PSCanvas.soundManager.play(1, Constants.LEVELS_MUSIC[GameBoard.currentLevel], -1);
                    this.nextState = 23;
                    break;
                }
                case 3: {
                    this.missionStarted = false;
                    if (this.currentScript < GameBoard.scriptArray.length) {
                        if ((this.missionType == 2 || this.missionType == 1 || this.missionType == 3) && GameBoard.scriptArray[this.currentScript][4] != 7 && GameBoard.scriptArray[this.currentScript][4] != 8 || this.missionType == 4 && GameBoard.scriptArray[this.currentScript][4] != 7) {
                            ++this.currentScript;
                            break;
                        }
                        this.executeScript();
                        break;
                    }
                    if (this.missionType != 0 || GameBoard.currentLevel == 14) {
                        PSCanvas.nextState = 4;
                        return;
                    }
                    this.unloadLevel();
                    if (!this.isProgressUpdated) {
                        this.updateGameProgress();
                    }
                    if (PSCanvas.demoMode == 0) {
                        if ((PSCanvas.completedLevel = ++GameBoard.currentLevel) >= Constants.LEVELS.length) {
                            PSCanvas.completedLevel = Constants.LEVELS.length - 1;
                        }
                        this.nextState = 2;
                    } else if (PSCanvas.demoMode != 0 && GameBoard.currentLevel < 6) {
                        if ((PSCanvas.completedLevel = ++GameBoard.currentLevel) >= Constants.LEVELS.length) {
                            PSCanvas.completedLevel = Constants.LEVELS.length - 1;
                        }
                        this.nextState = 2;
                    } else if (PSCanvas.gmgMode == 0) {
                        this.nextState = 29;
                    } else {
                        if ((PSCanvas.completedLevel = ++GameBoard.currentLevel) >= Constants.LEVELS.length) {
                            PSCanvas.completedLevel = Constants.LEVELS.length - 1;
                        }
                        this.nextState = 2;
                    }
                    PSCanvas.saveData();
                    PSCanvas.resetCardPacksNumber();
                    break;
                }
                case 29: {
                    if ((keyPressed & 256) != 0) {
                        PSCanvas.nextState = 4;
                        break;
                    }
                    if ((keyPressed & 512) == 0 || PSCanvas.demoMode != 2) break;
                    isBrowserOpened = false;
                    try {
                        PSCanvas.canBeDestroyed = true;
                        isBrowserOpened = PSCanvas.midlet.platformRequest(PSCanvas.demoUrl);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    PSCanvas.midlet.notifyDestroyed();
                    break;
                }
                case 4: {
                    if ((keyPressed & 256) != 0) {
                        this.messageBarText = " ";
                        this.unloadLevel();
                        PSCanvas.resetCardPacksNumber();
                        if (this.levelUnloaded) {
                            this.loadLevel(this.LEVELS_BIN_NAME[GameBoard.currentLevel]);
                            this.initLevel(this.missionType);
                            this.levelUnloaded = false;
                        }
                        this.nextState = 2;
                        break;
                    }
                    if ((keyPressed & 512) == 0) break;
                    this.ingameHud.setMessage(483);
                    this.nextState = 25;
                    break;
                }
                case 5: {
                    if (GameBoard.camIsTraveling) break;
                    this.nextState = 6;
                    break;
                }
                case 6: {
                    if (this.isInitDrawCards) {
                        GameBoard.snake.deck.drawCards(6);
                        this.isInitDrawCards = false;
                    } else {
                        GameBoard.snake.deck.drawCards(2);
                    }
                    GameBoard.snake.deck.selectNextCard();
                    this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                    this.nextState = 7;
                    break;
                }
                case 7: {
                    this.ingameHud.displayCardsOn();
                    if (keyPressed != 0) {
                        this.skipPaint = false;
                    }
                    option = 0;
                    if (GameBoard.snake.deck.getHandCardsCount() == 0) {
                        this.ingameHud.displayCardsOff();
                    } else {
                        if (!this.ingameHud.isMenuDataLoaded()) {
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        }
                        option = this.ingameHud.executeCardMenu();
                    }
                    if ((keyPressed & 16) == 0 && (keyPressed & 512) == 0) ** GOTO lbl291
                    if (this.ingameHud.isKeyBlocked()) ** GOTO lbl289
                    if (GameBoard.snake.deck.getHandCardsCount() == 0) ** GOTO lbl286
                    this.tmpCard = GameBoard.snake.deck.getSelectedCard();
                    v0 = previewCost = GameBoard.snake.nextCardCost0 != false ? 0 : CardSet.CARD_LIST[this.tmpCard].getCardCost();
                    if (CardSet.CARD_LIST[this.tmpCard].getCardSubType() == 5) {
                        previewCost = -CardSet.CARD_LIST[this.tmpCard].getCardAttackDamage();
                    }
                    this.ingameHud.setPreviewCost(previewCost);
                    switch (option) {
                        case 1: {
                            if (CardSet.CARD_LIST[this.tmpCard].getCardType() != 0) ** GOTO lbl262
                            if ((GameBoard.tileLayerZ[GameBoard.snake.tileRow][GameBoard.snake.tileCol] & 32) != 0) ** GOTO lbl202
                            if (Snake.currentState != 2) ** GOTO lbl205
lbl202:
                            // 2 sources

                            this.ingameHud.setMessage(475);
                            this.nextState = 24;
                            break;
lbl205:
                            // 1 sources

                            if (CardSet.CARD_LIST[this.tmpCard].getCardSubType() == 26) {
                                visionGrid = null;
                                switch (GameBoard.snake.facingDirection) {
                                    case 1: {
                                        visionGrid = this.GRENADE_GRID[0];
                                        break;
                                    }
                                    case 2: {
                                        visionGrid = this.GRENADE_GRID[1];
                                        break;
                                    }
                                    case 4: {
                                        visionGrid = this.GRENADE_GRID[2];
                                        break;
                                    }
                                    case 8: {
                                        visionGrid = this.GRENADE_GRID[3];
                                        break;
                                    }
                                }
                                GameBoard.computeVisionGrid(visionGrid, this.grenadeGrid, GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.snake.facingDirection);
                                if (this.grenadeGrid[0] != -1) {
                                    this.grenadeGridPosition = 0;
                                    this.missileLaunching = false;
                                    this.nextState = 12;
                                    break;
                                }
                                this.ingameHud.setMessage(474);
                                this.nextState = 24;
                                break;
                            }
                            if (CardSet.CARD_LIST[this.tmpCard].getCardSubType() == 27) {
                                visionGrid = null;
                                switch (GameBoard.snake.facingDirection) {
                                    case 1: {
                                        visionGrid = this.GRENADE_GRID[0];
                                        break;
                                    }
                                    case 2: {
                                        visionGrid = this.GRENADE_GRID[1];
                                        break;
                                    }
                                    case 4: {
                                        visionGrid = this.GRENADE_GRID[2];
                                        break;
                                    }
                                    case 8: {
                                        visionGrid = this.GRENADE_GRID[3];
                                        break;
                                    }
                                }
                                GameBoard.computeVisionGrid(visionGrid, this.grenadeGrid, GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.snake.facingDirection);
                                if (this.grenadeGrid[0] != -1) {
                                    this.grenadeGridPosition = 0;
                                    this.missileLaunching = true;
                                    this.nextState = 12;
                                    break;
                                }
                                this.ingameHud.setMessage(474);
                                this.nextState = 24;
                                break;
                            }
                            if (CardSet.CARD_LIST[this.tmpCard].getCardSubType() == 25) {
                                this.nextState = 8;
                                break;
                            }
                            if (GameBoard.checkSnakeSeeingAI(CardSet.CARD_LIST[this.tmpCard].getAttackRange() * 2)) {
                                this.nextState = 11;
                                break;
                            }
                            this.ingameHud.setMessage(474);
                            this.nextState = 24;
                            break;
lbl262:
                            // 1 sources

                            if (CardSet.CARD_LIST[this.tmpCard].getCardType() == 2) {
                                this.nextState = 8;
                                break;
                            }
                            this.nextState = 8;
                            break;
                        }
                        case 0: {
                            this.nextState = 13;
                            break;
                        }
                        case 2: {
                            if (CardSet.CARD_LIST[this.tmpCard].getCardSubType() != 11) ** GOTO lbl281
                            if (Snake.currentState == 3) ** GOTO lbl278
                            if (Snake.currentState != 2) ** GOTO lbl281
lbl278:
                            // 2 sources

                            this.ingameHud.setMessage(475);
                            this.nextState = 24;
                            break;
lbl281:
                            // 2 sources

                            this.nextState = 9;
                            break;
                        }
                        case 3: {
                            this.nextState = 10;
                        }
                    }
                    ** GOTO lbl289
lbl286:
                    // 1 sources

                    this.ingameHud.displayCardsOff();
                    this.ingameHud.clearIngameMenu();
                    this.nextState = 15;
lbl289:
                    // 3 sources

                    PSCanvas.keyClear();
                    ** GOTO lbl316
lbl291:
                    // 1 sources

                    if ((keyPressed & 64) != 0) {
                        this.nextState = 22;
                        PSCanvas.keyClear();
                    } else if ((keyPressed & 256) != 0) {
                        this.ingameHud.resetPreviewCost();
                        this.ingameHud.initIngameMenu();
                        this.nextState = 15;
                        PSCanvas.keyClear();
                    } else if ((keyPressed & 8) != 0 && !this.ingameHud.isKeyBlocked()) {
                        if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                            PSCanvas.soundManager.play(0, 18, 0);
                            GameBoard.snake.deck.selectNextCard();
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        } else {
                            this.ingameHud.displayCardsOff();
                        }
                    } else if ((keyPressed & 2) != 0 && !this.ingameHud.isKeyBlocked()) {
                        if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                            PSCanvas.soundManager.play(0, 18, 0);
                            GameBoard.snake.deck.selectPrevCard();
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        } else {
                            this.ingameHud.displayCardsOff();
                        }
                    }
lbl316:
                    // 9 sources

                    PSCanvas.keyClear();
                    break;
                }
                case 11: {
                    snakeEquipmentIndex = GameBoard.snake.getEquipment(5);
                    v1 = snakeEquipment = snakeEquipmentIndex != -1 ? GameBoard.snake.equipment[snakeEquipmentIndex] : -1;
                    if (snakeEquipment != -1) {
                        this.ingameHud.setPreviewCost(0);
                    }
                    if (this.ingameHud.isKeyBlocked() || GameBoard.camIsTraveling) break;
                    if (GameBoard.snake.isTargetingObject) {
                        this.travelCamTo(GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].posX, GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].posY, 40);
                    } else {
                        this.travelCamTo(GameBoard.AiArray[GameBoard.snake.targetList[GameBoard.snake.currentTarget]].posX, GameBoard.AiArray[GameBoard.snake.targetList[GameBoard.snake.currentTarget]].posY, 40);
                    }
                    if (this.checkDeaths()) {
                        return;
                    }
                    if (GameBoard.snake.hasFinishedAttack) {
                        if (this.checkActiveScript()) {
                            this.executeScript();
                        } else {
                            this.nextState = GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7;
                        }
                    } else if ((keyPressed & 8) != 0 || (keyPressed & 4) != 0) {
                        this.targetReduceRadius = 0;
                        --GameBoard.snake.currentTarget;
                        if (GameBoard.snake.currentTarget < 0) {
                            if (GameBoard.snake.isTargetingObject && GameBoard.snake.targetList != null) {
                                GameBoard.snake.currentTarget = GameBoard.snake.targetList.length - 1;
                                GameBoard.snake.isTargetingObject = false;
                            } else if (GameBoard.snake.isTargetingObject && GameBoard.snake.targetList == null) {
                                GameBoard.snake.currentTarget = GameBoard.snake.targetObjectList.length - 1;
                            } else if (!GameBoard.snake.isTargetingObject && GameBoard.snake.targetObjectList == null) {
                                GameBoard.snake.currentTarget = GameBoard.snake.targetList.length - 1;
                            } else {
                                GameBoard.snake.currentTarget = GameBoard.snake.targetObjectList.length - 1;
                                GameBoard.snake.isTargetingObject = true;
                            }
                        }
                    } else if ((keyPressed & 2) != 0 || (keyPressed & 1) != 0) {
                        this.targetReduceRadius = 0;
                        ++GameBoard.snake.currentTarget;
                        v2 = maxTarget = GameBoard.snake.isTargetingObject != false ? GameBoard.snake.targetObjectList.length : GameBoard.snake.targetList.length;
                        if (GameBoard.snake.currentTarget >= maxTarget) {
                            GameBoard.snake.currentTarget = 0;
                            if (GameBoard.snake.isTargetingObject && GameBoard.snake.targetList != null) {
                                GameBoard.snake.isTargetingObject = false;
                            } else if (!GameBoard.snake.isTargetingObject && GameBoard.snake.targetObjectList != null) {
                                GameBoard.snake.isTargetingObject = true;
                            }
                        }
                    } else if ((keyPressed & 32) != 0 || (keyPressed & 256) != 0) {
                        GameBoard.snake.unsetAttack();
                        this.ingameHud.resetPreviewCost();
                        this.nextState = 7;
                    } else if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                        if (snakeEquipment != -1) {
                            v3 = snakeEquipmentIndex;
                            GameBoard.snake.equipmentUses[v3] = GameBoard.snake.equipmentUses[v3] - 1;
                            if (GameBoard.snake.equipmentUses[snakeEquipmentIndex] == 0) {
                                GameBoard.snake.removeEquipment(snakeEquipmentIndex);
                            }
                        } else {
                            GameBoard.snake.hasFinishedAttack = true;
                            GameBoard.snake.addCost(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost());
                            this.totalLevelCost += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost();
                            --GameBoard.snake.actionNumberLeft;
                            if (8 != CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect()) {
                                GameBoard.checkAiHearing(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
                            }
                            if (GameBoard.snake.isTargetingObject) {
                                GameBoard.snake.attack(GameBoard.computeFullDirection(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].tileRow, GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].tileCol, 0));
                                GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].explode();
                                this.explode(GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].tileRow, GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].tileCol, 1, GameBoard.objectArray[GameBoard.snake.targetObjectList[GameBoard.snake.currentTarget]].objectDamage, 4);
                                PSCanvas.soundManager.play(0, 9, 0);
                                PSCanvas.setVibration(200);
                            } else {
                                switch (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType()) {
                                    case 19: {
                                        PSCanvas.soundManager.play(0, 14, 0);
                                        PSCanvas.setVibration(200);
                                        break;
                                    }
                                    case 23: {
                                        PSCanvas.soundManager.play(0, 16, 0);
                                        PSCanvas.setVibration(200);
                                        break;
                                    }
                                    case 27: {
                                        PSCanvas.soundManager.play(0, 17, 0);
                                        PSCanvas.setVibration(200);
                                    }
                                }
                                GameBoard.snake.attack(GameBoard.computeFullDirection(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[GameBoard.snake.targetList[GameBoard.snake.currentTarget]].tileRow, GameBoard.AiArray[GameBoard.snake.targetList[GameBoard.snake.currentTarget]].tileCol, 0));
                                range = CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getAreaOfEffect();
                                hitListSize = range + 1;
                                hitListSize *= hitListSize;
                                aiHitList = new int[hitListSize];
                                for (i = 0; i < hitListSize; ++i) {
                                    aiHitList[i] = -1;
                                }
                                aiHitList[0] = GameBoard.snake.targetList[GameBoard.snake.currentTarget];
                                col = GameBoard.AiArray[aiHitList[0]].tileCol;
                                row = GameBoard.AiArray[aiHitList[0]].tileRow;
                                if (range > 0) {
                                    index = 1;
                                    startCol = col - range * 2;
                                    startRow = row - range * 2;
                                    endCol = col + range * 2;
                                    endRow = row + range * 2;
                                    for (k = 0; k < GameBoard.AiArray.length; ++k) {
                                        if (!GameBoard.AiArray[k].isAlive || GameBoard.AiArray[k].tileRow < startRow || GameBoard.AiArray[k].tileRow > endRow || GameBoard.AiArray[k].tileCol < startCol || GameBoard.AiArray[k].tileCol > endCol || !GameBoard.lineOfSight(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[k].tileRow, GameBoard.AiArray[k].tileCol, GameBoard.computeDirection(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[k].tileRow, GameBoard.AiArray[k].tileCol)) || GameBoard.AiArray[k].tileCol == col || GameBoard.AiArray[k].tileRow == row) continue;
                                        aiHitList[index] = k;
                                        ++index;
                                    }
                                }
                                damage = 0;
                                for (i = 0; i < CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getAttacksNumber(); ++i) {
                                    random = GameBoard.getRandom(0, 100);
                                    if (random > CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardHitChance()) continue;
                                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect() == 6) {
                                        for (k = 0; k < hitListSize; ++k) {
                                            if (aiHitList[k] == -1) continue;
                                            ++GameBoard.AiArray[aiHitList[k]].currentCost;
                                        }
                                    }
                                    damage += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage();
                                }
                                if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect() == 6) {
                                    this.initiativeList.removeElement(GameBoard.snake);
                                    this.initiativeList.trimToSize();
                                    this.fillInitiativeQueue(GameBoard.snake);
                                    for (i = 0; i < GameBoard.AiArray.length; ++i) {
                                        if (!GameBoard.AiArray[i].isAlive || GameBoard.AiArray[i].type == 6 || GameBoard.AiArray[i].type == 7 || GameBoard.AiArray[i].type == 9) continue;
                                        this.initiativeList.removeElement(GameBoard.AiArray[i]);
                                        this.initiativeList.trimToSize();
                                    }
                                    for (i = 0; i < GameBoard.AiArray.length; ++i) {
                                        if (!GameBoard.AiArray[i].isAlive || GameBoard.AiArray[i].type == 6 || GameBoard.AiArray[i].type == 7 || GameBoard.AiArray[i].type == 9) continue;
                                        this.fillInitiativeQueue(GameBoard.AiArray[i]);
                                    }
                                    index = 1;
                                    e = this.initiativeList.elements();
                                    while (e.hasMoreElements()) {
                                        ((GameBoardElement)e.nextElement()).initiativeTurnNumber = index++;
                                    }
                                }
                                for (k = 0; k < hitListSize; ++k) {
                                    if (aiHitList[k] == -1) continue;
                                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect() == 9 && GameBoard.AiArray[aiHitList[k]].isMachine) {
                                        GameBoard.AiArray[aiHitList[k]].setDamage(damage * 2, 0, CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect());
                                    } else {
                                        GameBoard.AiArray[aiHitList[k]].setDamage(damage, 0, CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect());
                                    }
                                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect() == 4 && !GameBoard.AiArray[aiHitList[k]].immuneStun) {
                                        GameBoard.AiArray[aiHitList[k]].fall();
                                    }
                                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect() == 7) {
                                        GameBoard.AiArray[aiHitList[k]].knockdown(GameBoard.snake.facingDirection, aiHitList[k]);
                                        continue;
                                    }
                                    GameBoard.AiArray[aiHitList[k]].isHit();
                                }
                                snakeEquipmentIndex = GameBoard.snake.getEquipment(9);
                                v4 = snakeEquipment = snakeEquipmentIndex != -1 ? GameBoard.snake.equipment[snakeEquipmentIndex] : -1;
                                if (snakeEquipment != -1) {
                                    v5 = snakeEquipmentIndex;
                                    GameBoard.snake.equipmentUses[v5] = GameBoard.snake.equipmentUses[v5] - 1;
                                    if (GameBoard.snake.equipmentUses[snakeEquipmentIndex] == 0) {
                                        GameBoard.snake.removeEquipment(snakeEquipmentIndex);
                                    }
                                    for (k = 0; k < hitListSize; ++k) {
                                        GameBoard.AiArray[aiHitList[k]].knockdown(GameBoard.snake.facingDirection, aiHitList[k]);
                                    }
                                }
                            }
                            GameBoard.snake.deck.useSelectedCard();
                            if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                                this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                            } else {
                                this.ingameHud.displayCardsOff();
                            }
                            this.ingameHud.resetPreviewCost();
                        }
                    }
                    PSCanvas.keyClear();
                    break;
                }
                case 12: {
                    this.travelCamTo(this.grenadeGrid[this.grenadeGridPosition + 1] * 20, this.grenadeGrid[this.grenadeGridPosition] * 20, 10);
                    if (this.hasLaunchedGrenade) ** GOTO lbl557
                    positionFound = false;
                    if ((keyPressed & 8) == 0) ** GOTO lbl503
                    for (i = 1; i < this.grenadeGrid.length; i += 2) {
                        if (this.grenadeGrid[i - 1] != this.grenadeGrid[this.grenadeGridPosition] || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition + 1] + 2) continue;
                        positionFound = true;
                        this.grenadeGridPosition = i - 1;
                        break;
                    }
                    if (positionFound) ** GOTO lbl540
                    for (i = 1; i < this.grenadeGrid.length; i += 2) {
                        if (this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition + 1] + 2) continue;
                        this.grenadeGridPosition = i - 1;
                        ** GOTO lbl540
                    }
                    ** GOTO lbl540
lbl503:
                    // 1 sources

                    if ((keyPressed & 2) == 0) ** GOTO lbl516
                    for (i = 1; i < this.grenadeGrid.length; i += 2) {
                        if (this.grenadeGrid[i] <= -1 || this.grenadeGrid[i - 1] != this.grenadeGrid[this.grenadeGridPosition] || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition + 1] - 2) continue;
                        positionFound = true;
                        this.grenadeGridPosition = i - 1;
                        break;
                    }
                    if (positionFound) ** GOTO lbl540
                    for (i = 1; i < this.grenadeGrid.length; i += 2) {
                        if (this.grenadeGrid[i] <= -1 || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition + 1] - 2) continue;
                        this.grenadeGridPosition = i - 1;
                        ** GOTO lbl540
                    }
                    ** GOTO lbl540
lbl516:
                    // 1 sources

                    if ((keyPressed & 1) == 0) ** GOTO lbl529
                    for (i = 0; i < this.grenadeGrid.length; i += 2) {
                        if (this.grenadeGrid[i] <= -1 || this.grenadeGrid[i + 1] != this.grenadeGrid[this.grenadeGridPosition + 1] || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition] - 2) continue;
                        positionFound = true;
                        this.grenadeGridPosition = i;
                        break;
                    }
                    if (positionFound) ** GOTO lbl540
                    for (i = 0; i < this.grenadeGrid.length; i += 2) {
                        if (this.grenadeGrid[i] <= -1 || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition] - 2) continue;
                        this.grenadeGridPosition = i;
                        ** GOTO lbl540
                    }
                    ** GOTO lbl540
lbl529:
                    // 1 sources

                    if ((keyPressed & 4) != 0) {
                        for (i = 0; i < this.grenadeGrid.length; i += 2) {
                            if (this.grenadeGrid[i] <= -1 || this.grenadeGrid[i + 1] != this.grenadeGrid[this.grenadeGridPosition + 1] || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition] + 2) continue;
                            positionFound = true;
                            this.grenadeGridPosition = i;
                            break;
                        }
                        if (!positionFound) {
                            for (i = 0; i < this.grenadeGrid.length; i += 2) {
                                if (this.grenadeGrid[i] <= -1 || this.grenadeGrid[i] != this.grenadeGrid[this.grenadeGridPosition] + 2) continue;
                                this.grenadeGridPosition = i;
                                break;
                            }
                        }
                    }
lbl540:
                    // 15 sources

                    if (!((keyPressed & 16) == 0 && (keyPressed & 512) == 0 || this.ingameHud.isKeyBlocked())) {
                        launchingDirection = GameBoard.computeFullDirection(GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.grenadeGrid[this.grenadeGridPosition], this.grenadeGrid[this.grenadeGridPosition + 1], 0);
                        if (this.missileLaunching) {
                            GameBoard.snake.attack(launchingDirection);
                            this.computeProjectilePath(GameBoard.snake.tileCol * 20, GameBoard.snake.tileRow * 20 - 20, this.grenadeGrid[this.grenadeGridPosition + 1] * 20, this.grenadeGrid[this.grenadeGridPosition] * 20, 0, launchingDirection);
                            this.createProjectile(GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.grenadeGrid[this.grenadeGridPosition], this.grenadeGrid[this.grenadeGridPosition + 1], true);
                        } else {
                            GameBoard.snake.attack(GameBoard.computeFullDirection(GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.grenadeGrid[this.grenadeGridPosition], this.grenadeGrid[this.grenadeGridPosition + 1], 0));
                            this.computeProjectilePath(GameBoard.snake.tileCol * 20, GameBoard.snake.tileRow * 20 - 20, this.grenadeGrid[this.grenadeGridPosition + 1] * 20, this.grenadeGrid[this.grenadeGridPosition] * 20, 40, launchingDirection);
                            this.createProjectile(GameBoard.snake.tileRow, GameBoard.snake.tileCol, this.grenadeGrid[this.grenadeGridPosition], this.grenadeGrid[this.grenadeGridPosition + 1], false);
                        }
                        GameBoard.objectArray[0].objectDamage = CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage();
                        this.hasLaunchedGrenade = true;
                    } else if ((keyPressed & 256) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.nextState = 7;
                        this.ingameHud.resetPreviewCost();
                    }
                    ** GOTO lbl580
lbl557:
                    // 1 sources

                    if (GameBoard.objectArray[0] != null) {
                        GameBoard.snake.update(0);
                        if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardEffect() == 3) {
                            this.animateProjectile(3);
                        } else {
                            this.animateProjectile(4);
                        }
                    } else {
                        if (this.checkDeaths()) {
                            return;
                        }
                        --GameBoard.snake.actionNumberLeft;
                        GameBoard.snake.addCost(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost());
                        this.totalLevelCost += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost();
                        GameBoard.snake.deck.useSelectedCard();
                        this.ingameHud.displayCardsOff();
                        if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        } else {
                            this.ingameHud.displayCardsOff();
                        }
                        if (this.checkActiveScript()) {
                            this.executeScript();
                        } else {
                            this.nextState = GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7;
                        }
                        this.ingameHud.resetPreviewCost();
                    }
lbl580:
                    // 5 sources

                    PSCanvas.keyClear();
                    break;
                }
                case 8: {
                    this.ingameHud.displayCardsOn();
                    this.ingameHud.setMessage(476);
                    if ((keyPressed & 16) == 0 && (keyPressed & 512) == 0 || this.ingameHud.isKeyBlocked()) ** GOTO lbl632
                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() != 13) ** GOTO lbl592
                    if ((GameBoard.nextAlertPercent -= CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage()) <= 0) {
                        GameBoard.nextAlertPercent = 0;
                        GameBoard.alertPercent = 0;
                        GameBoard.setAlert(false);
                    }
                    ** GOTO lbl612
lbl592:
                    // 1 sources

                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() != 12) ** GOTO lbl597
                    GameBoard.snake.setDamage(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage(), -1);
                    if (GameBoard.snake.lifeNumberLeft > GameBoard.snake.maxLifeNumber) {
                        GameBoard.snake.lifeNumberLeft = GameBoard.snake.maxLifeNumber;
                    }
                    ** GOTO lbl612
lbl597:
                    // 1 sources

                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() != 7 || GameBoard.snake.maxActionNumber > 4) ** GOTO lbl603
                    GameBoard.snake.maxActionNumber += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage();
                    GameBoard.snake.actionNumberLeft += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage();
                    GameBoard.snake.effectCard = GameBoard.snake.deck.getSelectedCard();
                    GameBoard.snake.turnEffectCount = CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardHitChance();
                    ** GOTO lbl612
lbl603:
                    // 1 sources

                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() != 25) ** GOTO lbl610
                    for (i = 1; i < 5; ++i) {
                        if (GameBoard.objectArray[i] != null && GameBoard.objectArray[i].isAlive) continue;
                        GameBoard.objectArray[i] = new GameBoardObject(GameBoard.snake.tileRow, GameBoard.snake.tileCol, 26);
                        GameBoard.objectArray[i].objectDamage = CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage();
                        ** GOTO lbl612
                    }
                    ** GOTO lbl612
lbl610:
                    // 1 sources

                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 10) {
                        this.generalEffectCard = GameBoard.snake.deck.getSelectedCard();
                    }
lbl612:
                    // 8 sources

                    if (CardSet.CARD_LIST[this.tmpCard].getCardSubType() == 5) {
                        GameBoard.snake.currentCost = GameBoard.snake.currentCost >= CardSet.CARD_LIST[this.tmpCard].getCardAttackDamage() ? (GameBoard.snake.currentCost -= CardSet.CARD_LIST[this.tmpCard].getCardAttackDamage()) : 0;
                    } else {
                        GameBoard.snake.addCost(CardSet.CARD_LIST[this.tmpCard].getCardCost());
                        this.totalLevelCost += CardSet.CARD_LIST[this.tmpCard].getCardCost();
                    }
                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 28) {
                        GameBoard.snake.nextCardCost0 = true;
                    }
                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 8) {
                        GameBoard.snake.deck.discardCardsFromHand(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardAttackDamage(), CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardHitChance());
                    } else {
                        GameBoard.snake.deck.useSelectedCard();
                    }
                    this.ingameHud.displayCardsOff();
                    if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                        this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                    } else {
                        this.ingameHud.displayCardsOff();
                    }
                    --GameBoard.snake.actionNumberLeft;
                    this.nextState = GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7;
                    this.ingameHud.resetPreviewCost();
                    ** GOTO lbl635
lbl632:
                    // 1 sources

                    if ((keyPressed & 256) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.nextState = 7;
                        this.ingameHud.resetPreviewCost();
                    }
lbl635:
                    // 4 sources

                    PSCanvas.keyClear();
                    break;
                }
                case 9: {
                    if (GameBoard.snake.equipment[GameBoard.snake.equipIndex] != -1) {
                        this.ingameHud.setMessage(478);
                    } else {
                        this.ingameHud.setMessage(477);
                    }
                    if (!((keyPressed & 16) == 0 && (keyPressed & 512) == 0 || this.ingameHud.isKeyBlocked())) {
                        this.ingameHud.displayEquipOff();
                        --GameBoard.snake.actionNumberLeft;
                        GameBoard.snake.addCost(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost());
                        this.totalLevelCost += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost();
                        GameBoard.snake.equipment[GameBoard.snake.equipIndex] = GameBoard.snake.deck.getSelectedCard();
                        if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 5 || CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 9 || CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 15) {
                            GameBoard.snake.equipmentUses[GameBoard.snake.equipIndex] = CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getAttacksNumber();
                        }
                        GameBoard.snake.deck.useSelectedCard();
                        this.ingameHud.displayCardsOff();
                        GameBoard.snake.equipIndex = 0;
                        if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        } else {
                            this.ingameHud.displayCardsOff();
                        }
                        this.nextState = GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7;
                        this.ingameHud.resetPreviewCost();
                    } else if ((keyPressed & 256) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.nextState = 7;
                        this.ingameHud.resetPreviewCost();
                    } else if ((keyPressed & 2) != 0 && !this.ingameHud.isKeyBlocked()) {
                        --GameBoard.snake.equipIndex;
                        if (GameBoard.snake.equipIndex < 0) {
                            GameBoard.snake.equipIndex = GameBoard.snake.maxEquipmentNumber - 1;
                        }
                    } else if ((keyPressed & 8) != 0 && !this.ingameHud.isKeyBlocked()) {
                        ++GameBoard.snake.equipIndex;
                        if (GameBoard.snake.equipIndex > GameBoard.snake.maxEquipmentNumber - 1) {
                            GameBoard.snake.equipIndex = 0;
                        }
                    }
                    PSCanvas.keyClear();
                    break;
                }
                case 10: {
                    this.ingameHud.displayCardsOn();
                    this.ingameHud.setMessage(479);
                    this.ingameHud.setPreviewCost(3);
                    if (!((keyPressed & 16) == 0 && (keyPressed & 512) == 0 || this.ingameHud.isKeyBlocked())) {
                        GameBoard.snake.currentCost += 3;
                        this.totalLevelCost += 3;
                        --GameBoard.snake.actionNumberLeft;
                        GameBoard.snake.deck.useSelectedCard();
                        this.ingameHud.displayCardsOff();
                        if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        }
                        this.nextState = GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7;
                        this.ingameHud.resetPreviewCost();
                    } else if ((keyPressed & 256) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.nextState = 7;
                        this.ingameHud.resetPreviewCost();
                    }
                    PSCanvas.keyClear();
                    break;
                }
                case 24: {
                    if ((keyPressed & 256) == 0 && (keyPressed & 16) == 0 && (keyPressed & 512) == 0 || this.ingameHud.isKeyBlocked()) break;
                    this.nextState = 7;
                    this.ingameHud.resetPreviewCost();
                    break;
                }
                case 13: {
                    if (Snake.currentState == 7) {
                        this.travelCam(GameBoard.snake.posX, GameBoard.snake.posY, GameBoard.snake.facingDirection, 5);
                    } else {
                        this.travelCam(GameBoard.snake.posX, GameBoard.snake.posY, GameBoard.snake.facingDirection, 15);
                    }
                    if ((keyPressed & 256) != 0) {
                        if (GameBoard.snake.moveNumberLeft == GameBoard.snake.moveNumber || GameBoard.snake.moveInitialState == 3 && GameBoard.snake.moveNumberStanding == GameBoard.snake.moveNumber) {
                            GameBoard.snake.cancelMove();
                            GameBoard.checkSnakeSeeingAI(10);
                            this.nextState = 7;
                            this.ingameHud.resetPreviewCost();
                            if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                                this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                            } else {
                                this.ingameHud.displayCardsOff();
                            }
                        } else if (!GameBoard.snake.blockCancelMove) {
                            for (i = 1; i < 5; ++i) {
                                if (GameBoard.objectArray[i] == null || !GameBoard.objectArray[i].isAlive || !GameBoard.objectArray[i].isActive || GameBoard.snake.moveInitialCol != GameBoard.objectArray[i].tileCol || GameBoard.snake.moveInitialRow != GameBoard.objectArray[i].tileRow) continue;
                                GameBoard.objectArray[i].isActive = false;
                            }
                            GameBoard.snake.cancelMove();
                            this.setCam(GameBoard.snake.posX, GameBoard.snake.posY, GameBoard.snake.facingDirection);
                            this.travelCamPath = null;
                            GameBoard.camIsTraveling = false;
                            GameBoard.checkSnakeSeeingAI(10);
                            PSCanvas.keyClear();
                        }
                    } else if ((keyPressed & 64) != 0 && !GameBoard.snake.isAnimated) {
                        this.nextState = 22;
                    } else if ((keyPressed & 32) != 0) {
                        if (Snake.currentState == 3) {
                            if ((GameBoard.tileLayerZ[GameBoard.snake.tileRow][GameBoard.snake.tileCol] & 32) == 0) {
                                GameBoard.snake.setStandUp();
                                this.updateDisplayCoordinates();
                                if ((GameBoard.tileLayerZ[GameBoard.snake.tileRow][GameBoard.snake.tileCol] & 64) == 64) {
                                    GameBoard.alertPercent = 100;
                                    GameBoard.nextAlertPercent = 100;
                                    GameBoard.alertAiAround(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 12, true);
                                }
                            }
                        } else if (Snake.currentState == 2) {
                            GameBoard.snake.knock();
                            PSCanvas.soundManager.play(0, 11, 0);
                            PSCanvas.setVibration(200);
                            GameBoard.checkAiHearing(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
                        } else if (GameBoard.snake.getEquipment(11) == -1) {
                            GameBoard.snake.setCrawl();
                            this.updateDisplayCoordinates();
                        }
                        PSCanvas.keyClear();
                    }
                    GameBoard.snake.update(keyPressed);
                    for (i = 1; i < 5; ++i) {
                        if (GameBoard.objectArray[i] == null || !GameBoard.objectArray[i].isAlive) continue;
                        if (GameBoard.objectArray[i].isActive) {
                            if (GameBoard.snake.tileRow != GameBoard.objectArray[i].tileRow || GameBoard.snake.tileCol != GameBoard.objectArray[i].tileCol) continue;
                            GameBoard.snake.posY = GameBoard.objectArray[i].tileRow * 20;
                            GameBoard.snake.posX = GameBoard.objectArray[i].tileCol * 20;
                            GameBoard.objectArray[i].explode();
                            this.explode(GameBoard.objectArray[i].tileRow, GameBoard.objectArray[i].tileCol, 1, GameBoard.objectArray[i].objectDamage, 4);
                            PSCanvas.soundManager.play(0, 9, 0);
                            PSCanvas.setVibration(200);
                            GameBoard.snake.moveNumberLeft = 0;
                            GameBoard.snake.blockCancelMove = true;
                            GameBoard.snake.updateMoveGrid();
                            continue;
                        }
                        if (GameBoard.snake.moveInitialCol != GameBoard.objectArray[i].tileCol || GameBoard.snake.moveInitialRow != GameBoard.objectArray[i].tileRow || GameBoard.snake.tileCol == GameBoard.objectArray[i].tileCol && GameBoard.snake.tileRow == GameBoard.objectArray[i].tileRow) continue;
                        GameBoard.objectArray[i].isActive = true;
                    }
                    for (i = 5; i < GameBoard.objectArray.length; ++i) {
                        if (GameBoard.objectArray[i] == null || !GameBoard.objectArray[i].isAlive || GameBoard.objectArray[i].imageId != 32 || GameBoard.snake.tileRow != GameBoard.objectArray[i].tileRow || GameBoard.snake.tileCol != GameBoard.objectArray[i].tileCol) continue;
                        GameBoard.objectArray[i].isAlive = false;
                        for (j = 0; j < this.LEVELS_CARD_PACKS[GameBoard.currentLevel].length; ++j) {
                            if (this.LEVELS_CARD_PACKS[GameBoard.currentLevel][j][1] != GameBoard.snake.tileCol || this.LEVELS_CARD_PACKS[GameBoard.currentLevel][j][0] != GameBoard.snake.tileRow) continue;
                            switch (this.LEVELS_CARD_PACKS[GameBoard.currentLevel][j][2]) {
                                case 99: {
                                    this.pickUpCardPack = PSCanvas.textArray[521] + " " + PSCanvas.textArray[550];
                                    break;
                                }
                                case 100: {
                                    this.pickUpCardPack = PSCanvas.textArray[522] + " " + PSCanvas.textArray[550];
                                    break;
                                }
                                case 101: {
                                    this.pickUpCardPack = PSCanvas.textArray[523] + " " + PSCanvas.textArray[550];
                                    break;
                                }
                                case 102: {
                                    this.pickUpCardPack = PSCanvas.textArray[524] + " " + PSCanvas.textArray[550];
                                    break;
                                }
                                default: {
                                    this.pickUpCardPack = PSCanvas.textArray[551] + " " + PSCanvas.textArray[CardSet.CARD_LIST[this.LEVELS_CARD_PACKS[GameBoard.currentLevel][j][2]].getCardName()];
                                }
                            }
                            if ((Integer)PSCanvas.foundItems[GameBoard.currentLevel - 6].firstElement() < this.LEVELS_CARD_PACKS[GameBoard.currentLevel].length) {
                                PSCanvas.foundItems[GameBoard.currentLevel - 6].addElement(new Integer(this.LEVELS_CARD_PACKS[GameBoard.currentLevel][j][3]));
                            }
                            this.pickedUpCardsPacks.addElement(new Integer(this.LEVELS_CARD_PACKS[GameBoard.currentLevel][j][2]));
                            this.pickUpPrintDuration = 0;
                            GameBoard.snake.blockCancelMove = true;
                        }
                    }
                    if (!GameBoard.snake.isAnimated) {
                        if (Snake.nextState != 6) {
                            if (Snake.nextState != 7) {
                                GameBoard.snake.setDirection(GameBoard.snake.facingDirection);
                            }
                        }
                    }
                    if ((keyPressed & 16) == 0 && (keyPressed & 512) == 0) ** GOTO lbl817
                    if (GameBoard.snake.isAnimated) ** GOTO lbl816
                    if (Snake.currentState == 1) ** GOTO lbl815
                    if (Snake.currentState == 3) ** GOTO lbl815
                    if (Snake.currentState != 2) ** GOTO lbl816
lbl815:
                    // 3 sources

                    this.nextState = 14;
lbl816:
                    // 3 sources

                    PSCanvas.keyClear();
lbl817:
                    // 2 sources

                    if (!this.checkActiveScript() || GameBoard.snake.isAnimated) break;
                    this.executeScript();
                    break;
                }
                case 14: {
                    this.travelCam(GameBoard.snake.posX, GameBoard.snake.posY, GameBoard.snake.facingDirection, 10);
                    GameBoard.snake.update(0);
                    if (!GameBoard.snake.isAnimated && this.checkDeaths()) {
                        return;
                    }
                    snakeTarget = 0;
                    if (GameBoard.snake.hasPunched || GameBoard.snake.isAnimated) {
                        GameBoard.snake.canPunch = false;
                    } else {
                        GameBoard.snake.canPunch = false;
                        if (Snake.currentState != 2) {
                            if (Snake.currentState != 3) {
                                for (i = 0; i < GameBoard.AiArray.length; ++i) {
                                    if (!GameBoard.AiArray[i].isAlive || GameBoard.manhattanDistance(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol) != 2 || !GameBoard.lineOfSight(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol, GameBoard.snake.facingDirection) || GameBoard.AiArray[i].status == 4) continue;
                                    GameBoard.snake.canPunch = true;
                                    snakeTarget = i;
                                    break;
                                }
                            }
                        }
                    }
                    if ((keyPressed & 32) != 0) {
                        if (GameBoard.snake.canPunch) {
                            PSCanvas.soundManager.play(0, 15, 3);
                            PSCanvas.setVibration(200);
                            PSCanvas.setVibration(200);
                            if (!GameBoard.AiArray[snakeTarget].isKnockedDown) {
                                GameBoard.snake.canPunch = false;
                                GameBoard.AiArray[snakeTarget].setDamage(30, 0, 4);
                                GameBoard.AiArray[snakeTarget].knockdown(GameBoard.snake.facingDirection, snakeTarget);
                                PSCanvas.setVibration(200);
                                GameBoard.snake.punch(snakeTarget);
                            }
                        }
                        PSCanvas.keyClear();
                    } else if (!GameBoard.snake.isAnimated && this.checkActiveScript()) {
                        this.executeScript();
                    } else if (Snake.currentState != 2) {
                        GameBoard.snake.setDirection(keyPressed);
                    }
                    GameBoard.checkSnakeSeeingAI(10);
                    if ((keyPressed & 256) != 0) {
                        this.nextState = 13;
                        break;
                    }
                    if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                        GameBoard.snake.addCost(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost());
                        this.totalLevelCost += CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardCost();
                        --GameBoard.snake.actionNumberLeft;
                        GameBoard.snake.deck.useSelectedCard();
                        if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                            this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                        } else {
                            this.ingameHud.displayCardsOff();
                        }
                        if (GameBoard.currentLevel == 11 && (this.missionType == 0 || this.missionType == 4)) {
                            distanceToEnd = GameBoard.manhattanDistance(GameBoard.snake.tileRow, GameBoard.snake.tileCol, 5, 13);
                            if (distanceToEnd <= 8) {
                                this.ingameHud.loadDialogText(Dialogs.DIALOGS[38]);
                            } else if (distanceToEnd <= 16) {
                                this.ingameHud.loadDialogText(Dialogs.DIALOGS[37]);
                            } else if (distanceToEnd <= 24) {
                                this.ingameHud.loadDialogText(Dialogs.DIALOGS[36]);
                            } else if (distanceToEnd > 24) {
                                this.ingameHud.loadDialogText(Dialogs.DIALOGS[35]);
                            }
                            this.nextState = 1;
                            this.ingameHud.resetPreviewCost();
                            break;
                        }
                        this.nextState = GameBoard.snake.actionNumberLeft == 0 || GameBoard.snake.deck.getHandCardsCount() == 0 ? 15 : 7;
                        this.ingameHud.resetPreviewCost();
                        break;
                    }
                    if ((keyPressed & 64) == 0) break;
                    this.nextState = 22;
                    break;
                }
                case 15: {
                    this.ingameHud.isEndMenu = true;
                    if (!this.ingameHud.isKeyBlocked()) {
                        optionSelected = this.ingameHud.executeMenus();
                        if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                            switch (optionSelected) {
                                case 1: {
                                    PSCanvas.soundManager.play(0, 12, 0);
                                    if (GameBoard.snake.actionNumberLeft == GameBoard.snake.maxActionNumber) {
                                        GameBoard.snake.currentCost += 4;
                                        this.totalLevelCost += 4;
                                    }
                                    this.nextState = 23;
                                    this.ingameHud.isEndMenu = false;
                                    GameBoard.snake.deck.resetCardSelection();
                                    break;
                                }
                                case 3: {
                                    PSCanvas.soundManager.play(0, 12, 0);
                                    break;
                                }
                                case 4: {
                                    PSCanvas.soundManager.play(0, 13, 0);
                                    break;
                                }
                                case 7: {
                                    break;
                                }
                                case 8: {
                                    PSCanvas.soundManager.play(0, 13, 0);
                                    break;
                                }
                                case 6: {
                                    PSCanvas.soundManager.play(0, 13, 0);
                                    break;
                                }
                                case 2: {
                                    PSCanvas.soundManager.play(0, 12, 0);
                                    this.nextState = 17;
                                    this.ingameHud.isEndMenu = false;
                                    break;
                                }
                                case 5: {
                                    PSCanvas.soundManager.play(0, 12, 0);
                                    this.ingameHud.setMessage(483);
                                    this.nextState = 25;
                                    this.ingameHud.isEndMenu = false;
                                }
                            }
                        } else if ((keyPressed & 256) != 0 && GameBoard.snake.actionNumberLeft > 0) {
                            if (optionSelected != 0) {
                                if (GameBoard.snake.deck.getHandCardsCount() != 0) {
                                    this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                                    this.nextState = 7;
                                    this.ingameHud.isEndMenu = false;
                                } else {
                                    this.ingameHud.displayCardsOff();
                                }
                            }
                        } else if ((keyPressed & 64) != 0) {
                            this.nextState = 22;
                            this.ingameHud.isEndMenu = false;
                        }
                    }
                    PSCanvas.keyClear();
                    break;
                }
                case 17: {
                    if ((keyPressed & 2) != 0) {
                        this.ingameHud.nextHelpPage();
                    } else if ((keyPressed & 8) != 0) {
                        this.ingameHud.prevHelpPage();
                    } else if ((keyPressed & 1) != 0) {
                        this.ingameHud.helpPageUp();
                    } else if ((keyPressed & 4) != 0) {
                        this.ingameHud.helpPageDown();
                    } else if ((keyPressed & 256) != 0) {
                        this.nextState = this.lastState;
                    }
                    PSCanvas.keyClear();
                    break;
                }
                case 18: {
                    if ((keyPressed & 1) != 0) {
                        this.ingameHud.prevResultLine();
                    } else if ((keyPressed & 4) != 0) {
                        this.ingameHud.nextResultLine();
                    } else if ((keyPressed & 256) != 0) {
                        this.ingameHud.setMessage(483);
                        this.nextState = 25;
                    } else if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                        this.nextState = 3;
                    }
                    PSCanvas.keyClear();
                    break;
                }
                case 20: {
                    if ((keyPressed & 256) != 0) {
                        if (++PSCanvas.gameSpeed > 3) {
                            PSCanvas.gameSpeed = 1;
                        }
                        PSCanvas.keyClear();
                        break;
                    }
                    if (GameBoard.camIsTraveling && (GameBoard.AiArray[this.currentActiveAi].moveNumberLeft == GameBoard.AiArray[this.currentActiveAi].moveNumber || GameBoard.AiArray[this.currentActiveAi].isShooting)) break;
                    for (i = 0; i < PSCanvas.gameSpeed; ++i) {
                        if (GameBoard.AiArray[this.currentActiveAi].setDirection || GameBoard.AiArray[this.currentActiveAi].launchProjectile) {
                            for (j = 1; j < 5; ++j) {
                                if (GameBoard.objectArray[j] == null || !GameBoard.objectArray[j].isAlive || GameBoard.objectArray[j].isExploding || GameBoard.AiArray[this.currentActiveAi].tileRow != GameBoard.objectArray[j].tileRow || GameBoard.AiArray[this.currentActiveAi].tileCol != GameBoard.objectArray[j].tileCol) continue;
                                GameBoard.objectArray[j].explode();
                                this.explode(GameBoard.objectArray[j].tileRow, GameBoard.objectArray[j].tileCol, 1, GameBoard.objectArray[j].objectDamage, 4);
                                PSCanvas.soundManager.play(0, 9, 0);
                                PSCanvas.setVibration(200);
                                GameBoard.AiArray[this.currentActiveAi].moveNumberLeft = 0;
                            }
                            GameBoard.snake.update(0);
                            GameBoard.AiArray[this.currentActiveAi].updateDisplayPositions();
                            GameBoard.AiArray[this.currentActiveAi].update();
                            if (GameBoard.AiArray[this.currentActiveAi].requestCamTravel) {
                                this.travelCamTo(GameBoard.snake.posX, GameBoard.snake.posY, 40);
                            } else {
                                this.setCam(GameBoard.AiArray[this.currentActiveAi].posX, GameBoard.AiArray[this.currentActiveAi].posY);
                            }
                            if (!GameBoard.AiArray[this.currentActiveAi].launchProjectile) continue;
                            if (GameBoard.objectArray[0] == null) {
                                if (GameBoard.camIsTraveling) continue;
                                launchingDirection = GameBoard.computeFullDirection(GameBoard.AiArray[this.currentActiveAi].tileRow, GameBoard.AiArray[this.currentActiveAi].tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 0);
                                this.computeProjectilePath(GameBoard.AiArray[this.currentActiveAi].tileCol * 20, GameBoard.AiArray[this.currentActiveAi].tileRow * 20 - 10, GameBoard.snake.tileCol * 20, GameBoard.snake.tileRow * 20, 0, launchingDirection);
                                this.createProjectile(GameBoard.AiArray[this.currentActiveAi].tileRow, GameBoard.AiArray[this.currentActiveAi].tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, true);
                                GameBoard.objectArray[0].objectDamage = GameBoard.AiArray[this.currentActiveAi].projectileDamage;
                                continue;
                            }
                            this.animateProjectile(4);
                            if (GameBoard.objectArray[0] != null) continue;
                            GameBoard.AiArray[this.currentActiveAi].launchProjectile = false;
                            continue;
                        }
                        if (this.checkDeaths()) {
                            return;
                        }
                        if (GameBoard.AiArray[this.currentActiveAi].isAlive) {
                            --GameBoard.AiArray[this.currentActiveAi].actionNumberLeft;
                            GameBoard.AiArray[this.currentActiveAi].deck.selectNextCard();
                            GameBoard.AiArray[this.currentActiveAi].deck.useSelectedCard();
                        }
                        if (GameBoard.AiArray[this.currentActiveAi].actionNumberLeft <= 0) {
                            this.nextState = 23;
                            break block4;
                        }
                        GameBoard.AiArray[this.currentActiveAi].moveNumberLeft = 3;
                        GameBoard.AiArray[this.currentActiveAi].setDirection = true;
                    }
                    break;
                }
                case 22: {
                    if (GameBoard.camIsTraveling) break;
                    wasKeyPressed = false;
                    if ((keyPressed & 8) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.camVelocityX = (short)96;
                        this.moveCam(this.camVelocityX >> 3, 0);
                        wasKeyPressed = true;
                    }
                    if ((keyPressed & 2) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.camVelocityX = (short)-96;
                        this.moveCam(-(-this.camVelocityX >> 3), 0);
                        wasKeyPressed = true;
                    }
                    if ((keyPressed & 4) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.camVelocityY = (short)96;
                        this.moveCam(0, this.camVelocityY >> 3);
                        wasKeyPressed = true;
                    }
                    if ((keyPressed & 1) != 0 && !this.ingameHud.isKeyBlocked()) {
                        this.camVelocityY = (short)-96;
                        this.moveCam(0, -(-this.camVelocityY >> 3));
                        wasKeyPressed = true;
                    }
                    if (!wasKeyPressed) {
                        this.camVelocityX = 0;
                        this.camVelocityY = 0;
                    }
                    GameBoard.camOffsetX = 0;
                    GameBoard.camOffsetY = 0;
                    if ((keyPressed & 64) == 0 && (keyPressed & 256) == 0 || this.ingameHud.isKeyBlocked()) break;
                    if (this.lastState != 7 && this.lastState != 15) {
                        this.forceTravelCam = true;
                        this.travelCam(GameBoard.snake.posX, GameBoard.snake.posY, GameBoard.snake.facingDirection, 40);
                    }
                    this.nextState = this.lastState;
                    break;
                }
                case 23: {
                    firstElement = (GameBoardElement)this.initiativeList.firstElement();
                    if (firstElement.currentCost > 0) {
                        costToReduce = firstElement.currentCost;
                        if (GameBoard.alertPercent > 0 && !GameBoard.checkAiSeeingSnake() && (GameBoard.nextAlertPercent = GameBoard.alertPercent - costToReduce * 3) <= 0) {
                            GameBoard.setAlert(false);
                        }
                        GameBoard.snake.currentCost -= costToReduce;
                        snakeEquipmentIndex = GameBoard.snake.getEquipment(15);
                        v6 = snakeEquipment = snakeEquipmentIndex != -1 ? GameBoard.snake.equipment[snakeEquipmentIndex] : -1;
                        if (snakeEquipment != -1) {
                            v7 = snakeEquipmentIndex;
                            GameBoard.snake.equipmentUses[v7] = GameBoard.snake.equipmentUses[v7] - costToReduce;
                            if (GameBoard.snake.equipmentUses[snakeEquipmentIndex] <= 0) {
                                GameBoard.snake.equipmentUses[snakeEquipmentIndex] = 0;
                                GameBoard.snake.removeEquipment(snakeEquipmentIndex);
                            }
                        }
                        for (i = 0; i < GameBoard.AiArray.length; ++i) {
                            GameBoard.AiArray[i].currentCost -= costToReduce;
                        }
                    }
                    if (GameBoard.snake.currentCost <= 0) {
                        this.initiativeList.removeElement(GameBoard.snake);
                        this.initiativeList.insertElementAt(GameBoard.snake, 0);
                        firstElement = GameBoard.snake;
                    }
                    if (firstElement instanceof Snake) {
                        this.wasSnakeTurn = true;
                        this.nextState = 5;
                        break;
                    }
                    tmpAi = (GameAI)this.initiativeList.firstElement();
                    tmpAi.deck.drawCards(2);
                    tmpAi.deck.selectNextCard();
                    this.nextState = 20;
                    break;
                }
                case 25: {
                    if (keyPressed != 0) {
                        this.skipPaint = false;
                    }
                    if ((keyPressed & 16) != 0 || (keyPressed & 512) != 0) {
                        if (this.lastState == 18 && this.missionType == 0 && GameBoard.currentLevel < 14) {
                            if (PSCanvas.demoMode == 0) {
                                if ((PSCanvas.completedLevel = ++GameBoard.currentLevel) >= Constants.LEVELS.length) {
                                    PSCanvas.completedLevel = Constants.LEVELS.length - 1;
                                }
                            } else if (PSCanvas.demoMode != 0 && GameBoard.currentLevel < 6 && (PSCanvas.completedLevel = ++GameBoard.currentLevel) >= Constants.LEVELS.length) {
                                PSCanvas.completedLevel = Constants.LEVELS.length - 1;
                            }
                            PSCanvas.saveData();
                            PSCanvas.resetCardPacksNumber();
                        }
                        if (PSCanvas.isUnlockElement && PSCanvas.demoMode == 0) {
                            PSCanvas.nextState = 5;
                            break;
                        }
                        if (PSCanvas.demoMode != 0) {
                            this.nextState = 29;
                            break;
                        }
                        PSCanvas.nextState = 4;
                        break;
                    }
                    if ((keyPressed & 256) == 0) break;
                    this.nextState = this.lastState;
                    break;
                }
                case 26: {
                    --this.messageBarTimer;
                    if (this.messageBarTimer > 0) break;
                    this.nextState = this.lastState;
                    break;
                }
            }
        }
        this.updateTravelCam();
    }

    public void updateGameHud() {
        if (!this.levelUnloaded) {
            this.ingameHud.updateSnakeStatus(snake);
            if (this.currentState == 22) {
                this.ingameHud.updateAIStatus(AiArray);
            }
            this.ingameHud.updateCheckGameState(this.currentState, this.lastState);
        }
    }

    private void enterState(int stateToEnter) {
        this.enteringState = true;
        switch (stateToEnter) {
            case 5: {
                this.travelCamTo(GameBoard.snake.posX, GameBoard.snake.posY, 40);
                snake.initTurn();
                this.enteringState = false;
                break;
            }
            case 7: {
                this.ingameHud.prepareFadeInCardAnimation();
                this.ingameHud.prepareCardData(GameBoard.snake.deck.getSelectedCard());
                this.travelCamPath = null;
                camIsTraveling = false;
                camBorderOffsetX = 0;
                camBorderOffsetY = 0;
                this.forceTravelCam = true;
                this.travelCamTo(GameBoard.snake.posX, GameBoard.snake.posY, 40);
                this.enteringState = false;
                this.skipPaint = false;
                break;
            }
            case 12: {
                this.hasLaunchedGrenade = false;
                this.enteringState = false;
                break;
            }
            case 8: {
                this.ingameHud.prepareFadeOutCardAnimation();
                this.enteringState = false;
            }
            case 9: {
                this.ingameHud.displayEquipOn();
                this.ingameHud.prepareFadeOutCardAnimation();
                this.enteringState = false;
                break;
            }
            case 10: {
                this.ingameHud.prepareFadeOutCardAnimation();
                this.enteringState = false;
            }
            case 24: {
                this.ingameHud.prepareFadeOutCardAnimation();
                this.enteringState = false;
                break;
            }
            case 20: {
                GameAI tmpAi = (GameAI)this.initiativeList.firstElement();
                this.currentActiveAi = tmpAi.AiID;
                if (GameBoard.AiArray[this.currentActiveAi].actionNumberLeft <= 0) {
                    AiArray[this.currentActiveAi].initTurn();
                }
                this.travelCamTo(GameBoard.AiArray[this.currentActiveAi].posX, GameBoard.AiArray[this.currentActiveAi].posY, 40 * PSCanvas.gameSpeed);
                this.wasSnakeTurn = false;
                this.enteringState = false;
                break;
            }
            case 11: {
                int i;
                this.ingameHud.prepareFadeOutCardAnimation();
                int[] targetList = new int[AiArray.length];
                int numTarget = 0;
                GameBoard.snake.isTargetingObject = false;
                for (i = 0; i < AiArray.length; ++i) {
                    if (!GameBoard.AiArray[i].isTargetable) continue;
                    targetList[numTarget] = i;
                    ++numTarget;
                }
                if (numTarget > 0) {
                    GameBoard.snake.targetList = new int[numTarget];
                    for (i = 0; i < numTarget; ++i) {
                        GameBoard.snake.targetList[i] = targetList[i];
                    }
                } else {
                    GameBoard.snake.isTargetingObject = true;
                }
                numTarget = 0;
                targetList = new int[objectArray.length];
                for (i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || !GameBoard.objectArray[i].isTargetable) continue;
                    targetList[numTarget] = i;
                    ++numTarget;
                }
                if (numTarget > 0) {
                    GameBoard.snake.targetObjectList = new int[numTarget];
                    for (i = 0; i < numTarget; ++i) {
                        GameBoard.snake.targetObjectList[i] = targetList[i];
                    }
                }
                GameBoard.snake.currentTarget = 0;
                GameBoard.snake.hasFinishedAttack = false;
                snake.setAttack();
                this.travelCamTo(GameBoard.snake.posX, GameBoard.snake.posY, 40);
                this.targetReduceRadius = 0;
                this.enteringState = false;
                break;
            }
            case 13: {
                if (this.currentState == 7) {
                    this.ingameHud.prepareFadeOutCardAnimation();
                }
                if (this.currentState != 14 && this.currentState != 22 && this.currentState != 1) {
                    if (CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getCardSubType() == 0) {
                        snake.setMove(CardSet.CARD_LIST[GameBoard.snake.deck.getSelectedCard()].getAttackRange());
                    } else {
                        snake.setMove(3);
                    }
                }
                GameBoard.checkSnakeSeeingAI(10);
                this.updateDisplayCoordinates();
                this.targetReduceRadius = 0;
                if (camIsTraveling) {
                    this.updateTravelCam();
                    break;
                }
                this.enteringState = false;
                break;
            }
            case 22: {
                if (this.currentState != 13 && this.currentState != 14 && this.currentState != 15) {
                    this.ingameHud.prepareFadeOutCardAnimation();
                }
                GameBoard.checkSnakeSeeingAI(10);
                camOffsetX = 0;
                camOffsetY = 0;
                this.forceTravelCam = true;
                this.travelCamTo(GameBoard.snake.posX, GameBoard.snake.posY, 40);
                this.targetReduceRadius = 0;
                this.enteringState = false;
                break;
            }
            case 15: {
                PSCanvas.soundManager.stop(1);
                if (this.currentState != 22 && this.currentState != 17) {
                    this.ingameHud.prepareFadeOutCardAnimation();
                }
                this.forceTravelCam = true;
                this.travelCamTo(GameBoard.snake.posX, GameBoard.snake.posY, 40);
                this.ingameHud.initIngameMenu();
                this.enteringState = false;
                break;
            }
            case 17: {
                this.ingameHud.loadHelpText(542);
                this.enteringState = false;
                break;
            }
            case 26: {
                this.messageBarTimer = 24;
                this.enteringState = false;
                break;
            }
            case 4: {
                if (!this.wasMissionFailed) {
                    PSCanvas.soundManager.play(1, 5, 0);
                }
                this.wasMissionFailed = true;
                this.enteringState = false;
                break;
            }
            case 18: {
                if (this.missionType == 0 && !this.isProgressUpdated) {
                    this.updateGameProgress();
                }
                this.enteringState = false;
                break;
            }
            default: {
                this.enteringState = false;
            }
        }
    }

    private void exitState(int stateToExit) {
        this.exitingState = true;
        switch (stateToExit) {
            case 3: {
                if (this.levelUnloaded) {
                    this.loadLevel(this.LEVELS_BIN_NAME[currentLevel]);
                    this.initLevel(0);
                    this.levelUnloaded = false;
                }
                this.exitingState = false;
                break;
            }
            case 4: {
                this.exitingState = false;
                break;
            }
            case 1: {
                this.ingameHud.unloadDialogText();
                this.exitingState = false;
                break;
            }
            case 27: {
                this.ingameHud.unloadDialogText();
                this.exitingState = false;
                break;
            }
            case 7: {
                camBorderOffsetX = 0;
                camBorderOffsetY = 0;
                this.skipPaint = false;
                this.exitingState = false;
                break;
            }
            case 11: {
                this.setCam(GameBoard.snake.posX, GameBoard.snake.posY);
                snake.setDirection(GameBoard.snake.facingDirection);
                this.targetReduceRadius = 0;
                GameBoard.snake.targetList = null;
                GameBoard.snake.targetObjectList = null;
                this.exitingState = false;
                break;
            }
            case 15: {
                if (this.nextState != 25 && this.currentState != 25 && this.currentState != 17 && this.nextState != 17) {
                    PSCanvas.soundManager.play(1, Constants.LEVELS_MUSIC[currentLevel], -1);
                }
                this.ingameHud.clearIngameMenu();
                if (this.nextState == 23) {
                    if (this.generalEffectCard != -1) {
                        if (CardSet.CARD_LIST[this.generalEffectCard].getCardSubType() == 10) {
                            this.generalEffectCard = -1;
                        }
                        this.wasSnakeTurn = true;
                        this.nextState = 5;
                    } else {
                        this.initiativeList.removeElement(snake);
                        if (this.initiativeList.isEmpty()) {
                            this.initiativeList.addElement(snake);
                        } else {
                            this.fillInitiativeQueue(snake);
                        }
                    }
                }
                this.exitingState = false;
                break;
            }
            case 17: {
                this.ingameHud.unloadHelpText();
                this.exitingState = false;
                break;
            }
            case 20: {
                if (this.nextState == 23 && GameBoard.AiArray[this.currentActiveAi].isAlive) {
                    GameAI tmpAi = (GameAI)this.initiativeList.firstElement();
                    this.initiativeList.removeElementAt(0);
                    this.fillInitiativeQueue(tmpAi);
                }
                this.exitingState = false;
                break;
            }
            case 25: {
                this.skipPaint = false;
                this.exitingState = false;
                break;
            }
            default: {
                this.exitingState = false;
            }
        }
        snake.update(0);
        PSCanvas.keyClear();
    }

    private void fillInitiativeQueue(GameBoardElement gameElement) {
        int cost = gameElement.currentCost;
        GameBoardElement firstElement = (GameBoardElement)this.initiativeList.firstElement();
        this.initiativeList.trimToSize();
        int lowestCost = firstElement.currentCost;
        if (cost < lowestCost) {
            this.initiativeList.insertElementAt(gameElement, 0);
            gameElement.initiativeTurnNumber = 1;
        } else {
            int index;
            for (index = 0; index < this.initiativeList.size(); ++index) {
                GameBoardElement tmpElement = (GameBoardElement)this.initiativeList.elementAt(index);
                if (cost < tmpElement.currentCost) {
                    this.initiativeList.insertElementAt(gameElement, index);
                    gameElement.initiativeTurnNumber = index + 1;
                    break;
                }
                tmpElement.initiativeTurnNumber = index + 1;
            }
            if (index == this.initiativeList.size()) {
                this.initiativeList.addElement(gameElement);
                gameElement.initiativeTurnNumber = index + 1;
            }
        }
    }

    private int previewInitiativeQueue(GameBoardElement gameElement, int previewCost) {
        int turnNumber = 1;
        int cost = gameElement.currentCost + previewCost;
        GameBoardElement firstElement = (GameBoardElement)this.initiativeList.firstElement();
        int lowestCost = firstElement.currentCost;
        if (cost < lowestCost) {
            turnNumber = 1;
        } else {
            for (int index = 0; index < this.initiativeList.size(); ++index) {
                GameBoardElement tmpElement = (GameBoardElement)this.initiativeList.elementAt(index);
                if (cost < tmpElement.currentCost) continue;
                turnNumber = index + 1;
            }
        }
        return turnNumber;
    }

    private void moveCam(int moveX, int moveY) {
        int diff;
        if (moveX > 0) {
            if (camOffsetX < -camBorderOffsetX) {
                if ((camOffsetX = (short)(camOffsetX + moveX)) > 0) {
                    camX = (short)(camX + camOffsetX);
                    camOffsetX = 0;
                }
            } else {
                diff = (camX = (short)(camX + moveX)) - (mapWidth * 20 - camWidth + camBorderOffsetX);
                if (diff > 0) {
                    camOffsetX = (short)(camOffsetX + diff);
                    camX = (short)(camX - diff);
                }
            }
        } else if (moveX < 0) {
            if (camOffsetX > camBorderOffsetX) {
                if ((camOffsetX = (short)(camOffsetX + moveX)) < 0) {
                    camX = (short)(camX + camOffsetX);
                    camOffsetX = 0;
                }
            } else if ((camX = (short)(camX + moveX)) < -camBorderOffsetX) {
                camOffsetX = (short)(camOffsetX + camX);
                camX = -camBorderOffsetX;
            }
        }
        if (moveY > 0) {
            if (camOffsetY < -camBorderOffsetY) {
                if ((camOffsetY = (short)(camOffsetY + moveY)) > 0) {
                    camY = (short)(camY + camOffsetY);
                    camOffsetY = 0;
                }
            } else {
                diff = (camY = (short)(camY + moveY)) - (mapHeight * 20 - camHeight + camBorderOffsetY);
                if (diff > 0) {
                    camOffsetY = (short)(camOffsetY + diff);
                    camY = (short)(camY - diff);
                }
            }
        } else if (moveY < 0) {
            if (camOffsetY > camBorderOffsetY) {
                if ((camOffsetY = (short)(camOffsetY + moveY)) < 0) {
                    camY = (short)(camY + camOffsetY);
                    camOffsetY = 0;
                }
            } else if ((camY = (short)(camY + moveY)) < -camBorderOffsetY) {
                camOffsetY = (short)(camOffsetY + camY);
                camY = -camBorderOffsetY;
            }
        }
        this.updateDisplayCoordinates();
    }

    private void setCam(int newCamX, int newCamY) {
        camOffsetX = 0;
        camOffsetY = 0;
        this.moveCam(newCamX - camX - (camWidth >> 1) + 20, newCamY - camY - (camHeight >> 1));
    }

    private void setCam(int newCamX, int newCamY, int viewingDirection) {
        camOffsetX = 0;
        camOffsetY = 0;
        switch (viewingDirection) {
            case 1: {
                this.setCam(newCamX, newCamY - 60);
                break;
            }
            case 2: {
                this.setCam(newCamX - 40, newCamY);
                break;
            }
            case 4: {
                this.setCam(newCamX, newCamY + 20);
                break;
            }
            case 8: {
                this.setCam(newCamX + 40, newCamY);
                break;
            }
        }
    }

    private void travelCam(int newCamX, int newCamY, int viewingDirection, int travelCamSpeed) {
        camOffsetX = 0;
        camOffsetY = 0;
        switch (viewingDirection) {
            case 1: {
                this.travelCamTo(newCamX, newCamY - 60, travelCamSpeed);
                break;
            }
            case 2: {
                this.travelCamTo(newCamX - 40, newCamY, travelCamSpeed);
                break;
            }
            case 4: {
                this.travelCamTo(newCamX, newCamY + 20, travelCamSpeed);
                break;
            }
            case 8: {
                this.travelCamTo(newCamX + 40, newCamY, travelCamSpeed);
                break;
            }
        }
    }

    private void setCamBetween(int camX1, int camY1, int camX2, int camY2) {
        int targetX = 0;
        int targetY = 0;
        targetX = camX2 > camX1 ? camX1 + (camX2 - camX1 >> 1) : camX2 + (camX1 - camX2 >> 1);
        targetY = camY2 > camY1 ? camY1 + (camY2 - camY1 >> 1) : camY2 + (camY1 - camY2 >> 1);
        this.travelCamTo(targetX, targetY, 40);
    }

    private void travelCamTo(int camX2, int camY2, int camSpeedFactor) {
        int startCamX = camX + (camWidth >> 1) - 20;
        int startCamY = camY + (camHeight >> 1);
        if (camX < -camBorderOffsetX && (camX2 += -camBorderOffsetX + camX) < camBorderOffsetX + (camWidth >> 1) - 20) {
            camX2 = camBorderOffsetX + (camWidth >> 1) - 20;
        }
        if (camY < -camBorderOffsetY && (camY2 += -camBorderOffsetY + camY) < camBorderOffsetY + (camHeight >> 1)) {
            camY2 = camBorderOffsetY + (camHeight >> 1);
        }
        if (camX + camWidth > mapWidth * 20 + camBorderOffsetX && (camX2 -= camX + camWidth - mapWidth * 20 - camBorderOffsetX) + camWidth - (camWidth >> 1) > mapWidth * 20 + camBorderOffsetX - 20) {
            camX2 = mapWidth * 20 + camBorderOffsetX - (camWidth >> 1) - 20;
        }
        if (camY + camHeight > mapHeight * 20 + camBorderOffsetY && (camY2 -= camY + camHeight - mapHeight * 20 - camBorderOffsetY) + camHeight - (camHeight >> 1) > mapHeight * 20 + camBorderOffsetY) {
            camY2 = mapHeight * 20 + camBorderOffsetY - (camHeight >> 1);
        }
        int dx = camX2 - startCamX;
        int dy = camY2 - startCamY;
        int dxabs = Math.abs(dx);
        int dyabs = Math.abs(dy);
        if (dxabs == 0 && dyabs == 0) {
            this.updateDisplayCoordinates();
            return;
        }
        if (!this.forceTravelCam && camX2 == this.lastTravelCamX && camY2 == this.lastTravelCamY) {
            return;
        }
        int sdx = GameBoard.sign(dx);
        int sdy = GameBoard.sign(dy);
        int x = dyabs >> 1;
        int y = dxabs >> 1;
        int px = startCamX;
        int py = startCamY;
        if (dxabs >= dyabs) {
            this.travelCamPath = new short[dxabs / camSpeedFactor + 1][2];
            for (int i = 0; i < dxabs; ++i) {
                if ((y += dyabs) >= dxabs) {
                    y -= dxabs;
                    py += sdy;
                }
                px += sdx;
                if (i % (camSpeedFactor > 1 ? camSpeedFactor >> 1 : 1) != 0) continue;
                this.travelCamPath[i / camSpeedFactor][0] = (short)px;
                this.travelCamPath[i / camSpeedFactor][1] = (short)py;
            }
        } else {
            this.travelCamPath = new short[dyabs / camSpeedFactor + 1][2];
            for (int i = 0; i < dyabs; ++i) {
                if ((x += dxabs) >= dyabs) {
                    x -= dyabs;
                    px += sdx;
                }
                py += sdy;
                if (i % (camSpeedFactor > 1 ? camSpeedFactor >> 1 : 1) != 0) continue;
                this.travelCamPath[i / camSpeedFactor][0] = (short)px;
                this.travelCamPath[i / camSpeedFactor][1] = (short)py;
            }
        }
        if (this.travelCamPath != null) {
            this.currentTravelPoint = 0;
            this.travelCamPath[this.travelCamPath.length - 1][0] = (short)camX2;
            this.travelCamPath[this.travelCamPath.length - 1][1] = (short)camY2;
            this.lastTravelCamX = camX2;
            this.lastTravelCamY = camY2;
            this.forceTravelCam = false;
            camIsTraveling = true;
        }
    }

    private void updateTravelCam() {
        if (camIsTraveling) {
            this.setCam(this.travelCamPath[this.currentTravelPoint][0], this.travelCamPath[this.currentTravelPoint][1]);
            ++this.currentTravelPoint;
            if (this.currentTravelPoint >= this.travelCamPath.length) {
                this.currentTravelPoint = 0;
                camIsTraveling = false;
                this.travelCamPath = null;
                this.forceCamTraveling = false;
            }
        }
    }

    private void updateDisplayCoordinates() {
        if (camX < 20) {
            this.colStart = 0;
            this.colEnd = this.colStart + (camWidth + camX) / 20 + 1;
            this.startDisplayTileX = -camX;
            offsetX = 0;
        } else {
            this.colStart = camX / 20 - 1;
            this.colEnd = this.colStart + camWidth / 20 + 2;
            if (this.colEnd >= mapWidth) {
                this.colEnd = mapWidth - 1;
            }
            this.startDisplayTileX = displayStartX - 20;
            offsetX = -(camX % 20);
        }
        if (camY < 20) {
            this.rowStart = 0;
            this.rowEnd = this.rowStart + (camHeight + camY) / 20 + 1;
            this.startDisplayTileY = -camY;
            offsetY = 0;
        } else {
            this.rowStart = camY / 20 - 1;
            this.rowEnd = this.rowStart + camHeight / 20 + 2;
            if (this.rowEnd >= mapHeight) {
                this.rowEnd = mapHeight - 1;
            }
            this.startDisplayTileY = displayStartY - 20;
            offsetY = -(camY % 20);
        }
        snake.updateDisplayPositions();
        for (int i = 0; i < AiArray.length; ++i) {
            AiArray[i].updateDisplayPositions();
        }
        this.updateTileBuffer();
        this.pixelRowStart = this.rowStart * 20 - 1;
        this.pixelRowEnd = this.rowEnd * 20 + 1;
        this.pixelColStart = this.colStart * 20 - 1;
        this.pixelColEnd = this.colEnd * 20 + 1;
        this.updateDisplayQueue();
    }

    public void updateDisplayQueue() {
        int k;
        this.displayQueue.removeAllElements();
        this.firstDisplayY = 10000;
        if (GameBoard.snake.posX >= this.pixelColStart && GameBoard.snake.posX <= this.pixelColEnd && GameBoard.snake.posY >= this.pixelRowStart && GameBoard.snake.posY <= this.pixelRowEnd) {
            int j;
            int i;
            this.fillDisplayQueue(snake);
            int tmpSnakeRow = GameBoard.snake.posY / 20;
            int tmpSnakeCol = GameBoard.snake.posX / 20;
            for (i = tmpSnakeRow - 2; i < tmpSnakeRow + 2; ++i) {
                for (j = tmpSnakeCol - 1; j < tmpSnakeCol + 3; ++j) {
                    if (i <= 0 || i >= mapHeight || j <= 0 || j >= mapWidth) continue;
                    if (tileLayer1[i][j] != -1) {
                        this.fillDisplayQueue(new GameBoardElement(j * 20, i * 20, (i + (tileLayerZ[i][j] & 0xF) + 1) * 20, tileLayer1[i][j]));
                    }
                    if ((this.currentState == 13 || this.currentState == 22 && this.lastState == 13) && tilesAreTransparent || tileLayer2[i][j] == -1) continue;
                    this.fillDisplayQueue(new GameBoardElement(j * 20, i * 20, 10000, tileLayer2[i][j]));
                }
            }
            if ((this.currentState == 13 || this.nextState == 13 || this.currentState == 22 && this.lastState == 13) && tilesAreTransparent && GameBoard.snake.moveArray != null) {
                for (i = 0; i < GameBoard.snake.moveArray.length; ++i) {
                    for (j = 0; j < GameBoard.snake.moveArray[i].length; ++j) {
                        if (GameBoard.snake.moveArray[i][j][0] <= -2) continue;
                        int tmpTileRow = (i << 1) + GameBoard.snake.moveRowToBoundRow;
                        int tmpTileCol = (j << 1) + GameBoard.snake.moveColToBoundCol;
                        if (tmpTileRow < this.lastCamY / 20 || tmpTileRow >= this.lastCamY / 20 + BUFFER_PIXEL_HEIGHT || tmpTileCol < this.lastCamX / 20 || tmpTileCol >= this.lastCamX / 20 + BUFFER_PIXEL_WIDTH || tmpTileRow <= 0 || tmpTileRow >= mapHeight - 1 || tmpTileCol <= 0 || tmpTileCol >= mapWidth - 1) continue;
                        if (tileLayer2[tmpTileRow][tmpTileCol] != -1) {
                            this.fillDisplayQueue(new GameBoardElement(tmpTileCol * 20, tmpTileRow * 20, 10000, tileLayer2[tmpTileRow][tmpTileCol]));
                        }
                        if (tileLayer2[tmpTileRow + 1][tmpTileCol] != -1) {
                            this.fillDisplayQueue(new GameBoardElement(tmpTileCol * 20, (tmpTileRow + 1) * 20, 10000, tileLayer2[tmpTileRow + 1][tmpTileCol]));
                        }
                        if (tileLayer2[tmpTileRow][tmpTileCol + 1] != -1) {
                            this.fillDisplayQueue(new GameBoardElement((tmpTileCol + 1) * 20, tmpTileRow * 20, 10000, tileLayer2[tmpTileRow][tmpTileCol + 1]));
                        }
                        if (tileLayer2[tmpTileRow + 1][tmpTileCol + 1] == -1) continue;
                        this.fillDisplayQueue(new GameBoardElement((tmpTileCol + 1) * 20, (tmpTileRow + 1) * 20, 10000, tileLayer2[tmpTileRow + 1][tmpTileCol + 1]));
                    }
                }
            }
        }
        for (k = 0; k < AiArray.length; ++k) {
            if (GameBoard.AiArray[k].posX < this.pixelColStart - GameBoard.AiArray[k].fillDisplayQueueOffsetX1 || GameBoard.AiArray[k].posX > this.pixelColEnd + GameBoard.AiArray[k].fillDisplayQueueOffsetX2 || GameBoard.AiArray[k].posY < this.pixelRowStart - GameBoard.AiArray[k].fillDisplayQueueOffsetY1 || GameBoard.AiArray[k].posY > this.pixelRowEnd + GameBoard.AiArray[k].fillDisplayQueueOffsetY2) continue;
            this.fillDisplayQueue(AiArray[k]);
            this.refillDisplayQueue(AiArray[k]);
        }
        for (k = 1; k < objectArray.length; ++k) {
            if (objectArray[k] == null || GameBoard.objectArray[k].posX < this.pixelColStart - GameBoard.objectArray[k].fillDisplayQueueOffsetX1 || GameBoard.objectArray[k].posX > this.pixelColEnd + GameBoard.objectArray[k].fillDisplayQueueOffsetX2 || GameBoard.objectArray[k].posY < this.pixelRowStart - GameBoard.objectArray[k].fillDisplayQueueOffsetY1 || GameBoard.objectArray[k].posY > this.pixelRowEnd + GameBoard.objectArray[k].fillDisplayQueueOffsetY2) continue;
            if (GameBoard.objectArray[k].imageId == 56) {
                if (scriptArray[0][0] != 0 && scriptArray[0][0] != 1) continue;
                this.fillDisplayQueue(objectArray[k]);
                this.refillDisplayQueue(objectArray[k]);
                continue;
            }
            this.fillDisplayQueue(objectArray[k]);
            this.refillDisplayQueue(objectArray[k]);
        }
    }

    public void refillDisplayQueue(GameBoardElement e) {
        int tmpAiRow = e.posY / 20;
        int tmpAiCol = e.posX / 20;
        for (int i = tmpAiRow - 2; i < tmpAiRow + 3; ++i) {
            for (int j = tmpAiCol - 1; j < tmpAiCol + 4; ++j) {
                if (i <= 0 || i >= mapHeight || j <= 0 || j >= mapWidth) continue;
                if (tileLayer1[i][j] != -1) {
                    this.fillDisplayQueue(new GameBoardElement(j * 20, i * 20, (i + (tileLayerZ[i][j] & 0xF) + 1) * 20, tileLayer1[i][j]));
                }
                if (tileLayer2[i][j] == -1) continue;
                this.fillDisplayQueue(new GameBoardElement(j * 20, i * 20, 10000, tileLayer2[i][j]));
            }
        }
    }

    public static void drawTile(PSGraphics g, int tileNumber, int posX, int posY, int tileRow, int tileCol, boolean clipRect) {
        int imageNumber;
        boolean tilePosX = false;
        boolean tilePosY = false;
        if (tileNumber >= 0 && tileNumber < 20) {
            imageNumber = 0;
        } else if (tileNumber >= 20 && tileNumber < 50) {
            tileNumber -= 20;
            imageNumber = 1;
        } else if (tileNumber >= 50 && tileNumber < 87) {
            tileNumber -= 50;
            imageNumber = 2;
        } else if (tileNumber >= 87 && tileNumber < 112) {
            tileNumber -= 87;
            imageNumber = 3;
        } else if (tileNumber >= 112 && tileNumber < 122) {
            tileNumber -= 112;
            imageNumber = 4;
        } else {
            return;
        }
        if (clipRect) {
            g.setClip(posX, posY, 20, 20);
        }
        int borderSize = 2;
        switch (imageNumber) {
            case 0: {
                g.drawImage(PSCanvas.tileArray0[tileNumber], posX, posY);
                break;
            }
            case 1: {
                g.drawImage(PSCanvas.tileArray1[tileNumber], posX, posY);
                break;
            }
            case 2: {
                g.setColor(0);
                if (tileNumber >= 15 && tileNumber % 2 == 0) {
                    g.drawImage(PSCanvas.imageArray[Constants.LEVELS_IMAGES[currentLevel][2]], posX, posY);
                } else {
                    g.fillRect(posX, posY, 20, 20);
                }
                g.setColor(0x444444);
                if (tileCol - 1 >= 0 && (GameBoard.isTileOutside(tileRow, tileCol - 1, 50, 86) && tileLayer2[tileRow][tileCol - 1] == -1 || tileLayerZ[tileRow][tileCol - 1] == 7 && tileLayerZ[tileRow][tileCol] == 7)) {
                    g.fillRect(posX, posY, borderSize, 20);
                }
                if (tileCol + 1 < mapWidth && (GameBoard.isTileOutside(tileRow, tileCol + 1, 50, 86) && tileLayer2[tileRow][tileCol + 1] == -1 || tileLayerZ[tileRow][tileCol + 1] == 7 && tileLayerZ[tileRow][tileCol] == 7)) {
                    g.fillRect(posX + 20 - borderSize, posY, borderSize, 20);
                }
                if (tileRow - 1 >= 0 && GameBoard.isTileOutside(tileRow - 1, tileCol, 50, 86) && tileLayer2[tileRow - 1][tileCol] == -1) {
                    g.fillRect(posX, posY, 20, borderSize);
                }
                if (tileRow + 1 >= mapHeight || !GameBoard.isTileOutside(tileRow + 1, tileCol, 50, 86) || tileLayer2[tileRow + 1][tileCol] != -1) break;
                g.fillRect(posX, posY + 20 - borderSize, 20, borderSize);
                break;
            }
            case 3: {
                if (tileNumber >= 0 && tileNumber <= 1) {
                    g.drawImage(PSCanvas.tileArray3[tileNumber], posX, posY);
                    break;
                }
                if (tileNumber > 1 && tileNumber < 7 || tileNumber > 13 && tileNumber < 17) {
                    g.setColor(3620168);
                    g.fillRect(posX + 20 - 4, posY, 2, 20);
                    g.setColor(6384769);
                    g.fillRect(posX + 20 - 2, posY, 2, 20);
                    break;
                }
                if (tileNumber >= 7 && tileNumber <= 13) {
                    g.setColor(3620168);
                    g.fillRect(posX, posY, 2, 20);
                    g.setColor(6384769);
                    g.fillRect(posX + 2, posY, 2, 20);
                    break;
                }
                g.drawImage(PSCanvas.tileArray3[tileNumber - 15], posX, posY);
                break;
            }
            case 4: {
                g.drawImage(PSCanvas.tileArray4[tileNumber], posX, posY);
            }
        }
    }

    private static boolean isTileOutside(int tileRow, int tileCol, int min, int max) {
        return tileLayer0[tileRow][tileCol] > -1 && tileLayer0[tileRow][tileCol] < min || tileLayer0[tileRow][tileCol] > max || tileLayer1[tileRow][tileCol] > -1 && tileLayer1[tileRow][tileCol] < min || tileLayer1[tileRow][tileCol] > max;
    }

    private final void bufferTileUpdate(int bufferTileRow, int bufferTileCol, int drawX, int drawY, int clipX, int clipY, int clipW, int clipH) {
        boardImageGraphics.setClip(clipX, clipY, clipW, clipH);
        boardImageGraphics.setColor(0);
        if (bufferTileRow < 0 || bufferTileCol < 0 || bufferTileCol >= mapWidth || bufferTileRow >= mapHeight) {
            boardImageGraphics.fillRect(drawX, drawY, 20, 20);
        } else {
            if (tileLayer0[bufferTileRow][bufferTileCol] != -1) {
                GameBoard.drawTile(boardImageGraphics, tileLayer0[bufferTileRow][bufferTileCol], drawX, drawY, bufferTileRow, bufferTileCol, false);
            }
            if (tileLayer1[bufferTileRow][bufferTileCol] != -1) {
                GameBoard.drawTile(boardImageGraphics, tileLayer1[bufferTileRow][bufferTileCol], drawX, drawY, bufferTileRow, bufferTileCol, false);
            }
            if (tileLayer2[bufferTileRow][bufferTileCol] != -1) {
                GameBoard.drawTile(boardImageGraphics, tileLayer2[bufferTileRow][bufferTileCol], drawX, drawY, bufferTileRow, bufferTileCol, false);
            }
        }
        if (clipX + clipW > BUFFER_PIXEL_WIDTH) {
            int newDrawX = drawX - BUFFER_PIXEL_WIDTH;
            int newClipW = clipX + clipW - BUFFER_PIXEL_WIDTH;
            int newClipX = 0;
            this.bufferTileUpdate(bufferTileRow, bufferTileCol, newDrawX, drawY, newClipX, clipY, newClipW, clipH);
        }
        if (clipY + clipH > BUFFER_PIXEL_HEIGHT) {
            int newDrawY = drawY - BUFFER_PIXEL_HEIGHT;
            int newClipH = clipY + clipH - BUFFER_PIXEL_HEIGHT;
            int newClipY = 0;
            this.bufferTileUpdate(bufferTileRow, bufferTileCol, drawX, newDrawY, clipX, newClipY, clipW, newClipH);
        }
    }

    public void updateTileBuffer() {
        int clipY;
        int clipH;
        int drawY;
        int clipX;
        int clipW;
        int drawX;
        if (boardImageBuffer == null) {
            boardImageBuffer = Image.createImage((int)BUFFER_PIXEL_WIDTH, (int)BUFFER_PIXEL_HEIGHT);
        }
        if (boardImageGraphics == null) {
            boardImageGraphics = new PSGraphics(boardImageBuffer.getGraphics());
        }
        this.updateMapTiles();
        if (camX != this.lastCamX) {
            int updateEndX;
            int updateStartX;
            boolean scrollingRight = false;
            if (camX < this.lastCamX) {
                updateStartX = camX;
                updateEndX = this.lastCamX;
                if (updateStartX + BUFFER_PIXEL_WIDTH < updateEndX) {
                    updateEndX = updateStartX + BUFFER_PIXEL_WIDTH;
                }
            } else {
                updateStartX = this.lastCamX + BUFFER_PIXEL_WIDTH;
                updateEndX = camX + BUFFER_PIXEL_WIDTH;
                if (camX < 0 || this.lastCamX < 0) {
                    updateStartX += camX;
                }
                scrollingRight = true;
            }
            int maxColUpdate = updateEndX / 20;
            for (int minColUpdate = updateStartX / 20; minColUpdate <= maxColUpdate; ++minColUpdate) {
                short updateStartY = camY;
                int updateEndY = camY + BUFFER_PIXEL_HEIGHT;
                int maxRowUpdate = updateEndY / 20;
                for (int minRowUpdate = updateStartY / 20; minRowUpdate <= maxRowUpdate; ++minRowUpdate) {
                    if (scrollingRight) {
                        if (minColUpdate == maxColUpdate) {
                            drawX = minColUpdate * 20 % BUFFER_PIXEL_WIDTH;
                            clipW = updateEndX % 20;
                            clipX = drawX;
                        } else if (minColUpdate == updateStartX / 20) {
                            drawX = updateStartX % BUFFER_PIXEL_WIDTH - updateStartX % 20;
                            clipW = 20 - updateStartX % 20;
                            clipX = updateStartX % BUFFER_PIXEL_WIDTH;
                        } else {
                            drawX = minColUpdate * 20 % BUFFER_PIXEL_WIDTH;
                            clipW = 20;
                            clipX = drawX;
                        }
                    } else if (minColUpdate == updateStartX / 20) {
                        drawX = updateStartX % BUFFER_PIXEL_WIDTH - updateStartX % 20;
                        clipW = 20 - updateStartX % 20;
                        clipX = updateStartX % BUFFER_PIXEL_WIDTH;
                    } else if (minColUpdate == maxColUpdate) {
                        drawX = minColUpdate * 20 % BUFFER_PIXEL_WIDTH;
                        clipW = updateEndX % 20;
                        clipX = drawX;
                    } else {
                        drawX = minColUpdate * 20 % BUFFER_PIXEL_WIDTH;
                        clipW = 20;
                        clipX = drawX;
                    }
                    if (minRowUpdate == updateStartY / 20) {
                        drawY = updateStartY % BUFFER_PIXEL_HEIGHT - updateStartY % 20;
                        clipH = 20 - updateStartY % 20;
                        clipY = updateStartY % BUFFER_PIXEL_HEIGHT;
                    } else if (minRowUpdate == maxRowUpdate) {
                        drawY = minRowUpdate * 20 % BUFFER_PIXEL_HEIGHT;
                        clipH = updateEndY % 20;
                        clipY = drawY;
                    } else {
                        drawY = minRowUpdate * 20 % BUFFER_PIXEL_HEIGHT;
                        clipH = 20;
                        clipY = drawY;
                    }
                    this.bufferTileUpdate(minRowUpdate, minColUpdate, drawX, drawY, clipX, clipY, clipW, clipH);
                }
            }
            this.lastCamX = camX;
        }
        if (camY != this.lastCamY) {
            int updateEndY;
            int updateStartY;
            boolean scrollingDown = false;
            if (camY < this.lastCamY) {
                updateStartY = camY;
                updateEndY = this.lastCamY;
                if (updateStartY + BUFFER_PIXEL_HEIGHT < updateEndY) {
                    updateEndY = updateStartY + BUFFER_PIXEL_HEIGHT;
                }
            } else {
                updateStartY = this.lastCamY + BUFFER_PIXEL_HEIGHT;
                updateEndY = camY + BUFFER_PIXEL_HEIGHT;
                if (camY < 0 || this.lastCamY < 0) {
                    updateStartY += camY;
                }
                scrollingDown = true;
            }
            int maxRowUpdate = updateEndY / 20;
            for (int minRowUpdate = updateStartY / 20; minRowUpdate <= maxRowUpdate; ++minRowUpdate) {
                short updateStartX = camX;
                int updateEndX = camX + BUFFER_PIXEL_WIDTH;
                int maxColUpdate = updateEndX / 20;
                for (int minColUpdate = updateStartX / 20; minColUpdate <= maxColUpdate; ++minColUpdate) {
                    if (minColUpdate == maxColUpdate) {
                        drawX = minColUpdate * 20 % BUFFER_PIXEL_WIDTH;
                        clipW = updateEndX % 20;
                        clipX = drawX;
                    } else if (minColUpdate == updateStartX / 20) {
                        drawX = updateStartX % BUFFER_PIXEL_WIDTH - updateStartX % 20;
                        clipW = 20 - updateStartX % 20;
                        clipX = updateStartX % BUFFER_PIXEL_WIDTH;
                    } else {
                        drawX = minColUpdate * 20 % BUFFER_PIXEL_WIDTH;
                        clipW = 20;
                        clipX = drawX;
                    }
                    if (scrollingDown) {
                        if (minRowUpdate == maxRowUpdate) {
                            drawY = minRowUpdate * 20 % BUFFER_PIXEL_HEIGHT;
                            clipH = updateEndY % 20;
                            clipY = drawY;
                        } else if (minRowUpdate == updateStartY / 20) {
                            drawY = updateStartY % BUFFER_PIXEL_HEIGHT - updateStartY % 20;
                            clipH = 20 - updateStartY % 20;
                            clipY = updateStartY % BUFFER_PIXEL_HEIGHT;
                        } else {
                            drawY = minRowUpdate * 20 % BUFFER_PIXEL_HEIGHT;
                            clipH = 20;
                            clipY = drawY;
                        }
                    } else if (minRowUpdate == updateStartY / 20) {
                        drawY = updateStartY % BUFFER_PIXEL_HEIGHT - updateStartY % 20;
                        clipH = 20 - updateStartY % 20;
                        clipY = updateStartY % BUFFER_PIXEL_HEIGHT;
                    } else if (minRowUpdate == maxRowUpdate) {
                        drawY = minRowUpdate * 20 % BUFFER_PIXEL_HEIGHT;
                        clipH = updateEndY % 20;
                        clipY = drawY;
                    } else {
                        drawY = minRowUpdate * 20 % BUFFER_PIXEL_HEIGHT;
                        clipH = 20;
                        clipY = drawY;
                    }
                    this.bufferTileUpdate(minRowUpdate, minColUpdate, drawX, drawY, clipX, clipY, clipW, clipH);
                }
            }
            this.lastCamY = camY;
        }
        this.bufferPivotX = camX < 0 ? BUFFER_PIXEL_WIDTH + camX : camX % BUFFER_PIXEL_WIDTH;
        this.bufferPivotWidth = BUFFER_PIXEL_WIDTH - this.bufferPivotX;
        this.bufferPivotY = camY < 0 ? BUFFER_PIXEL_HEIGHT + camY : camY % BUFFER_PIXEL_HEIGHT;
        this.bufferPivotHeight = BUFFER_PIXEL_HEIGHT - this.bufferPivotY;
    }

    public void releaseTileBuffer() {
        boardImageGraphics = null;
        boardImageBuffer = null;
    }

    private void updateMapTiles() {
        if (!GameBoard.snake.isHidden) {
            if (tileLayer2[GameBoard.snake.tileRow][GameBoard.snake.tileCol] != -1) {
                this.setTransparentTiles(GameBoard.snake.tileRow, GameBoard.snake.tileCol, true);
                snake.setHidden(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
            } else if (GameBoard.snake.tileRow - 1 > 0 && tileLayer2[GameBoard.snake.tileRow - 1][GameBoard.snake.tileCol] != -1) {
                this.setTransparentTiles(GameBoard.snake.tileRow - 1, GameBoard.snake.tileCol, true);
                snake.setHidden(GameBoard.snake.tileRow - 1, GameBoard.snake.tileCol);
            }
        }
        if (GameBoard.snake.isHidden && tileLayer2[GameBoard.snake.tileRow][GameBoard.snake.tileCol] == -1 && tileLayer2[GameBoard.snake.tileRow - 1][GameBoard.snake.tileCol] == -1 && tileLayer2[GameBoard.snake.tileRow - 1][GameBoard.snake.tileCol + 1] == -1 && tileLayer2[GameBoard.snake.tileRow][GameBoard.snake.tileCol + 1] == -1) {
            this.setTransparentTiles(GameBoard.snake.hiddenStartRow, GameBoard.snake.hiddenStartCol, false);
            GameBoard.snake.isHidden = false;
        }
    }

    private void setTransparentTiles(int rowStartSearch, int colStartSearch, boolean setTransparent) {
        for (int i = 0; i < tileLayer2.length; ++i) {
            for (int j = 0; j < tileLayer2[i].length; ++j) {
                if (tileLayer2[i][j] <= 0) continue;
                if (setTransparent) {
                    byte[] byArray = tileLayer2[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] + 1);
                } else {
                    byte[] byArray = tileLayer2[i];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] - 1);
                }
                this.lastCamX = (short)(-BUFFER_PIXEL_WIDTH);
                this.lastCamY = (short)(-BUFFER_PIXEL_HEIGHT);
            }
        }
        tilesAreTransparent = setTransparent;
    }

    public static int computeDirection(int startRow, int startCol, int targetRow, int targetCol) {
        int rowDiff = targetRow - startRow;
        int colDiff = targetCol - startCol;
        if (rowDiff == 0 && colDiff == 0) {
            int randomDir = PSCanvas.getRandom(0, 3);
            return 1 << randomDir;
        }
        if (rowDiff >= 0) {
            if (colDiff >= 0) {
                if (rowDiff > colDiff) {
                    return 4;
                }
                return 8;
            }
            if (-colDiff > rowDiff) {
                return 2;
            }
            return 4;
        }
        if (colDiff >= 0) {
            if (-rowDiff > colDiff) {
                return 1;
            }
            return 8;
        }
        if (-rowDiff > -colDiff) {
            return 1;
        }
        return 2;
    }

    public static int computeFullDirection(int startRow, int startCol, int targetRow, int targetCol, int diagonalRange) {
        return GameBoard.computeDirection(startRow, startCol, targetRow, targetCol);
    }

    public static int sign(int x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static void lineOfSight(int startRow, int startCol, int targetRow, int targetCol, int[] visionGrid) {
        int currentRow = startRow;
        int currentCol = startCol;
        int previousRow = startRow;
        int previousCol = startCol;
        boolean ignoreCheck = false;
        boolean isDiagonal = false;
        int dx = targetCol - startCol;
        int dy = targetRow - startRow;
        int dxabs = Math.abs(dx);
        int dyabs = Math.abs(dy);
        int sdx = GameBoard.sign(dx);
        int sdy = GameBoard.sign(dy);
        int x = dyabs >> 1;
        int y = dxabs >> 1;
        if (dxabs == dyabs) {
            if (sdy < 0) {
                --currentRow;
                --targetRow;
            }
            if (sdx > 0) {
                ++currentCol;
                ++targetCol;
            }
        }
        previousRow = currentRow;
        previousCol = currentCol;
        dx = targetCol - currentCol;
        dy = targetRow - currentRow;
        dxabs = Math.abs(dx);
        dyabs = Math.abs(dy);
        sdx = GameBoard.sign(dx);
        sdy = GameBoard.sign(dy);
        x = dyabs >> 1;
        y = dxabs >> 1;
        while (currentRow != targetRow || currentCol != targetCol) {
            if (dxabs >= dyabs) {
                if ((y += dyabs) >= dxabs) {
                    y -= dxabs;
                    currentRow += sdy;
                }
                currentCol += sdx;
            } else {
                if ((x += dxabs) >= dyabs) {
                    x -= dyabs;
                    currentCol += sdx;
                }
                currentRow += sdy;
            }
            isDiagonal = false;
            if (currentCol != previousCol && currentRow != previousRow) {
                isDiagonal = true;
            }
            if (currentRow != previousRow) {
                if (sdy < 0 ? currentRow + 1 >= mapHeight || (visionMapData[currentRow + 1][previousCol] & 1) != 0 || (visionMapData[currentRow][currentCol] & 4) != 0 : sdy > 0 && (currentRow - 1 < 0 || (visionMapData[currentRow - 1][previousCol] & 4) != 0 || (visionMapData[currentRow][currentCol] & 1) != 0)) {
                    return;
                }
                if (!isDiagonal) {
                    previousRow = currentRow;
                }
            }
            if (currentCol != previousCol) {
                if (sdx < 0 ? currentCol + 1 >= mapWidth || (visionMapData[previousRow][currentCol + 1] & 2) != 0 || (visionMapData[currentRow][currentCol] & 8) != 0 : sdx > 0 && (currentCol - 1 < 0 || (visionMapData[previousRow][currentCol - 1] & 8) != 0 || (visionMapData[currentRow][currentCol] & 2) != 0)) {
                    return;
                }
                previousCol = currentCol;
                if (isDiagonal) {
                    previousRow = currentRow;
                }
            }
            int colToInsert = currentCol;
            int rowToInsert = currentRow;
            boolean toInsert = false;
            if ((currentCol - startCol & 1) == 0 && (currentRow - startRow & 1) == 0) {
                toInsert = true;
            } else if ((currentCol - 1 - startCol & 1) == 0 && (currentRow - startRow & 1) == 0) {
                --colToInsert;
                toInsert = true;
            } else if ((currentCol - 1 - startCol & 1) == 0 && (currentRow + 1 - startRow & 1) == 0) {
                --colToInsert;
                ++rowToInsert;
                toInsert = true;
            } else if ((currentCol - startCol & 1) == 0 && (currentRow + 1 - startRow & 1) == 0) {
                ++rowToInsert;
                toInsert = true;
            }
            if (!toInsert || colToInsert == startCol && rowToInsert == startRow) continue;
            for (int i = 0; i < visionGrid.length; i += 2) {
                if (visionGrid[i] == -1) {
                    visionGrid[i] = rowToInsert;
                    visionGrid[i + 1] = colToInsert;
                    i = visionGrid.length;
                    continue;
                }
                if (visionGrid[i] != rowToInsert || visionGrid[i + 1] != colToInsert) continue;
                i = visionGrid.length;
            }
        }
    }

    public static boolean lineOfSight(int startRow, int startCol, int targetRow, int targetCol, int viewerDirection) {
        int dyabs;
        int dx = targetCol - startCol;
        int dy = targetRow - startRow;
        int dxabs = Math.abs(dx);
        if (dxabs == (dyabs = Math.abs(dy))) {
            switch (viewerDirection) {
                case 1: {
                    if (dy < 0 && dxabs <= dyabs) break;
                    return false;
                }
                case 2: {
                    if (dx < 0 && dyabs <= dxabs) break;
                    return false;
                }
                case 4: {
                    if (dy > 0 && dxabs <= dyabs) break;
                    return false;
                }
                case 8: {
                    if (dx > 0 && dyabs <= dxabs) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return GameBoard.lineOfSight(startRow, startCol, targetRow, targetCol);
        }
        switch (viewerDirection) {
            case 1: {
                if (dy >= 0 || dxabs > dyabs) {
                    return false;
                }
                return GameBoard.lineOfSight(startRow - 1, startCol, targetRow, targetCol) || GameBoard.lineOfSight(startRow - 1, startCol + 1, targetRow, targetCol + 1);
            }
            case 2: {
                if (dx >= 0 || dyabs > dxabs) {
                    return false;
                }
                return GameBoard.lineOfSight(startRow, startCol, targetRow, targetCol) || GameBoard.lineOfSight(startRow - 1, startCol, targetRow - 1, targetCol);
            }
            case 4: {
                if (dy <= 0 || dxabs > dyabs) {
                    return false;
                }
                return GameBoard.lineOfSight(startRow, startCol, targetRow - 1, targetCol) || GameBoard.lineOfSight(startRow, startCol + 1, targetRow - 1, targetCol + 1);
            }
            case 8: {
                if (dx <= 0 || dyabs > dxabs) {
                    return false;
                }
                return GameBoard.lineOfSight(startRow, startCol + 1, targetRow, targetCol) || GameBoard.lineOfSight(startRow - 1, startCol + 1, targetRow - 1, targetCol);
            }
        }
        return false;
    }

    public static boolean lineOfSight(int startRow, int startCol, int targetRow, int targetCol) {
        int currentRow = startRow;
        int currentCol = startCol;
        int previousRow = startRow;
        int previousCol = startCol;
        boolean ignoreCheck = false;
        boolean isDiagonal = false;
        int dx = targetCol - startCol;
        int dy = targetRow - startRow;
        int dxabs = Math.abs(dx);
        int dyabs = Math.abs(dy);
        int sdx = GameBoard.sign(dx);
        int sdy = GameBoard.sign(dy);
        int x = dyabs >> 1;
        int y = dxabs >> 1;
        if (dxabs == dyabs) {
            if (sdy < 0) {
                --currentRow;
                --targetRow;
            }
            if (sdx > 0) {
                ++currentCol;
                ++targetCol;
            }
        }
        previousRow = currentRow;
        previousCol = currentCol;
        dx = targetCol - currentCol;
        dy = targetRow - currentRow;
        dxabs = Math.abs(dx);
        dyabs = Math.abs(dy);
        sdx = GameBoard.sign(dx);
        sdy = GameBoard.sign(dy);
        x = dyabs >> 1;
        y = dxabs >> 1;
        while (currentRow != targetRow || currentCol != targetCol) {
            if (dxabs >= dyabs) {
                if ((y += dyabs) >= dxabs) {
                    y -= dxabs;
                    currentRow += sdy;
                }
                currentCol += sdx;
            } else {
                if ((x += dxabs) >= dyabs) {
                    x -= dyabs;
                    currentCol += sdx;
                }
                currentRow += sdy;
            }
            isDiagonal = false;
            if (currentCol != previousCol && currentRow != previousRow) {
                isDiagonal = true;
            }
            if (currentRow != previousRow) {
                if (sdy < 0 ? currentRow + 1 >= mapHeight || (visionMapData[currentRow + 1][previousCol] & 1) != 0 || (visionMapData[currentRow][currentCol] & 4) != 0 : sdy > 0 && (currentRow - 1 < 0 || (visionMapData[currentRow - 1][previousCol] & 4) != 0 || (visionMapData[currentRow][currentCol] & 1) != 0)) {
                    return false;
                }
                if (!isDiagonal) {
                    previousRow = currentRow;
                }
            }
            if (currentCol == previousCol) continue;
            if (sdx < 0 ? currentCol + 1 >= mapWidth || (visionMapData[previousRow][currentCol + 1] & 2) != 0 || (visionMapData[currentRow][currentCol] & 8) != 0 : sdx > 0 && (currentCol - 1 < 0 || (visionMapData[previousRow][currentCol - 1] & 8) != 0 || (visionMapData[currentRow][currentCol] & 2) != 0)) {
                return false;
            }
            previousCol = currentCol;
            if (!isDiagonal) continue;
            previousRow = currentRow;
        }
        return true;
    }

    public static void computeVisionGrid(int[][] visionGrid, int[] currentVisionGrid, int tileRow, int tileCol, int facingDirection) {
        if (visionGrid != null) {
            try {
                for (int i = 0; i < currentVisionGrid.length; ++i) {
                    currentVisionGrid[i] = -1;
                }
                GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[3][0] * 2, tileCol + visionGrid[3][1] * 2, currentVisionGrid);
                GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[0][0] * 2, tileCol + visionGrid[0][1] * 2, currentVisionGrid);
                GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[6][0] * 2, tileCol + visionGrid[6][1] * 2, currentVisionGrid);
                int insertIndex = 0;
                while (currentVisionGrid[insertIndex] != -1) {
                    ++insertIndex;
                }
                if (GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[1][0] * 2, tileCol + visionGrid[1][1] * 2, facingDirection)) {
                    currentVisionGrid[insertIndex] = tileRow + visionGrid[1][0] * 2;
                    currentVisionGrid[insertIndex + 1] = tileCol + visionGrid[1][1] * 2;
                    insertIndex += 2;
                }
                if (GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[2][0] * 2, tileCol + visionGrid[2][1] * 2, facingDirection)) {
                    currentVisionGrid[insertIndex] = tileRow + visionGrid[2][0] * 2;
                    currentVisionGrid[insertIndex + 1] = tileCol + visionGrid[2][1] * 2;
                    insertIndex += 2;
                }
                if (GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[4][0] * 2, tileCol + visionGrid[4][1] * 2, facingDirection)) {
                    currentVisionGrid[insertIndex] = tileRow + visionGrid[4][0] * 2;
                    currentVisionGrid[insertIndex + 1] = tileCol + visionGrid[4][1] * 2;
                    insertIndex += 2;
                }
                if (GameBoard.lineOfSight(tileRow, tileCol, tileRow + visionGrid[5][0] * 2, tileCol + visionGrid[5][1] * 2, facingDirection)) {
                    currentVisionGrid[insertIndex] = tileRow + visionGrid[5][0] * 2;
                    currentVisionGrid[insertIndex + 1] = tileCol + visionGrid[5][1] * 2;
                    insertIndex += 2;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void alertAiAround(int guardRow, int guardCol, int targetRow, int targetCol, int distance, boolean forceAlert) {
        for (int i = 0; i < AiArray.length; ++i) {
            if (!GameBoard.AiArray[i].isAlive || GameBoard.manhattanDistance(guardRow, guardCol, GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol) > distance || !forceAlert && GameBoard.AiArray[i].isAlerted) continue;
            AiArray[i].setAlert(targetRow, targetCol);
        }
    }

    public static boolean checkAiSeeingSnake() {
        boolean result = false;
        for (int i = 0; i < AiArray.length; ++i) {
            int snakeEquipment;
            if (!GameBoard.AiArray[i].isAlive || GameBoard.AiArray[i].status == 3 || GameBoard.AiArray[i].status == 4 || GameBoard.AiArray[i].status == 0 || GameBoard.manhattanDistance(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol) > 8) continue;
            boolean hasDetected = GameBoard.AiArray[i].isAlerted;
            if (AiArray[i].checkPlayerPosOutOfAI()) {
                result = true;
                if (GameBoard.AiArray[i].type == 9) {
                    GameBoard.setAlert(true);
                    GameBoard.alertAiAround(GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 12, true);
                } else if (alertPercent > 0) {
                    nextAlertPercent = 100;
                }
            }
            if (!hasDetected && GameBoard.AiArray[i].isAlerted) {
                GameBoard.snake.blockCancelMove = true;
            }
            if (nextAlertPercent <= 0) continue;
            int snakeEquipmentIndex = snake.getEquipment(15);
            int n = snakeEquipment = snakeEquipmentIndex != -1 ? GameBoard.snake.equipment[snakeEquipmentIndex] : -1;
            if (snakeEquipment != -1) continue;
            if (Snake.currentState == 3) continue;
            if (Snake.currentState == 7 || !AiArray[i].checkSound(GameBoard.snake.tileRow, GameBoard.snake.tileCol)) continue;
            if (GameBoard.AiArray[i].isAlerted) {
                AiArray[i].setAlert(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
                continue;
            }
            AiArray[i].setCaution(GameBoard.snake.tileRow, GameBoard.snake.tileCol);
        }
        if ((tileLayerZ[GameBoard.snake.tileRow][GameBoard.snake.tileCol] & 0x40) == 64) {
            if (Snake.currentState != 5) {
                if (Snake.currentState != 3) {
                    alertPercent = 100;
                    nextAlertPercent = 100;
                    GameBoard.alertAiAround(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.snake.tileRow, GameBoard.snake.tileCol, 12, true);
                }
            }
        }
        if (result && snake.getEquipment(11) != -1) {
            snake.removeEquipment(snake.getEquipment(11));
        }
        return result;
    }

    public static void checkAiHearing(int tileRow, int tileCol) {
        for (int i = 0; i < AiArray.length; ++i) {
            int snakeEquipment;
            if (!GameBoard.AiArray[i].isAlive) continue;
            int snakeEquipmentIndex = snake.getEquipment(15);
            int n = snakeEquipment = snakeEquipmentIndex != -1 ? GameBoard.snake.equipment[snakeEquipmentIndex] : -1;
            if (snakeEquipment != -1 || !AiArray[i].checkSound(tileRow, tileCol)) continue;
            System.out.println("set Caution from sound/knock");
            AiArray[i].setCaution(tileRow, tileCol);
        }
    }

    public static boolean checkSnakeSeeingAI(int range) {
        int i;
        boolean result = false;
        for (i = 0; i < AiArray.length; ++i) {
            if (!GameBoard.AiArray[i].isAlive) continue;
            if (GameBoard.manhattanDistance(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol) <= range && GameBoard.lineOfSight(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.AiArray[i].tileRow, GameBoard.AiArray[i].tileCol, GameBoard.snake.facingDirection)) {
                GameBoard.AiArray[i].isTargetable = true;
                result = true;
                continue;
            }
            GameBoard.AiArray[i].isTargetable = false;
        }
        for (i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !GameBoard.objectArray[i].canBeTargeted) continue;
            if (GameBoard.manhattanDistance(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.objectArray[i].tileRow, GameBoard.objectArray[i].tileCol) <= 10 && GameBoard.lineOfSight(GameBoard.snake.tileRow, GameBoard.snake.tileCol, GameBoard.objectArray[i].tileRow, GameBoard.objectArray[i].tileCol, GameBoard.snake.facingDirection)) {
                GameBoard.objectArray[i].isTargetable = true;
                result = true;
                continue;
            }
            GameBoard.objectArray[i].isTargetable = false;
        }
        return result;
    }

    public static int manhattanDistance(int startRow, int startCol, int targetRow, int targetCol) {
        return Math.abs(startCol - targetCol) + Math.abs(startRow - targetRow);
    }

    public static int[][] aStarSearch(int startRow, int startCol, int goalRow, int goalCol, boolean avoidPlayer) {
        int cost;
        Object ir = null;
        Hashtable<Integer, Node> open = new Hashtable<Integer, Node>();
        Hashtable<Integer, Node> close = new Hashtable<Integer, Node>();
        Node startNode = new Node();
        Node goalNode = new Node();
        Node extractNode = null;
        Node n = null;
        Node newNode = null;
        boolean inOpen = false;
        int hashInOpen = 0;
        boolean targetIsPlayer = false;
        startNode.tileCol = startCol;
        startNode.tileRow = startRow;
        goalNode.tileCol += goalCol;
        goalNode.tileRow = goalRow;
        startNode.costFromStart = 0;
        startNode.costToGoal = cost = GameBoard.manhattanDistance(startRow, startCol, goalRow, goalCol);
        startNode.parent = null;
        startNode.setTotalCost();
        if (cost == 0) {
            return null;
        }
        open.put(new Integer((startNode.tileRow << 8) + startNode.tileCol), startNode);
        while (!open.isEmpty()) {
            int min = 10000;
            Enumeration e = open.elements();
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                if (n.totalCost >= min) continue;
                min = n.totalCost;
                hashInOpen = (n.tileRow << 8) + n.tileCol;
            }
            Integer min2 = new Integer(hashInOpen);
            extractNode = (Node)open.get(min2);
            open.remove(min2);
            close.put(min2, extractNode);
            if (extractNode.tileCol == goalNode.tileCol && extractNode.tileRow == goalNode.tileRow) {
                int pathLength = extractNode.costFromStart >> 1;
                int[][] resultPath = new int[pathLength][2];
                for (int i = 0; i < resultPath.length; ++i) {
                    resultPath[i][0] = extractNode.tileRow;
                    resultPath[i][1] = extractNode.tileCol;
                    extractNode = extractNode.parent;
                }
                return resultPath;
            }
            for (int i = 0; i < 4; ++i) {
                Integer tmpHash;
                boolean collision = false;
                boolean collisionAI = false;
                hashInOpen = 0;
                inOpen = false;
                newNode = new Node();
                newNode.tileCol = extractNode.tileCol;
                newNode.tileRow = extractNode.tileRow;
                switch (i) {
                    case 0: {
                        if (newNode.tileCol - 2 < 0 || (boundMapData[newNode.tileRow][newNode.tileCol] & 2) != 0) {
                            collision = true;
                        } else if (newNode.tileCol - 2 >= 0 && (boundMapData[newNode.tileRow][newNode.tileCol - 2] & 0x10) != 0) {
                            collisionAI = true;
                        }
                        newNode.tileCol -= 2;
                        break;
                    }
                    case 1: {
                        if (newNode.tileCol + 1 >= mapWidth || (boundMapData[newNode.tileRow][newNode.tileCol + 1] & 8) != 0) {
                            collision = true;
                        } else if (newNode.tileCol + 2 < mapWidth && (boundMapData[newNode.tileRow][newNode.tileCol + 2] & 0x10) != 0) {
                            collisionAI = true;
                        }
                        newNode.tileCol += 2;
                        break;
                    }
                    case 2: {
                        if (newNode.tileRow + 2 >= mapHeight || (boundMapData[newNode.tileRow][newNode.tileCol] & 4) != 0) {
                            collision = true;
                        } else if (newNode.tileRow + 2 < mapHeight && (boundMapData[newNode.tileRow + 2][newNode.tileCol] & 0x10) != 0) {
                            collisionAI = true;
                        }
                        newNode.tileRow += 2;
                        break;
                    }
                    case 3: {
                        if (newNode.tileRow - 1 < 0 || (boundMapData[newNode.tileRow - 1][newNode.tileCol] & 1) != 0) {
                            collision = true;
                        } else if (newNode.tileRow - 2 >= 0 && (boundMapData[newNode.tileRow - 2][newNode.tileCol] & 0x10) != 0) {
                            collisionAI = true;
                        }
                        newNode.tileRow -= 2;
                    }
                }
                if (avoidPlayer && newNode.tileCol == GameBoard.snake.tileCol && newNode.tileRow == GameBoard.snake.tileRow) {
                    collision = true;
                }
                if (collisionAI) {
                    for (int k = 0; k < AiArray.length; ++k) {
                        if (GameBoard.AiArray[k].tileRow != newNode.tileRow || GameBoard.AiArray[k].tileCol != newNode.tileCol) continue;
                        if (GameBoard.AiArray[k].currentPathPoint <= 0) break;
                        GameBoard.AiArray[k].forceMove = true;
                        break;
                    }
                }
                if (collision || collisionAI || close.containsKey(tmpHash = new Integer((newNode.tileRow << 8) + newNode.tileCol))) continue;
                cost = GameBoard.manhattanDistance(newNode.tileRow, newNode.tileCol, goalNode.tileRow, goalNode.tileCol);
                newNode.costFromStart += extractNode.costFromStart + 2;
                newNode.costToGoal = cost;
                newNode.parent = extractNode;
                newNode.setTotalCost();
                n = (Node)open.get(tmpHash);
                if (n == null) {
                    open.put(tmpHash, newNode);
                    continue;
                }
                if (newNode.costFromStart >= n.costFromStart) continue;
                open.remove(tmpHash);
                open.put(tmpHash, newNode);
            }
        }
        return null;
    }

    public static int getRandom(int a, int b) {
        Random random = new Random();
        return a + Math.abs(random.nextInt()) % (1 + b - a);
    }

    private void computeBezier() {
        this.currentGrenadePoint = 0;
        this.computeBezierRecursive(this.grenadePath, this.bezierLevel);
        this.grenadePoints[this.currentGrenadePoint][0] = this.grenadePath[3][0];
        this.grenadePoints[this.currentGrenadePoint][1] = this.grenadePath[3][1];
    }

    void computeBezierRecursive(int[][] b, int level) {
        try {
            if (level <= 0) {
                this.grenadePoints[this.currentGrenadePoint][0] = b[0][0];
                this.grenadePoints[this.currentGrenadePoint][1] = b[0][1];
                ++this.currentGrenadePoint;
            } else {
                int[][] left = new int[4][2];
                int[][] right = new int[4][2];
                left[0][0] = b[0][0];
                left[0][1] = b[0][1];
                left[1][0] = (b[0][0] + b[1][0]) / 2;
                left[1][1] = (b[0][1] + b[1][1]) / 2;
                left[2][0] = (b[0][0] + 2 * b[1][0] + b[2][0]) / 4;
                left[2][1] = (b[0][1] + 2 * b[1][1] + b[2][1]) / 4;
                left[3][0] = (b[0][0] + 3 * b[1][0] + 3 * b[2][0] + b[3][0]) / 8;
                left[3][1] = (b[0][1] + 3 * b[1][1] + 3 * b[2][1] + b[3][1]) / 8;
                right[0][0] = left[3][0];
                right[0][1] = left[3][1];
                right[1][0] = (b[1][0] + 2 * b[2][0] + b[3][0]) / 4;
                right[1][1] = (b[1][1] + 2 * b[2][1] + b[3][1]) / 4;
                right[2][0] = (b[2][0] + b[3][0]) / 2;
                right[2][1] = (b[2][1] + b[3][1]) / 2;
                right[3][0] = b[3][0];
                right[3][1] = b[3][1];
                this.computeBezierRecursive(left, level - 1);
                this.computeBezierRecursive(right, level - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeProjectilePath(int startX, int startY, int endX, int endY, int trajectHeight, int direction) {
        this.grenadePath[0][0] = startX;
        this.grenadePath[0][1] = startY;
        this.grenadePath[3][0] = endX;
        this.grenadePath[3][1] = endY;
        switch (direction) {
            case 9: {
                int[] nArray = this.grenadePath[0];
                nArray[0] = nArray[0] + 20;
                int[] nArray2 = this.grenadePath[0];
                nArray2[1] = nArray2[1] - 20;
                break;
            }
            case 3: {
                int[] nArray = this.grenadePath[0];
                nArray[0] = nArray[0] - 20;
                int[] nArray3 = this.grenadePath[0];
                nArray3[1] = nArray3[1] - 20;
                break;
            }
            case 6: {
                int[] nArray = this.grenadePath[0];
                nArray[0] = nArray[0] - 20;
                int[] nArray4 = this.grenadePath[0];
                nArray4[1] = nArray4[1] + 20;
                break;
            }
            case 12: {
                int[] nArray = this.grenadePath[0];
                nArray[0] = nArray[0] + 20;
                int[] nArray5 = this.grenadePath[0];
                nArray5[1] = nArray5[1] + 20;
                break;
            }
            case 1: {
                int[] nArray = this.grenadePath[0];
                nArray[1] = nArray[1] - 20;
                break;
            }
            case 2: {
                int[] nArray = this.grenadePath[0];
                nArray[0] = nArray[0] - 20;
                break;
            }
            case 4: {
                int[] nArray = this.grenadePath[0];
                nArray[1] = nArray[1] + 20;
                break;
            }
            case 8: {
                int[] nArray = this.grenadePath[0];
                nArray[0] = nArray[0] + 20;
                break;
            }
        }
        if (this.grenadePath[3][0] > this.grenadePath[0][0]) {
            this.grenadePath[1][0] = this.grenadePath[0][0] + (this.grenadePath[3][0] - this.grenadePath[0][0]) / 3;
            this.grenadePath[2][0] = this.grenadePath[0][0] + (this.grenadePath[3][0] - this.grenadePath[0][0]) * 2 / 3;
        } else if (this.grenadePath[3][0] < this.grenadePath[0][0]) {
            this.grenadePath[1][0] = this.grenadePath[0][0] - (this.grenadePath[0][0] - this.grenadePath[3][0]) / 3;
            this.grenadePath[2][0] = this.grenadePath[0][0] - (this.grenadePath[0][0] - this.grenadePath[3][0]) * 2 / 3;
        } else {
            this.grenadePath[1][0] = this.grenadePath[0][0];
            this.grenadePath[2][0] = this.grenadePath[0][0];
        }
        if (this.grenadePath[3][1] > this.grenadePath[0][1]) {
            this.grenadePath[1][1] = this.grenadePath[0][1] + (this.grenadePath[3][1] - this.grenadePath[0][1]) / 3 - trajectHeight;
            this.grenadePath[2][1] = this.grenadePath[0][1] + (this.grenadePath[3][1] - this.grenadePath[0][1]) * 2 / 3 - trajectHeight;
        } else if (this.grenadePath[3][1] < this.grenadePath[0][1]) {
            this.grenadePath[1][1] = this.grenadePath[0][1] - (this.grenadePath[0][1] - this.grenadePath[3][1]) / 3 - trajectHeight;
            this.grenadePath[2][1] = this.grenadePath[0][1] - (this.grenadePath[0][1] - this.grenadePath[3][1]) * 2 / 3 - trajectHeight;
        } else {
            this.grenadePath[1][1] = this.grenadePath[0][1] - trajectHeight;
            this.grenadePath[2][1] = this.grenadePath[0][1] - trajectHeight;
        }
        this.computeBezier();
    }

    private void createProjectile(int rowStart, int colStart, int rowEnd, int colEnd, boolean isMissile) {
        if (!isMissile) {
            GameBoard.objectArray[0] = new GameBoardObject(rowEnd, colEnd, 25);
        } else {
            int projectileDir = GameBoard.computeFullDirection(rowStart, colStart, rowEnd, colEnd, 0);
            GameBoard.objectArray[0] = new GameBoardObject(rowEnd, colEnd, 27);
            switch (projectileDir) {
                case 1: {
                    objectArray[0].setCurrentFrameNumber(0);
                    break;
                }
                case 8: {
                    objectArray[0].setCurrentFrameNumber(4);
                    break;
                }
                case 4: {
                    objectArray[0].setCurrentFrameNumber(8);
                    break;
                }
                case 2: {
                    objectArray[0].setCurrentFrameNumber(12);
                    break;
                }
                case 9: {
                    objectArray[0].setCurrentFrameNumber(2);
                    break;
                }
                case 3: {
                    objectArray[0].setCurrentFrameNumber(14);
                    break;
                }
                case 12: {
                    objectArray[0].setCurrentFrameNumber(6);
                    break;
                }
                case 6: {
                    objectArray[0].setCurrentFrameNumber(10);
                }
            }
        }
        GameBoard.objectArray[0].posX = this.grenadePath[0][0];
        GameBoard.objectArray[0].posZ = GameBoard.objectArray[0].posY = this.grenadePath[0][1];
        this.currentGrenadePoint = 0;
    }

    private void animateProjectile(int projectileEffect) {
        ++this.currentGrenadePoint;
        if (this.currentGrenadePoint < this.grenadePoints.length) {
            GameBoard.objectArray[0].posX = this.grenadePoints[this.currentGrenadePoint][0];
            GameBoard.objectArray[0].posY = this.grenadePoints[this.currentGrenadePoint][1];
            GameBoard.objectArray[0].posZ = this.grenadePoints[0][1] + (this.grenadePoints[16][1] - this.grenadePoints[0][1]) / 17 * this.currentGrenadePoint;
            if (GameBoard.objectArray[0].imageId == 25) {
                if (this.currentGrenadePoint >= 0 && this.currentGrenadePoint <= 1 || this.currentGrenadePoint >= 15 && this.currentGrenadePoint <= 16) {
                    objectArray[0].setCurrentFrameNumber(0);
                } else if (this.currentGrenadePoint >= 2 && this.currentGrenadePoint <= 3 || this.currentGrenadePoint >= 13 && this.currentGrenadePoint <= 14) {
                    objectArray[0].setCurrentFrameNumber(1);
                } else if (this.currentGrenadePoint >= 4 && this.currentGrenadePoint <= 6 || this.currentGrenadePoint >= 10 && this.currentGrenadePoint <= 12) {
                    objectArray[0].setCurrentFrameNumber(2);
                } else if (this.currentGrenadePoint >= 7 && this.currentGrenadePoint <= 9) {
                    objectArray[0].setCurrentFrameNumber(3);
                }
            } else {
                GameBoard.objectArray[0].currentFrameNumber = GameBoard.objectArray[0].currentFrameNumber % 2 == 0 ? ++GameBoard.objectArray[0].currentFrameNumber : --GameBoard.objectArray[0].currentFrameNumber;
            }
        } else if (GameBoard.objectArray[0].isAlive && !GameBoard.objectArray[0].isExploding) {
            objectArray[0].explode();
            this.explode(GameBoard.objectArray[0].tileRow, GameBoard.objectArray[0].tileCol, 1, GameBoard.objectArray[0].objectDamage, projectileEffect);
            PSCanvas.soundManager.play(0, 9, 0);
            PSCanvas.setVibration(200);
        } else if (!GameBoard.objectArray[0].isAlive) {
            GameBoard.objectArray[0] = null;
        }
    }

    private void explode(int row, int col, int range, int damage, int addedEffect) {
        int k;
        int startCol = col - range * 2;
        int startRow = row - range * 2;
        int endCol = col + range * 2;
        int endRow = row + range * 2;
        if (GameBoard.snake.tileRow >= startRow && GameBoard.snake.tileRow <= endRow && GameBoard.snake.tileCol >= startCol && GameBoard.snake.tileCol <= endCol && GameBoard.snake.isHit == 0) {
            snake.setDamage(damage, 0);
            if (addedEffect == 4) {
                snake.knockdown(GameBoard.computeDirection(row, col, GameBoard.snake.tileRow, GameBoard.snake.tileCol));
            }
        }
        for (k = 0; k < AiArray.length; ++k) {
            if (!GameBoard.AiArray[k].isAlive || GameBoard.AiArray[k].tileRow < startRow || GameBoard.AiArray[k].tileRow > endRow || GameBoard.AiArray[k].tileCol < startCol || GameBoard.AiArray[k].tileCol > endCol || !GameBoard.lineOfSight(row, col, GameBoard.AiArray[k].tileRow, GameBoard.AiArray[k].tileCol, GameBoard.computeDirection(row, col, GameBoard.AiArray[k].tileRow, GameBoard.AiArray[k].tileCol)) && (GameBoard.AiArray[k].tileCol != col || GameBoard.AiArray[k].tileRow != row) || GameBoard.AiArray[k].isKnockedDown) continue;
            AiArray[k].setDamage(damage, 0, addedEffect);
            if (addedEffect == 4) {
                AiArray[k].knockdown(GameBoard.computeDirection(row, col, GameBoard.AiArray[k].tileRow, GameBoard.AiArray[k].tileCol), k);
                continue;
            }
            AiArray[k].isHit();
        }
        for (k = 0; k < objectArray.length; ++k) {
            if (objectArray[k] == null || !GameBoard.objectArray[k].isAlive || !GameBoard.objectArray[k].canBeTargeted || GameBoard.objectArray[k].isExploding || GameBoard.objectArray[k].tileRow < startRow || GameBoard.objectArray[k].tileRow > endRow || GameBoard.objectArray[k].tileCol < startCol || GameBoard.objectArray[k].tileCol > endCol || !GameBoard.lineOfSight(row, col, GameBoard.objectArray[k].tileRow, GameBoard.objectArray[k].tileCol, GameBoard.computeDirection(row, col, GameBoard.objectArray[k].tileRow, GameBoard.objectArray[k].tileCol)) && (GameBoard.objectArray[k].tileCol != col || GameBoard.objectArray[k].tileRow != row)) continue;
            objectArray[k].explode();
            this.explode(GameBoard.objectArray[k].tileRow, GameBoard.objectArray[k].tileCol, 1, GameBoard.objectArray[k].objectDamage, 4);
            PSCanvas.soundManager.play(0, 9, 0);
            PSCanvas.setVibration(200);
        }
    }

    boolean checkActiveScript() {
        if (scriptArray[0][0] != 0) {
            boolean allDead = true;
            switch (scriptArray[0][0]) {
                case 1: {
                    for (int i = 0; i < AiArray.length; ++i) {
                        if (!GameBoard.AiArray[i].isAlerted) continue;
                        this.nextState = 4;
                        return false;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < AiArray.length; ++i) {
                        if (!GameBoard.AiArray[i].isAlive) continue;
                        allDead = false;
                    }
                    if (currentLevel == 13 && !GameBoard.AiArray[0].isAlive) {
                        allDead = true;
                    }
                    if (currentLevel == 14 && !GameBoard.AiArray[0].isAlive) {
                        allDead = true;
                    }
                    if (!allDead) break;
                    this.nextState = 3;
                    isScriptActive = true;
                    return true;
                }
                case 3: {
                    for (int i = 0; i < AiArray.length; ++i) {
                        if (!GameBoard.AiArray[i].isAlive) continue;
                        allDead = false;
                    }
                    if (!allDead) break;
                    GameBoard.scriptArray[this.currentScript][0] = GameBoard.snake.tileRow;
                    GameBoard.scriptArray[this.currentScript][1] = GameBoard.snake.tileCol;
                    GameBoard.scriptArray[this.currentScript][2] = GameBoard.snake.tileRow;
                    GameBoard.scriptArray[this.currentScript][3] = GameBoard.snake.tileCol;
                    GameBoard.scriptArray[this.currentScript + 1][0] = GameBoard.snake.tileRow;
                    GameBoard.scriptArray[this.currentScript + 1][1] = GameBoard.snake.tileCol;
                    GameBoard.scriptArray[this.currentScript + 1][2] = GameBoard.snake.tileRow;
                    GameBoard.scriptArray[this.currentScript + 1][3] = GameBoard.snake.tileCol;
                    GameBoard.scriptArray[0][0] = 0;
                    this.nextState = 23;
                    return true;
                }
            }
        }
        if (this.currentScript < scriptArray.length && GameBoard.snake.tileRow >= scriptArray[this.currentScript][0] && GameBoard.snake.tileCol >= scriptArray[this.currentScript][1] && GameBoard.snake.tileRow <= scriptArray[this.currentScript][2] && GameBoard.snake.tileCol <= scriptArray[this.currentScript][3]) {
            isScriptActive = true;
            return true;
        }
        return false;
    }

    private void executeScript() {
        if (this.currentScript < scriptArray.length) {
            switch (scriptArray[this.currentScript][4]) {
                case 0: {
                    if (scriptArray[this.currentScript][5] < 0) break;
                    PSCanvas.soundManager.play(0, 8, 0);
                    PSCanvas.setVibration(200);
                    this.ingameHud.loadDialogText(Dialogs.DIALOGS[scriptArray[this.currentScript][5]]);
                    this.nextState = 1;
                    break;
                }
                case 10: {
                    if (scriptArray[this.currentScript][5] < 0) break;
                    this.ingameHud.loadDialogText(Dialogs.DIALOGS[scriptArray[this.currentScript][5]]);
                    this.nextState = 27;
                    break;
                }
                case 1: {
                    this.savedState = this.currentState;
                    this.currentState = 2;
                    this.travelCamTo(scriptArray[this.currentScript][6] * 20, scriptArray[this.currentScript][5] * 20, 40);
                    if (currentLevel == 14 && this.LEVELS_SCRIPTS[currentLevel][this.currentScript][6] == scriptArray[this.currentScript][6] && this.LEVELS_SCRIPTS[currentLevel][this.currentScript][5] == scriptArray[this.currentScript][5] && !this.hasMetalGearAppeared) {
                        this.hasMetalGearAppeared = true;
                        PSCanvas.soundManager.play(1, 6, 0);
                        PSCanvas.setVibration(200);
                    }
                    this.forceCamTraveling = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    this.nextState = 3;
                    break;
                }
                case 8: {
                    this.pointsEarned = this.totalKills * 300 * (1 + (currentLevel - 6) / 100) + this.LEVELS_POINTS[currentLevel] - (totalAlarms * 100 + this.totalLevelCost * 5);
                    PSCanvas.gamePoints += this.pointsEarned;
                    if ((Integer)PSCanvas.foundItems[currentLevel - 6].firstElement() < this.LEVELS_CARD_PACKS[currentLevel].length) {
                        PSCanvas.foundItems[currentLevel - 6].setElementAt(new Integer((Integer)PSCanvas.foundItems[currentLevel - 6].elementAt(0) + this.pickedUpCardsPacks.size()), 0);
                    }
                    this.ingameHud.setResult(this.totalLevelCost, this.totalKills, totalAlarms, this.pointsEarned, PSCanvas.gamePoints, this.pickedUpCardsPacks.size(), this.LEVELS_CARD_PACKS[currentLevel].length, this.prepareCollectedCards());
                    alertPercent = 0;
                    this.nextState = 18;
                    break;
                }
                case 6: {
                    this.savedState = this.currentState;
                    this.currentState = 2;
                    this.waitTimer = scriptArray[this.currentScript][5];
                    PSCanvas.keyClear();
                    break;
                }
                case 7: {
                    this.messageBarText = "";
                    for (int i = 5; i < scriptArray[this.currentScript].length; ++i) {
                        this.messageBarText = this.messageBarText + PSCanvas.textArray[scriptArray[this.currentScript][i]];
                        this.messageBarText = this.messageBarText + " ";
                    }
                    if (this.messageBarText.equals(PSCanvas.textArray[495] + " " + PSCanvas.textArray[496] + " ")) {
                        PSCanvas.soundManager.play(1, 3, 0);
                    } else if (this.messageBarText.equals(PSCanvas.textArray[495] + " " + PSCanvas.textArray[497] + " ")) {
                        PSCanvas.soundManager.play(1, 4, 0);
                    }
                    this.nextState = 26;
                    break;
                }
                case 9: {
                    this.initiativeList.removeAllElements();
                    for (int i = 0; i < AiArray.length; ++i) {
                        if (!GameBoard.AiArray[i].isAlive) continue;
                        AiArray[i].die();
                    }
                    this.initAiArray(this.LEVEL_06_EXTRA_AI);
                    GameBoard.snake.currentCost = 0;
                    this.initiativeList.addElement(snake);
                    GameBoard.scriptArray[0][0] = 2;
                    this.updateDisplayCoordinates();
                    this.ingameHud.createPlayersStatsArray(AiArray.length);
                    this.ingameHud.updateSnakeStatus(snake);
                    this.ingameHud.updateAIStatus(AiArray);
                    this.nextState = 23;
                    break;
                }
            }
        }
        isScriptActive = false;
        ++this.currentScript;
    }

    public static void setAlert(boolean setAlert) {
        if (setAlert) {
            if (!isAlertOn) {
                PSCanvas.soundManager.play(0, 7, 0);
                PSCanvas.setVibration(200);
                isAlertOn = true;
            }
            if (alertPercent < 100) {
                ++totalAlarms;
            }
            alertPercent = 100;
            nextAlertPercent = 100;
        } else {
            if (nextAlertPercent <= 0) {
                isAlertOn = false;
            }
            for (int i = 0; i < AiArray.length; ++i) {
                AiArray[i].setAlertOff();
            }
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    private boolean checkDeaths() {
        int i;
        boolean aiAnimated = false;
        snake.update(0);
        for (i = 0; i < AiArray.length; ++i) {
            if (GameBoard.AiArray[i].type == 6 || GameBoard.AiArray[i].type == 7) continue;
            if (GameBoard.AiArray[i].isAnimated) {
                AiArray[i].update();
                aiAnimated = true;
            }
            if (GameBoard.AiArray[i].isHit <= 0) continue;
            aiAnimated = true;
        }
        if (!GameBoard.snake.isAnimated && !aiAnimated) {
            for (i = 0; i < AiArray.length; ++i) {
                if (GameBoard.AiArray[i].type != 9) {
                    for (int j = 1; j < 5; ++j) {
                        if (objectArray[j] == null || !GameBoard.objectArray[j].isAlive || GameBoard.objectArray[j].isExploding || GameBoard.AiArray[i].tileRow != GameBoard.objectArray[j].tileRow || GameBoard.AiArray[i].tileCol != GameBoard.objectArray[j].tileCol) continue;
                        objectArray[j].explode();
                        this.explode(GameBoard.objectArray[j].tileRow, GameBoard.objectArray[j].tileCol, 1, GameBoard.objectArray[j].objectDamage, 4);
                        PSCanvas.soundManager.play(0, 9, 0);
                        PSCanvas.setVibration(200);
                        GameBoard.AiArray[i].moveNumberLeft = 0;
                    }
                }
                if (GameBoard.AiArray[i].type == 6 || GameBoard.AiArray[i].type == 7) continue;
                if (GameBoard.AiArray[i].isAlive && GameBoard.AiArray[i].lifeNumberLeft <= 0) {
                    AiArray[i].die();
                    ++this.totalKills;
                    this.initiativeList.removeElement(AiArray[i]);
                    this.initiativeList.trimToSize();
                    this.setCam(GameBoard.AiArray[i].posX, GameBoard.AiArray[i].posY);
                    return true;
                }
                GameBoard.AiArray[i].isTargetable = false;
            }
            if (GameBoard.snake.lifeNumberLeft <= 0) {
                if (Snake.currentState != 13) {
                    snake.die();
                } else {
                    this.nextState = 4;
                }
                return true;
            }
            this.checkActiveScript();
            return false;
        }
        return true;
    }

    private int[] prepareCollectedCards() {
        if (this.pickedUpCardsPacks.size() > 0) {
            int i;
            int[] randomCards = new int[]{-1, -1, -1};
            int[] cardsNumber = null;
            Vector[] packCards = null;
            int indexCollected = 0;
            int totalCardsCount = 0;
            packCards = new Vector[4];
            cardsNumber = new int[4];
            for (i = 0; i < 4; ++i) {
                packCards[i] = new Vector(0);
                cardsNumber[i] = 0;
            }
            for (i = 0; i < CardSet.CARD_LIST.length; ++i) {
                if (!CardSet.CARD_LIST[i].getIsToBuyFind()) continue;
                int n = CardSet.CARD_LIST[i].getCardPack();
                cardsNumber[n] = cardsNumber[n] + 1;
                packCards[CardSet.CARD_LIST[i].getCardPack()].addElement(new Integer(i));
            }
            block8: for (i = 0; i < this.pickedUpCardsPacks.size(); ++i) {
                indexCollected = (Integer)this.pickedUpCardsPacks.elementAt(i);
                switch (indexCollected) {
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        totalCardsCount += 3;
                        continue block8;
                    }
                    default: {
                        ++totalCardsCount;
                    }
                }
            }
            int[] cardsCollected = new int[totalCardsCount];
            totalCardsCount = 0;
            block9: for (i = 0; i < this.pickedUpCardsPacks.size(); ++i) {
                indexCollected = (Integer)this.pickedUpCardsPacks.elementAt(i);
                switch (indexCollected) {
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        int j;
                        if (102 == indexCollected) {
                            for (j = 0; j < randomCards.length; ++j) {
                                randomCards[j] = (Integer)packCards[indexCollected - 99].elementAt(PSCanvas.getRandom(0, cardsNumber[indexCollected - 99] - 1));
                            }
                        } else {
                            while (randomCards[0] == randomCards[1] || randomCards[1] == randomCards[2] || randomCards[2] == randomCards[0]) {
                                for (j = 0; j < randomCards.length; ++j) {
                                    randomCards[j] = (Integer)packCards[indexCollected - 99].elementAt(PSCanvas.getRandom(0, cardsNumber[indexCollected - 99] - 1));
                                }
                            }
                        }
                        for (int k = 0; k < randomCards.length; ++k) {
                            if (!CardSet.CARD_LIST[randomCards[k]].getIsUnlocked()) {
                                CardSet.CARD_LIST[randomCards[k]].setUnlock();
                            }
                            CardSet.CARD_LIST[randomCards[k]].setCardsOwnAmount(CardSet.CARD_LIST[randomCards[k]].getCardsOwnAmount() + 1);
                            cardsCollected[totalCardsCount] = randomCards[k];
                            ++totalCardsCount;
                            randomCards[k] = -1;
                        }
                        continue block9;
                    }
                    default: {
                        if (!CardSet.CARD_LIST[indexCollected].getIsUnlocked()) {
                            CardSet.CARD_LIST[indexCollected].setUnlock();
                        }
                        CardSet.CARD_LIST[indexCollected].setCardsOwnAmount(CardSet.CARD_LIST[indexCollected].getCardsOwnAmount() + 1);
                        cardsCollected[totalCardsCount] = indexCollected;
                        ++totalCardsCount;
                    }
                }
            }
            return cardsCollected;
        }
        return null;
    }

    private void updateGameProgress() {
        this.isProgressUpdated = true;
        switch (currentLevel) {
            case 6: {
                if (PSCanvas.unlockedLevelsSneak == 0) {
                    PSCanvas.isUnlockElement = true;
                    PSCanvas.unlockedText = PSCanvas.textArray[33] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_SNEAK[++PSCanvas.unlockedLevelsSneak - 1] - 6 + 1);
                }
                if (PSCanvas.unlockedLevelsKillAll != 0) break;
                ++PSCanvas.unlockedLevelsKillAll;
                PSCanvas.isUnlockElement = true;
                if (!PSCanvas.unlockedText.equals("")) {
                    PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                }
                PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[34] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] - 6 + 1);
                break;
            }
            case 7: {
                if (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] < 7) {
                    ++PSCanvas.unlockedLevelsSneak;
                    PSCanvas.isUnlockElement = true;
                    if (!PSCanvas.unlockedText.equals("")) {
                        PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                    }
                    PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[33] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] - 6 + 1);
                }
                if (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] >= 7) break;
                ++PSCanvas.unlockedLevelsKillAll;
                PSCanvas.isUnlockElement = true;
                if (!PSCanvas.unlockedText.equals("")) {
                    PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                }
                PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[34] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] - 6 + 1);
                break;
            }
            case 8: {
                if (PSCanvas.unlockedPacksNumber < 3) {
                    ++PSCanvas.unlockedPacksNumber;
                    PSCanvas.isUnlockElement = true;
                    if (!PSCanvas.unlockedText.equals("")) {
                        PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                    }
                    PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[551] + " " + PSCanvas.textArray[550] + "|" + PSCanvas.textArray[523];
                }
                if (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] < 8) {
                    ++PSCanvas.unlockedLevelsSneak;
                    PSCanvas.isUnlockElement = true;
                    if (!PSCanvas.unlockedText.equals("")) {
                        PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                    }
                    PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[33] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] - 6 + 1);
                }
                if (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] >= 8) break;
                ++PSCanvas.unlockedLevelsKillAll;
                PSCanvas.isUnlockElement = true;
                if (!PSCanvas.unlockedText.equals("")) {
                    PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                }
                PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[34] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] - 6 + 1);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                if (PSCanvas.unlockedPacksNumber < 4) {
                    ++PSCanvas.unlockedPacksNumber;
                    PSCanvas.isUnlockElement = true;
                    if (!PSCanvas.unlockedText.equals("")) {
                        PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                    }
                    PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[551] + " " + PSCanvas.textArray[550] + "|" + PSCanvas.textArray[524];
                }
                if (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] < 10) {
                    ++PSCanvas.unlockedLevelsSneak;
                    PSCanvas.isUnlockElement = true;
                    if (!PSCanvas.unlockedText.equals("")) {
                        PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                    }
                    PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[33] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] - 6 + 1);
                }
                if (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] >= 10) break;
                ++PSCanvas.unlockedLevelsKillAll;
                PSCanvas.isUnlockElement = true;
                if (!PSCanvas.unlockedText.equals("")) {
                    PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                }
                PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[34] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] - 6 + 1);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                if (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] < 12) {
                    ++PSCanvas.unlockedLevelsSneak;
                    PSCanvas.isUnlockElement = true;
                    if (!PSCanvas.unlockedText.equals("")) {
                        PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                    }
                    PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[33] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_SNEAK[PSCanvas.unlockedLevelsSneak - 1] - 6 + 1);
                }
                if (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] >= 12) break;
                ++PSCanvas.unlockedLevelsKillAll;
                PSCanvas.isUnlockElement = true;
                if (!PSCanvas.unlockedText.equals("")) {
                    PSCanvas.unlockedText = PSCanvas.unlockedText + "|";
                }
                PSCanvas.unlockedText = PSCanvas.unlockedText + PSCanvas.textArray[34] + "|" + PSCanvas.textArray[493] + " " + (Constants.LEVELS_KILL[PSCanvas.unlockedLevelsKillAll - 1] - 6 + 1);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
        }
    }

    static {
        snakeTileColStart = 0;
        snakeTileRowStart = 0;
        camX = 0;
        camY = 0;
        camOffsetX = 0;
        camOffsetY = 0;
        camBorderOffsetX = 0;
        camBorderOffsetY = 0;
        displayStartX = 0;
        displayStartY = 0;
        camWidth = (short)176;
        camHeight = (short)193;
        BUFFER_PIXEL_WIDTH = camWidth;
        BUFFER_PIXEL_HEIGHT = camHeight;
        BUFFER_TILE_WIDTH = camWidth / 20 + 1 + camWidth % 20 / 10;
        BUFFER_TILE_HEIGHT = camHeight / 20 + 1 + camHeight % 20 / 10;
        boardImageBuffer = null;
        boardImageGraphics = null;
        camIsTraveling = false;
        currentLevel = 0;
        mapWidth = 0;
        mapHeight = 0;
        tileLayer0 = null;
        tileLayer1 = null;
        tileLayer2 = null;
        tileLayerZ = null;
        boundMapData = null;
        visionMapData = null;
        tilesAreTransparent = false;
        isScriptActive = false;
        offsetX = 0;
        offsetY = 0;
        instance = null;
        alertPercent = 0;
        nextAlertPercent = 0;
        isAlertOn = false;
        totalAlarms = 0;
    }
}

