/*
 * Decompiled with CFR 0.152.
 */
public class Snake
extends GameBoardElement
implements PSSpriteConstants {
    public static final int INITIAL_MAX_SNAKE_TURN_NUMBER = 2;
    public static final int INITIAL_MAX_SNAKE_LIFE_POINTS = 500;
    public static final int INITIAL_MAX_SNAKE_HAND_CARDS = 6;
    public static final int MOVE_ARRAY_CANNOT_REACH_ANYMORE = -1;
    public static final int MOVE_ARRAY_CANNOT_REACH = -2;
    public static final int SHADOW_WIDTH = 20;
    public static final int SHADOW_HEIGHT = 10;
    public static final int CSTATE_NONE = 0;
    public static final int CSTATE_STAND = 1;
    public static final int CSTATE_FLATTENED = 2;
    public static final int CSTATE_CRAWLED = 3;
    public static final int CSTATE_SET_ATTACK = 4;
    public static final int CSTATE_SET_CRAWLING = 5;
    public static final int CSTATE_MOVING = 6;
    public static final int CSTATE_CRAWLING = 7;
    public static final int CSTATE_STANDING_UP = 8;
    public static final int CSTATE_FLATTENING = 9;
    public static final int CSTATE_UNFLATTENING = 10;
    public static final int CSTATE_SHOOTING = 11;
    public static final int CSTATE_HIT = 12;
    public static final int CSTATE_DIEING = 13;
    public static final int CSTATE_KNOCKING = 14;
    public static final int CSTATE_PUNCHING = 15;
    public static final int CSTATE_ATTACK_IS_SET = 16;
    public static final int CSTATE_KNOCKDOWN = 17;
    public static final int CSTATE_KNOCKUP = 18;
    public static final int CSTATE_UNKNOCKING = 19;
    public static final int CSTATE_HIT_CRAWL = 20;
    public static final int CSTATE_THROW_GRENADE = 21;
    public static final int CSEC_KNOCKING = 22;
    public static PSSprite sprite;
    public PSSpritePlayer spritePlayer;
    private int[] animatedActions;
    public static final int ANIMATION_SHOOT_UP_REPEAT = 3;
    public static final int ANIMATION_SHOOT_LEFT_REPEAT = 3;
    public static final int ANIMATION_SHOOT_DOWN_REPEAT = 3;
    public static final int ANIMATION_SHOOT_RIGHT_REPEAT = 3;
    public static final int ANIMATION_RUN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_RUN_LEFT_REPEAT = 0;
    public static final int ANIMATION_RUN_UP_REPEAT = 0;
    public static final int ANIMATION_RUN_DOWN_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_LEFT_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_LEFT_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_UP_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_UP_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_DOWN_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_DOWN_REPEAT = 0;
    public static final int ANIMATION_CRAWL_UP_REPEAT = 2;
    public static final int ANIMATION_CRAWL_DOWN_REPEAT = 2;
    public static final int ANIMATION_CRAWL_LEFT_REPEAT = 2;
    public static final int ANIMATION_CRAWL_RIGHT_REPEAT = 2;
    public static final int ANIMATION_KNOCK_UP_REPEAT = 2;
    public static final int ANIMATION_KNOCK_DOWN_REPEAT = 2;
    public static final int ANIMATION_KNOCK_LEFT_REPEAT = 2;
    public static final int ANIMATION_KNOCK_RIGHT_REPEAT = 2;
    public static final int ANIMATION_PUNCH_UP_REPEAT = 0;
    public static final int ANIMATION_PUNCH_DOWN_REPEAT = 0;
    public static final int ANIMATION_PUNCH_LEFT_REPEAT = 0;
    public static final int ANIMATION_PUNCH_RIGHT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_UP_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_DOWN_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_LEFT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_UP_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_DOWN_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_LEFT_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_RIGHT_REPEAT = 0;
    public static final int ANIMATION_GRANADE_UP_REPEAT = 0;
    public static final int ANIMATION_GRANADE_DOWN_REPEAT = 0;
    public static final int ANIMATION_GRANADE_LEFT_REPEAT = 0;
    public static final int ANIMATION_GRANADE_RIGHT_REPEAT = 0;
    private static final int ANIMATED_ACTION_SHOOT_UP = 0;
    private static final int ANIMATED_ACTION_SHOOT_LEFT = 1;
    private static final int ANIMATED_ACTION_SHOOT_DOWN = 2;
    private static final int ANIMATED_ACTION_SHOOT_RIGHT = 3;
    private static final int ANIMATED_ACTION_DEATH_LEFT = 4;
    private static final int ANIMATED_ACTION_DEATH_RIGHT = 5;
    private static final int ANIMATED_ACTION_WALK_UP = 6;
    private static final int ANIMATED_ACTION_WALK_LEFT = 7;
    private static final int ANIMATED_ACTION_WALK_DOWN = 8;
    private static final int ANIMATED_ACTION_WALK_RIGHT = 9;
    private static final int ANIMATED_ACTION_FACE_UP = 10;
    private static final int ANIMATED_ACTION_FACE_LEFT = 11;
    private static final int ANIMATED_ACTION_FACE_DOWN = 12;
    private static final int ANIMATED_ACTION_FACE_RIGHT = 13;
    private static final int ANIMATED_ACTION_KNOCKDOWN_UP = 14;
    private static final int ANIMATED_ACTION_KNOCKDOWN_LEFT = 15;
    private static final int ANIMATED_ACTION_KNOCKDOWN_DOWN = 16;
    private static final int ANIMATED_ACTION_KNOCKDOWN_RIGHT = 17;
    private static final int ANIMATED_ACTION_SHOOT_UP_LEFT = 18;
    private static final int ANIMATED_ACTION_SHOOT_UP_RIGHT = 19;
    private static final int ANIMATED_ACTION_SHOOT_DOWN_LEFT = 20;
    private static final int ANIMATED_ACTION_SHOOT_DOWN_RIGHT = 21;
    private static final int ANIMATED_ACTION_BAZOOKA_UP = 22;
    private static final int ANIMATED_ACTION_BAZOOKA_LEFT = 23;
    private static final int ANIMATED_ACTION_BAZOOKA_DOWN = 24;
    private static final int ANIMATED_ACTION_BAZOOKA_RIGHT = 25;
    private static final int ANIMATED_ACTION_BAZOOKA_UP_LEFT = 26;
    private static final int ANIMATED_ACTION_BAZOOKA_UP_RIGHT = 27;
    private static final int ANIMATED_ACTION_BAZOOKA_DOWN_LEFT = 28;
    private static final int ANIMATED_ACTION_BAZOOKA_DOWN_RIGHT = 29;
    private static final int ANIMATED_ACTION_FLATTEN_UP = 30;
    private static final int ANIMATED_ACTION_FLATTEN_LEFT = 31;
    private static final int ANIMATED_ACTION_FLATTEN_DOWN = 32;
    private static final int ANIMATED_ACTION_FLATTEN_RIGHT = 33;
    private static final int ANIMATED_ACTION_CRAWL_UP = 34;
    private static final int ANIMATED_ACTION_CRAWL_LEFT = 35;
    private static final int ANIMATED_ACTION_CRAWL_DOWN = 36;
    private static final int ANIMATED_ACTION_CRAWL_RIGHT = 37;
    private static final int ANIMATED_ACTION_KNOCK_UP = 38;
    private static final int ANIMATED_ACTION_KNOCK_LEFT = 39;
    private static final int ANIMATED_ACTION_KNOCK_DOWN = 40;
    private static final int ANIMATED_ACTION_KNOCK_RIGHT = 41;
    private static final int ANIMATED_ACTION_PUNCH_UP = 42;
    private static final int ANIMATED_ACTION_PUNCH_LEFT = 43;
    private static final int ANIMATED_ACTION_PUNCH_DOWN = 44;
    private static final int ANIMATED_ACTION_PUNCH_RIGHT = 45;
    private static final int ANIMATED_ACTION_GRENADE_UP = 46;
    private static final int ANIMATED_ACTION_GRENADE_LEFT = 47;
    private static final int ANIMATED_ACTION_GRENADE_DOWN = 48;
    private static final int ANIMATED_ACTION_GRENADE_RIGHT = 49;
    private static final int ANIMATED_ACTION_FAMAS_UP = 50;
    private static final int ANIMATED_ACTION_FAMAS_LEFT = 51;
    private static final int ANIMATED_ACTION_FAMAS_DOWN = 52;
    private static final int ANIMATED_ACTION_FAMAS_RIGHT = 53;
    private static final int ANIMATED_ACTION_FAMAS_UP_LEFT = 54;
    private static final int ANIMATED_ACTION_FAMAS_UP_RIGHT = 55;
    private static final int ANIMATED_ACTION_FAMAS_DOWN_LEFT = 56;
    private static final int ANIMATED_ACTION_FAMAS_DOWN_RIGHT = 57;
    private static final int ANIMATED_ACTION_FLATTENSTILL_UP = 58;
    private static final int ANIMATED_ACTION_FLATTENSTILL_LEFT = 59;
    private static final int ANIMATED_ACTION_FLATTENSTILL_DOWN = 60;
    private static final int ANIMATED_ACTION_FLATTENSTILL_RIGHT = 61;
    private static final int ANIMATED_ACTION_CRAWLSTILL_UP = 62;
    private static final int ANIMATED_ACTION_CRAWLSTILL_LEFT = 63;
    private static final int ANIMATED_ACTION_CRAWLSTILL_DOWN = 64;
    private static final int ANIMATED_ACTION_CRAWLSTILL_RIGHT = 65;
    private static final int ANIMATED_ACTION_FAMASSTILL_UP = 66;
    private static final int ANIMATED_ACTION_FAMASSTILL_LEFT = 67;
    private static final int ANIMATED_ACTION_FAMASSTILL_DOWN = 68;
    private static final int ANIMATED_ACTION_FAMASSTILL_RIGHT = 69;
    private static final int ANIMATED_ACTION_GUNSTILL_UP = 70;
    private static final int ANIMATED_ACTION_GUNSTILL_LEFT = 71;
    private static final int ANIMATED_ACTION_GUNSTILL_DOWN = 72;
    private static final int ANIMATED_ACTION_GUNSTILL_RIGHT = 73;
    private static final int[] SNAKE_ANIMATED_ACTIONS;
    private final int MAX_VELOCITY;
    private final int VELOCITY_INCREASE;
    private final int VISION_RANGE;
    public boolean isAnimated = false;
    public int speedX = 40;
    public int speedY = 40;
    private int speedTileX = this.speedX / 20;
    private int speedTileY = this.speedY / 20;
    public int moveNumber = 4;
    public int moveNumberLeft = 4;
    public int moveNumberStanding = 0;
    public int[][][] moveArray;
    public int moveRowToBoundRow = 0;
    public int moveColToBoundCol = 0;
    public int moveRowStart;
    public int moveColStart;
    private int velocityX = 0;
    private int velocityY = 0;
    private int decelerateFrame = 0;
    public int moveInitialRow;
    public int moveInitialCol;
    private int moveInitialPosX;
    private int moveInitialPosY;
    private int moveInitialPosZ;
    private int moveInitialDirection;
    public int moveInitialState;
    public int facingDirection = 0;
    public boolean blockCancelMove = false;
    private int displayX;
    private int displayY;
    private int setClipX;
    private int setClipY;
    private int posYSubPixel = 0;
    private int posXSubPixel = 0;
    public int tileRow;
    public int tileCol;
    public int shadowOffsetX = 0;
    public int shadowOffsetY = 0;
    public int damageToPrint = -1;
    public int damagePrintDuration = 20;
    private boolean enteringState = false;
    private boolean exitingState = false;
    public static int lastState;
    public static int currentState;
    public static int nextState;
    public int lifeNumberLeft = 500;
    public int maxLifeNumber = 500;
    public int actionNumberLeft = 0;
    public int maxActionNumber = 2;
    public int decksCardsNumberLeft = 30;
    public int maxDecksCardsNumber = 30;
    public int cardsHandNumber = 6;
    public int maxEquipmentNumber = 2;
    public int equipmentNumber = 0;
    public int turnEffectCount = 0;
    public int effectCard = -1;
    public int isHit = 0;
    public boolean isHidden = false;
    public int hiddenStartRow = 0;
    public int hiddenStartCol = 0;
    public int[] equipment = new int[this.maxEquipmentNumber];
    public int[] equipmentUses = new int[this.maxEquipmentNumber];
    public int equipIndex = 0;
    public int[] targetList = null;
    public int[] targetObjectList = null;
    public boolean isTargetingObject = false;
    public int currentTarget = -1;
    public boolean hasFinishedAttack = false;
    public boolean hasPunched = false;
    public boolean canPunch = false;
    public boolean hasKnocked = false;
    public Deck deck;
    public boolean nextCardCost0 = false;

    public Snake() {
        this.MAX_VELOCITY = 16;
        this.VELOCITY_INCREASE = 4;
        this.VISION_RANGE = 10;
    }

    public Snake(int tileRow, int tileCol, int posZ, int facingDirection) {
        this.MAX_VELOCITY = 16;
        this.VELOCITY_INCREASE = 4;
        this.VISION_RANGE = 10;
        this.tileCol = tileCol;
        this.tileRow = tileRow;
        this.posX = tileCol * 20;
        this.posY = tileRow * 20;
        this.posZ = posZ * 20;
        this.posXSubPixel = tileCol * 20 << 8;
        this.posYSubPixel = tileRow * 20 << 8;
        this.facingDirection = facingDirection;
        lastState = 0;
        currentState = 1;
        nextState = 1;
        this.currentCost = 0;
        this.animatedActions = SNAKE_ANIMATED_ACTIONS;
        if (this.spritePlayer == null) {
            this.spritePlayer = new PSSpritePlayer(sprite);
        }
        this.updateDisplayPositions();
        this.deck = PSCanvas.gameDeck;
        for (int i = 0; i < this.equipment.length; ++i) {
            this.equipment[i] = -1;
        }
    }

    public void display(PSGraphics g) {
        g.setClip(this.setClipX, this.setClipY, sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()), sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()));
        if (this.isHit > 0) {
            if (this.isHit % 4 != 0 && this.isHit % 4 != 3) {
                if (this.getEquipment(11) != -1) {
                    g.drawImage(PSCanvas.imageArray[35], this.posX - GameBoard.camX + 20 - PSCanvas.imageWidth[35] / 2, this.posY - GameBoard.camY - 20);
                } else {
                    this.spritePlayer.moveTo(this.displayX, this.displayY);
                    this.spritePlayer.draw(g);
                }
            }
            --this.isHit;
        } else if (this.getEquipment(11) != -1) {
            g.drawImage(PSCanvas.imageArray[35], this.posX - GameBoard.camX + 20 - PSCanvas.imageWidth[35] / 2, this.posY - GameBoard.camY - 20);
        } else {
            this.spritePlayer.moveTo(this.displayX, this.displayY);
            this.spritePlayer.draw(g);
        }
    }

    public void displayShadow(PSGraphics g) {
        if (this.lifeNumberLeft > 0) {
            g.setClip(this.setClipX, this.setClipY, sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()), sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()));
            g.setColor(Constants.LEVELS_SHADOW_COLOR[GameBoard.currentLevel]);
            if (this.getEquipment(11) != -1) {
                g.fillArc(this.posX + 20 - 15 - GameBoard.camX, this.posY - GameBoard.camY - 2, 30, 15, 0, 360);
            } else if (currentState != 3 && currentState != 7 && nextState != 2 && nextState != 14 && (currentState != 12 || lastState != 3)) {
                g.fillArc(this.posX + 20 - 10 - GameBoard.camX + this.shadowOffsetX, this.posY - GameBoard.camY - 2 + this.shadowOffsetY, 20, 10, 0, 360);
            }
        }
    }

    public void updateAnim() {
        if (this.isAnimated) {
            this.spritePlayer.update();
            if (this.spritePlayer.getDurationFrame() == 0 && this.spritePlayer.isPlaying()) {
                this.updateMovePos();
                this.updateDisplayPositions();
            }
            if (!this.spritePlayer.isPlaying()) {
                this.isAnimated = false;
                this.shadowOffsetX = 0;
                this.shadowOffsetY = 0;
            }
        }
    }

    public void update(int keyPressed) {
        if (nextState != currentState) {
            if (!this.enteringState) {
                this.exitState(currentState);
            }
            if (!this.exitingState) {
                this.enterState(nextState);
            }
            if (!this.enteringState && !this.exitingState) {
                lastState = currentState;
                currentState = nextState;
            }
        }
        if (nextState == currentState) {
            switch (currentState) {
                case 1: 
                case 2: 
                case 3: {
                    this.setDirection(this.facingDirection);
                    if (!this.move(keyPressed)) break;
                    this.updateMoveGrid();
                    GameBoard.checkAiSeeingSnake();
                    GameBoard.checkSnakeSeeingAI(10);
                    break;
                }
                case 6: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (!GameBoard.isScriptActive && !this.move(keyPressed)) {
                        if (nextState == 9) break;
                        nextState = 1;
                        break;
                    }
                    this.updateMoveGrid();
                    GameBoard.checkAiSeeingSnake();
                    GameBoard.checkSnakeSeeingAI(10);
                    break;
                }
                case 7: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (!this.move(keyPressed)) {
                        nextState = 3;
                        break;
                    }
                    this.updateMoveGrid();
                    GameBoard.checkAiSeeingSnake();
                    GameBoard.checkSnakeSeeingAI(10);
                    break;
                }
                case 9: 
                case 14: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (currentState == 15) {
                        this.hasKnocked = true;
                    }
                    nextState = 2;
                    break;
                }
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (currentState == 15) {
                        this.hasPunched = true;
                    }
                    nextState = 1;
                    break;
                }
                case 12: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    nextState = lastState;
                    break;
                }
                case 13: {
                    if (!this.isAnimated) break;
                    this.updateAnim();
                    break;
                }
                case 4: {
                    this.setDirection(this.facingDirection);
                    break;
                }
            }
        }
    }

    private void enterState(int stateToEnter) {
        this.enteringState = true;
        switch (stateToEnter) {
            default: 
        }
        this.enteringState = false;
    }

    private void exitState(int stateToExit) {
        this.exitingState = true;
        switch (stateToExit) {
            default: 
        }
        this.exitingState = false;
    }

    public void initTurn() {
        if (GameBoard.instance.missionType == 2) {
            GameBoard.instance.checkActiveScript();
        }
        this.hasPunched = false;
        this.hasKnocked = false;
        if (this.effectCard != -1) {
            if (CardSet.CARD_LIST[this.effectCard].getCardSubType() == 7) {
                this.actionNumberLeft = this.maxActionNumber;
                --this.turnEffectCount;
                if (this.turnEffectCount == 0) {
                    this.effectCard = -1;
                }
            } else {
                this.actionNumberLeft = 2;
                this.maxActionNumber = 2;
            }
        } else {
            this.actionNumberLeft = 2;
            this.maxActionNumber = 2;
        }
    }

    public void updateMovePos() {
        this.velocityX = 0;
        this.velocityY = 0;
        switch (nextState) {
            case 7: {
                this.velocityX = 10240 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 3);
                this.velocityY = 10240 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 3);
                break;
            }
            case 6: {
                this.velocityX = 10240 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1);
                this.velocityY = 10240 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1);
                break;
            }
            case 17: {
                this.velocityX = -(10240 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1));
                this.velocityY = -(10240 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1));
                break;
            }
            case 9: {
                if (this.spritePlayer.getFrameIdx() > 0) {
                    if (GameBoard.tileLayer1[this.tileRow][this.tileCol] != -1 && this.facingDirection == 8 || GameBoard.tileLayer1[this.tileRow][this.tileCol + 1] != -1 && this.facingDirection == 2) {
                        this.velocityX = -(3072 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                        this.velocityY = -(3072 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                    } else {
                        this.velocityX = -(4096 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                        this.velocityY = -(4096 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                    }
                }
                if (this.spritePlayer.isCurrentFrameLast()) {
                    this.shadowOffsetX = -176;
                    this.shadowOffsetY = -208;
                    break;
                }
                this.shadowOffsetX = 0;
                this.shadowOffsetY = 0;
                break;
            }
            case 10: {
                if (this.spritePlayer.getFrameIdx() > 0) {
                    if (GameBoard.tileLayer1[this.tileRow][this.tileCol] != -1 && this.facingDirection == 8 || GameBoard.tileLayer1[this.tileRow][this.tileCol + 1] != -1 && this.facingDirection == 2) {
                        this.velocityX = 3072 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                        this.velocityY = 3072 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                    } else {
                        this.velocityX = 4096 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                        this.velocityY = 4096 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                    }
                }
                if (this.spritePlayer.isCurrentFrameFirst()) {
                    this.shadowOffsetX = -176;
                    this.shadowOffsetY = -208;
                    break;
                }
                this.shadowOffsetX = 0;
                this.shadowOffsetY = 0;
                break;
            }
        }
        switch (this.facingDirection) {
            case 1: {
                this.posYSubPixel -= this.velocityY;
                this.posY = this.posYSubPixel >> 8;
                break;
            }
            case 4: {
                if (currentState == 6) {
                    this.shadowOffsetY = -5;
                }
                this.posYSubPixel += this.velocityY;
                this.posY = this.posYSubPixel >> 8;
                break;
            }
            case 8: {
                this.posXSubPixel += this.velocityX;
                this.posX = this.posXSubPixel >> 8;
                break;
            }
            case 2: {
                this.posXSubPixel -= this.velocityX;
                this.posX = this.posXSubPixel >> 8;
                break;
            }
        }
        this.posZ = nextState == 7 || nextState == 3 ? -10000 : this.posY;
    }

    public boolean move(int direction) {
        switch (direction) {
            case 1: {
                if (currentState == 2) {
                    if (this.facingDirection == 1) {
                        nextState = 10;
                        this.setReversedAnimation(30, 0);
                    }
                    return false;
                }
                if (this.tileRow - 1 >= 0 && (GameBoard.boundMapData[this.tileRow - 1][this.tileCol] & 1) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileRow - this.speedTileY >= 0 && (GameBoard.tileLayerZ[this.tileRow - this.speedTileY][this.tileCol] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.posYSubPixel = this.tileRow * 20 << 8;
                        this.setAnimation(32, 0);
                        this.facingDirection = 4;
                    }
                    if (currentState != 3 || this.tileRow - this.speedTileY < 0 || (GameBoard.tileLayerZ[this.tileRow - this.speedTileY][this.tileCol] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileRow - this.speedTileY >= 0 && (GameBoard.boundMapData[this.tileRow - this.speedTileY][this.tileCol] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.posYSubPixel = this.tileRow * 20 << 8;
                this.tileRow -= this.speedTileY;
                if (this.facingDirection != 1) {
                    this.setDirection(1);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(34, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetY = -5;
                    this.setAnimation(6, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
            case 4: {
                if (currentState == 2) {
                    if (this.facingDirection == 4) {
                        nextState = 10;
                        this.setReversedAnimation(32, 0);
                    }
                    return false;
                }
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 4) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileRow + 1 < GameBoard.mapHeight && (GameBoard.tileLayerZ[this.tileRow + 1][this.tileCol] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.posYSubPixel = this.tileRow * 20 << 8;
                        this.setAnimation(30, 0);
                        this.facingDirection = 1;
                    }
                    if (currentState != 3 || this.tileRow + this.speedTileY >= GameBoard.mapHeight || (GameBoard.tileLayerZ[this.tileRow + this.speedTileY][this.tileCol] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileRow + this.speedTileY < GameBoard.mapHeight && (GameBoard.boundMapData[this.tileRow + this.speedTileY][this.tileCol] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.posYSubPixel = this.tileRow * 20 << 8;
                this.tileRow += this.speedTileY;
                if (this.facingDirection != 4) {
                    this.setDirection(4);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(36, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetY = 0;
                    this.setAnimation(8, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
            case 8: {
                if (currentState == 2) {
                    if (this.facingDirection == 8) {
                        nextState = 10;
                        this.setReversedAnimation(33, 0);
                    }
                    return false;
                }
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol + 1] & 8) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileCol + this.speedTileX < GameBoard.mapWidth && (GameBoard.tileLayerZ[this.tileRow][this.tileCol + this.speedTileX] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.posXSubPixel = this.tileCol * 20 << 8;
                        this.setAnimation(31, 0);
                        this.facingDirection = 2;
                    }
                    if (currentState != 3 || this.tileCol + this.speedTileX >= GameBoard.mapWidth || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + this.speedTileX] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileCol + this.speedTileX < GameBoard.mapWidth && (GameBoard.boundMapData[this.tileRow][this.tileCol + this.speedTileX] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.posXSubPixel = this.tileCol * 20 << 8;
                this.tileCol += this.speedTileX;
                if (this.facingDirection != 8) {
                    this.setDirection(8);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(37, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetX = 5;
                    this.setAnimation(9, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
            case 2: {
                if (currentState == 2) {
                    if (this.facingDirection == 2) {
                        nextState = 10;
                        this.setReversedAnimation(31, 0);
                    }
                    return false;
                }
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 2) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileCol - 1 >= 0 && (GameBoard.tileLayerZ[this.tileRow][this.tileCol - 1] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.posXSubPixel = this.tileCol * 20 << 8;
                        this.setAnimation(33, 0);
                        this.facingDirection = 8;
                    }
                    if (currentState != 3 || this.tileCol - this.speedTileX < 0 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol - this.speedTileX] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileCol - this.speedTileX >= 0 && (GameBoard.boundMapData[this.tileRow][this.tileCol - this.speedTileX] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.posXSubPixel = this.tileCol * 20 << 8;
                this.tileCol -= this.speedTileX;
                if (this.facingDirection != 2) {
                    this.setDirection(2);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(35, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetX = -5;
                    this.setAnimation(7, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
        }
        return false;
    }

    public void cancelMove() {
        this.moveNumberLeft = this.moveNumber;
        this.tileRow = this.moveInitialRow;
        this.tileCol = this.moveInitialCol;
        this.posX = this.moveInitialPosX;
        this.posY = this.moveInitialPosY;
        this.posZ = this.moveInitialPosZ;
        nextState = this.moveInitialState;
        this.posYSubPixel = this.posY << 8;
        this.posXSubPixel = this.posX << 8;
        this.setDirection(this.moveInitialDirection);
        this.updateDisplayPositions();
        if (nextState == 3) {
            this.moveNumberStanding = this.moveNumberLeft;
            this.moveNumberLeft -= 2;
        }
        this.updateMoveGrid();
    }

    public void setDirection(int direction) {
        switch (direction) {
            case 1: {
                this.facingDirection = 1;
                break;
            }
            case 2: {
                this.facingDirection = 2;
                break;
            }
            case 4: {
                this.facingDirection = 4;
                break;
            }
            case 8: {
                this.facingDirection = 8;
                break;
            }
        }
        block6 : switch (currentState) {
            case 2: {
                switch (this.facingDirection) {
                    case 1: {
                        this.spritePlayer.play(this.animatedActions[58], true);
                        break block6;
                    }
                    case 2: {
                        this.spritePlayer.play(this.animatedActions[59], true);
                        break block6;
                    }
                    case 4: {
                        this.spritePlayer.play(this.animatedActions[60], true);
                        break block6;
                    }
                    case 8: {
                        this.spritePlayer.play(this.animatedActions[61], true);
                        break block6;
                    }
                }
                break;
            }
            case 3: {
                switch (this.facingDirection) {
                    case 1: {
                        this.spritePlayer.play(this.animatedActions[62], true);
                        break block6;
                    }
                    case 2: {
                        this.spritePlayer.play(this.animatedActions[63], true);
                        break block6;
                    }
                    case 4: {
                        this.spritePlayer.play(this.animatedActions[64], true);
                        break block6;
                    }
                    case 8: {
                        this.spritePlayer.play(this.animatedActions[65], true);
                        break block6;
                    }
                }
                break;
            }
            case 1: 
            case 6: {
                switch (this.facingDirection) {
                    case 1: {
                        this.spritePlayer.play(this.animatedActions[10], true);
                        break block6;
                    }
                    case 2: {
                        this.spritePlayer.play(this.animatedActions[11], true);
                        break block6;
                    }
                    case 4: {
                        this.spritePlayer.play(this.animatedActions[12], true);
                        break block6;
                    }
                    case 8: {
                        this.spritePlayer.play(this.animatedActions[13], true);
                        break block6;
                    }
                }
                break;
            }
            case 4: {
                int type = CardSet.CARD_LIST[this.deck.getSelectedCard()].getCardSubType();
                switch (this.facingDirection) {
                    case 1: {
                        switch (type) {
                            case 23: {
                                this.spritePlayer.play(this.animatedActions[66], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.animatedActions[70], true);
                        break block6;
                    }
                    case 2: {
                        switch (type) {
                            case 23: {
                                this.spritePlayer.play(this.animatedActions[67], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.animatedActions[71], true);
                        break block6;
                    }
                    case 4: {
                        switch (type) {
                            case 23: {
                                this.spritePlayer.play(this.animatedActions[68], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.animatedActions[72], true);
                        break block6;
                    }
                    case 8: {
                        switch (type) {
                            case 23: {
                                this.spritePlayer.play(this.animatedActions[69], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.animatedActions[73], true);
                        break block6;
                    }
                }
                break;
            }
        }
        this.shadowOffsetX = 0;
        this.shadowOffsetY = 0;
        this.updateDisplayPositions();
    }

    public void setCrawl() {
        if (currentState == 1) {
            this.moveNumberStanding = this.moveNumberLeft;
            this.moveNumberLeft -= 2;
            if (this.moveNumberLeft < 0) {
                this.moveNumberLeft = 0;
            }
            nextState = 3;
            this.updateMoveGrid();
            this.posZ = -10000;
        }
    }

    public void setStandUp() {
        if (currentState == 3) {
            this.moveNumberLeft = this.moveNumberStanding;
            nextState = 1;
            this.updateMoveGrid();
            this.posZ = this.posY;
        }
    }

    public void setAttack() {
        try {
            if (this.getEquipment(11) != -1) {
                this.removeEquipment(this.getEquipment(11));
            }
        }
        catch (Exception ex) {
            System.out.println("SET ATACK ERROR");
            ex.printStackTrace();
        }
        nextState = 4;
    }

    public void unsetAttack() {
        nextState = 1;
    }

    public void knock() {
        nextState = 14;
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(38, 2);
                break;
            }
            case 2: {
                this.setAnimation(39, 2);
                break;
            }
            case 4: {
                this.setAnimation(40, 2);
                break;
            }
            case 8: {
                this.setAnimation(41, 2);
                break;
            }
        }
    }

    public void punch(int AiID) {
        if (this.getEquipment(11) != -1) {
            this.removeEquipment(this.getEquipment(11));
        }
        nextState = 15;
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(42, 0);
                break;
            }
            case 2: {
                this.setAnimation(43, 0);
                break;
            }
            case 4: {
                this.setAnimation(44, 0);
                break;
            }
            case 8: {
                this.setAnimation(45, 0);
                break;
            }
        }
        this.blockCancelMove = true;
        this.currentTarget = AiID;
        this.updateMoveGrid();
    }

    public void attack(int direction) {
        int type = CardSet.CARD_LIST[this.deck.getSelectedCard()].getCardSubType();
        nextState = 11;
        block0 : switch (direction) {
            case 1: {
                switch (type) {
                    case 27: {
                        this.setAnimation(22, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(50, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(46, 0);
                        break block0;
                    }
                }
                this.setAnimation(0, 3);
                break;
            }
            case 2: {
                switch (type) {
                    case 27: {
                        this.setAnimation(23, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(51, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(47, 0);
                        break block0;
                    }
                }
                this.setAnimation(1, 3);
                break;
            }
            case 4: {
                switch (type) {
                    case 27: {
                        this.setAnimation(24, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(52, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(48, 0);
                        break block0;
                    }
                }
                this.setAnimation(2, 3);
                break;
            }
            case 8: {
                switch (type) {
                    case 27: {
                        this.setAnimation(25, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(53, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(49, 0);
                        break block0;
                    }
                }
                this.setAnimation(3, 3);
                break;
            }
        }
        this.hasFinishedAttack = true;
    }

    public void isHit() {
        this.isHit = 18;
    }

    public void knockdown(int direction) {
        this.posYSubPixel = this.tileRow * 20 << 8;
        this.posXSubPixel = this.tileCol * 20 << 8;
        this.spritePlayer.stop();
        switch (direction) {
            case 1: {
                if ((this.tileRow - 1 < 0 || (GameBoard.boundMapData[this.tileRow - 1][this.tileCol] & 1) != 0) && (this.tileRow - 2 < 0 || (GameBoard.tileLayerZ[this.tileRow - 2][this.tileCol] & 0xF) != 15) || this.tileRow - 2 < 0 || (GameBoard.boundMapData[this.tileRow - 2][this.tileCol] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 4;
                this.setAnimation(16, 0);
                this.tileRow -= 2;
                break;
            }
            case 2: {
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 2) != 0 && (this.tileCol - 1 < 0 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol - 1] & 0xF) != 15) || this.tileCol - 2 < 0 || (GameBoard.boundMapData[this.tileRow][this.tileCol - 2] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 8;
                this.setAnimation(17, 0);
                this.tileCol -= 2;
                break;
            }
            case 4: {
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 4) != 0 && (this.tileRow + 1 >= GameBoard.mapHeight || (GameBoard.tileLayerZ[this.tileRow + 1][this.tileCol] & 0xF) != 15) || this.tileRow + 2 >= GameBoard.mapHeight || (GameBoard.boundMapData[this.tileRow + 2][this.tileCol] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 1;
                this.setAnimation(14, 0);
                this.tileRow += 2;
                break;
            }
            case 8: {
                if ((this.tileCol + 1 < 0 || (GameBoard.boundMapData[this.tileRow][this.tileCol + 1] & 8) != 0) && (this.tileCol + 2 >= GameBoard.mapHeight || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + 2] & 0xF) != 15) || this.tileCol + 2 >= GameBoard.mapHeight || (GameBoard.boundMapData[this.tileRow][this.tileCol + 2] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 2;
                this.setAnimation(15, 0);
                this.tileCol += 2;
                break;
            }
        }
        if ((GameBoard.tileLayerZ[this.tileRow][this.tileCol] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow - 1][this.tileCol] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + 1] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow - 1][this.tileCol + 1] & 0xF) == 15) {
            this.lifeNumberLeft = 0;
        } else {
            this.isHit();
        }
    }

    public void die() {
        nextState = 13;
        this.posYSubPixel = this.tileRow * 20 << 8;
        this.posXSubPixel = this.tileCol * 20 << 8;
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(15, 0);
                break;
            }
            case 2: {
                this.setAnimation(15, 0);
                break;
            }
            case 4: {
                this.setAnimation(17, 0);
                break;
            }
            case 8: {
                this.setAnimation(17, 0);
                break;
            }
        }
    }

    public void updateDisplayPositions() {
        this.setClipX = this.posX - GameBoard.camX - (sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()) >> 2);
        this.setClipY = this.posY - GameBoard.camY - sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()) / 5 * 3;
        this.displayX = this.setClipX;
        this.displayY = this.setClipY;
    }

    public void computeMoveGrid() {
        int rowStart = (this.moveNumber << 1) + 1 >> 1;
        this.moveRowStart = this.tileRow;
        this.moveColStart = this.tileCol;
        int colStart = (this.moveNumber << 1) + 1 >> 1;
        this.moveRowToBoundRow = this.tileRow - ((rowStart << 1) + 1);
        this.moveColToBoundCol = this.tileCol - (colStart << 1);
        this.moveArray = new int[(this.moveNumber << 1) + 1][(this.moveNumber << 1) + 1][1];
        for (int i = 0; i < this.moveArray.length; ++i) {
            for (int j = 0; j < this.moveArray[i].length; ++j) {
                this.moveArray[i][j][0] = -2;
            }
        }
        this.initRecursiveComputeMove(rowStart, colStart, this.moveNumber, this.moveNumber - 2);
        this.updateMoveGrid();
    }

    public void initRecursiveComputeMove(int rowStart, int colStart, int moveLeft, int moveCrawLeft) {
        int currentBoundMapRowChecking = (rowStart << 1) + 1 + this.moveRowToBoundRow;
        int currentBoundMapColChecking = (colStart << 1) + this.moveColToBoundCol;
        if (moveLeft > -1 && rowStart >= 0 && colStart >= 0 && currentBoundMapRowChecking < GameBoard.mapHeight && currentBoundMapColChecking < GameBoard.mapWidth && colStart <= this.moveArray.length && rowStart <= this.moveArray.length && (GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking] & 0x10) == 0) {
            if (moveLeft < this.moveArray[rowStart][colStart][0]) {
                return;
            }
            this.moveArray[rowStart][colStart][0] = moveLeft;
            if (currentBoundMapRowChecking - 1 > 0 && (GameBoard.boundMapData[currentBoundMapRowChecking - 1][currentBoundMapColChecking] & 1) == 0 || moveCrawLeft > 0 && currentBoundMapRowChecking - 2 > 0 && (GameBoard.tileLayerZ[currentBoundMapRowChecking - 2][currentBoundMapColChecking] & 0x10) != 0) {
                this.initRecursiveComputeMove(rowStart - 1, colStart, moveLeft - 1, moveCrawLeft - 1);
            }
            if ((GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking] & 4) == 0 || moveCrawLeft > 0 && currentBoundMapRowChecking + 2 < GameBoard.mapHeight && (GameBoard.tileLayerZ[currentBoundMapRowChecking + 2][currentBoundMapColChecking] & 0x10) != 0) {
                this.initRecursiveComputeMove(rowStart + 1, colStart, moveLeft - 1, moveCrawLeft - 1);
            }
            if ((GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking] & 2) == 0 || moveCrawLeft > 0 && currentBoundMapColChecking - 2 > 0 && (GameBoard.tileLayerZ[currentBoundMapRowChecking][currentBoundMapColChecking - 2] & 0x10) != 0) {
                this.initRecursiveComputeMove(rowStart, colStart - 1, moveLeft - 1, moveCrawLeft - 1);
            }
            if (currentBoundMapColChecking + 1 < GameBoard.mapWidth && (GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking + 1] & 8) == 0 || moveCrawLeft > 0 && currentBoundMapColChecking + 2 < GameBoard.mapWidth && (GameBoard.tileLayerZ[currentBoundMapRowChecking][currentBoundMapColChecking + 2] & 0x10) != 0) {
                this.initRecursiveComputeMove(rowStart, colStart + 1, moveLeft - 1, moveCrawLeft - 1);
            }
        }
    }

    public void recursiveComputeMove(int rowStart, int colStart, int moveLeft) {
        int currentBoundMapRowChecking = (rowStart << 1) + 1 + this.moveRowToBoundRow;
        int currentBoundMapColChecking = (colStart << 1) + this.moveColToBoundCol;
        if (moveLeft > -1 && rowStart >= 0 && colStart >= 0 && currentBoundMapRowChecking < GameBoard.mapHeight && currentBoundMapColChecking < GameBoard.mapWidth && colStart <= this.moveArray.length && rowStart <= this.moveArray.length && (GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking] & 0x10) == 0) {
            if (moveLeft < this.moveArray[rowStart][colStart][0]) {
                return;
            }
            this.moveArray[rowStart][colStart][0] = moveLeft;
            if (currentBoundMapRowChecking - 1 > 0 && (GameBoard.boundMapData[currentBoundMapRowChecking - 1][currentBoundMapColChecking] & 1) == 0 || (nextState == 3 || nextState == 7) && currentBoundMapRowChecking - 2 > 0 && (GameBoard.tileLayerZ[currentBoundMapRowChecking - 2][currentBoundMapColChecking] & 0x10) != 0) {
                this.recursiveComputeMove(rowStart - 1, colStart, moveLeft - 1);
            }
            if ((GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking] & 4) == 0 || (nextState == 3 || nextState == 7) && currentBoundMapRowChecking + 2 < GameBoard.mapHeight && (GameBoard.tileLayerZ[currentBoundMapRowChecking + 2][currentBoundMapColChecking] & 0x10) != 0) {
                this.recursiveComputeMove(rowStart + 1, colStart, moveLeft - 1);
            }
            if ((GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking] & 2) == 0 || (nextState == 3 || nextState == 7) && currentBoundMapColChecking - 2 > 0 && (GameBoard.tileLayerZ[currentBoundMapRowChecking][currentBoundMapColChecking - 2] & 0x10) != 0) {
                this.recursiveComputeMove(rowStart, colStart - 1, moveLeft - 1);
            }
            if (currentBoundMapColChecking + 1 < GameBoard.mapWidth && (GameBoard.boundMapData[currentBoundMapRowChecking][currentBoundMapColChecking + 1] & 8) == 0 || (nextState == 3 || nextState == 7) && currentBoundMapColChecking + 2 < GameBoard.mapWidth && (GameBoard.tileLayerZ[currentBoundMapRowChecking][currentBoundMapColChecking + 2] & 0x10) != 0) {
                this.recursiveComputeMove(rowStart, colStart + 1, moveLeft - 1);
            }
        }
    }

    public void updateMoveGrid() {
        int rowStart = this.moveRowStart - (this.moveRowStart - this.tileRow) - this.moveRowToBoundRow >> 1;
        int colStart = this.moveColStart - (this.moveColStart - this.tileCol) - this.moveColToBoundCol >> 1;
        for (int i = 0; i < this.moveArray.length; ++i) {
            for (int j = 0; j < this.moveArray[i].length; ++j) {
                if (this.moveArray[i][j][0] < 0) continue;
                this.moveArray[i][j][0] = -1;
            }
        }
        this.recursiveComputeMove(rowStart, colStart, this.moveNumberLeft);
    }

    public void setHidden(int startingRow, int startingCol) {
        this.isHidden = true;
        this.hiddenStartRow = startingRow;
        this.hiddenStartCol = startingCol;
    }

    public void setMove(int setNumber) {
        this.posYSubPixel = this.posY << 8;
        this.posXSubPixel = this.posX << 8;
        this.moveNumber = setNumber;
        this.moveNumberLeft = setNumber;
        this.moveInitialRow = this.tileRow;
        this.moveInitialCol = this.tileCol;
        this.moveInitialPosX = this.posX;
        this.moveInitialPosY = this.posY;
        this.moveInitialPosZ = this.posZ;
        this.moveInitialDirection = this.facingDirection;
        this.moveInitialState = currentState;
        this.blockCancelMove = false;
        this.computeMoveGrid();
        if (this.moveInitialState == 3) {
            this.moveNumberStanding = this.moveNumberLeft;
            this.moveNumberLeft -= 2;
            this.updateMoveGrid();
        }
    }

    public void setDamage(int damage, int type) {
        int snakeEquipmentIndex;
        int snakeEquipment;
        if (this.getEquipment(11) != -1) {
            this.removeEquipment(this.getEquipment(11));
        }
        int n = snakeEquipment = (snakeEquipmentIndex = this.getEquipment(6)) != -1 ? this.equipment[snakeEquipmentIndex] : -1;
        if (snakeEquipment != -1) {
            if (PSCanvas.getRandom(0, 100) <= CardSet.CARD_LIST[snakeEquipment].getCardReactionChance()) {
                if ((damage -= CardSet.CARD_LIST[snakeEquipment].getCardAttackDamage()) <= 0) {
                    damage = 0;
                }
                this.removeEquipment(snakeEquipmentIndex);
            }
        } else {
            snakeEquipmentIndex = this.getEquipment(15);
            int n2 = snakeEquipment = snakeEquipmentIndex != -1 ? this.equipment[snakeEquipmentIndex] : -1;
            if (snakeEquipment != -1 && PSCanvas.getRandom(0, 100) <= CardSet.CARD_LIST[snakeEquipment].getCardReactionChance()) {
                this.removeEquipment(snakeEquipmentIndex);
                return;
            }
        }
        if (type == -1) {
            this.damageToPrint = -damage;
        } else {
            this.damageToPrint = damage;
            this.isHit();
        }
        this.damagePrintDuration = 0;
        this.lifeNumberLeft -= this.damageToPrint;
    }

    public void setAnimation(int animatedAction, int repeatCount) {
        if (animatedAction >= this.animatedActions.length || this.animatedActions[animatedAction] == -1) {
            return;
        }
        this.isAnimated = true;
        this.spritePlayer.play(this.animatedActions[animatedAction], repeatCount);
        this.updateMovePos();
        this.updateDisplayPositions();
    }

    public void setReversedAnimation(int animatedAction, int repeatCount) {
        if (animatedAction >= this.animatedActions.length || this.animatedActions[animatedAction] == -1) {
            return;
        }
        this.isAnimated = true;
        this.spritePlayer.reversePlay(this.animatedActions[animatedAction], repeatCount);
        this.updateMovePos();
        this.updateDisplayPositions();
    }

    public int getEquipment(int equipmentType) {
        for (int i = 0; i < this.equipment.length; ++i) {
            if (this.equipment[i] == -1 || equipmentType != CardSet.CARD_LIST[this.equipment[i]].getCardSubType()) continue;
            return i;
        }
        return -1;
    }

    public void removeEquipment(int equipmentIndex) {
        this.equipment[equipmentIndex] = -1;
    }

    public void addCost(int costToAdd) {
        if (this.nextCardCost0) {
            this.nextCardCost0 = false;
        } else {
            this.currentCost += costToAdd;
        }
    }

    static {
        SNAKE_ANIMATED_ACTIONS = new int[]{6, 7, 9, 8, 19, 20, 10, 1, 21, 0, 28, 29, 31, 30, 67, 19, 66, 20, -1, -1, -1, -1, 36, 37, 39, 38, -1, -1, -1, -1, 17, 13, 11, 15, 5, 3, 2, 4, 18, 14, 12, 16, 75, 74, 72, 73, 68, 69, 71, 70, 6, 7, 9, 8, -1, -1, -1, -1, 65, 63, 62, 64, 35, 33, 32, 34, 77, 78, 80, 79, 77, 78, 80, 79};
        lastState = 0;
        currentState = 1;
        nextState = 1;
    }
}

