/*
 * Decompiled with CFR 0.152.
 */
public class PSSpritePlayer {
    private PSSprite sprite;
    private int x;
    private int y;
    private int frame;
    private int frameNumber;
    private int frameCounter;
    private int startFrame;
    private int endFrame;
    private int durationFrame;
    private boolean playing;
    private int animId;
    private boolean loop;
    private int repeatCounter;
    private boolean reverse;

    public PSSpritePlayer(PSSprite sprite) {
        this.sprite = sprite;
    }

    public void play(int animId, boolean loop) {
        this.startFrame = 0;
        this.endFrame = this.sprite.getAnimationFramesNumber(animId) - 1;
        this.play(animId, this.startFrame, this.endFrame, loop);
    }

    public void play(int animId, int repeatCounter) {
        this.startFrame = 0;
        this.endFrame = this.sprite.getAnimationFramesNumber(animId) - 1;
        this.play(animId, this.startFrame, this.endFrame, repeatCounter);
    }

    public void play(int animId, int startFrame, int endFrame, int repeatCounter) {
        this.playing = true;
        this.reverse = false;
        this.animId = animId;
        this.loop = false;
        this.repeatCounter = repeatCounter;
        this.frame = startFrame;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.durationFrame = 0;
        this.frameCounter = this.frameNumber = endFrame - startFrame + 1;
    }

    public void play(int animId, int startFrame, int endFrame, boolean loop) {
        this.playing = true;
        this.reverse = false;
        this.animId = animId;
        this.loop = loop;
        this.repeatCounter = 0;
        this.frame = startFrame;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.durationFrame = 0;
        this.frameCounter = this.frameNumber = endFrame - startFrame + 1;
    }

    public void reversePlay(int animId, int repeatCounter) {
        this.startFrame = this.sprite.getAnimationFramesNumber(animId) - 1;
        this.endFrame = 0;
        this.reversePlay(animId, this.startFrame, this.endFrame, repeatCounter);
    }

    public void reversePlay(int animId, int startFrame, int endFrame, int repeatCounter) {
        this.playing = true;
        this.reverse = true;
        this.animId = animId;
        this.loop = false;
        this.repeatCounter = repeatCounter;
        this.frame = startFrame;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.durationFrame = 0;
        this.frameCounter = this.frameNumber = startFrame - endFrame + 1;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isCurrentFrameLast() {
        return this.frame == this.endFrame;
    }

    public boolean isCurrentFrameFirst() {
        return this.frame == this.startFrame;
    }

    public void update() {
        if (!this.playing) {
            return;
        }
        if (this.durationFrame < this.sprite.getFrameInAnimationTiming(this.animId, this.frame) - 1) {
            ++this.durationFrame;
        } else {
            this.durationFrame = 0;
            this.frame = this.reverse ? --this.frame : ++this.frame;
            --this.frameCounter;
            if (this.frameCounter <= 0) {
                this.frame = this.endFrame;
                if (!this.loop) {
                    if (--this.repeatCounter < 0) {
                        this.stop();
                    } else {
                        this.durationFrame = 0;
                        this.frame = this.startFrame;
                        this.frameCounter = this.frameNumber;
                    }
                } else {
                    this.durationFrame = 0;
                    this.frame = this.startFrame;
                    this.frameCounter = this.frameNumber;
                }
            }
        }
    }

    public void stop() {
        this.playing = false;
    }

    public void draw(PSGraphics g) {
        this.sprite.drawAniFrame(g, this.animId, this.frame, this.x, this.y);
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void moveTo(int px, int py) {
        this.x = px;
        this.y = py;
    }

    public int getFrameIdx() {
        if (this.reverse) {
            return this.frameNumber - this.frame - 1;
        }
        return this.frame;
    }

    public int getAnimIdx() {
        return this.animId;
    }

    public int getRepeatCounter() {
        return this.repeatCounter;
    }

    public int getDurationFrame() {
        return this.durationFrame;
    }
}

