/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class PSSoundManager
implements Constants {
    public static PSSoundManager instance = null;
    public static boolean soundOn = false;
    public static boolean musicOn = false;
    public static int currentSoundIndex = -1;
    static int currentRepeat = 0;
    private String typeOfSound = "";
    private String extention = "";
    private static Player soundPlayer = null;

    public PSSoundManager(String soundType) {
        instance = this;
        this.typeOfSound = soundType;
        if (soundType.equals("audio/x-wav")) {
            this.extention = ".wav";
        } else if (soundType.equals("audio/midi")) {
            this.extention = ".mid";
        } else if (soundType.equals("audio/amr")) {
            this.extention = ".amr";
        }
    }

    public void init(int player, int soundIndex) {
        if (soundIndex != currentSoundIndex) {
            currentSoundIndex = soundIndex;
        }
        try {
            Player tmpPlayer;
            soundPlayer = tmpPlayer = Manager.createPlayer((InputStream)instance.getClass().getResourceAsStream(Constants.MUSIC_FILE_NAME[soundIndex] + this.extention), (String)this.typeOfSound);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play(int player, int soundIndex, int repeat) {
        if (soundOn && player == 0 || musicOn && player == 1) {
            if (soundIndex != currentSoundIndex) {
                this.stop(player);
            }
            if (soundPlayer == null) {
                currentSoundIndex = soundIndex;
                this.init(player, soundIndex);
                this.play(player, soundIndex, repeat);
                return;
            }
            try {
                if (soundPlayer.getState() != 400) {
                    soundPlayer.realize();
                    currentRepeat = repeat;
                    if (repeat != 0) {
                        soundPlayer.setLoopCount(repeat);
                    }
                    soundPlayer.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop(int player) {
        try {
            if (soundPlayer != null) {
                soundPlayer.stop();
                soundPlayer.deallocate();
                soundPlayer.close();
                soundPlayer = null;
                PSGraphics.Gc();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void soundOnOff() {
        if (soundOn) {
            this.stop(0);
            soundOn = false;
        } else {
            soundOn = true;
            this.stop(1);
            musicOn = false;
        }
    }

    public void musicOnOff() {
        if (musicOn) {
            this.stop(1);
            musicOn = false;
        } else {
            musicOn = true;
            this.stop(0);
            soundOn = false;
        }
    }

    public int getPlayerState() {
        if (soundPlayer != null) {
            return soundPlayer.getState();
        }
        return -1;
    }

    public void restart() {
        try {
            if (soundPlayer != null && (soundOn || musicOn)) {
                soundPlayer.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void forceStop() {
        try {
            if (soundPlayer == null) {
                return;
            }
            soundPlayer.stop();
            soundPlayer.close();
            soundPlayer = null;
        }
        catch (Exception e) {
            PSSoundManager.forceStop();
        }
    }
}

