/*
 * Decompiled with CFR 0.152.
 */
public class GameBoardObject
extends GameBoardElement {
    public static final int EXPLOSION_SPR_WIDTH = 24;
    public static final int EXPLOSION_SPR_HEIGHT = 24;
    public static final int EXPLOSION_ANIM_LENGTH = 7;
    PSSpritePlayer explosionSpritePlayer;
    private int flag = 0;
    public int tileRow = 0;
    public int tileCol = 0;
    private int frameNumber = 1;
    public int currentFrameNumber = 0;
    private int frameWidth;
    private int counter = 0;
    public boolean canBeTargeted = false;
    public boolean isTargetable = false;
    public boolean isExploding = false;
    public boolean isAlive = true;
    public boolean isActive = false;
    public int objectDamage = 0;
    public int fillDisplayQueueOffsetX1 = 0;
    public int fillDisplayQueueOffsetX2 = 0;
    public int fillDisplayQueueOffsetY1 = 0;
    public int fillDisplayQueueOffsetY2 = 0;
    public boolean doorOpened = false;

    public GameBoardObject() {
    }

    public GameBoardObject(int row, int col, int imageId) {
        this.tileRow = row;
        this.tileCol = col;
        this.imageId = imageId;
        this.isExploding = false;
        switch (imageId) {
            case 28: {
                this.posX = col * 20;
                this.posZ = this.posY = row * 20 - 10;
                this.flag = 3;
                byte[] byArray = GameBoard.boundMapData[this.tileRow];
                int n = this.tileCol;
                byArray[n] = (byte)(byArray[n] + 16);
                break;
            }
            case 56: {
                this.posX = col * 20 - 10 - 2;
                this.posY = row * 20 - 10 - 2;
                this.posZ = -10001;
                break;
            }
            case 57: {
                this.posX = col * 20;
                this.posZ = this.posY = row * 20;
                this.flag = 3;
                this.canBeTargeted = true;
                byte[] byArray = GameBoard.boundMapData[this.tileRow];
                int n = this.tileCol;
                byArray[n] = (byte)(byArray[n] + 16);
                this.objectDamage = 100;
                this.explosionSpritePlayer = new PSSpritePlayer(GameAI.spriteExplosions);
                break;
            }
            case 26: {
                this.posX = col * 20;
                this.posY = row * 20;
                this.posZ = -10001;
                this.flag = 3;
                this.canBeTargeted = true;
                this.explosionSpritePlayer = new PSSpritePlayer(GameAI.spriteExplosions);
                break;
            }
            case 25: {
                this.flag = 0;
                this.frameNumber = 4;
                this.explosionSpritePlayer = new PSSpritePlayer(GameAI.spriteExplosions);
                break;
            }
            case 27: {
                this.flag = 0;
                this.frameNumber = 16;
                this.explosionSpritePlayer = new PSSpritePlayer(GameAI.spriteExplosions);
                break;
            }
            case 19: {
                this.flag = 0;
                this.posX = col * 20 - 10;
                this.posY = row * 20 - 50;
                this.posZ = row * 20;
                this.fillDisplayQueueOffsetY1 = 60;
                break;
            }
            case 20: {
                this.flag = 0;
                this.posX = col * 20 - 10;
                this.posY = row * 20 - 40 - 6;
                this.posZ = row * 20;
                break;
            }
            case 21: {
                this.flag = 0;
                this.posX = col * 20 - 20;
                this.posY = row * 20 - PSCanvas.imageHeight[imageId] + 10;
                this.posZ = row * 20;
                this.fillDisplayQueueOffsetX1 = 80;
                this.frameNumber = 2;
                break;
            }
            case 32: {
                this.posX = (col - 1) * 20 + 4;
                this.posZ = this.posY = (row - 1) * 20;
                this.flag = 0;
                break;
            }
        }
        this.frameWidth = PSCanvas.imageWidth[this.imageId] / this.frameNumber;
    }

    public void display(PSGraphics g) {
        if (this.isAlive) {
            int displayX = this.posX + 20 - GameBoard.camX;
            int displayY = this.posY - GameBoard.camY;
            if (this.flag == 3) {
                g.setClip(displayX - this.frameWidth / 2, displayY - PSCanvas.imageHeight[this.imageId] / 2, this.frameWidth, PSCanvas.imageHeight[this.imageId]);
            } else {
                g.setClip(displayX, displayY, this.frameWidth, PSCanvas.imageHeight[this.imageId]);
            }
            if (!this.isExploding) {
                if (this.imageId == 32) {
                    ++this.counter;
                    if (this.counter >= 3) {
                        if (this.counter == 4) {
                            this.counter = 0;
                        }
                        return;
                    }
                }
                g.drawImage(PSCanvas.imageArray[this.imageId], displayX - this.currentFrameNumber * this.frameWidth, displayY, this.flag);
                if (this.imageId == 21) {
                    g.setClip(displayX, displayY, 72, PSCanvas.imageHeight[this.imageId]);
                    g.setColor(0xFF0000);
                    g.fillRect(displayX + 8, displayY + 25, 80, 2);
                    g.fillRect(displayX + 8, displayY + 28, 80, 2);
                    g.setClip(displayX + 60, displayY, this.frameWidth, PSCanvas.imageHeight[this.imageId]);
                    g.drawImage(PSCanvas.imageArray[this.imageId], displayX - (this.currentFrameNumber + 1) * this.frameWidth + 60, displayY, this.flag);
                } else if (this.imageId == 19) {
                    g.setClip(displayX + 7, displayY + 10, this.frameWidth, PSCanvas.imageHeight[this.imageId] + 80);
                    g.setColor(0xFF0000);
                    g.fillRect(displayX + 7, displayY + 10, 2, 80);
                    g.fillRect(displayX + 11, displayY + 10, 2, 80);
                }
            }
            if (this.isExploding) {
                short explosionWidth = GameAI.spriteExplosions.getAnimationWidth(this.explosionSpritePlayer.getAnimIdx());
                short explosionHeight = GameAI.spriteExplosions.getAnimationHeight(this.explosionSpritePlayer.getAnimIdx());
                int explosionX = displayX - explosionWidth / 2;
                int explosionY = displayY - explosionHeight / 2;
                g.setClip(explosionX, explosionY, explosionWidth, explosionHeight);
                this.explosionSpritePlayer.moveTo(explosionX, explosionY);
                this.explosionSpritePlayer.draw(g);
            }
        }
    }

    public void displayShadow(PSGraphics g) {
        if (this.isAlive) {
            if (this.imageId == 32) {
                int displayX = this.posX + 20 - GameBoard.camX;
                int displayY = this.posY - GameBoard.camY + 13;
                g.setClip(displayX, displayY, this.frameWidth, PSCanvas.imageHeight[this.imageId]);
                g.setColor(Constants.LEVELS_SHADOW_COLOR[GameBoard.currentLevel]);
                g.fillArc(displayX, displayY, this.frameWidth, PSCanvas.imageHeight[this.imageId] / 2, 0, 360);
            } else if (this.imageId == 28) {
                int displayX = this.posX - GameBoard.camX + 5;
                int displayY = this.posY - GameBoard.camY + 2;
                g.setClip(displayX, displayY, this.frameWidth + 4, PSCanvas.imageHeight[this.imageId]);
                g.setColor(Constants.LEVELS_SHADOW_COLOR[GameBoard.currentLevel]);
                g.fillRect(displayX, displayY, this.frameWidth + 4, PSCanvas.imageHeight[this.imageId] / 2);
            } else if (this.imageId == 57) {
                int displayX = this.posX - GameBoard.camX + 20 - this.frameWidth / 2;
                int displayY = this.posY - GameBoard.camY;
                g.setClip(displayX, displayY, this.frameWidth, PSCanvas.imageHeight[this.imageId]);
                g.setColor(Constants.LEVELS_SHADOW_COLOR[GameBoard.currentLevel]);
                g.fillArc(displayX, displayY, this.frameWidth, PSCanvas.imageHeight[this.imageId] / 2, 0, 360);
            }
        }
    }

    public void explode() {
        this.isExploding = true;
        if (this.imageId == 57) {
            byte[] byArray = GameBoard.boundMapData[this.tileRow];
            int n = this.tileCol;
            byArray[n] = (byte)(byArray[n] - 16);
        }
        this.isTargetable = false;
        this.canBeTargeted = false;
    }

    public void setCurrentFrameNumber(int frame) {
        this.currentFrameNumber = frame;
    }

    public void update() {
        if (this.explosionSpritePlayer != null) {
            this.explosionSpritePlayer.update();
        }
    }
}

