/*
 * Decompiled with CFR 0.152.
 */
public class Snake
extends GameBoardElement
implements PSSpriteConstants {
    public static final int INITIAL_MAX_SNAKE_TURN_NUMBER = 2;
    public static final int INITIAL_MAX_SNAKE_LIFE_POINTS = 500;
    public static final int INITIAL_MAX_SNAKE_HAND_CARDS = 6;
    public static final int MOVE_ARRAY_CANNOT_REACH_ANYMORE = -1;
    public static final int MOVE_ARRAY_CANNOT_REACH = -2;
    public static final int SHADOW_WIDTH = 10;
    public static final int SHADOW_HEIGHT = 5;
    public static final int CSTATE_NONE = 0;
    public static final int CSTATE_STAND = 1;
    public static final int CSTATE_FLATTENED = 2;
    public static final int CSTATE_CRAWLED = 3;
    public static final int CSTATE_SET_ATTACK = 4;
    public static final int CSTATE_SET_CRAWLING = 5;
    public static final int CSTATE_MOVING = 6;
    public static final int CSTATE_CRAWLING = 7;
    public static final int CSTATE_STANDING_UP = 8;
    public static final int CSTATE_FLATTENING = 9;
    public static final int CSTATE_UNFLATTENING = 10;
    public static final int CSTATE_SHOOTING = 11;
    public static final int CSTATE_HIT = 12;
    public static final int CSTATE_DIEING = 13;
    public static final int CSTATE_KNOCKING = 14;
    public static final int CSTATE_PUNCHING = 15;
    public static final int CSTATE_ATTACK_IS_SET = 16;
    public static final int CSTATE_KNOCKDOWN = 17;
    public static final int CSTATE_KNOCKUP = 18;
    public static final int CSTATE_UNKNOCKING = 19;
    public static final int CSTATE_HIT_CRAWL = 20;
    public static final int CSTATE_THROW_GRENADE = 21;
    public static final int CSEC_KNOCKING = 22;
    public static PSSprite sprite;
    public PSSpritePlayer spritePlayer;
    private int[] a;
    public static final int ANIMATION_SHOOT_UP_REPEAT = 3;
    public static final int ANIMATION_SHOOT_LEFT_REPEAT = 3;
    public static final int ANIMATION_SHOOT_DOWN_REPEAT = 3;
    public static final int ANIMATION_SHOOT_RIGHT_REPEAT = 3;
    public static final int ANIMATION_RUN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_RUN_LEFT_REPEAT = 0;
    public static final int ANIMATION_RUN_UP_REPEAT = 0;
    public static final int ANIMATION_RUN_DOWN_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_LEFT_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_LEFT_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_UP_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_UP_REPEAT = 0;
    public static final int ANIMATION_FLATTEN_DOWN_REPEAT = 0;
    public static final int ANIMATION_UNFLATTEN_DOWN_REPEAT = 0;
    public static final int ANIMATION_CRAWL_UP_REPEAT = 2;
    public static final int ANIMATION_CRAWL_DOWN_REPEAT = 2;
    public static final int ANIMATION_CRAWL_LEFT_REPEAT = 2;
    public static final int ANIMATION_CRAWL_RIGHT_REPEAT = 2;
    public static final int ANIMATION_KNOCK_UP_REPEAT = 2;
    public static final int ANIMATION_KNOCK_DOWN_REPEAT = 2;
    public static final int ANIMATION_KNOCK_LEFT_REPEAT = 2;
    public static final int ANIMATION_KNOCK_RIGHT_REPEAT = 2;
    public static final int ANIMATION_PUNCH_UP_REPEAT = 0;
    public static final int ANIMATION_PUNCH_DOWN_REPEAT = 0;
    public static final int ANIMATION_PUNCH_LEFT_REPEAT = 0;
    public static final int ANIMATION_PUNCH_RIGHT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_UP_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_DOWN_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_LEFT_REPEAT = 0;
    public static final int ANIMATION_KNOCKDOWN_RIGHT_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_UP_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_DOWN_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_LEFT_REPEAT = 0;
    public static final int ANIMATION_BAZOOKA_RIGHT_REPEAT = 0;
    public static final int ANIMATION_GRANADE_UP_REPEAT = 0;
    public static final int ANIMATION_GRANADE_DOWN_REPEAT = 0;
    public static final int ANIMATION_GRANADE_LEFT_REPEAT = 0;
    public static final int ANIMATION_GRANADE_RIGHT_REPEAT = 0;
    private static final int[] b;
    private static final int[] c;
    public boolean isAnimated = false;
    public int speedX = 20;
    public int speedY = 20;
    private int d = this.speedX / 10;
    private int e = this.speedY / 10;
    public int moveNumber = 4;
    public int moveNumberLeft = 4;
    public int moveNumberStanding = 0;
    public int[][][] moveArray;
    public int moveRowToBoundRow = 0;
    public int moveColToBoundCol = 0;
    public int moveRowStart;
    public int moveColStart;
    private int f = 0;
    private int g = 0;
    public int moveInitialRow;
    public int moveInitialCol;
    private int h;
    private int i;
    private int j;
    private int k;
    public int moveInitialState;
    public int facingDirection = 0;
    public boolean blockCancelMove = false;
    private int l;
    private int m;
    private int n;
    private int o;
    private int p = 0;
    private int q = 0;
    public int tileRow;
    public int tileCol;
    public int shadowOffsetX = 0;
    public int shadowOffsetY = 0;
    public int damageToPrint = -1;
    public int damagePrintDuration = 20;
    private boolean r = false;
    private boolean s = false;
    public static int lastState;
    public static int currentState;
    public static int nextState;
    public int lifeNumberLeft = 500;
    public int maxLifeNumber = 500;
    public int actionNumberLeft = 0;
    public int maxActionNumber = 2;
    public int decksCardsNumberLeft = 30;
    public int maxDecksCardsNumber = 30;
    public int cardsHandNumber = 6;
    public int maxEquipmentNumber = 2;
    public int equipmentNumber = 0;
    public int turnEffectCount = 0;
    public int effectCard = -1;
    public int isHit = 0;
    public boolean isHidden = false;
    public int hiddenStartRow = 0;
    public int hiddenStartCol = 0;
    public int[] equipment = new int[this.maxEquipmentNumber];
    public int[] equipmentUses = new int[this.maxEquipmentNumber];
    public int equipIndex = 0;
    public int[] targetList = null;
    public int[] targetObjectList = null;
    public boolean isTargetingObject = false;
    public int currentTarget = -1;
    public boolean hasFinishedAttack = false;
    public boolean hasPunched = false;
    public boolean canPunch = false;
    public boolean hasKnocked = false;
    public boolean isCharacterVenus = false;
    public boolean hitByTrain = false;
    public Deck deck;
    public boolean nextCardCost0 = false;

    public Snake() {
    }

    public Snake(int n, int n2, int n3, int n4, int n5) {
        this.tileCol = n2;
        this.tileRow = n;
        this.posX = n2 * 10;
        this.posY = n * 10;
        this.posZ = n3 * 10;
        this.q = n2 * 10 << 8;
        this.p = n * 10 << 8;
        this.facingDirection = n4;
        lastState = 0;
        currentState = 1;
        nextState = 1;
        this.currentCost = 0;
        boolean bl = this.isCharacterVenus = n5 == 1;
        if (n5 == 1) {
            sprite = GameAI.spriteVenus;
            this.a = c;
        } else {
            this.a = b;
        }
        if (this.spritePlayer == null) {
            this.spritePlayer = new PSSpritePlayer(sprite);
        }
        this.updateDisplayPositions();
        this.deck = PSCanvas.gameDeck;
        for (int i = 0; i < this.equipment.length; ++i) {
            this.equipment[i] = -1;
        }
    }

    public void display(PSGraphics pSGraphics) {
        pSGraphics.setClip(this.n, this.o, sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()), sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()));
        if (this.isHit > 0) {
            if (this.isHit % 4 != 0 && this.isHit % 4 != 3) {
                if (this.getEquipment(11) != -1) {
                    pSGraphics.drawImage(PSCanvas.imageArray[35], this.posX - GameBoard.camX + 10 - PSCanvas.imageWidth[35] / 2, this.posY - GameBoard.camY - 10);
                } else {
                    this.spritePlayer.moveTo(this.l, this.m);
                    this.spritePlayer.draw(pSGraphics);
                }
            }
            --this.isHit;
            return;
        }
        if (this.getEquipment(11) != -1) {
            pSGraphics.drawImage(PSCanvas.imageArray[35], this.posX - GameBoard.camX + 10 - PSCanvas.imageWidth[35] / 2, this.posY - GameBoard.camY - 10);
            return;
        }
        this.spritePlayer.moveTo(this.l, this.m);
        this.spritePlayer.draw(pSGraphics);
    }

    public void displayShadow(PSGraphics pSGraphics) {
        if (this.lifeNumberLeft > 0) {
            pSGraphics.setClip(this.n, this.o, sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()), sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()));
            pSGraphics.setColor(Constants.LEVELS_SHADOW_COLOR[GameBoard.currentLevel]);
            if (this.getEquipment(11) != -1) {
                pSGraphics.fillArc(this.posX + 10 - 7 - GameBoard.camX, this.posY - GameBoard.camY - 2, 15, 7, 0, 360);
                return;
            }
            if (currentState != 3 && currentState != 7 && nextState != 2 && nextState != 14 && (currentState != 12 || lastState != 3)) {
                pSGraphics.fillArc(this.posX + 10 - 5 - GameBoard.camX + this.shadowOffsetX, this.posY - GameBoard.camY - 2, 10, 5, 0, 360);
            }
        }
    }

    public void updateAnim() {
        if (this.isAnimated) {
            this.spritePlayer.update();
            if (this.spritePlayer.getDurationFrame() == 0 && this.spritePlayer.isPlaying()) {
                this.updateMovePos();
                this.updateDisplayPositions();
            }
            if (!this.spritePlayer.isPlaying()) {
                this.isAnimated = false;
                this.shadowOffsetX = 0;
                this.shadowOffsetY = 0;
            }
        }
    }

    public void update(int n) {
        if (nextState != currentState) {
            if (!this.r) {
                this.b(currentState);
            }
            if (!this.s) {
                this.a(nextState);
            }
            if (!this.r && !this.s) {
                lastState = currentState;
                currentState = nextState;
            }
        }
        if (nextState == currentState) {
            switch (currentState) {
                case 1: 
                case 2: 
                case 3: {
                    this.setDirection(this.facingDirection);
                    if (!this.move(n)) break;
                    this.updateMoveGrid();
                    GameBoard.checkAiSeeingSnake();
                    GameBoard.checkSnakeSeeingAI(10);
                    return;
                }
                case 6: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (!GameBoard.isScriptActive && !this.move(n)) {
                        if (nextState == 9) break;
                        nextState = 1;
                        return;
                    }
                    this.updateMoveGrid();
                    GameBoard.checkAiSeeingSnake();
                    GameBoard.checkSnakeSeeingAI(10);
                    return;
                }
                case 7: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (!this.move(n)) {
                        nextState = 3;
                        return;
                    }
                    this.updateMoveGrid();
                    GameBoard.checkAiSeeingSnake();
                    GameBoard.checkSnakeSeeingAI(10);
                    return;
                }
                case 9: 
                case 14: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (currentState == 15) {
                        this.hasKnocked = true;
                    }
                    nextState = 2;
                    return;
                }
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    if (currentState == 15) {
                        this.hasPunched = true;
                    }
                    nextState = 1;
                    return;
                }
                case 12: {
                    this.updateAnim();
                    if (this.isAnimated) break;
                    nextState = lastState;
                    return;
                }
                case 13: {
                    if (!this.isAnimated) break;
                    this.updateAnim();
                    return;
                }
                case 4: {
                    this.setDirection(this.facingDirection);
                }
            }
        }
    }

    private void a(int n) {
        this.r = true;
        this.r = false;
    }

    private void b(int n) {
        this.s = true;
        this.s = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initTurn() {
        if (GameBoard.instance.a == 2) {
            GameBoard.instance.a();
        }
        this.hasPunched = false;
        this.hasKnocked = false;
        if (this.effectCard != -1) {
            if (CardSet.CARD_LIST[this.effectCard].getCardSubType() == 7) {
                this.actionNumberLeft = this.maxActionNumber;
                --this.turnEffectCount;
                if (this.turnEffectCount != 0) return;
                this.effectCard = -1;
                return;
            }
            this.actionNumberLeft = 2;
            this.maxActionNumber = 2;
            return;
        }
        this.actionNumberLeft = 2;
        this.maxActionNumber = 2;
    }

    public void updateMovePos() {
        this.f = 0;
        this.g = 0;
        switch (nextState) {
            case 7: {
                this.f = 5120 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 3);
                this.g = 5120 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 3);
                break;
            }
            case 6: {
                this.f = 5120 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1);
                this.g = 5120 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1);
                break;
            }
            case 17: {
                this.f = -(5120 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1));
                this.g = -(5120 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1));
                break;
            }
            case 9: {
                if (this.spritePlayer.getFrameIdx() > 0) {
                    if (GameBoard.tileLayer1[this.tileRow][this.tileCol] != -1 && this.facingDirection == 8 || GameBoard.tileLayer1[this.tileRow][this.tileCol + 1] != -1 && this.facingDirection == 2) {
                        this.f = -(1536 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                        this.g = -(1536 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                    } else {
                        this.f = -(2048 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                        this.g = -(2048 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1));
                    }
                }
                if (this.spritePlayer.isCurrentFrameLast()) {
                    this.shadowOffsetX = -128;
                    this.shadowOffsetY = -160;
                    break;
                }
                this.shadowOffsetX = 0;
                this.shadowOffsetY = 0;
                break;
            }
            case 10: {
                if (this.spritePlayer.getFrameIdx() > 0) {
                    if (GameBoard.tileLayer1[this.tileRow][this.tileCol] != -1 && this.facingDirection == 8 || GameBoard.tileLayer1[this.tileRow][this.tileCol + 1] != -1 && this.facingDirection == 2) {
                        this.f = 1536 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                        this.g = 1536 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                    } else {
                        this.f = 2048 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                        this.g = 2048 / (sprite.getAnimationFramesNumber(this.spritePlayer.getAnimIdx()) * 1 - 1);
                    }
                }
                if (this.spritePlayer.isCurrentFrameFirst()) {
                    this.shadowOffsetX = -128;
                    this.shadowOffsetY = -160;
                    break;
                }
                this.shadowOffsetX = 0;
                this.shadowOffsetY = 0;
            }
        }
        switch (this.facingDirection) {
            case 1: {
                this.p -= this.g;
                this.posY = this.p >> 8;
                break;
            }
            case 4: {
                if (currentState == 6) {
                    this.shadowOffsetY = -2;
                }
                this.p += this.g;
                this.posY = this.p >> 8;
                break;
            }
            case 8: {
                this.q += this.f;
                this.posX = this.q >> 8;
                break;
            }
            case 2: {
                this.q -= this.f;
                this.posX = this.q >> 8;
            }
        }
        if (nextState == 7 || nextState == 3) {
            this.posZ = -10000;
            return;
        }
        this.posZ = this.posY;
    }

    public boolean move(int n) {
        switch (n) {
            case 1: {
                if (currentState == 2) {
                    if (this.facingDirection == 1) {
                        nextState = 10;
                        this.setReversedAnimation(30, 0);
                    }
                    return false;
                }
                if (this.tileRow - 1 >= 0 && (GameBoard.boundMapData[this.tileRow - 1][this.tileCol] & 1) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileRow - this.e >= 0 && (GameBoard.tileLayerZ[this.tileRow - this.e][this.tileCol] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.p = this.tileRow * 10 << 8;
                        this.setAnimation(32, 0);
                        this.facingDirection = 4;
                    }
                    if (currentState != 3 || this.tileRow - this.e < 0 || (GameBoard.tileLayerZ[this.tileRow - this.e][this.tileCol] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileRow - this.e >= 0 && (GameBoard.boundMapData[this.tileRow - this.e][this.tileCol] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.p = this.tileRow * 10 << 8;
                this.tileRow -= this.e;
                if (this.facingDirection != 1) {
                    this.setDirection(1);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(34, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetY = -2;
                    this.setAnimation(6, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
            case 4: {
                if (currentState == 2) {
                    if (this.facingDirection == 4) {
                        nextState = 10;
                        this.setReversedAnimation(32, 0);
                    }
                    return false;
                }
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 4) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileRow + 1 < GameBoard.mapHeight && (GameBoard.tileLayerZ[this.tileRow + 1][this.tileCol] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.p = this.tileRow * 10 << 8;
                        this.setAnimation(30, 0);
                        this.facingDirection = 1;
                    }
                    if (currentState != 3 || this.tileRow + this.e >= GameBoard.mapHeight || (GameBoard.tileLayerZ[this.tileRow + this.e][this.tileCol] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileRow + this.e < GameBoard.mapHeight && (GameBoard.boundMapData[this.tileRow + this.e][this.tileCol] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.p = this.tileRow * 10 << 8;
                this.tileRow += this.e;
                if (this.facingDirection != 4) {
                    this.setDirection(4);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(36, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetY = 0;
                    this.setAnimation(8, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
            case 8: {
                if (currentState == 2) {
                    if (this.facingDirection == 8) {
                        nextState = 10;
                        this.setReversedAnimation(33, 0);
                    }
                    return false;
                }
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol + 1] & 8) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileCol + this.d < GameBoard.mapWidth && (GameBoard.tileLayerZ[this.tileRow][this.tileCol + this.d] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.q = this.tileCol * 10 << 8;
                        this.setAnimation(31, 0);
                        this.facingDirection = 2;
                    }
                    if (currentState != 3 || this.tileCol + this.d >= GameBoard.mapWidth || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + this.d] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileCol + this.d < GameBoard.mapWidth && (GameBoard.boundMapData[this.tileRow][this.tileCol + this.d] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.q = this.tileCol * 10 << 8;
                this.tileCol += this.d;
                if (this.facingDirection != 8) {
                    this.setDirection(8);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(37, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetX = 2;
                    this.setAnimation(9, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
            case 2: {
                if (currentState == 2) {
                    if (this.facingDirection == 2) {
                        nextState = 10;
                        this.setReversedAnimation(31, 0);
                    }
                    return false;
                }
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 2) != 0) {
                    if (currentState != 3 && currentState != 7 && this.tileCol - 1 >= 0 && (GameBoard.tileLayerZ[this.tileRow][this.tileCol - 1] & 0xF) != 15 && this.getEquipment(11) == -1) {
                        nextState = 9;
                        this.q = this.tileCol * 10 << 8;
                        this.setAnimation(33, 0);
                        this.facingDirection = 8;
                    }
                    if (currentState != 3 || this.tileCol - this.d < 0 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol - this.d] & 0x10) != 16) {
                        return false;
                    }
                }
                if (this.tileCol - this.d >= 0 && (GameBoard.boundMapData[this.tileRow][this.tileCol - this.d] & 0x10) != 0) {
                    return false;
                }
                if (this.moveNumberLeft <= 0) {
                    this.setDirection(this.facingDirection);
                    return false;
                }
                this.q = this.tileCol * 10 << 8;
                this.tileCol -= this.d;
                if (this.facingDirection != 2) {
                    this.setDirection(2);
                }
                if (currentState == 3 || currentState == 7) {
                    nextState = 7;
                    this.setAnimation(35, 2);
                } else {
                    nextState = 6;
                    this.shadowOffsetX = -2;
                    this.setAnimation(7, 0);
                }
                --this.moveNumberLeft;
                if (currentState == 3 || currentState == 7) {
                    --this.moveNumberStanding;
                }
                return true;
            }
        }
        return false;
    }

    public void cancelMove() {
        this.moveNumberLeft = this.moveNumber;
        this.tileRow = this.moveInitialRow;
        this.tileCol = this.moveInitialCol;
        this.posX = this.h;
        this.posY = this.i;
        this.posZ = this.j;
        nextState = this.moveInitialState;
        this.p = this.posY << 8;
        this.q = this.posX << 8;
        this.setDirection(this.k);
        this.updateDisplayPositions();
        if (nextState == 3) {
            this.moveNumberStanding = this.moveNumberLeft;
            this.moveNumberLeft -= 2;
        }
        this.updateMoveGrid();
    }

    public void setDirection(int n) {
        switch (n) {
            case 1: {
                this.facingDirection = 1;
                break;
            }
            case 2: {
                this.facingDirection = 2;
                break;
            }
            case 4: {
                this.facingDirection = 4;
                break;
            }
            case 8: {
                this.facingDirection = 8;
            }
        }
        block6 : switch (currentState) {
            case 2: {
                switch (this.facingDirection) {
                    case 1: {
                        this.spritePlayer.play(this.a[58], true);
                        break block6;
                    }
                    case 2: {
                        this.spritePlayer.play(this.a[59], true);
                        break block6;
                    }
                    case 4: {
                        this.spritePlayer.play(this.a[60], true);
                        break block6;
                    }
                    case 8: {
                        this.spritePlayer.play(this.a[61], true);
                        break block6;
                    }
                }
                break;
            }
            case 3: {
                switch (this.facingDirection) {
                    case 1: {
                        this.spritePlayer.play(this.a[62], true);
                        break block6;
                    }
                    case 2: {
                        this.spritePlayer.play(this.a[63], true);
                        break block6;
                    }
                    case 4: {
                        this.spritePlayer.play(this.a[64], true);
                        break block6;
                    }
                    case 8: {
                        this.spritePlayer.play(this.a[65], true);
                        break block6;
                    }
                }
                break;
            }
            case 1: 
            case 6: {
                switch (this.facingDirection) {
                    case 1: {
                        this.spritePlayer.play(this.a[10], true);
                        break block6;
                    }
                    case 2: {
                        this.spritePlayer.play(this.a[11], true);
                        break block6;
                    }
                    case 4: {
                        this.spritePlayer.play(this.a[12], true);
                        break block6;
                    }
                    case 8: {
                        this.spritePlayer.play(this.a[13], true);
                        break block6;
                    }
                }
                break;
            }
            case 4: {
                int n2 = CardSet.CARD_LIST[this.deck.getSelectedCard()].getCardSubType();
                switch (this.facingDirection) {
                    case 1: {
                        switch (n2) {
                            case 23: {
                                this.spritePlayer.play(this.a[66], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.a[70], true);
                        break block6;
                    }
                    case 2: {
                        switch (n2) {
                            case 23: {
                                this.spritePlayer.play(this.a[67], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.a[71], true);
                        break block6;
                    }
                    case 4: {
                        switch (n2) {
                            case 23: {
                                this.spritePlayer.play(this.a[68], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.a[72], true);
                        break block6;
                    }
                    case 8: {
                        switch (n2) {
                            case 23: {
                                this.spritePlayer.play(this.a[69], true);
                                break block6;
                            }
                        }
                        this.spritePlayer.play(this.a[73], true);
                    }
                }
            }
        }
        this.shadowOffsetX = 0;
        this.shadowOffsetY = 0;
        this.updateDisplayPositions();
    }

    public void setCrawl() {
        if (currentState == 1) {
            this.moveNumberStanding = this.moveNumberLeft;
            this.moveNumberLeft -= 2;
            if (this.moveNumberLeft < 0) {
                this.moveNumberLeft = 0;
            }
            nextState = 3;
            this.updateMoveGrid();
            this.posZ = -10000;
        }
    }

    public void setStandUp() {
        if (currentState == 3) {
            this.moveNumberLeft = this.moveNumberStanding;
            nextState = 1;
            this.updateMoveGrid();
            this.posZ = this.posY;
        }
    }

    public void setAttack() {
        try {
            if (this.getEquipment(11) != -1) {
                this.removeEquipment(this.getEquipment(11));
            }
        }
        catch (Exception exception) {
            System.out.println("SET ATACK ERROR");
            exception.printStackTrace();
        }
        nextState = 4;
    }

    public void unsetAttack() {
        nextState = 1;
    }

    public void knock() {
        nextState = 14;
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(38, 2);
                return;
            }
            case 2: {
                this.setAnimation(39, 2);
                return;
            }
            case 4: {
                this.setAnimation(40, 2);
                return;
            }
            case 8: {
                this.setAnimation(41, 2);
            }
        }
    }

    public void punch(int n) {
        if (this.getEquipment(11) != -1) {
            this.removeEquipment(this.getEquipment(11));
        }
        nextState = 15;
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(42, 0);
                break;
            }
            case 2: {
                this.setAnimation(43, 0);
                break;
            }
            case 4: {
                this.setAnimation(44, 0);
                break;
            }
            case 8: {
                this.setAnimation(45, 0);
            }
        }
        this.blockCancelMove = true;
        this.currentTarget = n;
        this.updateMoveGrid();
    }

    public void attack(int n) {
        int n2 = CardSet.CARD_LIST[this.deck.getSelectedCard()].getCardSubType();
        nextState = 11;
        block0 : switch (n) {
            case 9: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(27, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(55, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(46, 0);
                        break block0;
                    }
                }
                this.setAnimation(19, 3);
                break;
            }
            case 3: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(26, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(54, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(46, 0);
                        break block0;
                    }
                }
                this.setAnimation(18, 3);
                break;
            }
            case 6: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(28, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(56, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(48, 0);
                        break block0;
                    }
                }
                this.setAnimation(20, 3);
                break;
            }
            case 12: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(29, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(57, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(48, 0);
                        break block0;
                    }
                }
                this.setAnimation(21, 3);
                break;
            }
            case 1: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(22, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(50, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(46, 0);
                        break block0;
                    }
                }
                this.setAnimation(0, 3);
                break;
            }
            case 2: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(23, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(51, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(47, 0);
                        break block0;
                    }
                }
                this.setAnimation(1, 3);
                break;
            }
            case 4: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(24, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(52, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(48, 0);
                        break block0;
                    }
                }
                this.setAnimation(2, 3);
                break;
            }
            case 8: {
                switch (n2) {
                    case 27: {
                        this.setAnimation(25, 0);
                        break block0;
                    }
                    case 23: {
                        this.setAnimation(53, 3);
                        break block0;
                    }
                    case 26: {
                        this.setAnimation(49, 0);
                        break block0;
                    }
                }
                this.setAnimation(3, 3);
            }
        }
        this.hasFinishedAttack = true;
    }

    public void isHit() {
        this.isHit = 18;
    }

    public void knockdown(int n) {
        this.p = this.tileRow * 10 << 8;
        this.q = this.tileCol * 10 << 8;
        this.spritePlayer.stop();
        switch (n) {
            case 1: {
                if ((this.tileRow - 1 < 0 || (GameBoard.boundMapData[this.tileRow - 1][this.tileCol] & 1) != 0) && (this.tileRow - 2 < 0 || (GameBoard.tileLayerZ[this.tileRow - 2][this.tileCol] & 0xF) != 15) || this.tileRow - 2 < 0 || (GameBoard.boundMapData[this.tileRow - 2][this.tileCol] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 4;
                this.setAnimation(16, 0);
                this.tileRow -= 2;
                break;
            }
            case 2: {
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 2) != 0 && (this.tileCol - 1 < 0 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol - 1] & 0xF) != 15) || this.tileCol - 2 < 0 || (GameBoard.boundMapData[this.tileRow][this.tileCol - 2] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 8;
                this.setAnimation(17, 0);
                this.tileCol -= 2;
                break;
            }
            case 4: {
                if ((GameBoard.boundMapData[this.tileRow][this.tileCol] & 4) != 0 && (this.tileRow + 1 >= GameBoard.mapHeight || (GameBoard.tileLayerZ[this.tileRow + 1][this.tileCol] & 0xF) != 15) || this.tileRow + 2 >= GameBoard.mapHeight || (GameBoard.boundMapData[this.tileRow + 2][this.tileCol] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 1;
                this.setAnimation(14, 0);
                this.tileRow += 2;
                break;
            }
            case 8: {
                if ((this.tileCol + 1 < 0 || (GameBoard.boundMapData[this.tileRow][this.tileCol + 1] & 8) != 0) && (this.tileCol + 2 >= GameBoard.mapHeight || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + 2] & 0xF) != 15) || this.tileCol + 2 >= GameBoard.mapHeight || (GameBoard.boundMapData[this.tileRow][this.tileCol + 2] & 0x10) != 0) break;
                nextState = 17;
                this.facingDirection = 2;
                this.setAnimation(15, 0);
                this.tileCol += 2;
            }
        }
        if ((GameBoard.tileLayerZ[this.tileRow][this.tileCol] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow - 1][this.tileCol] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow][this.tileCol + 1] & 0xF) == 15 || (GameBoard.tileLayerZ[this.tileRow - 1][this.tileCol + 1] & 0xF) == 15) {
            this.lifeNumberLeft = 0;
            return;
        }
        this.isHit();
    }

    public void die() {
        nextState = 13;
        this.p = this.tileRow * 10 << 8;
        this.q = this.tileCol * 10 << 8;
        switch (this.facingDirection) {
            case 1: {
                this.setAnimation(15, 0);
                return;
            }
            case 2: {
                this.setAnimation(15, 0);
                return;
            }
            case 4: {
                this.setAnimation(17, 0);
                return;
            }
            case 8: {
                this.setAnimation(17, 0);
            }
        }
    }

    public void updateDisplayPositions() {
        this.n = this.posX - GameBoard.camX - (sprite.getAnimationWidth(this.spritePlayer.getAnimIdx()) >> 2);
        this.o = this.posY - GameBoard.camY - sprite.getAnimationHeight(this.spritePlayer.getAnimIdx()) / 5 * 3;
        this.l = this.n;
        this.m = this.o;
    }

    public void computeMoveGrid() {
        int n = (this.moveNumber << 1) + 1 >> 1;
        this.moveRowStart = this.tileRow;
        this.moveColStart = this.tileCol;
        int n2 = (this.moveNumber << 1) + 1 >> 1;
        this.moveRowToBoundRow = this.tileRow - ((n << 1) + 1);
        this.moveColToBoundCol = this.tileCol - (n2 << 1);
        this.moveArray = new int[(this.moveNumber << 1) + 1][(this.moveNumber << 1) + 1][1];
        for (int i = 0; i < this.moveArray.length; ++i) {
            for (int j = 0; j < this.moveArray[i].length; ++j) {
                this.moveArray[i][j][0] = -2;
            }
        }
        this.initRecursiveComputeMove(n, n2, this.moveNumber, this.moveNumber - 2);
        this.updateMoveGrid();
    }

    public void initRecursiveComputeMove(int n, int n2, int n3, int n4) {
        int n5 = (n << 1) + 1 + this.moveRowToBoundRow;
        int n6 = (n2 << 1) + this.moveColToBoundCol;
        if (n3 > -1 && n >= 0 && n2 >= 0 && n5 < GameBoard.mapHeight && n6 < GameBoard.mapWidth && n2 <= this.moveArray.length && n <= this.moveArray.length && (GameBoard.boundMapData[n5][n6] & 0x10) == 0) {
            if (n3 < this.moveArray[n][n2][0]) {
                return;
            }
            this.moveArray[n][n2][0] = n3;
            if (n5 - 1 > 0 && (GameBoard.boundMapData[n5 - 1][n6] & 1) == 0 || n4 > 0 && n5 - 2 > 0 && (GameBoard.tileLayerZ[n5 - 2][n6] & 0x10) != 0) {
                this.initRecursiveComputeMove(n - 1, n2, n3 - 1, n4 - 1);
            }
            if ((GameBoard.boundMapData[n5][n6] & 4) == 0 || n4 > 0 && n5 + 2 < GameBoard.mapHeight && (GameBoard.tileLayerZ[n5 + 2][n6] & 0x10) != 0) {
                this.initRecursiveComputeMove(n + 1, n2, n3 - 1, n4 - 1);
            }
            if ((GameBoard.boundMapData[n5][n6] & 2) == 0 || n4 > 0 && n6 - 2 > 0 && (GameBoard.tileLayerZ[n5][n6 - 2] & 0x10) != 0) {
                this.initRecursiveComputeMove(n, n2 - 1, n3 - 1, n4 - 1);
            }
            if (n6 + 1 < GameBoard.mapWidth && (GameBoard.boundMapData[n5][n6 + 1] & 8) == 0 || n4 > 0 && n6 + 2 < GameBoard.mapWidth && (GameBoard.tileLayerZ[n5][n6 + 2] & 0x10) != 0) {
                this.initRecursiveComputeMove(n, n2 + 1, n3 - 1, n4 - 1);
            }
        }
    }

    public void recursiveComputeMove(int n, int n2, int n3) {
        int n4 = (n << 1) + 1 + this.moveRowToBoundRow;
        int n5 = (n2 << 1) + this.moveColToBoundCol;
        if (n3 > -1 && n >= 0 && n2 >= 0 && n4 < GameBoard.mapHeight && n5 < GameBoard.mapWidth && n2 <= this.moveArray.length && n <= this.moveArray.length && (GameBoard.boundMapData[n4][n5] & 0x10) == 0) {
            if (n3 < this.moveArray[n][n2][0]) {
                return;
            }
            this.moveArray[n][n2][0] = n3;
            if (n4 - 1 > 0 && (GameBoard.boundMapData[n4 - 1][n5] & 1) == 0 || (nextState == 3 || nextState == 7) && n4 - 2 > 0 && (GameBoard.tileLayerZ[n4 - 2][n5] & 0x10) != 0) {
                this.recursiveComputeMove(n - 1, n2, n3 - 1);
            }
            if ((GameBoard.boundMapData[n4][n5] & 4) == 0 || (nextState == 3 || nextState == 7) && n4 + 2 < GameBoard.mapHeight && (GameBoard.tileLayerZ[n4 + 2][n5] & 0x10) != 0) {
                this.recursiveComputeMove(n + 1, n2, n3 - 1);
            }
            if ((GameBoard.boundMapData[n4][n5] & 2) == 0 || (nextState == 3 || nextState == 7) && n5 - 2 > 0 && (GameBoard.tileLayerZ[n4][n5 - 2] & 0x10) != 0) {
                this.recursiveComputeMove(n, n2 - 1, n3 - 1);
            }
            if (n5 + 1 < GameBoard.mapWidth && (GameBoard.boundMapData[n4][n5 + 1] & 8) == 0 || (nextState == 3 || nextState == 7) && n5 + 2 < GameBoard.mapWidth && (GameBoard.tileLayerZ[n4][n5 + 2] & 0x10) != 0) {
                this.recursiveComputeMove(n, n2 + 1, n3 - 1);
            }
        }
    }

    public void updateMoveGrid() {
        int n = this.moveRowStart - (this.moveRowStart - this.tileRow) - this.moveRowToBoundRow >> 1;
        int n2 = this.moveColStart - (this.moveColStart - this.tileCol) - this.moveColToBoundCol >> 1;
        for (int i = 0; i < this.moveArray.length; ++i) {
            for (int j = 0; j < this.moveArray[i].length; ++j) {
                if (this.moveArray[i][j][0] < 0) continue;
                this.moveArray[i][j][0] = -1;
            }
        }
        this.recursiveComputeMove(n, n2, this.moveNumberLeft);
    }

    public void setHidden(int n, int n2) {
        this.isHidden = true;
        this.hiddenStartRow = n;
        this.hiddenStartCol = n2;
    }

    public void setMove(int n) {
        this.p = this.posY << 8;
        this.q = this.posX << 8;
        this.moveNumber = n;
        this.moveNumberLeft = n;
        this.moveInitialRow = this.tileRow;
        this.moveInitialCol = this.tileCol;
        this.h = this.posX;
        this.i = this.posY;
        this.j = this.posZ;
        this.k = this.facingDirection;
        this.moveInitialState = currentState;
        this.blockCancelMove = false;
        this.computeMoveGrid();
        if (this.moveInitialState == 3) {
            this.moveNumberStanding = this.moveNumberLeft;
            this.moveNumberLeft -= 2;
            this.updateMoveGrid();
        }
    }

    public void setDamage(int n, int n2) {
        int n3;
        int n4;
        if (this.getEquipment(11) != -1) {
            this.removeEquipment(this.getEquipment(11));
        }
        if ((n4 = (n3 = this.getEquipment(6)) != -1 ? this.equipment[n3] : -1) != -1) {
            if (PSCanvas.getRandom(0, 100) <= CardSet.CARD_LIST[n4].getCardReactionChance()) {
                if ((n -= CardSet.CARD_LIST[n4].getCardAttackDamage()) <= 0) {
                    n = 0;
                }
                this.removeEquipment(n3);
            }
        } else {
            n3 = this.getEquipment(15);
            n4 = n3 != -1 ? this.equipment[n3] : -1;
            if (n4 != -1 && PSCanvas.getRandom(0, 100) <= CardSet.CARD_LIST[n4].getCardReactionChance()) {
                this.removeEquipment(n3);
                return;
            }
        }
        if (n2 == -1) {
            this.damageToPrint = -n;
        } else {
            this.damageToPrint = n;
            this.isHit();
        }
        this.damagePrintDuration = 0;
        this.lifeNumberLeft -= this.damageToPrint;
    }

    public void setAnimation(int n, int n2) {
        if (n >= this.a.length || this.a[n] == -1) {
            return;
        }
        this.isAnimated = true;
        this.spritePlayer.play(this.a[n], n2);
        this.updateMovePos();
        this.updateDisplayPositions();
    }

    public void setReversedAnimation(int n, int n2) {
        if (n >= this.a.length || this.a[n] == -1) {
            return;
        }
        this.isAnimated = true;
        this.spritePlayer.reversePlay(this.a[n], n2);
        this.updateMovePos();
        this.updateDisplayPositions();
    }

    public int getEquipment(int n) {
        for (int i = 0; i < this.equipment.length; ++i) {
            if (this.equipment[i] == -1 || n != CardSet.CARD_LIST[this.equipment[i]].getCardSubType()) continue;
            return i;
        }
        return -1;
    }

    public void removeEquipment(int n) {
        this.equipment[n] = -1;
    }

    public void addCost(int n) {
        if (this.nextCardCost0) {
            this.nextCardCost0 = false;
            return;
        }
        this.currentCost += n;
    }

    static {
        b = new int[]{6, 7, 9, 8, 19, 20, 10, 1, 21, 0, 28, 29, 31, 30, 67, 19, 66, 20, 24, 25, 22, 23, 36, 37, 39, 38, 41, 43, 40, 42, 17, 13, 11, 15, 5, 3, 2, 4, 18, 14, 12, 16, 75, 74, 72, 73, 68, 69, 71, 70, 48, 49, 50, 53, 52, 55, 51, 54, 65, 63, 62, 64, 35, 33, 32, 34, 85, 86, 87, 90, 77, 78, 80, 79};
        c = new int[]{29, 28, 30, 31, 53, 52, 6, 1, 7, 0, 9, 8, 10, 11, 53, 53, 52, 52, 32, 34, 33, 35, 45, 44, 46, 47, 48, 51, 49, 50, 13, 12, 14, 15, 5, 3, 2, 4, 18, 16, 19, 17, 20, 21, 22, 23, 24, 25, 26, 27, 37, 36, 38, 39, 40, 42, 41, 43, 82, 81, 83, 84, 80, 78, 77, 79, 62, 61, 63, 64, 54, 85, 55, 56};
        lastState = 0;
        currentState = 1;
        nextState = 1;
    }
}

