/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage {
    public static final boolean USE_CLIPPING = true;
    public static final byte FLIP_HORIZONTAL = 1;
    public static final byte FLIP_VERTICAL = 2;
    public static final byte ROTATE_90 = 4;
    public static final byte ROTATE_180 = 8;
    public static final byte ROTATE_270 = 16;
    private int manipulation = 0;
    public Image tileImage;
    public int tileX;
    public int tileY;
    public int width;
    public int height;
    private int[] pixels;
    public int[] scaled;
    public int scaled_width;
    public int scaled_height;
    private int old_scaled_width;
    private int old_scaled_height;
    public static final int MAX_SCALE = 200;

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.tileImage = deviceImage.tileImage;
        this.width = n3;
        this.height = n4;
        this.tileX = n;
        this.tileY = n2;
    }

    public DeviceImage(Image image) {
        this.tileImage = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public DeviceImage(byte[] byArray) {
        this.createImage(byArray);
    }

    private void createImage(byte[] byArray) {
        try {
            this.tileImage = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.tileImage.getWidth();
            this.height = (short)this.tileImage.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.tileImage = deviceImage.tileImage;
        this.tileX = deviceImage.tileX;
        this.tileY = deviceImage.tileY;
        this.width = deviceImage.width;
        this.height = deviceImage.height;
        this.manipulation = n;
        if (n >= 4) {
            this.width = deviceImage.height;
            this.height = deviceImage.width;
        } else {
            this.width = deviceImage.width;
            this.height = deviceImage.height;
        }
    }

    public DeviceImage(String string) throws Exception {
        byte[] byArray = null;
        byArray = Engine.ResourceMaster_getResource(string);
        try {
            this.tileImage = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.width = this.tileImage.getWidth();
        this.height = this.tileImage.getHeight();
        byArray = null;
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        if (this.manipulation != 0) {
            this.drawImage(graphics, n, n2, 20);
        } else {
            int n3 = graphics.getClipX();
            int n4 = graphics.getClipY();
            int n5 = graphics.getClipWidth();
            int n6 = graphics.getClipHeight();
            graphics.clipRect(n, n2, this.width, this.height);
            graphics.drawImage(this.tileImage, n - this.tileX, n2 - this.tileY, 20);
            graphics.setClip(n3, n4, n5, n6);
        }
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        if (this.manipulation != 0) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            if (this.manipulation >= 4) {
                graphics.drawRegion(this.tileImage, n4, n5, this.height, this.width, this.manipulation, n, n2, n3);
            } else {
                graphics.drawRegion(this.tileImage, n4, n5, this.width, this.height, this.manipulation, n, n2, n3);
            }
        } else {
            graphics.clipRect(n, n2, this.width, this.height);
            graphics.drawImage(this.tileImage, n - this.tileX, n2 - this.tileY, n3);
            graphics.setClip(0, 0, 128, 160);
        }
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.tileImage, n - this.tileX, n2 - this.tileY, 20);
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        int n3 = this.height;
        return this.divide(n2, n3);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }

    public DeviceImage(byte[] byArray, boolean bl) {
        try {
            this.tileImage = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.tileImage.getWidth();
            this.height = (short)this.tileImage.getHeight();
            if (bl) {
                this.pixels = new int[this.width * this.height];
                this.scaled = new int[this.width * 200 / 100 * (this.height * 200 / 100)];
                this.tileImage.getRGB(this.pixels, 0, this.width, 0, 0, this.width, this.height);
                this.old_scaled_height = -1;
                this.old_scaled_width = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawImageScaled(Graphics graphics, int n, int n2) {
        graphics.drawRGB(this.scaled, 0, this.scaled_width, n, n2, this.scaled_width, this.scaled_height, true);
    }

    public void drawImageScaled(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.scaled_width / n4;
        graphics.drawRGB(this.scaled, n5 * n3, this.scaled_width, n, n2, n5, this.scaled_height, true);
    }

    public void resize(int n, int n2) {
        this.scaled_width = n;
        this.scaled_height = n2;
        this.scale(this.pixels, this.width, this.height, this.scaled, this.scaled_width, this.scaled_height, this.scaled_width, this.scaled_height, 0, 0);
    }

    public void resize(int n) {
        if (n > 200) {
            n = 200;
        }
        this.scaled_width = this.width * n / 100;
        this.scaled_height = this.height * n / 100;
        if (this.old_scaled_width == this.scaled_width && this.old_scaled_height == this.scaled_height) {
            return;
        }
        this.old_scaled_width = this.scaled_width;
        this.old_scaled_height = this.scaled_height;
        this.resize(this.scaled_width, this.scaled_height);
    }

    private void scale(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 1;
        boolean bl = true;
        int n10 = 0;
        int n11 = 0;
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n12 = Math.abs(n3);
        int n13 = Math.abs(n4);
        int n14 = (n << 16) / n12;
        int n15 = (n2 << 16) / n13;
        if (n3 > 0 && n4 > 0) {
            n11 = n5 - n12;
        } else if (n3 > 0 && n4 < 0) {
            n11 = -n5 - n12;
        } else if (n3 < 0 && n4 > 0) {
            n11 = n5 + n12;
        } else if (n3 < 0 && n4 < 0) {
            n11 = -n5 + n12;
        }
        int n16 = 0;
        int n17 = n7 + n8 * n5;
        for (int i = 0; i < n13; ++i) {
            int n18 = 0;
            for (int j = 0; j < n12; ++j) {
                nArray2[n17] = nArray[(n18 >> 16) + n16];
                n17 += n9;
                n18 += n14;
            }
            n17 += n11;
            n16 += ((n10 += n15) >> 16) * n;
            n10 &= 0xFFFF;
        }
    }
}

