/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Lozenge
implements Constants {
    public static final int LOZENGE_TEXT_COLOUR = 0xFFFFFF;
    public static final int LABEL_COLOUR = 15907854;
    public static final int NUM_LINE_FRAMES = 6;
    public int lineFrameIndex;
    public static final byte NORMAL = 0;
    public static final byte QUESTION = 1;
    public static final byte IMAGE = 2;
    public byte type;
    public static final byte[][] LOZENGE_FRAMES = new byte[][]{{0, 1, 2}, {2}, {5}, {4}, {3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2}, {3}, {0, 1, 2}, {0}, {4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2}};
    public static final byte[][] LOZENGE_SLOW_DEVICE_FRAMES = new byte[][]{{0, 1, 2}, {2}, {5}, {4}, {3, 3, 2, 2}, {3}, {0, 1, 2}, {0}, {4, 4, 2, 2}};
    public static final int[] TEXT_COLOR_FOR_FRAME = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0, 0, 0xFFFFFF};
    public static final int[] LABEL_COLOR_FOR_FRAME = new int[]{15907854, 15907854, 15907854, 0xFFFFFF, 0xFFFFFF, 15907854};
    public static final byte[] ELLIPSE_FOR_FRAME = new byte[]{0, 0, 0, 0, 0, 0};
    public static final byte CENTER = 0;
    public static final byte LEFT = 1;
    public static final byte OPENING = 0;
    public static final byte OPENED = 1;
    public static final byte SELECTED = 2;
    public static final byte CLICKED = 3;
    public static final byte CORRECT = 4;
    public static final byte CORRECT_IDLE = 5;
    public static final byte CLOSING = 6;
    public static final byte CLOSED = 7;
    public static final byte WRONG_FASTEST_FINGER_CHOICE = 8;
    public byte state = (byte)7;
    public int x;
    public int y;
    public String label;
    public String labelToDraw;
    public String[] texts;
    public static DeviceSprite baseLozengeSprite;
    public static DeviceSprite ellipseSprite;
    public static DeviceImage lineImage;
    public int lozengeWidth;
    public int lozengeHeight;
    public DeviceSprite lozengeSprite;
    public DeviceImage insideImage;
    public int lineSpacing;
    public int linesPerScreen;
    public GameStage listener;
    public int alignment;
    public int textStartX;
    public int imageBgColor;
    public int topLineIndex;
    public int textStartY;
    public boolean doRepaint = true;
    public boolean isSplashLozenge;
    public boolean isViewProfile;
    public boolean isCompareProfile;
    public boolean demoLozenge;
    public int scrollX;
    public boolean scrollTexts;
    public int m_lozengeTextYoffet = 0;
    public boolean isPhoneLozenge = false;
    public boolean isPeopleSpeakLozenge = false;

    public Lozenge(String string, String string2, int n, int n2, int n3, byte by, int n4, GameStage gameStage) {
        this.alignment = n3;
        this.type = by;
        this.listener = gameStage;
        this.lozengeSprite = new DeviceSprite(baseLozengeSprite);
        if (by == 1) {
            this.lozengeWidth = Device.viewWidth;
            this.lozengeHeight = n4;
        } else {
            this.linesPerScreen = 1;
            this.lozengeWidth = this.lozengeSprite.getWidth();
            this.lozengeHeight = this.lozengeSprite.getHeight();
        }
        this.setText(string, string2, 0);
        this.setPosition(n, n2);
        this.textStartX = 12 + ellipseSprite.getWidth() + 4;
    }

    public Lozenge(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.imageBgColor = n4;
        this.insideImage = deviceImage;
        this.type = (byte)2;
        this.lozengeSprite = new DeviceSprite(baseLozengeSprite);
        this.lozengeWidth = Device.viewWidth;
        this.lozengeHeight = n3;
        this.setPosition(n, n2);
        this.alignment = 0;
    }

    public static void init() throws Exception {
        if (baseLozengeSprite == null) {
            if (Engine.text == null) {
                baseLozengeSprite = new DeviceSprite("lozenge_classic");
                MainStage.LozengerStyle = 1;
            } else if (Engine.text[0].equals("0")) {
                baseLozengeSprite = new DeviceSprite("lozenge");
                MainStage.LozengerStyle = 0;
                Lozenge.baseLozengeSprite.spriteImages[2] = null;
                Lozenge.baseLozengeSprite.spriteImages[2] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(108)));
                Lozenge.baseLozengeSprite.spriteImages[3] = null;
                Lozenge.baseLozengeSprite.spriteImages[3] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(109)));
                Lozenge.baseLozengeSprite.spriteImages[4] = new DeviceImage(Engine.ResourceMaster_getResource(49));
                Lozenge.baseLozengeSprite.spriteImages[5] = null;
                Lozenge.baseLozengeSprite.spriteImages[5] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(111)));
                Lozenge.baseLozengeSprite.spriteImages[6] = null;
                Lozenge.baseLozengeSprite.spriteImages[6] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(112)));
                MainStage.LozengerStyle = 0;
            } else {
                baseLozengeSprite = new DeviceSprite("lozenge_classic");
                MainStage.LozengerStyle = 1;
            }
            lineImage = new DeviceImage("line.png");
        }
    }

    public static void changeLozengerColour(int n, int n2) {
        switch (n2) {
            case 0: {
                Lozenge.baseLozengeSprite.spriteImages[n] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(108)));
                break;
            }
            case 1: {
                Lozenge.baseLozengeSprite.spriteImages[n] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(109)));
                break;
            }
            case 2: {
                Lozenge.baseLozengeSprite.spriteImages[n] = new DeviceImage(Engine.ResourceMaster_getResource(49));
                break;
            }
            case 3: {
                Lozenge.baseLozengeSprite.spriteImages[n] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(111)));
                break;
            }
            case 4: {
                Lozenge.baseLozengeSprite.spriteImages[n] = new DeviceImage(Engine.insertPLTE(Engine.ResourceMaster_getResource(49), Engine.ResourceMaster_getResource(110)));
            }
        }
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.lozengeSprite.setPosition(n, n2);
    }

    public void setText(String string, String string2, int n) {
        this.label = string;
        this.labelToDraw = string;
        if (this.labelToDraw != null) {
            this.labelToDraw = Engine.text[102].equals("fr") ? this.labelToDraw + " : " : this.labelToDraw + ":";
        }
        if (string2 == null) {
            this.texts = null;
        } else if (this.type == 1) {
            int n2 = this.lozengeHeight - n;
            if (MainStage.phoneFriendActive) {
                Engine cfr_ignored_0 = Main.instance.engine;
                if (Engine.imgFriends != null) {
                    Engine cfr_ignored_1 = Main.instance.engine;
                    n2 -= Engine.imgFriends[0].height + 2;
                }
            }
            this.lineSpacing = 6;
            this.lineSpacing += -6;
            this.linesPerScreen = (n2 - this.lineSpacing) / (FontMgr.getCharBaseLine(4) + this.lineSpacing);
            this.lineSpacing = (n2 - this.linesPerScreen * FontMgr.getCharBaseLine(4)) / (this.linesPerScreen + 1);
            if (!Device.USE_BITMAP_FONTS) {
                // empty if block
            }
            this.texts = Engine.newStage.compareGraphMenu != null && Engine.newStage.compareGraphMenu.isCompareGraphMenu ? Engine.getStrings(string2, this.lozengeWidth - 12 - Engine.phoneFriendArrows[0].width * 2 - 20, 4) : Engine.getStrings(string2, this.lozengeWidth - 12, 4);
            if (this.texts.length < this.linesPerScreen) {
                this.linesPerScreen = this.texts.length;
            }
            this.textStartY = (n2 - this.linesPerScreen * (FontMgr.getCharBaseLine(4) + this.lineSpacing) + this.lineSpacing) / 2;
        } else {
            this.texts = new String[1];
            this.texts[0] = string2;
            if (FontMgr.stringWidth(0, this.texts[0]) > this.lozengeWidth - 24) {
                this.scrollTexts = true;
            }
        }
        this.doRepaint = true;
    }

    public void setState(byte by) {
        if (this.state == 7 && by == 6) {
            return;
        }
        byte by2 = this.state;
        this.state = by;
        this.lozengeSprite.setFrameSequence(LOZENGE_SLOW_DEVICE_FRAMES[this.state]);
        this.lozengeSprite.setFrame(0);
        if (this.state == 0 || this.state == 7) {
            this.lineFrameIndex = 0;
            this.lozengeSprite.setVisible(false);
        } else if (this.state == 6) {
            this.lineFrameIndex = 6 + LOZENGE_SLOW_DEVICE_FRAMES[6].length;
            this.lozengeSprite.setFrame(LOZENGE_SLOW_DEVICE_FRAMES[6].length - 1);
        }
        this.doRepaint = true;
    }

    public int getWidth() {
        return this.lozengeWidth;
    }

    public int getHeight() {
        return this.lozengeHeight;
    }

    public void tick() {
        short s = this.lozengeSprite.getFrame();
        this.lozengeSprite.nextFrame();
        if (s != this.lozengeSprite.getFrame()) {
            this.doRepaint = true;
        }
        switch (this.state) {
            case 0: {
                ++this.lineFrameIndex;
                int n = this.lineFrameIndex - 6;
                if (n == 0) {
                    this.lozengeSprite.setVisible(true);
                }
                if (n >= LOZENGE_SLOW_DEVICE_FRAMES[0].length - 1) {
                    this.setState((byte)1);
                    break;
                }
                if (n < 0) break;
                this.lozengeSprite.setFrame(n);
                break;
            }
            case 6: {
                --this.lineFrameIndex;
                int n = this.lineFrameIndex - 6;
                if (n == -1) {
                    this.lozengeSprite.setVisible(false);
                } else if (n >= 0) {
                    this.lozengeSprite.setFrame(n);
                }
                if (this.lineFrameIndex >= 0) break;
                this.setState((byte)7);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void paint(Graphics var1_1) {
        block41: {
            block43: {
                block42: {
                    var2_2 = (this.lozengeHeight >> 1) + this.y;
                    var3_3 = Device.TEXT_HEIGHT_FOR_FRAME[Lozenge.LOZENGE_SLOW_DEVICE_FRAMES[this.state][this.lozengeSprite.getFrame()]];
                    var4_4 = 0;
                    if ((this.state == 0 || this.state == 6) && this.lineFrameIndex > 0 && this.lineFrameIndex <= 6) {
                        var5_5 = this.lozengeWidth * this.lineFrameIndex / 6;
                        var1_1.setClip(this.x + (this.lozengeWidth - var5_5) / 2, var2_2, var5_5, 1);
                        Lozenge.lineImage.drawImage(var1_1, this.x, var2_2);
                        var1_1.setClip(0, 0, Device.canvasWidth, Device.canvasHeight);
                    }
                    Engine.setColor(var1_1, 0xFFFFFF);
                    if (!this.lozengeSprite.isVisible) break block41;
                    if (this.type != 0) break block42;
                    if (this.isViewProfile) break block43;
                    if (!this.isSplashLozenge) ** GOTO lbl-1000
                    if (MainStage.LozengerStyle == 0) {
                        this.lozengeSprite.paint(var1_1, 6, 0, 0);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.lozengeSprite.paint(var1_1, 0, 0);
                    }
                    break block43;
                }
                var3_3 = var3_3 * this.lozengeHeight / Device.TEXT_HEIGHT_FOR_FRAME[2];
                var5_5 = this.y + (this.lozengeHeight - (var3_3 += 0)) / 2;
                if (this.isPhoneLozenge) {
                    var4_4 = 60;
                    var5_5 = 30;
                }
                if (this.type == 2) {
                    Engine.setColor(var1_1, this.imageBgColor);
                } else if (this.state == 2) {
                    Engine.setColor(var1_1, 2654392);
                } else if (this.state == 3) {
                    Engine.setColor(var1_1, 15705088);
                } else {
                    var6_6 = Integer.parseInt(Engine.getText(1));
                    switch (var6_6) {
                        case 0: {
                            Engine.setColor(var1_1, 0);
                            break;
                        }
                        case 1: {
                            Engine.setColor(var1_1, 11259189);
                            break;
                        }
                        case 2: {
                            Engine.setColor(var1_1, 16298259);
                            break;
                        }
                        case 3: {
                            Engine.setColor(var1_1, 36820);
                            break;
                        }
                        case 4: {
                            Engine.setColor(var1_1, 18571);
                            break;
                        }
                        case 5: {
                            Engine.setColor(var1_1, 3942758);
                        }
                    }
                }
                if (!this.isPeopleSpeakLozenge) {
                    var1_1.fillRect(this.x, var5_5, this.lozengeWidth, var3_3 - var4_4);
                    Lozenge.lineImage.drawImage(var1_1, this.x, var5_5);
                    Lozenge.lineImage.drawImage(var1_1, this.x, var5_5 + var3_3 - var4_4);
                    var1_1.setClip(this.x, this.y + (this.lozengeHeight - var3_3) / 2, this.lozengeWidth, var3_3);
                } else {
                    Lozenge.lineImage.drawImage(var1_1, this.x, 29);
                    Lozenge.lineImage.drawImage(var1_1, this.x, 30 + Engine.newStage.peopleSpeakImage.height);
                }
            }
            var6_6 = this.x;
            var5_5 = this.type == 1 ? this.y + this.textStartY : var2_2 - FontMgr.getCharBaseLine(4) / 2 - 0;
            if (this.alignment == 0) {
                var6_6 += this.lozengeWidth / 2;
                var7_7 = 17;
            } else {
                var6_6 += this.textStartX;
                var7_7 = 20;
            }
            if (this.isCompareProfile) {
                var6_6 = this.x + (this.lozengeWidth - 16);
                var7_7 = 24;
            }
            if (this.type == 2) {
                this.insideImage.drawImage(var1_1, var6_6, var2_2, 3);
            }
            if (this.state != 0 && this.state != 6) {
                if (this.labelToDraw != null) {
                    var8_8 = Lozenge.LOZENGE_SLOW_DEVICE_FRAMES[this.state][this.lozengeSprite.getFrame()];
                    if (!this.isCompareProfile) {
                        Lozenge.ellipseSprite.paint(var1_1, Lozenge.ELLIPSE_FOR_FRAME[var8_8], this.x + 12, this.y + (this.lozengeHeight - Lozenge.ellipseSprite.getHeight()) / 2 + 1);
                    }
                    Engine.setColor(var1_1, Lozenge.LABEL_COLOR_FOR_FRAME[var8_8]);
                    var9_9 = this.getFontForLozenger(var8_8, true);
                    FontMgr.drawString(var9_9, var1_1, this.labelToDraw, this.x + this.textStartX, var5_5 + this.m_lozengeTextYoffet, 20);
                    if (this.alignment == 1) {
                        var6_6 += FontMgr.stringWidth(4, this.labelToDraw) + 4;
                    }
                }
                if (this.texts != null) {
                    var8_8 = 0;
                    var8_8 = Lozenge.LOZENGE_SLOW_DEVICE_FRAMES[this.state][this.lozengeSprite.getFrame()];
                    Engine.setColor(var1_1, Lozenge.TEXT_COLOR_FOR_FRAME[Lozenge.LOZENGE_SLOW_DEVICE_FRAMES[this.state][this.lozengeSprite.getFrame()]]);
                    if (this.isPhoneLozenge) {
                        Main.instance.engine;
                        if (Engine.imgFriends != null) {
                            Main.instance.engine;
                            var5_5 = 31 + Engine.imgFriends[0].height + 6;
                        }
                    }
                    if (this.isPeopleSpeakLozenge && Engine.newStage.peopleSpeakImage != null) {
                        var5_5 = 30 + Engine.newStage.peopleSpeakImage.height + 3;
                    }
                    var9_9 = this.getFontForLozenger(var8_8, false);
                    if (this.isSplashLozenge) {
                        var9_9 = this.getFontForLozenger(6, false);
                    }
                    if (this.type == 1) {
                        var9_9 = 4;
                    }
                    var11_11 = this.topLineIndex + this.linesPerScreen;
                    for (var10_10 = this.topLineIndex; var10_10 < var11_11 && var10_10 < this.texts.length; ++var10_10) {
                        if (PlayerProfile.profileForm != null) {
                            if (this.isSplashLozenge && !this.isViewProfile && this.scrollTexts) {
                                ++this.scrollX;
                                if (this.scrollX >= (FontMgr.stringWidth(0, this.texts[0]) << 1) - 6 + 1) {
                                    this.scrollX = 0;
                                }
                                var1_1.setClip(12, var5_5 - 1, this.lozengeWidth - 24, var3_3);
                                FontMgr.drawString(var9_9, var1_1, this.texts[var10_10], 116 - this.scrollX, var5_5 + this.m_lozengeTextYoffet, 20);
                            } else if (!this.scrollTexts) {
                                FontMgr.drawString(var9_9, var1_1, this.texts[var10_10], var6_6, var5_5 + this.m_lozengeTextYoffet, var7_7);
                            }
                        } else {
                            FontMgr.drawString(var9_9, var1_1, this.texts[var10_10], var6_6, var5_5 + this.m_lozengeTextYoffet, var7_7);
                        }
                        var5_5 += FontMgr.getCharBaseLine(4) + this.lineSpacing;
                    }
                }
            }
            var1_1.setClip(0, 0, Device.canvasWidth, Device.canvasHeight);
        }
        this.doRepaint = false;
    }

    public int getFrameForLozengeFont() {
        byte by = LOZENGE_SLOW_DEVICE_FRAMES[this.state][this.lozengeSprite.getFrame()];
        return this.getFontForLozenger(by, false);
    }

    public int getFontForLozenger(int n, boolean bl) {
        int n2 = 0;
        if (Engine.text == null) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    n2 = 4;
                    break;
                }
                case 3: {
                    n2 = 6;
                    break;
                }
                case 4: {
                    n2 = 5;
                    break;
                }
                case 5: {
                    n2 = 4;
                }
            }
            return n2;
        }
        if (MainStage.LozengerStyle == 1) {
            return 4;
        }
        int n3 = 0;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                n3 = Integer.parseInt(Engine.getText(1));
                n2 = this.getFontColour(n3, bl);
                break;
            }
            case 3: {
                n3 = Integer.parseInt(Engine.getText(2));
                n2 = this.getFontColour(n3, bl);
                break;
            }
            case 4: {
                n3 = Integer.parseInt(Engine.getText(3));
                n2 = this.getFontColour(n3, bl);
                break;
            }
            case 5: {
                n3 = Integer.parseInt(Engine.getText(4));
                n2 = this.getFontColour(n3, bl);
                break;
            }
            case 6: {
                n3 = Integer.parseInt(Engine.getText(5));
                n2 = this.getFontColour(n3, bl);
            }
        }
        return n2;
    }

    public int getFontColour(int n, boolean bl) {
        int n2 = 4;
        if (!bl) {
            switch (n) {
                case 0: {
                    n2 = 4;
                    break;
                }
                case 1: {
                    n2 = 6;
                    break;
                }
                case 2: {
                    n2 = 5;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 7;
                    break;
                }
                case 5: {
                    n2 = 15;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    n2 = 8;
                    break;
                }
                case 1: {
                    n2 = 10;
                    break;
                }
                case 2: {
                    n2 = 9;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 7;
                    break;
                }
                case 5: {
                    n2 = 15;
                }
            }
        }
        return n2;
    }
}

