/*
 * Decompiled with CFR 0.152.
 */
public class TileSequence {
    private int[] m_tiles;
    private int[] m_frames;
    private int m_index = 0;
    private int m_frameCount = 0;
    private int m_sequenceNumber = 0;
    private int m_sequenceLength;

    public TileSequence(int sequenceNumber, int sequenceLength) {
        this.m_sequenceNumber = sequenceNumber;
        if (this.m_sequenceNumber < 0) {
            this.m_sequenceNumber *= -1;
        }
        this.m_sequenceLength = sequenceLength;
        this.m_tiles = new int[sequenceLength];
        this.m_frames = new int[sequenceLength];
    }

    public void addTile(int index, int tile, int frames) {
        if (index < this.m_sequenceLength) {
            this.m_tiles[index] = tile;
            this.m_frames[index] = frames = frames < 1 ? 1 : frames;
        }
    }

    public void reset() {
        this.m_index = 0;
        this.m_frameCount = this.m_frames[0];
    }

    public int getNextTile() {
        int tile = this.m_tiles[this.m_index];
        --this.m_frameCount;
        if (this.m_frameCount == 0) {
            this.m_index = this.m_index < this.m_sequenceLength - 1 ? this.m_index + 1 : 0;
            this.m_frameCount = this.m_frames[this.m_index];
        }
        return tile;
    }

    public int getSequenceNumber() {
        return this.m_sequenceNumber;
    }
}

