/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    cricketcanvas canvas;
    byte[] buf = new byte[49152];
    InputStream is = null;
    Player menuSnd;
    Player wordSolved;
    Player introSnd;
    Player timeout;
    Player youWin;
    Player transSnd;
    Player puzzleStart;
    boolean transSndBool;
    boolean puzzleStartBool;

    public SoundPlayer(cricketcanvas canvas) {
        this.canvas = canvas;
        this.loadAllAMRSound();
    }

    public synchronized void loadAllAMRSound() {
        this.loadWavSound((byte)0);
        this.loadWavSound((byte)1);
        this.loadWavSound((byte)2);
        this.loadWavSound((byte)3);
    }

    public synchronized void loadWavSound(byte type) {
        try {
            switch (type) {
                case 0: {
                    this.SoundManager("/sound/menu.mid", (byte)0);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception while loading Sound: " + e);
        }
    }

    public void playWavSound(byte type) {
        try {
            switch (type) {
                case 0: {
                    this.stopWavSound();
                    if (this.menuSnd == null) {
                        this.loadWavSound((byte)0);
                    }
                    VolumeControl vc1 = (VolumeControl)this.menuSnd.getControl("VolumeControl");
                    vc1.setLevel(this.canvas.soundVolume * 33);
                    this.menuSnd.start();
                }
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stopWavSound() {
        try {
            if (this.menuSnd != null) {
                this.menuSnd.stop();
            }
            if (this.wordSolved != null) {
                this.wordSolved.stop();
            }
            if (this.introSnd != null) {
                this.introSnd.stop();
            }
            if (this.timeout != null) {
                this.timeout.stop();
            }
            if (this.youWin != null) {
                this.youWin.stop();
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void SoundManager(String url, byte type1) {
        try {
            this.is = this.getClass().getResourceAsStream(url);
            String ctype = SoundPlayer.guessContentType(url);
            switch (type1) {
                case 0: {
                    this.menuSnd = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.menuSnd.realize();
                    this.menuSnd.setLoopCount(-1);
                    break;
                }
                case 1: {
                    this.wordSolved = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.wordSolved.realize();
                    this.wordSolved.setLoopCount(1);
                    break;
                }
                case 2: {
                    this.introSnd = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.introSnd.realize();
                    this.introSnd.setLoopCount(1);
                    break;
                }
                case 3: {
                    this.timeout = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.timeout.realize();
                    this.timeout.setLoopCount(-1);
                    break;
                }
                case 4: {
                    this.youWin = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.youWin.realize();
                    this.youWin.setLoopCount(1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in SoundManager " + e.toString());
        }
    }

    private static String guessContentType(String url) {
        String ctype = null;
        if (url.endsWith("wav")) {
            ctype = "audio/x-wav";
        } else if (url.endsWith("jts")) {
            ctype = "audio/x-tone-seq";
        } else if (url.endsWith("mid")) {
            ctype = "audio/midi";
        } else if (url.endsWith("amr")) {
            ctype = "audio/amr";
        } else {
            System.out.println("Cannot guess content type from URL: " + url);
        }
        return ctype;
    }
}

