/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.MagmicGame;
import com.magmic.MagmicIO;
import com.magmic.kahuna.BoardLayer;
import com.magmic.maglet.Maglet;
import java.io.IOException;
import java.io.InputStream;

public class Board {
    public static final int BOX_EXISTS_MASK = 128;
    public static final int BOX_SPAWN_MASK = 64;
    public static final int BOX_VALUE_MASK = 63;
    public static final int BOX_LOCK_MASK = 768;
    public static final int BOX_STONE_MASK = 3072;
    public static final int BOX_LOCK_SHIFT = 8;
    public static final int BOX_STONE_SHIFT = 10;
    public static final int BOX_DEFAULT = 0;
    public static final int EMPTY_VALUE = 0;
    public static final int WILD_VALUE = 27;
    public static final int INFINITE_LOOP_LIMIT = 1000;
    public String name;
    public String bonusWord;
    public byte nRow;
    public byte nCol;
    public short[][] board;
    public boolean swapped;
    public byte swapRow1;
    public byte swapCol1;
    public byte swapRow2;
    public byte swapCol2;
    public int letterCount;
    public int letterFrequencyTotal;
    public char[] letters;
    public short[] letterFrequencies;
    public boolean[] letterLockable;
    public int wordTablesLength;
    public byte[] wordTikiMovement;
    public byte[] wordTikiMovementFromBomb;
    public byte[] wordGenerateBomb;
    public short[] wordStoneBreakingPoint;
    public int score;
    public int tiki;
    public int completedWordLengthSum;
    public int completedWordCount;
    public int timeAllowed;
    public int stoneLeft;
    public int fallXDirection;
    public boolean showTiki;
    public boolean calculateSpawn;
    public BoardLayer listener;
    public int completeWordBombStrenght;
    public int completeWordStoneStrenght;

    public void setLetterFrequency(String string) {
        Maglet.getInstance();
        InputStream inputStream = Maglet.getResourceInputStream(string);
        this.initializeLetterFrequencyTable(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setScoreRules(String string) {
        Maglet.getInstance();
        InputStream inputStream = Maglet.getResourceInputStream(string);
        this.initializeScoreRules(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean readLevel(InputStream inputStream) {
        int n;
        int n2;
        short s;
        int n3;
        int n4;
        int n5;
        this.score = 0;
        this.tiki = 0;
        this.completedWordLengthSum = 0;
        this.completedWordCount = 0;
        this.stoneLeft = 0;
        BoardLayer boardLayer = this.listener;
        this.listener = null;
        MagmicIO magmicIO = MagmicGame.maglet.io;
        magmicIO.bind(inputStream);
        this.name = magmicIO.read_string_8();
        this.bonusWord = magmicIO.read_string_8();
        short s2 = magmicIO.read_u8();
        this.calculateSpawn = (s2 & 1) != 0;
        this.showTiki = (s2 & 2) != 0;
        short s3 = magmicIO.read_u8();
        this.timeAllowed = (60 * (s3 / 10) + 6 * (s3 % 10)) * 1000;
        short s4 = magmicIO.read_u8();
        int n6 = s4 >>> 4;
        int n7 = s4 & 0xF;
        if (magmicIO.exception != null) {
            return false;
        }
        this.setBoardSize(n6, n7);
        this.swapped = false;
        this.fallXDirection = 1;
        short s5 = magmicIO.read_u8();
        boolean bl = true;
        int n8 = 0;
        for (n5 = 0; n5 < this.nRow; ++n5) {
            for (n4 = 0; n4 < this.nCol; ++n4) {
                n8 = bl ? magmicIO.read_u8() : (n8 <<= 4);
                n3 = (n8 & 0x10) != 0 ? 1 : 0;
                s = (n8 & 0x20) != 0 ? (short)1 : 0;
                n2 = (n8 & 0xC0) >>> 6;
                this.setExists(n5, n4, n3 != 0);
                if (n3 != 0) {
                    this.setLockLevel(n5, n4, n2);
                    this.setStoneLevel(n5, n4, s != 0 ? s5 : (short)0);
                }
                if (s != 0) {
                    this.stoneLeft += s5;
                }
                bl = !bl;
            }
        }
        if (magmicIO.exception != null) {
            return false;
        }
        if (this.calculateSpawn) {
            for (n5 = (int)this.nRow; n5 >= 0; --n5) {
                for (n4 = 0; n4 < this.nCol; ++n4) {
                    if (!this.exists(n5, n4) || this.exists(n5 - 1, n4) || this.exists(n5 - 1, n4 - 1) || this.exists(n5 - 1, n4 + 1)) continue;
                    this.setSpawn(n5, n4, true);
                }
            }
        }
        for (n5 = 1000; this.fallAndSpawn() && n5 > 0; --n5) {
        }
        for (n4 = 0; n4 < this.nRow; ++n4) {
            for (n3 = 0; n3 < this.nCol; ++n3) {
                s = this.getBox(n4, n3);
                if (!this.exists(s) || this.getLockLevel(s) == 0 || this.isEmpty(s)) continue;
                this.setValue(n4, n3, this.spawnRandomValue(true));
            }
        }
        n4 = magmicIO.read_u8();
        for (n3 = 0; n3 < n4; ++n3) {
            s = magmicIO.read_u8();
            n2 = s >>> 4;
            n = s & 0xF;
            this.setValue(n2, n, 27);
        }
        n4 = magmicIO.read_u8();
        for (n3 = 0; n3 < n4; ++n3) {
            s = magmicIO.read_u8();
            n2 = s >>> 4;
            n = s & 0xF;
            char c = (char)magmicIO.read_s8();
            this.setValue(n2, n, this.charToValue(c));
        }
        this.listener = boardLayer;
        if (magmicIO.exception == null && this.listener != null) {
            this.listener.onNewBoard(this);
        }
        return magmicIO.exception == null;
    }

    public boolean exists(int n, int n2) {
        if (n < 0 || n >= this.nRow || n2 < 0 || n2 >= this.nCol) {
            return false;
        }
        return this.exists(this.board[n][n2]);
    }

    public boolean exists(short s) {
        return (s & 0x80) != 0;
    }

    public short getBox(int n, int n2) {
        if (!this.exists(n, n2)) {
            return 0;
        }
        return this.board[n][n2];
    }

    public boolean isSpawn(short s) {
        return (s & 0x40) != 0;
    }

    public boolean isEmpty(short s) {
        int n = this.getValue(s);
        char c = Board.valueToChar(n);
        return c == '_';
    }

    public int getStoneLevel(short s) {
        return (s & 0xC00) >>> 10;
    }

    public int getLockLevel(short s) {
        return (s & 0x300) >>> 8;
    }

    public int getValue(short s) {
        return s & 0x3F;
    }

    public boolean canFallDown(short s) {
        return this.exists(s) && !this.isEmpty(s) && this.getLockLevel(s) == 0;
    }

    public boolean canFallSoon(int n, int n2, int n3) {
        if (n3 < 0) {
            return false;
        }
        --n3;
        short s = this.getBox(n, n2);
        if (!this.exists(s) || this.getLockLevel(s) != 0) {
            return false;
        }
        if (this.canFallDown(s)) {
            return true;
        }
        if (!this.exists(s) || !this.isEmpty(s)) {
            return false;
        }
        short s2 = this.getBox(n - 1, n2);
        short s3 = this.getBox(n - 1, n2 - 1);
        short s4 = this.getBox(n - 1, n2 + 1);
        if (this.canFallDown(s2) || this.canFallDown(s3) || this.canFallDown(s4)) {
            return true;
        }
        return this.canFallSoon(n - 1, n2, n3) || this.canFallSoon(n - 1, n2 - 1, n3) || this.canFallSoon(n - 1, n2 + 1, n3);
    }

    public void setExists(int n, int n2, boolean bl) {
        if (bl) {
            short[] sArray = this.board[n];
            int n3 = n2;
            sArray[n3] = (short)(sArray[n3] | 0x80);
        } else {
            short[] sArray = this.board[n];
            int n4 = n2;
            sArray[n4] = (short)(sArray[n4] & 0xFFFFFF7F);
        }
    }

    public void setSpawn(int n, int n2, boolean bl) {
        if (bl) {
            short[] sArray = this.board[n];
            int n3 = n2;
            sArray[n3] = (short)(sArray[n3] | 0x40);
        } else {
            short[] sArray = this.board[n];
            int n4 = n2;
            sArray[n4] = (short)(sArray[n4] & 0xFFFFFFBF);
        }
    }

    public void setStoneLevel(int n, int n2, int n3) {
        short[] sArray = this.board[n];
        int n4 = n2;
        sArray[n4] = (short)(sArray[n4] & 0xFFFFF3FF);
        short[] sArray2 = this.board[n];
        int n5 = n2;
        sArray2[n5] = (short)(sArray2[n5] | n3 << 10 & 0xC00);
    }

    public void setLockLevel(int n, int n2, int n3) {
        short[] sArray = this.board[n];
        int n4 = n2;
        sArray[n4] = (short)(sArray[n4] & 0xFFFFFCFF);
        short[] sArray2 = this.board[n];
        int n5 = n2;
        sArray2[n5] = (short)(sArray2[n5] | n3 << 8 & 0x300);
    }

    public void setValue(int n, int n2, int n3) {
        short[] sArray = this.board[n];
        int n4 = n2;
        sArray[n4] = (short)(sArray[n4] & 0xFFFFFFC0);
        short[] sArray2 = this.board[n];
        int n5 = n2;
        sArray2[n5] = (short)(sArray2[n5] | n3 & 0x3F);
    }

    public boolean fallAndSpawn() {
        boolean bl = false;
        bl |= this.spawn();
        int n = this.fallXDirection > 0 ? 0 : this.nCol - 1;
        for (int i = this.nRow - 1; i > 0; --i) {
            for (int j = n; j >= 0 && j < this.nCol; j += this.fallXDirection) {
                short s;
                short s2 = this.getBox(i, j);
                if (!this.exists(s2) || !this.isEmpty(s2)) continue;
                short s3 = this.getBox(i - 1, j);
                if (this.canFallDown(s3)) {
                    this.fall(i - 1, j, i, j);
                    bl = true;
                    continue;
                }
                if (this.canFallSoon(i - 1, j, 2)) {
                    bl = true;
                    continue;
                }
                if (j > 0) {
                    s3 = this.getBox(i - 1, j - 1);
                    s = this.getBox(i, j - 1);
                    if (!(!this.canFallDown(s3) || this.exists(s) && this.isEmpty(s))) {
                        this.fall(i - 1, j - 1, i, j);
                        bl = true;
                        continue;
                    }
                    if (this.canFallSoon(i - 1, j - 1, 0)) {
                        bl = true;
                    }
                }
                if (j + 1 >= this.nCol) continue;
                s3 = this.getBox(i - 1, j + 1);
                s = this.getBox(i, j + 1);
                if (!(!this.canFallDown(s3) || this.exists(s) && this.isEmpty(s))) {
                    this.fall(i - 1, j + 1, i, j);
                    bl = true;
                    continue;
                }
                if (!this.canFallSoon(i - 1, j + 1, 0)) continue;
                bl = true;
            }
        }
        return bl |= this.spawn();
    }

    public void fall(int n, int n2, int n3, int n4) {
        this.setValue(n3, n4, this.getValue(this.getBox(n, n2)));
        this.setValue(n, n2, 0);
        if (this.listener != null) {
            this.listener.onFall(this, n, n2, n3, n4);
        }
    }

    public boolean spawn() {
        boolean bl = false;
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                short s;
                if (!this.exists(i, j) || !this.isEmpty(s = this.getBox(i, j)) || !this.isSpawn(s)) continue;
                this.setValue(i, j, this.spawnRandomValue(false));
                if (this.listener != null) {
                    this.listener.onSpawn(this, i, j);
                }
                bl = true;
            }
        }
        return bl;
    }

    public void initializeLetterFrequencyTable(InputStream inputStream) {
        MagmicIO magmicIO = MagmicGame.maglet.io;
        magmicIO.bind(inputStream);
        this.letterCount = magmicIO.read_s8();
        this.letters = new char[this.letterCount];
        this.letterFrequencies = new short[this.letterCount];
        this.letterLockable = new boolean[this.letterCount];
        this.letterFrequencyTotal = 0;
        for (int i = 0; i < this.letterCount; ++i) {
            byte by = magmicIO.read_s8();
            boolean bl = false;
            if (by < 0) {
                bl = true;
                by = (byte)(by + 128);
            }
            this.letters[i] = (char)by;
            this.letterFrequencies[i] = magmicIO.read_s16();
            this.letterLockable[i] = bl;
            this.letterFrequencyTotal += this.letterFrequencies[i];
        }
    }

    public void initializeScoreRules(InputStream inputStream) {
        MagmicIO magmicIO = MagmicGame.maglet.io;
        magmicIO.bind(inputStream);
        this.wordTablesLength = magmicIO.read_s8();
        this.wordTikiMovement = new byte[this.wordTablesLength];
        this.wordTikiMovementFromBomb = new byte[this.wordTablesLength];
        this.wordGenerateBomb = new byte[this.wordTablesLength];
        this.wordStoneBreakingPoint = new short[this.wordTablesLength];
        for (int i = 0; i < this.wordTablesLength; ++i) {
            this.wordTikiMovement[i] = magmicIO.read_s8();
            this.wordTikiMovementFromBomb[i] = magmicIO.read_s8();
            this.wordGenerateBomb[i] = magmicIO.read_s8();
            this.wordStoneBreakingPoint[i] = magmicIO.read_s16();
        }
    }

    public int spawnRandomValue(boolean bl) {
        int n;
        int n2 = n = bl ? 1000 : 1;
        while (n > 0) {
            --n;
            int n3 = MagmicGame.rand() % this.letterFrequencyTotal;
            int n4 = 0;
            for (int i = 0; i < this.letterCount; ++i) {
                if (n3 >= (n4 += this.letterFrequencies[i]) || bl && !this.letterLockable[i]) continue;
                return this.charToValue(this.letters[i]);
            }
        }
        return this.charToValue(this.letters[0]);
    }

    public void clear(boolean bl) {
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                if (bl && this.getLockLevel(this.getBox(i, j)) != 0) continue;
                this.setValue(i, j, 0);
            }
        }
        this.swapped = false;
    }

    public boolean swap(int n, int n2, int n3, int n4) {
        boolean bl = this.swapped && (n == this.swapRow1 && n2 == this.swapCol1 && n3 == this.swapRow2 && n4 == this.swapCol2 || n3 == this.swapRow1 && n4 == this.swapCol1 && n == this.swapRow2 && n2 == this.swapCol2);
        this.unswap();
        if (bl) {
            return true;
        }
        if (n == n3 && n2 == n4) {
            return false;
        }
        short s = this.getBox(n, n2);
        short s2 = this.getBox(n3, n4);
        if (!this.exists(s) || !this.exists(s2)) {
            return false;
        }
        if (this.isEmpty(s) || this.isEmpty(s2)) {
            return false;
        }
        int n5 = this.getValue(s);
        int n6 = this.getValue(s2);
        this.setValue(n, n2, n6);
        this.setValue(n3, n4, n5);
        this.swapped = true;
        this.swapRow1 = (byte)n;
        this.swapCol1 = (byte)n2;
        this.swapRow2 = (byte)n3;
        this.swapCol2 = (byte)n4;
        if (this.listener != null) {
            this.listener.onSwapLetter(this, n, n2, n3, n4);
        }
        return true;
    }

    public void unswap() {
        if (this.swapped) {
            short s = this.getBox(this.swapRow1, this.swapCol1);
            short s2 = this.getBox(this.swapRow2, this.swapCol2);
            int n = this.getValue(s);
            int n2 = this.getValue(s2);
            this.setValue(this.swapRow1, this.swapCol1, n2);
            this.setValue(this.swapRow2, this.swapCol2, n);
            this.swapped = false;
            if (this.listener != null) {
                this.listener.onUnSwapLetter(this, this.swapRow1, this.swapCol1, this.swapRow2, this.swapCol2);
            }
        }
    }

    public static char valueToChar(int n) {
        if (n == 0) {
            return '_';
        }
        int n2 = 26;
        if (--n < n2) {
            return (char)(n + 97);
        }
        switch (n -= n2) {
            case 0: {
                return '?';
            }
            case 1: {
                return '?';
            }
            case 2: {
                return '?';
            }
            case 3: {
                return '?';
            }
            case 4: {
                return '?';
            }
            case 5: {
                return '?';
            }
            case 6: {
                return '?';
            }
        }
        throw new RuntimeException("Invalid value: " + n);
    }

    public int charToValue(char c) {
        if (c == '_') {
            return 0;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 1;
        }
        return 27;
    }

    public int getBombValue(int n) {
        if (n >= 1 && n <= 6) {
            return 27 + n;
        }
        throw new RuntimeException("Invalid Bomb Strenght" + n);
    }

    public int getBombStrenght(int n) {
        int n2 = n - 27;
        if (n2 >= 1 && n2 <= 6) {
            return n2;
        }
        return 0;
    }

    public static char bombToChar(int n) {
        switch (n) {
            case 1: {
                return '=';
            }
            case 2: {
                return '{';
            }
            case 3: {
                return '}';
            }
            case 4: {
                return '[';
            }
            case 5: {
                return ']';
            }
            case 6: {
                return '~';
            }
        }
        return '^';
    }

    public int getGeneratedBombValue(int n) {
        byte by = this.wordGenerateBomb[n - 1];
        if (by == 0) {
            return 0;
        }
        return this.getBombValue(by);
    }

    public void completeWord(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        this.completeWordBombStrenght = 0;
        this.completeWordStoneStrenght = 0;
        int n10 = 0;
        for (n9 = n; n9 < n + n2; ++n9) {
            n8 = this.getBox(nArray[n9], nArray2[n9]);
            n7 = Board.valueToChar(this.getValue((short)n8));
            if (n7 != 113) continue;
            ++n10;
        }
        this.completedWordLengthSum += n2;
        this.completedWordLengthSum += n10;
        ++this.completedWordCount;
        if (this.swapped) {
            n9 = 0;
            for (n8 = n; n8 < n + n2 && n9 == 0; n9 |= nArray[n8] == this.swapRow1 && nArray2[n8] == this.swapCol1 || nArray[n8] == this.swapRow2 && nArray2[n8] == this.swapCol2 ? 1 : 0, ++n8) {
            }
            if (n9 == 0) {
                this.unswap();
            }
            this.swapped = false;
        }
        n9 = 0;
        n8 = 0;
        n7 = 0;
        for (n6 = n; n6 < n + n2; ++n6) {
            n5 = this.getBox(nArray[n6], nArray2[n6]);
            n4 = this.getBombStrenght(this.getValue((short)n5));
            if (n4 <= 0) continue;
            n7 = this.detonate(nArray[n6], nArray2[n6], n4, n2);
            n8 = n7 > 0 ? 1 : 0;
            n9 += n7;
            if (this.completeWordBombStrenght >= n4) continue;
            this.completeWordBombStrenght = n4;
        }
        for (n6 = n; n6 < n + n2; ++n6) {
            n9 += this.destroy(nArray[n6], nArray2[n6], false, n2);
        }
        n6 = this.getGeneratedBombValue(n2);
        if (n6 != 0) {
            this.setValue(nArray[n + n2 - 1], nArray2[n + n2 - 1], n6);
        }
        if (n9 > 0) {
            n5 = 0;
            n4 = 0;
            n4 += this.wordTikiMovement[n2 - 1];
            if (n8 != 0) {
                n4 += this.wordTikiMovementFromBomb[n2 - 1] * n7;
            }
            if (n3 == 1) {
                n5 += Math.max(1, this.tiki) * n9;
            }
            if (n3 == 0) {
                n5 += Math.max(1, this.wordStoneBreakingPoint[n2 - 1]) * n9;
            }
            int n11 = Math.max(0, (this.tiki + n4) / 100 - this.tiki / 100);
            for (int i = 0; i < n11; ++i) {
                this.generateRandomWild(3);
            }
            this.tiki += n4;
            this.score += n5;
            if (this.listener != null) {
                this.listener.onAlterScore(this, this.score, n5);
                this.listener.onAlterTiki(this, this.tiki, n4);
            }
        }
    }

    public int detonate(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 8;
        int n7 = (n3 << n6) + (1 << n6) / 2;
        int n8 = n7 >> n6;
        if (n7 - (n8 << n6) > 0) {
            ++n8;
        }
        int n9 = n7 * n7 >> n6 >> n6;
        if (n8 > 0) {
            for (int i = n - n8; i <= n + n8; ++i) {
                int n10 = i - n;
                for (int j = n2 - n8; j <= n2 + n8; ++j) {
                    int n11 = j - n2;
                    int n12 = n10 * n10 + n11 * n11;
                    if (n12 > n9) continue;
                    n5 += this.destroy(i, j, true, n4);
                }
            }
        }
        return n5;
    }

    public int destroy(int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        short s = this.getBox(n, n2);
        if (this.exists(s)) {
            int n5 = this.getStoneLevel(s);
            int n6 = this.getLockLevel(s);
            boolean bl2 = false;
            boolean bl3 = false;
            if (n6 > 0) {
                this.setLockLevel(n, n2, n6 - 1);
                bl3 = true;
            } else if (n5 > 0) {
                this.setStoneLevel(n, n2, n5 - 1);
                bl2 = true;
                if (this.completeWordStoneStrenght < n5) {
                    this.completeWordStoneStrenght = n5;
                }
                --this.stoneLeft;
            }
            if (bl2) {
                ++n4;
            }
            if (this.listener != null) {
                this.listener.onDestroy(this, n, n2, n3, bl, bl3, bl2);
            }
            this.setValue(n, n2, 0);
            int n7 = this.getBombStrenght(this.getValue(s));
            if (n7 > 0) {
                n4 += this.detonate(n, n2, n7, n3);
                if (this.completeWordBombStrenght < n7) {
                    this.completeWordBombStrenght = n7;
                }
            }
            if (bl2 && this.stoneLeft == 0 && this.listener != null) {
                this.listener.onSolved(this);
            }
        }
        return n4;
    }

    public int getFinalScoreWithoutTimeBonus() {
        return (int)((long)this.score * ((long)(this.completedWordLengthSum << 8) / (long)this.completedWordCount) >> 8);
    }

    public int getTimeRemainingScore(int n) {
        return n / 1000 * 5;
    }

    public void generateRandomWild(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        for (n7 = 0; n7 < this.nRow; ++n7) {
            for (n6 = 0; n6 < this.nCol; ++n6) {
                n5 = this.getBox(n7, n6);
                n4 = this.getStoneLevel((short)n5);
                n3 = this.getValue((short)n5);
                if (n3 == 0 || n3 >= 27) continue;
                ++n9;
                if (n4 <= 0) continue;
                ++n8;
            }
        }
        while (n > 0 && n8 > 0) {
            n7 = MagmicGame.rand() % n8;
            n6 = 0;
            for (n5 = 0; n5 < this.nRow && n6 <= n7; ++n5) {
                for (n4 = 0; n4 < this.nCol && n6 <= n7; ++n4) {
                    n3 = this.getBox(n5, n4);
                    n2 = this.getStoneLevel((short)n3);
                    int n10 = this.getValue((short)n3);
                    if (n10 == 0 || n10 >= 27 || n2 <= 0) continue;
                    if (n6 == n7) {
                        this.setValue(n5, n4, 27);
                    }
                    ++n6;
                }
            }
            --n8;
            --n;
        }
        while (n > 0 && n9 > 0) {
            n7 = MagmicGame.rand() % n9;
            n6 = 0;
            for (n5 = 0; n5 < this.nRow && n6 <= n7; ++n5) {
                for (n4 = 0; n4 < this.nCol && n6 <= n7; ++n4) {
                    n3 = this.getBox(n5, n4);
                    n2 = this.getValue((short)n3);
                    if (n2 == 0 || n2 >= 27) continue;
                    if (n6 == n7) {
                        this.setValue(n5, n4, 27);
                    }
                    ++n6;
                }
            }
            --n9;
            --n;
        }
    }

    public void setBoardSize(int n, int n2) {
        if (this.board == null || this.nCol < n2 || this.nRow < n) {
            this.board = new short[n][n2];
        }
        this.nRow = (byte)n;
        this.nCol = (byte)n2;
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                this.board[i][j] = 0;
            }
        }
    }

    public void save(MagmicIO magmicIO) {
        magmicIO.write_string_8(this.name);
        magmicIO.write_string_8(this.bonusWord);
        magmicIO.write_s8(this.nRow);
        magmicIO.write_s8(this.nCol);
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.nCol; ++j) {
                magmicIO.write_s16(this.board[i][j]);
            }
        }
        magmicIO.write_s8((byte)(this.swapped ? 1 : 0));
        magmicIO.write_s8(this.swapRow1);
        magmicIO.write_s8(this.swapCol1);
        magmicIO.write_s8(this.swapRow2);
        magmicIO.write_s8(this.swapCol2);
        magmicIO.write_s32(this.score);
        magmicIO.write_s32(this.tiki);
        magmicIO.write_s32(this.completedWordLengthSum);
        magmicIO.write_s32(this.completedWordCount);
        magmicIO.write_s32(this.timeAllowed);
        magmicIO.write_s32(this.stoneLeft);
        magmicIO.write_s32(this.fallXDirection);
        magmicIO.write_s8((byte)(this.showTiki ? 1 : 0));
        magmicIO.write_s8((byte)(this.calculateSpawn ? 1 : 0));
    }

    public boolean load(MagmicIO magmicIO) {
        this.name = magmicIO.read_string_8();
        this.bonusWord = magmicIO.read_string_8();
        int n = magmicIO.read_s8();
        int n2 = magmicIO.read_s8();
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        this.setBoardSize(n, n2);
        if (magmicIO.exception != null) {
            return false;
        }
        for (n = 0; n < this.nRow; ++n) {
            for (n2 = 0; n2 < this.nCol; ++n2) {
                this.board[n][n2] = magmicIO.read_s16();
            }
        }
        this.swapped = magmicIO.read_s8() != 0;
        this.swapRow1 = magmicIO.read_s8();
        this.swapCol1 = magmicIO.read_s8();
        this.swapRow2 = magmicIO.read_s8();
        this.swapCol2 = magmicIO.read_s8();
        this.score = magmicIO.read_s32();
        this.tiki = magmicIO.read_s32();
        this.completedWordLengthSum = magmicIO.read_s32();
        this.completedWordCount = magmicIO.read_s32();
        this.timeAllowed = magmicIO.read_s32();
        this.stoneLeft = magmicIO.read_s32();
        this.fallXDirection = magmicIO.read_s32();
        this.showTiki = magmicIO.read_s8() != 0;
        this.calculateSpawn = magmicIO.read_s8() != 0;
        return magmicIO.exception == null;
    }
}

