/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.ui;

import com.magmic.maglet.Maglet;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import com.magmic.ui.MagmicSplashInterface;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MagmicSplash2
implements MagmicSplashInterface {
    public Image c2m = null;
    public long c2m_delay = 0L;
    public static final int STATE_LOAD = 0;
    public static final int STATE_ANIMATE = 1;
    public static final int STATE_DELAY = 2;
    public static final int STATE_EXIT = 3;
    private Maglet app;
    private int state;
    private int stateDeltaTime;
    private int deltaTime = 0;
    private long lastTime;
    private static final int DELAY_TIME = 1500;
    private static final int TRANS_COLOUR = 255;
    private static final int FRAME_TIME = 50;
    private static final int TILE_DIM = 8;
    private static final int TILE_SIZE = 32;
    private int timeCode;
    private int[] tileList;
    private boolean[] visibleTileList;
    private int numRows;
    private int numCols;
    private int tileIndex;
    private int numToAdd;
    private Image bgImage;
    private Image magmicImage;
    private int COL_BUFFER = 8;
    private int ROW_BUFFER = 8;
    private int magmicImage_width;
    private int magmicImage_height;
    private Image buffer = null;
    private final Object MUTEX = new Object();
    private int screenWidth;
    private int screenHeight;

    public boolean processEvent(int n, int n2, int n3, Object object) {
        switch (n) {
            case 4: {
                this.app = Maglet.getInstance();
                this.app.enableTickEvents(50L);
                this.state = 0;
                this.app.invalidateScreen();
                this.lastTime = System.currentTimeMillis();
                break;
            }
            case 7: {
                this.app.enableTickEvents(0L);
                this.freeResources();
                return false;
            }
            case 3: {
                this.tick();
                this.app.invalidateScreen();
                break;
            }
            case 1: {
                MagmicGraphics magmicGraphics = (MagmicGraphics)object;
                this.paint(magmicGraphics.getGraphics());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.lastTime = System.currentTimeMillis();
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                return true;
            }
        }
        return this.state != 3;
    }

    public int getState() {
        return this.state;
    }

    public void initMagmicSplash() {
        Image image;
        Image image2;
        block5: {
            block4: {
                this.c2m_delay = System.currentTimeMillis();
                try {
                    this.c2m = Image.createImage((String)"/c2m_splash.png");
                }
                catch (Exception exception) {
                    if (this.c2m != null) break block4;
                    return;
                }
            }
            image2 = null;
            image = null;
            try {
                image = MagmicImage.loadMagmicImage("/lib-intro_magmic_logo.png").getNativeFormat();
                image2 = MagmicImage.loadMagmicImage("/lib-intro_bg.png").getNativeFormat();
            }
            catch (Exception exception) {
                if (image != null) break block5;
                return;
            }
        }
        this.loadMagmicSplash(image2, image);
    }

    private void loadMagmicSplash(Image image, Image image2) {
        int n;
        int n2;
        int n3;
        this.bgImage = image;
        this.magmicImage = image2;
        this.screenWidth = this.app.getWidth();
        this.screenHeight = this.app.getHeight();
        this.magmicImage_width = this.magmicImage.getWidth();
        this.magmicImage_height = this.magmicImage.getHeight();
        this.numRows = this.magmicImage_height / 8;
        this.numCols = this.magmicImage_width / 8;
        this.tileList = new int[this.numRows * this.numCols];
        for (n3 = 0; n3 < this.tileList.length; ++n3) {
            this.tileList[n3] = n3;
        }
        this.visibleTileList = new boolean[this.numRows * this.numCols];
        for (n3 = 0; n3 < this.visibleTileList.length; ++n3) {
            this.visibleTileList[n3] = false;
        }
        Random random = new Random();
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < this.tileList.length; ++n) {
                int n4 = n + (random.nextInt() & Integer.MAX_VALUE) % (this.tileList.length - n);
                int n5 = this.tileList[n4];
                this.tileList[n4] = this.tileList[n];
                this.tileList[n] = n5;
            }
        }
        n2 = this.screenWidth / 32 * 32;
        n = this.screenHeight / 32 * 32;
        this.COL_BUFFER = (this.screenWidth - n2) / 2;
        this.ROW_BUFFER = (this.screenHeight - n) / 2;
        this.numToAdd = 1;
    }

    public void tick() {
        if (System.currentTimeMillis() - this.c2m_delay > 2000L) {
            long l = System.currentTimeMillis();
            this.deltaTime += (int)(l - this.lastTime);
            this.lastTime = l;
            switch (this.state) {
                case 0: {
                    this.initMagmicSplash();
                    this.setBuffer(Image.createImage((int)this.app.getWidth(), (int)this.app.getHeight()));
                    this.deltaTime = 0;
                    this.state = 1;
                    break;
                }
                case 1: {
                    try {
                        while (this.deltaTime > 50) {
                            this.deltaTime -= 50;
                            for (int i = 0; i < this.numToAdd; ++i) {
                                if (this.tileIndex >= this.tileList.length) {
                                    this.state = 2;
                                    this.stateDeltaTime = 0;
                                    break;
                                }
                                int n = this.tileList[this.tileIndex++];
                                this.visibleTileList[n] = true;
                            }
                            ++this.numToAdd;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case 2: {
                    this.stateDeltaTime += this.deltaTime;
                    this.deltaTime = 0;
                    if (this.stateDeltaTime <= 1500) break;
                    this.state = 3;
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        if (System.currentTimeMillis() - this.c2m_delay < 2000L) {
            graphics.drawImage(this.c2m, this.screenWidth / 2, this.screenHeight / 2, 3);
            this.lastTime = System.currentTimeMillis();
        } else {
            if (this.buffer == null) {
                return;
            }
            graphics.drawImage(this.buffer, 0, 0, 20);
            for (int i = 0; i < this.visibleTileList.length; ++i) {
                if (!this.visibleTileList[i]) continue;
                int n = this.tileList[i];
                int n2 = n % this.numCols * 8;
                int n3 = n / this.numCols * 8;
                this.drawImage(graphics, this.magmicImage, (this.screenWidth - this.magmicImage_width >> 1) + n2, (this.screenHeight - this.magmicImage_height >> 1) + n3, 8, 8, n2, n3);
            }
        }
    }

    public void drawBackground(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        int n = this.screenWidth / 32;
        int n2 = this.screenHeight / 32;
        int n3 = 0;
        int n4 = 0;
        if (this.bgImage != null) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n5 = this.COL_BUFFER + j * 32;
                    int n6 = this.ROW_BUFFER + i * 32;
                    n4 = i == n2 - 1 ? 64 : (i == 0 ? 0 : 32);
                    n3 = j == n - 1 ? 64 : (j == 0 ? 0 : 32);
                    this.drawImage(graphics, this.bgImage, n5, n6, 32, 32, n3, n4);
                }
            }
        }
    }

    public void setBuffer(Image image) {
        this.buffer = image;
        Graphics graphics = image.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        this.drawBackground(graphics);
    }

    public Image getBuffer() {
        return this.buffer;
    }

    private void drawImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        graphics.setClip(n, n2, n3, n4);
        graphics.drawImage(image, n - n5, n2 - n6, 20);
        graphics.setClip(n7, n8, n9, n10);
    }

    public void freeResources() {
        this.buffer = null;
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

