/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.slic;

import com.magmic.maglet.Maglet;
import com.magmic.slic.ProgramCallback;
import com.magmic.slic.ResInfo;
import com.magmic.slic.Spr;
import com.magmic.slic.SprInfo;
import com.magmic.ui.MagmicImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Slic {
    public static final int SLIC_NULL_RES_INFO_ID = 0;
    public static final int SLIC_NULL_SPR_INFO_ID = 0;
    public static final int SLIC_NULL_IMAGE_ID = 0;
    public static final int SLIC_OPTION_AUTO_CLEANUP_INFOS = 0;
    private boolean option_auto_cleanup_infos = false;
    private ProgramCallback prgCallback;
    MagmicImage[] images;
    private int[] imageRef;
    private String[] imageFiles;
    ResInfo[] resInfo;
    private int[] resInfoRefCount;
    private SprInfo[] sprInfo;
    private int[] sprInfoRefCount;
    private int loadedPixels = 0;

    public Slic(String string) throws IOException {
        this.readIndexFile(string);
    }

    public Slic(InputStream inputStream) throws IOException {
        this.readIndexFile(inputStream);
    }

    public void cleanup() {
        int n;
        if (this.sprInfo != null) {
            for (n = 0; n < this.sprInfo.length; ++n) {
                if (n == 0 || this.sprInfoRefCount[n] != 0) continue;
                this.destroySprInfo(n);
            }
        }
        if (this.resInfo != null) {
            for (n = 0; n < this.resInfo.length; ++n) {
                if (n == 0 || this.resInfoRefCount[n] != 0) continue;
                this.destroyResInfo(n);
            }
        }
        if (this.images != null) {
            for (n = 0; n < this.images.length; ++n) {
                if (n == 0 || this.images[n] == null || this.imageRef[n] != 0) continue;
                this.destroyImage(n);
            }
        }
    }

    private void readIndexFile(InputStream inputStream) throws IOException {
        int n;
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        short s = dataInputStream.readShort();
        this.images = new MagmicImage[s + 1];
        this.imageRef = new int[s + 1];
        this.imageFiles = new String[s + 1];
        for (n2 = 1; n2 < s + 1; ++n2) {
            this.imageFiles[n2] = dataInputStream.readUTF();
        }
        n2 = dataInputStream.readShort();
        this.resInfo = new ResInfo[n2 + 1];
        this.resInfoRefCount = new int[n2 + 1];
        for (n = 1; n < n2 + 1; ++n) {
            String string = dataInputStream.readUTF();
            this.resInfo[n] = new ResInfo(string);
        }
        n = dataInputStream.readShort();
        this.sprInfo = new SprInfo[n + 1];
        this.sprInfoRefCount = new int[n + 1];
        for (int i = 1; i < n + 1; ++i) {
            String string = dataInputStream.readUTF();
            this.sprInfo[i] = new SprInfo(string);
        }
    }

    public int getNumImages() {
        return this.images == null ? 0 : this.images.length - 1;
    }

    public int getNumSprites() {
        return this.sprInfo == null ? 0 : this.sprInfo.length - 1;
    }

    public int getNumRes() {
        return this.resInfo == null ? 0 : this.resInfo.length - 1;
    }

    public int getNumImageRef(int n) {
        return this.imageRef == null || n == 0 ? 0 : this.imageRef[n];
    }

    public int getNumResRef(int n) {
        return this.resInfo == null || n == 0 ? 0 : this.resInfoRefCount[n];
    }

    public int getNumSprRef(int n) {
        return this.sprInfo == null || n == 0 ? 0 : this.sprInfoRefCount[n];
    }

    private void readIndexFile(String string) throws IOException {
        Maglet.getInstance();
        InputStream inputStream = Maglet.getResourceInputStream(string);
        if (inputStream == null) {
            throw new IOException("File not found: " + string);
        }
        this.readIndexFile(inputStream);
    }

    public void destroy() {
        this.images = null;
        this.imageRef = null;
        this.imageFiles = null;
        this.resInfo = null;
        this.sprInfo = null;
        this.prgCallback = null;
    }

    void prgCb(Spr spr, int n, int n2, short[] sArray) {
        if (this.prgCallback != null) {
            this.prgCallback.slicProgramCallback(spr, n, n2, sArray);
        }
    }

    public void setOption(int n, int n2) {
        switch (n) {
            case 0: {
                this.option_auto_cleanup_infos = n2 != 0;
            }
        }
    }

    public void setProgramCallback(ProgramCallback programCallback, Object object) {
        this.prgCallback = programCallback;
    }

    MagmicImage getImage(int n) {
        if (n == 0) {
            return null;
        }
        if (this.images[n] == null) {
            this.images[n] = MagmicImage.loadMagmicImage(this.imageFiles[n]);
            int n2 = this.images[n].getWidth() * this.images[n].getHeight();
            this.loadedPixels += n2;
        }
        int n3 = n;
        this.imageRef[n3] = this.imageRef[n3] + 1;
        return this.images[n];
    }

    void releaseImage(int n) {
        if (this.images[n] != null) {
            int n2 = n;
            this.imageRef[n2] = this.imageRef[n2] - 1;
            if (this.imageRef[n2] <= 0) {
                this.imageRef[n] = 0;
                if (this.option_auto_cleanup_infos) {
                    this.destroyImage(n);
                }
            }
        }
    }

    void destroyImage(int n) {
        int n2 = this.images[n].getWidth() * this.images[n].getHeight();
        this.loadedPixels -= n2;
        this.images[n] = null;
    }

    MagmicImage getImageFromResInfo(int n) {
        return this.images[this.resInfo[n].imageID];
    }

    ResInfo getResInfo(int n) {
        if (n == 0) {
            return null;
        }
        try {
            if (!this.resInfo[n].initialized) {
                this.resInfo[n].create(this);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        int n2 = n;
        this.resInfoRefCount[n2] = this.resInfoRefCount[n2] + 1;
        return this.resInfo[n];
    }

    void releaseResInfo(int n) {
        if (n == 0) {
            return;
        }
        if (this.resInfo[n].initialized) {
            int n2 = n;
            this.resInfoRefCount[n2] = this.resInfoRefCount[n2] - 1;
            if (this.resInfoRefCount[n] == 0 && this.option_auto_cleanup_infos) {
                this.destroyResInfo(n);
            }
        }
    }

    void destroyResInfo(int n) {
        if (n == 0) {
            return;
        }
        this.releaseImage(this.resInfo[n].imageID);
        this.resInfo[n].destroy();
    }

    SprInfo getSprInfo(int n) {
        if (n == 0) {
            return null;
        }
        try {
            if (!this.sprInfo[n].initialized) {
                this.sprInfo[n].create(this);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        int n2 = n;
        this.sprInfoRefCount[n2] = this.sprInfoRefCount[n2] + 1;
        return this.sprInfo[n];
    }

    void releaseSprInfo(int n) {
        if (n == 0) {
            return;
        }
        if (this.sprInfo[n].initialized) {
            int n2 = n;
            this.sprInfoRefCount[n2] = this.sprInfoRefCount[n2] - 1;
            if (this.sprInfoRefCount[n] == 0 && this.option_auto_cleanup_infos) {
                this.destroySprInfo(n);
            }
        }
    }

    void destroySprInfo(int n) {
        if (n == 0) {
            return;
        }
        SprInfo sprInfo = this.sprInfo[n];
        if (sprInfo.initialized) {
            for (int i = 0; i < sprInfo.progs.length; ++i) {
                int n2 = sprInfo.frameCutID[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.releaseResInfo(sprInfo.frameResID[i][j]);
                }
            }
            sprInfo.destroy();
        }
    }
}

