/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.net;

import com.magmic.maglet.Maglet;
import com.magmic.net.NetClientListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;

public final class NetClient
implements Runnable {
    private static final int MAGMIC_BUILD_NUMBER = 0;
    private static final int MAGMIC_CHANNEL_ID = 0;
    private static final int MAGMIC_PLATFORM_ID = 0;
    public static final String PROTOCOL_VER = "2.6";
    public static final int RMS_VERSION = 1;
    public static final String NETCLIENT_DATA = "N";
    private static final String DEFAULT_LOCALE_STRING = "en_US";
    private static final int RESP_OK = 200;
    public static final byte SUCCESS = 100;
    public static final byte ERR_INVALID_REQUEST = 0;
    public static final byte ERR_INVALID_SESSION = 1;
    public static final byte ERR_INVALID_GAMEID = 2;
    public static final byte ERR_INVALID_USERNAME = 3;
    public static final byte ERR_NAME_PSWD = 4;
    public static final byte ERR_NAME_IN_USE = 5;
    public static final byte ERR_TRANSPORT = 6;
    public static final byte ERR_LOGIN = 7;
    public static final byte ERR_INVALID_EMAIL = 8;
    public static final byte ERR_SECURITY = 9;
    public static final byte ERR_CONCURRANT_REQUEST = 10;
    public static final byte ERR_GUEST_NOT_ALLOWED = 11;
    public static final byte ERR_NO_AVATAR_FOUND = 12;
    public static final byte ERR_ANONYMOUS_PROHIBITED = 13;
    public static final byte ERR_USER_SUSPENDED = 14;
    public static final byte PAK_NONE = 0;
    public static final byte PAK_CREATE_ACCOUNT = 1;
    public static final byte PAK_LOGIN = 2;
    public static final byte PAK_DATA = 3;
    public static final byte PAK_ERROR = 4;
    public static final byte PAK_TELL_FRIEND = 5;
    public static final byte PAK_GET_AVATAR = 6;
    public static final byte PAK_GET_BUDDYS = 7;
    public static final byte PAK_ADD_BUDDY = 8;
    public static final byte PAK_REMOVE_BUDDY = 9;
    public static final byte PAK_GET_MSG = 10;
    public static final byte PAK_GET_TOP_MSG = 11;
    public static final byte PAK_GET_AVAIL_MSGS = 12;
    public static final byte PAK_GET_MULTIPLE_AVATARS = 13;
    public static final byte PAK_ANONYMOUS_REQUEST = 127;
    public static final byte BROADCAST_LOC_WELCOME = 1;
    public static final byte BROADCAST_LOC_NEWS = 2;
    public static final byte CONTENT_TEXT = 1;
    public static final byte CONTENT_HTML = 2;
    public static final byte CONTENT_XML = 3;
    public static final byte CONTENT_IMAGE = 4;
    public static final byte GEN_GET_TOP_SCORES = 13;
    public static final byte GEN_GET_USER_SCORES = 14;
    public static final byte GEN_GET_MULTIPLE_SCORES = 15;
    public static final byte GEN_SUBMIT_SCORE = 16;
    public static final byte GEN_GET_ASSET_DOWNLOAD_LIST = 50;
    public static final byte GEN_GET_UPDATED_ASSET_LIST = 51;
    public static final byte GEN_GET_ASSET_DOWNLOAD = 52;
    public static final byte GEN_UPLOAD_ASSET_DOWNLOAD = 53;
    public static final byte GEN_GET_CURRENT_TIMED_ASSET = 54;
    public static final byte GEN_SUBMIT_ASSET_SCORE = 55;
    public static final byte GEN_GET_TOP_ASSET_SCORES = 56;
    public static final byte GEN_GET_USER_ASSET_SCORES = 57;
    public static final byte GEN_GET_BINARY_DATA_BY_ID = 58;
    public static final byte GEN_GET_BINARY_DATA_BY_NAME = 59;
    public static final byte GEN_GET_BINARY_DATA_LIST = 60;
    public static final byte GEN_SUBMIT_NEW_BINARY_DATA = 61;
    public static final byte GEN_UPDATE_BINARY_DATA = 62;
    public static final int GENERR_ERROR_OCCURRED = -20;
    public static final int GENERR_INVALID_ASSET_ID = -21;
    public static final int GENERR_ASSET_EXPIRED = -22;
    public static final int GENERR_ASSET_NOT_FOUND = -23;
    public static final int GENERR_NAME_UNIQUE = -24;
    private final Object MUTEX = new Object();
    private NetClientListener listener;
    private String username;
    private String password;
    private String email;
    private long nextPoll;
    private String sessionID;
    private int gameID = 10090;
    private String otherAlias;
    private int maxBytes = -1;
    private int avatarHeight = 15;
    private int avatarWidth = 15;
    private int avatarID = 0;
    private int otherUserID = 0;
    private String locale = null;
    private int numElements = 0;
    private boolean anonymous;
    private long msgID;
    private byte msgContentType;
    private String msgText;
    private String msgTitle;
    private String msgURL;
    private byte msgLocID;
    private int msgImgWidth;
    private int msgImgHeight;
    private boolean friend;
    private boolean buddyResult;
    private byte[] data;
    private DataOutputStream dout;
    private byte curRequest = 0;
    private byte packetID = 0;
    private boolean isLoggedIn;
    private boolean isAGuest;
    private volatile boolean requestPending;
    private int resp;
    private HttpConnection http;
    private Object returnData;
    public static String SERVER;
    private int runCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(NetClientListener netClientListener) {
        Object object = this.MUTEX;
        synchronized (object) {
            this.listener = netClientListener;
        }
    }

    public void setUsername(String string) {
        if (string == null) {
            string = "";
        }
        this.username = string;
    }

    public String getUsername() {
        if (this.isAGuest) {
            return "";
        }
        return this.username;
    }

    public void setPassword(String string) {
        if (string == null) {
            string = "";
        }
        this.password = string;
    }

    public String getPassword() {
        if (this.isAGuest) {
            return "";
        }
        return this.password;
    }

    public void setEmail(String string) {
        if (string == null) {
            string = "";
        }
        this.email = string;
    }

    public String getEmail() {
        if (this.isAGuest) {
            return "Guest";
        }
        return this.email;
    }

    public long getNextPoll() {
        return this.nextPoll;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setOtherAlias(String string) {
        this.otherAlias = string;
    }

    public String getOtherAlias() {
        return this.otherAlias;
    }

    public void setMaxBytes(int n) {
        this.maxBytes = n;
    }

    public void setAvatarHeight(int n) {
        this.avatarHeight = n;
    }

    public void setAvatarWidth(int n) {
        this.avatarWidth = n;
    }

    public int getAvatarID() {
        return this.avatarID;
    }

    private void setOtherUserID(int n) {
        this.otherUserID = n;
    }

    public String getLocaleString() {
        if (this.locale == null || this.locale.length() == 0) {
            return DEFAULT_LOCALE_STRING;
        }
        return this.locale;
    }

    public void setLocaleString(String string) {
        if (string != null && string.length() > 0) {
            this.locale = string;
        }
    }

    public int getNumberElments() {
        return this.numElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultipleAvatarData(Object object, int n, int n2, int n3) {
        String[] stringArray = null;
        int[] nArray = null;
        boolean bl = false;
        this.numElements = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (object instanceof int[]) {
                nArray = (int[])object;
                if (nArray != null && nArray.length > 0) {
                    this.numElements = nArray.length;
                }
            } else if (object instanceof String[] && (stringArray = (String[])object) != null && stringArray.length > 0) {
                this.numElements = stringArray.length;
                bl = true;
            }
            if (this.numElements > 0) {
                this.dout = new DataOutputStream(byteArrayOutputStream);
                if (n3 > 0) {
                    this.setMaxBytes(n3);
                }
                if (n > 0) {
                    this.setAvatarWidth(n);
                }
                if (n2 > 0) {
                    this.setAvatarHeight(n2);
                }
                this.dout.writeInt(this.maxBytes);
                this.dout.writeInt(this.avatarWidth);
                this.dout.writeInt(this.avatarHeight);
                this.dout.writeInt(this.numElements);
                this.dout.writeBoolean(bl);
                for (int i = 0; i < this.numElements; ++i) {
                    if (bl) {
                        this.dout.writeUTF(stringArray[i]);
                        continue;
                    }
                    this.dout.writeInt(nArray[i]);
                }
                this.dout.close();
                this.setData(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {
            this.data = null;
        }
        finally {
            this.dout = null;
            byteArrayOutputStream = null;
        }
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean bl) {
        this.anonymous = bl;
    }

    public long getMsgID() {
        return this.msgID;
    }

    public void setMsgID(int n) {
        this.msgID = n;
    }

    public byte getMsgContentType() {
        return this.msgContentType;
    }

    public void setMsgContentType(byte by) {
        this.msgContentType = by;
    }

    public String getMsgText() {
        return this.msgText;
    }

    public String getMsgTitle() {
        return this.msgTitle;
    }

    public String getMsgURL() {
        return this.msgURL;
    }

    public byte getMsgLocID() {
        return this.msgLocID;
    }

    public void setMsgLocID(byte by) {
        this.msgLocID = by;
    }

    public int getMsgImgWidth() {
        return this.msgImgWidth;
    }

    public void setMsgImgWidth(int n) {
        this.msgImgWidth = n;
    }

    public int getMsgImgHeight() {
        return this.msgImgHeight;
    }

    public void setMsgImgHeight(int n) {
        this.msgImgHeight = n;
    }

    public boolean isFriend() {
        return this.friend;
    }

    public void setFriend(boolean bl) {
        this.friend = bl;
    }

    public boolean isbuddyResult() {
        return this.buddyResult;
    }

    public void setData(byte[] byArray) {
        if (this.requestPending) {
            throw new IllegalStateException();
        }
        this.data = byArray;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public boolean isAGuest() {
        return this.isAGuest;
    }

    public void setIsAGuest(boolean bl) {
        this.isAGuest = bl;
    }

    public boolean isRequestPending() {
        return this.requestPending;
    }

    public NetClient(NetClientListener netClientListener) {
        this.listener = netClientListener;
        SERVER = Maglet.getInstance().getApplicationProperty("Magmic-GameServer");
        if (SERVER == null) {
            SERVER = "http://gameserver.magmic.com/gameserver/gateway";
        }
        this.readFromRMS();
        new Thread(this).start();
    }

    public NetClient(NetClientListener netClientListener, String string) {
        this.listener = netClientListener;
        SERVER = null;
        if (SERVER == null) {
            SERVER = "http://gameserver.magmic.com/gameserver/gateway";
        }
        this.readFromRMS();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(byte by) {
        if (this.requestPending) {
            this.listener.netClientEvent(by, 10, null);
            return;
        }
        switch (by) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (this.isLoggedIn || this.isAnonymous()) break;
                this.listener.netClientEvent(by, 7, null);
                return;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.listener.netClientEvent(by, 0, null);
                return;
            }
        }
        Object object = this.MUTEX;
        synchronized (object) {
            this.curRequest = by;
            this.requestPending = true;
            this.MUTEX.notify();
        }
    }

    public final boolean readFromRMS() {
        try {
            boolean bl = false;
            RecordStore recordStore = RecordStore.openRecordStore((String)NETCLIENT_DATA, (boolean)false);
            if (recordStore.getNumRecords() == 0) {
                bl = false;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.enumerateRecords(null, null, false).nextRecord());
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.loadState(dataInputStream);
                dataInputStream.close();
                dataInputStream = null;
                byteArrayInputStream.close();
                byteArrayInputStream = null;
                bl = true;
            }
            recordStore.closeRecordStore();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void loadState(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.isLoggedIn = dataInputStream.readBoolean();
        if (this.isLoggedIn) {
            this.username = dataInputStream.readUTF();
            this.password = dataInputStream.readUTF();
            this.sessionID = dataInputStream.readUTF();
            this.isAGuest = dataInputStream.readBoolean();
        }
        this.readInt(dataInputStream);
    }

    public final boolean writeToRMS() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.saveState(dataOutputStream);
            RecordStore recordStore = RecordStore.openRecordStore((String)NETCLIENT_DATA, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                byte[] byArray = byteArrayOutputStream.toByteArray();
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                int n = recordStore.enumerateRecords(null, null, false).nextRecordId();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                recordStore.setRecord(n, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            dataOutputStream.close();
            dataOutputStream = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void saveState(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(1);
        dataOutputStream.writeBoolean(this.isLoggedIn);
        if (this.isLoggedIn) {
            dataOutputStream.writeUTF(this.username);
            dataOutputStream.writeUTF(this.password);
            dataOutputStream.writeUTF(this.sessionID);
            dataOutputStream.writeBoolean(this.isAGuest);
        }
        dataOutputStream.writeInt(this.gameID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.runCount++ > 0) {
            return;
        }
        boolean bl = true;
        while (bl) {
            NetClientListener netClientListener = null;
            try {
                Object object = this.MUTEX;
                synchronized (object) {
                    while (!this.requestPending) {
                        this.MUTEX.wait();
                    }
                    netClientListener = this.listener;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            try {
                this.sendRequest(this.curRequest);
                this.getResponse(this.curRequest);
            }
            catch (IOException iOException) {
                if (this.resp == 100 || this.resp == 0 || this.resp == 200) {
                    this.resp = 6;
                }
                this.resp = 6;
            }
            catch (SecurityException securityException) {
                this.resp = 9;
            }
            catch (Throwable throwable) {
                this.resp = 6;
            }
            this.requestPending = false;
            try {
                netClientListener.netClientEvent(this.curRequest, this.resp, this.returnData);
            }
            catch (Throwable throwable) {}
        }
    }

    private void sendRequest(byte by) throws Exception {
        this.sendHeaders(by);
        this.sendBody(by);
        this.sendFooter(by);
    }

    private void sendHeaders(byte by) throws Exception {
        this.http = (HttpConnection)Connector.open((String)SERVER, (int)3, (boolean)true);
        this.http.setRequestMethod("POST");
        this.dout = this.http.openDataOutputStream();
        this.dout.writeUTF(PROTOCOL_VER);
        this.dout.writeUTF(this.getLocaleString());
        this.dout.write(1);
        if (this.isAnonymous()) {
            this.dout.write(127);
        }
        this.dout.write(by);
        byte by2 = this.packetID;
        this.packetID = (byte)(by2 + 1);
        this.dout.write(by2);
        switch (by) {
            case 1: 
            case 2: {
                this.invalidAnonymous();
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.invalidAnonymous();
            }
            case 3: 
            case 6: 
            case 13: {
                this.dout.writeUTF(this.isAnonymous() ? "" : this.sessionID);
                this.dout.writeInt(this.gameID);
                break;
            }
        }
    }

    private void sendBody(byte by) throws Exception {
        switch (by) {
            case 1: {
                this.dout.writeInt(0);
                this.dout.writeInt(0);
                this.dout.writeInt(this.gameID);
                this.dout.writeInt(0);
                this.dout.writeByte(this.isAGuest ? 1 : 0);
                if (this.isAGuest) break;
                this.dout.writeUTF(this.username);
                this.dout.writeUTF(this.password);
                this.dout.writeUTF(this.email == null ? "" : this.email);
                break;
            }
            case 2: {
                this.dout.writeInt(0);
                this.dout.writeInt(0);
                this.dout.writeInt(this.gameID);
                this.dout.writeInt(0);
                this.dout.writeUTF(this.username);
                this.dout.writeUTF(this.password);
                break;
            }
            case 3: {
                if (!this.isLoggedIn && !this.isAnonymous()) {
                    this.resp = 7;
                    throw new IOException("Must be logged in to send data");
                }
                this.dout.writeInt(0);
                this.dout.writeInt(this.data.length);
                if (this.data.length <= 0) break;
                this.dout.write(this.data, 0, this.data.length);
                break;
            }
            case 5: {
                this.dout.writeInt(0);
                this.dout.writeUTF(this.email == null ? "" : this.email);
                break;
            }
            case 6: {
                this.dout.writeInt(0);
                if (this.otherUserID != 0) {
                    this.dout.writeBoolean(false);
                    this.dout.writeInt(this.otherUserID);
                } else {
                    this.dout.writeBoolean(true);
                    this.dout.writeUTF(this.otherAlias == null ? "" : this.otherAlias);
                }
                this.dout.writeInt(this.maxBytes);
                this.dout.writeInt(this.avatarWidth);
                this.dout.writeInt(this.avatarHeight);
                break;
            }
            case 13: {
                if (this.data == null || this.data.length <= 0) {
                    this.resp = 12;
                    throw new IOException("No users passed in to retrieve avatars for");
                }
                this.dout.writeInt(0);
                this.dout.write(this.data, 0, this.data.length);
                break;
            }
            case 7: {
                this.dout.writeInt(0);
                this.dout.writeBoolean(this.friend);
                break;
            }
            case 8: 
            case 9: {
                this.dout.writeInt(0);
                this.dout.writeBoolean(this.friend);
                this.dout.writeUTF(this.otherAlias == null ? "" : this.otherAlias);
                break;
            }
            case 11: 
            case 12: {
                if (this.getMsgContentType() >= 1 && this.getMsgContentType() <= 4 && this.getMsgLocID() >= 1) {
                    this.dout.writeInt(0);
                    this.dout.writeByte(this.getMsgLocID());
                    this.dout.writeByte(this.getMsgContentType());
                    this.dout.writeInt(this.getMsgImgWidth());
                    this.dout.writeInt(this.getMsgImgHeight());
                    break;
                }
                throw new IOException("Invalid message display location / content type");
            }
            case 10: {
                if (this.getMsgContentType() >= 1 && this.getMsgContentType() <= 4 && this.getMsgLocID() >= 1) {
                    this.dout.writeInt(0);
                    this.dout.writeByte(this.getMsgContentType());
                    this.dout.writeLong(this.getMsgID());
                    this.dout.writeInt(this.getMsgImgWidth());
                    this.dout.writeInt(this.getMsgImgHeight());
                    break;
                }
                throw new IOException("Must provide message display location and content type");
            }
        }
    }

    private void sendFooter(byte by) throws Exception {
        this.dout.close();
        this.dout = null;
    }

    private void getResponse(byte by) throws Exception {
        int n = -1;
        this.returnData = null;
        this.numElements = 0;
        this.setAnonymous(false);
        try {
            this.resp = this.http.getResponseCode();
        }
        catch (IOException iOException) {
            this.resp = 6;
        }
        catch (SecurityException securityException) {
            this.resp = 9;
        }
        if (this.resp == 200) {
            this.resp = 100;
            DataInputStream dataInputStream = this.http.openDataInputStream();
            this.nextPoll = this.readInt(dataInputStream);
            if (this.nextPoll > 0L) {
                this.nextPoll += System.currentTimeMillis();
            }
            int n2 = dataInputStream.read();
            switch (n2) {
                case 1: 
                case 2: {
                    this.sessionID = dataInputStream.readUTF();
                    if (dataInputStream.readByte() == 10) {
                        this.msgContentType = dataInputStream.readByte();
                        this.msgID = dataInputStream.readLong();
                        this.msgTitle = dataInputStream.readUTF();
                        this.msgText = dataInputStream.readUTF();
                    }
                    this.isLoggedIn = true;
                    this.writeToRMS();
                    break;
                }
                case 3: 
                case 7: {
                    int n3 = dataInputStream.readInt();
                    byte[] byArray = new byte[n3];
                    dataInputStream.readFully(byArray);
                    this.returnData = byArray;
                    byArray = null;
                    break;
                }
                case 13: {
                    this.numElements = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    byte[] byArray = new byte[n4];
                    dataInputStream.readFully(byArray);
                    this.returnData = byArray;
                    byArray = null;
                    break;
                }
                case 6: {
                    this.avatarID = dataInputStream.readInt();
                    int n5 = dataInputStream.readInt();
                    byte[] byArray = new byte[n5];
                    dataInputStream.readFully(byArray);
                    this.returnData = byArray;
                    byArray = null;
                    break;
                }
                case 8: 
                case 9: {
                    dataInputStream.readInt();
                    this.buddyResult = dataInputStream.readBoolean();
                    break;
                }
                case 4: {
                    this.resp = this.readInt(dataInputStream);
                    byte by2 = dataInputStream.readByte();
                    this.logout();
                    break;
                }
                case 10: 
                case 11: {
                    this.msgContentType = dataInputStream.readByte();
                    this.msgID = dataInputStream.readLong();
                    if (this.msgID <= 0L) break;
                    this.msgTitle = dataInputStream.readUTF();
                    this.msgText = dataInputStream.readUTF();
                    this.msgURL = dataInputStream.readUTF();
                    this.msgImgWidth = dataInputStream.readInt();
                    this.msgImgHeight = dataInputStream.readInt();
                    int n6 = dataInputStream.readInt();
                    if (n6 <= 0) break;
                    byte[] byArray = new byte[n6];
                    dataInputStream.readFully(byArray);
                    this.returnData = byArray;
                    byArray = null;
                    break;
                }
                case 12: {
                    int n7 = dataInputStream.readInt();
                    this.numElements = dataInputStream.readInt();
                    if (this.numElements <= 0 || n7 <= 4) break;
                    byte[] byArray = new byte[n7 -= 4];
                    dataInputStream.readFully(byArray);
                    this.returnData = byArray;
                    byArray = null;
                }
            }
            try {
                dataInputStream.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            dataInputStream = null;
        } else {
            this.resp = 6;
        }
        try {
            this.http.close();
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.http = null;
    }

    private int readInt(InputStream inputStream) throws IOException {
        return (inputStream.read() & 0xFF) << 24 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
    }

    public void logout() {
        this.username = null;
        this.password = null;
        this.email = null;
        this.isLoggedIn = false;
        this.isAGuest = false;
        this.sessionID = null;
        this.avatarHeight = 15;
        this.avatarWidth = 15;
        this.otherUserID = 0;
        this.avatarID = 0;
        this.maxBytes = -1;
        this.otherAlias = null;
        this.msgID = -1L;
        this.msgContentType = (byte)-1;
        this.msgLocID = (byte)-1;
        this.writeToRMS();
    }

    public static String respToString(int n) {
        switch (n) {
            case 0: {
                return "Invalid Request";
            }
            case 1: {
                return "Invalid Session";
            }
            case 2: {
                return "Invalid Game";
            }
            case 3: {
                return "Username does not exist";
            }
            case 4: {
                return "Invalid Username/Password";
            }
            case 5: {
                return "Username currently in use";
            }
            case 6: {
                return "Network Transmission Error, Please try again";
            }
            case 7: {
                return "User not logged in";
            }
            case 8: {
                return "Invalid email entered";
            }
            case 9: {
                return "Security Error";
            }
            case 10: {
                return "Too many concurrent requests";
            }
            case 11: {
                return "This action prohibited for guests";
            }
            case 12: {
                return "No avatar found";
            }
            case 13: {
                return "You must be logged in";
            }
            case 14: {
                return "User is suspended";
            }
            case 100: {
                return "Operation Completed";
            }
        }
        return "Unknown Error Occured";
    }

    public static String typeToString(int n) {
        switch (n) {
            case 0: {
                return "PAK_NONE";
            }
            case 1: {
                return "PAK_CREATE_ACCOUNT";
            }
            case 2: {
                return "PAK_LOGIN";
            }
            case 3: {
                return "PAK_DATA";
            }
            case 4: {
                return "PAK_ERROR";
            }
            case 5: {
                return "PAK_TELL_FRIEND";
            }
            case 6: {
                return "PAK_GET_AVATAR";
            }
            case 10: {
                return "PAK_GET_MSG";
            }
            case 11: {
                return "PAK_GET_TOP_MSG";
            }
            case 12: {
                return "PAK_GET_AVAIL_MSGS";
            }
            case 13: {
                return "PAK_GET_MULTIPLE_AVATARS";
            }
            case 127: {
                return "PAK_ANONYMOUS_REQUEST";
            }
        }
        return "unknown type";
    }

    private void invalidAnonymous() throws IOException {
        if (this.isAnonymous()) {
            this.resp = 13;
            throw new IOException(NetClient.respToString(13));
        }
    }

    public static boolean isEmailValid(char[] cArray) {
        int n;
        int n2 = 0;
        String string = "()<>@,;:\\\"[]";
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == '\"' && (n == 0 || cArray[n - 1] == '.' || cArray[n - 1] == '\"')) {
                while (++n < cArray.length && cArray[n] != '\"') {
                    if (cArray[n] == '\\' && cArray[++n] == ' ' || cArray[n] > ' ' && cArray[n] < '\u007f') continue;
                    return false;
                }
                if (n++ > cArray.length) {
                    return false;
                }
                if (cArray[n] == '@') break;
                if (cArray[n] == '.') continue;
                return false;
            }
            if (cArray[n] == '@') break;
            if (cArray[n] <= ' ' || cArray[n] >= '\u007f') {
                return false;
            }
            if (string.indexOf(cArray[n]) <= -1) continue;
            return false;
        }
        if (n == 0 || cArray[n - 1] == '.') {
            return false;
        }
        if (++n > cArray.length) {
            return false;
        }
        int n3 = n;
        do {
            if (cArray[n] == '.') {
                if (n == n3 || cArray[n - 1] == '.') {
                    return false;
                }
                ++n2;
            }
            if (cArray[n] <= ' ' || cArray[n] >= '\u007f') {
                return false;
            }
            if (string.indexOf(cArray[n]) <= -1) continue;
            return false;
        } while (++n < cArray.length);
        return n2 >= 1;
    }
}

