/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.ui;

import com.magmic.ui.MagmicGraphics;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class MagmicImage {
    private Image img;
    private int w;
    private int h;

    private MagmicImage() {
    }

    public MagmicImage(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.img = Image.createImage((int)n, (int)n2);
    }

    public MagmicImage(Image image) {
        this.img = image;
        this.w = image.getWidth();
        this.h = image.getHeight();
    }

    private static Image loadNativeImage(String string) {
        Image image;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            return null;
        }
        return image;
    }

    public static MagmicImage loadMagmicImage(String string) {
        MagmicImage magmicImage = new MagmicImage();
        magmicImage.img = MagmicImage.loadNativeImage(string);
        if (magmicImage.img == null) {
            return null;
        }
        magmicImage.w = magmicImage.img.getWidth();
        magmicImage.h = magmicImage.img.getHeight();
        return magmicImage;
    }

    private static Image loadNativeImageFromBytes(byte[] byArray, int n, int n2) {
        Image image;
        try {
            image = Image.createImage((byte[])byArray, (int)n, (int)n2);
        }
        catch (Throwable throwable) {
            return null;
        }
        return image;
    }

    public static MagmicImage loadMagmicImageFromBytes(byte[] byArray, int n, int n2) {
        MagmicImage magmicImage = new MagmicImage();
        magmicImage.img = MagmicImage.loadNativeImageFromBytes(byArray, n, n2);
        if (magmicImage.img == null) {
            return null;
        }
        magmicImage.w = magmicImage.img.getWidth();
        magmicImage.h = magmicImage.img.getHeight();
        return magmicImage;
    }

    private static Image loadNativeMutableImage(String string) {
        int n;
        Image image = MagmicImage.loadNativeImage(string);
        if (image == null) {
            return null;
        }
        int n2 = image.getWidth();
        Image image2 = Image.createImage((int)n2, (int)(n = image.getHeight()));
        if (image2 == null) {
            return null;
        }
        image2.getGraphics().drawImage(image, 0, 0, 20);
        return image2;
    }

    public static MagmicImage loadMutableMagmicImage(String string) {
        MagmicImage magmicImage = new MagmicImage();
        magmicImage.img = MagmicImage.loadNativeMutableImage(string);
        if (magmicImage.img == null) {
            return null;
        }
        magmicImage.w = magmicImage.img.getWidth();
        magmicImage.h = magmicImage.img.getHeight();
        return magmicImage;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void drawRegion(MagmicGraphics magmicGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics graphics = magmicGraphics.getGraphics();
        graphics.drawRegion(this.img, n5, n6, n3, n4, 0, n, n2, 20);
    }

    public void draw(MagmicGraphics magmicGraphics, int n, int n2) {
        Graphics graphics = magmicGraphics.getGraphics();
        graphics.drawImage(this.img, n, n2, 20);
    }

    public MagmicGraphics getGraphics() {
        return new MagmicGraphics(this.img.getGraphics());
    }

    public Image getNativeFormat() {
        return this.img;
    }
}

