/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.DAWGReader;
import com.magmic.Font;
import com.magmic.K;
import com.magmic.MagmicFileIO;
import com.magmic.MagmicGame;
import com.magmic.MagmicIO;
import com.magmic.MagmicStringBuffer;
import com.magmic.Slide;
import com.magmic.Slide2D;
import com.magmic.Window;
import com.magmic.kahuna.Board;
import com.magmic.kahuna.ScoreWindow;
import com.magmic.maglet.Maglet;
import com.magmic.pykegame.FontData;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.slic.Spr;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import java.io.IOException;

public class BoardLayer
extends MagmicLayer {
    public Board board;
    public Font valueFont;
    public Font selectedValueFont;
    public Font statusBarFont;
    public Font tikiPoleFont;
    public DAWGReader dawg;
    public boolean changedInputMode;
    public boolean waitingToShowTut;
    public ScoreWindow scoreWindow;
    public static final int MENU_ITEMS_CAPACITY = 6;
    public int[] menuItems;
    public int inputMenuItemIndex;
    public MagmicStringBuffer word = new MagmicStringBuffer(20);
    public int wordTestResult;
    public boolean wordIsBonusWord;
    public int searchDuration;
    public boolean neverPainted = true;
    public boolean falling = true;
    public boolean solved;
    public int fallingTickDuration = 200;
    public int fallingTickAccumulator;
    public int cursorRow = 0;
    public int cursorCol = 0;
    public static final int MAX_SELECTION = 20;
    public int selectionLength = 0;
    public int[] selectionRow = new int[20];
    public int[] selectionCol = new int[20];
    public byte[][][] chains;
    public int[] chainsSize;
    public int selectedChainIndex;
    public boolean isUsingChains;
    public static final int PPC_MAX_SEARCH_DURATION = 100;
    public static final int MAX_WORD_LENGTH = 20;
    public static final int MAX_WORD_HISTORY_LENGTH = 30;
    public int wordHistoryLength;
    public MagmicStringBuffer[] wordHistory;
    public boolean foundBonusWord;
    public int timeSpent;
    public long lastVolcanoTime;
    public int lastTikiRise;
    public int numberOfFreedFishBeforeSolving;
    public int numberOfFreedFishAfterSolving;
    public int boxW;
    public int boxH;
    public int separatorX;
    public MagmicImage statusBar;
    public int statusBarHeight;
    public MagmicImage bonusWordIndicatorFound;
    public MagmicImage bonusWordIndicatorNotFound;
    public int bonusWordLight;
    public MagmicImage wordValidLight;
    public MagmicImage wordInvalidLight;
    public MagmicImage wordPartialLight;
    public int wordLightWidth;
    public MagmicImage tikiBackground;
    public int tikiBackgroundWidth;
    public MagmicImage tikiPoleBase;
    public MagmicImage tikiPoleTop;
    public MagmicImage tikiPolePart1;
    public MagmicImage tikiPolePart2;
    public MagmicImage tikiPolePart3;
    public MagmicImage tikiTextPlate;
    public Spr cursor;
    public Spr explosion;
    public Slide tikiPercent;
    public Slide score;
    public int guessWordAllowedWidth;
    public Slide guessWordScroll;
    public int clipMinRow;
    public int clipMinCol;
    public int clipMaxRow;
    public int clipMaxCol;
    public boolean clipOnNextPaint;
    public Slide2D[][] letters;
    public boolean[][] explodeFlag;
    public boolean paintExplosions;
    public int saveInterval;
    public int saveTimerAccumulator;
    public int soundBreakStone;
    public int soundBreakMetal;
    public int soundSwap;
    public int soundCompleteWord;
    public int[] soundBomb;
    public int soundNewFish;
    public int soundPartialFish;
    public static final char CHAR_QU = '|';
    public static final int MODE_RELAXED = 0;
    public static final int MODE_ACTIVE = 1;
    public static final int MODE_COUNT = 2;
    public static final int BOARD_MAX_ROW = 10;
    public static final int BOARD_MAX_COL = 13;

    public BoardLayer(MagmicGame magmicGame) {
        super(magmicGame);
        int n;
        int n2;
        this.left_softkey_label = " Back";
        this.right_softkey_label = "Pause ";
        this.dawg = magmicGame.dawg;
        this.wordHistory = new MagmicStringBuffer[30];
        for (n2 = 0; n2 < 30; ++n2) {
            this.wordHistory[n2] = new MagmicStringBuffer(20);
        }
        this.tikiPercent = new Slide();
        this.score = new Slide();
        this.guessWordScroll = new Slide();
        this.letters = new Slide2D[10][13];
        this.explodeFlag = new boolean[10][13];
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 13; ++n) {
                this.letters[n2][n] = new Slide2D();
                this.explodeFlag[n2][n] = false;
            }
        }
        this.chains = new byte[20][50][];
        this.chainsSize = new int[20];
        for (n2 = 0; n2 < 20; ++n2) {
            for (n = 0; n < 50; ++n) {
                this.chains[n2][n] = new byte[n2 + 1];
                this.chainsSize[n2] = 0;
            }
        }
        this.statusBarHeight = 27;
        this.bonusWordLight = 9;
        this.wordLightWidth = 9;
        this.tikiBackgroundWidth = 25;
        this.boxW = 8;
        this.boxH = 8;
    }

    public void init(int n) {
        switch (n) {
            case 0: {
                this.board = new Board();
                this.board.setLetterFrequency("/letterFrequency.bin");
                this.setMode(this.maglet.gameMode);
                this.board.listener = this;
                break;
            }
            case 1: {
                this.maglet.menuWindow.setTitle(this.maglet.systemFont, 26);
                this.maglet.menuWindow.setupMessage(this.maglet.systemFont, null, 0, 0);
                this.maglet.helpWindow.setTitle(this.maglet.systemFont, null);
                this.maglet.helpWindow.setuptNoOptions();
                this.menuItems = new int[6];
                break;
            }
            case 7: {
                if (K.boxFont == K.systemFont) {
                    this.valueFont = this.maglet.systemFont;
                    break;
                }
                FontData fontData = new FontData();
                fontData.init(K.boxFont);
                this.valueFont = new Font(fontData);
                break;
            }
            case 17: {
                FontData fontData = new FontData();
                fontData.init(K.boxFontSelected);
                this.selectedValueFont = new Font(fontData);
                break;
            }
            case 31: {
                if (K.statusFont == K.systemFont) {
                    this.statusBarFont = this.maglet.systemFont;
                    break;
                }
                FontData fontData = new FontData();
                fontData.init(K.statusFont);
                this.statusBarFont = new Font(fontData);
                break;
            }
            case 32: {
                if (K.tikiFont == K.systemFont) {
                    this.tikiPoleFont = this.maglet.systemFont;
                    break;
                }
                FontData fontData = new FontData();
                fontData.init(K.tikiFont);
                this.tikiPoleFont = new Font(fontData);
                break;
            }
            case 33: {
                this.scoreWindow = new ScoreWindow(this.maglet, this, this.statusBarFont);
                this.scoreWindow.init_fully();
                this.scoreWindow.setupFillRect(7558229, 8681573, 1, 5);
                this.scoreWindow.setSizeAndCenter(K.standardWindowWidth, K.standardWindowHeight, K.windowPolicy);
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                this.saveInterval = 10000;
                this.saveTimerAccumulator = 0;
                break;
            }
            case 37: {
                this.soundBreakStone = -1;
                if (K.soundBreakStone == null) break;
                this.soundBreakStone = this.maglet.loadSound(K.soundBreakStone);
                break;
            }
            case 38: {
                this.soundBreakMetal = -1;
                if (K.soundBreakMetal == null) break;
                this.soundBreakMetal = this.maglet.loadSound(K.soundBreakMetal);
                break;
            }
            case 39: {
                this.soundSwap = -1;
                if (K.soundSwap == null) break;
                this.soundSwap = this.maglet.loadSound(K.soundSwap);
                break;
            }
            case 40: {
                this.soundCompleteWord = -1;
                if (K.soundCompleteWord == null) break;
                this.soundCompleteWord = this.maglet.loadSound(K.soundCompleteWord);
                break;
            }
            case 41: {
                this.soundNewFish = -1;
                if (K.soundNewFish == null) break;
                this.soundNewFish = this.maglet.loadSound(K.soundNewFish);
                break;
            }
            case 42: {
                this.soundPartialFish = -1;
                if (K.soundPartialFish == null) break;
                this.soundPartialFish = this.maglet.loadSound(K.soundPartialFish);
                break;
            }
            case 43: {
                this.soundBomb = new int[K.numberOfBombTypes];
                this.soundBomb[0] = -1;
                if (K.soundBomb[0] == null) break;
                this.soundBomb[0] = this.maglet.loadSound(K.soundBomb[0]);
                break;
            }
            case 44: {
                this.soundBomb[1] = -1;
                if (K.soundBomb[1] == null) break;
                this.soundBomb[1] = this.maglet.loadSound(K.soundBomb[1]);
                break;
            }
            case 45: {
                this.soundBomb[2] = -1;
                if (K.soundBomb[2] == null) break;
                this.soundBomb[2] = this.maglet.loadSound(K.soundBomb[2]);
                break;
            }
            case 46: {
                this.soundBomb[3] = -1;
                if (K.soundBomb[3] == null) break;
                this.soundBomb[3] = this.maglet.loadSound(K.soundBomb[3]);
                break;
            }
            case 47: {
                this.soundBomb[4] = -1;
                if (K.soundBomb[4] == null) break;
                this.soundBomb[4] = this.maglet.loadSound(K.soundBomb[4]);
                break;
            }
            case 48: {
                this.soundBomb[5] = -1;
                if (K.soundBomb[5] == null) break;
                this.soundBomb[5] = this.maglet.loadSound(K.soundBomb[5]);
            }
        }
    }

    public int getNumberOfInitSteps() {
        return 49;
    }

    public void destroy() {
        this.maglet.releaseMusic();
        this.maglet.releaseSound(this.soundSwap);
        this.maglet.releaseSound(this.soundCompleteWord);
        this.maglet.releaseSound(this.soundNewFish);
        this.maglet.releaseSound(this.soundPartialFish);
        this.maglet.releaseSound(this.soundBreakStone);
        this.maglet.releaseSound(this.soundBreakMetal);
        for (int i = 0; i < K.numberOfBombTypes; ++i) {
            this.maglet.releaseSound(this.soundBomb[i]);
        }
    }

    public void setMode(int n) {
        this.maglet.gameMode = n;
        switch (n) {
            case 1: {
                this.board.setScoreRules("/timed.scorerules");
                break;
            }
            case 0: {
                this.board.setScoreRules("/relaxed.scorerules");
            }
        }
    }

    public void show() {
        switch (this.maglet.loadMethod) {
            case 1: {
                if (!this.load(this.maglet.fileSystem, 1) || (this.maglet.audioMode & 1) == 0) break;
                this.maglet.loadAndPlayRandomBackgroundMusic();
                break;
            }
            default: {
                if (this.board.readLevel(Maglet.getResourceInputStream(K.getLevelFilename(this.maglet.levelId, this.maglet.gameMode)))) break;
            }
        }
    }

    public boolean pause() {
        return true;
    }

    public boolean resume() {
        this.showMenu();
        return true;
    }

    public void sizeChange() {
        this.scoreWindow.setSizeAndCenter(K.standardWindowWidth, K.standardWindowHeight, K.windowPolicy);
    }

    public void paintBackBuffer(MagmicGraphics magmicGraphics) {
        this.paintBoardFrame(magmicGraphics);
        this.paintStatusBarFrame(magmicGraphics);
        this.paintTikiBackground(magmicGraphics);
        this.clipOnNextPaint = false;
    }

    public void paint(MagmicGraphics magmicGraphics) {
        MagmicGraphics magmicGraphics2;
        int n = this.maglet.get_width();
        int n2 = this.maglet.get_height();
        if (this.clipOnNextPaint) {
            magmicGraphics2 = this.maglet.fullscreenBackbufferGraphics;
            MagmicGame.pushClip(magmicGraphics2);
            int n3 = this.getOX();
            int n4 = this.getOY();
            int n5 = this.clipMinCol * this.boxW - 1 + n3;
            int n6 = this.clipMinRow * this.boxH - 1 + n4;
            int n7 = (this.clipMaxCol + 1) * this.boxW + n3;
            int n8 = (this.clipMaxRow + 1) * this.boxH + n4;
            magmicGraphics2.setClip(n5, n6, n7 - n5 + 1, n8 - n6 + 1);
            this.maglet.paintBackground(magmicGraphics2);
            this.paintBoardFrame(magmicGraphics2);
            this.paintStatusBarFrame(magmicGraphics2);
            this.paintTikiBackground(magmicGraphics2);
            MagmicGame.popClip(magmicGraphics2);
            this.clipOnNextPaint = false;
        }
        magmicGraphics2 = magmicGraphics;
        if (this.board.showTiki) {
            this.paintTiki(magmicGraphics2);
        }
        this.paintBoardData(magmicGraphics2);
        this.paintStatusBarData(magmicGraphics2);
        this.paintExplosion(magmicGraphics2);
    }

    public void paintBoardFrame(MagmicGraphics magmicGraphics) {
        MagmicImage magmicImage = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.getOX();
        int n4 = this.getOY();
        for (int i = 0; i < this.board.nRow; ++i) {
            block9: for (int j = 0; j < this.board.nCol; ++j) {
                int n5 = j * this.boxW;
                int n6 = i * this.boxH;
                if (!this.board.exists(i, j)) continue;
                short s = this.board.getBox(i, j);
                switch (this.board.getStoneLevel(s)) {
                    case 0: {
                        n = 2405106;
                        n2 = 4579071;
                        break;
                    }
                    case 1: {
                        n = 10133381;
                        n2 = 9268825;
                        break;
                    }
                    default: {
                        n = 15374687;
                        n2 = 8997674;
                    }
                }
                magmicGraphics.setColor(n);
                magmicGraphics.fillRect(n3 + n5, n4 + n6, this.boxW, this.boxH);
                magmicGraphics.setColor(n2);
                magmicGraphics.drawRect(n3 + n5, n4 + n6, this.boxW, this.boxH);
                switch (this.board.getLockLevel(s)) {
                    case 1: {
                        n = 16016920;
                        magmicGraphics.setColor(n);
                        magmicGraphics.drawRect(n3 + n5 - 1, n4 + n6 - 1, this.boxW + 1, this.boxH + 1);
                        continue block9;
                    }
                    case 2: {
                        n = 8170908;
                        if (magmicImage != null) {
                            magmicImage.draw(magmicGraphics, n3 + n5 - 1, n4 + n6 - 1);
                        }
                        magmicGraphics.setColor(n);
                        magmicGraphics.drawRect(n3 + n5 - 1, n4 + n6 - 1, this.boxW + 1, this.boxH + 1);
                        continue block9;
                    }
                }
            }
        }
    }

    public void paintStatusBarFrame(MagmicGraphics magmicGraphics) {
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        int n = this.maglet.get_width();
        int n2 = this.maglet.get_height();
        int n3 = n - this.tikiBackgroundWidth;
        int n4 = this.statusBarHeight;
        int n5 = 0;
        int n6 = 2;
        int n7 = n5 / 2;
        int n8 = n2 - n4;
        magmicGraphics.setColor(8681573);
        magmicGraphics.fillRect(n7, n8 += 2, n3 -= n5, n4 -= 2);
        magmicGraphics.setColor(7558229);
        magmicGraphics.drawRect(n7, n8, n3, n4);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (this.board.bonusWord != null && this.board.bonusWord.length() > 0) {
            n10 = n8 + K.statusBarRow2Y;
            int n12 = n7 + n6;
            int n13 = 9;
            int n14 = 9;
            int n15 = 1;
            n9 = n7 + n13 + n15 + n6;
            magmicStringBuffer.clear();
            magmicStringBuffer.append(this.board.bonusWord);
            for (int i = 0; i < magmicStringBuffer.length; ++i) {
                magmicStringBuffer.chars[i] = Character.toUpperCase(magmicStringBuffer.chars[i]);
            }
            n11 = this.statusBarFont.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n9, n10);
        }
    }

    public void paintTikiBackground(MagmicGraphics magmicGraphics) {
        int n = this.maglet.get_width();
        int n2 = this.maglet.get_height();
        int n3 = this.tikiBackgroundWidth;
        int n4 = n - n3;
        magmicGraphics.setColor(8681573);
        magmicGraphics.fillRect(++n4, 0, --n3, n2);
        magmicGraphics.setColor(7558229);
        magmicGraphics.drawRect(n4, 0, n3, n2);
    }

    public void paintBoardData(MagmicGraphics magmicGraphics) {
        char c;
        int n;
        short s;
        int n2;
        int n3;
        Object var2_2 = null;
        int n4 = this.getOX();
        int n5 = this.getOY();
        if (this.board.swapped) {
            // empty if block
        }
        for (n3 = 0; n3 < this.selectionLength - 1; ++n3) {
            n2 = this.selectionCol[n3] * this.boxW + this.boxW / 2;
            s = this.selectionRow[n3] * this.boxH + this.boxH / 2;
            n = this.selectionCol[n3 + 1] * this.boxW + this.boxW / 2;
            c = this.selectionRow[n3 + 1] * this.boxH + this.boxH / 2;
            magmicGraphics.setColor(16756992);
            magmicGraphics.drawLine(n4 + n2, n5 + s, n4 + n, n5 + c);
        }
        for (n3 = 0; n3 < this.board.nRow; ++n3) {
            for (n2 = 0; n2 < this.board.nCol; ++n2) {
                Font font;
                if (!this.board.exists(n3, n2) || (n = this.board.getValue(s = (short)this.board.getBox(n3, n2))) == 0) continue;
                c = Board.valueToChar(n);
                if (c == '?') {
                    c = Board.bombToChar(this.board.getBombStrenght(n));
                }
                Font font2 = font = this.isSelected(n3, n2) ? this.selectedValueFont : this.valueFont;
                if (c == 'q') {
                    c = '|';
                }
                font.paint_char(magmicGraphics, c, n4 + this.letters[n3][n2].getX() + (this.boxW - 1 - this.valueFont.get_char_width(c)) / 2, n5 + this.letters[n3][n2].getY() + (this.boxH - 1 - this.valueFont.line_height) / 2);
            }
        }
        magmicGraphics.setColor(16768100);
        magmicGraphics.drawRect(n4 + this.cursorCol * this.boxW - 1, n5 + this.cursorRow * this.boxH - 1, 9, 9);
    }

    public void paintExplosion(MagmicGraphics magmicGraphics) {
    }

    public void paintTiki(MagmicGraphics magmicGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        int n5 = this.maglet.get_width();
        int n6 = this.maglet.get_height();
        int n7 = this.tikiBackgroundWidth;
        int n8 = n6;
        int n9 = n5 - n7;
        int n10 = this.tikiPoleFont.base_line;
        --n7;
        ++n9;
        boolean bl = false;
        if (this.maglet.gameMode == 1) {
            n4 = this.board.timeAllowed - this.timeSpent;
            bl = true;
            if (n4 > 0) {
                magmicStringBuffer.clear();
                this.maglet.appendTime(n4, magmicStringBuffer);
                n3 = this.tikiPoleFont.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
                n2 = n9 + (n7 - n3) / 2;
                n = n6 - this.tikiPoleFont.line_height;
                this.tikiPoleFont.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
            }
        }
        n4 = this.tikiPercent.get();
        int n11 = n6 - this.tikiPoleFont.line_height;
        if (bl) {
            n11 -= this.tikiPoleFont.line_height;
        }
        int n12 = Math.min(n4, 100);
        int n13 = n12 * n11 / 100;
        int n14 = n6 - n13 - (bl ? this.tikiPoleFont.line_height : 0) - 1;
        magmicGraphics.setColor(0xFF0000);
        magmicGraphics.fillRect(n9 + n7 / 4, n14, n7 / 2, n13);
        magmicStringBuffer.clear();
        magmicStringBuffer.append(n4);
        magmicStringBuffer.append('%');
        n3 = this.tikiPoleFont.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
        n2 = n9 + (n7 - n3) / 2;
        n = n6 - this.tikiPoleFont.line_height - n13;
        if (bl) {
            n -= this.tikiPoleFont.line_height;
        }
        this.tikiPoleFont.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
    }

    public void paintStatusBarData(MagmicGraphics magmicGraphics) {
        int n;
        char c;
        int n2;
        int n3;
        int n4;
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        int n5 = this.maglet.get_width();
        int n6 = this.maglet.get_height();
        int n7 = n5 - this.tikiBackgroundWidth;
        int n8 = this.statusBarHeight;
        int n9 = 0;
        int n10 = 2;
        n7 -= n9;
        int n11 = n9 / 2;
        int n12 = n6 - n8;
        int n13 = this.statusBarFont.base_line;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        if (this.board.bonusWord != null && this.board.bonusWord.length() > 0) {
            n15 = n12 + K.statusBarRow2Y;
            n4 = n11 + n10;
            n3 = this.foundBonusWord ? 16762112 : 10261874;
            n2 = 9;
            c = '\t';
            magmicGraphics.setColor(n3);
            magmicGraphics.fillRoundRect(n4, n15 + (n13 - c) / 2, n2, c, n2 / 2, c / 2);
        }
        n2 = this.score.get();
        magmicStringBuffer.clear();
        magmicStringBuffer.append(n2);
        n16 = this.statusBarFont.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
        n14 = n11 + n7 - n10 - n16;
        n15 = n12 + K.statusBarRow2Y;
        if (n14 < this.separatorX + n10 && n2 > 999) {
            if (n2 > 999999) {
                c = 'M';
                n4 = n2 / 1000000;
                n3 = n2 / 100000 % 10;
            } else {
                c = 'K';
                n4 = n2 / 1000;
                n3 = n2 / 100 % 10;
            }
            magmicStringBuffer.clear();
            magmicStringBuffer.append(n4);
            magmicStringBuffer.append('.');
            magmicStringBuffer.append(n3);
            magmicStringBuffer.append(c);
            n16 = this.statusBarFont.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
            n14 = n11 + n7 - n10 - n16;
            if (n14 < this.separatorX + n10) {
                magmicStringBuffer.clear();
                magmicStringBuffer.append(n4);
                magmicStringBuffer.append(c);
                n16 = this.statusBarFont.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
                n14 = n11 + n7 - n10 - n16;
            }
        }
        this.statusBarFont.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n14, n15);
        n15 = n12 + K.statusBarRow1Y;
        n3 = n11 + n10;
        if (this.word.length > 2) {
            switch (this.wordTestResult) {
                case 0: {
                    n = 16531204;
                    break;
                }
                case 1: {
                    n = 10022773;
                    break;
                }
                case 2: {
                    n = 0xFCFCFC;
                    break;
                }
                default: {
                    n = 0xFCFCFC;
                    break;
                }
            }
        } else {
            n = 0xFCFCFC;
        }
        c = '\t';
        n4 = 9;
        magmicGraphics.setColor(n);
        magmicGraphics.fillRoundRect(n3, n15 + (n13 - n4) / 2, c, n4, c / 2, n4 / 2);
        int n17 = 1;
        n14 = n11 + c + n17 + n10;
        MagmicGame.pushClip(magmicGraphics);
        magmicGraphics.clipRect(n14, n15, this.guessWordAllowedWidth, this.statusBarFont.line_height);
        n14 += this.guessWordScroll.get();
        for (int i = 0; i < this.word.length; ++i) {
            n14 += this.statusBarFont.paint_char(magmicGraphics, Character.toUpperCase(this.word.chars[i]), n14, n15);
            if (this.word.chars[i] != 'q') continue;
            n14 += this.statusBarFont.paint_char(magmicGraphics, 'U', n14, n15);
        }
        MagmicGame.popClip(magmicGraphics);
    }

    public boolean tick(int n) {
        int n2;
        if (this.neverPainted) {
            this.neverPainted = false;
            return true;
        }
        boolean bl = this.maglet.tickBubbles(n);
        if (!this.maglet.is_layer_on_top(this)) {
            return bl;
        }
        if (!this.solved && this.isIdle() && this.maglet.is_layer_on_top(this)) {
            if (!MagmicGame.cheatTimeFreeze) {
                this.timeSpent += this.maglet.delta_time_without_crop;
            }
            if (this.timeSpent > this.board.timeAllowed && this.maglet.gameMode == 1) {
                this.solved = true;
                this.maglet.fileSystem.delete(1);
            }
            if (this.maglet.gameMode == 1 && this.timeSpent > this.lastTikiRise + 18000 && this.board.tiki > 0) {
                n2 = this.board.tiki;
                this.board.tiki = 0;
                this.onAlterTiki(this.board, this.board.tiki, -n2);
            } else {
                this.saveTimerAccumulator += n;
                if (this.saveTimerAccumulator > this.saveInterval && this.canSave()) {
                    this.saveTimerAccumulator = 0;
                    this.save(this.maglet.fileSystem, 1);
                }
            }
        }
        if (this.solved && this.isIdle() && this.maglet.is_layer_on_top(this)) {
            if (this.timeSpent > this.board.timeAllowed && this.maglet.gameMode == 1) {
                this.scoreWindow.setTitle(this.statusBarFont, 77);
            } else {
                this.scoreWindow.setTitle(this.statusBarFont, 78);
            }
            this.scoreWindow.open(this);
            return true;
        }
        this.paintExplosions = false;
        this.tikiPercent.tick(n);
        this.score.tick(n);
        if (this.guessWordScroll.is_done()) {
            this.guessWordScroll.init_reverse();
        } else {
            this.guessWordScroll.tick(n);
        }
        for (n2 = 0; n2 < 10; ++n2) {
            for (int i = 0; i < 13; ++i) {
                this.letters[n2][i].tick(n);
            }
        }
        if (this.falling) {
            this.fallingTickAccumulator += n;
            while (this.fallingTickAccumulator >= this.fallingTickDuration) {
                this.fallingTickAccumulator -= this.fallingTickDuration;
                this.falling = this.board.fallAndSpawn();
            }
            return true;
        }
        if (this.wordTestResult == 3) {
            long l = Maglet.currentTimeMillis();
            if (this.wildInSelection()) {
                this.resynchWordWithSelection();
            }
            this.wordTestResult = this.dawg.resumeTest(this.word.chars, 0, this.word.length, 100);
            long l2 = Maglet.currentTimeMillis();
            this.searchDuration = (int)(l2 - l);
            return this.wordTestResult != 3;
        }
        return true;
    }

    public void fall() {
        this.falling = true;
        this.fallingTickAccumulator = 0;
    }

    public boolean isIdle() {
        return !this.falling && !this.paintExplosions;
    }

    public boolean triggerVolcanoEruption() {
        if ((long)(this.timeSpent - 60000) < this.lastVolcanoTime) {
            if (!MagmicGame.cheatNoVolcanoCooldown) {
                return false;
            }
        }
        if (this.maglet.gameMode == 1) {
            if (this.timeSpent + 30000 > this.board.timeAllowed - 30000) {
                return false;
            }
            this.timeSpent += 30000;
        }
        this.lastVolcanoTime = this.timeSpent;
        this.clearSelection();
        this.board.clear(true);
        this.fall();
        return true;
    }

    public boolean chainsAppendLetters(char[] cArray, int n, int n2) {
        boolean bl = false;
        if (this.selectionLength == 0) {
            this.chainsSize[this.selectionLength] = 0;
            for (int i = 0; i < this.board.nRow; ++i) {
                for (int j = 0; j < this.board.nCol; ++j) {
                    int n3;
                    char c = Board.valueToChar(this.board.getValue(this.board.getBox(i, j)));
                    boolean bl2 = false;
                    for (n3 = 0; n3 < n2; ++n3) {
                        bl2 |= c == cArray[n3];
                    }
                    if (!(bl2 |= c == '?') || (n3 = this.chainsSize[this.selectionLength]) >= 50) continue;
                    this.chains[this.selectionLength][n3][this.selectionLength] = (byte)(i << 4 | j);
                    int n4 = this.selectionLength;
                    this.chainsSize[n4] = this.chainsSize[n4] + 1;
                    bl = true;
                }
            }
        } else {
            if (this.selectionLength >= 20) {
                return false;
            }
            this.chainsSize[this.selectionLength] = 0;
            for (int i = 0; i < this.chainsSize[this.selectionLength - 1]; ++i) {
                byte by = this.chains[this.selectionLength - 1][i][this.selectionLength - 1];
                int n5 = by >>> 4;
                int n6 = by & 0xF;
                for (int j = -1; j < 2; ++j) {
                    for (int k = -1; k < 2; ++k) {
                        int n7;
                        int n8;
                        int n9;
                        if (j == 0 && k == 0) continue;
                        short s = this.board.getBox(n5 + j, n6 + k);
                        char c = Board.valueToChar(this.board.getValue(s));
                        boolean bl3 = false;
                        for (n9 = 0; n9 < n2; ++n9) {
                            bl3 |= c == cArray[n9];
                        }
                        if (!(bl3 |= c == '?')) continue;
                        n9 = 0;
                        for (n8 = 0; n8 < this.selectionLength - 1 && n9 == 0; ++n8) {
                            n7 = this.chains[this.selectionLength - 1][i][n8];
                            int n10 = n7 >>> 4;
                            int n11 = n7 & 0xF;
                            n9 = n10 == n5 + j && n11 == n6 + k ? 1 : 0;
                        }
                        if (n9 != 0 || this.board.getLockLevel(s) != 0 || (n8 = this.chainsSize[this.selectionLength]) >= 50) continue;
                        for (n7 = 0; n7 < this.selectionLength; ++n7) {
                            this.chains[this.selectionLength][n8][n7] = this.chains[this.selectionLength - 1][i][n7];
                        }
                        this.chains[this.selectionLength][n8][this.selectionLength] = (byte)(n5 + j << 4 | n6 + k);
                        int n12 = this.selectionLength;
                        this.chainsSize[n12] = this.chainsSize[n12] + 1;
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            ++this.selectionLength;
            this.updateSelectionWithChain(0);
        }
        return bl;
    }

    public void updateSelectionWithChain(int n) {
        if (this.selectionLength == 0) {
            return;
        }
        if (n < 0) {
            n = this.chainsSize[this.selectionLength - 1] - 1;
        }
        if (n >= this.chainsSize[this.selectionLength - 1]) {
            n = 0;
        }
        for (int i = 0; i < this.selectionLength; ++i) {
            this.selectionRow[i] = this.chains[this.selectionLength - 1][n][i] >>> 4;
            this.selectionCol[i] = this.chains[this.selectionLength - 1][n][i] & 0xF;
        }
        this.cursorCol = this.selectionCol[this.selectionLength - 1];
        this.cursorRow = this.selectionRow[this.selectionLength - 1];
        long l = Maglet.currentTimeMillis();
        this.resynchWordWithSelection();
        this.wordTestResult = this.selectedBonusWord() ? 1 : this.dawg.startTest(this.word.chars, 0, this.word.length, 100);
        long l2 = Maglet.currentTimeMillis();
        this.searchDuration = (int)(l2 - l);
        this.selectedChainIndex = n;
    }

    public boolean key_up(int n, int n2) {
        switch (n) {
            case 1: {
                if (!this.falling && this.board.swapped && this.selectionLength == 0) {
                    this.board.unswap();
                } else if (this.selectionLength > 0) {
                    this.decreaseSelectionSize();
                }
                return true;
            }
            case 7: {
                if (this.canSave()) {
                    this.save(this.maglet.fileSystem, 1);
                }
                this.showMenu();
                return true;
            }
        }
        return false;
    }

    public boolean key_down(int n, int n2) {
        char[] cArray;
        int n3;
        if (this.maglet.inputMode == 2 && (n3 = MagmicGame.get_key_letters(n2, cArray = MagmicStringBuffer.global_buffer.chars, false)) > 0) {
            if (this.chainsAppendLetters(cArray, 0, n3)) {
                this.isUsingChains = true;
            }
            return true;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.isUsingChains) {
                    if (n == 5 || n == 2) {
                        this.updateSelectionWithChain(this.selectedChainIndex - 1);
                    }
                    if (n == 4 || n == 3) {
                        this.updateSelectionWithChain(this.selectedChainIndex + 1);
                    }
                } else {
                    int n4 = this.cursorRow++;
                    n3 = this.cursorCol;
                    if (n == 5) {
                        // empty if block
                    }
                    if (n == 4) {
                        --this.cursorRow;
                    }
                    if (n == 2) {
                        --this.cursorCol;
                    }
                    if (n == 3) {
                        ++this.cursorCol;
                    }
                    if (n == 10) {
                        ++this.cursorRow;
                        --this.cursorCol;
                    }
                    if (n == 8) {
                        --this.cursorRow;
                        --this.cursorCol;
                    }
                    if (n == 11) {
                        ++this.cursorRow;
                        ++this.cursorCol;
                    }
                    if (n == 9) {
                        --this.cursorRow;
                        ++this.cursorCol;
                    }
                    if (this.cursorCol < 0) {
                        this.cursorCol = 0;
                    }
                    if (this.cursorCol >= this.board.nCol) {
                        this.cursorCol = this.board.nCol - 1;
                    }
                    if (this.cursorRow < 0) {
                        this.cursorRow = 0;
                    }
                    if (this.cursorRow >= this.board.nRow) {
                        this.cursorRow = this.board.nRow - 1;
                    }
                    if (this.maglet.inputMode == 1 && this.selectionLength > 0) {
                        if (!this.isValidNewSelection(this.cursorRow, this.cursorCol)) {
                            if (this.selectionLength > 1 && this.selectionCol[this.selectionLength - 2] == this.cursorCol && this.selectionRow[this.selectionLength - 2] == this.cursorRow) {
                                this.decreaseSelectionSize();
                            } else {
                                this.cursorRow = n4;
                                this.cursorCol = n3;
                            }
                        } else {
                            this.addNewSelection(this.cursorRow, this.cursorCol);
                        }
                    }
                }
                return true;
            }
        }
        if (n == 6 && this.isIdle()) {
            boolean bl = this.isSelected(this.cursorRow, this.cursorCol);
            if (!bl) {
                if (!this.isValidNewSelection(this.cursorRow, this.cursorCol)) {
                    if (!this.board.isEmpty(this.board.getBox(this.cursorRow, this.cursorCol))) {
                        this.clearSelection();
                    }
                } else {
                    this.addNewSelection(this.cursorRow, this.cursorCol);
                }
            } else {
                if (this.selectionLength > 1) {
                    if (this.selectionLength == 2) {
                        if (this.board.getLockLevel(this.board.getBox(this.selectionRow[0], this.selectionCol[0])) == 0) {
                            this.board.swap(this.selectionRow[0], this.selectionCol[0], this.selectionRow[1], this.selectionCol[1]);
                        }
                    } else if (this.selectionLength >= 2 && (this.wordTestResult == 1 || MagmicGame.cheatEverythingsAWord)) {
                        this.logWord(this.word.chars, 0, this.word.length);
                        this.board.completeWord(this.selectionRow, this.selectionCol, 0, this.selectionLength, this.maglet.gameMode);
                        if (this.board.completeWordBombStrenght > 0) {
                            this.playSound(this.soundBomb[this.board.completeWordBombStrenght - 1]);
                        } else if (this.board.completeWordStoneStrenght == 1) {
                            this.playSound(this.soundBreakStone);
                        } else if (this.board.completeWordStoneStrenght == 2) {
                            this.playSound(this.soundBreakMetal);
                        } else {
                            this.playSound(this.soundCompleteWord);
                        }
                        if (this.wordIsBonusWord) {
                            this.board.score += 400;
                            this.foundBonusWord = true;
                            this.onAlterScore(this.board, this.board.score, 400);
                            this.board.setValue(this.selectionRow[this.selectionLength - 1], this.selectionCol[this.selectionLength - 1], this.board.getGeneratedBombValue(Math.max(6, this.selectionLength)));
                        }
                        this.fall();
                    }
                }
                this.clearSelection();
            }
            return true;
        }
        return false;
    }

    public void addNewSelection(int n, int n2) {
        char c = Board.valueToChar(this.board.getValue(this.board.getBox(n, n2)));
        this.word.append(c);
        if (this.selectionLength > 0) {
            for (int i = 0; i < this.selectionLength; ++i) {
                this.chains[this.selectionLength][0][i] = this.chains[this.selectionLength - 1][0][i];
            }
        }
        this.chains[this.selectionLength][0][this.selectionLength] = (byte)(n << 4 | n2);
        this.chainsSize[this.selectionLength] = 1;
        this.selectionRow[this.selectionLength] = n;
        this.selectionCol[this.selectionLength] = n2;
        ++this.selectionLength;
        this.resynchWordWithSelection();
        long l = Maglet.currentTimeMillis();
        this.wordTestResult = this.selectedBonusWord() ? 1 : (this.wildInSelection() ? this.dawg.startTest(this.word.chars, 0, this.word.length, 100) : (this.selectionLength > 1 && !this.wordIsBonusWord && (this.wordTestResult == 1 || this.wordTestResult == 2) ? this.dawg.addOneLetterToPreviousSearch(c) : this.dawg.startTest(this.word.chars, 0, this.word.length, 100)));
        long l2 = Maglet.currentTimeMillis();
        this.searchDuration = (int)(l2 - l);
        this.resetGuessWordScroll();
    }

    public void showMenu() {
        if (this.maglet.is_layer_visible(this.maglet.menuWindow)) {
            return;
        }
        if (!this.maglet.is_layer_on_top(this)) {
            return;
        }
        this.maglet.menuWindow.closeOnConfirmOption = false;
        int n = 0;
        this.menuItems[n++] = 28;
        if (this.board.calculateSpawn) {
            this.menuItems[n++] = 29;
        }
        this.inputMenuItemIndex = n;
        this.menuItems[n++] = this.getInputModeLabel();
        if (this.maglet.levelId >= 0 && this.maglet.levelId <= 6) {
            this.menuItems[n++] = 76;
        }
        this.menuItems[n++] = 24;
        this.maglet.menuWindow.setupOptions(this.menuItems, 0, n, 28, 28, n, true);
        this.maglet.menuWindow.pack(K.windowPackPolicy);
        this.maglet.menuWindow.open(this);
    }

    public int getInputModeLabel() {
        switch (this.maglet.inputMode) {
            case 1: {
                return 45;
            }
            case 2: {
                return 46;
            }
        }
        return 44;
    }

    public boolean selectedBonusWord() {
        int n;
        boolean bl;
        boolean bl2 = bl = this.selectionLength == this.board.bonusWord.length();
        if (bl) {
            for (n = 0; n < this.selectionLength && bl; bl &= this.word.chars[n] == '?' || this.word.chars[n] == this.board.bonusWord.charAt(n), ++n) {
            }
        }
        if (bl) {
            for (n = 0; n < this.selectionLength; ++n) {
                this.word.chars[n] = this.board.bonusWord.charAt(n);
            }
        }
        this.wordIsBonusWord = bl;
        return bl;
    }

    public void resynchWordWithSelection() {
        this.word.clear();
        for (int i = 0; i < this.selectionLength; ++i) {
            this.word.append(Board.valueToChar(this.board.getValue(this.board.getBox(this.selectionRow[i], this.selectionCol[i]))));
        }
    }

    public boolean wildInSelection() {
        for (int i = 0; i < this.selectionLength; ++i) {
            if (Board.valueToChar(this.board.getValue(this.board.getBox(this.selectionRow[i], this.selectionCol[i]))) != '?') continue;
            return true;
        }
        return false;
    }

    public void clearSelection() {
        this.selectionLength = 0;
        this.isUsingChains = false;
        this.word.clear();
        this.resetGuessWordScroll();
    }

    public void decreaseSelectionSize() {
        if (this.selectionLength <= 1) {
            this.clearSelection();
            return;
        }
        --this.selectionLength;
        if (this.isUsingChains) {
            this.updateSelectionWithChain(0);
        } else {
            long l = Maglet.currentTimeMillis();
            this.resynchWordWithSelection();
            this.wordTestResult = this.selectedBonusWord() ? 1 : this.dawg.startTest(this.word.chars, 0, this.word.length, 100);
            long l2 = Maglet.currentTimeMillis();
            this.searchDuration = (int)(l2 - l);
            if (this.maglet.inputMode == 1 || this.maglet.inputMode == 0) {
                this.cursorCol = this.selectionCol[this.selectionLength - 1];
                this.cursorRow = this.selectionRow[this.selectionLength - 1];
            }
        }
        this.resetGuessWordScroll();
    }

    public void resetGuessWordScroll() {
        int n = K.statusBarTileWidth;
        int n2 = this.maglet.get_width() - this.tikiBackgroundWidth;
        int n3 = n2 % n;
        int n4 = n3 / 2;
        int n5 = 1;
        int n6 = this.wordLightWidth;
        int n7 = n4 + n6 + n5 + n;
        this.guessWordAllowedWidth = (n2 -= n3) - (n7 - n4) - n;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < this.word.length; ++i) {
            if ((n8 += this.statusBarFont.get_char_width(Character.toUpperCase(this.word.chars[i])) + this.statusBarFont.data.spacer_x) > this.guessWordAllowedWidth) {
                ++n9;
            }
            if (this.word.chars[i] != 'q' || (n8 += this.statusBarFont.get_char_width('U') + this.statusBarFont.data.spacer_x) <= this.guessWordAllowedWidth) continue;
            ++n9;
        }
        if (n8 > this.guessWordAllowedWidth) {
            this.guessWordScroll.init(0, this.guessWordAllowedWidth - n8, 500 * n9);
        } else {
            this.guessWordScroll.init(0, 0, 1);
        }
    }

    public boolean isSelected(int n, int n2) {
        for (int i = 0; i < this.selectionLength; ++i) {
            if (this.selectionRow[i] != n || this.selectionCol[i] != n2) continue;
            return true;
        }
        return false;
    }

    public boolean isValidNewSelection(int n, int n2) {
        if (this.selectionLength >= 20) {
            return false;
        }
        short s = this.board.getBox(n, n2);
        if (!this.board.exists(s) || this.board.isEmpty(s)) {
            return false;
        }
        if (this.selectionLength <= 0) {
            return true;
        }
        if (this.board.getLockLevel(s) > 0) {
            return false;
        }
        int n3 = this.selectionRow[this.selectionLength - 1];
        int n4 = this.selectionCol[this.selectionLength - 1];
        int n5 = Math.abs(n3 - n);
        int n6 = Math.abs(n4 - n2);
        if (n5 > 1 || n6 > 1) {
            return false;
        }
        for (int i = 0; i < this.selectionLength; ++i) {
            if (n != this.selectionRow[i] || n2 != this.selectionCol[i]) continue;
            return false;
        }
        return true;
    }

    public boolean logWord(char[] cArray, int n, int n2) {
        if (this.wordHistoryLength < 30) {
            this.wordHistory[this.wordHistoryLength].clear();
            this.wordHistory[this.wordHistoryLength].append(cArray, n, n2);
            ++this.wordHistoryLength;
            return true;
        }
        return false;
    }

    public void window_closed(Window window) {
        if (window == this.scoreWindow) {
            this.maglet.levelSelectWindow.open(this);
        }
        if (window == this.maglet.systemWindow && this.solved && this.isIdle()) {
            this.maglet.levelSelectWindow.open(this);
        }
        if (window == this.maglet.menuWindow) {
            if (this.changedInputMode) {
                this.changedInputMode = false;
                if (this.maglet.inputMode == 1) {
                    this.maglet.showSystemMessage(59, (MagmicLayer)this, -1);
                }
            }
        } else if (this.waitingToShowTut) {
            this.waitingToShowTut = false;
            this.showTutorial();
        }
    }

    public void window_confirm_option(Window window, int n, int n2, int n3) {
        if (window == this.maglet.menuWindow) {
            switch (this.maglet.menuWindow.selectedOptionId) {
                case 28: {
                    window.close();
                    break;
                }
                case 29: {
                    window.close();
                    if (this.triggerVolcanoEruption()) break;
                    this.maglet.showSystemMessage(54, (MagmicLayer)this, -1);
                    break;
                }
                case 76: {
                    this.showTutorial();
                    break;
                }
                case 44: 
                case 45: 
                case 46: {
                    this.changedInputMode = true;
                    this.maglet.inputMode = (this.maglet.inputMode + 1) % 3;
                    this.maglet.saveSettings();
                    this.menuItems[this.inputMenuItemIndex] = this.getInputModeLabel();
                    this.maglet.menuWindow.updateSelectedOptionId();
                    this.maglet.menuWindow.pack(true);
                    this.maglet.repaintFullscreenBackbuffer = true;
                    this.clearSelection();
                    break;
                }
                case 24: {
                    this.maglet.changeRootLayer(4);
                }
            }
        }
    }

    public void window_key_up(Window window, int n, int n2) {
        if (window == this.maglet.menuWindow) {
            switch (n) {
                case 7: {
                    int n3 = -1;
                    switch (this.maglet.menuWindow.selectedOptionId) {
                        case 28: {
                            n3 = 91;
                            break;
                        }
                        case 45: {
                            n3 = 93;
                            break;
                        }
                        case 46: {
                            n3 = 94;
                            break;
                        }
                        case 44: {
                            n3 = 95;
                            break;
                        }
                        case 29: {
                            n3 = 89;
                            break;
                        }
                        case 76: {
                            n3 = 111;
                            break;
                        }
                        case 30: {
                            n3 = 90;
                            break;
                        }
                        case 24: {
                            n3 = 96;
                        }
                    }
                    if (n3 == -1) break;
                    MagmicStringBuffer magmicStringBuffer = this.maglet.helpWindowBuffer;
                    magmicStringBuffer.clear();
                    this.maglet.strings.append_string(n3, magmicStringBuffer);
                    this.maglet.helpWindow.setupMessage(this.maglet.systemFont, magmicStringBuffer.chars, 0, magmicStringBuffer.length);
                    this.maglet.helpWindow.open(this);
                }
            }
        }
    }

    public void onDestroy(Board board, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.explodeFlag[n][n2] = true;
        this.paintExplosions = true;
        if (bl2 || bl3) {
            if (!this.clipOnNextPaint) {
                this.clipMinRow = n;
                this.clipMaxRow = n;
                this.clipMinCol = n2;
                this.clipMaxCol = n2;
            } else {
                if (this.clipMinRow > n) {
                    this.clipMinRow = n;
                }
                if (this.clipMaxRow < n) {
                    this.clipMaxRow = n;
                }
                if (this.clipMinCol > n2) {
                    this.clipMinCol = n2;
                }
                if (this.clipMaxCol < n2) {
                    this.clipMaxCol = n2;
                }
            }
            this.clipOnNextPaint = true;
        }
    }

    public void onSwapLetter(Board board, int n, int n2, int n3, int n4) {
        this._swapAnim(n, n2, n3, n4);
        this.playSound(this.soundSwap);
    }

    public void onUnSwapLetter(Board board, int n, int n2, int n3, int n4) {
        this._swapAnim(n, n2, n3, n4);
        this.playSound(this.soundSwap);
    }

    public void _swapAnim(int n, int n2, int n3, int n4) {
        Slide2D slide2D = this.letters[n][n2];
        Slide2D slide2D2 = this.letters[n3][n4];
        int n5 = slide2D.getDestinationX();
        int n6 = slide2D.getDestinationY();
        slide2D.init(slide2D.getX(), slide2D.getY(), slide2D2.getDestinationX(), slide2D2.getDestinationY(), 600);
        slide2D2.init(slide2D2.getX(), slide2D2.getY(), n5, n6, 600);
        this.letters[n][n2] = slide2D2;
        this.letters[n3][n4] = slide2D;
    }

    public void _swap(int n, int n2, int n3, int n4) {
        Slide2D slide2D;
        Slide2D slide2D2 = this.letters[n][n2];
        this.letters[n][n2] = slide2D = this.letters[n3][n4];
        this.letters[n3][n4] = slide2D2;
    }

    public void onSpawn(Board board, int n, int n2) {
        int n3 = n2 * this.boxW;
        int n4 = n * this.boxH;
        this.letters[n][n2].init(n3, n4 - this.boxH, n3, n4, 300);
    }

    public void onFall(Board board, int n, int n2, int n3, int n4) {
        int n5 = n4 * this.boxW;
        int n6 = n3 * this.boxH;
        int n7 = this.letters[n][n2].getX();
        int n8 = this.letters[n][n2].getY();
        this.letters[n][n2].init(n7, n8, n5, n6, 300);
        this._swap(n, n2, n3, n4);
    }

    public void onSolved(Board board) {
        int n;
        this.solved = true;
        this.numberOfFreedFishBeforeSolving = this.maglet.score.getNumberOfFreedFishes();
        int n2 = board.completedWordLengthSum * 10 / board.completedWordCount;
        long l = board.getFinalScoreWithoutTimeBonus();
        if (this.maglet.gameMode == 1 && (n = board.timeAllowed - this.timeSpent) > 0) {
            l += (long)board.getTimeRemainingScore(n);
        }
        if (this.maglet.score.getScore(this.maglet.levelId, this.maglet.gameMode) < l) {
            this.maglet.score.setScore(this.maglet.levelId, this.maglet.gameMode, l);
        }
        if (this.maglet.score.getTiki(this.maglet.levelId, this.maglet.gameMode) < board.tiki) {
            this.maglet.score.setTiki(this.maglet.levelId, this.maglet.gameMode, board.tiki);
        }
        if (this.maglet.score.getAverage(this.maglet.levelId, this.maglet.gameMode) < n2) {
            this.maglet.score.setAverage(this.maglet.levelId, this.maglet.gameMode, n2);
        }
        if (this.maglet.score.getTime(this.maglet.levelId, this.maglet.gameMode) == 0L || this.maglet.score.getTime(this.maglet.levelId, this.maglet.gameMode) > (long)this.timeSpent) {
            this.maglet.score.setTime(this.maglet.levelId, this.maglet.gameMode, this.timeSpent);
        }
        if (!this.maglet.score.foundBonusWord(this.maglet.levelId, this.maglet.gameMode)) {
            this.maglet.score.setFoundBonusWord(this.maglet.levelId, this.maglet.gameMode, this.foundBonusWord);
        }
        this.maglet.score.save(this.maglet.fileSystem, 0);
        this.maglet.fileSystem.delete(1);
        this.numberOfFreedFishAfterSolving = this.maglet.score.getNumberOfFreedFishes();
    }

    public void onNewBoard(Board board) {
        this.wordHistoryLength = 0;
        this.foundBonusWord = false;
        this.timeSpent = 0;
        this.lastTikiRise = 0;
        this.solved = false;
        this.lastVolcanoTime = -60000L;
        this.cursorCol = board.nCol / 2;
        this.cursorRow = board.nRow / 2;
        this.clearSelection();
        this.synchScore();
        for (int i = 0; i < board.nRow; ++i) {
            for (int j = 0; j < board.nCol; ++j) {
                int n = j * this.boxW;
                int n2 = i * this.boxH;
                this.letters[i][j].init(n, n2, n, n2, 1);
            }
        }
        this.paintExplosions = false;
        this.maglet.fileSystem.delete(1);
        this.maglet.repaintFullscreenBackbuffer = true;
        if ((this.maglet.audioMode & 1) != 0) {
            this.maglet.loadAndPlayRandomBackgroundMusic();
        }
        this.showTutorial();
    }

    public void showTutorial() {
        switch (this.maglet.levelId) {
            case 0: {
                this.maglet.showSystemMessage(17, (MagmicLayer)this, 76);
                break;
            }
            case 1: {
                this.maglet.showSystemMessage(18, (MagmicLayer)this, 76);
                break;
            }
            case 2: {
                this.maglet.showSystemMessage(19, (MagmicLayer)this, 76);
                break;
            }
            case 3: {
                this.maglet.showSystemMessage(20, (MagmicLayer)this, 76);
                break;
            }
            case 4: {
                this.maglet.showSystemMessage(21, (MagmicLayer)this, 76);
                break;
            }
            case 5: {
                this.maglet.showSystemMessage(22, (MagmicLayer)this, 76);
                break;
            }
            case 6: {
                this.maglet.showSystemMessage(23, (MagmicLayer)this, 76);
                break;
            }
        }
    }

    public void onAlterScore(Board board, int n, int n2) {
        this.score.init(this.score.get(), n, Math.min(5 * Math.abs(n2), 3000));
    }

    public void onAlterTiki(Board board, int n, int n2) {
        this.tikiPercent.init(this.tikiPercent.get(), n, Math.min(75 * Math.abs(n2), 3000));
        this.lastTikiRise = this.timeSpent;
    }

    public boolean canSave() {
        return !this.solved;
    }

    public boolean save(MagmicFileIO magmicFileIO, int n) {
        MagmicIO magmicIO = MagmicGame.maglet.io;
        magmicIO.bind(this.maglet.ioBuffer, 0, 2048);
        magmicIO.write_s32(this.cursorRow);
        magmicIO.write_s32(this.cursorCol);
        magmicIO.write_s32(this.maglet.levelId);
        magmicIO.write_s32(this.wordHistoryLength);
        for (int i = 0; i < this.wordHistoryLength; ++i) {
            magmicIO.write_string_8(this.wordHistory[i].chars, 0, this.wordHistory[i].length);
        }
        magmicIO.write_s8((byte)(this.foundBonusWord ? 1 : 0));
        magmicIO.write_s32(this.timeSpent);
        magmicIO.write_s32(this.lastTikiRise);
        magmicIO.write_s32(this.maglet.gameMode);
        magmicIO.write_s32((int)((long)this.timeSpent - this.lastVolcanoTime));
        this.board.save(magmicIO);
        if (magmicIO.exception != null) {
            return false;
        }
        try {
            magmicFileIO.save(n, this.maglet.ioBuffer, 0, magmicIO.pointer);
        }
        catch (IOException iOException) {
            return false;
        }
        this.maglet.consume_delta_time();
        return magmicIO.exception == null;
    }

    public boolean load(MagmicFileIO magmicFileIO, int n) {
        int n2;
        magmicFileIO.load(n, this.maglet.ioBuffer, 0);
        MagmicIO magmicIO = MagmicGame.maglet.io;
        magmicIO.bind(this.maglet.ioBuffer, 0, 2048);
        this.cursorRow = magmicIO.read_s32();
        this.cursorCol = magmicIO.read_s32();
        this.maglet.levelId = magmicIO.read_s32();
        this.wordHistoryLength = magmicIO.read_s32();
        if (magmicIO.exception != null) {
            return false;
        }
        for (n2 = 0; n2 < this.wordHistoryLength; ++n2) {
            this.wordHistory[n2].length = magmicIO.read_string_8(this.wordHistory[n2].chars, 0);
        }
        this.foundBonusWord = magmicIO.read_s8() != 0;
        this.timeSpent = magmicIO.read_s32();
        this.lastTikiRise = magmicIO.read_s32();
        this.maglet.gameMode = magmicIO.read_s32();
        this.lastVolcanoTime = this.timeSpent - magmicIO.read_s32();
        this.board.load(magmicIO);
        if (magmicIO.exception != null) {
            return false;
        }
        this.solved = false;
        this.setMode(this.maglet.gameMode);
        for (n2 = 0; n2 < this.board.nRow; ++n2) {
            for (int i = 0; i < this.board.nCol; ++i) {
                int n3 = i * this.boxW;
                int n4 = n2 * this.boxH;
                this.letters[n2][i].init(n3, n4, n3, n4, 1);
            }
        }
        this.paintExplosions = false;
        this.synchScore();
        this.clearSelection();
        this.fall();
        this.maglet.repaintFullscreenBackbuffer = true;
        return magmicIO.exception == null;
    }

    public void synchScore() {
        this.score.init(this.score.get(), this.board.score, Math.min(5 * Math.abs(this.score.get() - this.board.score), 3000));
        this.tikiPercent.init(this.tikiPercent.get(), this.board.tiki, Math.min(5 * Math.abs(this.tikiPercent.get() - this.board.tiki), 3000));
    }

    public int getOX() {
        int n = this.maglet.get_width() - this.tikiBackgroundWidth;
        return (n - this.boxW * this.board.nCol) / 2;
    }

    public int getOY() {
        int n = this.maglet.get_height() - this.statusBarHeight;
        return (n - this.boxH * this.board.nRow) / 2;
    }

    public void playSound(int n) {
        if ((this.maglet.audioMode & 2) != 0) {
            this.maglet.playSound(n);
        }
    }
}

