/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.Font;
import com.magmic.MagmicGame;
import com.magmic.MagmicStringBuffer;
import com.magmic.Window;
import com.magmic.kahuna.BoardLayer;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.ui.MagmicGraphics;

public class ScoreWindow
extends Window {
    public static final int MODE_SUMMARY = 0;
    public static final int MODE_WORD_HISTORY = 1;
    public static final int MODE_FINAL_SCORE = 2;
    public static final int MODE_TIMES_UP = 4;
    public BoardLayer game;
    public Font font;
    public int mode;
    public boolean readyForNextMode;
    public boolean receivedKeyDown;
    public int lineDelay;
    public int lineTimeAccumulator;
    public int lineProgress;
    public int totalLine;
    public boolean needsChangePageConfirmation;
    public boolean multiPage;

    public ScoreWindow(MagmicGame magmicGame, BoardLayer boardLayer, Font font) {
        super(magmicGame);
        this.game = boardLayer;
        this.font = font;
        this.lineDelay = 200;
    }

    public void open(MagmicLayer magmicLayer) {
        super.open(magmicLayer);
        this.receivedKeyDown = false;
        if (this.game.timeSpent > this.game.board.timeAllowed && this.maglet.gameMode == 1) {
            this.setMode(4);
        } else {
            this.setMode(0);
        }
    }

    public void close() {
        super.close();
    }

    public void nextMode() {
        if (this.readyForNextMode) {
            this.setMode(this.mode + 1);
        }
    }

    public void setMode(int n) {
        this.mode = n;
        this.readyForNextMode = false;
        this.lineProgress = 0;
        this.lineTimeAccumulator = 0;
        this.needsChangePageConfirmation = false;
        this.multiPage = false;
        switch (n) {
            case 0: {
                boolean bl = this.game.board.bonusWord != null && this.game.board.bonusWord.length() > 0;
                this.totalLine = 2;
                if (bl) {
                    this.totalLine += 3;
                }
                if (!this.game.board.showTiki) break;
                this.totalLine += 3;
                break;
            }
            case 1: {
                this.totalLine = this.game.wordHistoryLength;
                this.multiPage = true;
                break;
            }
            case 2: {
                this.totalLine = 10;
                if (this.maglet.gameMode != 1) break;
                this.totalLine += 3;
                break;
            }
            case 4: {
                this.totalLine = 3;
                break;
            }
            default: {
                this.close();
            }
        }
    }

    public void paint(MagmicGraphics magmicGraphics) {
        super.paint(magmicGraphics);
        if (this.isTransiting()) {
            return;
        }
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        int n = 0;
        int n2 = this.center_h / this.font.line_height;
        int n3 = (this.center_h - this.font.line_height * Math.min(this.totalLine, n2)) / 2;
        int n4 = this.lineProgress == 0 ? 0 : (this.lineProgress - 1) / n2;
        switch (this.mode) {
            case 0: {
                boolean bl = this.game.board.bonusWord != null && this.game.board.bonusWord.length() > 0;
                this.paintCentered(magmicGraphics, 81, n++, n3);
                magmicStringBuffer.clear();
                this.maglet.appendTime(this.game.timeSpent, magmicStringBuffer);
                this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n++, n3);
                if (this.game.board.showTiki) {
                    int n5 = ++n;
                    this.paintCentered(magmicGraphics, 82, n5, n3);
                    magmicStringBuffer.clear();
                    magmicStringBuffer.append(this.game.board.tiki);
                    magmicStringBuffer.append('%');
                    int n6 = ++n;
                    ++n;
                    this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n6, n3);
                }
                if (!bl) break;
                int n7 = ++n;
                ++n;
                this.paintCentered(magmicGraphics, 83, n7, n3);
                this.paintCentered(magmicGraphics, this.game.foundBonusWord ? "Found" : "Not Found", n++, n3);
                break;
            }
            case 1: {
                for (int i = n4 * n2; i < this.lineProgress && i < this.game.wordHistoryLength; ++i) {
                    magmicStringBuffer.clear();
                    this.appendWithQU(magmicStringBuffer, this.game.wordHistory[i].chars, 0, this.game.wordHistory[i].length);
                    this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, i - n4 * n2, n3);
                }
                break;
            }
            case 2: {
                this.paintCentered(magmicGraphics, 84, n++, n3);
                magmicStringBuffer.clear();
                magmicStringBuffer.append(this.game.board.score);
                this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n++, n3);
                this.paintCentered(magmicGraphics, "x", n++, n3);
                this.paintCentered(magmicGraphics, "Average", n++, n3);
                this.paintCentered(magmicGraphics, "Length", n++, n3);
                magmicStringBuffer.clear();
                magmicStringBuffer.append_fixed_point((this.game.board.completedWordLengthSum << 8) / this.game.board.completedWordCount, 8, 2);
                this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n++, n3);
                int n8 = 0;
                if (this.maglet.gameMode == 1) {
                    this.paintCentered(magmicGraphics, "+", n++, n3);
                    this.paintCentered(magmicGraphics, 85, n++, n3);
                    int n9 = this.game.board.timeAllowed - this.game.timeSpent;
                    n8 = this.game.board.getTimeRemainingScore(n9);
                    magmicStringBuffer.clear();
                    this.maglet.appendTime(n9, magmicStringBuffer);
                    this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n++, n3);
                    magmicStringBuffer.clear();
                    magmicStringBuffer.append(n8);
                    this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n++, n3);
                }
                int n10 = ++n;
                this.paintCentered(magmicGraphics, 86, n10, n3);
                magmicStringBuffer.clear();
                magmicStringBuffer.append(this.game.board.getFinalScoreWithoutTimeBonus() + n8);
                int n11 = ++n;
                ++n;
                this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n11, n3);
                break;
            }
            case 4: {
                this.paintCentered(magmicGraphics, 87, n++, n3);
                int n12 = ++n;
                ++n;
                this.paintCentered(magmicGraphics, 88, n12, n3);
            }
        }
    }

    public boolean tick(int n) {
        super.tick(n);
        if (this.isTransiting()) {
            return true;
        }
        if (!this.readyForNextMode) {
            int n2 = this.center_h / this.font.line_height;
            this.lineTimeAccumulator += n;
            while (this.lineTimeAccumulator > this.lineDelay) {
                this.lineTimeAccumulator -= this.lineDelay;
                if (this.needsChangePageConfirmation && this.multiPage) continue;
                ++this.lineProgress;
                if (!this.multiPage || this.lineProgress % n2 != 0) continue;
                this.needsChangePageConfirmation = this.lineProgress < this.totalLine;
            }
        }
        this.readyForNextMode = this.lineProgress >= this.totalLine;
        return true;
    }

    public boolean key_down(int n, int n2) {
        if (this.isTransiting()) {
            return false;
        }
        this.receivedKeyDown = true;
        return false;
    }

    public boolean key_up(int n, int n2) {
        if (this.isTransiting()) {
            return false;
        }
        if (!this.receivedKeyDown) {
            return false;
        }
        this.needsChangePageConfirmation = false;
        this.nextMode();
        return true;
    }

    public void paintCentered(MagmicGraphics magmicGraphics, String string, int n, int n2) {
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        magmicStringBuffer.clear();
        magmicStringBuffer.append(string);
        this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n, n2);
    }

    public void paintCentered(MagmicGraphics magmicGraphics, int n, int n2, int n3) {
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        magmicStringBuffer.clear();
        this.maglet.strings.append_string(n, magmicStringBuffer);
        this.paintCentered(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3);
    }

    public void paintCentered(MagmicGraphics magmicGraphics, char[] cArray, int n, int n2, int n3, int n4) {
        if (this.lineProgress <= n3) {
            return;
        }
        int n5 = this.font.get_chars_width(cArray, n, n2);
        this.font.paint_chars(magmicGraphics, cArray, n, n2, this.center_x + (this.center_w - n5) / 2, this.center_y + n3 * this.font.line_height + n4);
    }

    private void appendWithQU(MagmicStringBuffer magmicStringBuffer, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            magmicStringBuffer.append(c);
            if (c == 'Q') {
                magmicStringBuffer.append('U');
            }
            if (c != 'q') continue;
            magmicStringBuffer.append('u');
        }
    }
}

