/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.magmicSound;

import com.magmic.maglet.Maglet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class MagmicSound2 {
    private static Class callingClass;
    private static final int NUMBER_OF_MIDP_PLAYERS = 1;
    private static Player[] playerArray;
    private static int[] indexOnPlayer;
    private static int[] numberOfTimesPlayed;
    private static PlayerListener listener;
    private static int arraySizes;
    private static String[] fileNames;
    private static String[] mimeOfFile;
    private static final String MIME_TYPE_MIDI = "audio/midi";
    private static final String FILE_EXTENSION_MIDI = ".mid";
    private static final String MIME_TYPE_WAV = "audio/x-wav";
    private static final String FILE_EXTENSION_WAV = ".wav";
    private static boolean firstPlay;
    private static volatile int state;
    public static final int STATE_INIT = 0;
    public static final int STATE_ADDAUDIO = 1;
    public static final int STATE_STOP = 2;
    public static final int STATE_PLAY = 4;
    public static final int STATE_PAUSE = 5;
    private static boolean soundEnabled;
    private static int currentlyPlayingAudioIndex;
    private static int currentlyPlayingAudioVolume;
    private static int currentlyPlayingAudioLoopCount;

    private static InputStream getResourceAsStream(String string) {
        Maglet.getInstance();
        return Maglet.getResourceInputStream(string);
    }

    private static final void initializeArrays() {
        playerArray = new Player[1];
        indexOnPlayer = new int[1];
        numberOfTimesPlayed = new int[1];
        for (int i = 0; i < 1; ++i) {
            MagmicSound2.indexOnPlayer[i] = -1;
        }
    }

    private static final void initPlayers(int n) {
        byte[] byArray = null;
        try {
            byArray = MagmicSound2.readByteArray(fileNames[n]);
        }
        catch (Throwable throwable) {
            System.out.println("Exceptiong in initPlayers: " + throwable);
        }
        try {
            for (int i = 0; i < 1; ++i) {
                if (playerArray[i] != null) continue;
                MagmicSound2.playerArray[i] = Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), (String)mimeOfFile[n]);
                playerArray[i].realize();
                playerArray[i].prefetch();
                MagmicSound2.indexOnPlayer[i] = n;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final void play(int n, int n2, int n3) {
        int n4 = 0;
        byte[] byArray = null;
        for (int i = 0; i < 1; ++i) {
            if (numberOfTimesPlayed[i] < numberOfTimesPlayed[n4]) {
                n4 = i;
            }
            if (n != indexOnPlayer[i]) continue;
            try {
                ((VolumeControl)playerArray[i].getControl("VolumeControl")).setLevel(n3);
                playerArray[i].setLoopCount(n2);
                playerArray[n4].addPlayerListener(listener);
                playerArray[i].start();
                int n5 = i;
                numberOfTimesPlayed[n5] = numberOfTimesPlayed[n5] + 1;
                return;
            }
            catch (Throwable throwable) {
                System.out.println("Exception in playing: " + throwable);
            }
        }
        try {
            byArray = MagmicSound2.readByteArray(fileNames[n]);
        }
        catch (Throwable throwable) {
            System.out.println("Exception in play(): " + throwable);
        }
        try {
            playerArray[n4].deallocate();
            playerArray[n4].close();
        }
        catch (Throwable throwable) {
            System.out.println("Exception in play (close): = " + throwable);
        }
        MagmicSound2.playerArray[n4] = null;
        try {
            MagmicSound2.playerArray[n4] = Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), (String)mimeOfFile[n]);
            playerArray[n4].realize();
            playerArray[n4].prefetch();
            ((VolumeControl)playerArray[n4].getControl("VolumeControl")).setLevel(n3);
            playerArray[n4].setLoopCount(n2);
            MagmicSound2.indexOnPlayer[n4] = n;
            MagmicSound2.numberOfTimesPlayed[n4] = 1;
            playerArray[n4].addPlayerListener(listener);
            playerArray[n4].start();
        }
        catch (Throwable throwable) {
            System.out.println("Exception in play part 2: = " + throwable);
        }
    }

    private static final void stop(int n) {
        for (int i = 0; i < 1; ++i) {
            if (n != indexOnPlayer[i]) continue;
            try {
                playerArray[i].stop();
            }
            catch (Throwable throwable) {
                System.out.println("Exception in stop(): " + throwable);
            }
            break;
        }
    }

    private static final void free(int n) {
        try {
            MagmicSound2.fileNames[n] = null;
            MagmicSound2.mimeOfFile[n] = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = 0; i < 1; ++i) {
            if (n != indexOnPlayer[i]) continue;
            try {
                playerArray[i].deallocate();
                playerArray[i].close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            MagmicSound2.playerArray[i] = null;
            MagmicSound2.indexOnPlayer[i] = -1;
            MagmicSound2.numberOfTimesPlayed[i] = 0;
            break;
        }
    }

    private static final void pause() {
        MagmicSound2.stop(currentlyPlayingAudioIndex);
    }

    private static final void resume() {
        MagmicSound2.play(currentlyPlayingAudioIndex, currentlyPlayingAudioLoopCount, currentlyPlayingAudioVolume);
    }

    private static final void silence() {
        for (int i = 0; i < 1; ++i) {
            if (currentlyPlayingAudioIndex != indexOnPlayer[i]) continue;
            try {
                ((VolumeControl)playerArray[i].getControl("VolumeControl")).setLevel(0);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("error in silence(): " + throwable);
            }
        }
    }

    public static final void setCallingClass(Class clazz) {
        callingClass = clazz;
    }

    public static final int getState() {
        return state;
    }

    public static final void initializeAudio(int n) {
        if (state == 0) {
            arraySizes = n;
            fileNames = new String[n];
            mimeOfFile = new String[n];
            MagmicSound2.initializeArrays();
            state = 1;
        }
    }

    public static final int addAudio(String string) {
        if (state == 1 || state == 2) {
            state = 1;
            int n = -1;
            for (int i = 0; i < arraySizes; ++i) {
                if (fileNames[i] != null) continue;
                MagmicSound2.fileNames[i] = string;
                if (string.indexOf(FILE_EXTENSION_MIDI) != -1) {
                    MagmicSound2.mimeOfFile[i] = MIME_TYPE_MIDI;
                } else if (string.indexOf(FILE_EXTENSION_WAV) != -1) {
                    MagmicSound2.mimeOfFile[i] = MIME_TYPE_WAV;
                }
                n = i;
                break;
            }
            MagmicSound2.initPlayers(n);
            state = 2;
            return n;
        }
        return -1;
    }

    public static final void playAudio(int n, int n2, int n3) {
        MagmicSound2.stopAudio();
        if (state == 2 && soundEnabled) {
            currentlyPlayingAudioIndex = n;
            currentlyPlayingAudioLoopCount = n2;
            currentlyPlayingAudioVolume = n3;
            MagmicSound2.play(n, n2, n3);
            state = 4;
        }
    }

    public static final void stopAudio() {
        if (state == 4 || state == 5) {
            MagmicSound2.stop(currentlyPlayingAudioIndex);
            state = 2;
        }
    }

    public static final void pauseAudio() {
        if (state == 4) {
            MagmicSound2.pause();
            state = 5;
        }
    }

    public static final void resumeAudio() {
        if (state == 5 && soundEnabled) {
            MagmicSound2.resume();
            state = 4;
        }
    }

    public static final void freeAudio(int n) {
        if (state != 0) {
            if (n == currentlyPlayingAudioIndex) {
                MagmicSound2.stopAudio();
            }
            MagmicSound2.free(n);
        }
    }

    public static final void freeAudio(String string) {
        for (int i = 0; i < arraySizes; ++i) {
            if (!string.equals(fileNames[i])) continue;
            MagmicSound2.free(i);
        }
    }

    public static final void setSoundEnabled(boolean bl) {
        soundEnabled = bl;
    }

    public static final boolean isSoundEnabled() {
        return soundEnabled;
    }

    private static final byte[] readByteArray(String string) {
        try {
            InputStream inputStream = MagmicSound2.getResourceAsStream(string);
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        listener = new PlayerListener(){

            public void playerUpdate(Player player, String string, Object object) {
            }
        };
        currentlyPlayingAudioIndex = -1;
    }
}

