/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.magmicSound.ui;

import com.magmic.maglet.Maglet;
import com.magmic.magmicSound.MagmicSound2;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import javax.microedition.lcdui.Font;

public final class MagmicSoundPrompt {
    public static final byte STATE_RUNNING = 0;
    public static final byte STATE_EXIT = 1;
    private static byte state;
    private static final int wave_1 = 0;
    private static final int wave_2 = 1;
    private static final int wave_3 = 2;
    private static final int red_circle = 3;
    private static final int yellow_circle = 4;
    private static final int grey_speaker = 5;
    private static final int yellow_speaker = 6;
    private static final int[] xPos;
    private static final int[] yPos;
    private static final int[] width;
    private static final int[] height;
    private static final int MAX_DELTA = 400;
    private static int animationState;
    private static final int STATE_ANIMATION_WAVE1 = 0;
    private static final int STATE_ANIMATION_WAVE2 = 1;
    private static final int STATE_ANIMATION_WAVE3 = 2;
    private static MagmicImage spImage;
    private static MagmicImage soundImage;
    private static MagmicImage onImage;
    private static MagmicImage offImage;
    private static MagmicImage okImage;
    public static final int SELECTION_SOUND_OFF = 1;
    public static final int SELECTION_SOUND_ON = 0;
    private static int deltaTime;
    private static long lastTime;
    private static boolean soundEnabled;
    private static Maglet app;
    private static int selectedIndex;

    public boolean processEvent(int n, int n2, int n3, Object object) {
        switch (n) {
            case 4: {
                lastTime = System.currentTimeMillis();
                app.enableTickEvents(10L);
                return true;
            }
            case 1: {
                this.paint((MagmicGraphics)object);
                return true;
            }
            case 6: {
                lastTime = System.currentTimeMillis();
                return true;
            }
            case 3: {
                return this.tick();
            }
            case 9: {
                return this.keyDown(app.getGameAction(n2));
            }
        }
        return false;
    }

    public MagmicSoundPrompt(Maglet maglet) {
        app = maglet;
    }

    private final void paint(MagmicGraphics magmicGraphics) {
        int n = app.getWidth() / 4 - width[6] / 2;
        int n2 = app.getHeight() / 2 - height[6] / 2;
        int n3 = app.getWidth() * 3 / 4 - width[5] / 2;
        int n4 = app.getHeight() / 2 - height[5] / 2;
        int n5 = app.getWidth() / 2 - (soundImage.getWidth() + onImage.getWidth()) / 2;
        int n6 = app.getHeight() / 2 - height[4];
        int n7 = app.getWidth() / 2 - okImage.getWidth() / 2;
        int n8 = app.getHeight() / 2 + height[4];
        magmicGraphics.setColor(0);
        magmicGraphics.fillRect(0, 0, app.getWidth(), app.getHeight());
        soundImage.draw(magmicGraphics, n5, n6);
        okImage.draw(magmicGraphics, n7, n8);
        switch (animationState) {
            case 0: {
                spImage.drawRegion(magmicGraphics, n + width[6], app.getHeight() / 2 - height[0] / 2, width[0], height[0], xPos[0], yPos[0]);
                break;
            }
            case 1: {
                spImage.drawRegion(magmicGraphics, n + width[6], app.getHeight() / 2 - height[1] / 2, width[1], height[1], xPos[1], yPos[1]);
                break;
            }
            case 2: {
                spImage.drawRegion(magmicGraphics, n + width[6], app.getHeight() / 2 - height[2] / 2, width[2], height[2], xPos[2], yPos[2]);
            }
        }
        if (soundEnabled) {
            spImage.drawRegion(magmicGraphics, n, n2, width[6], height[6], xPos[6], yPos[6]);
            spImage.drawRegion(magmicGraphics, n - width[6] / 2, app.getHeight() / 2 - height[4] / 2, width[4], height[4], xPos[4], yPos[4]);
            spImage.drawRegion(magmicGraphics, n3, n4, width[5], height[5], xPos[5], yPos[5]);
            spImage.drawRegion(magmicGraphics, n3 - width[5] / 2, app.getHeight() / 2 - height[3] / 2, width[3], height[3], xPos[3], yPos[3]);
            onImage.draw(magmicGraphics, n5 + soundImage.getWidth(), n6);
        } else {
            spImage.drawRegion(magmicGraphics, n, n4, width[5], height[5], xPos[5], yPos[5]);
            spImage.drawRegion(magmicGraphics, n3, n2, width[6], height[6], xPos[6], yPos[6]);
            spImage.drawRegion(magmicGraphics, n3 - width[5] / 2, app.getHeight() / 2 - height[3] / 2, width[3], height[3], xPos[3], yPos[3]);
            spImage.drawRegion(magmicGraphics, n3 - width[6] / 2 - 2, app.getHeight() / 2 - height[4] / 2, width[4], height[4], xPos[4], yPos[4]);
            offImage.draw(magmicGraphics, n5 + soundImage.getWidth(), n6);
        }
        magmicGraphics.setColor(0xFFFFFF);
        magmicGraphics.fillRect(0, app.getHeight() - Font.getDefaultFont().getHeight(), app.getWidth(), app.getHeight());
        magmicGraphics.setColor(0);
        magmicGraphics.drawString(" OK", 0, app.getHeight() - Font.getDefaultFont().getHeight(), 0x10 | 4);
    }

    private final boolean keyDown(int n) {
        switch (n) {
            case 2: {
                soundEnabled = true;
                return true;
            }
            case 5: {
                soundEnabled = false;
                return true;
            }
            case 8: {
                state = 1;
                MagmicSound2.setSoundEnabled(soundEnabled);
                return true;
            }
            case 30: {
                state = 1;
                MagmicSound2.setSoundEnabled(soundEnabled);
                return true;
            }
        }
        return false;
    }

    public static final int getState() {
        return state;
    }

    private final boolean tick() {
        long l = System.currentTimeMillis();
        deltaTime += (int)(l - lastTime);
        lastTime = l;
        switch (state) {
            case 0: {
                app.invalidateScreen();
                if (deltaTime >= 400) {
                    switch (animationState) {
                        case 0: {
                            deltaTime = 0;
                            animationState = 1;
                            break;
                        }
                        case 1: {
                            deltaTime = 0;
                            animationState = 2;
                            break;
                        }
                        case 2: {
                            deltaTime = 0;
                            animationState = 0;
                        }
                    }
                }
                return true;
            }
            case 1: {
                app.enableTickEvents(0L);
                spImage = null;
                return true;
            }
        }
        return false;
    }

    static {
        xPos = new int[]{0, 17, 36, 56, 87, 122, 122};
        yPos = new int[]{0, 0, 0, 7, 6, 0, 22};
        width = new int[]{17, 19, 20, 31, 35, 18, 18};
        height = new int[]{41, 41, 41, 31, 35, 22, 19};
        animationState = 0;
        spImage = MagmicImage.loadMagmicImage("/sound_prompt.png");
        soundImage = MagmicImage.loadMagmicImage("/sound.png");
        onImage = MagmicImage.loadMagmicImage("/on.png");
        offImage = MagmicImage.loadMagmicImage("/off.png");
        okImage = MagmicImage.loadMagmicImage("/ok.png");
    }
}

