/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.pykegame;

import com.magmic.MagmicGame;
import com.magmic.MagmicIO;
import com.magmic.maglet.Maglet;
import com.magmic.pykegame.FontCutData;
import com.magmic.pykegame.GameData;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import java.io.IOException;
import java.io.InputStream;

public class FontData {
    public int line_height;
    public int base_line;
    public byte spacer_x;
    public byte spacer_y;
    public char[] supported_char_ranges;
    public char[] supported_char_singles;
    public FontCutData[] cuts;
    public int[] cut_indexes;
    public char default_char;
    public MagmicImage fontImage;

    public void init(int n) {
        try {
            MagmicImage magmicImage = MagmicGame.loadMagmicImage(GameData.fonts[n]);
            String string = "/" + n + ".fnt";
            Maglet.getInstance();
            InputStream inputStream = Maglet.getResourceInputStream(string);
            this.init(inputStream, magmicImage);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void init(InputStream inputStream, MagmicImage magmicImage) {
        int n;
        this.fontImage = magmicImage;
        MagmicIO magmicIO = new MagmicIO();
        magmicIO.bind(inputStream);
        this.line_height = magmicIO.read_u16();
        this.base_line = magmicIO.read_u16();
        this.spacer_x = magmicIO.read_s8();
        this.spacer_y = magmicIO.read_s8();
        int n2 = magmicIO.read_u16();
        int n3 = magmicIO.read_u16();
        int n4 = magmicIO.read_u16();
        int n5 = magmicIO.read_u16();
        boolean bl = n5 > 0;
        this.default_char = magmicIO.read_char();
        this.supported_char_ranges = new char[n2 * 2];
        this.supported_char_singles = new char[n3];
        for (n = 0; n < this.supported_char_ranges.length; ++n) {
            this.supported_char_ranges[n] = magmicIO.read_char();
        }
        for (n = 0; n < this.supported_char_singles.length; ++n) {
            this.supported_char_singles[n] = magmicIO.read_char();
        }
        this.cuts = new FontCutData[n4];
        for (n = 0; n < this.cuts.length; ++n) {
            FontCutData fontCutData = this.cuts[n] = new FontCutData();
            fontCutData.x = (short)magmicIO.read_u16();
            fontCutData.y = (short)magmicIO.read_u16();
            fontCutData.w = magmicIO.read_u8();
            fontCutData.start = magmicIO.read_s8();
            fontCutData.trail = magmicIO.read_s8();
        }
        if (bl) {
            this.cut_indexes = new int[n5];
            for (n = 0; n < this.cut_indexes.length; ++n) {
                this.cut_indexes[n] = magmicIO.read_s32();
            }
        }
    }

    public void destroy() {
        this.supported_char_ranges = null;
        this.supported_char_singles = null;
        this.cuts = null;
        this.cut_indexes = null;
        this.fontImage = null;
    }

    public FontCutData get_cut_for(char c) {
        int n;
        int n2 = 0;
        boolean bl = false;
        for (n = 0; !bl && n < this.supported_char_ranges.length / 2; ++n) {
            char c2 = this.supported_char_ranges[n * 2];
            char c3 = this.supported_char_ranges[n * 2 + 1];
            if (c >= c2 && c <= c3) {
                n2 += c - c2;
                bl = true;
                continue;
            }
            n2 += c3 - c2 + 1;
        }
        for (n = 0; !bl && n < this.supported_char_singles.length; ++n) {
            if (c == this.supported_char_singles[n]) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            if (this.cut_indexes == null) {
                return this.cuts[n2];
            }
            return this.cuts[this.cut_indexes[n2]];
        }
        return this.get_cut_for(this.default_char);
    }

    public boolean is_supported_character(char c) {
        int n;
        for (n = 0; n < this.supported_char_ranges.length / 2; ++n) {
            char c2 = this.supported_char_ranges[n * 2];
            char c3 = this.supported_char_ranges[n * 2 + 1];
            if (c < c2 || c > c3) continue;
            return true;
        }
        for (n = 0; n < this.supported_char_singles.length; ++n) {
            if (c != this.supported_char_singles[n]) continue;
            return true;
        }
        return false;
    }

    public int paint_char(MagmicGraphics magmicGraphics, char c, int n, int n2) {
        switch (c) {
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\n': {
                return 0;
            }
        }
        return this.paint_cut(magmicGraphics, this.get_cut_for(c), n, n2);
    }

    public int paint_cut(MagmicGraphics magmicGraphics, FontCutData fontCutData, int n, int n2) {
        this.fontImage.drawRegion(magmicGraphics, n -= fontCutData.start, n2, fontCutData.w, this.line_height, fontCutData.x, fontCutData.y);
        return -fontCutData.start + fontCutData.w + this.spacer_x - fontCutData.trail;
    }

    public int get_char_width(char c) {
        switch (c) {
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\n': {
                return 0;
            }
        }
        FontCutData fontCutData = this.get_cut_for(c);
        return -fontCutData.start + fontCutData.w - fontCutData.trail;
    }
}

