/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.Font;
import com.magmic.K;
import com.magmic.MagmicGame;
import com.magmic.MagmicIO;
import com.magmic.MagmicStringBuffer;
import com.magmic.Window;
import com.magmic.kahuna.BoardLayer;
import com.magmic.maglet.Maglet;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.ui.MagmicGraphics;
import java.io.InputStream;

public class LevelSelectionWindow
extends Window {
    public Font font;
    public String levelName;
    public boolean showBonusWord;
    public boolean showTiki;
    public int levelLock;
    public boolean receivedKeyDown;

    public LevelSelectionWindow(MagmicGame magmicGame) {
        super(magmicGame);
        this.left_softkey_label = " Back";
        this.font = magmicGame.systemFont;
    }

    public void open(MagmicLayer magmicLayer) {
        super.open(magmicLayer);
        this.receivedKeyDown = false;
        this.levelLock = this.maglet.score.getFurthestLevelCompleted(this.maglet.gameMode) + 1;
        if (MagmicGame.cheatPlayAllLevels) {
            this.levelLock = K.numberOfLevel;
        }
        if (this.levelLock >= K.numberOfLevel) {
            this.levelLock = K.numberOfLevel - 1;
            this.loadLevel(0);
        } else {
            this.loadLevel(this.levelLock);
        }
    }

    public void close() {
        super.close();
    }

    public void paint(MagmicGraphics magmicGraphics) {
        super.paint(magmicGraphics);
        if (this.isTransiting()) {
            return;
        }
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        int n = this.center_y;
        int n2 = this.center_x;
        int n3 = this.maglet.levelId;
        int n4 = this.maglet.gameMode;
        magmicStringBuffer.clear();
        magmicStringBuffer.append("Level #");
        magmicStringBuffer.append(n3 + 1);
        this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
        magmicStringBuffer.clear();
        magmicStringBuffer.append(this.levelName);
        this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n += this.font.line_height, this.center_w);
        int n5 = n;
        n += this.font.line_height * this.font.line_count_of_last_rendering;
        n += this.font.line_height;
        magmicStringBuffer.clear();
        magmicStringBuffer.append("Best score: ");
        if (this.maglet.score.getScore(n3, n4) > 99999L) {
            magmicStringBuffer.append("\n  ");
        }
        magmicStringBuffer.append((int)this.maglet.score.getScore(n3, n4));
        this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
        n += this.font.line_height * this.font.line_count_of_last_rendering;
        magmicStringBuffer.clear();
        magmicStringBuffer.append("Best average: ");
        int n6 = this.maglet.score.getAverage(n3, n4);
        magmicStringBuffer.append(n6 / 10);
        magmicStringBuffer.append('.');
        magmicStringBuffer.append(n6 % 10);
        this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
        n += this.font.line_height * this.font.line_count_of_last_rendering;
        if (this.showTiki) {
            magmicStringBuffer.clear();
            magmicStringBuffer.append("Best tiki rise: ");
            magmicStringBuffer.append(this.maglet.score.getTiki(n3, n4));
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
            n += this.font.line_height * this.font.line_count_of_last_rendering;
        }
        if (this.showBonusWord) {
            magmicStringBuffer.clear();
            magmicStringBuffer.append("Bonus word:\n  ");
            magmicStringBuffer.append(this.maglet.score.foundBonusWord(n3, n4) ? "Found" : "Not Found");
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
            n += this.font.line_height * this.font.line_count_of_last_rendering;
        }
        magmicStringBuffer.clear();
        magmicStringBuffer.append("Best time: ");
        this.maglet.appendTime((int)this.maglet.score.getTime(n3, n4), magmicStringBuffer);
        this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n);
        n += this.font.line_height * this.font.line_count_of_last_rendering;
        if (this.levelLock > 0) {
            int n7 = this.x + (this.center_x - this.x - this.maglet.arrowLeft.getWidth()) / 2;
            int n8 = this.x + this.w - (this.center_x + this.center_w);
            int n9 = this.center_x + this.center_w + (n8 - this.maglet.arrowRight.getWidth()) / 2;
            int n10 = n5 + (this.font.line_height - this.maglet.arrowLeft.getHeight()) / 2;
            this.maglet.arrowLeft.draw(magmicGraphics, n7, n10);
            this.maglet.arrowRight.draw(magmicGraphics, n9, n10);
        }
    }

    public boolean tick(int n) {
        return super.tick(n);
    }

    public boolean key_down(int n, int n2) {
        if (this.isTransiting()) {
            return false;
        }
        this.receivedKeyDown = true;
        switch (n) {
            case 3: 
            case 5: {
                this.loadLevel(this.maglet.levelId + 1);
                break;
            }
            case 2: 
            case 4: {
                this.loadLevel(this.maglet.levelId - 1);
            }
        }
        return false;
    }

    public boolean key_up(int n, int n2) {
        if (this.isTransiting()) {
            return false;
        }
        if (!this.receivedKeyDown) {
            return false;
        }
        switch (n) {
            case 1: {
                if (this.maglet.rootLayer == 3) {
                    this.maglet.changeRootLayer(4);
                    break;
                }
                this.close();
                break;
            }
            case 6: {
                if (this.maglet.rootLayer != 3) {
                    this.maglet.changeRootLayer(3);
                    break;
                }
                BoardLayer boardLayer = (BoardLayer)this.maglet.get_root_layer();
                if (!boardLayer.board.readLevel(Maglet.getResourceInputStream(K.getLevelFilename(this.maglet.levelId, this.maglet.gameMode)))) {
                    // empty if block
                }
                this.close();
            }
        }
        return true;
    }

    public boolean loadLevel(int n) {
        if (n < 0) {
            n = this.levelLock;
        }
        if (n > this.levelLock) {
            n = 0;
        }
        InputStream inputStream = Maglet.getResourceInputStream(K.getLevelFilename(n, this.maglet.gameMode));
        MagmicIO magmicIO = MagmicGame.maglet.io;
        magmicIO.bind(inputStream);
        this.maglet.levelId = n;
        this.levelName = magmicIO.read_string_8();
        this.showBonusWord = magmicIO.read_string_8().length() > 0;
        short s = magmicIO.read_u8();
        this.showTiki = (s & 2) != 0;
        return magmicIO.exception == null;
    }
}

