/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.pykegame;

import com.magmic.MagmicIO;
import com.magmic.MagmicStringBuffer;
import java.io.InputStream;

public class StringTable {
    public static final char CHAR_NULL = '\u0000';
    public static final char CHAR_WAIT = '\u0001';
    public static final char CHAR_NEW_LINE = '\n';
    public static final char CHAR_PAGE_BREAK = '\u0002';
    public static final char CHAR_JUSTIFY_LEFT = '\u0003';
    public static final char CHAR_JUSTIFY_CENTER = '\u0004';
    public static final char CHAR_JUSTIFY_RIGHT = '\u0005';
    public static final char CHAR_SPACE = ' ';
    public int char_width;
    public int number_of_strings;
    public char[] char_table;
    public int[] offset_table;
    public byte[] string_table;
    public MagmicIO io = new MagmicIO();

    public void init(InputStream inputStream) {
        int n;
        this.io.bind(inputStream);
        this.char_width = this.io.read_u8();
        this.number_of_strings = (int)this.io.read_u32();
        int n2 = this.io.read_u16();
        int n3 = (int)this.io.read_u32();
        this.char_table = new char[n2];
        for (n = 0; n < n2; ++n) {
            this.char_table[n] = this.io.read_char();
        }
        this.offset_table = new int[this.number_of_strings];
        for (n = 0; n < this.number_of_strings; ++n) {
            this.offset_table[n] = (int)this.io.read_u32();
        }
        this.string_table = new byte[n3];
        this.io.read_bytes(this.string_table);
        this.io.bind(this.string_table, 0, this.string_table.length);
    }

    public void destroy() {
        this.string_table = null;
    }

    public int get_string_offset(int n) {
        return this.offset_table[n];
    }

    public int get_encoded_char(int n) {
        this.io.set_pointer(n);
        switch (this.char_width) {
            case 1: {
                return this.io.read_u8();
            }
            case 2: {
                return this.io.read_u16();
            }
        }
        return 0;
    }

    public char get_char(int n, int n2) {
        return (char)this.run_string(n, n2, 0);
    }

    public char get_char(int n, int n2, int n3) {
        return (char)this.run_string(n, n2, n3);
    }

    public int get_param_u16(int n, int n2) {
        return this.run_string(n, n2, 0);
    }

    public int get_length(int n) {
        return this.run_string(n, -1, 0);
    }

    private int run_string(int n, int n2, int n3) {
        char c;
        this.io.set_pointer(this.get_string_offset(n) + n3);
        int n4 = 0;
        do {
            int n5 = this.char_width == 1 ? this.io.read_u8() : this.io.read_u16();
            c = this.char_table[n5];
            if (n4 == n2) {
                return c;
            }
            if (c == '\u0000') continue;
            ++n4;
            if (c != '\u0001') continue;
            int n6 = this.io.read_u16();
            if (n4 == n2) {
                return n6;
            }
            ++n4;
        } while (c != '\u0000');
        return n4;
    }

    public int get_param_u16(int n) {
        this.io.set_pointer(n);
        return this.io.read_u16();
    }

    public int get_string(int n, char[] cArray, int n2) {
        char c;
        this.io.set_pointer(this.get_string_offset(n));
        int n3 = 0;
        do {
            int n4;
            if ((c = this.char_table[n4 = this.char_width == 1 ? this.io.read_u8() : this.io.read_u16()]) == '\u0000') continue;
            cArray[n2 + n3] = c;
            ++n3;
            if (c != '\u0001') continue;
            cArray[n2 + n3] = this.io.read_char();
            ++n3;
        } while (c != '\u0000');
        return n3;
    }

    public String get_string_object(int n) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.io.set_pointer(this.get_string_offset(n));
        int n2 = 0;
        do {
            int n3;
            if ((c = this.char_table[n3 = this.char_width == 1 ? this.io.read_u8() : this.io.read_u16()]) == '\u0000') continue;
            stringBuffer.append(c);
            ++n2;
            if (c != '\u0001') continue;
            stringBuffer.append(this.io.read_char());
            ++n2;
        } while (c != '\u0000');
        return stringBuffer.toString();
    }

    public void append_string(int n, MagmicStringBuffer magmicStringBuffer) {
        magmicStringBuffer.length += this.get_string(n, magmicStringBuffer.chars, magmicStringBuffer.length);
    }
}

