/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.pykegame;

import com.magmic.SoftKeyManager;
import com.magmic.maglet.Maglet;
import com.magmic.maglet.MagletGameCanvas;
import com.magmic.pykegame.LayerStackInfo;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;

public abstract class LayeredMaglet
extends Maglet {
    public static MagletGameCanvas GAME_CANVAS;
    public long last_tick_timestamp;
    public int delta_time_accumulator;
    public int delta_time;
    public int delta_time_without_crop;
    public boolean shutted_down = false;
    public boolean initialized = false;
    public SoftKeyManager softKeyManager;
    public MagmicLayer softKeyOwner;
    public boolean updateSoftKeys;
    public MagmicImage fullscreenBackbuffer;
    public MagmicGraphics fullscreenBackbufferGraphics;
    public boolean repaintFullscreenBackbuffer;
    public LayerStackInfo[] layer_stack = new LayerStackInfo[10];
    public int layer_stack_size;
    private boolean ignoreNextKeyUp = false;
    public static final int GAME_VK_NONE = -1;
    public int lastGetGameKeyRepeat;

    public LayeredMaglet() {
        for (int i = 0; i < 10; ++i) {
            this.layer_stack[i] = new LayerStackInfo();
        }
        this.layer_stack_size = 0;
        GAME_CANVAS = Maglet.getInstance().getMagletGameCanvas();
    }

    public final boolean processEvent(int n, int n2, int n3, Object object) {
        if (this.shutted_down) {
            return false;
        }
        if (!this.initialized && n != 4) {
            return false;
        }
        if (n == 1 && this.fullscreenBackbuffer != null && this.repaintFullscreenBackbuffer) {
            this.fullscreenBackbufferGraphics.setClip(0, 0, this.get_width(), this.get_height());
        }
        this.pre_process_event(n, n2, n3, object);
        boolean bl = false;
        block0 : switch (n) {
            case 4: {
                this.softKeyManager = new SoftKeyManager(this.theGameCanvas);
                this.process_event_init();
                this.last_tick_timestamp = Maglet.currentTimeMillis();
                this.enableTickEvents(20L);
                this.initialized = true;
                bl = true;
                break;
            }
            case 7: {
                for (int i = this.layer_stack_size - 1; i >= 0; --i) {
                    if (this.layer_stack[i].status != 0) continue;
                    this.remove_layer(this.layer_stack[i].layer, true);
                }
                this.shutted_down = true;
                bl = true;
                break;
            }
            case 5: {
                this.ignoreNextKeyUp = true;
                for (int i = this.layer_stack_size - 1; i >= 0; --i) {
                    if (this.layer_stack[i].status != 0) continue;
                    bl |= this.layer_stack[i].layer.pause();
                    if (this.layer_stack[i].is_pause_resume_modal) break block0;
                }
                break;
            }
            case 6: {
                for (int i = this.layer_stack_size - 1; i >= 0; --i) {
                    if (this.layer_stack[i].status != 0) continue;
                    bl |= this.layer_stack[i].layer.resume();
                    if (this.layer_stack[i].is_pause_resume_modal) break;
                }
                this.consume_delta_time();
                break;
            }
            case 1: {
                int n4;
                MagmicGraphics magmicGraphics = (MagmicGraphics)object;
                this.updateSoftKeyLabels();
                this.softKeyManager.paint(magmicGraphics);
                magmicGraphics.setClip(0, 0, this.get_width(), this.get_height());
                for (n4 = this.layer_stack_size - 1; !(n4 < 0 || this.layer_stack[n4].status == 0 && this.layer_stack[n4].is_paint_modal); --n4) {
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (this.fullscreenBackbuffer != null) {
                    if (this.repaintFullscreenBackbuffer) {
                        for (int i = n4; i < this.layer_stack_size; ++i) {
                            if (this.layer_stack[i].status != 0) continue;
                            this.layer_stack[i].layer.paintBackBuffer(this.fullscreenBackbufferGraphics);
                        }
                        this.repaintFullscreenBackbuffer = false;
                    }
                    this.fullscreenBackbuffer.draw(magmicGraphics, 0, 0);
                }
                this.layer_stack[this.layer_stack_size - 1].layer.paint(magmicGraphics);
                break;
            }
            case 3: {
                long l = Maglet.currentTimeMillis();
                this.delta_time_accumulator += (int)(l - this.last_tick_timestamp);
                this.last_tick_timestamp = l;
                if (this.delta_time_accumulator < 50) break;
                this.delta_time_without_crop = this.delta_time_accumulator;
                if (this.delta_time_accumulator > 100) {
                    this.delta_time_accumulator = 100;
                }
                this.delta_time = this.delta_time_accumulator;
                for (int i = this.layer_stack_size - 1; i >= 0; --i) {
                    if (this.layer_stack[i].status != 0) continue;
                    bl |= this.layer_stack[i].layer.tick(this.delta_time);
                    if (this.layer_stack[i].is_tick_modal) break;
                }
                this.delta_time_accumulator = 0;
                break;
            }
            case 9: 
            case 21: 
            case 23: {
                this.ignoreNextKeyUp = false;
                int n5 = this.get_game_key(n, n2, n3, object);
                if (n5 == -1) break;
                for (int i = this.layer_stack_size - 1; i >= 0; --i) {
                    if (this.layer_stack[i].status != 0) continue;
                    int n6 = n5;
                    for (int j = 0; j < this.lastGetGameKeyRepeat; ++j) {
                        bl |= this.layer_stack[i].layer.key_down(n6, n == 9 ? n2 : -1);
                    }
                    if (this.layer_stack[i].is_key_modal) break block0;
                }
                break;
            }
            case 8: 
            case 22: {
                if (this.ignoreNextKeyUp) {
                    this.ignoreNextKeyUp = false;
                    break;
                }
                int n7 = this.get_game_key(n, n2, n3, object);
                if (n7 == -1) break;
                for (int i = this.layer_stack_size - 1; i >= 0; --i) {
                    if (this.layer_stack[i].status != 0) continue;
                    bl |= this.layer_stack[i].layer.key_up(n7, n == 8 ? n2 : -1);
                    if (this.layer_stack[i].is_key_modal) break block0;
                }
                break;
            }
            default: {
                bl = false;
            }
        }
        this.post_process_event(n, n2, n3, object);
        if ((bl |= this.run_layer_log()) && n != 1 && n != 7) {
            this.invalidateScreen();
        }
        return bl;
    }

    public abstract void process_event_init();

    public abstract void post_process_event(int var1, int var2, int var3, Object var4);

    public abstract void pre_process_event(int var1, int var2, int var3, Object var4);

    public abstract void changeRootLayer(int var1);

    public abstract int get_game_key(int var1, int var2, int var3, Object var4);

    public void shutdown_application() {
        this.postEvent(7, 0, 0, null, 15);
    }

    public void consume_delta_time() {
        this.delta_time_accumulator = 0;
        this.last_tick_timestamp = Maglet.currentTimeMillis();
    }

    public int get_width() {
        return super.getWidth();
    }

    public int get_height() {
        int n = super.getHeight();
        return n -= this.softKeyManager.getLabelHeight();
    }

    public void push_layer(MagmicLayer magmicLayer, boolean bl, boolean bl2, boolean bl3, boolean bl4, byte by) {
        LayerStackInfo layerStackInfo = this.layer_stack[this.layer_stack_size];
        layerStackInfo.layer = magmicLayer;
        layerStackInfo.is_key_modal = bl;
        layerStackInfo.is_paint_modal = bl2;
        layerStackInfo.is_tick_modal = bl3;
        layerStackInfo.is_pause_resume_modal = bl4;
        layerStackInfo.z_order = by;
        layerStackInfo.status = 1;
        ++this.layer_stack_size;
    }

    public void set_layer_modality(MagmicLayer magmicLayer, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        for (int i = 0; i < this.layer_stack_size; ++i) {
            if (this.layer_stack[i].layer != magmicLayer) continue;
            LayerStackInfo layerStackInfo = this.layer_stack[i];
            layerStackInfo.is_key_modal = bl;
            layerStackInfo.is_paint_modal = bl2;
            layerStackInfo.is_tick_modal = bl3;
            layerStackInfo.is_pause_resume_modal = bl4;
        }
    }

    public void remove_layer(MagmicLayer magmicLayer, boolean bl) {
        if (bl) {
            magmicLayer.destroy();
        }
        for (int i = this.layer_stack_size - 1; i >= 0; --i) {
            if (this.layer_stack[i].layer != magmicLayer) continue;
            this.layer_stack[i].status = (byte)2;
            break;
        }
    }

    public boolean is_layer_visible(MagmicLayer magmicLayer) {
        for (int i = this.layer_stack_size - 1; i >= 0; --i) {
            if (this.layer_stack[i].status != 0 || magmicLayer != this.layer_stack[i].layer) continue;
            return true;
        }
        return false;
    }

    public boolean is_layer_on_top(MagmicLayer magmicLayer) {
        return this.layer_stack[this.layer_stack_size - 1].layer == magmicLayer;
    }

    public MagmicLayer get_root_layer() {
        if (this.layer_stack_size > 0) {
            return this.layer_stack[0].layer;
        }
        return null;
    }

    public MagmicLayer get_top_layer() {
        return this.layer_stack[this.layer_stack_size - 1].layer;
    }

    public boolean run_layer_log() {
        boolean bl = false;
        for (int i = 0; i < this.layer_stack_size; ++i) {
            int n;
            LayerStackInfo layerStackInfo = this.layer_stack[i];
            if (layerStackInfo.status == 2) {
                bl = true;
                layerStackInfo.status = 0;
                for (n = i + 1; n < this.layer_stack_size; ++n) {
                    this.layer_stack[n - 1] = this.layer_stack[n];
                }
                --this.layer_stack_size;
                this.layer_stack[this.layer_stack_size] = layerStackInfo;
                --i;
                continue;
            }
            if (layerStackInfo.status != 1) continue;
            bl = true;
            layerStackInfo.status = 0;
            layerStackInfo.layer.show();
            for (n = i; n > 0 && this.layer_stack[n - 1].z_order > layerStackInfo.z_order; --n) {
                LayerStackInfo layerStackInfo2 = this.layer_stack[n - 1];
                this.layer_stack[n - 1] = this.layer_stack[n];
                this.layer_stack[n] = layerStackInfo2;
            }
        }
        return bl;
    }

    public void updateSoftKeyLabels() {
        MagmicLayer magmicLayer = null;
        for (int i = this.layer_stack_size - 1; i >= 0; --i) {
            if (this.layer_stack[i].status != 0) continue;
            LayerStackInfo layerStackInfo = this.layer_stack[i];
            if (!layerStackInfo.is_key_modal && i != 0) continue;
            magmicLayer = layerStackInfo.layer;
            break;
        }
        if (magmicLayer != this.softKeyOwner || this.updateSoftKeys) {
            this.updateSoftKeys = false;
            if (magmicLayer == null) {
                this.softKeyManager.setSoftKeys("", "");
            } else {
                this.softKeyManager.setSoftKeys(magmicLayer.left_softkey_label, magmicLayer.right_softkey_label);
            }
            this.softKeyOwner = magmicLayer;
        }
    }
}

