/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import com.magmic.maglet.Maglet;
import com.magmic.maglet.MagletGameCanvas;
import com.magmic.ui.MagmicGraphics;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;

public class SoftKeyManager {
    public static final int NUM_POSITIONS = 3;
    public static final short PRIORITY_HIGH = 1;
    public static final short PRIORITY_MEDIUM = 2;
    public static final short PRIORITY_LOW = 3;
    public static final int POSITION_MIDDLE = 0;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    private static final String STR_EMPTY = "";
    private static final String STR_FILLER = " ";
    private static final String STR_STD_MIDDLE_LABEL = " ";
    private static final String STR_STD_LEFT_LABEL = "OK";
    private static final String STR_STD_RIGHT_LABEL = "BACK";
    private static final int TYPE_STD_MIDDLE = 4;
    private static final int TYPE_STD_LEFT = 1;
    private static final int TYPE_STD_RIGHT = 8;
    private static final short PRI_STD_MIDDLE = 1;
    private static final short PRI_STD_LEFT = 2;
    private static final short PRI_STD_RIGHT = 3;
    private static final int COL_STD_LABEL_COLOR = 0xFFFFFF;
    private static final int COL_STD_FONT_COLOR = 0;
    private static final Font FNT_STD_LABEL_FONT = Font.getDefaultFont();
    private Displayable dispMyDisplay = null;
    private Command cmdMiddle;
    private Command cmdLeft;
    private Command cmdRight;
    private boolean blnHasMiddleCommand = false;
    private boolean blnHasLeftCommand = false;
    private boolean blnHasRightCommand = false;
    private int intLabelHeight;
    private int colLabelColor;
    private int colFontColor;
    private Font fntLabelFont = FNT_STD_LABEL_FONT;

    public SoftKeyManager(MagletGameCanvas magletGameCanvas) {
        this.setFontColor(0);
        this.intLabelHeight = FNT_STD_LABEL_FONT.getHeight();
        this.setLabelColor(0xFFFFFF);
    }

    public boolean paint(MagmicGraphics magmicGraphics) {
        int n = Maglet.getInstance().getWidth();
        int n2 = Maglet.getInstance().getHeight();
        magmicGraphics.setColor(this.colLabelColor);
        magmicGraphics.fillRect(0, n2 - this.intLabelHeight, n, this.intLabelHeight);
        magmicGraphics.getGraphics().setFont(this.fntLabelFont);
        magmicGraphics.setColor(this.colFontColor);
        int n3 = 0;
        int n4 = n / 2;
        int n5 = n;
        int n6 = n2 - this.intLabelHeight;
        if (this.blnHasLeftCommand) {
            magmicGraphics.drawString(this.cmdLeft.getLabel(), n3, n6, 20);
        }
        if (this.blnHasRightCommand) {
            magmicGraphics.drawString(this.cmdRight.getLabel(), n5, n6, 24);
        }
        if (this.blnHasMiddleCommand) {
            magmicGraphics.drawString(this.cmdMiddle.getLabel(), n4, n6, 17);
        }
        return true;
    }

    public void setLabelColor(int n) {
        this.colLabelColor = this.validateColor(n);
    }

    public int getLabelColor() {
        return this.colLabelColor;
    }

    public void setFontColor(int n) {
        this.colFontColor = this.validateColor(n);
    }

    public int getLabelHeight() {
        return this.intLabelHeight;
    }

    public boolean setSoftKeys(Command command, Command command2) {
        boolean bl = true;
        this.clearSoftKeys();
        bl = bl && this.setSoftKey(command, 1);
        bl = bl && this.setSoftKey(command2, 2);
        return bl;
    }

    public boolean setSoftKeys() {
        return this.setSoftKeys(STR_STD_LEFT_LABEL, 1, (short)2, STR_STD_RIGHT_LABEL, 8, (short)3);
    }

    public boolean setSoftKeys(String string, String string2) {
        return this.setSoftKeys(string, 1, (short)2, string2, 8, (short)3);
    }

    public boolean setSoftKeys(String string, int n, String string2, int n2) {
        return this.setSoftKeys(string, n, (short)2, string2, n2, (short)3);
    }

    public boolean setSoftKeys(String string, short s, String string2, short s2) {
        return this.setSoftKeys(string, 1, s, string2, 8, s2);
    }

    public boolean setSoftKeys(String string, int n, short s, String string2, int n2, short s2) {
        String string3 = string;
        String string4 = string2;
        return this.setSoftKeys(new Command(string3, n, (int)s), new Command(string4, n2, (int)s2));
    }

    public boolean setSoftKey(Command command, int n) {
        Command command2 = null;
        boolean bl = true;
        try {
            boolean bl2 = true;
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    command2 = this.cmdLeft;
                    bl2 = this.blnHasLeftCommand;
                    this.cmdLeft = command;
                    this.blnHasLeftCommand = command != null;
                    break;
                }
                case 2: {
                    command2 = this.cmdRight;
                    bl2 = this.blnHasRightCommand;
                    this.cmdRight = command;
                    this.blnHasRightCommand = command != null;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        command2 = null;
        System.gc();
        return bl;
    }

    public boolean setSoftKey(int n) {
        return this.setSoftKey(this.getDefaultLabel(n), this.getDefaultType(n), this.getDefaultPriority(n), n);
    }

    public boolean setSoftKey(String string, int n) {
        return this.setSoftKey(string, this.getDefaultType(n), this.getDefaultPriority(n), n);
    }

    public boolean setSoftKey(String string, int n, int n2) {
        return this.setSoftKey(string, n, this.getDefaultPriority(n2), n2);
    }

    public boolean setSoftKey(String string, short s, int n) {
        return this.setSoftKey(string, this.getDefaultType(n), s, n);
    }

    public boolean setSoftKey(String string, int n, short s, int n2) {
        return this.setSoftKey(new Command(string, n, (int)s), n2);
    }

    public void clearSoftKeys() {
        int n = 0;
        try {
            ++n;
            this.clearSoftKey(0);
            ++n;
            this.clearSoftKey(1);
            ++n;
            this.clearSoftKey(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("!!!SoftKeyManager.clearSoftKeys()[" + String.valueOf(n) + "] : Invalid position constant.");
        }
    }

    public void clearSoftKey(int n) throws IllegalArgumentException {
        boolean bl;
        Command command;
        switch (n) {
            case 0: {
                command = this.cmdMiddle;
                bl = this.blnHasMiddleCommand;
                this.cmdMiddle = null;
                this.blnHasMiddleCommand = false;
                break;
            }
            case 1: {
                command = this.cmdLeft;
                bl = this.blnHasLeftCommand;
                this.cmdLeft = null;
                this.blnHasLeftCommand = false;
                break;
            }
            case 2: {
                command = this.cmdRight;
                bl = this.blnHasRightCommand;
                this.cmdRight = null;
                this.blnHasRightCommand = false;
                break;
            }
            default: {
                throw this.getBadPositionException(n);
            }
        }
        if (bl && this.dispMyDisplay != null) {
            this.dispMyDisplay.removeCommand(command);
        }
        command = null;
        System.gc();
    }

    public Command getSoftKey(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.cmdMiddle;
            }
            case 1: {
                return this.cmdLeft;
            }
            case 2: {
                return this.cmdRight;
            }
        }
        throw this.getBadPositionException(n);
    }

    public String getDefaultLabel(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return " ";
            }
            case 1: {
                return STR_STD_LEFT_LABEL;
            }
            case 2: {
                return STR_STD_RIGHT_LABEL;
            }
        }
        throw this.getBadPositionException(n);
    }

    public int getDefaultType(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 8;
            }
        }
        throw this.getBadPositionException(n);
    }

    public short getDefaultPriority(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        throw this.getBadPositionException(n);
    }

    private int getCommandWidth(int n) throws IllegalArgumentException {
        try {
            String string;
            switch (n) {
                case 0: {
                    string = this.cmdMiddle.getLabel();
                    break;
                }
                case 1: {
                    string = this.cmdLeft.getLabel();
                    break;
                }
                case 2: {
                    string = this.cmdRight.getLabel();
                    break;
                }
                default: {
                    throw this.getBadPositionException(n);
                }
            }
            return this.fntLabelFont.charsWidth(string.toCharArray(), 0, string.length());
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    private int validateColor(int n) {
        if (n > 0xFFFFFF) {
            n = 0xFFFFFF;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private IllegalArgumentException getBadPositionException(int n) {
        return new IllegalArgumentException("The position '" + String.valueOf(n) + "' is not valid.\n" + "Valid positions lie within the range of 0 to " + String.valueOf(3) + ".\n" + "Using the constants prefixed with 'POSITION_' is recommended.");
    }
}

