/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.K;
import com.magmic.MagmicFileIO;
import com.magmic.MagmicGame;
import com.magmic.MagmicIO;
import java.io.IOException;

public class Score {
    public static final int BYTES_PER_LEVEL = 11;
    public static final int OFFSET_SCORE = 0;
    public static final int OFFSET_AVG = 4;
    public static final int OFFSET_TIKI_AND_BONUS = 5;
    public static final int OFFSET_TIME = 7;
    public static final int MASK_TIKI = Short.MAX_VALUE;
    public static final int MASK_BONUS = 32768;
    public byte[] data;
    MagmicIO io;

    public Score() {
        this.io = MagmicGame.maglet.io;
        this.data = new byte[K.numberOfLevel * K.modeCount * 11];
    }

    public boolean save(MagmicFileIO magmicFileIO, int n) {
        try {
            magmicFileIO.save(n, this.data, 0, K.numberOfLevel * K.modeCount * 11);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean load(MagmicFileIO magmicFileIO, int n) {
        int n2 = magmicFileIO.load(n, this.data, 0);
        if (n2 != K.numberOfLevel * K.modeCount * 11) {
            this.reset();
            return false;
        }
        return true;
    }

    public void reset() {
        for (int i = 0; i < K.numberOfLevel * K.modeCount * 11; ++i) {
            this.data[i] = 0;
        }
    }

    public long getScore(int n, int n2) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 0);
        return this.io.read_u32();
    }

    public int getAverage(int n, int n2) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 4);
        return this.io.read_u8();
    }

    public int getTiki(int n, int n2) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 5);
        return this.io.read_u16() & Short.MAX_VALUE;
    }

    public boolean foundBonusWord(int n, int n2) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 5);
        return (this.io.read_u32() & 0x8000L) != 0L;
    }

    public long getTime(int n, int n2) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 7);
        return this.io.read_u32();
    }

    public void setScore(int n, int n2, long l) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 0);
        this.io.write_u32(l);
    }

    public void setAverage(int n, int n2, int n3) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 4);
        this.io.write_u8((short)n3);
    }

    public void setTiki(int n, int n2, int n3) {
        boolean bl = this.foundBonusWord(n, n2);
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 5);
        this.io.write_u16(n3 | (bl ? 32768 : 0));
    }

    public void setFoundBonusWord(int n, int n2, boolean bl) {
        int n3 = this.getTiki(n, n2);
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 5);
        this.io.write_u16(n3 | (bl ? 32768 : 0));
    }

    public void setTime(int n, int n2, long l) {
        this.io.bind(this.data, 0, this.data.length);
        this.io.set_pointer((n + K.numberOfLevel * n2) * 11 + 7);
        this.io.write_u32(l);
    }

    public boolean isCompleted(int n, int n2) {
        return this.getScore(n, n2) > 0L;
    }

    public int getCompletedCount() {
        int n = 0;
        for (int i = 0; i < K.modeCount; ++i) {
            for (int j = 0; j < K.numberOfLevel; ++j) {
                if (!this.isCompleted(j, i)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getPercentCompleted() {
        return this.getCompletedCount() * 100 / (K.numberOfLevel * K.modeCount);
    }

    public int getFurthestLevelCompleted(int n) {
        for (int i = K.numberOfLevel - 1; i >= 0; --i) {
            if (!this.isCompleted(i, n)) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfFreedFishes() {
        return this.getPercentCompleted() * (K.numberOfFish - 2) / 100 + 2;
    }

    public int getNumberOfLevelTillFreeingNextFish() {
        int n;
        int n2 = this.getCompletedCount();
        if (n2 == K.numberOfLevel * K.modeCount) {
            return 0;
        }
        int n3 = 0;
        int n4 = n = n2 * 100 / (K.numberOfLevel * K.modeCount) * (K.numberOfFish - 2) / 100 + 2;
        while (n4 == n) {
            n4 = ++n2 * 100 / (K.numberOfLevel * K.modeCount) * (K.numberOfFish - 2) / 100 + 2;
            ++n3;
        }
        return n3;
    }

    public int getTotalScore(int n) {
        int n2 = 0;
        for (int i = 0; i < K.numberOfLevel; ++i) {
            n2 = (int)((long)n2 + this.getScore(i, n));
        }
        return n2;
    }

    public int getTotalAvg(int n) {
        int n2 = 0;
        for (int i = 0; i < K.numberOfLevel; ++i) {
            n2 += this.getAverage(i, n);
        }
        return n2 / K.numberOfLevel;
    }
}

